/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_optitems.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:38:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

// -----------------------------------------------------------------------

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _TOOLS_RESID_HXX //autogen
#include <tools/resid.hxx>
#endif
#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

#ifndef _COM_SUN_STAR_LINGUISTIC2_XSPELLCHECKER1_HPP_
#include <com/sun/star/linguistic2/XSpellChecker1.hpp>
#endif

#define ITEMID_SPELLCHECK	0
#define ITEMID_HYPHENREGION	0

#include "optitems.hxx"
#include "dialmgr.hxx"
#include "svxitems.hrc"
namespace binfilter {

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::linguistic2;

// STATIC DATA -----------------------------------------------------------

//STRIP001 TYPEINIT1(SfxSpellCheckItem, SfxPoolItem);
//STRIP001 TYPEINIT1(SfxHyphenRegionItem, SfxPoolItem);

// class SfxSpellCheckItem -----------------------------------------------

//STRIP001 SfxSpellCheckItem::SfxSpellCheckItem
//STRIP001 (
//STRIP001 	Reference< XSpellChecker1 > &xChecker,
//STRIP001 	sal_uInt16 nWhich
//STRIP001 ) :
//STRIP001 
//STRIP001 	SfxPoolItem( nWhich )
//STRIP001 {
//STRIP001 	xSpellCheck = xChecker;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxSpellCheckItem::SfxSpellCheckItem( const SfxSpellCheckItem& rItem ) :
//STRIP001 
//STRIP001 	SfxPoolItem( rItem ),
//STRIP001 	xSpellCheck( rItem.GetXSpellChecker() )
//STRIP001 {
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 SfxItemPresentation SfxSpellCheckItem::GetPresentation
//STRIP001 (
//STRIP001 	SfxItemPresentation	ePres,
//STRIP001 	SfxMapUnit			eCoreUnit,
//STRIP001 	SfxMapUnit			ePresUnit,
//STRIP001 	String&				rText,
//STRIP001     const IntlWrapper*
//STRIP001 )	const
//STRIP001 {
//STRIP001 	switch ( ePres )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_PRESENTATION_NONE:
//STRIP001 			rText.Erase();
//STRIP001 			return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 
//STRIP001 		case SFX_ITEM_PRESENTATION_NAMELESS:
//STRIP001 		case SFX_ITEM_PRESENTATION_COMPLETE:
//STRIP001 		{
//STRIP001 			return ePres;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxPoolItem* SfxSpellCheckItem::Clone( SfxItemPool* ) const
//STRIP001 {
//STRIP001 	return new SfxSpellCheckItem( *this );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 int SfxSpellCheckItem::operator==( const SfxPoolItem& rItem ) const
//STRIP001 {
//STRIP001 	DBG_ASSERT( SfxPoolItem::operator==(rItem), "unequal types" );
//STRIP001 	return ( xSpellCheck == ( (const SfxSpellCheckItem& )rItem ).GetXSpellChecker() );
//STRIP001 }

// class SfxHyphenRegionItem -----------------------------------------------

//STRIP001 SfxHyphenRegionItem::SfxHyphenRegionItem( const sal_uInt16 nId ) :
//STRIP001 
//STRIP001 	SfxPoolItem( nId )
//STRIP001 {
//STRIP001 	nMinLead = nMinTrail = 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxHyphenRegionItem::SfxHyphenRegionItem( const SfxHyphenRegionItem& rItem ) :
//STRIP001 
//STRIP001 	SfxPoolItem	( rItem ),
//STRIP001 
//STRIP001 	nMinLead	( rItem.GetMinLead() ),
//STRIP001 	nMinTrail	( rItem.GetMinTrail() )
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 int SfxHyphenRegionItem::operator==( const SfxPoolItem& rAttr ) const
//STRIP001 {
//STRIP001 	DBG_ASSERT( SfxPoolItem::operator==(rAttr), "unequal types" );
//STRIP001 
//STRIP001 	return ( ( ( (SfxHyphenRegionItem&)rAttr ).nMinLead == nMinLead ) &&
//STRIP001 			 ( ( (SfxHyphenRegionItem&)rAttr ).nMinTrail == nMinTrail ) );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxPoolItem* SfxHyphenRegionItem::Clone( SfxItemPool* ) const
//STRIP001 {
//STRIP001 	return new SfxHyphenRegionItem( *this );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 SfxItemPresentation SfxHyphenRegionItem::GetPresentation
//STRIP001 (
//STRIP001 	SfxItemPresentation ePres,
//STRIP001 	SfxMapUnit			eCoreUnit,
//STRIP001 	SfxMapUnit			ePresUnit,
//STRIP001 	String&				rText,
//STRIP001     const IntlWrapper*
//STRIP001 )	const
//STRIP001 {
//STRIP001 	switch ( ePres )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_PRESENTATION_NONE:
//STRIP001 			rText.Erase();
//STRIP001 			return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 
//STRIP001 		case SFX_ITEM_PRESENTATION_NAMELESS:
//STRIP001 		case SFX_ITEM_PRESENTATION_COMPLETE:
//STRIP001 		{
//STRIP001 			rText += String::CreateFromInt32( nMinLead );
//STRIP001 			rText += String( ResId( RID_SVXITEMS_HYPHEN_MINLEAD, DIALOG_MGR() ) );
//STRIP001 			rText += ',';
//STRIP001 			rText += String::CreateFromInt32( nMinTrail );
//STRIP001 			rText += String( ResId( RID_SVXITEMS_HYPHEN_MINTRAIL, DIALOG_MGR() ) );
//STRIP001 			return ePres;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxPoolItem* SfxHyphenRegionItem::Create(SvStream& rStrm, sal_uInt16 ) const
//STRIP001 {
//STRIP001 	sal_uInt8 nMinLead, nMinTrail;
//STRIP001 	rStrm >> nMinLead >> nMinTrail;
//STRIP001 	SfxHyphenRegionItem* pAttr = new SfxHyphenRegionItem( Which() );
//STRIP001 	pAttr->GetMinLead() = nMinLead;
//STRIP001 	pAttr->GetMinTrail() = nMinTrail;
//STRIP001 	return pAttr;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SvStream& SfxHyphenRegionItem::Store( SvStream& rStrm, sal_uInt16 ) const
//STRIP001 {
//STRIP001 	rStrm << (sal_uInt8) GetMinLead()
//STRIP001 		  << (sal_uInt8) GetMinTrail();
//STRIP001 	return rStrm;
//STRIP001 }


}
