/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_dragmt3d.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:30:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {

// MIB 6.11.97: Die Reihenfolge der Includes mag verwundern, aber in dieser
// Reihenfolge geht das durch den SCO GCC, in anderen nicht. Also bitte nicht
// an der Reihenfolge drehen, wenn es nicht noetig ist. Das gleiche gilt
// natuerlich auch fuer das hinzufuegen von Includes. Danke.

//STRIP001 #ifndef _SHL_HXX //autogen
//STRIP001 #include <tools/shl.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SVDPAGV_HXX //autogen
//STRIP001 #include "svdpagv.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SVX_DIALMGR_HXX //autogen
//STRIP001 #include <dialmgr.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _XOUTX_HXX //autogen
//STRIP001 #include <xoutx.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SVDDRGMT_HXX //autogen
//STRIP001 #include <svddrgmt.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SVDTRANS_HXX
//STRIP001 #include "svdtrans.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _POLY3D_HXX
//STRIP001 #include "poly3d.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SVX_MATRIX3D_HXX
//STRIP001 #include "matrix3d.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _E3D_OBJ3D_HXX
//STRIP001 #include "obj3d.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _E3D_POLYSC3D_HXX
//STRIP001 #include "polysc3d.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _E3D_UNDO_HXX
//STRIP001 #include "e3dundo.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _E3D_DRAGMT3D_HXX
//STRIP001 #include "dragmt3d.hxx"
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SVX_DIALOGS_HRC
//STRIP001 #include "dialogs.hrc"
//STRIP001 #endif

//STRIP001 TYPEINIT1(E3dDragMethod, SdrDragMethod);
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Parameter fuer Interaktion eines 3D-Objektes
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SV_IMPL_PTRARR(E3dDragMethodUnitGroup, E3dDragMethodUnit*);
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Timing-Qualitaeten
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 #define	E3D_GOOD_TIME				Time(0,0)
//STRIP001 #define	E3D_BAD_TIME				Time(0,0,1)
//STRIP001 #define	E3D_WANTED_TIME				Time(0,0,0,25)
//STRIP001 #define E3D_WAITTIME_TIL_REDRAW		(5)
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Konstruktor aller 3D-DragMethoden
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 E3dDragMethod::E3dDragMethod (
//STRIP001 	SdrDragView &rView,
//STRIP001 	const SdrMarkList& rMark,
//STRIP001 	E3dDragDetail eDetail,
//STRIP001 	E3dDragConstraint eConstr,
//STRIP001 	BOOL bFull)
//STRIP001 :	SdrDragMethod(rView),
//STRIP001 	eConstraint(eConstr),
//STRIP001 	eDragDetail(eDetail),
//STRIP001 	bMoveFull(bFull),
//STRIP001 	bMovedAtAll(FALSE)
//STRIP001 {
//STRIP001 	// Fuer alle in der selektion befindlichen 3D-Objekte
//STRIP001 	// eine Unit anlegen
//STRIP001 	long nCnt = rMark.GetMarkCount();
//STRIP001 	for(long nObjs = 0;nObjs < nCnt;nObjs++)
//STRIP001 	{
//STRIP001 		SdrObject *pObj = rMark.GetMark(nObjs)->GetObj();
//STRIP001 		if(pObj && pObj->ISA(E3dObject))
//STRIP001 		{
//STRIP001 			E3dObject* p3DObj = (E3dObject*)pObj;
//STRIP001 			E3dDragMethodUnit* pNewUnit = new E3dDragMethodUnit;
//STRIP001 			DBG_ASSERT(pNewUnit, "AW: Kein Speicher");
//STRIP001 
//STRIP001 			// Neue Unit einrichten
//STRIP001 			pNewUnit->p3DObj = p3DObj;
//STRIP001 
//STRIP001 			// Transformationen holen
//STRIP001 			pNewUnit->aInitTransform = pNewUnit->aTransform = p3DObj->GetTransform();
//STRIP001 			if(p3DObj->GetParentObj())
//STRIP001 				pNewUnit->aDisplayTransform = p3DObj->GetParentObj()->GetFullTransform();
//STRIP001 			pNewUnit->aInvDisplayTransform = pNewUnit->aDisplayTransform;
//STRIP001 			pNewUnit->aInvDisplayTransform.Invert();
//STRIP001 
//STRIP001 			// SnapRects der beteiligten Objekte invalidieren, um eine
//STRIP001 			// Neuberechnung beim Setzen der Marker zu erzwingen
//STRIP001 			p3DObj->SetRectsDirty();
//STRIP001 
//STRIP001 			if(bMoveFull)
//STRIP001 			{
//STRIP001 				// Timings merken
//STRIP001 				pNewUnit->nOrigQuality = p3DObj->GetScene()->GetDisplayQuality();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// Drahtgitterdarstellung fuer Parent-Koodinaten erzeugen
//STRIP001 				pNewUnit->aWireframePoly.SetPointCount(0);
//STRIP001 				p3DObj->CreateWireframe(pNewUnit->aWireframePoly, NULL, eDragDetail);
//STRIP001 				pNewUnit->aWireframePoly.Transform(pNewUnit->aTransform);
//STRIP001 			}
//STRIP001 
//STRIP001 			// FullBound ermitteln
//STRIP001 			aFullBound.Union(p3DObj->GetSnapRect());
//STRIP001 
//STRIP001 			// Unit einfuegen
//STRIP001 			aGrp.Insert((const E3dDragMethodUnit*&)pNewUnit, aGrp.Count());
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Link auf den Timer setzen
//STRIP001 	aCallbackTimer.SetTimeoutHdl( LINK( this, E3dDragMethod, TimerInterruptHdl) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK(E3dDragMethod, TimerInterruptHdl, void*, EMPTYARG)
//STRIP001 {
//STRIP001 	// Alle beteiligten Szenen neu zeichnen
//STRIP001 	UINT16 nCnt = aGrp.Count();
//STRIP001 	E3dScene* pScene = NULL;
//STRIP001 	UINT32 nNewTime(0);
//STRIP001 
//STRIP001 	for(UINT16 nOb=0;nOb<nCnt;nOb++)
//STRIP001 	{
//STRIP001 		if(aGrp[nOb]->p3DObj->GetScene() != pScene)
//STRIP001 		{
//STRIP001 			pScene = aGrp[nOb]->p3DObj->GetScene();
//STRIP001 			INT32 nOldQual = pScene->GetDisplayQuality();
//STRIP001 			if(nOldQual != 255)
//STRIP001 			{
//STRIP001 				if(nOldQual == 0)
//STRIP001 					nOldQual = 30;
//STRIP001 				else if(nOldQual <= 64)
//STRIP001 					nOldQual = 64;
//STRIP001 				else
//STRIP001 					nOldQual = 255;
//STRIP001 
//STRIP001 				pScene->SetDisplayQuality((UINT8)nOldQual);
//STRIP001 				pScene->SendRepaintBroadcast();
//STRIP001 
//STRIP001 				if(nOldQual != 255)
//STRIP001 				{
//STRIP001 					Time aLast = pScene->GetLastPaintTime();
//STRIP001 					if(nOldQual == 30)
//STRIP001 						nNewTime = aLast.GetTime() * (50 * E3D_WAITTIME_TIL_REDRAW);
//STRIP001 					else
//STRIP001 						nNewTime = aLast.GetTime() * (200 * E3D_WAITTIME_TIL_REDRAW);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if(nNewTime)
//STRIP001 	{
//STRIP001 		// Timer reset
//STRIP001 		aCallbackTimer.SetTimeout(nNewTime);
//STRIP001 		aCallbackTimer.Start();
//STRIP001 	}
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void E3dDragMethod::TakeComment(XubString& rStr) const
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Erstelle das Drahtgittermodel fuer alle Aktionen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 FASTBOOL E3dDragMethod::Beg()
//STRIP001 {
//STRIP001 	if(eConstraint == E3DDRAG_CONSTR_Z)
//STRIP001 	{
//STRIP001 		UINT16 nCnt = aGrp.Count();
//STRIP001 		DragStat().Ref1() = aFullBound.Center();
//STRIP001 		for(UINT16 nOb=0;nOb<nCnt;nOb++)
//STRIP001 		{
//STRIP001 			aGrp[nOb]->nStartAngle = GetAngle(DragStat().GetStart() - DragStat().GetRef1());
//STRIP001 			aGrp[nOb]->nLastAngle = 0;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aLastPos = DragStat().GetStart();
//STRIP001 	}
//STRIP001 
//STRIP001 	if(!bMoveFull)
//STRIP001 	{
//STRIP001 		Show();
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Schluss
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 FASTBOOL E3dDragMethod::End(FASTBOOL bCopy)
//STRIP001 {
//STRIP001 	UINT16 nCnt = aGrp.Count();
//STRIP001 
//STRIP001 	if(bMoveFull)
//STRIP001 	{
//STRIP001 		// Timer stoppen
//STRIP001 		aCallbackTimer.Stop();
//STRIP001 
//STRIP001 		if(bMovedAtAll)
//STRIP001 		{
//STRIP001 			// Original-Qualitaet restaurieren
//STRIP001 			for(UINT16 nOb=0;nOb<nCnt;nOb++)
//STRIP001 				aGrp[nOb]->p3DObj->GetScene()->SetDisplayQuality(aGrp[nOb]->nOrigQuality);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// WireFrame ausblenden
//STRIP001 		Hide();
//STRIP001 	}
//STRIP001 
//STRIP001 	// Alle Transformationen anwenden und UnDo's anlegen
//STRIP001 	if(bMovedAtAll)
//STRIP001 	{
//STRIP001 		rView.BegUndo(SVX_RESSTR(RID_SVX_3D_UNDO_ROTATE));
//STRIP001 		UINT16 nOb;
//STRIP001 		for(nOb=0;nOb<nCnt;nOb++)
//STRIP001 		{
//STRIP001 			aGrp[nOb]->p3DObj->SetTransform(aGrp[nOb]->aTransform);
//STRIP001 			rView.AddUndo(new E3dRotateUndoAction(aGrp[nOb]->p3DObj->GetModel(),
//STRIP001 				aGrp[nOb]->p3DObj, aGrp[nOb]->aInitTransform,
//STRIP001 				aGrp[nOb]->aTransform));
//STRIP001 		}
//STRIP001 		rView.EndUndo();
//STRIP001 
//STRIP001 		// An allen beteiligten Szenen SnapRect neu setzen und
//STRIP001 		// BoundVolume der Kamera neu bestimmen, da sich die Geometrie
//STRIP001 		// tatsaechlich geaendert haben kann
//STRIP001 		E3dScene* pScene = NULL;
//STRIP001 		for(nOb=0;nOb<nCnt;nOb++)
//STRIP001 		{
//STRIP001 			if(aGrp[nOb]->p3DObj->GetScene() != pScene)
//STRIP001 			{
//STRIP001 				pScene = aGrp[nOb]->p3DObj->GetScene();
//STRIP001 				pScene->CorrectSceneDimensions();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Abbruch
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void E3dDragMethod::Brk()
//STRIP001 {
//STRIP001 	if(bMoveFull)
//STRIP001 	{
//STRIP001 		// Timer stoppen
//STRIP001 		aCallbackTimer.Stop();
//STRIP001 
//STRIP001 		if(bMovedAtAll)
//STRIP001 		{
//STRIP001 			UINT16 nCnt = aGrp.Count();
//STRIP001 			for(UINT16 nOb=0;nOb<nCnt;nOb++)
//STRIP001 			{
//STRIP001 				// Transformation restaurieren
//STRIP001 				aGrp[nOb]->p3DObj->SetTransform(aGrp[nOb]->aInitTransform);
//STRIP001 				aGrp[nOb]->p3DObj->GetScene()->FitSnapRectToBoundVol();
//STRIP001 
//STRIP001 				// Original-Qualitaet restaurieren
//STRIP001 				aGrp[nOb]->p3DObj->GetScene()->SetDisplayQuality(aGrp[nOb]->nOrigQuality);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// WireFrame ausblenden
//STRIP001 		Hide();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Gemeinsames Mov()
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void E3dDragMethod::Mov(const Point& rPnt)
//STRIP001 {
//STRIP001 	bMovedAtAll = TRUE;
//STRIP001 	if(bMoveFull)
//STRIP001 	{
//STRIP001 		UINT32 nNewTime = 0L;
//STRIP001 
//STRIP001 		// Darstellungsqualitaet bestimmen
//STRIP001 		UINT16 nCnt = aGrp.Count();
//STRIP001 		for(UINT16 nOb=0;nOb<nCnt;nOb++)
//STRIP001 		{
//STRIP001 			E3dScene* pScene = aGrp[nOb]->p3DObj->GetScene();
//STRIP001 			if(pScene)
//STRIP001 			{
//STRIP001 				Time aLast = pScene->GetLastPaintTime();
//STRIP001 				if(aLast.GetTime())
//STRIP001 				{
//STRIP001 					INT32 nActQual = pScene->GetDisplayQuality();
//STRIP001 
//STRIP001 					// nur weiter ueberlegen, wenn die Qualitaet ueber null liegt
//STRIP001 					if(nActQual)
//STRIP001 					{
//STRIP001 						INT32 nNewQual = nActQual + (E3D_WANTED_TIME.GetTime() - aLast.GetTime());
//STRIP001 						if(nNewQual < 0L)
//STRIP001 							nNewQual = 0L;
//STRIP001 						if(nNewQual > 255L)
//STRIP001 							nNewQual = 255L;
//STRIP001 						pScene->SetDisplayQuality((UINT8)nNewQual);
//STRIP001 					}
//STRIP001 				}
//STRIP001 				UINT32 nTime = aLast.GetTime() * (25 * E3D_WAITTIME_TIL_REDRAW);
//STRIP001 				nNewTime = (nTime > nNewTime) ? nTime : nNewTime;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// Timer reset
//STRIP001 		aCallbackTimer.SetTimeout(nNewTime);
//STRIP001 		aCallbackTimer.Start();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Zeichne das Drahtgittermodel
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void E3dDragMethod::DrawXor(ExtOutputDevice& rXOut, FASTBOOL bFull) const
//STRIP001 {
//STRIP001 	UINT16 nPVCnt = rView.GetPageViewCount();
//STRIP001 	XPolygon aLine(2);
//STRIP001 	UINT16 nCnt = aGrp.Count();
//STRIP001 
//STRIP001 	for(UINT16 nOb=0;nOb<nCnt;nOb++)
//STRIP001 	{
//STRIP001 		B3dCamera& rCameraSet = aGrp[nOb]->p3DObj->GetScene()->GetCameraSet();
//STRIP001 		for (UINT16 a=0;a<nPVCnt;a++)
//STRIP001 		{
//STRIP001 			SdrPageView* pPV = rView.GetPageViewPvNum(a);
//STRIP001 			if(pPV->HasMarkedObj())
//STRIP001 			{
//STRIP001 				rXOut.SetOffset(pPV->GetOffset());
//STRIP001 				UINT16 nPntCnt = aGrp[nOb]->aWireframePoly.GetPointCount();
//STRIP001 				if(nPntCnt > 1)
//STRIP001 				{
//STRIP001 					for(UINT16 b=0;b < nPntCnt;b += 2)
//STRIP001 					{
//STRIP001 						Vector3D aPnt1 = aGrp[nOb]->aDisplayTransform * aGrp[nOb]->aWireframePoly[b];
//STRIP001 						aPnt1 = rCameraSet.WorldToViewCoor(aPnt1);
//STRIP001 						aLine[0].X() = (long)(aPnt1.X() + 0.5);
//STRIP001 						aLine[0].Y() = (long)(aPnt1.Y() + 0.5);
//STRIP001 
//STRIP001 						Vector3D aPnt2 = aGrp[nOb]->aDisplayTransform * aGrp[nOb]->aWireframePoly[b+1];
//STRIP001 						aPnt2 = rCameraSet.WorldToViewCoor(aPnt2);
//STRIP001 						aLine[1].X() = (long)(aPnt2.X() + 0.5);
//STRIP001 						aLine[1].Y() = (long)(aPnt2.Y() + 0.5);
//STRIP001 
//STRIP001 						rXOut.DrawXPolyLine(aLine);
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 
//STRIP001 								E3dDragRotate
//STRIP001 
//STRIP001 *************************************************************************/
//STRIP001 
//STRIP001 TYPEINIT1(E3dDragRotate, E3dDragMethod);
//STRIP001 
//STRIP001 E3dDragRotate::E3dDragRotate(SdrDragView &rView,
//STRIP001 	const SdrMarkList& rMark,
//STRIP001 	E3dDragDetail eDetail,
//STRIP001 	E3dDragConstraint eConstr,
//STRIP001 	BOOL bFull)
//STRIP001 :	E3dDragMethod(rView, rMark, eDetail, eConstr, bFull)
//STRIP001 {
//STRIP001 	// Zentrum aller selektierten Objekte in Augkoordinaten holen
//STRIP001 	UINT16 nCnt = aGrp.Count();
//STRIP001 	E3dScene *pScene = NULL;
//STRIP001 
//STRIP001 	for(UINT16 nOb=0;nOb<nCnt;nOb++)
//STRIP001 	{
//STRIP001 		Vector3D aObjCenter = aGrp[nOb]->p3DObj->GetCenter();
//STRIP001 		B3dCamera& rCameraSet = aGrp[nOb]->p3DObj->GetScene()->GetCameraSet();
//STRIP001 		aObjCenter *= aGrp[nOb]->aInitTransform;
//STRIP001 		aObjCenter *= aGrp[nOb]->aDisplayTransform;
//STRIP001 		aObjCenter = rCameraSet.WorldToEyeCoor(aObjCenter);
//STRIP001 		aGlobalCenter += aObjCenter;
//STRIP001 
//STRIP001 		if(aGrp[nOb]->p3DObj->ISA(E3dScene))
//STRIP001 			pScene = (E3dScene*)aGrp[nOb]->p3DObj;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Teilen durch Anzahl
//STRIP001 	if(nCnt > 1)
//STRIP001 		aGlobalCenter /= (double)nCnt;
//STRIP001 
//STRIP001 	// Gruppe schon gesetzt? Sonst gruppe irgendeines Objektes
//STRIP001 	// (erstes) holen
//STRIP001 	if(!pScene && nCnt)
//STRIP001 	{
//STRIP001 		if(aGrp[0]->p3DObj)
//STRIP001 			pScene = aGrp[0]->p3DObj->GetScene();
//STRIP001 	}
//STRIP001 
//STRIP001 	if(pScene)
//STRIP001 	{
//STRIP001 		// 2D-Koordinaten des Controls Rotationszentrum holen
//STRIP001 		Point aRotCenter2D = Ref1();
//STRIP001 
//STRIP001 		// In Augkoordinaten transformieren
//STRIP001 		Vector3D aRotCenter(aRotCenter2D.X(), aRotCenter2D.Y(), 0.0);
//STRIP001 		aRotCenter = pScene->GetCameraSet().ViewToEyeCoor(aRotCenter);
//STRIP001 
//STRIP001 		// X,Y des RotCenter und Tiefe der gemeinsamen Objektmitte aus
//STRIP001 		// Rotationspunkt im Raum benutzen
//STRIP001 		aGlobalCenter.X() = aRotCenter.X();
//STRIP001 		aGlobalCenter.Y() = aRotCenter.Y();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Das Objekt wird bewegt, bestimme die Winkel
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void E3dDragRotate::Mov(const Point& rPnt)
//STRIP001 {
//STRIP001 	// call parent
//STRIP001 	E3dDragMethod::Mov(rPnt);
//STRIP001 
//STRIP001 	if(DragStat().CheckMinMoved(rPnt))
//STRIP001 	{
//STRIP001 		// Modifier holen
//STRIP001 		UINT16 nModifier = 0;
//STRIP001 		if(rView.ISA(E3dView))
//STRIP001 		{
//STRIP001 			const MouseEvent& rLastMouse = ((E3dView&)rView).GetMouseEvent();
//STRIP001 			nModifier = rLastMouse.GetModifier();
//STRIP001 		}
//STRIP001 
//STRIP001 		// Alle Objekte rotieren
//STRIP001 		UINT16 nCnt = aGrp.Count();
//STRIP001 		for(UINT16 nOb=0;nOb<nCnt;nOb++)
//STRIP001 		{
//STRIP001 			// Rotationswinkel bestimmen
//STRIP001 			double fWAngle, fHAngle;
//STRIP001 
//STRIP001 			if(eConstraint == E3DDRAG_CONSTR_Z)
//STRIP001 			{
//STRIP001 				fWAngle = NormAngle360(GetAngle(rPnt - DragStat().GetRef1()) -
//STRIP001 					aGrp[nOb]->nStartAngle) - aGrp[nOb]->nLastAngle;
//STRIP001 				aGrp[nOb]->nLastAngle = (long)fWAngle + aGrp[nOb]->nLastAngle;
//STRIP001 				fWAngle /= 100.0;
//STRIP001 				fHAngle = 0.0;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				fWAngle = 90.0 * (double)(rPnt.X() - aLastPos.X())
//STRIP001 					/ (double)aFullBound.GetWidth();
//STRIP001 				fHAngle = 90.0 * (double)(rPnt.Y() - aLastPos.Y())
//STRIP001 					/ (double)aFullBound.GetHeight();
//STRIP001 			}
//STRIP001 			long nSnap = 0;
//STRIP001 
//STRIP001 			if(!rView.IsRotateAllowed(FALSE))
//STRIP001 				nSnap = 90;
//STRIP001 
//STRIP001 			if(nSnap != 0)
//STRIP001 			{
//STRIP001 				fWAngle = (double)(((long) fWAngle + nSnap/2) / nSnap * nSnap);
//STRIP001 				fHAngle = (double)(((long) fHAngle + nSnap/2) / nSnap * nSnap);
//STRIP001 			}
//STRIP001 
//STRIP001 			// nach radiant
//STRIP001 			fWAngle *= F_PI180;
//STRIP001 			fHAngle *= F_PI180;
//STRIP001 
//STRIP001 			// Transformation bestimmen
//STRIP001 			Matrix4D aRotMat;
//STRIP001 			if(eConstraint & E3DDRAG_CONSTR_Y)
//STRIP001 			{
//STRIP001 				if(nModifier & KEY_MOD2)
//STRIP001 					aRotMat.RotateZ(fWAngle);
//STRIP001 				else
//STRIP001 					aRotMat.RotateY(fWAngle);
//STRIP001 			}
//STRIP001 			else if(eConstraint & E3DDRAG_CONSTR_Z)
//STRIP001 			{
//STRIP001 				if(nModifier & KEY_MOD2)
//STRIP001 					aRotMat.RotateY(fWAngle);
//STRIP001 				else
//STRIP001 					aRotMat.RotateZ(fWAngle);
//STRIP001 			}
//STRIP001 			if(eConstraint & E3DDRAG_CONSTR_X)
//STRIP001 			{
//STRIP001 				aRotMat.RotateX(fHAngle);
//STRIP001 			}
//STRIP001 
//STRIP001 			// Transformation in Eye-Koordinaten, dort rotieren
//STRIP001 			// und zurueck
//STRIP001 			B3dCamera& rCameraSet = aGrp[nOb]->p3DObj->GetScene()->GetCameraSet();
//STRIP001 			Matrix4D aTransMat = aGrp[nOb]->aDisplayTransform;
//STRIP001 			aTransMat *= rCameraSet.GetOrientation();
//STRIP001 			aTransMat.Translate(-aGlobalCenter);
//STRIP001 			aTransMat *= aRotMat;
//STRIP001 			aTransMat.Translate(aGlobalCenter);
//STRIP001 			aTransMat *= rCameraSet.GetInvOrientation();
//STRIP001 			aTransMat *= aGrp[nOb]->aInvDisplayTransform;
//STRIP001 
//STRIP001 			// ...und anwenden
//STRIP001 			aGrp[nOb]->aTransform *= aTransMat;
//STRIP001 			if(bMoveFull)
//STRIP001 			{
//STRIP001 				aGrp[nOb]->p3DObj->NbcSetTransform(aGrp[nOb]->aTransform);
//STRIP001 				aGrp[nOb]->p3DObj->GetScene()->FitSnapRectToBoundVol();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				Hide();
//STRIP001 				aGrp[nOb]->aWireframePoly.Transform(aTransMat);
//STRIP001 				Show();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		aLastPos = rPnt;
//STRIP001 		DragStat().NextMove(rPnt);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 Pointer E3dDragRotate::GetPointer() const
//STRIP001 {
//STRIP001 	return Pointer(POINTER_ROTATE);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* E3dDragMove
//STRIP001 |* Diese DragMethod wird nur bei Translationen innerhalb von 3D-Scenen
//STRIP001 |* benoetigt. Wird eine 3D-Scene selbst verschoben, so wird diese DragMethod
//STRIP001 |* nicht verwendet.
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 TYPEINIT1(E3dDragMove, E3dDragMethod);
//STRIP001 
//STRIP001 E3dDragMove::E3dDragMove(SdrDragView &rView,
//STRIP001 	const SdrMarkList& rMark,
//STRIP001 	E3dDragDetail eDetail,
//STRIP001 	SdrHdlKind eDrgHdl,
//STRIP001 	E3dDragConstraint eConstr,
//STRIP001 	BOOL bFull)
//STRIP001 :	E3dDragMethod(rView, rMark, eDetail, eConstr, bFull),
//STRIP001 	eWhatDragHdl(eDrgHdl)
//STRIP001 {
//STRIP001 	switch(eWhatDragHdl)
//STRIP001 	{
//STRIP001 		case HDL_LEFT:
//STRIP001 			aScaleFixPos = aFullBound.RightCenter();
//STRIP001 			break;
//STRIP001 		case HDL_RIGHT:
//STRIP001 			aScaleFixPos = aFullBound.LeftCenter();
//STRIP001 			break;
//STRIP001 		case HDL_UPPER:
//STRIP001 			aScaleFixPos = aFullBound.BottomCenter();
//STRIP001 			break;
//STRIP001 		case HDL_LOWER:
//STRIP001 			aScaleFixPos = aFullBound.TopCenter();
//STRIP001 			break;
//STRIP001 		case HDL_UPLFT:
//STRIP001 			aScaleFixPos = aFullBound.BottomRight();
//STRIP001 			break;
//STRIP001 		case HDL_UPRGT:
//STRIP001 			aScaleFixPos = aFullBound.BottomLeft();
//STRIP001 			break;
//STRIP001 		case HDL_LWLFT:
//STRIP001 			aScaleFixPos = aFullBound.TopRight();
//STRIP001 			break;
//STRIP001 		case HDL_LWRGT:
//STRIP001 			aScaleFixPos = aFullBound.TopLeft();
//STRIP001 			break;
//STRIP001 		default:
//STRIP001 			// Bewegen des Objektes, HDL_MOVE
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Override wenn IsResizeAtCenter()
//STRIP001 	if(rView.IsResizeAtCenter())
//STRIP001 	{
//STRIP001 		eWhatDragHdl = HDL_USER;
//STRIP001 		aScaleFixPos = aFullBound.Center();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Das Objekt wird bewegt, bestimme die Translation
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void E3dDragMove::Mov(const Point& rPnt)
//STRIP001 {
//STRIP001 	// call parent
//STRIP001 	E3dDragMethod::Mov(rPnt);
//STRIP001 
//STRIP001 	if(DragStat().CheckMinMoved(rPnt))
//STRIP001 	{
//STRIP001 		if(eWhatDragHdl == HDL_MOVE)
//STRIP001 		{
//STRIP001 			// Translation
//STRIP001 			// Bewegungsvektor bestimmen
//STRIP001 			Vector3D aGlobalMoveHead((double)(rPnt.X() - aLastPos.X()),
//STRIP001 				(double)(rPnt.Y() - aLastPos.Y()), 32768.0);
//STRIP001 			Vector3D aGlobalMoveTail(0.0, 0.0, 32768.0);
//STRIP001 			UINT16 nCnt = aGrp.Count();
//STRIP001 
//STRIP001 			// Modifier holen
//STRIP001 			UINT16 nModifier = 0;
//STRIP001 			if(rView.ISA(E3dView))
//STRIP001 			{
//STRIP001 				const MouseEvent& rLastMouse = ((E3dView&)rView).GetMouseEvent();
//STRIP001 				nModifier = rLastMouse.GetModifier();
//STRIP001 			}
//STRIP001 
//STRIP001 			for(UINT16 nOb=0;nOb<nCnt;nOb++)
//STRIP001 			{
//STRIP001 				B3dCamera& rCameraSet = aGrp[nOb]->p3DObj->GetScene()->GetCameraSet();
//STRIP001 
//STRIP001 				// Bewegungsvektor von View-Koordinaten nach Aug-Koordinaten
//STRIP001 				Vector3D aMoveHead = rCameraSet.ViewToEyeCoor(aGlobalMoveHead);
//STRIP001 				Vector3D aMoveTail = rCameraSet.ViewToEyeCoor(aGlobalMoveTail);
//STRIP001 
//STRIP001 				// Eventuell Bewegung von XY-Ebene auf XZ-Ebene umschalten
//STRIP001 				if(nModifier & KEY_MOD2)
//STRIP001 				{
//STRIP001 					double fZwi = aMoveHead.Y();
//STRIP001 					aMoveHead.Y() = aMoveHead.Z();
//STRIP001 					aMoveHead.Z() = fZwi;
//STRIP001 
//STRIP001 					fZwi = aMoveTail.Y();
//STRIP001 					aMoveTail.Y() = aMoveTail.Z();
//STRIP001 					aMoveTail.Z() = fZwi;
//STRIP001 				}
//STRIP001 
//STRIP001 				// Bewegungsvektor von Aug-Koordinaten nach Parent-Koordinaten
//STRIP001 				aMoveHead = rCameraSet.EyeToWorldCoor(aMoveHead);
//STRIP001 				aMoveHead *= aGrp[nOb]->aInvDisplayTransform;
//STRIP001 				aMoveTail = rCameraSet.EyeToWorldCoor(aMoveTail);
//STRIP001 				aMoveTail *= aGrp[nOb]->aInvDisplayTransform;
//STRIP001 
//STRIP001 				// Transformation bestimmen
//STRIP001 				Matrix4D aTransMat;
//STRIP001 				aTransMat.Translate(aMoveHead - aMoveTail);
//STRIP001 
//STRIP001 				// ...und anwenden
//STRIP001 				aGrp[nOb]->aTransform *= aTransMat;
//STRIP001 				if(bMoveFull)
//STRIP001 				{
//STRIP001 					aGrp[nOb]->p3DObj->NbcSetTransform(aGrp[nOb]->aTransform);
//STRIP001 					aGrp[nOb]->p3DObj->GetScene()->FitSnapRectToBoundVol();
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					Hide();
//STRIP001 					aGrp[nOb]->aWireframePoly.Transform(aTransMat);
//STRIP001 					Show();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// Skalierung
//STRIP001 			// Skalierungsvektor bestimmen
//STRIP001 			Point aStartPos = DragStat().GetStart();
//STRIP001 			Vector3D aGlobalScaleStart((double)(aStartPos.X()), (double)(aStartPos.Y()), 32768.0);
//STRIP001 			Vector3D aGlobalScaleNext((double)(rPnt.X()), (double)(rPnt.Y()), 32768.0);
//STRIP001 			Vector3D aGlobalScaleFixPos((double)(aScaleFixPos.X()), (double)(aScaleFixPos.Y()), 32768.0);
//STRIP001 			UINT16 nCnt = aGrp.Count();
//STRIP001 
//STRIP001 			for(UINT16 nOb=0;nOb<nCnt;nOb++)
//STRIP001 			{
//STRIP001 				B3dCamera& rCameraSet = aGrp[nOb]->p3DObj->GetScene()->GetCameraSet();
//STRIP001 				Vector3D aObjectCenter = aGrp[nOb]->p3DObj->GetCenter();
//STRIP001 				aGlobalScaleStart.Z() = aObjectCenter.Z();
//STRIP001 				aGlobalScaleNext.Z() = aObjectCenter.Z();
//STRIP001 				aGlobalScaleFixPos.Z() = aObjectCenter.Z();
//STRIP001 
//STRIP001 				// Skalierungsvektor von View-Koordinaten nach Aug-Koordinaten
//STRIP001 				Vector3D aScStart = rCameraSet.ViewToEyeCoor(aGlobalScaleStart);
//STRIP001 				Vector3D aScNext = rCameraSet.ViewToEyeCoor(aGlobalScaleNext);
//STRIP001 				Vector3D aScFixPos = rCameraSet.ViewToEyeCoor(aGlobalScaleFixPos);
//STRIP001 
//STRIP001 				// Einschraenkungen?
//STRIP001 				switch(eWhatDragHdl)
//STRIP001 				{
//STRIP001 					case HDL_LEFT:
//STRIP001 					case HDL_RIGHT:
//STRIP001 						// Einschraenken auf X -> Y gleichsetzen
//STRIP001 						aScNext.Y() = aScFixPos.Y();
//STRIP001 						break;
//STRIP001 					case HDL_UPPER:
//STRIP001 					case HDL_LOWER:
//STRIP001 						// Einschraenken auf Y -> X gleichsetzen
//STRIP001 						aScNext.X() = aScFixPos.X();
//STRIP001 						break;
//STRIP001 				}
//STRIP001 
//STRIP001 				// ScaleVector in Augkoordinaten bestimmen
//STRIP001 				Vector3D aScaleVec = aScStart - aScFixPos;
//STRIP001 				aScaleVec.Z() = 1.0;
//STRIP001 
//STRIP001 				if(aScaleVec.X() != 0.0)
//STRIP001 					aScaleVec.X() = (aScNext.X() - aScFixPos.X()) / aScaleVec.X();
//STRIP001 				else
//STRIP001 					aScaleVec.X() = 1.0;
//STRIP001 
//STRIP001 				if(aScaleVec.Y() != 0.0)
//STRIP001 					aScaleVec.Y() = (aScNext.Y() - aScFixPos.Y()) / aScaleVec.Y();
//STRIP001 				else
//STRIP001 					aScaleVec.Y() = 1.0;
//STRIP001 
//STRIP001 				// Mit SHIFT-Taste?
//STRIP001 				if(rView.IsOrtho())
//STRIP001 				{
//STRIP001 					if(fabs(aScaleVec.X()) > fabs(aScaleVec.Y()))
//STRIP001 					{
//STRIP001 						// X ist am groessten
//STRIP001 						aScaleVec.Y() = aScaleVec.X();
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						// Y ist am groessten
//STRIP001 						aScaleVec.X() = aScaleVec.Y();
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				// Transformation bestimmen
//STRIP001 				Matrix4D aNewTrans = aGrp[nOb]->aInitTransform;
//STRIP001 				aNewTrans *= aGrp[nOb]->aDisplayTransform;
//STRIP001 				aNewTrans *= rCameraSet.GetOrientation();
//STRIP001 				aNewTrans.Translate(-aScFixPos);
//STRIP001 				aNewTrans.Scale(aScaleVec);
//STRIP001 				aNewTrans.Translate(aScFixPos);
//STRIP001 				aNewTrans *= rCameraSet.GetInvOrientation();
//STRIP001 				aNewTrans *= aGrp[nOb]->aInvDisplayTransform;
//STRIP001 
//STRIP001 				// ...und anwenden
//STRIP001 				aGrp[nOb]->aTransform = aNewTrans;
//STRIP001 				if(bMoveFull)
//STRIP001 				{
//STRIP001 					aGrp[nOb]->p3DObj->NbcSetTransform(aGrp[nOb]->aTransform);
//STRIP001 					aGrp[nOb]->p3DObj->GetScene()->FitSnapRectToBoundVol();
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					Hide();
//STRIP001 					aGrp[nOb]->aWireframePoly.SetPointCount(0);
//STRIP001 					aGrp[nOb]->p3DObj->CreateWireframe(aGrp[nOb]->aWireframePoly, NULL, eDragDetail);
//STRIP001 					aGrp[nOb]->aWireframePoly.Transform(aGrp[nOb]->aTransform);
//STRIP001 					Show();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		aLastPos = rPnt;
//STRIP001 		DragStat().NextMove(rPnt);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 Pointer E3dDragMove::GetPointer() const
//STRIP001 {
//STRIP001 	return Pointer(POINTER_MOVE);
//STRIP001 }


}
