/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_tplneend.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:11:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef _SFXAPP_HXX
#include <bf_sfx2/app.hxx>
#endif
#ifndef _FILEDLGHELPER_HXX
#include <bf_sfx2/filedlghelper.hxx>
#endif
#pragma hdrstop

#define _SVX_TPLNEEND_CXX

#include "dialogs.hrc"
#include "dlgname.hrc"
#include "tabline.hrc"
#include "helpid.hrc"

#define ITEMID_COLOR_TABLE		SID_COLOR_TABLE
#define ITEMID_LINEEND_LIST		SID_LINEEND_LIST

#include "svdobj.hxx"
#include "svdopath.hxx"
#include "drawitem.hxx"
#include "xpool.hxx"
#include "xtable.hxx"
#include "tabline.hxx"
#include "dlgname.hxx"
#include "dialmgr.hxx"
#include "dlgutil.hxx"
namespace binfilter {

//STRIP001 #define DLGWIN this->GetParent()->GetParent()

//STRIP001 #define BITMAP_WIDTH   32
//STRIP001 #define BITMAP_HEIGHT  12
//STRIP001 #define XOUT_WIDTH    150

/*************************************************************************
|*
|*	Dialog zum Definieren von Linienenden-Stilen
|*
\************************************************************************/

//STRIP001 SvxLineEndDefTabPage::SvxLineEndDefTabPage
//STRIP001 (
//STRIP001 	Window* pParent,
//STRIP001 	const SfxItemSet& rInAttrs
//STRIP001 ) :
//STRIP001 
//STRIP001 	SfxTabPage( pParent, SVX_RES( RID_SVXPAGE_LINEEND_DEF ), rInAttrs ),
//STRIP001 
//STRIP001 	pXPool				( (XOutdevItemPool*) rInAttrs.GetPool() ),
//STRIP001 	XOut				( &aCtlPreview ),
//STRIP001 	aXLineAttr			( pXPool ),
//STRIP001 	rXLSet				( aXLineAttr.GetItemSet() ),
//STRIP001 
//STRIP001 	aXLStyle			( XLINE_SOLID ),
//STRIP001 	aXWidth				( XOUT_WIDTH ),
//STRIP001 	aXColor				( String(), COL_BLACK ),
//STRIP001 
//STRIP001 	aFiTip			    ( this, ResId( FI_TIP ) ),
//STRIP001 	aFlTip 				( this, ResId( FL_TIP ) ),
//STRIP001 	aEdtName 		    ( this, ResId( EDT_NAME ) ),
//STRIP001 	aLbLineEnds         ( this, ResId( LB_LINEENDS ) ),
//STRIP001 	aFTLineEndStyle	    ( this, ResId( FT_LINE_END_STYLE ) ),
//STRIP001 	aFTTitle		    ( this, ResId( FT_TITLE ) ),
//STRIP001 	aBtnModify 		    ( this, ResId( BTN_MODIFY ) ),
//STRIP001 	aBtnAdd 			( this, ResId( BTN_ADD ) ),
//STRIP001 	aBtnDelete 		    ( this, ResId( BTN_DELETE ) ),
//STRIP001 	aCtlPreview         ( this, ResId( CTL_PREVIEW ), &XOut ),
//STRIP001 	aBtnLoad 		    ( this, ResId( BTN_LOAD ) ),
//STRIP001 	aBtnSave 		    ( this, ResId( BTN_SAVE ) ),
//STRIP001 	rOutAttrs		    ( rInAttrs )
//STRIP001 
//STRIP001 {
//STRIP001 	aBtnLoad.SetModeImage( Image( ResId( RID_SVXIMG_LOAD_H ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 	aBtnSave.SetModeImage( Image( ResId( RID_SVXIMG_SAVE_H ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	rXLSet.Put( aXLStyle );
//STRIP001 	rXLSet.Put( aXWidth );
//STRIP001 	rXLSet.Put( aXColor );
//STRIP001 	rXLSet.Put( XLineStartWidthItem( aCtlPreview.GetOutputSize().Height()  / 2 ) );
//STRIP001 	rXLSet.Put( XLineEndWidthItem( aCtlPreview.GetOutputSize().Height() / 2 ) );
//STRIP001 	XOut.SetLineAttr( aXLineAttr.GetItemSet() );
//STRIP001 
//STRIP001 	aBtnAdd.SetClickHdl(
//STRIP001 		LINK( this, SvxLineEndDefTabPage, ClickAddHdl_Impl ) );
//STRIP001 	aBtnModify.SetClickHdl(
//STRIP001 		LINK( this, SvxLineEndDefTabPage, ClickModifyHdl_Impl ) );
//STRIP001 	aBtnDelete.SetClickHdl(
//STRIP001 		LINK( this, SvxLineEndDefTabPage, ClickDeleteHdl_Impl ) );
//STRIP001 	aBtnLoad.SetClickHdl(
//STRIP001 		LINK( this, SvxLineEndDefTabPage, ClickLoadHdl_Impl ) );
//STRIP001 	aBtnSave.SetClickHdl(
//STRIP001 		LINK( this, SvxLineEndDefTabPage, ClickSaveHdl_Impl ) );
//STRIP001 
//STRIP001 	aLbLineEnds.SetSelectHdl(
//STRIP001 		LINK( this, SvxLineEndDefTabPage, SelectLineEndHdl_Impl ) );
//STRIP001 
//STRIP001 	pLineEndList = NULL;
//STRIP001 	pPolyObj	 = NULL;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 SvxLineEndDefTabPage::~SvxLineEndDefTabPage()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxLineEndDefTabPage::Construct()
//STRIP001 {
//STRIP001 	aLbLineEnds.Fill( pLineEndList );
//STRIP001 	if( !pPolyObj )
//STRIP001 		aBtnAdd.Disable();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxLineEndDefTabPage::ActivatePage( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	if( *pDlgType == 0 ) // Flaechen-Dialog
//STRIP001 	{
//STRIP001 		// ActivatePage() wird aufgerufen bevor der Dialog PageCreated() erhaelt !!!
//STRIP001 		if( pLineEndList )
//STRIP001 		{
//STRIP001 			if( *pPosLineEndLb >= 0 &&
//STRIP001 				*pPosLineEndLb != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 			{
//STRIP001 				aLbLineEnds.SelectEntryPos( *pPosLineEndLb );
//STRIP001 				SelectLineEndHdl_Impl( this );
//STRIP001 			}
//STRIP001 			INetURLObject	aURL( pLineEndList->GetPath() );
//STRIP001 
//STRIP001 			aURL.Append( pLineEndList->GetName() );
//STRIP001 			DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 /*			// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 			// der GroupBox darstellen
//STRIP001 			String			aString( SVX_RES( RID_SVXSTR_TABLE ) ); aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 
//STRIP001 			if ( aURL.getBase().Len() > 18 )
//STRIP001 			{
//STRIP001 				aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 				aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aString += aURL.getBase();
//STRIP001 
//STRIP001 			aGrpLineEnds.SetText( aString );
//STRIP001 */
//STRIP001 			*pPageType = 0; // 3
//STRIP001 			*pPosLineEndLb = LISTBOX_ENTRY_NOTFOUND;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 int SvxLineEndDefTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	CheckChanges_Impl();
//STRIP001 
//STRIP001 	if( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 
//STRIP001 	return( LEAVE_PAGE );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxLineEndDefTabPage::CheckChanges_Impl()
//STRIP001 {
//STRIP001 	USHORT nPos = aLbLineEnds.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if ( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		String aString = aEdtName.GetText();
//STRIP001 
//STRIP001 		if( aString != aLbLineEnds.GetSelectEntry() )
//STRIP001 		{
//STRIP001 			QueryBox aQueryBox( DLGWIN, WinBits( WB_YES_NO | WB_DEF_NO ),
//STRIP001 //!				SVX_RES( RID_SVXSTR_LINEEND ),
//STRIP001 				String( SVX_RES( RID_SVXSTR_ASK_CHANGE_LINEEND ) ) );
//STRIP001 
//STRIP001 			if ( aQueryBox.Execute() == RET_YES )
//STRIP001 				ClickModifyHdl_Impl( this );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	nPos = aLbLineEnds.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if ( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		*pPosLineEndLb = nPos;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 BOOL SvxLineEndDefTabPage::FillItemSet( SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	if( *pDlgType == 0 ) // Linien-Dialog
//STRIP001 	{
//STRIP001 		if( *pPageType == 3 )
//STRIP001 		{
//STRIP001 			CheckChanges_Impl();
//STRIP001 
//STRIP001 			long nPos = aLbLineEnds.GetSelectEntryPos();
//STRIP001 			XLineEndEntry* pEntry = pLineEndList->Get( nPos );
//STRIP001 
//STRIP001 			rOutAttrs.Put( XLineStartItem( pEntry->GetName(), pEntry->GetLineEnd() ) );
//STRIP001 			rOutAttrs.Put( XLineEndItem( pEntry->GetName(), pEntry->GetLineEnd() ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return( TRUE );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxLineEndDefTabPage::Reset( const SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	aLbLineEnds.SelectEntryPos( 0 );
//STRIP001 
//STRIP001 	// Update lineend
//STRIP001 	if( pLineEndList->Count() > 0 )
//STRIP001 	{
//STRIP001 		int nPos = aLbLineEnds.GetSelectEntryPos();
//STRIP001 
//STRIP001 		XLineEndEntry* pEntry = pLineEndList->Get( nPos );
//STRIP001 
//STRIP001 		aEdtName.SetText( aLbLineEnds.GetSelectEntry() );
//STRIP001 
//STRIP001 		rXLSet.Put( XLineStartItem( String(), pEntry->GetLineEnd() ) );
//STRIP001 		rXLSet.Put( XLineEndItem( String(), pEntry->GetLineEnd() ) );
//STRIP001 		XOut.SetLineAttr( aXLineAttr.GetItemSet() );
//STRIP001 
//STRIP001 		aCtlPreview.Invalidate();
//STRIP001 	}
//STRIP001 
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if( pLineEndList->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Enable();
//STRIP001 		aBtnDelete.Enable();
//STRIP001 		aBtnSave.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBtnModify.Disable();
//STRIP001 		aBtnDelete.Disable();
//STRIP001 		aBtnSave.Disable();
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxTabPage* SvxLineEndDefTabPage::Create( Window* pWindow,
//STRIP001 				const SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	return( new SvxLineEndDefTabPage( pWindow, rOutAttrs ) );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxLineEndDefTabPage, SelectLineEndHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	if( pLineEndList->Count() > 0 )
//STRIP001 	{
//STRIP001 		int nPos = aLbLineEnds.GetSelectEntryPos();
//STRIP001 
//STRIP001 		XLineEndEntry* pEntry = pLineEndList->Get( nPos );
//STRIP001 
//STRIP001 		aEdtName.SetText( aLbLineEnds.GetSelectEntry() );
//STRIP001 
//STRIP001 		rXLSet.Put( XLineStartItem( String(), pEntry->GetLineEnd() ) );
//STRIP001 		rXLSet.Put( XLineEndItem( String(), pEntry->GetLineEnd() ) );
//STRIP001 		XOut.SetLineAttr( aXLineAttr.GetItemSet() );
//STRIP001 
//STRIP001 		aCtlPreview.Invalidate();
//STRIP001 
//STRIP001 		// Wird erst hier gesetzt, um den Style nur dann zu uebernehmen,
//STRIP001 		// wenn in der ListBox ein Eintrag ausgewaehlt wurde
//STRIP001 		*pPageType = 3;
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 long SvxLineEndDefTabPage::ChangePreviewHdl_Impl( void* )
//STRIP001 {
//STRIP001 	aCtlPreview.Invalidate();
//STRIP001 	return( 0L );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxLineEndDefTabPage, ClickModifyHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	int nPos = aLbLineEnds.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		ResMgr* pMgr = DIALOG_MGR();
//STRIP001 		String aDesc( ResId( RID_SVXSTR_DESC_LINEEND, pMgr ) );
//STRIP001 		String aName( aEdtName.GetText() );
//STRIP001 		long nCount = pLineEndList->Count();
//STRIP001 		BOOL bDifferent = TRUE;
//STRIP001 
//STRIP001 		// Pruefen, ob Name schon vorhanden ist
//STRIP001 		for ( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 			if ( aName == pLineEndList->Get( i )->GetName() )
//STRIP001 				bDifferent = FALSE;
//STRIP001 
//STRIP001 		// Wenn ja, wird wiederholt ein neuer Name angefordert
//STRIP001 		if ( !bDifferent )
//STRIP001 		{
//STRIP001 			WarningBox aWarningBox( DLGWIN, WinBits( WB_OK ),
//STRIP001 				String( ResId( RID_SVXSTR_WARN_NAME_DUPLICATE, pMgr ) ) );
//STRIP001 			aWarningBox.SetHelpId( HID_WARN_NAME_DUPLICATE );
//STRIP001 			aWarningBox.Execute();
//STRIP001 
//STRIP001 			SvxNameDialog* pDlg = new SvxNameDialog( DLGWIN, aName, aDesc );
//STRIP001 			BOOL bLoop = TRUE;
//STRIP001 
//STRIP001 			while( !bDifferent && bLoop && pDlg->Execute() == RET_OK )
//STRIP001 			{
//STRIP001 				pDlg->GetName( aName );
//STRIP001 				bDifferent = TRUE;
//STRIP001 
//STRIP001 				for( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 				{
//STRIP001 					if( aName == pLineEndList->Get( i )->GetName() )
//STRIP001 						bDifferent = FALSE;
//STRIP001 				}
//STRIP001 
//STRIP001 				if( bDifferent )
//STRIP001 					bLoop = FALSE;
//STRIP001 				else
//STRIP001 					aWarningBox.Execute();
//STRIP001 			}
//STRIP001 			delete( pDlg );
//STRIP001 		}
//STRIP001 
//STRIP001 		// Wenn nicht vorhanden, wird Eintrag aufgenommen
//STRIP001 		if( bDifferent )
//STRIP001 		{
//STRIP001 			XLineEndEntry* pEntry = pLineEndList->Get( nPos );
//STRIP001 
//STRIP001 			pEntry->SetName( aName );
//STRIP001 			aEdtName.SetText( aName );
//STRIP001 
//STRIP001 			aLbLineEnds.Modify( pEntry, nPos, pLineEndList->GetBitmap( nPos ) );
//STRIP001 			aLbLineEnds.SelectEntryPos( nPos );
//STRIP001 
//STRIP001 			// Flag fuer modifiziert setzen
//STRIP001 			*pnLineEndListState |= CT_MODIFIED;
//STRIP001 
//STRIP001 			*pPageType = 3;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxLineEndDefTabPage, ClickAddHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	if( pPolyObj )
//STRIP001 	{
//STRIP001 		const SdrObject* pNewObj;
//STRIP001 		SdrObject* pConvPolyObj = NULL;
//STRIP001 		UINT16 nId = pPolyObj->GetObjIdentifier();
//STRIP001 
//STRIP001 		if( pPolyObj->ISA( SdrPathObj ) )
//STRIP001 		{
//STRIP001 			pNewObj = pPolyObj;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SdrObjTransformInfoRec aInfoRec;
//STRIP001 			pPolyObj->TakeObjInfo( aInfoRec );
//STRIP001 
//STRIP001 			if( aInfoRec.bCanConvToPath )
//STRIP001 			{
//STRIP001 				pNewObj = pConvPolyObj = pPolyObj->ConvertToPolyObj( TRUE, FALSE );
//STRIP001 
//STRIP001 				if( !pNewObj || !pNewObj->ISA( SdrPathObj ) )
//STRIP001 					return( 0L ); // Abbruch, zusaetzliche Sicherheit, die bei
//STRIP001 							// Gruppenobjekten aber nichts bringt.
//STRIP001 			}
//STRIP001 			else return( 0L ); // Abbruch
//STRIP001 		}
//STRIP001 
//STRIP001 		const XPolygon& rXPoly = ( (SdrPathObj*) pNewObj )->GetPathPoly().GetObject( 0 );
//STRIP001 		XPolygon aXPoly( rXPoly );
//STRIP001 
//STRIP001 		// Normalisieren
//STRIP001 		Point aPoint( aXPoly.GetBoundRect().TopLeft() );
//STRIP001 		aPoint.X() *= -1;
//STRIP001 		aPoint.Y() *= -1;
//STRIP001 		aXPoly.Translate( aPoint );
//STRIP001 
//STRIP001 		// Loeschen des angelegten PolyObjektes
//STRIP001 		if( pConvPolyObj )
//STRIP001 			delete pConvPolyObj;
//STRIP001 
//STRIP001 		XLineEndEntry* pEntry;
//STRIP001 
//STRIP001 		ResMgr* pMgr = DIALOG_MGR();
//STRIP001 		String aNewName( ResId( RID_SVXSTR_LINEEND, pMgr ) );
//STRIP001 		String aDesc( ResId( RID_SVXSTR_DESC_LINEEND, pMgr ) );
//STRIP001 		String aName;
//STRIP001 
//STRIP001 		long nCount = pLineEndList->Count();
//STRIP001 		long j = 1;
//STRIP001 		BOOL bDifferent = FALSE;
//STRIP001 
//STRIP001 		while ( !bDifferent )
//STRIP001 		{
//STRIP001 			aName = aNewName;
//STRIP001 			aName += sal_Unicode(' ');
//STRIP001 			aName += UniString::CreateFromInt32( j++ );
//STRIP001 			bDifferent = TRUE;
//STRIP001 
//STRIP001 			for( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 				if ( aName == pLineEndList->Get( i )->GetName() )
//STRIP001 					bDifferent = FALSE;
//STRIP001 		}
//STRIP001 
//STRIP001 		SvxNameDialog* pDlg = new SvxNameDialog( DLGWIN, aName, aDesc );
//STRIP001 		BOOL bLoop = TRUE;
//STRIP001 
//STRIP001 		while ( bLoop && pDlg->Execute() == RET_OK )
//STRIP001 		{
//STRIP001 			pDlg->GetName( aName );
//STRIP001 			bDifferent = TRUE;
//STRIP001 
//STRIP001 			for( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 			{
//STRIP001 				if( aName == pLineEndList->Get( i )->GetName() )
//STRIP001 					bDifferent = FALSE;
//STRIP001 			}
//STRIP001 
//STRIP001 			if( bDifferent )
//STRIP001 			{
//STRIP001 				bLoop = FALSE;
//STRIP001 				pEntry = new XLineEndEntry( aXPoly, aName );
//STRIP001 
//STRIP001 				long nCount = pLineEndList->Count();
//STRIP001 				pLineEndList->Insert( pEntry, nCount );
//STRIP001 				Bitmap* pBitmap = pLineEndList->GetBitmap( nCount );
//STRIP001 
//STRIP001 				// Zur ListBox hinzufuegen
//STRIP001 				aLbLineEnds.Append( pEntry, pBitmap );
//STRIP001 				aLbLineEnds.SelectEntryPos( aLbLineEnds.GetEntryCount() - 1 );
//STRIP001 
//STRIP001 				// Flag fuer modifiziert setzen
//STRIP001 				*pnLineEndListState |= CT_MODIFIED;
//STRIP001 
//STRIP001 				SelectLineEndHdl_Impl( this );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				WarningBox aBox( DLGWIN, WinBits( WB_OK ),String( ResId( RID_SVXSTR_WARN_NAME_DUPLICATE, pMgr ) ) );
//STRIP001 				aBox.SetHelpId( HID_WARN_NAME_DUPLICATE );
//STRIP001 				aBox.Execute();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		delete pDlg;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aBtnAdd.Disable();
//STRIP001 
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if ( pLineEndList->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Enable();
//STRIP001 		aBtnDelete.Enable();
//STRIP001 		aBtnSave.Enable();
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxLineEndDefTabPage, ClickDeleteHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	int nPos = aLbLineEnds.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if( nPos >= 0 )
//STRIP001 	{
//STRIP001 		QueryBox aQueryBox( DLGWIN, WinBits( WB_YES_NO | WB_DEF_NO ),
//STRIP001 //!			SVX_RES( RID_SVXSTR_DEL_LINEEND ),
//STRIP001 			String( SVX_RES( RID_SVXSTR_ASK_DEL_LINEEND ) ) );
//STRIP001 
//STRIP001 		if ( aQueryBox.Execute() == RET_YES )
//STRIP001 		{
//STRIP001 			delete pLineEndList->Remove( nPos );
//STRIP001 			aLbLineEnds.RemoveEntry( nPos );
//STRIP001 			aLbLineEnds.SelectEntryPos( 0 );
//STRIP001 
//STRIP001 			SelectLineEndHdl_Impl( this );
//STRIP001 			*pPageType = 0; // LineEnd soll nicht uebernommen werden
//STRIP001 
//STRIP001 			// Flag fuer modifiziert setzen
//STRIP001 			*pnLineEndListState |= CT_MODIFIED;
//STRIP001 
//STRIP001 			ChangePreviewHdl_Impl( this );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if( !pLineEndList->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Disable();
//STRIP001 		aBtnDelete.Disable();
//STRIP001 		aBtnSave.Disable();
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxLineEndDefTabPage, ClickLoadHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	ResMgr* pMgr = DIALOG_MGR();
//STRIP001 	USHORT nReturn = RET_YES;
//STRIP001 
//STRIP001 	if ( *pnLineEndListState & CT_MODIFIED )
//STRIP001 	{
//STRIP001 		nReturn = WarningBox( DLGWIN, WinBits( WB_YES_NO_CANCEL ),
//STRIP001 			String( ResId( RID_SVXSTR_WARN_TABLE_OVERWRITE, pMgr ) ) ).Execute();
//STRIP001 
//STRIP001 		if ( nReturn == RET_YES )
//STRIP001 			pLineEndList->Save();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nReturn != RET_CANCEL )
//STRIP001 	{
//STRIP001     	::sfx2::FileDialogHelper aDlg( ::sfx2::FILEOPEN_SIMPLE, 0 );
//STRIP001 		String aStrFilterType( RTL_CONSTASCII_USTRINGPARAM( "*.soe" ) );
//STRIP001 		aDlg.AddFilter( aStrFilterType, aStrFilterType );
//STRIP001 		INetURLObject aFile( SvtPathOptions().GetPalettePath() );
//STRIP001 		aDlg.SetDisplayDirectory( aFile.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001 		if( aDlg.Execute() == ERRCODE_NONE )
//STRIP001 		{
//STRIP001 			INetURLObject aURL( aDlg.GetPath() );
//STRIP001 			INetURLObject aPathURL( aURL );
//STRIP001 
//STRIP001 			aPathURL.removeSegment();
//STRIP001 			aPathURL.removeFinalSlash();
//STRIP001 
//STRIP001 			// Liste speichern
//STRIP001 			XLineEndList* pLeList = new XLineEndList( aPathURL.GetMainURL( INetURLObject::NO_DECODE ), pXPool );
//STRIP001 			pLeList->SetName( aURL.getName() );
//STRIP001 			if( pLeList->Load() )
//STRIP001 			{
//STRIP001 				if( pLeList )
//STRIP001 				{
//STRIP001 					// Pruefen, ob Tabelle geloescht werden darf:
//STRIP001 					if( pLineEndList != ( (SvxLineTabDialog*) DLGWIN )->GetLineEndList() )
//STRIP001 						delete pLineEndList;
//STRIP001 
//STRIP001 					pLineEndList = pLeList;
//STRIP001 					( (SvxLineTabDialog*) DLGWIN )->SetNewLineEndList( pLineEndList );
//STRIP001 					aLbLineEnds.Clear();
//STRIP001 					aLbLineEnds.Fill( pLineEndList );
//STRIP001 					Reset( rOutAttrs );
//STRIP001 
//STRIP001 					pLineEndList->SetName( aURL.getName() );
//STRIP001 
//STRIP001 /*					// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 					// der GroupBox darstellen
//STRIP001 					String aString( ResId( RID_SVXSTR_TABLE, pMgr ) );
//STRIP001 					aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 					if( aURL.getBase().Len() > 18 )
//STRIP001 					{
//STRIP001 						aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 						aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 					}
//STRIP001 					else
//STRIP001 						aString += aURL.getBase();
//STRIP001 
//STRIP001 					aGrpLineEnds.SetText( aString );
//STRIP001 */
//STRIP001 					// Flag fuer gewechselt setzen
//STRIP001 					*pnLineEndListState |= CT_CHANGED;
//STRIP001 					// Flag fuer modifiziert entfernen
//STRIP001 					*pnLineEndListState &= ~CT_MODIFIED;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 				ErrorBox( DLGWIN, WinBits( WB_OK ),
//STRIP001 					String( ResId( RID_SVXSTR_READ_DATA_ERROR, pMgr ) ) ).Execute();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if ( pLineEndList->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Enable();
//STRIP001 		aBtnDelete.Enable();
//STRIP001 		aBtnSave.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBtnModify.Disable();
//STRIP001 		aBtnDelete.Disable();
//STRIP001 		aBtnSave.Disable();
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxLineEndDefTabPage, ClickSaveHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001    	::sfx2::FileDialogHelper aDlg( ::sfx2::FILESAVE_SIMPLE, 0 );
//STRIP001 	String aStrFilterType( RTL_CONSTASCII_USTRINGPARAM( "*.soe" ) );
//STRIP001 	aDlg.AddFilter( aStrFilterType, aStrFilterType );
//STRIP001 
//STRIP001 	INetURLObject aFile( SvtPathOptions().GetPalettePath() );
//STRIP001 	DBG_ASSERT( aFile.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 	if( pLineEndList->GetName().Len() )
//STRIP001 	{
//STRIP001 		aFile.Append( pLineEndList->GetName() );
//STRIP001 
//STRIP001 		if( !aFile.getExtension().Len() )
//STRIP001 			aFile.SetExtension( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "soe" ) ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	aDlg.SetDisplayDirectory( aFile.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 	if ( aDlg.Execute() == ERRCODE_NONE )
//STRIP001 	{
//STRIP001 		INetURLObject	aURL( aDlg.GetPath() );
//STRIP001 		INetURLObject	aPathURL( aURL );
//STRIP001 
//STRIP001 		aPathURL.removeSegment();
//STRIP001 		aPathURL.removeFinalSlash();
//STRIP001 
//STRIP001 		pLineEndList->SetName( aURL.getName() );
//STRIP001 		pLineEndList->SetPath( aPathURL.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001 		if( pLineEndList->Save() )
//STRIP001 		{
//STRIP001 /*			// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 			// der GroupBox darstellen
//STRIP001 			String aString( SVX_RES( RID_SVXSTR_TABLE ) );
//STRIP001 			aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 
//STRIP001 			if ( aURL.getBase().Len() > 18 )
//STRIP001 			{
//STRIP001 				aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 				aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aString += aURL.getBase();
//STRIP001 			aGrpLineEnds.SetText( aString );
//STRIP001 */
//STRIP001 			// Flag fuer gespeichert setzen
//STRIP001 			*pnLineEndListState |= CT_SAVED;
//STRIP001 			// Flag fuer modifiziert entfernen
//STRIP001 			*pnLineEndListState &= ~CT_MODIFIED;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			ErrorBox( DLGWIN, WinBits( WB_OK ),
//STRIP001 				String( SVX_RES( RID_SVXSTR_WRITE_DATA_ERROR ) ) ).Execute();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }

//STRIP001 void SvxLineEndDefTabPage::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	SfxTabPage::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001 	{
//STRIP001 		USHORT nOldSelect = aLbLineEnds.GetSelectEntryPos();
//STRIP001 		aLbLineEnds.Clear();
//STRIP001 		aLbLineEnds.Fill( pLineEndList );
//STRIP001 		aLbLineEnds.SelectEntryPos( nOldSelect );
//STRIP001 	}
//STRIP001 }

}
