/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_srchxtra.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:04:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#include "srchxtra.hxx"

#ifndef _TOOLS_RCID_H
#include <tools/rcid.h>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef _SVTOOLS_CJKOPTIONS_HXX
#include <svtools/cjkoptions.hxx>
#endif
#ifndef _SFX_WHITER_HXX
#include <svtools/whiter.hxx>
#endif
#ifndef _SFX_OBJSH_HXX
#include <bf_sfx2/objsh.hxx>
#endif

#ifndef _SVX_DIALOGS_HRC
#include "dialogs.hrc"
#endif
#ifndef _SVX_SRCHXTRA_HRC
#include "srchxtra.hrc"
#endif
#ifndef _SVXITEMS_HRC
#include "svxitems.hrc"
#endif

#ifndef _SVX_FLSTITEM_HXX
#define ITEMID_FONTLIST		SID_ATTR_CHAR_FONTLIST
#include "flstitem.hxx"
#endif
#ifndef _SVX_CHARDLG_HXX
#include "chardlg.hxx"
#endif
#ifndef _SVX_PARAGRPH_HXX
#include "paragrph.hxx"
#endif
#ifndef _SVX_DIALMGR_HXX
#include "dialmgr.hxx"
#endif
#ifndef _SVX_BACKGRND_HXX
#include "backgrnd.hxx"
#endif
namespace binfilter {

// class SvxSearchFormatDialog -------------------------------------------

//STRIP001 SvxSearchFormatDialog::SvxSearchFormatDialog( Window* pParent, const SfxItemSet& rSet ) :
//STRIP001 
//STRIP001 	SfxTabDialog( pParent, SVX_RES( RID_SVXDLG_SEARCHFORMAT ), &rSet ),
//STRIP001 
//STRIP001 	pFontList( NULL )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	AddTabPage( RID_SVXPAGE_CHAR_NAME, SvxCharNamePage::Create, 0 );
//STRIP001 	AddTabPage( RID_SVXPAGE_CHAR_EFFECTS, SvxCharEffectsPage::Create, 0 );
//STRIP001 	AddTabPage( RID_SVXPAGE_CHAR_POSITION, SvxCharPositionPage::Create, 0 );
//STRIP001 	AddTabPage( RID_SVXPAGE_CHAR_TWOLINES, SvxCharTwoLinesPage::Create, 0 );
//STRIP001 	AddTabPage( RID_SVXPAGE_STD_PARAGRAPH, SvxStdParagraphTabPage::Create, 0 );
//STRIP001 	AddTabPage( RID_SVXPAGE_ALIGN_PARAGRAPH, SvxParaAlignTabPage::Create, 0 );
//STRIP001 	AddTabPage( RID_SVXPAGE_EXT_PARAGRAPH, SvxExtParagraphTabPage::Create, 0 );
//STRIP001 	AddTabPage( RID_SVXPAGE_PARA_ASIAN, SvxAsianTabPage::Create, 0 );
//STRIP001 	AddTabPage( RID_SVXPAGE_BACKGROUND, SvxBackgroundTabPage::Create, 0 );
//STRIP001 
//STRIP001 	// remove asian tabpages if necessary
//STRIP001     SvtCJKOptions aCJKOptions;
//STRIP001     if ( !aCJKOptions.IsDoubleLinesEnabled() )
//STRIP001         RemoveTabPage( RID_SVXPAGE_CHAR_TWOLINES );
//STRIP001     if ( !aCJKOptions.IsAsianTypographyEnabled() )
//STRIP001 		RemoveTabPage( RID_SVXPAGE_PARA_ASIAN );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SvxSearchFormatDialog::~SvxSearchFormatDialog()
//STRIP001 {
//STRIP001 	delete pFontList;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxSearchFormatDialog::PageCreated( USHORT nId, SfxTabPage& rPage )
//STRIP001 {
//STRIP001 	switch ( nId )
//STRIP001 	{
//STRIP001         case RID_SVXPAGE_CHAR_NAME:
//STRIP001 		{
//STRIP001 			const FontList*	pAppFontList = 0;
//STRIP001 			SfxObjectShell* pSh = SfxObjectShell::Current();
//STRIP001 
//STRIP001 			if ( pSh )
//STRIP001 			{
//STRIP001 				const SvxFontListItem* pFLItem = (const SvxFontListItem*)
//STRIP001 					pSh->GetItem( SID_ATTR_CHAR_FONTLIST );
//STRIP001 				if ( pFLItem )
//STRIP001 					pAppFontList = pFLItem->GetFontList();
//STRIP001 			}
//STRIP001 
//STRIP001 			const FontList* pList = pAppFontList;
//STRIP001 
//STRIP001 			if ( !pList )
//STRIP001 			{
//STRIP001 				if ( !pFontList )
//STRIP001 					pFontList = new FontList( this );
//STRIP001 				pList = pFontList;
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( pList )
//STRIP001                 ( (SvxCharNamePage&)rPage ).
//STRIP001 					SetFontList( SvxFontListItem( pList ) );
//STRIP001             ( (SvxCharNamePage&)rPage ).EnableSearchMode();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case RID_SVXPAGE_STD_PARAGRAPH:
//STRIP001 			( (SvxStdParagraphTabPage&)rPage ).EnableAutoFirstLine();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case RID_SVXPAGE_ALIGN_PARAGRAPH:
//STRIP001 			( (SvxParaAlignTabPage&)rPage ).EnableJustifyExt();
//STRIP001 			break;
//STRIP001 		case RID_SVXPAGE_BACKGROUND :
//STRIP001 			( (SvxBackgroundTabPage&)rPage ).ShowParaControl(TRUE);
//STRIP001 			break;
//STRIP001 	}
//STRIP001 }

// class SvxSearchFormatDialog -------------------------------------------

//STRIP001 SvxSearchAttributeDialog::SvxSearchAttributeDialog( Window* pParent,
//STRIP001 													SearchAttrItemList& rLst,
//STRIP001 													const USHORT* pWhRanges ) :
//STRIP001 
//STRIP001 	ModalDialog( pParent, SVX_RES( RID_SVXDLG_SEARCHATTR )  ),
//STRIP001 
//STRIP001 	aOKBtn	( this, ResId( BTN_ATTR_OK ) ),
//STRIP001 	aEscBtn	( this, ResId( BTN_ATTR_CANCEL ) ),
//STRIP001 	aHelpBtn( this, ResId( BTN_ATTR_HELP ) ),
//STRIP001 	aAttrLB	( this, ResId( LB_ATTR ) ),
//STRIP001     aAttrFL ( this, ResId( FL_ATTR ) ),
//STRIP001 
//STRIP001 	rList( rLst )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	aAttrLB.SetWindowBits( GetStyle() | WB_CLIPCHILDREN | WB_HSCROLL | WB_SORT );
//STRIP001 	aAttrLB.GetModel()->SetSortMode( SortAscending );
//STRIP001 
//STRIP001 	aOKBtn.SetClickHdl( LINK( this, SvxSearchAttributeDialog, OKHdl ) );
//STRIP001 
//STRIP001 	SfxObjectShell* pSh = SfxObjectShell::Current();
//STRIP001 	DBG_ASSERT( pSh, "No DocShell" );
//STRIP001 
//STRIP001 	SfxItemPool& rPool = pSh->GetPool();
//STRIP001 	SfxItemSet aSet( rPool, pWhRanges );
//STRIP001 	SfxWhichIter aIter( aSet );
//STRIP001 	USHORT nWhich = aIter.FirstWhich();
//STRIP001 
//STRIP001 	while ( nWhich )
//STRIP001 	{
//STRIP001 		USHORT nSlot = rPool.GetSlotId( nWhich );
//STRIP001 		if ( nSlot >= SID_SVX_START )
//STRIP001 		{
//STRIP001 			BOOL bChecked = FALSE, bFound = FALSE;
//STRIP001 			for ( USHORT i = 0; !bFound && i < rList.Count(); ++i )
//STRIP001 			{
//STRIP001 				if ( nSlot == rList[i].nSlot )
//STRIP001 				{
//STRIP001 					bFound = TRUE;
//STRIP001 					if ( IsInvalidItem( rList[i].pItem ) )
//STRIP001 						bChecked = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			USHORT nResId = nSlot - SID_SVX_START + RID_ATTR_BEGIN;
//STRIP001 			SvLBoxEntry* pEntry = NULL;
//STRIP001     		ResId aId( nResId );
//STRIP001     		aId.SetRT( RSC_STRING );
//STRIP001     		if ( DIALOG_MGR()->IsAvailable( aId ) )
//STRIP001 				pEntry = aAttrLB.SvTreeListBox::InsertEntry( SVX_RESSTR( nResId ) );
//STRIP001 			else
//STRIP001 			{
//STRIP001 				ByteString sError( "no resource for slot id\nslot = " );
//STRIP001 				sError += ByteString::CreateFromInt32( nSlot );
//STRIP001 				sError += ByteString( "\nresid = " );
//STRIP001 				sError += ByteString::CreateFromInt32( nResId );
//STRIP001 				DBG_ERRORFILE( sError.GetBuffer() );
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( pEntry )
//STRIP001 			{
//STRIP001 				aAttrLB.SetCheckButtonState( pEntry, bChecked ? SV_BUTTON_CHECKED : SV_BUTTON_UNCHECKED );
//STRIP001 				pEntry->SetUserData( (void*)(ULONG)nSlot );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 
//STRIP001 	aAttrLB.SetHighlightRange();
//STRIP001 	aAttrLB.SelectEntryPos( 0 );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxSearchAttributeDialog, OKHdl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	SearchAttrItem aInvalidItem;
//STRIP001 	aInvalidItem.pItem = (SfxPoolItem*)-1;
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < aAttrLB.GetEntryCount(); ++i )
//STRIP001 	{
//STRIP001 		USHORT nSlot = (USHORT)(ULONG)aAttrLB.GetEntryData(i);
//STRIP001 		BOOL bChecked = aAttrLB.IsChecked(i);
//STRIP001 
//STRIP001 		USHORT j;
//STRIP001 		for ( j = rList.Count(); j; )
//STRIP001 		{
//STRIP001 			SearchAttrItem& rItem = rList[ --j ];
//STRIP001 			if( rItem.nSlot == nSlot )
//STRIP001 			{
//STRIP001 				if( bChecked )
//STRIP001 				{
//STRIP001 					if( !IsInvalidItem( rItem.pItem ) )
//STRIP001 						delete rItem.pItem;
//STRIP001 					rItem.pItem = (SfxPoolItem*)-1;
//STRIP001 				}
//STRIP001 				else if( IsInvalidItem( rItem.pItem ) )
//STRIP001 					rItem.pItem = 0;
//STRIP001 				j = 1;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( !j && bChecked )
//STRIP001 		{
//STRIP001 			aInvalidItem.nSlot = nSlot;
//STRIP001 			rList.Insert( aInvalidItem );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// remove invalid items (pItem == NULL)
//STRIP001 	for ( USHORT n = rList.Count(); n; )
//STRIP001 		if ( !rList[ --n ].pItem )
//STRIP001 			rList.Remove( n );
//STRIP001 
//STRIP001 	EndDialog( RET_OK );
//STRIP001 	return 0;
//STRIP001 }

// class SvxSearchSimilarityDialog ---------------------------------------

//STRIP001 SvxSearchSimilarityDialog::SvxSearchSimilarityDialog
//STRIP001 (
//STRIP001 	Window* pParent,
//STRIP001 	BOOL bRelax,
//STRIP001 	USHORT nOther,
//STRIP001 	USHORT nShorter,
//STRIP001 	USHORT nLonger
//STRIP001 ) :
//STRIP001 	ModalDialog( pParent, SVX_RES( RID_SVXDLG_SEARCHSIMILARITY ) ),
//STRIP001 
//STRIP001 	aOtherTxt	( this, ResId( FT_OTHER ) ),
//STRIP001 	aOtherFld	( this, ResId( NF_OTHER	) ),
//STRIP001 	aShorterTxt	( this, ResId( FT_SHORTER ) ),
//STRIP001 	aShorterFld	( this, ResId( NF_SHORTER ) ),
//STRIP001 	aLongerTxt	( this, ResId( FT_LONGER ) ),
//STRIP001 	aLongerFld	( this, ResId( NF_LONGER ) ),
//STRIP001 	aRelaxBox	( this, ResId( CB_RELAX	) ),
//STRIP001     aFixedLine  ( this, ResId( FL_SIMILARITY ) ),
//STRIP001 
//STRIP001 	aOKBtn		( this, ResId( BTN_ATTR_OK ) ),
//STRIP001 	aEscBtn		( this, ResId( BTN_ATTR_CANCEL ) ),
//STRIP001 	aHelpBtn	( this, ResId( BTN_ATTR_HELP ) )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	aOtherFld.SetValue( nOther );
//STRIP001 	aShorterFld.SetValue( nShorter );
//STRIP001 	aLongerFld.SetValue( nLonger );
//STRIP001 	aRelaxBox.Check( bRelax );
//STRIP001 }

}
