/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_page.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:57:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#pragma hdrstop

#define ITEMID_BRUSH		0
#define ITEMID_BOX          0
#define ITEMID_BOXINFO      0
#define ITEMID_SHADOW       0
#define ITEMID_PAPERBIN     0
#define ITEMID_LRSPACE      0
#define ITEMID_ULSPACE      0
#define ITEMID_SIZE         0
#define ITEMID_FRAMEDIR     0

#ifndef _SFXAPP_HXX //autogen
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SFX_OBJSH_HXX
#include <bf_sfx2/objsh.hxx>
#endif
#ifndef _RESARY_HXX //autogen
#include <tools/resary.hxx>
#endif
#ifndef _GRAPH_HXX //autogen
#include <vcl/graph.hxx>
#endif
#ifndef _SFXVIEWSH_HXX //autogen
#include <bf_sfx2/viewsh.hxx>
#endif
#ifndef _SFXITEMITER_HXX //autogen
#include <svtools/itemiter.hxx>
#endif
#ifndef _SVTOOLS_LANGUAGEOPTIONS_HXX
#include <svtools/languageoptions.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _UTL_CONFIGITEM_HXX_
#include <unotools/configitem.hxx>
#endif
#ifndef _SVX_HTMLMODE_HXX
#include "htmlmode.hxx"
#endif

#define _SVX_PAGE_CXX

#include "dialogs.hrc"
#include "page.hrc"
#include "helpid.hrc"

#define ITEMID_PAGE 			0
#define ITEMID_SETITEM     		0
#define ITEMID_PTR 	    		0

#include "page.hxx"
#include "pageitem.hxx"
#include "brshitem.hxx"
#include "boxitem.hxx"
#include "shaditem.hxx"
#include "pbinitem.hxx"
#include "lrspitem.hxx"
#include "ulspitem.hxx"
#include "sizeitem.hxx"
#include "frmdiritem.hxx"
#include "bbdlg.hxx"
#include "dlgutil.hxx"
#include "dialmgr.hxx"
#include "paperinf.hxx"
#include "dialmgr.hxx"

#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif


#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
namespace binfilter {

// configuration helper =======================================================

/** Helper to get a configuration setting.
    @descr  This is a HACK to get a configuration item directly. Normally the
    OfaHtmlOptions class from 'offmgr' project would do the job, but we cannot
    use it here. On the other hand, the OfaHtmlOptions cannot be moved to
    'svtools', because it uses 'svx' itself...
    The correct way would be to move OfaHtmlOptions to 'svtools' anyway, and to
    remove the dependency from 'svx' (a call to the static function
    SvxTextEncodingBox::GetBestMimeEncoding(), which contains low level
    operations that can be moved to lower projects, i.e. 'rtl'). Then this
    class can be removed, and the OfaHtmlOptions can be used instead. */
//STRIP001 class SvxHtmlExportModeConfigItem_Impl : public utl::ConfigItem
//STRIP001 {
//STRIP001 public:
//STRIP001     explicit                    SvxHtmlExportModeConfigItem_Impl();
//STRIP001 
//STRIP001     /** Returns the HTML export mode, as read from the configuration. */
//STRIP001     inline sal_Int32            GetExportMode() const { return mnExpMode; }
//STRIP001 
//STRIP001     /** Returns true, if the current HTML export mode is set to HTML 3.2. */
//STRIP001     inline bool                 IsExportModeHTML32() const { return mnExpMode == 0; } // 0 == HTML_CFG_HTML32, see offmgr/htmlcfg.hxx
//STRIP001 
//STRIP001 private:
//STRIP001     sal_Int32                   mnExpMode;
//STRIP001 };
//STRIP001 
//STRIP001 SvxHtmlExportModeConfigItem_Impl::SvxHtmlExportModeConfigItem_Impl() :
//STRIP001     utl::ConfigItem( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Office.Common/Filter/HTML/Export" ) ) ),
//STRIP001     mnExpMode( 3 )  // default to 3 == HTML_CFG_NS40, see offmgr/htmlcfg.hxx
//STRIP001 {
//STRIP001     using ::com::sun::star::uno::Sequence;
//STRIP001     using ::com::sun::star::uno::Any;
//STRIP001 
//STRIP001     Sequence< ::rtl::OUString > aPropNames( 1 );
//STRIP001     aPropNames[ 0 ] = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Browser" ) );
//STRIP001     Sequence< Any > aPropValues( GetProperties( aPropNames ) );
//STRIP001     if( aPropValues.getLength() == 1 )
//STRIP001         aPropValues[ 0 ] >>= mnExpMode;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // static ----------------------------------------------------------------
//STRIP001 
//STRIP001 static const long MINBODY 		= 284;	// 0,5cm in twips aufgerundet
//STRIP001 //static const long PRINT_OFFSET 	= 17;	// 0,03cm in twips abgerundet
//STRIP001 static const long PRINT_OFFSET 	= 0;	// why was this ever set to 17 ? it led to wrong right and bottom margins.
//STRIP001 
//STRIP001 static USHORT pRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_BORDER_OUTER,
//STRIP001 	SID_ATTR_BORDER_SHADOW,
//STRIP001 	SID_ATTR_LRSPACE,
//STRIP001 	SID_ATTR_PAGE_SHARED,
//STRIP001 	SID_SWREGISTER_COLLECTION,
//STRIP001 	SID_SWREGISTER_MODE,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 // ------- Mapping Seitenlayout ------------------------------------------
//STRIP001 
//STRIP001 USHORT aArr[] =
//STRIP001 {
//STRIP001 	SVX_PAGE_ALL,
//STRIP001 	SVX_PAGE_MIRROR,
//STRIP001 	SVX_PAGE_RIGHT,
//STRIP001 	SVX_PAGE_LEFT
//STRIP001 };
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT PageUsageToPos_Impl( USHORT nUsage )
//STRIP001 {
//STRIP001 	const USHORT nCount = sizeof(aArr) / sizeof(USHORT);
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < nCount; ++i )
//STRIP001 		if ( aArr[i] == ( nUsage & 0x000f ) )
//STRIP001 			return i;
//STRIP001 	return SVX_PAGE_ALL;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT PosToPageUsage_Impl( USHORT nPos )
//STRIP001 {
//STRIP001 	const USHORT nCount = sizeof(aArr) / sizeof(USHORT);
//STRIP001 
//STRIP001 	if ( nPos >= nCount )
//STRIP001 		return 0;
//STRIP001 	return aArr[nPos];
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 Size GetMinBorderSpace_Impl( const SvxShadowItem& rShadow, const SvxBoxItem& rBox )
//STRIP001 {
//STRIP001 	Size aSz;
//STRIP001 	aSz.Height() = rShadow.CalcShadowSpace( SHADOW_BOTTOM ) + rBox.CalcLineSpace( BOX_LINE_BOTTOM );
//STRIP001 	aSz.Height() += rShadow.CalcShadowSpace( SHADOW_TOP ) + rBox.CalcLineSpace( BOX_LINE_TOP );
//STRIP001 	aSz.Width() = rShadow.CalcShadowSpace( SHADOW_LEFT ) + rBox.CalcLineSpace( BOX_LINE_LEFT );
//STRIP001 	aSz.Width() += rShadow.CalcShadowSpace( SHADOW_RIGHT ) + rBox.CalcLineSpace( BOX_LINE_RIGHT );
//STRIP001 	return aSz;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long ConvertLong_Impl( const long nIn, SfxMapUnit eUnit )
//STRIP001 {
//STRIP001 	return OutputDevice::LogicToLogic( nIn, (MapUnit)eUnit, MAP_TWIP );
//STRIP001 }
//STRIP001 
//STRIP001 BOOL IsEqualSize_Impl( const SvxSizeItem* pSize, const Size& rSize )
//STRIP001 {
//STRIP001 	if ( pSize )
//STRIP001 	{
//STRIP001 		Size aSize = pSize->GetSize();
//STRIP001 		long nDiffW = Abs( rSize.Width () - aSize.Width () );
//STRIP001 		long nDiffH = Abs( rSize.Height() - aSize.Height() );
//STRIP001 		return ( nDiffW < 10 && nDiffH < 10 );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 #define MARGIN_LEFT		( (MarginPosition)0x0001 )
//STRIP001 #define MARGIN_RIGHT	( (MarginPosition)0x0002 )
//STRIP001 #define MARGIN_TOP		( (MarginPosition)0x0004 )
//STRIP001 #define MARGIN_BOTTOM	( (MarginPosition)0x0008 )
//STRIP001 
//STRIP001 struct SvxPage_Impl
//STRIP001 {
//STRIP001 	MarginPosition	m_nPos;
//STRIP001 
//STRIP001 	SvxPage_Impl() : m_nPos( 0 ) {}
//STRIP001 };
//STRIP001 
//STRIP001 // class SvxPageDescPage --------------------------------------------------
//STRIP001 
//STRIP001 // gibt den Bereich der Which-Werte zur"uck
//STRIP001 
//STRIP001 USHORT* SvxPageDescPage::GetRanges()
//STRIP001 {
//STRIP001 	return pRanges;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SvxPageDescPage::Create( Window* pParent, const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	return new SvxPageDescPage( pParent, rSet );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxPageDescPage::SvxPageDescPage( Window* pParent, const SfxItemSet& rAttr ) :
//STRIP001 
//STRIP001 	SfxTabPage( pParent, SVX_RES( RID_SVXPAGE_PAGE ), rAttr ),
//STRIP001 
//STRIP001 	aLeftMarginLbl		( this, ResId( FT_LEFT_MARGIN ) ),
//STRIP001 	aLeftMarginEdit		( this, ResId( ED_LEFT_MARGIN ) ),
//STRIP001 	aRightMarginLbl		( this, ResId( FT_RIGHT_MARGIN ) ),
//STRIP001 	aRightMarginEdit	( this, ResId( ED_RIGHT_MARGIN ) ),
//STRIP001 	aTopMarginLbl		( this, ResId( FT_TOP_MARGIN ) ),
//STRIP001 	aTopMarginEdit		( this, ResId( ED_TOP_MARGIN ) ),
//STRIP001 	aBottomMarginLbl	( this, ResId( FT_BOTTOM_MARGIN ) ),
//STRIP001 	aBottomMarginEdit	( this, ResId( ED_BOTTOM_MARGIN ) ),
//STRIP001 	aMarginFl			( this, ResId( FL_MARGIN ) ),
//STRIP001 	aLayoutBox			( this, ResId( LB_LAYOUT ) ),
//STRIP001 	aPageText			( this, ResId( FT_PAGELAYOUT ) ),
//STRIP001 	aNumberFormatBox	( this, ResId( LB_NUMBER_FORMAT ) ),
//STRIP001 	aNumberFormatText	( this, ResId( FT_NUMBER_FORMAT ) ),
//STRIP001     aLayoutFL           ( this, ResId( FL_LAYOUT ) ),
//STRIP001 	aBspWin				( this, ResId( WN_BSP ) ),
//STRIP001 	aPaperFormatText	( this, ResId( FT_PAPER_FORMAT ) ),
//STRIP001 	aPaperSizeBox		( this, ResId( LB_PAPER_SIZE ) ),
//STRIP001     aOrientationFT      ( this, ResId( FT_ORIENTATION ) ),
//STRIP001     aPortraitBtn        ( this, ResId( RB_PORTRAIT ) ),
//STRIP001 	aLandscapeBtn		( this, ResId( RB_LANDSCAPE ) ),
//STRIP001 	aPaperWidthText		( this, ResId( FT_PAPER_WIDTH ) ),
//STRIP001 	aPaperWidthEdit		( this, ResId( ED_PAPER_WIDTH ) ),
//STRIP001 	aPaperHeightText	( this, ResId( FT_PAPER_HEIGHT ) ),
//STRIP001 	aPaperHeightEdit	( this, ResId( ED_PAPER_HEIGHT ) ),
//STRIP001 	aPaperTrayLbl		( this, ResId( FT_PAPER_TRAY ) ),
//STRIP001 	aPaperTrayBox		( this, ResId( LB_PAPER_TRAY ) ),
//STRIP001 	aPaperSizeFl		( this, ResId( FL_PAPER_SIZE ) ),
//STRIP001     aBottomSeparatorFl  ( this, ResId( FL_BOTTOM_SEP ) ),
//STRIP001     aTblAlignFT         ( this, ResId( FT_TBL_ALIGN ) ),
//STRIP001     aHorzBox            ( this, ResId( CB_HORZ ) ),
//STRIP001 	aVertBox			( this, ResId( CB_VERT ) ),
//STRIP001 	aAdaptBox			( this, ResId( CB_ADAPT ) ),
//STRIP001 	aRegisterCB         ( this, ResId( CB_REGISTER ) ),
//STRIP001 	aRegisterFT         ( this, ResId( FT_REGISTER ) ),
//STRIP001 	aRegisterLB       	( this, ResId( LB_REGISTER ) ),
//STRIP001     aTextFlowLbl        ( this, ResId( FT_TEXT_FLOW ) ),
//STRIP001     aTextFlowBox        ( this, ResId( LB_TEXT_FLOW ) ),
//STRIP001 
//STRIP001 	aInsideText			( 		ResId( STR_INSIDE ) ),
//STRIP001 	aOutsideText		( 		ResId( STR_OUTSIDE ) ),
//STRIP001 	aPrintRangeQueryText(		ResId( STR_QUERY_PRINTRANGE ) ),
//STRIP001 
//STRIP001 	bLandscape			( FALSE ),
//STRIP001 	eMode				( SVX_PAGE_MODE_STANDARD ),
//STRIP001 	ePaperStart			( SVX_PAPER_A3 ),
//STRIP001 	ePaperEnd 			( SVX_PAPER_DL ),
//STRIP001 	pImpl				( new SvxPage_Impl )
//STRIP001 
//STRIP001 {
//STRIP001 	bBorderModified = FALSE;
//STRIP001 	FreeResource();
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001     SvtLanguageOptions aLangOptions;
//STRIP001     sal_Bool bCJK = aLangOptions.IsAsianTypographyEnabled();
//STRIP001     sal_Bool bCTL = aLangOptions.IsCTLFontEnabled();
//STRIP001     sal_Bool bWeb = sal_False;
//STRIP001     const SfxPoolItem* pItem;
//STRIP001 
//STRIP001     SfxObjectShell* pShell;
//STRIP001     if(SFX_ITEM_SET == rAttr.GetItemState(SID_HTML_MODE, FALSE, &pItem) ||
//STRIP001 		( 0 != (pShell = SfxObjectShell::Current()) &&
//STRIP001 					0 != (pItem = pShell->GetItem(SID_HTML_MODE))))
//STRIP001         bWeb = 0 != (((const SfxUInt16Item*)pItem)->GetValue() & HTMLMODE_ON);
//STRIP001 
//STRIP001     // #109989# get the HTML export setting from configuration.
//STRIP001     // !! This is a hack, see comments in SvxHtmlExportModeConfigItem_Impl class above.
//STRIP001     bool bHTML32 = SvxHtmlExportModeConfigItem_Impl().IsExportModeHTML32();
//STRIP001 
//STRIP001     //  fill text flow listbox with valid entries
//STRIP001     aTextFlowBox.InsertEntryValue( SVX_RESSTR( RID_SVXSTR_PAGEDIR_LTR_HORI ), FRMDIR_HORI_LEFT_TOP );
//STRIP001     if( bCTL )
//STRIP001         aTextFlowBox.InsertEntryValue( SVX_RESSTR( RID_SVXSTR_PAGEDIR_RTL_HORI ), FRMDIR_HORI_RIGHT_TOP );
//STRIP001     // #109989# do not show vertical directions in Writer/Web
//STRIP001     if( !bWeb )
//STRIP001     {
//STRIP001         if( bCJK )
//STRIP001             aTextFlowBox.InsertEntryValue( SVX_RESSTR( RID_SVXSTR_PAGEDIR_RTL_VERT ), FRMDIR_VERT_TOP_RIGHT );
//STRIP001 //        if( ... )
//STRIP001 //            aTextFlowBox.InsertEntryValue( SVX_RESSTR( RID_SVXSTR_PAGEDIR_LTR_VERT ), FRMDIR_VERT_TOP_LEFT );
//STRIP001     }
//STRIP001 
//STRIP001     // #109989# show the text direction box in Writer/Web too, but only, if HTML export mode is not HTML3.2.
//STRIP001     if( !(bWeb && bHTML32) && (bCJK || bCTL) &&
//STRIP001         SFX_ITEM_UNKNOWN < rAttr.GetItemState(GetWhich( SID_ATTR_FRAMEDIRECTION )))
//STRIP001     {
//STRIP001         aTextFlowLbl.Show();
//STRIP001         aTextFlowBox.Show();
//STRIP001         aTextFlowBox.SetSelectHdl(LINK(this, SvxPageDescPage, FrameDirectionModify_Impl ));
//STRIP001 
//STRIP001         aBspWin.EnableFrameDirection(sal_True);
//STRIP001     }
//STRIP001     Init_Impl();
//STRIP001 
//STRIP001 	FieldUnit eFUnit = GetModuleFieldUnit( &rAttr );
//STRIP001 	SetFieldUnit( aLeftMarginEdit, eFUnit );
//STRIP001 	SetFieldUnit( aRightMarginEdit, eFUnit );
//STRIP001 	SetFieldUnit( aTopMarginEdit, eFUnit );
//STRIP001 	SetFieldUnit( aBottomMarginEdit, eFUnit );
//STRIP001 	SetFieldUnit( aPaperWidthEdit, eFUnit );
//STRIP001 	SetFieldUnit( aPaperHeightEdit, eFUnit );
//STRIP001 
//STRIP001 	Printer* pDefPrinter = 0;
//STRIP001 	BOOL bPrinterDel = FALSE;
//STRIP001 
//STRIP001 	if ( SfxViewShell::Current() && SfxViewShell::Current()->GetPrinter() )
//STRIP001 		pDefPrinter = (Printer*)SfxViewShell::Current()->GetPrinter();
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pDefPrinter = new Printer;
//STRIP001 		bPrinterDel = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	MapMode aOldMode = pDefPrinter->GetMapMode();
//STRIP001 	pDefPrinter->SetMapMode( MAP_TWIP );
//STRIP001 
//STRIP001 	// First- und Last-Werte f"ur die R"ander setzen
//STRIP001 	Size aPaperSize = pDefPrinter->GetPaperSize();
//STRIP001 	Size aPrintSize = pDefPrinter->GetOutputSize();
//STRIP001 	/*
//STRIP001 	 * einen Punkt ( 0,0 ) in logische Koordinaten zu konvertieren,
//STRIP001 	 * sieht aus wie Unsinn; ist aber sinnvoll, wenn der Ursprung des
//STRIP001 	 * Koordinatensystems verschoben ist.
//STRIP001 	 */
//STRIP001 	Point aPrintOffset = pDefPrinter->GetPageOffset() -
//STRIP001 						 pDefPrinter->PixelToLogic( Point() );
//STRIP001 	pDefPrinter->SetMapMode( aOldMode );
//STRIP001 
//STRIP001 	if ( bPrinterDel )
//STRIP001 		delete pDefPrinter;
//STRIP001 	long nOffset = !aPrintOffset.X() && !aPrintOffset.Y() ? 0 : PRINT_OFFSET;
//STRIP001 	aLeftMarginEdit.SetFirst( aLeftMarginEdit.Normalize( aPrintOffset.X() ), FUNIT_TWIP );
//STRIP001 	nFirstLeftMargin = aLeftMarginEdit.GetFirst();
//STRIP001 	aRightMarginEdit.SetFirst( aRightMarginEdit.Normalize(
//STRIP001 		aPaperSize.Width() - aPrintSize.Width() - aPrintOffset.X() + nOffset ), FUNIT_TWIP);
//STRIP001 	nFirstRightMargin = aRightMarginEdit.GetFirst();
//STRIP001 	aTopMarginEdit.SetFirst( aTopMarginEdit.Normalize( aPrintOffset.Y() ), FUNIT_TWIP );
//STRIP001 	nFirstTopMargin = aTopMarginEdit.GetFirst();
//STRIP001 	aBottomMarginEdit.SetFirst( aBottomMarginEdit.Normalize(
//STRIP001 		aPaperSize.Height() - aPrintSize.Height() - aPrintOffset.Y() + nOffset ), FUNIT_TWIP );
//STRIP001 	nFirstBottomMargin = aBottomMarginEdit.GetFirst();
//STRIP001 	aLeftMarginEdit.SetLast( aLeftMarginEdit.Normalize(
//STRIP001 		aPrintOffset.X() + aPrintSize.Width() ), FUNIT_TWIP );
//STRIP001 	nLastLeftMargin = aLeftMarginEdit.GetLast();
//STRIP001 	aRightMarginEdit.SetLast( aRightMarginEdit.Normalize(
//STRIP001 		aPrintOffset.X() + aPrintSize.Width() ), FUNIT_TWIP );
//STRIP001 	nLastRightMargin = aRightMarginEdit.GetLast();
//STRIP001 	aTopMarginEdit.SetLast( aTopMarginEdit.Normalize(
//STRIP001 		aPrintOffset.Y() + aPrintSize.Height() ), FUNIT_TWIP );
//STRIP001 	nLastTopMargin = aTopMarginEdit.GetLast();
//STRIP001 	aBottomMarginEdit.SetLast( aBottomMarginEdit.Normalize(
//STRIP001 		aPrintOffset.Y() + aPrintSize.Height() ), FUNIT_TWIP );
//STRIP001 	nLastBottomMargin = aBottomMarginEdit.GetLast();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxPageDescPage::~SvxPageDescPage()
//STRIP001 {
//STRIP001 	delete pImpl;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPageDescPage::Init_Impl()
//STRIP001 {
//STRIP001 	aLeftText = aLeftMarginLbl.GetText();
//STRIP001 	aRightText = aRightMarginLbl.GetText();
//STRIP001 
//STRIP001 		// Handler einstellen
//STRIP001 	aLayoutBox.SetSelectHdl( LINK( this, SvxPageDescPage, LayoutHdl_Impl ) );
//STRIP001 
//STRIP001 	aPaperTrayBox.SetGetFocusHdl(
//STRIP001 		LINK( this, SvxPageDescPage, PaperBinHdl_Impl ) );
//STRIP001 	aPaperSizeBox.SetSelectHdl(
//STRIP001 		LINK( this, SvxPageDescPage, PaperSizeSelect_Impl ) );
//STRIP001 	aPaperWidthEdit.SetModifyHdl(
//STRIP001 		LINK( this, SvxPageDescPage, PaperSizeModify_Impl ) );
//STRIP001 	aPaperHeightEdit.SetModifyHdl(
//STRIP001 		LINK( this, SvxPageDescPage, PaperSizeModify_Impl ) );
//STRIP001 	aLandscapeBtn.SetClickHdl(
//STRIP001 		LINK( this, SvxPageDescPage, SwapOrientation_Impl ) );
//STRIP001 	aPortraitBtn.SetClickHdl(
//STRIP001 		LINK( this, SvxPageDescPage, SwapOrientation_Impl ) );
//STRIP001 
//STRIP001 	Link aLink = LINK( this, SvxPageDescPage, BorderModify_Impl );
//STRIP001 	aLeftMarginEdit.SetModifyHdl( aLink );
//STRIP001 	aRightMarginEdit.SetModifyHdl( aLink );
//STRIP001 	aTopMarginEdit.SetModifyHdl( aLink );
//STRIP001 	aBottomMarginEdit.SetModifyHdl( aLink );
//STRIP001 
//STRIP001 	aLink = LINK( this, SvxPageDescPage, RangeHdl_Impl );
//STRIP001 	aPaperWidthEdit.SetLoseFocusHdl( aLink );
//STRIP001 	aPaperHeightEdit.SetLoseFocusHdl( aLink );
//STRIP001 	aLeftMarginEdit.SetLoseFocusHdl( aLink );
//STRIP001 	aRightMarginEdit.SetLoseFocusHdl( aLink );
//STRIP001 	aTopMarginEdit.SetLoseFocusHdl( aLink );
//STRIP001 	aBottomMarginEdit.SetLoseFocusHdl( aLink );
//STRIP001 
//STRIP001 	aHorzBox.SetClickHdl( LINK( this, SvxPageDescPage, CenterHdl_Impl ) );
//STRIP001 	aVertBox.SetClickHdl( LINK( this, SvxPageDescPage, CenterHdl_Impl ) );
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPageDescPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	SfxItemPool* pPool = rSet.GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 	SfxMapUnit eUnit = pPool->GetMetric( GetWhich( SID_ATTR_LRSPACE ) );
//STRIP001 
//STRIP001 	// R"ander (Links/Rechts) einstellen
//STRIP001 	const SfxPoolItem* pItem = GetItem( rSet, SID_ATTR_LRSPACE );
//STRIP001 
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		const SvxLRSpaceItem& rLRSpace = (const SvxLRSpaceItem&)*pItem;
//STRIP001 		SetMetricValue( aLeftMarginEdit, rLRSpace.GetLeft(), eUnit );
//STRIP001 		aBspWin.SetLeft(
//STRIP001 			(USHORT)ConvertLong_Impl( (long)rLRSpace.GetLeft(), eUnit ) );
//STRIP001 		SetMetricValue( aRightMarginEdit, rLRSpace.GetRight(), eUnit );
//STRIP001 		aBspWin.SetRight(
//STRIP001 			(USHORT)ConvertLong_Impl( (long)rLRSpace.GetRight(), eUnit ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	// R"ander (Oben/Unten) einstellen
//STRIP001 	pItem = GetItem( rSet, SID_ATTR_ULSPACE );
//STRIP001 
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		const SvxULSpaceItem& rULSpace = (const SvxULSpaceItem&)*pItem;
//STRIP001 		SetMetricValue( aTopMarginEdit, rULSpace.GetUpper(), eUnit );
//STRIP001 		aBspWin.SetTop(
//STRIP001 			(USHORT)ConvertLong_Impl( (long)rULSpace.GetUpper(), eUnit ) );
//STRIP001 		SetMetricValue( aBottomMarginEdit, rULSpace.GetLower(), eUnit );
//STRIP001 		aBspWin.SetBottom(
//STRIP001 			(USHORT)ConvertLong_Impl( (long)rULSpace.GetLower(), eUnit ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Printer f"ur die Sch"achte besorgen
//STRIP001 	Printer* pDefPrinter = 0;
//STRIP001 	BOOL bPrinterDel = FALSE;
//STRIP001 
//STRIP001 	if ( SfxViewShell::Current() && SfxViewShell::Current()->GetPrinter() )
//STRIP001 		pDefPrinter = (Printer*)SfxViewShell::Current()->GetPrinter();
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pDefPrinter = new Printer;
//STRIP001 		bPrinterDel = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// allgemeine Seitendaten
//STRIP001 	SvxNumType eNumType = SVX_ARABIC;
//STRIP001 	bLandscape = ( pDefPrinter->GetOrientation() == ORIENTATION_LANDSCAPE );
//STRIP001 	USHORT nUse = (USHORT)SVX_PAGE_ALL;
//STRIP001 	pItem = GetItem( rSet, SID_ATTR_PAGE );
//STRIP001 
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		const SvxPageItem& rItem = (const SvxPageItem&)*pItem;
//STRIP001 		eNumType = rItem.GetNumType();
//STRIP001 		nUse = (SvxPageUsage)rItem.GetPageUsage();
//STRIP001 		bLandscape = rItem.IsLandscape();
//STRIP001 	}
//STRIP001 
//STRIP001 	// Ausrichtung
//STRIP001 	aLayoutBox.SelectEntryPos( ::PageUsageToPos_Impl( nUse ) );
//STRIP001 	aBspWin.SetUsage( nUse );
//STRIP001 	LayoutHdl_Impl( 0 );
//STRIP001 
//STRIP001 	// Numerierungsart der Seitenvorlage einstellen
//STRIP001 	aNumberFormatBox.SelectEntryPos( eNumType );
//STRIP001 
//STRIP001 	// Aktueller Papierschacht
//STRIP001 	aPaperTrayBox.Clear();
//STRIP001 	BYTE nPaperBin = PAPERBIN_PRINTER_SETTINGS;
//STRIP001 	pItem = GetItem( rSet, SID_ATTR_PAGE_PAPERBIN );
//STRIP001 
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		nPaperBin = ( (const SvxPaperBinItem*)pItem )->GetValue();
//STRIP001 
//STRIP001 		if ( nPaperBin >= pDefPrinter->GetPaperBinCount() )
//STRIP001 			nPaperBin = PAPERBIN_PRINTER_SETTINGS;
//STRIP001 	}
//STRIP001 
//STRIP001 	String aBinName;
//STRIP001 
//STRIP001 	if ( PAPERBIN_PRINTER_SETTINGS	== nPaperBin )
//STRIP001 		aBinName = SVX_RESSTR( RID_SVXSTR_PAPERBIN_SETTINGS );
//STRIP001 	else
//STRIP001 		aBinName = pDefPrinter->GetPaperBinName( (USHORT)nPaperBin );
//STRIP001 
//STRIP001 	USHORT nEntryPos = aPaperTrayBox.InsertEntry( aBinName );
//STRIP001 	aPaperTrayBox.SetEntryData( nEntryPos, (void*)(ULONG)nPaperBin );
//STRIP001 	aPaperTrayBox.SelectEntry( aBinName );
//STRIP001 
//STRIP001 	// Size rausholen
//STRIP001 	Size aPaperSize = SvxPaperInfo::GetPaperSize( pDefPrinter );
//STRIP001 	pItem = GetItem( rSet, SID_ATTR_PAGE_SIZE );
//STRIP001 
//STRIP001 	if ( pItem )
//STRIP001 		aPaperSize = ( (const SvxSizeItem*)pItem )->GetSize();
//STRIP001 
//STRIP001 	FASTBOOL bOrientationSupport =
//STRIP001 		pDefPrinter->HasSupport( SUPPORT_SET_ORIENTATION );
//STRIP001 #ifdef OS2
//STRIP001 	// unter OS/2 wird bei HasSupport() immer TRUE returned
//STRIP001 	// aber nur als Dummy, deshalb FALSE
//STRIP001 	bOrientationSupport = FALSE;
//STRIP001 #endif
//STRIP001 
//STRIP001 	if ( !bOrientationSupport &&
//STRIP001 		 aPaperSize.Width() > aPaperSize.Height() )
//STRIP001 		bLandscape = TRUE;
//STRIP001 
//STRIP001 	aLandscapeBtn.Check( bLandscape );
//STRIP001 	aPortraitBtn.Check( !bLandscape );
//STRIP001 
//STRIP001 	aBspWin.SetSize( Size( ConvertLong_Impl( aPaperSize.Width(), eUnit ),
//STRIP001 						   ConvertLong_Impl( aPaperSize.Height(), eUnit ) ) );
//STRIP001 
//STRIP001 	// Werte in die Edits eintragen
//STRIP001 	SetMetricValue( aPaperHeightEdit, aPaperSize.Height(), eUnit );
//STRIP001 	SetMetricValue( aPaperWidthEdit, aPaperSize.Width(), eUnit );
//STRIP001 	aPaperSizeBox.Clear();
//STRIP001 
//STRIP001 	// Papierformate
//STRIP001 	Size aTmpSize = aPaperSize;
//STRIP001 
//STRIP001 	if ( bLandscape )
//STRIP001 		Swap( aTmpSize );
//STRIP001 	// aktuelles Format
//STRIP001 	SvxPaper ePaper = SvxPaperInfo::GetPaper( aTmpSize, (MapUnit)eUnit, TRUE );
//STRIP001 	USHORT nActPos = LISTBOX_ENTRY_NOTFOUND;
//STRIP001 	USHORT nAryId = RID_SVXSTRARY_PAPERSIZE_STD;
//STRIP001 
//STRIP001 	if ( ePaperStart != SVX_PAPER_A3 )
//STRIP001 		nAryId = RID_SVXSTRARY_PAPERSIZE_DRAW;
//STRIP001 	ResStringArray aPaperAry( SVX_RES( nAryId ) );
//STRIP001 	USHORT nCnt = aPaperAry.Count();
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < nCnt; ++i )
//STRIP001 	{
//STRIP001 		String aStr = aPaperAry.GetString(i);
//STRIP001 		SvxPaper eSize = (SvxPaper)aPaperAry.GetValue(i);
//STRIP001 		USHORT nPos = aPaperSizeBox.InsertEntry( aStr );
//STRIP001 		aPaperSizeBox.SetEntryData( nPos, (void*)(ULONG)eSize );
//STRIP001 
//STRIP001 		if ( eSize == ePaper )
//STRIP001 			nActPos = nPos;
//STRIP001 	}
//STRIP001 	// aktuelles Papierformat selektieren
//STRIP001 	aPaperSizeBox.SelectEntryPos( nActPos );
//STRIP001 
//STRIP001 	// ggf. angelegten Printer wieder l"oschen
//STRIP001 	if ( bPrinterDel )
//STRIP001 		delete pDefPrinter;
//STRIP001 
//STRIP001 	// Applikationsspezifisch
//STRIP001 
//STRIP001 	switch ( eMode )
//STRIP001 	{
//STRIP001 		case SVX_PAGE_MODE_CENTER:
//STRIP001 		{
//STRIP001             aTblAlignFT.Show();
//STRIP001             aHorzBox.Show();
//STRIP001 			aVertBox.Show();
//STRIP001             DisableVerticalPageDir();
//STRIP001 
//STRIP001 			// Horizontale Ausrichtung
//STRIP001 			pItem = GetItem( rSet, SID_ATTR_PAGE_EXT1 );
//STRIP001 			aHorzBox.Check( pItem ? ( (const SfxBoolItem*)pItem )->GetValue()
//STRIP001 								  : FALSE );
//STRIP001 
//STRIP001 			// Vertikale Ausrichtung
//STRIP001 			pItem = GetItem( rSet, SID_ATTR_PAGE_EXT2 );
//STRIP001 			aVertBox.Check( pItem ? ( (const SfxBoolItem*)pItem )->GetValue()
//STRIP001 								  : FALSE );
//STRIP001 
//STRIP001 			// Beispiel-Fenster auf Tabelle setzen
//STRIP001 			aBspWin.SetTable( TRUE );
//STRIP001 			aBspWin.SetHorz( aHorzBox.IsChecked() );
//STRIP001 			aBspWin.SetVert( aVertBox.IsChecked() );
//STRIP001 
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SVX_PAGE_MODE_PRESENTATION:
//STRIP001 		{
//STRIP001             DisableVerticalPageDir();
//STRIP001 			aAdaptBox.Show();
//STRIP001 			pItem = GetItem( rSet, SID_ATTR_PAGE_EXT1 );
//STRIP001 			aAdaptBox.Check( pItem ?
//STRIP001 				( (const SfxBoolItem*)pItem )->GetValue() : FALSE );
//STRIP001 
//STRIP001 			//!!! hidden, weil von StarDraw nicht implementiert
//STRIP001 			aLayoutBox.Hide();
//STRIP001 			aPageText.Hide();
//STRIP001 
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	// im Beispiel Hintergrund und Umrandung anzeigen
//STRIP001 	ResetBackground_Impl( rSet );
//STRIP001 //!	UpdateExample_Impl();
//STRIP001 	RangeHdl_Impl( 0 );
//STRIP001 
//STRIP001 	// Header Footer anzeigen
//STRIP001 	InitHeadFoot_Impl( rSet );
//STRIP001 
//STRIP001 	// R"ander auf Hoch/Quer updaten, dann Beispiel updaten
//STRIP001 	bBorderModified = FALSE;
//STRIP001 	SwapFirstValues_Impl( FALSE );
//STRIP001 	UpdateExample_Impl();
//STRIP001 
//STRIP001 	// Alte Werte sichern
//STRIP001 	aLeftMarginEdit.SaveValue();
//STRIP001 	aRightMarginEdit.SaveValue();
//STRIP001 	aTopMarginEdit.SaveValue();
//STRIP001 	aBottomMarginEdit.SaveValue();
//STRIP001 	aLayoutBox.SaveValue();
//STRIP001 	aNumberFormatBox.SaveValue();
//STRIP001 	aPaperSizeBox.SaveValue();
//STRIP001 	aPaperWidthEdit.SaveValue();
//STRIP001 	aPaperHeightEdit.SaveValue();
//STRIP001 	aPortraitBtn.SaveValue();
//STRIP001 	aLandscapeBtn.SaveValue();
//STRIP001 	aPaperTrayBox.SaveValue();
//STRIP001 	aVertBox.SaveValue();
//STRIP001 	aHorzBox.SaveValue();
//STRIP001     aAdaptBox.SaveValue();
//STRIP001 
//STRIP001 	CheckMarginEdits( true );
//STRIP001 
//STRIP001 	// Registerhaltigkeit
//STRIP001 	if(SFX_ITEM_SET == rSet.GetItemState(SID_SWREGISTER_MODE))
//STRIP001 	{
//STRIP001 		aRegisterCB.Check(((const SfxBoolItem&)rSet.Get(
//STRIP001 								SID_SWREGISTER_MODE)).GetValue());
//STRIP001 		aRegisterCB.SaveValue();
//STRIP001 		RegisterModify(&aRegisterCB);
//STRIP001 	}
//STRIP001 	if(SFX_ITEM_SET == rSet.GetItemState(SID_SWREGISTER_COLLECTION))
//STRIP001 	{
//STRIP001 		aRegisterLB.SelectEntry(
//STRIP001 				((const SfxStringItem&)rSet.Get(SID_SWREGISTER_COLLECTION)).GetValue());
//STRIP001 		aRegisterLB.SaveValue();
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxItemState eState = rSet.GetItemState( GetWhich( SID_ATTR_FRAMEDIRECTION ),
//STRIP001 												TRUE, &pItem );
//STRIP001 	if( SFX_ITEM_UNKNOWN != eState )
//STRIP001 	{
//STRIP001         sal_uInt32 nVal  = SFX_ITEM_SET == eState
//STRIP001 								? ((SvxFrameDirectionItem*)pItem)->GetValue()
//STRIP001                                 : 0;
//STRIP001         aTextFlowBox.SelectEntryValue( static_cast< SvxFrameDirection >( nVal ) );
//STRIP001 		aTextFlowBox.SaveValue();
//STRIP001         aBspWin.SetFrameDirection(nVal);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPageDescPage::FillUserData()
//STRIP001 {
//STRIP001 	if ( SVX_PAGE_MODE_PRESENTATION == eMode )
//STRIP001 		SetUserData( UniString::CreateFromInt32( (sal_Int32)aAdaptBox.IsChecked() ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxPageDescPage::FillItemSet( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 	const SfxItemSet& rOldSet = GetItemSet();
//STRIP001 	SfxItemPool* pPool = rOldSet.GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_LRSPACE );
//STRIP001 	SfxMapUnit eUnit = pPool->GetMetric( nWhich );
//STRIP001 	const SfxPoolItem* pOld = 0;
//STRIP001 
//STRIP001 	// alten linken und rechten Rand kopieren
//STRIP001 	SvxLRSpaceItem aMargin( (const SvxLRSpaceItem&)rOldSet.Get( nWhich ) );
//STRIP001 
//STRIP001 	// alten  oberen und unteren Rand kopieren
//STRIP001 	nWhich = GetWhich( SID_ATTR_ULSPACE );
//STRIP001 	SvxULSpaceItem aTopMargin( (const SvxULSpaceItem&)rOldSet.Get( nWhich ) );
//STRIP001 
//STRIP001 	if ( aLeftMarginEdit.GetText() != aLeftMarginEdit.GetSavedValue() )
//STRIP001 	{
//STRIP001 		aMargin.SetLeft( (USHORT)GetCoreValue( aLeftMarginEdit, eUnit ) );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( aRightMarginEdit.GetText() != aRightMarginEdit.GetSavedValue() )
//STRIP001 	{
//STRIP001 		aMargin.SetRight( (USHORT)GetCoreValue( aRightMarginEdit, eUnit ) );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Linken und rechten Rand setzen
//STRIP001 	if ( bModified )
//STRIP001 	{
//STRIP001 		pOld = GetOldItem( rSet, SID_ATTR_LRSPACE );
//STRIP001 
//STRIP001 		if ( !pOld || !( *(const SvxLRSpaceItem*)pOld == aMargin ) )
//STRIP001 			rSet.Put( aMargin );
//STRIP001 		else
//STRIP001 			bModified = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bMod = FALSE;
//STRIP001 
//STRIP001 	if ( aTopMarginEdit.GetText() != aTopMarginEdit.GetSavedValue() )
//STRIP001 	{
//STRIP001 		aTopMargin.SetUpper( (USHORT)GetCoreValue( aTopMarginEdit, eUnit ) );
//STRIP001 		bMod |= TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( aBottomMarginEdit.GetText() != aBottomMarginEdit.GetSavedValue() )
//STRIP001 	{
//STRIP001 		aTopMargin.SetLower( (USHORT)GetCoreValue( aBottomMarginEdit, eUnit ) );
//STRIP001 		bMod |= TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// unteren oberen Rand setzen
//STRIP001 	//
//STRIP001 	if ( bMod )
//STRIP001 	{
//STRIP001 		pOld = GetOldItem( rSet, SID_ATTR_ULSPACE );
//STRIP001 
//STRIP001 		if ( !pOld || !( *(const SvxULSpaceItem*)pOld == aTopMargin ) )
//STRIP001 		{
//STRIP001 			bModified |= TRUE;
//STRIP001 			rSet.Put( aTopMargin );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Druckerschacht
//STRIP001 	nWhich = GetWhich( SID_ATTR_PAGE_PAPERBIN );
//STRIP001 	USHORT nPos = aPaperTrayBox.GetSelectEntryPos();
//STRIP001 	USHORT nBin = (USHORT)(ULONG)aPaperTrayBox.GetEntryData( nPos );
//STRIP001 	pOld = GetOldItem( rSet, SID_ATTR_PAGE_PAPERBIN );
//STRIP001 
//STRIP001 	if ( !pOld || ( (const SvxPaperBinItem*)pOld )->GetValue() != nBin )
//STRIP001 	{
//STRIP001 		rSet.Put( SvxPaperBinItem( nWhich, (BYTE)nBin ) );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	nPos = aPaperSizeBox.GetSelectEntryPos();
//STRIP001 	SvxPaper ePaper = (SvxPaper)(ULONG)aPaperSizeBox.GetEntryData( nPos );
//STRIP001 	const USHORT nOld = aPaperSizeBox.GetSavedValue();
//STRIP001 	BOOL bChecked = aLandscapeBtn.IsChecked();
//STRIP001 
//STRIP001 	if ( SVX_PAPER_USER == ePaper )
//STRIP001 	{
//STRIP001 		if ( nOld != nPos						||
//STRIP001 			 aPaperWidthEdit.IsValueModified()  ||
//STRIP001 			 aPaperHeightEdit.IsValueModified() ||
//STRIP001 			 bChecked != aLandscapeBtn.GetSavedValue() )
//STRIP001 		{
//STRIP001 			Size aSize( GetCoreValue( aPaperWidthEdit, eUnit ),
//STRIP001 						GetCoreValue( aPaperHeightEdit, eUnit ) );
//STRIP001 			pOld = GetOldItem( rSet, SID_ATTR_PAGE_SIZE );
//STRIP001 
//STRIP001 			if ( !pOld || ( (const SvxSizeItem*)pOld )->GetSize() != aSize )
//STRIP001 			{
//STRIP001 				rSet.Put( SvxSizeItem( GetWhich(SID_ATTR_PAGE_SIZE), aSize ) );
//STRIP001 				bModified |= TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( nOld != nPos || bChecked != aLandscapeBtn.GetSavedValue() )
//STRIP001 		{
//STRIP001 			Size aSize( SvxPaperInfo::GetPaperSize( ePaper, (MapUnit)eUnit ) );
//STRIP001 
//STRIP001 			if ( bChecked )
//STRIP001 				Swap( aSize );
//STRIP001 
//STRIP001 			pOld = GetOldItem( rSet, SID_ATTR_PAGE_SIZE );
//STRIP001 
//STRIP001 			if ( !pOld || ( (const SvxSizeItem*)pOld )->GetSize() != aSize )
//STRIP001 			{
//STRIP001 				rSet.Put( SvxSizeItem( GetWhich(SID_ATTR_PAGE_SIZE), aSize ) );
//STRIP001 				bModified |= TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// sonstiges Zeug der Page
//STRIP001 	nWhich = GetWhich( SID_ATTR_PAGE );
//STRIP001 	SvxPageItem aPage( (const SvxPageItem&)rOldSet.Get( nWhich ) );
//STRIP001 	bMod = 	aLayoutBox.GetSelectEntryPos()  != aLayoutBox.GetSavedValue();
//STRIP001 
//STRIP001 	if ( bMod )
//STRIP001 		aPage.SetPageUsage(
//STRIP001 			::PosToPageUsage_Impl( aLayoutBox.GetSelectEntryPos() ) );
//STRIP001 
//STRIP001 	if ( bChecked != aLandscapeBtn.GetSavedValue() )
//STRIP001 	{
//STRIP001 		aPage.SetLandscape(bChecked);
//STRIP001 		bMod |= TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Einstellen der Numerierungsart der Seite
//STRIP001 	nPos = aNumberFormatBox.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if ( nPos != aNumberFormatBox.GetSavedValue() )
//STRIP001 	{
//STRIP001 		aPage.SetNumType( (SvxNumType)nPos );
//STRIP001 		bMod |= TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bMod )
//STRIP001 	{
//STRIP001 		pOld = GetOldItem( rSet, SID_ATTR_PAGE );
//STRIP001 
//STRIP001 		if ( !pOld || !( *(const SvxPageItem*)pOld == aPage ) )
//STRIP001 		{
//STRIP001 			rSet.Put( aPage );
//STRIP001 			bModified |= TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( SFX_ITEM_DEFAULT == rOldSet.GetItemState( nWhich ) )
//STRIP001 		rSet.ClearItem( nWhich );
//STRIP001 	else
//STRIP001 		rSet.Put( rOldSet.Get( nWhich ) );
//STRIP001 
//STRIP001 	// Modispezifische Controls auswerten
//STRIP001 
//STRIP001 	switch ( eMode )
//STRIP001 	{
//STRIP001 		case SVX_PAGE_MODE_CENTER:
//STRIP001 		{
//STRIP001 			if ( aHorzBox.IsChecked() != aHorzBox.GetSavedValue() )
//STRIP001 			{
//STRIP001 				SfxBoolItem aHorz( GetWhich( SID_ATTR_PAGE_EXT1 ),
//STRIP001 								   aHorzBox.IsChecked() );
//STRIP001 				rSet.Put( aHorz );
//STRIP001 				bModified |= TRUE;
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( aVertBox.IsChecked() != aVertBox.GetSavedValue() )
//STRIP001 			{
//STRIP001 				SfxBoolItem aVert( GetWhich( SID_ATTR_PAGE_EXT2 ),
//STRIP001 								   aVertBox.IsChecked() );
//STRIP001 				rSet.Put( aVert );
//STRIP001 				bModified |= TRUE;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SVX_PAGE_MODE_PRESENTATION:
//STRIP001 		{
//STRIP001 			// immer putten, damit Draw das auswerten kann
//STRIP001 			rSet.Put( SfxBoolItem( GetWhich( SID_ATTR_PAGE_EXT1 ),
//STRIP001 					  aAdaptBox.IsChecked() ) );
//STRIP001 			bModified |= TRUE;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		// bei Standard tut sich nichts
//STRIP001 	}
//STRIP001 
//STRIP001 	if(aRegisterCB.IsVisible() &&
//STRIP001 		(aRegisterCB.IsChecked() || aRegisterCB.GetSavedValue() != aRegisterCB.IsChecked()))
//STRIP001 	{
//STRIP001 		const SfxBoolItem& rRegItem = (const SfxBoolItem&)rOldSet.Get(SID_SWREGISTER_MODE);
//STRIP001 		SfxBoolItem* pRegItem = (SfxBoolItem*)rRegItem.Clone();
//STRIP001 		BOOL bCheck = aRegisterCB.IsChecked();
//STRIP001 		pRegItem->SetValue(bCheck);
//STRIP001 		rSet.Put(*pRegItem);
//STRIP001 		bModified |= TRUE;
//STRIP001 		if(bCheck)
//STRIP001 		{
//STRIP001 			bModified |= TRUE;
//STRIP001 			rSet.Put(SfxStringItem(SID_SWREGISTER_COLLECTION,
//STRIP001 							aRegisterLB.GetSelectEntry()));
//STRIP001 		}
//STRIP001 		delete pRegItem;
//STRIP001 	}
//STRIP001 
//STRIP001     SvxFrameDirection eDirection = aTextFlowBox.GetSelectEntryValue();
//STRIP001     if( aTextFlowBox.IsVisible() && (eDirection != aTextFlowBox.GetSavedValue()) )
//STRIP001 	{
//STRIP001         rSet.Put( SvxFrameDirectionItem( eDirection, GetWhich( SID_ATTR_FRAMEDIRECTION ) ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPageDescPage, LayoutHdl_Impl, ListBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	// innen au\sen umschalten
//STRIP001 	const USHORT nPos = PosToPageUsage_Impl( aLayoutBox.GetSelectEntryPos() );
//STRIP001 
//STRIP001 	if ( nPos == SVX_PAGE_MIRROR )
//STRIP001 	{
//STRIP001 		if ( aLeftMarginLbl.GetText() != aInsideText )
//STRIP001 			aLeftMarginLbl.SetText( aInsideText );
//STRIP001 
//STRIP001 		if ( aRightMarginLbl.GetText() != aOutsideText )
//STRIP001 			aRightMarginLbl.SetText( aOutsideText );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( aLeftMarginLbl.GetText() != aLeftText )
//STRIP001 			aLeftMarginLbl.SetText( aLeftText );
//STRIP001 
//STRIP001 		if ( aRightMarginLbl.GetText() != aRightText )
//STRIP001 			aRightMarginLbl.SetText( aRightText );
//STRIP001 	}
//STRIP001 	UpdateExample_Impl();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPageDescPage, PaperBinHdl_Impl, ListBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	if ( aPaperTrayBox.GetEntryCount() > 1 )
//STRIP001 		// schon gef"ullt
//STRIP001 		return 0;
//STRIP001 	Printer* pDefPrinter = 0;
//STRIP001 	BOOL bPrinterDel = FALSE;
//STRIP001 
//STRIP001 	if ( SfxViewShell::Current() && SfxViewShell::Current()->GetPrinter() )
//STRIP001 		pDefPrinter = (Printer*)SfxViewShell::Current()->GetPrinter();
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pDefPrinter = new Printer;
//STRIP001 		bPrinterDel = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Schacht-Box initialisieren
//STRIP001 	String aOldName = aPaperTrayBox.GetSelectEntry();
//STRIP001 	aPaperTrayBox.SetUpdateMode( FALSE );
//STRIP001 	aPaperTrayBox.Clear();
//STRIP001 	USHORT nEntryPos = aPaperTrayBox.InsertEntry(
//STRIP001 		SVX_RESSTR( RID_SVXSTR_PAPERBIN_SETTINGS ) );
//STRIP001 	aPaperTrayBox.SetEntryData( nEntryPos,
//STRIP001 		(void*)(ULONG)PAPERBIN_PRINTER_SETTINGS );
//STRIP001 	String aPaperBin( SVX_RES( RID_SVXSTR_PAPERBIN ) );
//STRIP001 	USHORT nBinCount = pDefPrinter->GetPaperBinCount();
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < nBinCount; ++i )
//STRIP001 	{
//STRIP001 		String aName = pDefPrinter->GetPaperBinName(i);
//STRIP001 
//STRIP001 		if ( !aName.Len() )
//STRIP001 		{
//STRIP001 			aName = aPaperBin;
//STRIP001 			aName.Append( sal_Unicode(' ') );
//STRIP001 			aName.Append( UniString::CreateFromInt32( i+1 ) );
//STRIP001 		}
//STRIP001 		nEntryPos = aPaperTrayBox.InsertEntry( aName );
//STRIP001 		aPaperTrayBox.SetEntryData( nEntryPos, (void*)(ULONG)i );
//STRIP001 	}
//STRIP001 	aPaperTrayBox.SelectEntry( aOldName );
//STRIP001 	aPaperTrayBox.SetUpdateMode( TRUE );
//STRIP001 
//STRIP001 	if ( bPrinterDel )
//STRIP001 		delete pDefPrinter;
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPageDescPage, PaperSizeSelect_Impl, ListBox *, pBox )
//STRIP001 {
//STRIP001 	const USHORT nPos = pBox->GetSelectEntryPos();
//STRIP001 	SvxPaper ePaper = (SvxPaper)(ULONG)aPaperSizeBox.GetEntryData( nPos );
//STRIP001 
//STRIP001 	if ( ePaper != SVX_PAPER_USER )
//STRIP001 	{
//STRIP001 		Size aSize( SvxPaperInfo::GetPaperSize( ePaper ) );
//STRIP001 
//STRIP001 		if ( aLandscapeBtn.IsChecked() )
//STRIP001 			Swap( aSize );
//STRIP001 
//STRIP001 		if ( aSize.Height() < aPaperHeightEdit.GetMin( FUNIT_TWIP ) )
//STRIP001 			aPaperHeightEdit.SetMin(
//STRIP001 				aPaperHeightEdit.Normalize( aSize.Height() ), FUNIT_TWIP );
//STRIP001 		if ( aSize.Width() < aPaperWidthEdit.GetMin( FUNIT_TWIP ) )
//STRIP001 			aPaperWidthEdit.SetMin(
//STRIP001 				aPaperWidthEdit.Normalize( aSize.Width() ), FUNIT_TWIP );
//STRIP001 		SetMetricValue( aPaperHeightEdit, aSize.Height(), SFX_MAPUNIT_TWIP );
//STRIP001 		SetMetricValue( aPaperWidthEdit, aSize.Width(), SFX_MAPUNIT_TWIP );
//STRIP001 
//STRIP001 		// R"ander ggf. neu berechnen
//STRIP001 		CalcMargin_Impl();
//STRIP001 
//STRIP001 		RangeHdl_Impl( 0 );
//STRIP001 		UpdateExample_Impl();
//STRIP001 
//STRIP001 		if ( eMode == SVX_PAGE_MODE_PRESENTATION )
//STRIP001 		{
//STRIP001 			// Draw: bei Papierformat soll der Rand 1cm betragen
//STRIP001 			long nTmp = 0;
//STRIP001 			BOOL bScreen = ( SVX_PAPER_SCREEN == ePaper );
//STRIP001 
//STRIP001 			if ( !bScreen )
//STRIP001 				// bei Bildschirm keinen Rand
//STRIP001 				nTmp = 1; // entspr. 1cm
//STRIP001 
//STRIP001 			// Abfragen, ob fuer Raender 0 gesetzt ist:
//STRIP001 			if ( bScreen || aRightMarginEdit.GetValue() == 0 )
//STRIP001 			{
//STRIP001 				SetMetricValue( aRightMarginEdit, nTmp, SFX_MAPUNIT_CM );
//STRIP001 				if ( !bScreen &&
//STRIP001 					 aRightMarginEdit.GetFirst() > aRightMarginEdit.GetValue() )
//STRIP001 					aRightMarginEdit.SetValue( aRightMarginEdit.GetFirst() );
//STRIP001 			}
//STRIP001 			if ( bScreen || aLeftMarginEdit.GetValue() == 0 )
//STRIP001 			{
//STRIP001 				SetMetricValue( aLeftMarginEdit, nTmp, SFX_MAPUNIT_CM );
//STRIP001 				if ( !bScreen &&
//STRIP001 					 aLeftMarginEdit.GetFirst() > aLeftMarginEdit.GetValue() )
//STRIP001 					aLeftMarginEdit.SetValue( aLeftMarginEdit.GetFirst() );
//STRIP001 			}
//STRIP001 			if ( bScreen || aBottomMarginEdit.GetValue() == 0 )
//STRIP001 			{
//STRIP001 				SetMetricValue( aBottomMarginEdit, nTmp, SFX_MAPUNIT_CM );
//STRIP001 				if ( !bScreen &&
//STRIP001 					 aBottomMarginEdit.GetFirst() > aBottomMarginEdit.GetValue() )
//STRIP001 					aBottomMarginEdit.SetValue( aBottomMarginEdit.GetFirst() );
//STRIP001 			}
//STRIP001 			if ( bScreen || aTopMarginEdit.GetValue() == 0 )
//STRIP001 			{
//STRIP001 				SetMetricValue( aTopMarginEdit, nTmp, SFX_MAPUNIT_CM );
//STRIP001 				if ( !bScreen &&
//STRIP001 					 aTopMarginEdit.GetFirst() > aTopMarginEdit.GetValue() )
//STRIP001 					aTopMarginEdit.SetValue( aTopMarginEdit.GetFirst() );
//STRIP001 			}
//STRIP001 			UpdateExample_Impl();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPageDescPage, PaperSizeModify_Impl, Edit *, EMPTYARG )
//STRIP001 {
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_LRSPACE );
//STRIP001 	SfxMapUnit eUnit = GetItemSet().GetPool()->GetMetric( nWhich );
//STRIP001 	Size aSize( GetCoreValue( aPaperWidthEdit, eUnit ),
//STRIP001 				GetCoreValue( aPaperHeightEdit, eUnit ) );
//STRIP001 	SvxPaper ePaper = SvxPaperInfo::GetPaper( aSize, (MapUnit)eUnit, TRUE );
//STRIP001 	USHORT nEntryCount = aPaperSizeBox.GetEntryCount();
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < nEntryCount; ++i )
//STRIP001 	{
//STRIP001 		SvxPaper eTmp = (SvxPaper)(ULONG)aPaperSizeBox.GetEntryData(i);
//STRIP001 
//STRIP001 		if ( eTmp == ePaper )
//STRIP001 		{
//STRIP001 			aPaperSizeBox.SelectEntryPos(i);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	UpdateExample_Impl();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPageDescPage, SwapOrientation_Impl, RadioButton *, pBtn )
//STRIP001 {
//STRIP001 	if ( !bLandscape && pBtn == &aLandscapeBtn ||
//STRIP001 		 bLandscape  && pBtn == &aPortraitBtn )
//STRIP001 	{
//STRIP001 		bLandscape = aLandscapeBtn.IsChecked();
//STRIP001 
//STRIP001 		const long lWidth = GetCoreValue( aPaperWidthEdit, SFX_MAPUNIT_TWIP );
//STRIP001 		const long lHeight = GetCoreValue( aPaperHeightEdit, SFX_MAPUNIT_TWIP );
//STRIP001 
//STRIP001 		// swappen
//STRIP001 		SetMetricValue( aPaperWidthEdit, lHeight, SFX_MAPUNIT_TWIP );
//STRIP001 		SetMetricValue( aPaperHeightEdit, lWidth, SFX_MAPUNIT_TWIP );
//STRIP001 
//STRIP001 		// R"ander ggf. neu berechnen
//STRIP001 		CalcMargin_Impl();
//STRIP001 
//STRIP001 		PaperSizeSelect_Impl( &aPaperSizeBox );
//STRIP001 		RangeHdl_Impl( 0 );
//STRIP001 		SwapFirstValues_Impl( bBorderModified );
//STRIP001 		UpdateExample_Impl();
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPageDescPage::SwapFirstValues_Impl( FASTBOOL bSet )
//STRIP001 {
//STRIP001 	Printer* pDefPrinter = 0;
//STRIP001 	BOOL bPrinterDel = FALSE;
//STRIP001 
//STRIP001 	if ( SfxViewShell::Current() && SfxViewShell::Current()->GetPrinter() )
//STRIP001 		pDefPrinter = (Printer*)SfxViewShell::Current()->GetPrinter();
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pDefPrinter = new Printer;
//STRIP001 		bPrinterDel = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	MapMode aOldMode = pDefPrinter->GetMapMode();
//STRIP001 	Orientation	eOri = ORIENTATION_PORTRAIT;
//STRIP001 
//STRIP001 	if ( bLandscape )
//STRIP001 		eOri = ORIENTATION_LANDSCAPE;
//STRIP001 	Orientation	eOldOri = pDefPrinter->GetOrientation();
//STRIP001 	pDefPrinter->SetOrientation( eOri );
//STRIP001 	pDefPrinter->SetMapMode( MAP_TWIP );
//STRIP001 
//STRIP001 	// First- und Last-Werte f"ur die R"ander setzen
//STRIP001 	Size aPaperSize = pDefPrinter->GetPaperSize();
//STRIP001 	Size aPrintSize = pDefPrinter->GetOutputSize();
//STRIP001 	/*
//STRIP001 	 * einen Punkt ( 0,0 ) in logische Koordinaten zu konvertieren,
//STRIP001 	 * sieht aus wie Unsinn; ist aber sinnvoll, wenn der Ursprung des
//STRIP001 	 * Koordinatensystems verschoben ist.
//STRIP001 	 */
//STRIP001 	Point aPrintOffset = pDefPrinter->GetPageOffset() -
//STRIP001 						 pDefPrinter->PixelToLogic( Point() );
//STRIP001 	pDefPrinter->SetMapMode( aOldMode );
//STRIP001 	pDefPrinter->SetOrientation( eOldOri );
//STRIP001 
//STRIP001 	if ( bPrinterDel )
//STRIP001 		delete pDefPrinter;
//STRIP001 
//STRIP001 	long nSetL = aLeftMarginEdit.Denormalize(
//STRIP001 					aLeftMarginEdit.GetValue( FUNIT_TWIP ) );
//STRIP001 	long nSetR = aRightMarginEdit.Denormalize(
//STRIP001 					aRightMarginEdit.GetValue( FUNIT_TWIP ) );
//STRIP001 	long nSetT = aTopMarginEdit.Denormalize(
//STRIP001 					aTopMarginEdit.GetValue( FUNIT_TWIP ) );
//STRIP001 	long nSetB = aBottomMarginEdit.Denormalize(
//STRIP001 					aBottomMarginEdit.GetValue( FUNIT_TWIP ) );
//STRIP001 
//STRIP001 	long nOffset = !aPrintOffset.X() && !aPrintOffset.Y() ? 0 : PRINT_OFFSET;
//STRIP001 	long nNewL = aPrintOffset.X();
//STRIP001 	long nNewR =
//STRIP001 		aPaperSize.Width() - aPrintSize.Width() - aPrintOffset.X() + nOffset;
//STRIP001 	long nNewT = aPrintOffset.Y();
//STRIP001 	long nNewB =
//STRIP001 		aPaperSize.Height() - aPrintSize.Height() - aPrintOffset.Y() + nOffset;
//STRIP001 
//STRIP001 	aLeftMarginEdit.SetFirst( aLeftMarginEdit.Normalize( nNewL ), FUNIT_TWIP );
//STRIP001 	nFirstLeftMargin = aLeftMarginEdit.GetFirst();
//STRIP001 	aRightMarginEdit.SetFirst( aRightMarginEdit.Normalize( nNewR ), FUNIT_TWIP );
//STRIP001 	nFirstRightMargin = aRightMarginEdit.GetFirst();
//STRIP001 	aTopMarginEdit.SetFirst( aTopMarginEdit.Normalize( nNewT ), FUNIT_TWIP );
//STRIP001 	nFirstTopMargin = aTopMarginEdit.GetFirst();
//STRIP001 	aBottomMarginEdit.SetFirst(	aBottomMarginEdit.Normalize( nNewB ), FUNIT_TWIP );
//STRIP001 	nFirstBottomMargin = aBottomMarginEdit.GetFirst();
//STRIP001 
//STRIP001 	if ( bSet )
//STRIP001 	{
//STRIP001 		// ggf. auch die Werte umsetzen,
//STRIP001 		if ( nSetL < nNewL )
//STRIP001 			aLeftMarginEdit.SetValue( aLeftMarginEdit.Normalize( nNewL ),
//STRIP001 									  FUNIT_TWIP );
//STRIP001 		if ( nSetR < nNewR )
//STRIP001 			aRightMarginEdit.SetValue( aRightMarginEdit.Normalize( nNewR ),
//STRIP001 									   FUNIT_TWIP );
//STRIP001 		if ( nSetT < nNewT )
//STRIP001 			aTopMarginEdit.SetValue( aTopMarginEdit.Normalize( nNewT ),
//STRIP001 									 FUNIT_TWIP );
//STRIP001 		if ( nSetB < nNewB )
//STRIP001 			aBottomMarginEdit.SetValue( aBottomMarginEdit.Normalize( nNewB ),
//STRIP001 										FUNIT_TWIP );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK_INLINE_START( SvxPageDescPage, BorderModify_Impl, MetricField *, EMPTYARG )
//STRIP001 {
//STRIP001 	if ( !bBorderModified )
//STRIP001 		bBorderModified = TRUE;
//STRIP001 	UpdateExample_Impl();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxPageDescPage, BorderModify_Impl, MetricField *, EMPTYARG )
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPageDescPage::UpdateExample_Impl()
//STRIP001 {
//STRIP001 	// Size
//STRIP001 	Size aSize(	GetCoreValue( aPaperWidthEdit, SFX_MAPUNIT_TWIP ),
//STRIP001 				GetCoreValue( aPaperHeightEdit, SFX_MAPUNIT_TWIP ) );
//STRIP001 
//STRIP001 	aBspWin.SetSize( aSize );
//STRIP001 
//STRIP001 	// R"ander
//STRIP001 	aBspWin.SetTop( GetCoreValue( aTopMarginEdit, SFX_MAPUNIT_TWIP ) );
//STRIP001 	aBspWin.SetBottom( GetCoreValue( aBottomMarginEdit, SFX_MAPUNIT_TWIP ) );
//STRIP001 	aBspWin.SetLeft( GetCoreValue( aLeftMarginEdit, SFX_MAPUNIT_TWIP ) );
//STRIP001 	aBspWin.SetRight( GetCoreValue( aRightMarginEdit, SFX_MAPUNIT_TWIP ) );
//STRIP001 
//STRIP001 	// Layout
//STRIP001 	aBspWin.SetUsage( PosToPageUsage_Impl( aLayoutBox.GetSelectEntryPos() ) );
//STRIP001 	aBspWin.Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPageDescPage::ResetBackground_Impl( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_PAGE_HEADERSET );
//STRIP001 
//STRIP001 	if ( rSet.GetItemState( nWhich, FALSE ) == SFX_ITEM_SET )
//STRIP001 	{
//STRIP001 		const SvxSetItem& rSetItem =
//STRIP001 			(const SvxSetItem&)rSet.Get( nWhich, FALSE );
//STRIP001 		const SfxItemSet& rTmpSet = rSetItem.GetItemSet();
//STRIP001 		const SfxBoolItem& rOn =
//STRIP001 			(const SfxBoolItem&)rTmpSet.Get( GetWhich( SID_ATTR_PAGE_ON ) );
//STRIP001 
//STRIP001 		if ( rOn.GetValue() )
//STRIP001 		{
//STRIP001 			nWhich = GetWhich( SID_ATTR_BRUSH );
//STRIP001 
//STRIP001 			if ( rTmpSet.GetItemState( nWhich ) == SFX_ITEM_SET )
//STRIP001 			{
//STRIP001 				const SvxBrushItem& rItem =
//STRIP001 					(const SvxBrushItem&)rTmpSet.Get( nWhich );
//STRIP001 				aBspWin.SetHdColor( rItem.GetColor() );
//STRIP001 			}
//STRIP001 			nWhich = GetWhich( SID_ATTR_BORDER_OUTER );
//STRIP001 
//STRIP001 			if ( rTmpSet.GetItemState( nWhich ) == SFX_ITEM_SET )
//STRIP001 			{
//STRIP001 				const SvxBoxItem& rItem =
//STRIP001 					(const SvxBoxItem&)rTmpSet.Get( nWhich );
//STRIP001 				aBspWin.SetHdBorder( rItem );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	nWhich = GetWhich( SID_ATTR_PAGE_FOOTERSET );
//STRIP001 
//STRIP001 	if ( rSet.GetItemState( nWhich, FALSE ) == SFX_ITEM_SET )
//STRIP001 	{
//STRIP001 		const SvxSetItem& rSetItem =
//STRIP001 			(const SvxSetItem&)rSet.Get( nWhich, FALSE );
//STRIP001 		const SfxItemSet& rTmpSet = rSetItem.GetItemSet();
//STRIP001 		const SfxBoolItem& rOn =
//STRIP001 			(const SfxBoolItem&)rTmpSet.Get( GetWhich( SID_ATTR_PAGE_ON ) );
//STRIP001 
//STRIP001 		if ( rOn.GetValue() )
//STRIP001 		{
//STRIP001 			nWhich = GetWhich( SID_ATTR_BRUSH );
//STRIP001 
//STRIP001 			if ( rTmpSet.GetItemState( nWhich ) == SFX_ITEM_SET )
//STRIP001 			{
//STRIP001 				const SvxBrushItem& rItem =
//STRIP001 					(const SvxBrushItem&)rTmpSet.Get( nWhich );
//STRIP001 				aBspWin.SetFtColor( rItem.GetColor() );
//STRIP001 			}
//STRIP001 			nWhich = GetWhich( SID_ATTR_BORDER_OUTER );
//STRIP001 
//STRIP001 			if ( rTmpSet.GetItemState( nWhich ) == SFX_ITEM_SET )
//STRIP001 			{
//STRIP001 				const SvxBoxItem& rItem =
//STRIP001 					(const SvxBoxItem&)rTmpSet.Get( nWhich );
//STRIP001 				aBspWin.SetFtBorder( rItem );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	const SfxPoolItem* pItem = GetItem( rSet, SID_ATTR_BRUSH );
//STRIP001 
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		aBspWin.SetColor( ( (const SvxBrushItem*)pItem )->GetColor() );
//STRIP001 		const Graphic* pGrf = ( (const SvxBrushItem*)pItem )->GetGraphic();
//STRIP001 
//STRIP001 		if ( pGrf )
//STRIP001 		{
//STRIP001 			Bitmap aBitmap = pGrf->GetBitmap();
//STRIP001 			aBspWin.SetBitmap( &aBitmap );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aBspWin.SetBitmap( NULL );
//STRIP001 	}
//STRIP001 
//STRIP001 	pItem = GetItem( rSet, SID_ATTR_BORDER_OUTER );
//STRIP001 
//STRIP001 	if ( pItem )
//STRIP001 		aBspWin.SetBorder( (SvxBoxItem&)*pItem );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPageDescPage::InitHeadFoot_Impl( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	bLandscape = aLandscapeBtn.IsChecked();
//STRIP001 	const SfxPoolItem* pItem = GetItem( rSet, SID_ATTR_PAGE_SIZE );
//STRIP001 
//STRIP001 	if ( pItem )
//STRIP001 		aBspWin.SetSize( ( (const SvxSizeItem*)pItem )->GetSize() );
//STRIP001 
//STRIP001 	const SvxSetItem* pSetItem = 0;
//STRIP001 
//STRIP001 	// Kopfzeilen-Attribute auswerten
//STRIP001 
//STRIP001 	if ( SFX_ITEM_SET ==
//STRIP001 		 rSet.GetItemState( GetWhich( SID_ATTR_PAGE_HEADERSET ),
//STRIP001 							FALSE, (const SfxPoolItem**)&pSetItem ) )
//STRIP001 	{
//STRIP001 		const SfxItemSet& rHeaderSet = pSetItem->GetItemSet();
//STRIP001 		const SfxBoolItem& rHeaderOn =
//STRIP001 			(const SfxBoolItem&)rHeaderSet.Get( GetWhich( SID_ATTR_PAGE_ON ) );
//STRIP001 
//STRIP001 		if ( rHeaderOn.GetValue() )
//STRIP001 		{
//STRIP001 			const SvxSizeItem& rSize = (const SvxSizeItem&)
//STRIP001 				rHeaderSet.Get( GetWhich( SID_ATTR_PAGE_SIZE ) );
//STRIP001 			const SvxULSpaceItem& rUL = (const SvxULSpaceItem&)
//STRIP001 				rHeaderSet.Get( GetWhich( SID_ATTR_ULSPACE ) );
//STRIP001 			long nDist = rUL.GetLower();
//STRIP001 			aBspWin.SetHdHeight( rSize.GetSize().Height() - nDist );
//STRIP001 			aBspWin.SetHdDist( nDist );
//STRIP001 			const SvxLRSpaceItem& rLR = (const SvxLRSpaceItem&)
//STRIP001 				rHeaderSet.Get( GetWhich( SID_ATTR_LRSPACE ) );
//STRIP001 			aBspWin.SetHdLeft( rLR.GetLeft() );
//STRIP001 			aBspWin.SetHdRight( rLR.GetRight() );
//STRIP001 			aBspWin.SetHeader( TRUE );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aBspWin.SetHeader( FALSE );
//STRIP001 
//STRIP001 		// im Beispiel Hintergrund und Umrandung anzeigen
//STRIP001 		USHORT nWhich = GetWhich( SID_ATTR_BRUSH );
//STRIP001 
//STRIP001 		if ( rHeaderSet.GetItemState( nWhich ) >= SFX_ITEM_AVAILABLE )
//STRIP001 		{
//STRIP001 			const SvxBrushItem& rItem =
//STRIP001 				(const SvxBrushItem&)rHeaderSet.Get( nWhich );
//STRIP001 			aBspWin.SetHdColor( rItem.GetColor() );
//STRIP001 		}
//STRIP001 		nWhich = GetWhich( SID_ATTR_BORDER_OUTER );
//STRIP001 
//STRIP001 		if ( rHeaderSet.GetItemState( nWhich ) >= SFX_ITEM_AVAILABLE )
//STRIP001 		{
//STRIP001 			const SvxBoxItem& rItem =
//STRIP001 				(const SvxBoxItem&)rHeaderSet.Get( nWhich );
//STRIP001 			aBspWin.SetHdBorder( rItem );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Fusszeilen-Attribute auswerten
//STRIP001 
//STRIP001 	if ( SFX_ITEM_SET ==
//STRIP001 		 rSet.GetItemState( GetWhich( SID_ATTR_PAGE_FOOTERSET ),
//STRIP001 							FALSE, (const SfxPoolItem**)&pSetItem ) )
//STRIP001 	{
//STRIP001 		const SfxItemSet& rFooterSet = pSetItem->GetItemSet();
//STRIP001 		const SfxBoolItem& rFooterOn =
//STRIP001 			(const SfxBoolItem&)rFooterSet.Get( GetWhich( SID_ATTR_PAGE_ON ) );
//STRIP001 
//STRIP001 		if ( rFooterOn.GetValue() )
//STRIP001 		{
//STRIP001 			const SvxSizeItem& rSize = (const SvxSizeItem&)
//STRIP001 				rFooterSet.Get( GetWhich( SID_ATTR_PAGE_SIZE ) );
//STRIP001 			const SvxULSpaceItem& rUL = (const SvxULSpaceItem&)
//STRIP001 				rFooterSet.Get( GetWhich( SID_ATTR_ULSPACE ) );
//STRIP001 			long nDist = rUL.GetUpper();
//STRIP001 			aBspWin.SetFtHeight( rSize.GetSize().Height() - nDist );
//STRIP001 			aBspWin.SetFtDist( nDist );
//STRIP001 			const SvxLRSpaceItem& rLR = (const SvxLRSpaceItem&)
//STRIP001 				rFooterSet.Get( GetWhich( SID_ATTR_LRSPACE ) );
//STRIP001 			aBspWin.SetFtLeft( rLR.GetLeft() );
//STRIP001 			aBspWin.SetFtRight( rLR.GetRight() );
//STRIP001 			aBspWin.SetFooter( TRUE );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aBspWin.SetFooter( FALSE );
//STRIP001 
//STRIP001 		// im Beispiel Hintergrund und Umrandung anzeigen
//STRIP001 		USHORT nWhich = GetWhich( SID_ATTR_BRUSH );
//STRIP001 
//STRIP001 		if ( rFooterSet.GetItemState( nWhich ) >= SFX_ITEM_AVAILABLE )
//STRIP001 		{
//STRIP001 			const SvxBrushItem& rItem =
//STRIP001 				(const SvxBrushItem&)rFooterSet.Get( nWhich );
//STRIP001 			aBspWin.SetFtColor( rItem.GetColor() );
//STRIP001 		}
//STRIP001 		nWhich = GetWhich( SID_ATTR_BORDER_OUTER );
//STRIP001 
//STRIP001 		if ( rFooterSet.GetItemState( nWhich ) >= SFX_ITEM_AVAILABLE )
//STRIP001 		{
//STRIP001 			const SvxBoxItem& rItem =
//STRIP001 				(const SvxBoxItem&)rFooterSet.Get( nWhich );
//STRIP001 			aBspWin.SetFtBorder( rItem );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPageDescPage::ActivatePage( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	InitHeadFoot_Impl( rSet );
//STRIP001 	ResetBackground_Impl( rSet );
//STRIP001 	RangeHdl_Impl( 0 );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxPageDescPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	// Abfrage, ob die Seitenr"ander ausserhalb des Druckbereichs liegen
//STRIP001 	// Wenn nicht, dann den Anwender fragen, ob sie "ubernommen werden sollen.
//STRIP001 	// Wenn nicht, dann auf der TabPage bleiben.
//STRIP001 	USHORT nPos = aPaperSizeBox.GetSelectEntryPos();
//STRIP001 	SvxPaper ePaper = (SvxPaper)(ULONG)aPaperSizeBox.GetEntryData( nPos );
//STRIP001 
//STRIP001 	if ( ePaper != SVX_PAPER_SCREEN && IsMarginOutOfRange() )
//STRIP001 	{
//STRIP001 		if ( QueryBox( this, WB_YES_NO | WB_DEF_NO, aPrintRangeQueryText ).Execute() == RET_NO )
//STRIP001 		{
//STRIP001 			MetricField* pField = NULL;
//STRIP001 			if ( IsPrinterRangeOverflow( aLeftMarginEdit, nFirstLeftMargin, nLastLeftMargin, MARGIN_LEFT ) )
//STRIP001 				pField = &aLeftMarginEdit;
//STRIP001 			if (	IsPrinterRangeOverflow( aRightMarginEdit, nFirstRightMargin, nLastRightMargin, MARGIN_RIGHT )
//STRIP001 				 && !pField )
//STRIP001 				pField = &aRightMarginEdit;
//STRIP001 			if (	IsPrinterRangeOverflow( aTopMarginEdit, nFirstTopMargin, nLastTopMargin, MARGIN_TOP )
//STRIP001 				 && !pField )
//STRIP001 				pField = &aTopMarginEdit;
//STRIP001 			if (	IsPrinterRangeOverflow( aBottomMarginEdit, nFirstBottomMargin, nLastBottomMargin, MARGIN_BOTTOM )
//STRIP001 				 && !pField )
//STRIP001 				pField = &aBottomMarginEdit;
//STRIP001 			if ( pField )
//STRIP001 				pField->GrabFocus();
//STRIP001 			UpdateExample_Impl();
//STRIP001 			return KEEP_PAGE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			CheckMarginEdits( false );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pSet )
//STRIP001 	{
//STRIP001 		FillItemSet( *pSet );
//STRIP001 
//STRIP001 		// ggf. hoch/quer putten
//STRIP001 		USHORT nWh = GetWhich( SID_ATTR_PAGE_SIZE );
//STRIP001 		SfxMapUnit eUnit = GetItemSet().GetPool()->GetMetric( nWh );
//STRIP001 		Size aSize( GetCoreValue( aPaperWidthEdit, eUnit ),
//STRIP001 					GetCoreValue( aPaperHeightEdit, eUnit ) );
//STRIP001 
//STRIP001 		// putten, wenn aktuelle Gr"o/se unterschiedlich zum Wert in pSet
//STRIP001 		const SvxSizeItem* pSize = (const SvxSizeItem*)GetItem( *pSet, SID_ATTR_PAGE_SIZE );
//STRIP001 		if ( aSize.Width() && ( !pSize || !IsEqualSize_Impl( pSize, aSize ) ) )
//STRIP001 			pSet->Put( SvxSizeItem( nWh, aSize ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPageDescPage, RangeHdl_Impl, Edit *, EMPTYARG )
//STRIP001 {
//STRIP001 	// Aktuelle Header-Breite/H"ohe aus dem Bsp
//STRIP001 	long nHHeight = aBspWin.GetHdHeight();
//STRIP001 	long nHDist = aBspWin.GetHdDist();
//STRIP001 
//STRIP001 	// Aktuelle Footer-Breite/H"ohe aus dem Bsp
//STRIP001 	long nFHeight = aBspWin.GetFtHeight();
//STRIP001 	long nFDist = aBspWin.GetFtDist();
//STRIP001 
//STRIP001 	// Aktuelle Header/Footer-R"ander aus dem Bsp
//STRIP001 	long nHFLeft = Max( aBspWin.GetHdLeft(), aBspWin.GetFtLeft() );
//STRIP001 	long nHFRight = Max( aBspWin.GetHdRight(), aBspWin.GetFtRight() );
//STRIP001 
//STRIP001 	// Aktuelle Werte der Seitenr"ander
//STRIP001 	long nBT = aTopMarginEdit.Denormalize(aTopMarginEdit.GetValue(FUNIT_TWIP));
//STRIP001 	long nBB = aBottomMarginEdit.Denormalize(aBottomMarginEdit.GetValue(FUNIT_TWIP));
//STRIP001 	long nBL = aLeftMarginEdit.Denormalize(aLeftMarginEdit.GetValue(FUNIT_TWIP));
//STRIP001 	long nBR = aRightMarginEdit.Denormalize(aRightMarginEdit.GetValue(FUNIT_TWIP));
//STRIP001 
//STRIP001 	// Breite Umrandung der Seite berechnen
//STRIP001 	const SfxItemSet* pSet = &GetItemSet();
//STRIP001 	Size aBorder;
//STRIP001 
//STRIP001 	if ( pSet->GetItemState( GetWhich(SID_ATTR_BORDER_SHADOW) ) >=
//STRIP001 			SFX_ITEM_AVAILABLE &&
//STRIP001 		 pSet->GetItemState( GetWhich(SID_ATTR_BORDER_OUTER)  ) >=
//STRIP001 			SFX_ITEM_AVAILABLE )
//STRIP001 	{
//STRIP001 		aBorder = ( GetMinBorderSpace_Impl(
//STRIP001 			(const SvxShadowItem&)pSet->Get(GetWhich(SID_ATTR_BORDER_SHADOW)),
//STRIP001 			(const SvxBoxItem&)pSet->Get(GetWhich(SID_ATTR_BORDER_OUTER))));
//STRIP001 	}
//STRIP001 
//STRIP001 	long nH  = aPaperHeightEdit.Denormalize(aPaperHeightEdit.GetValue(FUNIT_TWIP));
//STRIP001 	long nW  = aPaperWidthEdit.Denormalize(aPaperWidthEdit.GetValue(FUNIT_TWIP));
//STRIP001 
//STRIP001 	// Grenzen Papier
//STRIP001 	// Maximum liegt bei 54cm
//STRIP001 	//
//STRIP001 	long nMin = nHHeight + nHDist + nFDist + nFHeight + nBT + nBB +
//STRIP001 				MINBODY + aBorder.Height();
//STRIP001 	aPaperHeightEdit.SetMin(aPaperHeightEdit.Normalize(nMin), FUNIT_TWIP);
//STRIP001 
//STRIP001 	nMin = MINBODY + nBL + nBR + aBorder.Width();
//STRIP001 	aPaperWidthEdit.SetMin(aPaperWidthEdit.Normalize(nMin), FUNIT_TWIP);
//STRIP001 
//STRIP001 	// Falls sich die Papiergr"o\se ge"adert hat
//STRIP001 	nH = aPaperHeightEdit.Denormalize(aPaperHeightEdit.GetValue(FUNIT_TWIP));
//STRIP001 	nW = aPaperWidthEdit.Denormalize(aPaperWidthEdit.GetValue(FUNIT_TWIP));
//STRIP001 
//STRIP001 	// Top
//STRIP001 	long nMax =	nH - nBB - aBorder.Height() - MINBODY -
//STRIP001 				nFDist - nFHeight -	nHDist - nHHeight;
//STRIP001 
//STRIP001 	aTopMarginEdit.SetMax(aTopMarginEdit.Normalize(nMax), FUNIT_TWIP);
//STRIP001 
//STRIP001 	// Bottom
//STRIP001 	nMax = nH - nBT - aBorder.Height() - MINBODY -
//STRIP001 		   nFDist - nFHeight - nHDist - nHHeight;
//STRIP001 
//STRIP001 	aBottomMarginEdit.SetMax(aTopMarginEdit.Normalize(nMax), FUNIT_TWIP);
//STRIP001 
//STRIP001 	// Left
//STRIP001 	nMax = nW - nBR - MINBODY - aBorder.Width() - nHFLeft - nHFRight;
//STRIP001 	aLeftMarginEdit.SetMax(aLeftMarginEdit.Normalize(nMax), FUNIT_TWIP);
//STRIP001 
//STRIP001 	// Right
//STRIP001 	nMax = nW - nBL - MINBODY - aBorder.Width() - nHFLeft - nHFRight;
//STRIP001 	aRightMarginEdit.SetMax(aRightMarginEdit.Normalize(nMax), FUNIT_TWIP);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPageDescPage::CalcMargin_Impl()
//STRIP001 {
//STRIP001 	// Aktuelle Werte der Seitenr"ander
//STRIP001 	long nBT = GetCoreValue( aTopMarginEdit, SFX_MAPUNIT_TWIP );
//STRIP001 	long nBB = GetCoreValue( aBottomMarginEdit, SFX_MAPUNIT_TWIP );
//STRIP001 
//STRIP001 	long nBL = GetCoreValue( aLeftMarginEdit, SFX_MAPUNIT_TWIP );
//STRIP001 	long nBR = GetCoreValue( aRightMarginEdit, SFX_MAPUNIT_TWIP );
//STRIP001 
//STRIP001 	long nH  = GetCoreValue( aPaperHeightEdit, SFX_MAPUNIT_TWIP );
//STRIP001 	long nW  = GetCoreValue( aPaperWidthEdit, SFX_MAPUNIT_TWIP );
//STRIP001 
//STRIP001 	long nWidth = nBL + nBR + MINBODY;
//STRIP001 	long nHeight = nBT + nBB + MINBODY;
//STRIP001 
//STRIP001 	if ( nWidth > nW || nHeight > nH )
//STRIP001 	{
//STRIP001 		if ( nWidth > nW )
//STRIP001 		{
//STRIP001 			long nTmp = nBL <= nBR ? nBR : nBL;
//STRIP001 			nTmp -= nWidth - nW;
//STRIP001 
//STRIP001 			if ( nBL <= nBR )
//STRIP001 				SetMetricValue( aRightMarginEdit, nTmp, SFX_MAPUNIT_TWIP );
//STRIP001 			else
//STRIP001 				SetMetricValue( aLeftMarginEdit, nTmp, SFX_MAPUNIT_TWIP );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( nHeight > nH )
//STRIP001 		{
//STRIP001 			long nTmp = nBT <= nBB ? nBB : nBT;
//STRIP001 			nTmp -= nHeight - nH;
//STRIP001 
//STRIP001 			if ( nBT <= nBB )
//STRIP001 				SetMetricValue( aBottomMarginEdit, nTmp, SFX_MAPUNIT_TWIP );
//STRIP001 			else
//STRIP001 				SetMetricValue( aTopMarginEdit, nTmp, SFX_MAPUNIT_TWIP );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK_INLINE_START( SvxPageDescPage, CenterHdl_Impl, CheckBox *, EMPTYARG )
//STRIP001 {
//STRIP001     aBspWin.SetHorz( aHorzBox.IsChecked() );
//STRIP001     aBspWin.SetVert( aVertBox.IsChecked() );
//STRIP001     UpdateExample_Impl();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxPageDescPage, CenterHdl_Impl, CheckBox *, EMPTYARG )
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPageDescPage::SetCollectionList(const List* pList)
//STRIP001 {
//STRIP001 	sStandardRegister = *(String*)pList->GetObject(0);
//STRIP001 	for( USHORT i = 1; i < pList->Count(); i++   )
//STRIP001 	{
//STRIP001 		aRegisterLB.InsertEntry(*(String*)pList->GetObject(i));
//STRIP001 	}
//STRIP001 
//STRIP001 	aRegisterCB  .Show();
//STRIP001 	aRegisterFT  .Show();
//STRIP001 	aRegisterLB.Show();
//STRIP001 	aRegisterCB.SetClickHdl(LINK(this, SvxPageDescPage, RegisterModify));
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPageDescPage, RegisterModify, CheckBox*, pBox )
//STRIP001 {
//STRIP001 	BOOL bEnable = FALSE;
//STRIP001 	if(pBox->IsChecked())
//STRIP001 	{
//STRIP001 		bEnable = TRUE;
//STRIP001 		if(USHRT_MAX == aRegisterLB.GetSelectEntryPos())
//STRIP001 			aRegisterLB.SelectEntry(sStandardRegister);
//STRIP001 	}
//STRIP001 	aRegisterFT.Enable( bEnable );
//STRIP001 	aRegisterLB.Enable( bEnable );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // ----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPageDescPage::DisableVerticalPageDir()
//STRIP001 {
//STRIP001     aTextFlowBox.RemoveEntryValue( FRMDIR_VERT_TOP_RIGHT );
//STRIP001     aTextFlowBox.RemoveEntryValue( FRMDIR_VERT_TOP_LEFT );
//STRIP001     if( aTextFlowBox.GetEntryCount() < 2 )
//STRIP001     {
//STRIP001         aTextFlowLbl.Hide();
//STRIP001         aTextFlowBox.Hide();
//STRIP001         aBspWin.EnableFrameDirection( sal_False );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( SvxPageDescPage, FrameDirectionModify_Impl, ListBox*,  pListBox)
//STRIP001 {
//STRIP001     aBspWin.SetFrameDirection( (sal_uInt32) aTextFlowBox.GetSelectEntryValue() );
//STRIP001     aBspWin.Invalidate();
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 bool SvxPageDescPage::IsPrinterRangeOverflow(
//STRIP001 	MetricField& rField, long nFirstMargin, long nLastMargin, MarginPosition nPos )
//STRIP001 {
//STRIP001 	bool bRet = false;
//STRIP001 	bool bCheck = ( ( pImpl->m_nPos & nPos ) == 0 );
//STRIP001 	long nValue = rField.GetValue();
//STRIP001 	if ( bCheck &&
//STRIP001 		 (  nValue < nFirstMargin || nValue > nLastMargin ) &&
//STRIP001 		 rField.GetText() != rField.GetSavedValue() )
//STRIP001 	{
//STRIP001 		rField.SetValue( nValue < nFirstMargin ? nFirstMargin : nLastMargin );
//STRIP001  		bRet = true;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 /** Check if a value of a margin edit is outside the printer paper margins
//STRIP001 	and save this information.
//STRIP001 */
//STRIP001 void SvxPageDescPage::CheckMarginEdits( bool _bClear )
//STRIP001 {
//STRIP001 	if ( _bClear )
//STRIP001 		pImpl->m_nPos = 0;
//STRIP001 
//STRIP001 	long nValue = aLeftMarginEdit.GetValue();
//STRIP001 	if (  nValue < nFirstLeftMargin || nValue > nLastLeftMargin )
//STRIP001 		pImpl->m_nPos |= MARGIN_LEFT;
//STRIP001 	nValue = aRightMarginEdit.GetValue();
//STRIP001 	if (  nValue < nFirstRightMargin || nValue > nLastRightMargin )
//STRIP001 		pImpl->m_nPos |= MARGIN_RIGHT;
//STRIP001 	nValue = aTopMarginEdit.GetValue();
//STRIP001 	if (  nValue < nFirstTopMargin || nValue > nLastTopMargin )
//STRIP001 		pImpl->m_nPos |= MARGIN_TOP;
//STRIP001 	nValue = aBottomMarginEdit.GetValue();
//STRIP001 	if (  nValue < nFirstBottomMargin || nValue > nLastBottomMargin )
//STRIP001 		pImpl->m_nPos |= MARGIN_BOTTOM;
//STRIP001 }
//STRIP001 
//STRIP001 bool SvxPageDescPage::IsMarginOutOfRange()
//STRIP001 {
//STRIP001 	bool bRet = ( ( ( !( pImpl->m_nPos & MARGIN_LEFT ) &&
//STRIP001 					  ( aLeftMarginEdit.GetText() != aLeftMarginEdit.GetSavedValue() ) ) &&
//STRIP001 					( aLeftMarginEdit.GetValue() < nFirstLeftMargin ||
//STRIP001 					  aLeftMarginEdit.GetValue() > nLastLeftMargin ) ) ||
//STRIP001 				  ( ( !( pImpl->m_nPos & MARGIN_RIGHT ) &&
//STRIP001 					  ( aRightMarginEdit.GetText() != aRightMarginEdit.GetSavedValue() ) ) &&
//STRIP001 					( aRightMarginEdit.GetValue() < nFirstRightMargin ||
//STRIP001 					  aRightMarginEdit.GetValue() > nLastRightMargin ) ) ||
//STRIP001 				  ( ( !( pImpl->m_nPos & MARGIN_TOP ) &&
//STRIP001 					  ( aTopMarginEdit.GetText() != aTopMarginEdit.GetSavedValue() ) ) &&
//STRIP001 					( aTopMarginEdit.GetValue() < nFirstTopMargin ||
//STRIP001 					  aTopMarginEdit.GetValue() > nLastTopMargin ) ) ||
//STRIP001 				  ( ( !( pImpl->m_nPos & MARGIN_BOTTOM ) &&
//STRIP001 					  ( aBottomMarginEdit.GetText() != aBottomMarginEdit.GetSavedValue() ) ) &&
//STRIP001 					( aBottomMarginEdit.GetValue() < nFirstBottomMargin ||
//STRIP001 					  aBottomMarginEdit.GetValue() > nLastBottomMargin ) ) );
//STRIP001 	return bRet;
//STRIP001 }

}
