/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_imapdlg.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:51:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SDR_NOOBJECTS
#define _SDR_NOVIEWMARKER
#define _SDR_NODRAGMETHODS
#define _SDR_NOUNDO
#define _SDR_NOXOUTDEV

#include <stdlib.h>

// auto strip #ifndef _SHL_HXX
// auto strip #include <tools/shl.hxx>
// auto strip #endif
// auto strip #ifndef _EINF_HXX
// auto strip #include <tools/errinf.hxx>
// auto strip #endif
// auto strip #ifndef _URLOBJ_HXX
// auto strip #include <tools/urlobj.hxx>
// auto strip #endif
// auto strip #ifndef _UNOTOOLS_UCBSTREAMHELPER_HXX
// auto strip #include <unotools/ucbstreamhelper.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SV_GROUP_HXX //autogen
// auto strip #include <vcl/group.hxx>
// auto strip #endif
// auto strip #ifndef _SV_LSTBOX_HXX //autogen
// auto strip #include <vcl/lstbox.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
// auto strip #ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
// auto strip #include <svtools/pathoptions.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SFXMODULE_HXX
// auto strip #include <bf_sfx2/module.hxx>
// auto strip #endif
// auto strip #ifndef _FILEDLGHELPER_HXX
// auto strip #include <bf_sfx2/filedlghelper.hxx>
// auto strip #endif
#pragma hdrstop

// auto strip #ifndef SVTOOLS_URIHELPER_HXX
// auto strip #include <svtools/urihelper.hxx>
// auto strip #endif
// auto strip #include <svtools/miscopt.hxx>
// auto strip #include <bf_sfx2/viewfrm.hxx>

// auto strip #ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
// auto strip #include <unotools/localedatawrapper.hxx>
// auto strip #endif
// auto strip #ifndef _UNOTOOLS_PROCESSFACTORY_HXX
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif

#define _IMAPDLG_PRIVATE
#include "imapdlg.hxx"

// auto strip #include "dialmgr.hxx"
#include "dialogs.hrc"
#include "svxids.hrc"
#include "imapdlg.hrc"
// auto strip #include "imapwnd.hxx"
// auto strip #include "imapimp.hxx"
// auto strip #include "dlgutil.hxx"
// auto strip #include "svdtrans.hxx"
// auto strip #include "svdopath.hxx"
// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif
#include "so3/staticbaseurl.hxx"
namespace binfilter {

//STRIP001 #define SELF_TARGET			"_self"
//STRIP001 #define	IMAP_ALL_FILTER		"<Alle>"
//STRIP001 #define	IMAP_CERN_FILTER	"MAP - CERN"
//STRIP001 #define	IMAP_NCSA_FILTER	"MAP - NCSA"
//STRIP001 #define	IMAP_BINARY_FILTER	"SIP - StarView ImageMap"
//STRIP001 #define IMAP_ALL_TYPE		"*.*"
//STRIP001 #define IMAP_BINARY_TYPE	"*.sip"
//STRIP001 #define IMAP_CERN_TYPE		"*.map"
//STRIP001 #define IMAP_NCSA_TYPE		"*.map"
//STRIP001 #define	IMAP_BINARY_EXT		"sip"
//STRIP001 #define	IMAP_CERN_EXT		"map"
//STRIP001 #define	IMAP_NCSA_EXT		"map"

/******************************************************************************/

/*N*/ SFX_IMPL_FLOATINGWINDOW( SvxIMapDlgChildWindow, SID_IMAP );

/******************************************************************************/

//STRIP001 inline String GetUnitString( long nVal_100, FieldUnit eFieldUnit, sal_Unicode cSep )
//STRIP001 {
//STRIP001 	String aVal = UniString::CreateFromInt32( MetricField::ConvertValue( nVal_100, 2, MAP_100TH_MM, eFieldUnit ) );
//STRIP001 
//STRIP001 	while( aVal.Len() < 3 )
//STRIP001 		aVal.Insert( sal_Unicode('0'), 0 );
//STRIP001 
//STRIP001 	aVal.Insert( cSep, aVal.Len() - 2 );
//STRIP001 	aVal += sal_Unicode(' ');
//STRIP001 	aVal += SdrFormatter::GetUnitStr( eFieldUnit );
//STRIP001 
//STRIP001 	return aVal;
//STRIP001 }

/*************************************************************************
|*
|* ControllerItem
|*
\************************************************************************/

//STRIP001 SvxIMapDlgItem::SvxIMapDlgItem( USHORT nId, SvxIMapDlg& rIMapDlg, SfxBindings& rBindings ) :
//STRIP001 			SfxControllerItem   ( nId, rBindings ),
//STRIP001 			rIMap				( rIMapDlg )
//STRIP001 {
//STRIP001 }

/*************************************************************************
|*
|* StateChanged-Methode
|*
\************************************************************************/

//STRIP001 void SvxIMapDlgItem::StateChanged( USHORT nSID, SfxItemState eState,
//STRIP001 								   const SfxPoolItem* pItem )
//STRIP001 {
//STRIP001 	if ( ( nSID == SID_IMAP_EXEC ) && pItem )
//STRIP001 	{
//STRIP001 		const SfxBoolItem* pStateItem = PTR_CAST( SfxBoolItem, pItem );
//STRIP001 
//STRIP001 		DBG_ASSERT( pStateItem || pItem == 0, "SfxBoolItem erwartet");
//STRIP001 
//STRIP001 		// Float ggf. disablen
//STRIP001 		rIMap.SetExecState( !pStateItem->GetValue() );
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

/*N*/ SvxIMapDlgChildWindow::SvxIMapDlgChildWindow( Window* pParent, USHORT nId,
/*N*/ 											  SfxBindings* pBindings,
/*N*/ 											  SfxChildWinInfo* pInfo ) :
/*N*/ 			SfxChildWindow( pParent, nId )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	pWindow = new SvxIMapDlg( pBindings, this, pParent, SVX_RES( RID_SVXDLG_IMAP ) );
//STRIP001 	SvxIMapDlg* pDlg = (SvxIMapDlg*) pWindow;
//STRIP001 
//STRIP001 	if ( pInfo->nFlags & SFX_CHILDWIN_ZOOMIN )
//STRIP001 		pDlg->RollUp();
//STRIP001 
//STRIP001 	eChildAlignment = SFX_ALIGN_NOALIGNMENT;
//STRIP001 
//STRIP001     pDlg->Initialize( pInfo );
/*N*/ }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SvxIMapDlgChildWindow::UpdateIMapDlg( const Graphic& rGraphic, const ImageMap* pImageMap,
//STRIP001 										   const TargetList* pTargetList, void* pEditingObj )
//STRIP001 {
//STRIP001 	if ( SfxViewFrame::Current() &&
//STRIP001 		 SfxViewFrame::Current()->HasChildWindow( SvxIMapDlgChildWindow::GetChildWindowId() ) )
//STRIP001 		SVXIMAPDLG()->Update( rGraphic, pImageMap, pTargetList, pEditingObj );
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 SvxIMapDlg::SvxIMapDlg( SfxBindings *pBindings, SfxChildWindow *pCW,
//STRIP001 						Window* pParent, const ResId& rResId ) :
//STRIP001 		SfxModelessDialog	( pBindings, pCW, pParent, rResId ),
//STRIP001 		aIMapItem			( SID_IMAP_EXEC, *this, *pBindings ),
//STRIP001 		aTbxIMapDlg1		( this, SVX_RES( TBX_IMAPDLG1 ) ),
//STRIP001 		aStbStatus			( this, WB_BORDER | WB_3DLOOK | WB_LEFT ),
//STRIP001 		pCheckObj			( NULL ),
//STRIP001 		aFtURL				( this, SVX_RES( FT_URL ) ),
//STRIP001 		maURLBox			( this, SVX_RES( CBB_URL ) ),
//STRIP001 		aFtText				( this, SVX_RES( FT_TEXT ) ),
//STRIP001 		aEdtText			( this, SVX_RES( EDT_TEXT ) ),
//STRIP001 		maFtTarget			( this, SVX_RES( RID_SVXCTL_FT_TARGET ) ),
//STRIP001 		maCbbTarget			( this, SVX_RES( RID_SVXCTL_CBB_TARGET ) ),
//STRIP001 		maImageList			( SVX_RES( IL_IMAPDLG ) ),
//STRIP001 		maImageListH		( SVX_RES( ILH_IMAPDLG ) )
//STRIP001 {
//STRIP001 	pIMapWnd = new IMapWindow( this, SVX_RES( RID_SVXCTL_IMAP ) );
//STRIP001 
//STRIP001     ApplyImageList();
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	pOwnData = new IMapOwnData( this );
//STRIP001 
//STRIP001 	pIMapWnd->SetInfoLink( LINK( this, SvxIMapDlg, InfoHdl ) );
//STRIP001 	pIMapWnd->SetMousePosLink( LINK( this, SvxIMapDlg, MousePosHdl ) );
//STRIP001 	pIMapWnd->SetGraphSizeLink( LINK( this, SvxIMapDlg, GraphSizeHdl ) );
//STRIP001 	pIMapWnd->SetUpdateLink( LINK( this, SvxIMapDlg, StateHdl ) );
//STRIP001 
//STRIP001 	maURLBox.SetModifyHdl( LINK( this, SvxIMapDlg, URLModifyHdl ) );
//STRIP001 	maURLBox.SetSelectHdl( LINK( this, SvxIMapDlg, URLModifyHdl ) );
//STRIP001 	maURLBox.SetLoseFocusHdl( LINK( this, SvxIMapDlg, URLLoseFocusHdl ) );
//STRIP001 	aEdtText.SetModifyHdl( LINK( this, SvxIMapDlg, URLModifyHdl ) );
//STRIP001 	maCbbTarget.SetLoseFocusHdl( LINK( this, SvxIMapDlg, URLLoseFocusHdl ) );
//STRIP001 
//STRIP001    	SvtMiscOptions aMiscOptions;
//STRIP001     aMiscOptions.AddListener( LINK( this, SvxIMapDlg, MiscHdl ) );
//STRIP001 
//STRIP001     aTbxIMapDlg1.SetOutStyle( aMiscOptions.GetToolboxStyle() );
//STRIP001 	aTbxIMapDlg1.SetSizePixel( aTbxIMapDlg1.CalcWindowSizePixel() );
//STRIP001 	aTbxIMapDlg1.SetSelectHdl( LINK( this, SvxIMapDlg, TbxClickHdl ) );
//STRIP001 	aTbxIMapDlg1.CheckItem( TBI_SELECT, TRUE );
//STRIP001 	TbxClickHdl( &aTbxIMapDlg1 );
//STRIP001 
//STRIP001 	SetMinOutputSizePixel( aLastSize = GetOutputSizePixel() );
//STRIP001 
//STRIP001 	aStbStatus.InsertItem( 1, 130, SIB_LEFT | SIB_IN | SIB_AUTOSIZE );
//STRIP001 	aStbStatus.InsertItem( 2, 10 + GetTextWidth( DEFINE_CONST_UNICODE( " 9999,99 cm / 9999,99 cm ") ), SIB_CENTER | SIB_IN );
//STRIP001 	aStbStatus.InsertItem( 3, 10 + GetTextWidth( DEFINE_CONST_UNICODE( " 9999,99 cm x 9999,99 cm ") ), SIB_CENTER | SIB_IN );
//STRIP001 
//STRIP001 	aFtURL.Disable();
//STRIP001 	maURLBox.Disable();
//STRIP001 	aFtText.Disable();
//STRIP001 	aEdtText.Disable();
//STRIP001 	maFtTarget.Disable();
//STRIP001 	maCbbTarget.Disable();
//STRIP001 	pOwnData->bExecState = FALSE;
//STRIP001 
//STRIP001 	Resize();
//STRIP001 
//STRIP001 	pOwnData->aTimer.SetTimeout( 100 );
//STRIP001 	pOwnData->aTimer.SetTimeoutHdl( LINK( this, SvxIMapDlg, UpdateHdl ) );
//STRIP001 
//STRIP001 	aTbxIMapDlg1.EnableItem( TBI_ACTIVE, FALSE );
//STRIP001 	aTbxIMapDlg1.EnableItem( TBI_MACRO, FALSE );
//STRIP001 	aTbxIMapDlg1.EnableItem( TBI_PROPERTY, FALSE );
//STRIP001 }


/*************************************************************************
|*
|* Dtor
|*
\************************************************************************/

//STRIP001 SvxIMapDlg::~SvxIMapDlg()
//STRIP001 {
//STRIP001 	// URL-Liste loeschen
//STRIP001 	delete pIMapWnd;
//STRIP001 	delete pOwnData;
//STRIP001 }


/*************************************************************************
|*
|* Resize-Methode
|*
\************************************************************************/

//STRIP001 void SvxIMapDlg::Resize()
//STRIP001 {
//STRIP001 	SfxModelessDialog::Resize();
//STRIP001 
//STRIP001 	Size aMinSize( GetMinOutputSizePixel() );
//STRIP001 	Size aNewSize( GetOutputSizePixel() );
//STRIP001 
//STRIP001 	if ( aNewSize.Height() >= aMinSize.Height() )
//STRIP001 	{
//STRIP001 		Size	aSize( aStbStatus.GetSizePixel() );
//STRIP001 		Point	aPoint( 0, aNewSize.Height() - aSize.Height() );
//STRIP001 
//STRIP001 		// StatusBar positionieren
//STRIP001 		aStbStatus.SetPosSizePixel( aPoint, Size( aNewSize.Width(), aSize.Height() ) );
//STRIP001 		aStbStatus.Show();
//STRIP001 
//STRIP001 		// EditWindow positionieren
//STRIP001 		aSize.Width() = aNewSize.Width() - 18;
//STRIP001 		aSize.Height() = aPoint.Y() - pIMapWnd->GetPosPixel().Y() - 6;
//STRIP001 		pIMapWnd->SetSizePixel( aSize );
//STRIP001 
//STRIP001 		aLastSize = aNewSize;
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|* Close-Methode
|*
\************************************************************************/

//STRIP001 BOOL SvxIMapDlg::Close()
//STRIP001 {
//STRIP001 	BOOL bRet = TRUE;
//STRIP001 
//STRIP001 	if ( aTbxIMapDlg1.IsItemEnabled( TBI_APPLY ) )
//STRIP001 	{
//STRIP001 		QueryBox	aQBox( this, WB_YES_NO_CANCEL | WB_DEF_YES,
//STRIP001 						   String( SVX_RES( STR_IMAPDLG_MODIFY ) ) );
//STRIP001 		const long	nRet = aQBox.Execute();
//STRIP001 
//STRIP001 		if( nRet == RET_YES )
//STRIP001 		{
//STRIP001 			SfxBoolItem aBoolItem( SID_IMAP_EXEC, TRUE );
//STRIP001 			GetBindings().GetDispatcher()->Execute(
//STRIP001 				SID_IMAP_EXEC, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD, &aBoolItem, 0L );
//STRIP001 		}
//STRIP001 		else if( nRet == RET_CANCEL )
//STRIP001 			bRet = FALSE;
//STRIP001 	}
//STRIP001 	else if( pIMapWnd->IsChanged() )
//STRIP001 	{
//STRIP001 		QueryBox	aQBox( this, WB_YES_NO_CANCEL | WB_DEF_YES,
//STRIP001 						   String( SVX_RES( STR_IMAPDLG_SAVE ) ) );
//STRIP001 		const long	nRet = aQBox.Execute();
//STRIP001 
//STRIP001 		if( nRet == RET_YES )
//STRIP001 			bRet = DoSave();
//STRIP001 		else if( nRet == RET_CANCEL )
//STRIP001 			bRet = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return( bRet ? SfxModelessDialog::Close() : FALSE );
//STRIP001 }


/*************************************************************************
|*
|* Enabled oder disabled alle Controls
|*
\************************************************************************/

//STRIP001 void SvxIMapDlg::SetExecState( BOOL bEnable )
//STRIP001 {
//STRIP001 	pOwnData->bExecState = bEnable;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SvxIMapDlg::SetGraphic( const Graphic& rGraphic )
//STRIP001 {
//STRIP001 	pIMapWnd->SetGraphic( rGraphic );
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SvxIMapDlg::SetImageMap( const ImageMap& rImageMap )
//STRIP001 {
//STRIP001 	pIMapWnd->SetImageMap( rImageMap );
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 const ImageMap& SvxIMapDlg::GetImageMap() const
//STRIP001 {
//STRIP001 	return pIMapWnd->GetImageMap();
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SvxIMapDlg::SetTargetList( const TargetList& rTargetList )
//STRIP001 {
//STRIP001 	TargetList	aNewList( rTargetList );
//STRIP001 
//STRIP001 	pIMapWnd->SetTargetList( aNewList );
//STRIP001 
//STRIP001 	maCbbTarget.Clear();
//STRIP001 
//STRIP001 	for( String* pStr = aNewList.First(); pStr; pStr = aNewList.Next() )
//STRIP001 		maCbbTarget.InsertEntry( *pStr );
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 const TargetList& SvxIMapDlg::GetTargetList() const
//STRIP001 {
//STRIP001 	return pIMapWnd->GetTargetList();
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SvxIMapDlg::Update( const Graphic& rGraphic, const ImageMap* pImageMap,
//STRIP001 						 const TargetList* pTargetList, void* pEditingObj )
//STRIP001 {
//STRIP001 	pOwnData->aUpdateGraphic = rGraphic;
//STRIP001 
//STRIP001 	if ( pImageMap )
//STRIP001 		pOwnData->aUpdateImageMap = *pImageMap;
//STRIP001 	else
//STRIP001 		pOwnData->aUpdateImageMap.ClearImageMap();
//STRIP001 
//STRIP001 	pOwnData->pUpdateEditingObject = pEditingObj;
//STRIP001 
//STRIP001 	// UpdateTargetList loeschen, da diese Methode
//STRIP001 	// vor dem Zuschlagen des Update-Timers noch
//STRIP001 	// mehrmals gerufen werden kann( #46540 )
//STRIP001 	for( String* pStr = pOwnData->aUpdateTargetList.First(); pStr; pStr = pOwnData->aUpdateTargetList.Next() )
//STRIP001 		delete pStr;
//STRIP001 	pOwnData->aUpdateTargetList.Clear();
//STRIP001 
//STRIP001 	// TargetListe muss kopiert werden, da sie im
//STRIP001 	// Besitz des Aufrufers ist und von ihm nach diesem
//STRIP001 	// Aufruf sofort geloescht werden kann;
//STRIP001 	// die kopierte Liste wird im Handler wieder geloescht
//STRIP001 	if( pTargetList )
//STRIP001 	{
//STRIP001 		TargetList aTargetList( *pTargetList );
//STRIP001 
//STRIP001 		for( String* pStr = aTargetList.First(); pStr; pStr = aTargetList.Next() )
//STRIP001 			pOwnData->aUpdateTargetList.Insert( new String( *pStr ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	pOwnData->aTimer.Start();
//STRIP001 }


//STRIP001 void SvxIMapDlg::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001 		SfxModelessDialog::KeyInput( rKEvt );
//STRIP001 }

/*************************************************************************
|*
|* Click-Hdl fuer ToolBox
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxIMapDlg, TbxClickHdl, ToolBox*, pTbx )
//STRIP001 {
//STRIP001 	USHORT nNewItemId = pTbx->GetCurItemId();
//STRIP001 
//STRIP001 	switch( pTbx->GetCurItemId() )
//STRIP001 	{
//STRIP001 		case( TBI_APPLY ):
//STRIP001 		{
//STRIP001         	URLLoseFocusHdl( NULL );
//STRIP001 			SfxBoolItem aBoolItem( SID_IMAP_EXEC, TRUE );
//STRIP001 			GetBindings().GetDispatcher()->Execute(
//STRIP001 				SID_IMAP_EXEC, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aBoolItem, 0L );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_OPEN ):
//STRIP001 			DoOpen();
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_SAVEAS ):
//STRIP001 			DoSave();
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_SELECT ):
//STRIP001 		{
//STRIP001 			pTbx->CheckItem( nNewItemId, TRUE );
//STRIP001 			pIMapWnd->SetEditMode( TRUE );
//STRIP001 			if( pTbx->IsKeyEvent() )
//STRIP001 			{
//STRIP001 				if((pTbx->GetKeyModifier() & KEY_MOD1) != 0)
//STRIP001 					pIMapWnd->SelectFirstObject();
//STRIP001 				else
//STRIP001 					pIMapWnd->GrabFocus();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_RECT ):
//STRIP001 		{
//STRIP001 			pTbx->CheckItem( nNewItemId, TRUE );
//STRIP001 			pIMapWnd->SetObjKind( OBJ_RECT );
//STRIP001 			if( pTbx->IsKeyEvent() && ((pTbx->GetKeyModifier() & KEY_MOD1) != 0) )
//STRIP001 			{
//STRIP001 				pIMapWnd->CreateDefaultObject();
//STRIP001 				pIMapWnd->GrabFocus();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_CIRCLE ):
//STRIP001 		{
//STRIP001 			pTbx->CheckItem( nNewItemId, TRUE );
//STRIP001 			pIMapWnd->SetObjKind( OBJ_CIRC );
//STRIP001 			if( pTbx->IsKeyEvent() && ((pTbx->GetKeyModifier() & KEY_MOD1) != 0) )
//STRIP001 			{
//STRIP001 				pIMapWnd->CreateDefaultObject();
//STRIP001 				pIMapWnd->GrabFocus();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_POLY ):
//STRIP001 		{
//STRIP001 			pTbx->CheckItem( nNewItemId, TRUE );
//STRIP001 			pIMapWnd->SetObjKind( OBJ_POLY );
//STRIP001 			if( pTbx->IsKeyEvent() && ((pTbx->GetKeyModifier() & KEY_MOD1) != 0) )
//STRIP001 			{
//STRIP001 				pIMapWnd->CreateDefaultObject();
//STRIP001 				pIMapWnd->GrabFocus();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_FREEPOLY ):
//STRIP001 		{
//STRIP001 			pTbx->CheckItem( nNewItemId, TRUE );
//STRIP001 			pIMapWnd->SetObjKind( OBJ_FREEFILL );
//STRIP001 			if( pTbx->IsKeyEvent() && ((pTbx->GetKeyModifier() & KEY_MOD1) != 0) )
//STRIP001 			{
//STRIP001 				pIMapWnd->CreateDefaultObject();
//STRIP001 				pIMapWnd->GrabFocus();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_ACTIVE ):
//STRIP001 		{
//STRIP001         	URLLoseFocusHdl( NULL );
//STRIP001             BOOL bNewState = !pTbx->IsItemChecked( TBI_ACTIVE );
//STRIP001 			pTbx->CheckItem( TBI_ACTIVE, bNewState );
//STRIP001 			pIMapWnd->SetCurrentObjState( !bNewState );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_MACRO ):
//STRIP001 			pIMapWnd->DoMacroAssign();
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_PROPERTY ):
//STRIP001 			pIMapWnd->DoPropertyDialog();
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_POLYEDIT ):
//STRIP001 			pIMapWnd->SetPolyEditMode( pTbx->IsItemChecked( TBI_POLYEDIT ) ? SID_BEZIER_MOVE : 0 );
//STRIP001 			if( pTbx->IsKeyEvent() && pTbx->IsItemChecked( TBI_POLYEDIT ) )
//STRIP001 				pIMapWnd->StartPolyEdit();
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_POLYMOVE ):
//STRIP001 			pIMapWnd->SetPolyEditMode( SID_BEZIER_MOVE );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_POLYINSERT ):
//STRIP001 			pIMapWnd->SetPolyEditMode( SID_BEZIER_INSERT );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_POLYDELETE ):
//STRIP001 			pIMapWnd->GetSdrView()->DeleteMarkedPoints();
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_UNDO ):
//STRIP001         {
//STRIP001         	URLLoseFocusHdl( NULL );
//STRIP001 			pIMapWnd->GetSdrModel()->Undo();
//STRIP001         }
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( TBI_REDO ):
//STRIP001         {
//STRIP001         	URLLoseFocusHdl( NULL );
//STRIP001 			pIMapWnd->GetSdrModel()->Redo();
//STRIP001         }
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SvxIMapDlg::DoOpen()
//STRIP001 {
//STRIP001    	::sfx2::FileDialogHelper aDlg( ::sfx2::FILEOPEN_SIMPLE, 0 );
//STRIP001 
//STRIP001 	ImageMap		aLoadIMap;
//STRIP001 	const String	aFilter( DEFINE_CONST_UNICODE( IMAP_ALL_FILTER ) );
//STRIP001 
//STRIP001 	aDlg.AddFilter( aFilter, DEFINE_CONST_UNICODE( IMAP_ALL_TYPE ) );
//STRIP001 	aDlg.AddFilter( DEFINE_CONST_UNICODE( IMAP_CERN_FILTER ), DEFINE_CONST_UNICODE( IMAP_CERN_TYPE ) );
//STRIP001 	aDlg.AddFilter( DEFINE_CONST_UNICODE( IMAP_NCSA_FILTER ), DEFINE_CONST_UNICODE( IMAP_NCSA_TYPE ) );
//STRIP001 	aDlg.AddFilter( DEFINE_CONST_UNICODE( IMAP_BINARY_FILTER ), DEFINE_CONST_UNICODE( IMAP_BINARY_TYPE ) );
//STRIP001 
//STRIP001 	aDlg.SetCurrentFilter( aFilter );
//STRIP001 	aDlg.SetDisplayDirectory( SvtPathOptions().GetWorkPath() );
//STRIP001 
//STRIP001 	if( aDlg.Execute() == ERRCODE_NONE )
//STRIP001 	{
//STRIP001 		INetURLObject aURL( aDlg.GetPath() );
//STRIP001 		DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 		SvStream* pIStm = ::utl::UcbStreamHelper::CreateStream( aURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_READ );
//STRIP001 
//STRIP001 		if( pIStm )
//STRIP001 		{
//STRIP001 			aLoadIMap.Read( *pIStm, IMAP_FORMAT_DETECT );
//STRIP001 
//STRIP001 			if( pIStm->GetError() )
//STRIP001 				ErrorHandler::HandleError( ERRCODE_IO_GENERAL );
//STRIP001 			else
//STRIP001 				pIMapWnd->SetImageMap( aLoadIMap );
//STRIP001 
//STRIP001 			delete pIStm;
//STRIP001 		}
//STRIP001 
//STRIP001 		pIMapWnd->Invalidate();
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 BOOL SvxIMapDlg::DoSave()
//STRIP001 {
//STRIP001    	::sfx2::FileDialogHelper aDlg( ::sfx2::FILESAVE_SIMPLE, 0 );
//STRIP001 
//STRIP001 	const String	aBinFilter( DEFINE_CONST_UNICODE( IMAP_BINARY_FILTER ) );
//STRIP001 	const String	aCERNFilter( DEFINE_CONST_UNICODE( IMAP_CERN_FILTER ) );
//STRIP001 	const String	aNCSAFilter( DEFINE_CONST_UNICODE( IMAP_NCSA_FILTER ) );
//STRIP001 	SdrModel*		pModel = pIMapWnd->GetSdrModel();
//STRIP001 	const BOOL		bChanged = pModel->IsChanged();
//STRIP001 	BOOL			bRet;
//STRIP001 
//STRIP001 	aDlg.AddFilter( aCERNFilter, DEFINE_CONST_UNICODE( IMAP_CERN_TYPE ) );
//STRIP001 	aDlg.AddFilter( aNCSAFilter, DEFINE_CONST_UNICODE( IMAP_NCSA_TYPE ) );
//STRIP001 	aDlg.AddFilter( aBinFilter, DEFINE_CONST_UNICODE( IMAP_BINARY_TYPE ) );
//STRIP001 
//STRIP001 	aDlg.SetCurrentFilter( aCERNFilter );
//STRIP001 	aDlg.SetDisplayDirectory( SvtPathOptions().GetWorkPath() );
//STRIP001 
//STRIP001 	if( aDlg.Execute() == ERRCODE_NONE )
//STRIP001 	{
//STRIP001 		const String	aFilter( aDlg.GetCurrentFilter() );
//STRIP001 		String			aExt;
//STRIP001 		ULONG			nFormat;
//STRIP001 
//STRIP001 		if ( aFilter == aBinFilter )
//STRIP001 		{
//STRIP001 			nFormat = IMAP_FORMAT_BIN;
//STRIP001 			aExt = DEFINE_CONST_UNICODE( IMAP_BINARY_EXT );
//STRIP001 		}
//STRIP001 		else if ( aFilter == aCERNFilter )
//STRIP001 		{
//STRIP001 			nFormat = IMAP_FORMAT_CERN;
//STRIP001 			aExt = DEFINE_CONST_UNICODE( IMAP_CERN_EXT );
//STRIP001 		}
//STRIP001 		else if ( aFilter == aNCSAFilter )
//STRIP001 		{
//STRIP001 			nFormat = IMAP_FORMAT_NCSA;
//STRIP001 			aExt = DEFINE_CONST_UNICODE( IMAP_NCSA_EXT );
//STRIP001 		}
//STRIP001 
//STRIP001 		INetURLObject aURL( aDlg.GetPath() );
//STRIP001 
//STRIP001 		if( aURL.GetProtocol() == INET_PROT_NOT_VALID )
//STRIP001 		{
//STRIP001 			DBG_ERROR( "invalid URL" );
//STRIP001 			bRet = FALSE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if( !aURL.getExtension().Len() )
//STRIP001 				aURL.setExtension( aExt );
//STRIP001 
//STRIP001 			SvStream* pOStm = ::utl::UcbStreamHelper::CreateStream( aURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_WRITE | STREAM_TRUNC );
//STRIP001 
//STRIP001 			if( pOStm )
//STRIP001 			{
//STRIP001 				pIMapWnd->GetImageMap().Write( *pOStm, nFormat );
//STRIP001 
//STRIP001 				if( pOStm->GetError() )
//STRIP001 					ErrorHandler::HandleError( ERRCODE_IO_GENERAL );
//STRIP001 
//STRIP001 				delete pOStm;
//STRIP001 				pModel->SetChanged( bChanged );
//STRIP001 				bRet = TRUE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				bRet = FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		bRet = FALSE;
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxIMapDlg, InfoHdl, IMapWindow*, pWnd )
//STRIP001 {
//STRIP001 	String				aStr;
//STRIP001 	const NotifyInfo&	rInfo = pWnd->GetInfo();
//STRIP001 
//STRIP001 	if ( rInfo.bNewObj )
//STRIP001 	{
//STRIP001 		if( rInfo.aMarkURL.Len() && ( maURLBox.GetEntryPos( rInfo.aMarkURL ) == LISTBOX_ENTRY_NOTFOUND ) )
//STRIP001 			maURLBox.InsertEntry( rInfo.aMarkURL );
//STRIP001 
//STRIP001 		maURLBox.SetText( rInfo.aMarkURL );
//STRIP001 		aEdtText.SetText( rInfo.aMarkDescription );
//STRIP001 
//STRIP001 		if ( !rInfo.aMarkTarget.Len() )
//STRIP001 			maCbbTarget.SetText( DEFINE_CONST_UNICODE( SELF_TARGET ) );
//STRIP001 		else
//STRIP001 			maCbbTarget.SetText( rInfo.aMarkTarget );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !rInfo.bOneMarked )
//STRIP001 	{
//STRIP001 		aTbxIMapDlg1.CheckItem( TBI_ACTIVE, FALSE );
//STRIP001 		aTbxIMapDlg1.EnableItem( TBI_ACTIVE, FALSE );
//STRIP001 		aTbxIMapDlg1.EnableItem( TBI_MACRO, FALSE );
//STRIP001 		aTbxIMapDlg1.EnableItem( TBI_PROPERTY, FALSE );
//STRIP001 		aStbStatus.SetItemText( 1, aStr );
//STRIP001 
//STRIP001 		aFtURL.Disable();
//STRIP001 		maURLBox.Disable();
//STRIP001 		aFtText.Disable();
//STRIP001 		aEdtText.Disable();
//STRIP001 		maFtTarget.Disable();
//STRIP001 		maCbbTarget.Disable();
//STRIP001 
//STRIP001 		maURLBox.SetText( String() );
//STRIP001 		aEdtText.SetText( String() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aTbxIMapDlg1.EnableItem( TBI_ACTIVE, TRUE );
//STRIP001 		aTbxIMapDlg1.CheckItem( TBI_ACTIVE, !rInfo.bActivated );
//STRIP001 		aTbxIMapDlg1.EnableItem( TBI_MACRO, TRUE );
//STRIP001 		aTbxIMapDlg1.EnableItem( TBI_PROPERTY, TRUE );
//STRIP001 
//STRIP001 		aFtURL.Enable();
//STRIP001 		maURLBox.Enable();
//STRIP001 		aFtText.Enable();
//STRIP001 		aEdtText.Enable();
//STRIP001 		maFtTarget.Enable();
//STRIP001 		maCbbTarget.Enable();
//STRIP001 
//STRIP001 		aStbStatus.SetItemText( 1, rInfo.aMarkURL );
//STRIP001 
//STRIP001 		if ( maURLBox.GetText() != rInfo.aMarkURL )
//STRIP001 			maURLBox.SetText( rInfo.aMarkURL );
//STRIP001 
//STRIP001 		if ( aEdtText.GetText() != rInfo.aMarkDescription )
//STRIP001 			aEdtText.SetText( rInfo.aMarkDescription );
//STRIP001 
//STRIP001 		if ( !rInfo.aMarkTarget.Len() )
//STRIP001 			maCbbTarget.SetText( DEFINE_CONST_UNICODE( SELF_TARGET ) );
//STRIP001 		else
//STRIP001 			maCbbTarget.SetText(  rInfo.aMarkTarget );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxIMapDlg, MousePosHdl, IMapWindow*, pWnd )
//STRIP001 {
//STRIP001 	String aStr;
//STRIP001 	const FieldUnit eFieldUnit = GetModuleFieldUnit();
//STRIP001 	const Point& rMousePos = pWnd->GetMousePos();
//STRIP001 	LocaleDataWrapper aLocaleWrapper( ::legacy_binfilters::getLegacyProcessServiceFactory(), Application::GetSettings().GetLocale() );
//STRIP001 	const sal_Unicode cSep = aLocaleWrapper.getNumDecimalSep().GetChar(0);
//STRIP001 
//STRIP001 	aStr.Assign( GetUnitString( rMousePos.X(), eFieldUnit, cSep ) );
//STRIP001 	aStr.Append( DEFINE_CONST_UNICODE( " / " ) );
//STRIP001 	aStr.Append( GetUnitString( rMousePos.Y(), eFieldUnit, cSep ) );
//STRIP001 
//STRIP001 	aStbStatus.SetItemText( 2, aStr );
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxIMapDlg, GraphSizeHdl, IMapWindow*, pWnd )
//STRIP001 {
//STRIP001 	String aStr;
//STRIP001 	const FieldUnit eFieldUnit = GetModuleFieldUnit();
//STRIP001 	const Size&	rSize = pWnd->GetGraphicSize();
//STRIP001 	LocaleDataWrapper aLocaleWrapper( ::legacy_binfilters::getLegacyProcessServiceFactory(), Application::GetSettings().GetLocale() );
//STRIP001 	const sal_Unicode cSep = aLocaleWrapper.getNumDecimalSep().GetChar(0);
//STRIP001 
//STRIP001 	aStr.Assign( GetUnitString( rSize.Width(), eFieldUnit, cSep ) );
//STRIP001 	aStr.Append( DEFINE_CONST_UNICODE( " x " ) );
//STRIP001 	aStr.Append( GetUnitString( rSize.Height(), eFieldUnit, cSep ) );
//STRIP001 
//STRIP001 	aStbStatus.SetItemText( 3, aStr );
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxIMapDlg, URLModifyHdl, void*, p )
//STRIP001 {
//STRIP001 	NotifyInfo	aNewInfo;
//STRIP001 
//STRIP001 	aNewInfo.aMarkURL = maURLBox.GetText();
//STRIP001 	aNewInfo.aMarkDescription = aEdtText.GetText();
//STRIP001 	aNewInfo.aMarkTarget = maCbbTarget.GetText();
//STRIP001 
//STRIP001 	pIMapWnd->ReplaceActualIMapInfo( aNewInfo );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxIMapDlg, URLLoseFocusHdl, void*, p )
//STRIP001 {
//STRIP001 	NotifyInfo		aNewInfo;
//STRIP001 	const String	aURLText( maURLBox.GetText() );
//STRIP001 	const String	aTargetText( maCbbTarget.GetText() );
//STRIP001 
//STRIP001 	if ( aURLText.Len() )
//STRIP001 	{
//STRIP001 		aNewInfo.aMarkURL = so3::StaticBaseUrl::SmartRelToAbs( aURLText, FALSE,
//STRIP001 														INetURLObject::WAS_ENCODED,
//STRIP001 														INetURLObject::DECODE_UNAMBIGUOUS );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aNewInfo.aMarkURL = aURLText;
//STRIP001 
//STRIP001 	aNewInfo.aMarkDescription = aEdtText.GetText();
//STRIP001 
//STRIP001 	if ( !aTargetText.Len() )
//STRIP001 		aNewInfo.aMarkTarget = DEFINE_CONST_UNICODE( SELF_TARGET );
//STRIP001 	else
//STRIP001 		aNewInfo.aMarkTarget = aTargetText;
//STRIP001 
//STRIP001 	pIMapWnd->ReplaceActualIMapInfo( aNewInfo );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxIMapDlg, UpdateHdl, Timer*, pTimer )
//STRIP001 {
//STRIP001 	pOwnData->aTimer.Stop();
//STRIP001 
//STRIP001 	if ( pOwnData->pUpdateEditingObject != pCheckObj )
//STRIP001 	{
//STRIP001 		if ( pIMapWnd->IsChanged() &&
//STRIP001 			 ( QueryBox( this, WB_YES_NO | WB_DEF_YES,
//STRIP001 			 String( SVX_RES( STR_IMAPDLG_SAVE ) ) ).Execute() == RET_YES ) )
//STRIP001 		{
//STRIP001 			DoSave();
//STRIP001 		}
//STRIP001 
//STRIP001 		SetGraphic( pOwnData->aUpdateGraphic );
//STRIP001 		SetImageMap( pOwnData->aUpdateImageMap );
//STRIP001 		SetTargetList( pOwnData->aUpdateTargetList );
//STRIP001 		SetEditingObject( pOwnData->pUpdateEditingObject );
//STRIP001 
//STRIP001 		// Nach Wechsel => default Selektion
//STRIP001 		aTbxIMapDlg1.CheckItem( TBI_SELECT, TRUE );
//STRIP001 		pIMapWnd->SetEditMode( TRUE );
//STRIP001 	}
//STRIP001 
//STRIP001 	// die in der Update-Methode kopierte Liste wieder loeschen
//STRIP001 	for( String* pStr = pOwnData->aUpdateTargetList.First(); pStr; pStr = pOwnData->aUpdateTargetList.Next() )
//STRIP001 		delete pStr;
//STRIP001 
//STRIP001 	pOwnData->aUpdateTargetList.Clear();
//STRIP001 
//STRIP001 	GetBindings().Invalidate( SID_IMAP_EXEC );
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxIMapDlg, StateHdl, IMapWindow*, pWnd )
//STRIP001 {
//STRIP001 	const SdrObject*	pObj = pWnd->GetSelectedSdrObject();
//STRIP001 	const SdrModel*		pModel = pWnd->GetSdrModel();
//STRIP001 	const SdrView*		pView = pWnd->GetSdrView();
//STRIP001 	const BOOL			bPolyEdit = ( pObj != NULL ) && pObj->ISA( SdrPathObj );
//STRIP001 	const BOOL			bDrawEnabled = !( bPolyEdit && aTbxIMapDlg1.IsItemChecked( TBI_POLYEDIT ) );
//STRIP001 
//STRIP001 	aTbxIMapDlg1.EnableItem( TBI_APPLY, pOwnData->bExecState && pWnd->IsChanged() );
//STRIP001 
//STRIP001 	aTbxIMapDlg1.EnableItem( TBI_SELECT, bDrawEnabled );
//STRIP001 	aTbxIMapDlg1.EnableItem( TBI_RECT, bDrawEnabled );
//STRIP001 	aTbxIMapDlg1.EnableItem( TBI_CIRCLE, bDrawEnabled );
//STRIP001 	aTbxIMapDlg1.EnableItem( TBI_POLY, bDrawEnabled );
//STRIP001 	aTbxIMapDlg1.EnableItem( TBI_FREEPOLY, bDrawEnabled );
//STRIP001 
//STRIP001 	// BezierEditor-Stati
//STRIP001 	aTbxIMapDlg1.EnableItem( TBI_POLYEDIT, bPolyEdit );
//STRIP001 	aTbxIMapDlg1.EnableItem( TBI_POLYMOVE, !bDrawEnabled );
//STRIP001 	aTbxIMapDlg1.EnableItem( TBI_POLYINSERT, !bDrawEnabled );
//STRIP001 	aTbxIMapDlg1.EnableItem( TBI_POLYDELETE, !bDrawEnabled && pView->IsDeleteMarkedPointsPossible() );
//STRIP001 
//STRIP001 	// Undo/Redo
//STRIP001 	aTbxIMapDlg1.EnableItem( TBI_UNDO, pModel->GetUndoActionCount() > 0 );
//STRIP001 	aTbxIMapDlg1.EnableItem( TBI_REDO, pModel->GetRedoActionCount() > 0 );
//STRIP001 
//STRIP001 	if ( bPolyEdit )
//STRIP001 	{
//STRIP001 		USHORT nId = 0;
//STRIP001 
//STRIP001 		switch( pWnd->GetPolyEditMode() )
//STRIP001 		{
//STRIP001 			case( SID_BEZIER_MOVE ): nId = TBI_POLYMOVE; break;
//STRIP001 			case( SID_BEZIER_INSERT ): nId = TBI_POLYINSERT; break;
//STRIP001 
//STRIP001 			default:
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		aTbxIMapDlg1.CheckItem( nId, TRUE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aTbxIMapDlg1.CheckItem( TBI_POLYEDIT, FALSE );
//STRIP001 		aTbxIMapDlg1.CheckItem( TBI_POLYMOVE, TRUE );
//STRIP001 		aTbxIMapDlg1.CheckItem( TBI_POLYINSERT, FALSE );
//STRIP001 		pWnd->SetPolyEditMode( 0 );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxIMapDlg, MiscHdl, void*, p )
//STRIP001 {
//STRIP001    	SvtMiscOptions aMiscOptions;
//STRIP001     aTbxIMapDlg1.SetOutStyle( aMiscOptions.GetToolboxStyle() );
//STRIP001 
//STRIP001     return 0L;
//STRIP001 }

//STRIP001 void SvxIMapDlg::ApplyImageList()
//STRIP001 {
//STRIP001 	bool bHighContrast = GetDisplayBackground().GetColor().IsDark() != 0;
//STRIP001 
//STRIP001     ImageList& rImgLst = bHighContrast ? maImageListH : maImageList;
//STRIP001 
//STRIP001 	aTbxIMapDlg1.SetImageList( rImgLst );
//STRIP001 }

//STRIP001 void SvxIMapDlg::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001     SfxModelessDialog::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001             ApplyImageList();
//STRIP001 }
} //namespace binfilter
