/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_hltpbase.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:49:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFXFRAME_HXX
#include <bf_sfx2/frame.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX
#include <bf_sfx2/viewfrm.hxx>
#endif
#ifndef _SOT_FORMATS_HXX
#include <sot/formats.hxx>
#endif
#include <bf_sfx2/sfxsids.hrc>
#define ITEMID_MACRO SID_ATTR_MACROITEM
#ifndef _SFXMACITEM_HXX
#include <svtools/macitem.hxx>
#endif
#ifndef _UCBHELPER_CONTENT_HXX 
#include <ucbhelper/content.hxx>
#endif
#ifndef _UNOTOOLS_LOCALFILEHELPER_HXX
#include <unotools/localfilehelper.hxx>
#endif
#include "hyperdlg.hrc"
#ifndef _SVX_TAB_HYPERLINK_HXX
#include "hyperdlg.hxx"
#endif
#include "hltpbase.hxx"
namespace binfilter {

using namespace ucb;

//########################################################################
//#                                                                      #
//# ComboBox-Control, wich is filled with all current framenames         #
//#                                                                      #
//########################################################################

/*************************************************************************
|*
|* Contructor / Destructor
|*
|************************************************************************/

//STRIP001 SvxFramesComboBox::SvxFramesComboBox ( Window* pParent, WinBits nStyle )
//STRIP001 :	::com::boBox (pParent, nStyle)
//STRIP001 {
//STRIP001 	GetCurrentFrameNames ();
//STRIP001 }
//STRIP001 
//STRIP001 SvxFramesComboBox::SvxFramesComboBox ( Window* pParent, const ResId& rResId )
//STRIP001 :	::com::boBox (pParent, rResId)
//STRIP001 {
//STRIP001 	GetCurrentFrameNames ();
//STRIP001 }
//STRIP001 
//STRIP001 SvxFramesComboBox::~SvxFramesComboBox ()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Fill list with curretn known framenames
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 BOOL SvxFramesComboBox::GetCurrentFrameNames ()
//STRIP001 {
//STRIP001 	TargetList* pList = new TargetList;
//STRIP001 	const SfxFrame* pFrame = SFX_APP()->GetViewFrame()->GetTopFrame();
//STRIP001 	if ( pFrame )
//STRIP001 	{
//STRIP001 		pFrame->GetTargetList(*pList);
//STRIP001 		USHORT nCount = (USHORT)pList->Count();
//STRIP001 		if( nCount )
//STRIP001 		{
//STRIP001 			USHORT i;
//STRIP001 			for ( i = 0; i < nCount; i++ )
//STRIP001 			{
//STRIP001 				InsertEntry(*pList->GetObject(i));
//STRIP001 			}
//STRIP001 			for ( i = nCount; i; i-- )
//STRIP001 			{
//STRIP001 				delete pList->GetObject( i - 1 );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		delete pList;
//STRIP001 	}
//STRIP001 
//STRIP001 	return pFrame!=NULL;
//STRIP001 }
//STRIP001 
//STRIP001 //########################################################################
//STRIP001 //#																		 #
//STRIP001 //# ComboBox-Control for URL's with History and Autocompletion			 #
//STRIP001 //#																		 #
//STRIP001 //########################################################################
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Contructor / Destructor
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 SvxHyperURLBox::SvxHyperURLBox( Window* pParent, INetProtocol eSmart, BOOL bAddresses )
//STRIP001 : SvtURLBox			( pParent, eSmart ),
//STRIP001   DropTargetHelper  ( this ),
//STRIP001   mbAccessAddress	(bAddresses)
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int8 SvxHyperURLBox::AcceptDrop( const AcceptDropEvent& rEvt )
//STRIP001 {
//STRIP001     return( IsDropFormatSupported( FORMAT_STRING ) ? DND_ACTION_COPY : DND_ACTION_NONE );
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int8 SvxHyperURLBox::ExecuteDrop( const ExecuteDropEvent& rEvt )
//STRIP001 {
//STRIP001     TransferableDataHelper	aDataHelper( rEvt.maDropEvent.Transferable );
//STRIP001     String                  aString;
//STRIP001     sal_Int8                nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001     if( aDataHelper.GetString( FORMAT_STRING, aString ) )
//STRIP001     {
//STRIP001         SetText( aString );
//STRIP001 		nRet = DND_ACTION_COPY;
//STRIP001     }
//STRIP001 
//STRIP001     return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 /*
//STRIP001 Diese Methode parsed eine EMailadresse aus einem D&D-DataObjekt aus der Adredatenbank heraus
//STRIP001 
//STRIP001 #ifndef _OFF_OFADBMGR_HXX
//STRIP001 #include <bf_offmgr/ofadbmgr.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _OFF_APP_HXX
//STRIP001 #include <bf_offmgr/app.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SDB_SDBCURS_HXX
//STRIP001 #include <sdb/sdbcurs.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #define DB_DD_DELIM			((char)11)
//STRIP001 
//STRIP001 String SvxHyperURLBox::GetAllEmailNamesFromDragItem( USHORT nItem )
//STRIP001 {
//STRIP001 #if !defined( ICC ) && !defined( SOLARIS )
//STRIP001 	String aAddress;
//STRIP001 
//STRIP001 	if (  DragServer::HasFormat( nItem, SOT_FORMATSTR_ID_SBA_DATAEXCHANGE ) )
//STRIP001 	{
//STRIP001 		ULONG nLen = DragServer::GetDataLen( nItem, SOT_FORMATSTR_ID_SBA_DATAEXCHANGE ) - 1;
//STRIP001 		USHORT i = 0;
//STRIP001 		String aTxt;
//STRIP001 		char *pTxt = aTxt.AllocStrBuf( (USHORT)nLen );
//STRIP001 		DragServer::PasteData( nItem, pTxt, nLen, SOT_FORMATSTR_ID_SBA_DATAEXCHANGE );
//STRIP001 		String aDBName = aTxt.GetToken( i++, DB_DD_DELIM );
//STRIP001 		String aTableName = aTxt.GetToken( i++, DB_DD_DELIM );
//STRIP001 		i++;	// Format"anderung
//STRIP001 		String aStatement = aTxt.GetToken( i++, DB_DD_DELIM );
//STRIP001 		if ( !aStatement )
//STRIP001 		{
//STRIP001 			aDBName += DB_DELIM;
//STRIP001 			aDBName += aTableName;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// use here another delimiter, because the OfaDBMgr uses two
//STRIP001 			// delimiters ( (char)11 and ; )
//STRIP001 			aDBName += ';';
//STRIP001 			aDBName += aStatement;
//STRIP001 		}
//STRIP001 		SbaSelectionListRef pSelectionList;
//STRIP001 		pSelectionList.Clear();
//STRIP001 		pSelectionList = new SbaSelectionList;
//STRIP001 		USHORT nTokCnt = aTxt.GetTokenCount( DB_DD_DELIM );
//STRIP001 
//STRIP001 		for ( ; i < nTokCnt; ++i )
//STRIP001 			pSelectionList->Insert(
//STRIP001 				(void*)(USHORT)aTxt.GetToken( i, DB_DD_DELIM ), LIST_APPEND );
//STRIP001 
//STRIP001 		OfaDBMgr* pDBMgr = OFF_APP()->GetOfaDBMgr();
//STRIP001 		BOOL bBasic = DBMGR_STD;
//STRIP001 
//STRIP001 		if ( !pDBMgr->OpenDB( bBasic, aDBName ) )
//STRIP001 			return aAddress;
//STRIP001 
//STRIP001 		OfaDBParam& rParam = pDBMgr->GetDBData( bBasic );
//STRIP001 		pDBMgr->ChangeStatement( bBasic, aStatement );
//STRIP001 		rParam.pSelectionList->Clear();
//STRIP001 
//STRIP001 		if ( pSelectionList.Is() &&
//STRIP001 				(long)pSelectionList->GetObject(0) != -1L )
//STRIP001 			*rParam.pSelectionList = *pSelectionList;
//STRIP001 
//STRIP001 		if ( !pDBMgr->ToFirstSelectedRecord( bBasic ) )
//STRIP001 		{
//STRIP001 			pDBMgr->CloseAll();
//STRIP001 			return aAddress;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pDBMgr->IsSuccessful( bBasic ) )
//STRIP001 		{
//STRIP001 			//	Spaltenk"opfe
//STRIP001 			SbaDBDataDefRef aDBDef = pDBMgr->OpenColumnNames( bBasic );
//STRIP001 
//STRIP001 			if ( aDBDef.Is() )
//STRIP001 			{
//STRIP001 				SbaColumn* pCol = aDBDef->GetColumn("EMAIL");
//STRIP001 				ULONG nPos = 0;
//STRIP001 
//STRIP001 				if ( pCol )
//STRIP001 					nPos = aDBDef->GetOriginalColumns().GetPos( pCol ) + 1;
//STRIP001 				for ( i = 0 ; nPos && i < pSelectionList->Count(); ++i )
//STRIP001 				{
//STRIP001 					ULONG nIndex = (ULONG)pSelectionList->GetObject(i);
//STRIP001 
//STRIP001 					// N"achsten zu lesenden Datensatz ansteuern
//STRIP001 
//STRIP001 					BOOL bEnd = rParam.GetCursor()->IsOffRange();
//STRIP001 
//STRIP001 					if ( !bEnd )
//STRIP001 					{
//STRIP001 						const ODbRowRef aRow =
//STRIP001 							pDBMgr->GetSelectedRecord( bBasic, i );
//STRIP001 
//STRIP001 						if ( aRow.Is() )
//STRIP001 						{
//STRIP001 							aAddress += pDBMgr->
//STRIP001 								ImportDBField( (USHORT)nPos, &aDBDef, aRow.getBodyPtr() );
//STRIP001 							aAddress += ',';
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{
//STRIP001 							aAddress.Erase();
//STRIP001 							break;
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else
//STRIP001 						break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		pDBMgr->CloseAll();
//STRIP001 	}
//STRIP001 	aAddress.EraseTrailingChars( ',' );
//STRIP001 	return aAddress;
//STRIP001 #else
//STRIP001 	return String();
//STRIP001 #endif
//STRIP001 }
//STRIP001 */
//STRIP001 
//STRIP001 void SvxHyperURLBox::Select()
//STRIP001 {
//STRIP001 	SvtURLBox::Select();
//STRIP001 }
//STRIP001 void SvxHyperURLBox::Modify()
//STRIP001 {
//STRIP001 	SvtURLBox::Modify();
//STRIP001 }
//STRIP001 long SvxHyperURLBox::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	return SvtURLBox::Notify( rNEvt );
//STRIP001 }
//STRIP001 long SvxHyperURLBox::PreNotify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	return SvtURLBox::PreNotify( rNEvt );
//STRIP001 }
//STRIP001 
//STRIP001 //########################################################################
//STRIP001 //#                                                                      #
//STRIP001 //# Hyperlink-Dialog: Tabpages-Baseclass                                 #
//STRIP001 //#                                                                      #
//STRIP001 //########################################################################
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Con/Destructor, Initialize
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxHyperlinkTabPageBase::SvxHyperlinkTabPageBase ( Window *pParent,
//STRIP001 												   const ResId &rResId,
//STRIP001 												   const SfxItemSet& rItemSet)
//STRIP001 :	mpGrpMore				( NULL ),
//STRIP001 	mpFtFrame				( NULL ),
//STRIP001 	mpCbbFrame				( NULL ),
//STRIP001 	mpFtForm				( NULL ),
//STRIP001 	mpLbForm				( NULL ),
//STRIP001 	mpFtIndication			( NULL ),
//STRIP001 	mpEdIndication			( NULL ),
//STRIP001 	mpFtText				( NULL ),
//STRIP001 	mpEdText				( NULL ),
//STRIP001 	mpBtScript				( NULL ),
//STRIP001 	IconChoicePage			( pParent, rResId, rItemSet ),
//STRIP001 	mpDialog				( pParent ),
//STRIP001 	mbStdControlsInit		( FALSE )
//STRIP001 {
//STRIP001 	// create bookmark-window
//STRIP001 	mpMarkWnd = new SvxHlinkDlgMarkWnd ( this );
//STRIP001 }
//STRIP001 
//STRIP001 SvxHyperlinkTabPageBase::~SvxHyperlinkTabPageBase ()
//STRIP001 {
//STRIP001 	maTimer.Stop();
//STRIP001 
//STRIP001 	if ( mbStdControlsInit )
//STRIP001 	{
//STRIP001 		delete mpGrpMore;
//STRIP001 		delete mpFtFrame;
//STRIP001 		delete mpCbbFrame;
//STRIP001 		delete mpFtForm;
//STRIP001 		delete mpLbForm;
//STRIP001 		delete mpFtIndication;
//STRIP001 		delete mpEdIndication;
//STRIP001 		delete mpFtText;
//STRIP001 		delete mpEdText	;
//STRIP001 		delete mpBtScript;
//STRIP001 	}
//STRIP001 
//STRIP001 	delete mpMarkWnd;
//STRIP001 }
//STRIP001 
//STRIP001 void SvxHyperlinkTabPageBase::InitStdControls ()
//STRIP001 {
//STRIP001 	if ( !mbStdControlsInit )
//STRIP001 	{
//STRIP001 		mpGrpMore	  = new FixedLine			( this, ResId (GRP_MORE) );
//STRIP001 		mpFtFrame	  = new FixedText			( this, ResId (FT_FRAME) );
//STRIP001 		mpCbbFrame	  = new SvxFramesComboBox	( this, ResId (CB_FRAME) );
//STRIP001 		mpFtForm	  = new FixedText			( this, ResId (FT_FORM) );
//STRIP001 		mpLbForm	  = new ListBox				( this, ResId (LB_FORM) );
//STRIP001 		mpFtIndication= new FixedText			( this, ResId (FT_INDICATION) );
//STRIP001 		mpEdIndication= new Edit				( this, ResId (ED_INDICATION) );
//STRIP001 		mpFtText	  = new FixedText			( this, ResId (FT_TEXT) );
//STRIP001 		mpEdText	  = new Edit				( this, ResId (ED_TEXT) );
//STRIP001 		mpBtScript	  = new ImageButton			( this, ResId (BTN_SCRIPT) );
//STRIP001 
//STRIP001 		mpBtScript->SetClickHdl ( LINK ( this, SvxHyperlinkTabPageBase, ClickScriptHdl_Impl ) );
//STRIP001 
//STRIP001 		mpBtScript->SetModeImage( Image( ResId( IMG_SCRIPT_HC ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001         mpBtScript->EnableTextDisplay (FALSE);
//STRIP001 	}
//STRIP001 
//STRIP001 	mbStdControlsInit = TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Move Extra-Window
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL SvxHyperlinkTabPageBase::MoveToExtraWnd( Point aNewPos, BOOL bDisConnectDlg )
//STRIP001 {
//STRIP001 	BOOL bReturn = 	mpMarkWnd->MoveTo ( aNewPos );
//STRIP001 
//STRIP001 	if( bDisConnectDlg )
//STRIP001 		mpMarkWnd->ConnectToDialog( FALSE );
//STRIP001 
//STRIP001 	return ( !bReturn && IsMarkWndVisible() );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Show Extra-Window
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxHyperlinkTabPageBase::ShowMarkWnd ()
//STRIP001 {
//STRIP001 	( ( Window* ) mpMarkWnd )->Show();
//STRIP001 
//STRIP001 	// Size of dialog-window in screen pixels
//STRIP001     Rectangle aDlgRect( mpDialog->GetWindowExtentsRelative( NULL ) );
//STRIP001 	Point aDlgPos ( aDlgRect.TopLeft() );
//STRIP001 	Size aDlgSize (	mpDialog->GetSizePixel () );
//STRIP001 
//STRIP001 	// Absolute size of the screen
//STRIP001     Rectangle aScreen( mpDialog->GetDesktopRectPixel() );
//STRIP001 
//STRIP001 	// Size of Extrawindow
//STRIP001 	Size aExtraWndSize( mpMarkWnd->GetSizePixel () );
//STRIP001 
//STRIP001     // mpMarkWnd is a child of mpDialog, so coordinates for positioning must be relative to mpDialog
//STRIP001 	if( aDlgPos.X()+(1.05*aDlgSize.Width())+aExtraWndSize.Width() > aScreen.Right() )
//STRIP001 	{
//STRIP001 		if( aDlgPos.X() - ( 0.05*aDlgSize.Width() ) - aExtraWndSize.Width() < 0 )
//STRIP001 		{
//STRIP001 			// Pos Extrawindow anywhere
//STRIP001 			MoveToExtraWnd( Point(10,10) );  // very unlikely
//STRIP001 			mpMarkWnd->ConnectToDialog( FALSE );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// Pos Extrawindow on the left side of Dialog
//STRIP001 			MoveToExtraWnd( Point(0,0) - Point( long(0.05*aDlgSize.Width()), 0 ) - Point( aExtraWndSize.Width(), 0 ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Pos Extrawindow on the right side of Dialog
//STRIP001 		MoveToExtraWnd ( Point( long(1.05*aDlgSize.getWidth()), 0 ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Set size of Extra-Window
//STRIP001 	mpMarkWnd->SetSizePixel( Size( aExtraWndSize.Width(), aDlgSize.Height() ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Fill Dialogfields
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxHyperlinkTabPageBase::FillStandardDlgFields ( SvxHyperlinkItem* pHyperlinkItem )
//STRIP001 {
//STRIP001 	// Frame
//STRIP001 	USHORT nPos = mpCbbFrame->GetEntryPos ( pHyperlinkItem->GetTargetFrame() );
//STRIP001 	if ( nPos != LISTBOX_ENTRY_NOTFOUND)
//STRIP001 		mpCbbFrame->SetText ( pHyperlinkItem->GetTargetFrame() );
//STRIP001 
//STRIP001 	// Form
//STRIP001 	String aStrFormText = SVX_RESSTR( RID_SVXSTR_HYPERDLG_FROM_TEXT );
//STRIP001 	String aStrFormButton = SVX_RESSTR( RID_SVXSTR_HYPERDLG_FORM_BUTTON );
//STRIP001 
//STRIP001 	if( pHyperlinkItem->GetInsertMode() & HLINK_HTMLMODE )
//STRIP001 	{
//STRIP001 		mpLbForm->Clear();
//STRIP001 		mpLbForm->InsertEntry( aStrFormText );
//STRIP001 		mpLbForm->SelectEntryPos ( 0 );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		mpLbForm->Clear();
//STRIP001 		mpLbForm->InsertEntry( aStrFormText );
//STRIP001 		mpLbForm->InsertEntry( aStrFormButton );
//STRIP001 		mpLbForm->SelectEntryPos ( pHyperlinkItem->GetInsertMode() == HLINK_BUTTON ? 1 : 0 );
//STRIP001 	}
//STRIP001 
//STRIP001 	// URL
//STRIP001 	mpEdIndication->SetText ( pHyperlinkItem->GetName() );
//STRIP001 
//STRIP001 	// Name
//STRIP001 	mpEdText->SetText ( pHyperlinkItem->GetIntName() );
//STRIP001 
//STRIP001 	// Script-button
//STRIP001 	if ( !pHyperlinkItem->GetMacroEvents() )
//STRIP001 		mpBtScript->Disable();
//STRIP001 	else
//STRIP001 		mpBtScript->Enable();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Any action to do after apply-button is pressed
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxHyperlinkTabPageBase::DoApply ()
//STRIP001 {
//STRIP001 	// default-implemtation : do nothing
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ask page whether an insert is possible
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL SvxHyperlinkTabPageBase::AskApply ()
//STRIP001 {
//STRIP001 	// default-implementation
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* This method would be called from bookmark-window to set new mark-string
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxHyperlinkTabPageBase::SetMarkStr ( String& aStrMark )
//STRIP001 {
//STRIP001 	// default-implemtation : do nothing
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* This method will be called from the dialog-class if the state off
//STRIP001 |* the online-mode has changed.
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxHyperlinkTabPageBase::SetOnlineMode( BOOL bEnable )
//STRIP001 {
//STRIP001 	// default-implemtation : do nothing
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Set initial focus
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 void SvxHyperlinkTabPageBase::SetInitFocus()
//STRIP001 {
//STRIP001 	GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ask dialog whether the curretn doc is a HTML-doc
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 const BOOL SvxHyperlinkTabPageBase::IsHTMLDoc() const
//STRIP001 {
//STRIP001 	return ((SvxHpLinkDlg*)mpDialog)->IsHTMLDoc();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* retrieve dispatcher
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 SfxDispatcher* SvxHyperlinkTabPageBase::GetDispatcher() const 
//STRIP001 { 
//STRIP001 	return ((SvxHpLinkDlg*)mpDialog)->GetDispatcher(); 
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Click on imagebutton : Script
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK ( SvxHyperlinkTabPageBase, ClickScriptHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	SvxHyperlinkItem *pHyperlinkItem = (SvxHyperlinkItem *)
//STRIP001 		                               GetItemSet().GetItem (SID_HYPERLINK_GETLINK);
//STRIP001 
//STRIP001 	if ( pHyperlinkItem->GetMacroEvents() )
//STRIP001 	{
//STRIP001 		// get macros from itemset
//STRIP001 		const SvxMacroTableDtor* pMacroTbl = pHyperlinkItem->GetMacroTbl();
//STRIP001 		SvxMacroItem aItem ( GetWhich(SID_ATTR_MACROITEM) );
//STRIP001 		if( pMacroTbl )
//STRIP001 			aItem.SetMacroTable( *pMacroTbl );
//STRIP001 
//STRIP001 		// create empty itemset for macro-dlg
//STRIP001 		SfxItemSet* pItemSet = new SfxItemSet(SFX_APP()->GetPool(),
//STRIP001 			                                  SID_ATTR_MACROITEM,
//STRIP001 											  SID_ATTR_MACROITEM );
//STRIP001 		pItemSet->Put ( aItem, SID_ATTR_MACROITEM );
//STRIP001 
//STRIP001 		SfxMacroAssignDlg aDlg (this, *pItemSet );
//STRIP001 
//STRIP001 		// add events
//STRIP001 		SfxMacroTabPage *pMacroPage = (SfxMacroTabPage*) aDlg.GetTabPage();
//STRIP001 
//STRIP001 		if ( pHyperlinkItem->GetMacroEvents() & HYPERDLG_EVENT_MOUSEOVER_OBJECT )
//STRIP001 			pMacroPage->AddEvent( String( SVX_RESSTR(RID_SVXSTR_HYPDLG_MACROACT1) ),
//STRIP001 			                      SFX_EVENT_MOUSEOVER_OBJECT );
//STRIP001 		if ( pHyperlinkItem->GetMacroEvents() & HYPERDLG_EVENT_MOUSECLICK_OBJECT )
//STRIP001 			pMacroPage->AddEvent( String( SVX_RESSTR(RID_SVXSTR_HYPDLG_MACROACT2) ),
//STRIP001 			                      SFX_EVENT_MOUSECLICK_OBJECT);
//STRIP001 		if ( pHyperlinkItem->GetMacroEvents() & HYPERDLG_EVENT_MOUSEOUT_OBJECT )
//STRIP001 			pMacroPage->AddEvent( String( SVX_RESSTR(RID_SVXSTR_HYPDLG_MACROACT3) ),
//STRIP001 			                      SFX_EVENT_MOUSEOUT_OBJECT);
//STRIP001 
//STRIP001 		// execute dlg
//STRIP001 		if ( RET_OK == aDlg.Execute() )
//STRIP001 		{
//STRIP001 			const SfxItemSet* pOutSet = aDlg.GetOutputItemSet();
//STRIP001 			const SfxPoolItem* pItem;
//STRIP001 			if( SFX_ITEM_SET == pOutSet->GetItemState( SID_ATTR_MACROITEM, FALSE, &pItem ))
//STRIP001 			{
//STRIP001 				pHyperlinkItem->SetMacroTable( ((SvxMacroItem*)pItem)->GetMacroTable() );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		delete pItemSet;
//STRIP001 	}
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Get Macro-Infos
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 USHORT SvxHyperlinkTabPageBase::GetMacroEvents()
//STRIP001 {
//STRIP001 	SvxHyperlinkItem *pHyperlinkItem = (SvxHyperlinkItem *)
//STRIP001 		                               GetItemSet().GetItem (SID_HYPERLINK_GETLINK);
//STRIP001 
//STRIP001 	return pHyperlinkItem->GetMacroEvents();
//STRIP001 }
//STRIP001 
//STRIP001 SvxMacroTableDtor* SvxHyperlinkTabPageBase::GetMacroTable()
//STRIP001 {
//STRIP001 	SvxHyperlinkItem *pHyperlinkItem = (SvxHyperlinkItem *)
//STRIP001 		                               GetItemSet().GetItem (SID_HYPERLINK_GETLINK);
//STRIP001 
//STRIP001 	return ( (SvxMacroTableDtor*)pHyperlinkItem->GetMacroTbl() );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Does the given file exists ?
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 BOOL SvxHyperlinkTabPageBase::FileExists( const INetURLObject& rURL )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 
//STRIP001 	if( rURL.GetFull().Len() > 0 )
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			Content		aCnt( rURL.GetMainURL( INetURLObject::NO_DECODE ), ::com::sun::star::uno::Reference< ::com::sun::star::ucb::XCommandEnvironment >() );
//STRIP001 			::rtl::OUString	aTitle;
//STRIP001 
//STRIP001 			aCnt.getPropertyValue( ::rtl::OUString::createFromAscii( "Title" ) ) >>= aTitle;
//STRIP001 			bRet = ( aTitle.getLength() > 0 );
//STRIP001 		}
//STRIP001 		catch( ... )
//STRIP001 		{
//STRIP001 			DBG_ERROR( "FileExists: ucb error" );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* try to detect the current protocol that is used in aStrURL
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 String SvxHyperlinkTabPageBase::GetSchemeFromURL( String aStrURL )
//STRIP001 {
//STRIP001     String aStrScheme;
//STRIP001 
//STRIP001 	INetURLObject aURL( aStrURL );
//STRIP001 	INetProtocol aProtocol = aURL.GetProtocol();
//STRIP001 
//STRIP001     // #77696#
//STRIP001     // our new INetUrlObject now has the ability
//STRIP001     // to detect if an Url is valid or not :-(
//STRIP001     if ( aProtocol == INET_PROT_NOT_VALID )
//STRIP001     {
//STRIP001 	    if ( aStrURL.EqualsIgnoreCaseAscii( INET_HTTP_SCHEME, 0, 7 ) )
//STRIP001         {
//STRIP001             aStrScheme = String::CreateFromAscii( INET_HTTP_SCHEME );
//STRIP001         }
//STRIP001         else if ( aStrURL.EqualsIgnoreCaseAscii( INET_HTTPS_SCHEME, 0, 8 ) )
//STRIP001         {
//STRIP001             aStrScheme = String::CreateFromAscii( INET_HTTPS_SCHEME );
//STRIP001         }
//STRIP001         else if ( aStrURL.EqualsIgnoreCaseAscii( INET_FTP_SCHEME, 0, 6 ) )
//STRIP001         {
//STRIP001             aStrScheme = String::CreateFromAscii( INET_FTP_SCHEME );
//STRIP001         }
//STRIP001         else if ( aStrURL.EqualsIgnoreCaseAscii( INET_MAILTO_SCHEME, 0, 7 ) )
//STRIP001         {
//STRIP001             aStrScheme = String::CreateFromAscii( INET_MAILTO_SCHEME );
//STRIP001         }
//STRIP001         else if ( aStrURL.EqualsIgnoreCaseAscii( INET_NEWS_SCHEME, 0, 5 ) )
//STRIP001         {
//STRIP001             aStrScheme = String::CreateFromAscii( INET_NEWS_SCHEME );
//STRIP001         }
//STRIP001         else if ( aStrURL.EqualsIgnoreCaseAscii( INET_TELNET_SCHEME, 0, 9 ) )
//STRIP001         {
//STRIP001             aStrScheme = String::CreateFromAscii( INET_TELNET_SCHEME );
//STRIP001         }
//STRIP001     }
//STRIP001     else
//STRIP001         aStrScheme = INetURLObject::GetScheme( aProtocol );
//STRIP001     return aStrScheme;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void SvxHyperlinkTabPageBase::GetDataFromCommonFields( String& aStrName,
//STRIP001 											 String& aStrIntName, String& aStrFrame,
//STRIP001 											 SvxLinkInsertMode& eMode )
//STRIP001 {
//STRIP001 	aStrIntName	= mpEdText->GetText();
//STRIP001 	aStrName	= mpEdIndication->GetText();
//STRIP001 	aStrFrame	= mpCbbFrame->GetText();
//STRIP001 	eMode		= (SvxLinkInsertMode) (mpLbForm->GetSelectEntryPos()+1);
//STRIP001 	if( IsHTMLDoc() )
//STRIP001 		eMode = (SvxLinkInsertMode) ( UINT16(eMode) | HLINK_HTMLMODE );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* reset dialog-fields
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 void SvxHyperlinkTabPageBase::Reset( const SfxItemSet& rItemSet)
//STRIP001 {
//STRIP001 	///////////////////////////////////////
//STRIP001 	// Set dialog-fields from create-itemset
//STRIP001 	maStrInitURL = aEmptyStr;
//STRIP001 
//STRIP001 	SvxHyperlinkItem *pHyperlinkItem = (SvxHyperlinkItem *)
//STRIP001 		                               rItemSet.GetItem (SID_HYPERLINK_GETLINK);
//STRIP001 
//STRIP001 	if ( pHyperlinkItem )
//STRIP001 	{
//STRIP001 		// set dialog-fields
//STRIP001 		FillStandardDlgFields (pHyperlinkItem);
//STRIP001 
//STRIP001 		// set all other fields
//STRIP001 		FillDlgFields ( (String&)pHyperlinkItem->GetURL() );
//STRIP001 
//STRIP001 		// Store initial URL
//STRIP001 		maStrInitURL = pHyperlinkItem->GetURL();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Fill output-ItemSet
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 BOOL SvxHyperlinkTabPageBase::FillItemSet( SfxItemSet& rOut)
//STRIP001 {
//STRIP001 	String aStrURL, aStrName, aStrIntName, aStrFrame;
//STRIP001 	SvxLinkInsertMode eMode;
//STRIP001 
//STRIP001 	GetCurentItemData ( aStrURL, aStrName, aStrIntName, aStrFrame, eMode);
//STRIP001 	if ( !aStrName.Len() ) //automatically create a visible name if the link is created without name
//STRIP001 		aStrName = CreateUiNameFromURL(aStrURL);
//STRIP001 
//STRIP001 	USHORT nEvents = GetMacroEvents();
//STRIP001 	SvxMacroTableDtor* pTable = GetMacroTable();
//STRIP001 
//STRIP001 	SvxHyperlinkItem aItem( SID_HYPERLINK_SETLINK, aStrName, aStrURL, aStrFrame,
//STRIP001 		                    aStrIntName, eMode, nEvents, pTable );
//STRIP001 	rOut.Put (aItem);
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 String SvxHyperlinkTabPageBase::CreateUiNameFromURL( const String& aStrURL )
//STRIP001 {
//STRIP001     String			aStrUiURL;
//STRIP001     INetURLObject	aURLObj( aStrURL );
//STRIP001 
//STRIP001     switch(aURLObj.GetProtocol())
//STRIP001     {
//STRIP001         case INET_PROT_FILE:
//STRIP001             utl::LocalFileHelper::ConvertURLToSystemPath( aURLObj.GetMainURL(INetURLObject::NO_DECODE), aStrUiURL );
//STRIP001             break;
//STRIP001     	case INET_PROT_FTP :
//STRIP001             {
//STRIP001                 //remove password from name
//STRIP001                 INetURLObject	aTmpURL(aURLObj);
//STRIP001                 aTmpURL.SetPass(aEmptyStr);
//STRIP001                 aStrUiURL = aTmpURL.GetMainURL( INetURLObject::DECODE_UNAMBIGUOUS );
//STRIP001             }
//STRIP001             break;
//STRIP001 		default :
//STRIP001             {
//STRIP001                 aStrUiURL = aURLObj.GetMainURL(INetURLObject::DECODE_UNAMBIGUOUS);
//STRIP001             }
//STRIP001     }
//STRIP001     if(!aStrUiURL.Len())
//STRIP001         return aStrURL;
//STRIP001     return aStrUiURL;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Activate / Deactivate Tabpage
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 void SvxHyperlinkTabPageBase::ActivatePage( const SfxItemSet& rItemSet )
//STRIP001 {
//STRIP001 	///////////////////////////////////////
//STRIP001 	// Set dialog-fields from input-itemset
//STRIP001 	SvxHyperlinkItem *pHyperlinkItem = (SvxHyperlinkItem *)
//STRIP001 		                               rItemSet.GetItem (SID_HYPERLINK_GETLINK);
//STRIP001 
//STRIP001 	if ( pHyperlinkItem )
//STRIP001 	{
//STRIP001 		// standard-fields
//STRIP001 		FillStandardDlgFields (pHyperlinkItem);
//STRIP001 	}
//STRIP001 
//STRIP001 	// show mark-window if it was open before
//STRIP001 	if ( ShouldOpenMarkWnd () )
//STRIP001 		ShowMarkWnd ();
//STRIP001 }
//STRIP001 
//STRIP001 int SvxHyperlinkTabPageBase::DeactivatePage( SfxItemSet* pSet)
//STRIP001 {
//STRIP001 	// hide mark-wnd
//STRIP001 	SetMarkWndShouldOpen( IsMarkWndVisible () );
//STRIP001 	HideMarkWnd ();
//STRIP001 
//STRIP001 	// retrieve data of dialog
//STRIP001 	String aStrURL, aStrName, aStrIntName, aStrFrame;
//STRIP001 	SvxLinkInsertMode eMode;
//STRIP001 
//STRIP001 	GetCurentItemData ( aStrURL, aStrName, aStrIntName, aStrFrame, eMode);
//STRIP001 
//STRIP001 	USHORT nEvents = GetMacroEvents();
//STRIP001 	SvxMacroTableDtor* pTable = GetMacroTable();
//STRIP001 
//STRIP001 	if( pSet )
//STRIP001 	{
//STRIP001 		SvxHyperlinkItem aItem( SID_HYPERLINK_GETLINK, aStrName, aStrURL, aStrFrame,
//STRIP001 								aStrIntName, eMode, nEvents, pTable );
//STRIP001 		pSet->Put( aItem );
//STRIP001 	}
//STRIP001 
//STRIP001 	return( LEAVE_PAGE );
//STRIP001 }
}
