/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_frmsel.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:44:04 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SV_VIRDEV_HXX
#include <vcl/virdev.hxx>
#endif
#pragma hdrstop

#define _SVX_FRMSEL_CXX
#define ITEMID_BOX			SID_ATTR_BORDER_OUTER
#define ITEMID_BOXINFO 		SID_ATTR_BORDER_INNER

#include "frmsel.hxx"
#include <frmsel.hrc>
#ifndef _SVX_DIALOGS_HRC
#include <dialogs.hrc>
#endif
#include "dialmgr.hxx"
#include "linelink.hxx"

#ifndef _SVX_BOXITEM_HXX //autogen
#include <boxitem.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _UNO_LINGU_HXX
#include <unolingu.hxx>
#endif
#ifndef _TOOLS_RESARY_HXX
#include <tools/resary.hxx>
#endif
#ifndef _COM_SUN_STAR_AWT_KEYEVENT_HPP_
#include <com/sun/star/awt/KeyEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_KEYMODIFIER_HPP_
#include <com/sun/star/awt/KeyModifier.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_KEY_HPP_
#include <com/sun/star/awt/Key.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLE_HPP_
#include <com/sun/star/accessibility/XAccessible.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLECONTEXT_HPP_
#include <com/sun/star/accessibility/XAccessibleContext.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLECOMPONENT_HPP_
#include <com/sun/star/accessibility/XAccessibleComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ILLEGALACCESSIBLECOMPONENTSTATEEXCEPTION_HDL_
#include <com/sun/star/accessibility/IllegalAccessibleComponentStateException.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLESTATETYPE_HDL_
#include <com/sun/star/accessibility/AccessibleStateType.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLERELATIONTYPE_HDL_
#include <com/sun/star/accessibility/AccessibleRelationType.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEROLE_HDL_
#include <com/sun/star/accessibility/AccessibleRole.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_INDEXOUTOFBOUNDSEXCEPTION_HPP_
#include <com/sun/star/lang/IndexOutOfBoundsException.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_FOCUSCHANGEREASON_HPP_
#include <com/sun/star/awt/FocusChangeReason.hpp>
#endif
#ifndef _UTL_ACCESSIBLESTATESETHELPER_HXX_
#include <unotools/accessiblestatesethelper.hxx>
#endif
#ifndef _UTL_ACCESSIBLERELATIONSETHELPER_HXX_
#include <unotools/accessiblerelationsethelper.hxx>
#endif
#ifndef _CPPUHELPER_IMPLBASE4_HXX_
#include <cppuhelper/implbase4.hxx>
#endif
#ifndef _CPPUHELPER_INTERFACECONTAINER_HXX_
#include <cppuhelper/interfacecontainer.hxx>
#endif
#ifndef MNEMONIC_CHAR
#define MNEMONIC_CHAR               ((sal_Unicode)'~')
#endif
#include <com/sun/star/awt/XFocusListener.hpp>
namespace binfilter {

//STRIP001 using namespace ::com::sun::star;
//STRIP001 using namespace ::com::sun::star::accessibility;
//STRIP001 using namespace ::rtl;
//STRIP001 
//STRIP001 // struct SvxFrameSelector_Impl ------------------------------------------------
//STRIP001 struct SvxFrameSelector_Impl
//STRIP001 {
//STRIP001 	SvxFrameSelectorType				eSel;			// Selektor-Typ (Tabelle oder Absatz)
//STRIP001 
//STRIP001 	Color								aCurLineCol;	// aktuelle Linienfarbe
//STRIP001 	Color								aPaintLineCol;
//STRIP001 	SvxLineStruct						aCurLineStyle;	// aktueller LineStyle
//STRIP001 	Bitmap								aBackBmp;		// Hintergrund-Bitmap
//STRIP001 	Rectangle							aRectFrame;		// der Rahmen (Mitte der Linien)
//STRIP001 	Rectangle							aBoundingRect;	// alle Linien umschliessender Rahmen
//STRIP001 	SvxFrameLine						aLeftLine;		// seine Linien
//STRIP001 	SvxFrameLine						aRightLine;
//STRIP001 	SvxFrameLine						aTopLine;
//STRIP001 	SvxFrameLine						aBottomLine;
//STRIP001 	SvxFrameLine						aHorLine;
//STRIP001 	SvxFrameLine						aVerLine;
//STRIP001 	Rectangle							aSpotLeft;		// Click-HotSpots auf der Bitmap
//STRIP001 	Rectangle							aSpotRight;
//STRIP001 	Rectangle							aSpotTop;
//STRIP001 	Rectangle							aSpotBottom;
//STRIP001 	Rectangle							aSpotHor;
//STRIP001 	Rectangle							aSpotVer;
//STRIP001 	BOOL								bIsDontCare;
//STRIP001 	BOOL								bHC;
//STRIP001 	SvxFrameSelectorAccessible_Impl*	pAccess;
//STRIP001 	uno::Reference< XAccessible >		xAccess;
//STRIP001 	SvxFrameSelectorAccessible_Impl*	pChildren[6];
//STRIP001 	uno::Reference< XAccessible >		xChildren[6];
//STRIP001 
//STRIP001 										SvxFrameSelector_Impl( const SvxFrameSelector* pThis );
//STRIP001 										~SvxFrameSelector_Impl();
//STRIP001 
//STRIP001 	uno::Reference< XAccessible >		GetChildAccessible( SvxFrameSelector& rFrameSel, SvxFrameSelectorLine eWhich );
//STRIP001 	const Rectangle&					GetLineSpot( SvxFrameSelectorLine eWhich ) const;
//STRIP001 
//STRIP001 	void								SetHC( const SvxFrameSelector* pContrl = NULL );	// pContrl == NULL -> no HC
//STRIP001 	inline const Color&					GetPaintLineCol( void ) const;
//STRIP001 };
//STRIP001 
//STRIP001 inline const Color& SvxFrameSelector_Impl::GetPaintLineCol( void ) const
//STRIP001 {
//STRIP001 	return bHC? aPaintLineCol : aCurLineCol;
//STRIP001 }
//STRIP001 
//STRIP001 // class SvxFrameSelectorAccessible_Impl ------------------------------------------------
//STRIP001 
//STRIP001 class SvxFrameSelectorAccessible_Impl :
//STRIP001 	public ::cppu::WeakImplHelper4<
//STRIP001 				::com::sun::star::accessibility::XAccessible,
//STRIP001                 ::com::sun::star::accessibility::XAccessibleContext,
//STRIP001                 ::com::sun::star::accessibility::XAccessibleComponent,
//STRIP001                 ::com::sun::star::lang::XServiceInfo
//STRIP001                 >,
//STRIP001     public Resource
//STRIP001 {
//STRIP001     SvxFrameSelector*   pFrameSel;
//STRIP001     ::osl::Mutex aFocusMutex;
//STRIP001     ::osl::Mutex aPropertyMutex;
//STRIP001 
//STRIP001     SvxFrameSelectorLine    eWhichChild;
//STRIP001 
//STRIP001     ::cppu::OInterfaceContainerHelper aFocusListeners;
//STRIP001     ::cppu::OInterfaceContainerHelper aPropertyListeners;
//STRIP001 
//STRIP001     ResStringArray      aNameArray;
//STRIP001     ResStringArray      aDescriptionArray;
//STRIP001 
//STRIP001     void IsValid() throw (::com::sun::star::uno::RuntimeException);
//STRIP001 public:
//STRIP001     SvxFrameSelectorAccessible_Impl(SvxFrameSelector& rSelector, SvxFrameSelectorLine eWhichChild);
//STRIP001     ~SvxFrameSelectorAccessible_Impl();
//STRIP001 
//STRIP001     //XAccessible
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleContext > SAL_CALL getAccessibleContext(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001 
//STRIP001     //XAccessibleContext
//STRIP001     virtual sal_Int32 SAL_CALL getAccessibleChildCount(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > SAL_CALL getAccessibleChild( sal_Int32 i ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > SAL_CALL getAccessibleParent(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Int32 SAL_CALL getAccessibleIndexInParent(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Int16 SAL_CALL getAccessibleRole(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::rtl::OUString SAL_CALL getAccessibleDescription(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::rtl::OUString SAL_CALL getAccessibleName(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleRelationSet > SAL_CALL getAccessibleRelationSet(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleStateSet > SAL_CALL getAccessibleStateSet(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::lang::Locale SAL_CALL getLocale(  ) throw (::com::sun::star::accessibility::IllegalAccessibleComponentStateException, ::com::sun::star::uno::RuntimeException);
//STRIP001     virtual void SAL_CALL addPropertyChangeListener( const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertyChangeListener >& xListener ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual void SAL_CALL removePropertyChangeListener( const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertyChangeListener >& xListener ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001 
//STRIP001     //XAccessibleComponent
//STRIP001     virtual sal_Bool SAL_CALL containsPoint( const ::com::sun::star::awt::Point& aPoint ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > SAL_CALL getAccessibleAtPoint( const ::com::sun::star::awt::Point& aPoint ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::awt::Rectangle SAL_CALL getBounds(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::awt::Point SAL_CALL getLocation(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::awt::Point SAL_CALL getLocationOnScreen(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::awt::Size SAL_CALL getSize(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Bool SAL_CALL isShowing(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Bool SAL_CALL isVisible(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Bool SAL_CALL isFocusTraversable(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual void SAL_CALL addFocusListener( const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XFocusListener >& xListener ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual void SAL_CALL removeFocusListener( const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XFocusListener >& xListener ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual void SAL_CALL grabFocus(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Any SAL_CALL getAccessibleKeyBinding(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Int32 SAL_CALL getForeground(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Int32 SAL_CALL getBackground(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001 
//STRIP001     //XServiceInfo
//STRIP001     virtual ::rtl::OUString SAL_CALL getImplementationName(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual sal_Bool SAL_CALL supportsService( const ::rtl::OUString& ServiceName ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001     virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL getSupportedServiceNames(  ) throw (::com::sun::star::uno::RuntimeException);
//STRIP001 
//STRIP001     void    Invalidate();
//STRIP001     void    NotifyFocusListeners(sal_Bool bGetFocus);
//STRIP001 };
//STRIP001 
//STRIP001 /*-- 04.02.2002 14:11:53---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 SvxFrameSelectorAccessible_Impl::SvxFrameSelectorAccessible_Impl(
//STRIP001         SvxFrameSelector& rSelector, SvxFrameSelectorLine eChild) :
//STRIP001     Resource(SVX_RES( RID_SVXSTR_BORDER_CONTROL)),
//STRIP001     aNameArray(         ResId(ARR_TEXTS       )),
//STRIP001     aDescriptionArray(  ResId(ARR_DESCRIPTIONS)),
//STRIP001     pFrameSel(&rSelector),
//STRIP001     aFocusListeners(aFocusMutex),
//STRIP001     aPropertyListeners(aPropertyMutex),
//STRIP001     eWhichChild(eChild)
//STRIP001 {
//STRIP001     FreeResource();
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:11:55---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 SvxFrameSelectorAccessible_Impl::~SvxFrameSelectorAccessible_Impl()
//STRIP001 {
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:11:55---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 uno::Reference< XAccessibleContext > SvxFrameSelectorAccessible_Impl::getAccessibleContext(  )
//STRIP001     throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     return this;
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:11:55---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 sal_Int32 SvxFrameSelectorAccessible_Impl::getAccessibleChildCount(  ) throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     return eWhichChild != SVX_FRMSELLINE_NONE ?
//STRIP001                 0 :
//STRIP001                     pFrameSel->pImpl->eSel == SVX_FRMSELTYPE_TABLE ? 6 : 4;
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:11:56---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 uno::Reference< XAccessible > SvxFrameSelectorAccessible_Impl::getAccessibleChild( sal_Int32 i )
//STRIP001     throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     uno::Reference< XAccessible > xRet;
//STRIP001     switch(i)
//STRIP001     {
//STRIP001         case 0: xRet = pFrameSel->pImpl->GetChildAccessible(*pFrameSel, SVX_FRMSELLINE_LEFT); break;
//STRIP001         case 1: xRet = pFrameSel->pImpl->GetChildAccessible(*pFrameSel, SVX_FRMSELLINE_RIGHT); break;
//STRIP001         case 2: xRet = pFrameSel->pImpl->GetChildAccessible(*pFrameSel, SVX_FRMSELLINE_TOP); break;
//STRIP001         case 3: xRet = pFrameSel->pImpl->GetChildAccessible(*pFrameSel, SVX_FRMSELLINE_BOTTOM); break;
//STRIP001         case 4: if(pFrameSel->pImpl->eSel == SVX_FRMSELTYPE_TABLE)
//STRIP001                     xRet = pFrameSel->pImpl->GetChildAccessible(*pFrameSel, SVX_FRMSELLINE_HOR);
//STRIP001         break;
//STRIP001         case 5: if(pFrameSel->pImpl->eSel == SVX_FRMSELTYPE_TABLE)
//STRIP001             xRet = pFrameSel->pImpl->GetChildAccessible(*pFrameSel, SVX_FRMSELLINE_VER);
//STRIP001         break;
//STRIP001     }
//STRIP001     if(!xRet.is())
//STRIP001         throw uno::RuntimeException();
//STRIP001     return xRet;
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:11:56---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 uno::Reference< XAccessible > SvxFrameSelectorAccessible_Impl::getAccessibleParent(  )
//STRIP001     throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     uno::Reference< XAccessible > xRet;
//STRIP001     if(eWhichChild == SVX_FRMSELLINE_NONE)
//STRIP001         xRet = pFrameSel->GetParent()->GetAccessible( sal_True );
//STRIP001     else
//STRIP001         xRet = pFrameSel->CreateAccessible();
//STRIP001     return xRet;
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:11:56---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 sal_Int32 SvxFrameSelectorAccessible_Impl::getAccessibleIndexInParent(  )
//STRIP001     throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     USHORT nIdx = 0;
//STRIP001     if(eWhichChild == SVX_FRMSELLINE_NONE)
//STRIP001     {
//STRIP001         Window* pTabPage = pFrameSel->GetParent();
//STRIP001         USHORT nChildren = pTabPage->GetChildCount();
//STRIP001         for(nIdx = 0; nIdx < nChildren; nIdx++)
//STRIP001             if(pTabPage->GetChild( nIdx ) == pFrameSel)
//STRIP001                 break;
//STRIP001     }
//STRIP001     else
//STRIP001         nIdx = eWhichChild - 1;
//STRIP001     return nIdx;
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:11:57---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 sal_Int16 SvxFrameSelectorAccessible_Impl::getAccessibleRole(  ) throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     return AccessibleRole::OPTION_PANE;
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:11:57---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 ::rtl::OUString SvxFrameSelectorAccessible_Impl::getAccessibleDescription(  )
//STRIP001     throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     return aDescriptionArray.GetString(eWhichChild);
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:11:57---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 ::rtl::OUString SvxFrameSelectorAccessible_Impl::getAccessibleName(  )
//STRIP001     throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     return aNameArray.GetString(eWhichChild);
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:11:57---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 uno::Reference< XAccessibleRelationSet > SvxFrameSelectorAccessible_Impl::getAccessibleRelationSet(  )
//STRIP001     throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     utl::AccessibleRelationSetHelper* pHelper;
//STRIP001     uno::Reference< XAccessibleRelationSet > xRet = pHelper = new utl::AccessibleRelationSetHelper;
//STRIP001     if(eWhichChild == SVX_FRMSELLINE_NONE)
//STRIP001     {
//STRIP001         //add the label relation
//STRIP001         Window* pPrev = pFrameSel->GetWindow( WINDOW_PREV );
//STRIP001         if(pPrev && WINDOW_FIXEDTEXT == pPrev->GetType())
//STRIP001         {
//STRIP001             AccessibleRelation aLabelRelation;
//STRIP001             aLabelRelation.RelationType = AccessibleRelationType::LABELED_BY;
//STRIP001             aLabelRelation.TargetSet.realloc(1);
//STRIP001             aLabelRelation.TargetSet.getArray()[0]  = pPrev->GetAccessible();
//STRIP001             pHelper->AddRelation(aLabelRelation);
//STRIP001         }
//STRIP001     }
//STRIP001     return xRet;
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:11:58---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 uno::Reference< XAccessibleStateSet > SvxFrameSelectorAccessible_Impl::getAccessibleStateSet(  )
//STRIP001     throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     utl::AccessibleStateSetHelper* pStateSetHelper = new utl::AccessibleStateSetHelper;
//STRIP001     uno::Reference< XAccessibleStateSet > xRet = pStateSetHelper;
//STRIP001 
//STRIP001     if(!pFrameSel)
//STRIP001         pStateSetHelper->AddState(AccessibleStateType::DEFUNC);
//STRIP001     else
//STRIP001     {
//STRIP001         const sal_Int16 aStandardStates[] =
//STRIP001         {
//STRIP001             AccessibleStateType::EDITABLE,
//STRIP001             AccessibleStateType::FOCUSABLE,
//STRIP001             AccessibleStateType::MULTI_SELECTABLE,
//STRIP001             AccessibleStateType::SELECTABLE,
//STRIP001             AccessibleStateType::SHOWING,
//STRIP001             AccessibleStateType::VISIBLE,
//STRIP001             AccessibleStateType::OPAQUE,
//STRIP001             0};
//STRIP001         sal_Int16 nState = 0;
//STRIP001         while(aStandardStates[nState])
//STRIP001         {
//STRIP001             pStateSetHelper->AddState(aStandardStates[nState++]);
//STRIP001         }
//STRIP001         if(pFrameSel->IsEnabled())
//STRIP001             pStateSetHelper->AddState(AccessibleStateType::ENABLED);
//STRIP001 
//STRIP001         sal_Bool bIsParent = eWhichChild == SVX_FRMSELLINE_NONE;
//STRIP001         if(pFrameSel->HasFocus() &&
//STRIP001             (bIsParent || pFrameSel->GetLine(eWhichChild).IsSelected()))
//STRIP001         {
//STRIP001             pStateSetHelper->AddState(AccessibleStateType::ACTIVE);
//STRIP001             pStateSetHelper->AddState(AccessibleStateType::FOCUSED);
//STRIP001             pStateSetHelper->AddState(AccessibleStateType::SELECTED);
//STRIP001         }
//STRIP001     }
//STRIP001     return xRet;
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:11:58---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 lang::Locale SvxFrameSelectorAccessible_Impl::getLocale(  )
//STRIP001     throw (IllegalAccessibleComponentStateException, uno::RuntimeException)
//STRIP001 {
//STRIP001     lang::Locale aRet;
//STRIP001     SvxLanguageToLocale( aRet, Application::GetSettings().GetUILanguage() );
//STRIP001     return aRet;
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:11:59---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 void SvxFrameSelectorAccessible_Impl::addPropertyChangeListener(
//STRIP001     const uno::Reference< beans::XPropertyChangeListener >& xListener )
//STRIP001         throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     aPropertyListeners.addInterface( xListener );
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:11:59---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 void SvxFrameSelectorAccessible_Impl::removePropertyChangeListener( const uno::Reference< beans::XPropertyChangeListener >& xListener )
//STRIP001     throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     aPropertyListeners.removeInterface( xListener );
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:11:59---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 sal_Bool SvxFrameSelectorAccessible_Impl::containsPoint( const awt::Point& aPt )
//STRIP001     throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     Point aPoint(aPt.X, aPt.Y);
//STRIP001     //aPoint is relative to the frame selector
//STRIP001     return pFrameSel->pImpl->aSpotLeft.IsInside( aPoint ) ||
//STRIP001             pFrameSel->pImpl->aSpotRight.IsInside( aPoint ) ||
//STRIP001             pFrameSel->pImpl->aSpotTop.IsInside( aPoint ) ||
//STRIP001             pFrameSel->pImpl->aSpotBottom.IsInside( aPoint ) ||
//STRIP001             (pFrameSel->pImpl->eSel == SVX_FRMSELTYPE_TABLE &&
//STRIP001                 (pFrameSel->pImpl->aSpotHor.IsInside( aPoint ) ||
//STRIP001                     pFrameSel->pImpl->aSpotVer.IsInside( aPoint ) ));
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:12:00---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 uno::Reference< XAccessible > SvxFrameSelectorAccessible_Impl::getAccessibleAtPoint(
//STRIP001     const awt::Point& aPt )
//STRIP001         throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     Point aPoint(aPt.X, aPt.Y);
//STRIP001     uno::Reference< XAccessible > xRet;
//STRIP001     SvxFrameSelectorLine eEnd = pFrameSel->pImpl->eSel == SVX_FRMSELTYPE_TABLE ?
//STRIP001         SVX_FRMSELLINE_VER : SVX_FRMSELLINE_BOTTOM;
//STRIP001     for(sal_Int16 nWhich = SVX_FRMSELLINE_LEFT; nWhich <= eEnd; nWhich++)
//STRIP001     {
//STRIP001         const Rectangle aSpot = pFrameSel->pImpl->GetLineSpot((SvxFrameSelectorLine) nWhich);
//STRIP001         if(aSpot.IsInside( aPoint ))
//STRIP001         {
//STRIP001             xRet = pFrameSel->pImpl->GetChildAccessible(*pFrameSel, (SvxFrameSelectorLine) nWhich);
//STRIP001             break;
//STRIP001         }
//STRIP001     }
//STRIP001     return xRet;
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:12:00---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 awt::Rectangle SvxFrameSelectorAccessible_Impl::getBounds(  ) throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     Size aSz;
//STRIP001     Point aPos;
//STRIP001     switch(eWhichChild)
//STRIP001     {
//STRIP001         case SVX_FRMSELLINE_NONE:
//STRIP001             aSz = pFrameSel->GetSizePixel();
//STRIP001             aPos = pFrameSel->GetPosPixel();
//STRIP001         break;
//STRIP001         default:
//STRIP001             const Rectangle aSpot = pFrameSel->pImpl->GetLineSpot(eWhichChild);
//STRIP001             aPos = aSpot.TopLeft();
//STRIP001             aSz = aSpot.GetSize();
//STRIP001     }
//STRIP001     awt::Rectangle aRet;
//STRIP001     aRet.X = aPos.X();
//STRIP001     aRet.Y = aPos.Y();
//STRIP001     aRet.Width = aSz.Width();
//STRIP001     aRet.Height = aSz.Height();
//STRIP001     return aRet;
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:12:00---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 awt::Point SvxFrameSelectorAccessible_Impl::getLocation(  ) throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     Point aPos;
//STRIP001     switch(eWhichChild)
//STRIP001     {
//STRIP001         case SVX_FRMSELLINE_NONE:
//STRIP001             aPos = pFrameSel->GetPosPixel();
//STRIP001         break;
//STRIP001         default:
//STRIP001             const SvxFrameLine& rLine = pFrameSel->GetLine(eWhichChild);
//STRIP001             aPos = rLine.GetStartPos();
//STRIP001     }
//STRIP001     awt::Point aRet(aPos.X(), aPos.Y());
//STRIP001     return aRet;
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:12:01---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 awt::Point SvxFrameSelectorAccessible_Impl::getLocationOnScreen(  ) throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     Point aPos;
//STRIP001     switch(eWhichChild)
//STRIP001     {
//STRIP001         case SVX_FRMSELLINE_NONE:
//STRIP001             aPos = pFrameSel->GetPosPixel();
//STRIP001         break;
//STRIP001         default:
//STRIP001             const SvxFrameLine& rLine = pFrameSel->GetLine(eWhichChild);
//STRIP001             aPos = rLine.GetStartPos();
//STRIP001     }
//STRIP001     aPos = pFrameSel->OutputToAbsoluteScreenPixel( aPos );
//STRIP001     awt::Point aRet(aPos.X(), aPos.Y());
//STRIP001     return aRet;
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:12:01---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 awt::Size SvxFrameSelectorAccessible_Impl::getSize(  ) throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     Size aSz;
//STRIP001     switch(eWhichChild)
//STRIP001     {
//STRIP001         case SVX_FRMSELLINE_NONE:
//STRIP001             aSz = pFrameSel->GetSizePixel();
//STRIP001         break;
//STRIP001         default:
//STRIP001             const SvxFrameLine& rLine = pFrameSel->GetLine(eWhichChild);
//STRIP001             Point aPos = rLine.GetStartPos();
//STRIP001             Point aEndPos = rLine.GetEndPos();
//STRIP001             aSz.Width() = aPos.X() - aEndPos.X();
//STRIP001             aSz.Height() = aPos.Y() - aEndPos.Y();
//STRIP001     }
//STRIP001     awt::Size aRet(aSz.Width(), aSz.Height());
//STRIP001     return awt::Size();
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:12:01---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 sal_Bool SvxFrameSelectorAccessible_Impl::isShowing(  ) throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     return sal_True;
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:12:02---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 sal_Bool SvxFrameSelectorAccessible_Impl::isVisible(  ) throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     return sal_True;
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:12:02---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 sal_Bool SvxFrameSelectorAccessible_Impl::isFocusTraversable(  ) throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     return sal_True;
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:12:03---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 void SvxFrameSelectorAccessible_Impl::addFocusListener( const uno::Reference< awt::XFocusListener >& xListener ) throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     aFocusListeners.addInterface( xListener );
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:12:03---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 void SvxFrameSelectorAccessible_Impl::removeFocusListener( const uno::Reference< awt::XFocusListener >& xListener ) throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     aFocusListeners.removeInterface( xListener );
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:12:03---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 void SvxFrameSelectorAccessible_Impl::grabFocus(  ) throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     pFrameSel->GrabFocus();
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:12:04---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 uno::Any SvxFrameSelectorAccessible_Impl::getAccessibleKeyBinding(  ) throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     uno::Any aRet;
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     utl::AccessibleRelationSetHelper* pHelper;
//STRIP001     uno::Reference< XAccessibleRelationSet > xRet = pHelper = new utl::AccessibleRelationSetHelper;
//STRIP001     if(eWhichChild == SVX_FRMSELLINE_NONE)
//STRIP001     {
//STRIP001         Window* pPrev = pFrameSel->GetWindow( WINDOW_PREV );
//STRIP001         if(pPrev && WINDOW_FIXEDTEXT == pPrev->GetType())
//STRIP001         {
//STRIP001             String sText = pPrev->GetText();
//STRIP001             xub_StrLen nFound = sText.Search( MNEMONIC_CHAR );
//STRIP001             if(STRING_NOTFOUND != nFound && ++nFound < sText.Len())
//STRIP001             {
//STRIP001                 sText.ToUpperAscii();
//STRIP001                 sal_Unicode cChar = sText.GetChar(nFound);
//STRIP001                 awt::KeyEvent aEvent;
//STRIP001 
//STRIP001                 aEvent.KeyCode = 0;
//STRIP001                 aEvent.KeyChar = cChar;
//STRIP001                 aEvent.KeyFunc = 0;
//STRIP001                 if(cChar >= 'A' && cChar <= 'Z')
//STRIP001                 {
//STRIP001                      aEvent.KeyCode = awt::Key::A + cChar - 'A';
//STRIP001                 }
//STRIP001                 aEvent.Modifiers = awt::KeyModifier::MOD2;
//STRIP001                 aRet <<= aEvent;
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001     return aRet;
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:12:04---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 sal_Int32 SvxFrameSelectorAccessible_Impl::getForeground(  )
//STRIP001         throw (::com::sun::star::uno::RuntimeException)
//STRIP001 {
//STRIP001     uno::Any aRet;
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     return pFrameSel->GetControlForeground().GetColor();
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:12:04---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 sal_Int32 SvxFrameSelectorAccessible_Impl::getBackground(  )
//STRIP001         throw (::com::sun::star::uno::RuntimeException)
//STRIP001 {
//STRIP001     uno::Any aRet;
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     IsValid();
//STRIP001     return pFrameSel->GetControlBackground().GetColor();
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:12:04---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 ::rtl::OUString SvxFrameSelectorAccessible_Impl::getImplementationName(  ) throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     return ::rtl::OUString::createFromAscii("SvxFrameSelectorAccessible_Impl");
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:12:05---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 const sal_Char sAccessible[]          = "Accessible";
//STRIP001 const sal_Char sAccessibleContext[]   = "AccessibleContext";
//STRIP001 const sal_Char sAccessibleComponent[] = "AccessibleComponent";
//STRIP001 
//STRIP001 sal_Bool SvxFrameSelectorAccessible_Impl::supportsService( const ::rtl::OUString& rServiceName )
//STRIP001     throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     return  rServiceName.equalsAsciiL( sAccessible         , sizeof(sAccessible         )-1 ) ||
//STRIP001             rServiceName.equalsAsciiL( sAccessibleContext  , sizeof(sAccessibleContext  )-1 ) ||
//STRIP001             rServiceName.equalsAsciiL( sAccessibleComponent, sizeof(sAccessibleComponent)-1 );
//STRIP001 }
//STRIP001 /*-- 04.02.2002 14:12:05---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 uno::Sequence< ::rtl::OUString > SvxFrameSelectorAccessible_Impl::getSupportedServiceNames(  )
//STRIP001     throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     uno::Sequence< OUString > aRet(3);
//STRIP001 	OUString* pArray = aRet.getArray();
//STRIP001     pArray[0] = OUString( RTL_CONSTASCII_USTRINGPARAM(sAccessible         ) );
//STRIP001     pArray[1] = OUString( RTL_CONSTASCII_USTRINGPARAM(sAccessibleContext  ) );
//STRIP001     pArray[2] = OUString( RTL_CONSTASCII_USTRINGPARAM(sAccessibleComponent) );
//STRIP001     return aRet;
//STRIP001 }
//STRIP001 /* -----------------------------04.02.2002 14:31------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxFrameSelectorAccessible_Impl::IsValid() throw (uno::RuntimeException)
//STRIP001 {
//STRIP001     if(!pFrameSel)
//STRIP001         throw uno::RuntimeException();
//STRIP001 }
//STRIP001 /* -----------------------------04.02.2002 14:31------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void    SvxFrameSelectorAccessible_Impl::NotifyFocusListeners(sal_Bool bGetFocus)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     awt::FocusEvent aEvent;
//STRIP001     aEvent.FocusFlags = 0;
//STRIP001     if(bGetFocus)
//STRIP001     {
//STRIP001         USHORT nFocusFlags = pFrameSel->GetGetFocusFlags();
//STRIP001         if(nFocusFlags&GETFOCUS_TAB)
//STRIP001             aEvent.FocusFlags |= awt::FocusChangeReason::TAB;
//STRIP001         if(nFocusFlags&GETFOCUS_CURSOR)
//STRIP001             aEvent.FocusFlags |= awt::FocusChangeReason::CURSOR;
//STRIP001         if(nFocusFlags&GETFOCUS_MNEMONIC)
//STRIP001             aEvent.FocusFlags |= awt::FocusChangeReason::MNEMONIC;
//STRIP001         if(nFocusFlags&GETFOCUS_FORWARD)
//STRIP001             aEvent.FocusFlags |= awt::FocusChangeReason::FORWARD;
//STRIP001         if(nFocusFlags&GETFOCUS_BACKWARD)
//STRIP001             aEvent.FocusFlags |= awt::FocusChangeReason::BACKWARD;
//STRIP001         if(nFocusFlags&GETFOCUS_AROUND)
//STRIP001             aEvent.FocusFlags |= awt::FocusChangeReason::AROUND;
//STRIP001         if(nFocusFlags&GETFOCUS_UNIQUEMNEMONIC)
//STRIP001             aEvent.FocusFlags |= awt::FocusChangeReason::UNIQUEMNEMONIC;
//STRIP001     //        if(nFocusFlags&GETFOCUS_INIT)
//STRIP001     //            aEvent.FocusFlags |= FocusChangeReason::
//STRIP001     }
//STRIP001 //    else
//STRIP001     //how can I find the current focus window?
//STRIP001 //        aEvent.NextFocus = ;
//STRIP001     aEvent.Temporary = sal_False;
//STRIP001 
//STRIP001     uno::Reference < XAccessibleContext > xThis( this );
//STRIP001     aEvent.Source = xThis;
//STRIP001 
//STRIP001     ::cppu::OInterfaceIteratorHelper aIter( aFocusListeners );
//STRIP001 	while( aIter.hasMoreElements() )
//STRIP001 	{
//STRIP001         uno::Reference < awt::XFocusListener > xListener( aIter.next(), uno::UNO_QUERY );
//STRIP001         if(bGetFocus)
//STRIP001             xListener->focusGained( aEvent );
//STRIP001         else
//STRIP001             xListener->focusLost( aEvent );
//STRIP001     }
//STRIP001 }
//STRIP001 /* -----------------------------04.02.2002 16:16------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void    SvxFrameSelectorAccessible_Impl::Invalidate()
//STRIP001 {
//STRIP001     pFrameSel = 0;
//STRIP001     lang::EventObject aEvent;
//STRIP001     uno::Reference < XAccessibleContext > xThis( this );
//STRIP001 	aEvent.Source = xThis;
//STRIP001     aFocusListeners.disposeAndClear( aEvent );
//STRIP001     aPropertyListeners.disposeAndClear( aEvent );
//STRIP001 }
//STRIP001 // class SvxFrameLine ----------------------------------------------------
//STRIP001 
//STRIP001 struct SvxLineStruct SvxFrameLine::NO_LINE           = { 0,0,0 };
//STRIP001 struct SvxLineStruct SvxFrameLine::THIN_LINE         = { 1,0,0 };
//STRIP001 struct SvxLineStruct SvxFrameLine::THICK_LINE        = { 3,0,0 };
//STRIP001 struct SvxLineStruct SvxFrameLine::THIN_DOUBLE_LINE  = { 1,1,1 };
//STRIP001 struct SvxLineStruct SvxFrameLine::THICK_DOUBLE_LINE = { 2,1,2 };
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxFrameLine::SvxFrameLine()
//STRIP001 	:	aStartPos    ( 0, 0 ),
//STRIP001 		aMidPos      ( 0, 0 ),
//STRIP001 		aEndPos      ( 0, 0 ),
//STRIP001 		aColor       ( COL_BLACK ),
//STRIP001         aState     ( SVX_FRMLINESTATE_HIDE ),
//STRIP001 #ifndef MIPS
//STRIP001         aStyle     ( NO_LINE ),
//STRIP001         aCoreStyle ( NO_LINE ),
//STRIP001 #endif
//STRIP001 		bIsSelected  ( FALSE )
//STRIP001 {
//STRIP001 #if defined MIPS
//STRIP001     aStyle.nLeft=0;
//STRIP001     aStyle.nMiddle=0;
//STRIP001     aStyle.nRight=0;
//STRIP001     aCoreStyle.nLeft=0;
//STRIP001     aCoreStyle.nMiddle=0;
//STRIP001     aCoreStyle.nRight=0;
//STRIP001 #endif
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 #define WIDTH_THICK		(DEF_LINE_WIDTH_2 *100)
//STRIP001 
//STRIP001 void SvxFrameLine::SetStyle( const SvxLineStruct& rStyle )
//STRIP001 {
//STRIP001     aCoreStyle = rStyle;
//STRIP001 	/*
//STRIP001 	 * Mapping: (in TWIPS, 1pt = 100 * 20 TWIPS = duenn)
//STRIP001 	 * alles was <=0    				ist -> NO_LINE
//STRIP001 	 * alles was <=DEF_SLINE_WIDTH_2 	ist -> THIN_LINE
//STRIP001 	 * alles andere    					    -> THICK_LINE
//STRIP001 	 */
//STRIP001     if ( ( rStyle.nLeft <= 0 ) && ( rStyle.nRight <= 0 ) )
//STRIP001 	{
//STRIP001         aStyle = NO_LINE;
//STRIP001         aState = SVX_FRMLINESTATE_HIDE;
//STRIP001 	}
//STRIP001     else if ( ( rStyle.nRight == 0 ) &&             // einzelne Linie
//STRIP001               ( rStyle.nLeft  >  0 ) &&             // sichtbar
//STRIP001               ( rStyle.nLeft  < WIDTH_THICK ) )     // duenn
//STRIP001 	{
//STRIP001         aStyle = THIN_LINE;
//STRIP001         aState = SVX_FRMLINESTATE_SHOW;
//STRIP001 	}
//STRIP001     else if ( ( rStyle.nRight == 0 ) &&             // einzelne Linie
//STRIP001               ( rStyle.nLeft   > 0 ) &&             // sichtbar
//STRIP001               ( rStyle.nLeft  >= WIDTH_THICK ) )    // dick
//STRIP001 	{
//STRIP001         aStyle = THICK_LINE;
//STRIP001         aState = SVX_FRMLINESTATE_SHOW;
//STRIP001 	}
//STRIP001     else if ( ( rStyle.nRight > 0 ) &&              // doppelte Linie
//STRIP001               ( rStyle.nLeft  > 0 ) &&              // sichtbar
//STRIP001               ( rStyle.nLeft  < WIDTH_THICK ) )     // duenn
//STRIP001 	{
//STRIP001         aStyle = THIN_DOUBLE_LINE;
//STRIP001         aState = SVX_FRMLINESTATE_SHOW;
//STRIP001 	}
//STRIP001     else if ( ( rStyle.nRight > 0 ) &&              // doppelte Linie
//STRIP001               ( rStyle.nLeft  > 0 ) &&              // sichtbar
//STRIP001               ( rStyle.nLeft  >= WIDTH_THICK ) )    // dick
//STRIP001 	{
//STRIP001         aStyle = THICK_DOUBLE_LINE;
//STRIP001         aState = SVX_FRMLINESTATE_SHOW;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 #undef WIDTH_THICK
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFrameLine::SetState( SvxFrameLineState eState )
//STRIP001 {
//STRIP001     aState = eState;
//STRIP001 
//STRIP001 	if ( SVX_FRMLINESTATE_DONT_CARE == eState )
//STRIP001 	{
//STRIP001         aStyle     = THICK_LINE;
//STRIP001         aCoreStyle = NO_LINE;
//STRIP001 	}
//STRIP001 }
//STRIP001 // class SvxFrameSelector ------------------------------------------------
//STRIP001 
//STRIP001 inline const Color& SvxFrameSelector::GetPaintColor( const Color& rNormalColor ) const
//STRIP001 {
//STRIP001 	return pImpl->bHC? pImpl->aPaintLineCol : rNormalColor;
//STRIP001 }
//STRIP001 
//STRIP001 inline const Color&	SvxFrameSelector::GetDisplayBackgroundColor( const StyleSettings& rSettings ) const
//STRIP001 {
//STRIP001 	return rSettings.GetFieldColor();
//STRIP001 }
//STRIP001 
//STRIP001 const Color& SvxFrameSelector::GetDisplayBackgroundColor( void ) const
//STRIP001 {
//STRIP001 	return GetDisplayBackgroundColor( GetSettings().GetStyleSettings() );
//STRIP001 }
//STRIP001 
//STRIP001 SvxFrameSelector::SvxFrameSelector( Window* pParent,
//STRIP001                                     const ResId& rResId )
//STRIP001     :   Control			( pParent, rResId ),
//STRIP001         eShadow			( SVX_FRMSHADOW_NONE ),
//STRIP001         aShadowCol		( COL_BLACK ),
//STRIP001         bIsClicked		( FALSE ),
//STRIP001         pImpl			( new SvxFrameSelector_Impl( this ) )
//STRIP001 {
//STRIP001     EnableRTL( false ); // #107808# don't mirror the mouse handling
//STRIP001 }
//STRIP001 /* -----------------------------01.02.2002 16:47------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 SvxFrameSelector::~SvxFrameSelector()
//STRIP001 {
//STRIP001     delete pImpl;
//STRIP001 }
//STRIP001 /* -----------------------------01.02.2002 14:37------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxFrameSelector::Initialize(  SvxFrameSelectorType eType, BOOL bDontCare )
//STRIP001 {
//STRIP001     pImpl->eSel = eType;
//STRIP001     pImpl->bIsDontCare = bDontCare;
//STRIP001     InitBitmap_Impl();
//STRIP001 	Show();
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFrameSelector::InitBitmap_Impl()
//STRIP001 {
//STRIP001     Size aSzParent( GetSizePixel() );
//STRIP001     aSzParent.Width() -= 4;
//STRIP001     aSzParent.Height() -= 4;
//STRIP001     VirtualDevice   aVirDev;
//STRIP001     const long      nX  = aSzParent.Width();
//STRIP001     const long      nY  = aSzParent.Height();
//STRIP001 	long            nXMid = nX / 2;
//STRIP001 	long            nYMid = nY / 2;
//STRIP001 
//STRIP001     /*
//STRIP001 	 * Berechnen des Frame-Rects und der Linie-Mittelpunkte
//STRIP001 	 */
//STRIP001     pImpl->aBoundingRect = pImpl->aRectFrame = Rectangle( 21, 21, nX - 21, nY - 21 );
//STRIP001 
//STRIP001     pImpl->aLeftLine.aStartPos   = Point( 21, 21 );
//STRIP001     pImpl->aLeftLine.aEndPos     = Point( 21, nY - 21 );
//STRIP001     pImpl->aLeftLine.aMidPos     = Point( 21, nYMid );
//STRIP001 
//STRIP001     pImpl->aRightLine.aStartPos  = Point( nX - 21, 21 );
//STRIP001     pImpl->aRightLine.aEndPos    = Point( nX - 21, nY - 21 );
//STRIP001     pImpl->aRightLine.aMidPos    = Point( nX - 21, nYMid );
//STRIP001 
//STRIP001     pImpl->aVerLine.aStartPos    = Point( nXMid, 21 );
//STRIP001     pImpl->aVerLine.aEndPos      = Point( nXMid, nY - 21 );
//STRIP001     pImpl->aVerLine.aMidPos      = Point( nXMid, nYMid );
//STRIP001 
//STRIP001     pImpl->aTopLine.aStartPos    = pImpl->aLeftLine.aStartPos;
//STRIP001     pImpl->aTopLine.aEndPos      = pImpl->aRightLine.aStartPos;
//STRIP001     pImpl->aTopLine.aMidPos      = pImpl->aVerLine.aStartPos;
//STRIP001 
//STRIP001     pImpl->aBottomLine.aStartPos = pImpl->aLeftLine.aEndPos;
//STRIP001     pImpl->aBottomLine.aEndPos   = pImpl->aRightLine.aEndPos;
//STRIP001     pImpl->aBottomLine.aMidPos   = pImpl->aVerLine.aEndPos;
//STRIP001 
//STRIP001     pImpl->aHorLine.aStartPos    = pImpl->aLeftLine.aMidPos;
//STRIP001     pImpl->aHorLine.aEndPos      = pImpl->aRightLine.aMidPos;
//STRIP001     pImpl->aHorLine.aMidPos      = pImpl->aVerLine.aMidPos;
//STRIP001 
//STRIP001 	// HotSpot-Rectangles:
//STRIP001     pImpl->aSpotLeft   = Rectangle( Point( 0, 0 ),
//STRIP001                              Size( pImpl->aLeftLine.aStartPos.X() + 3,
//STRIP001                                    nY ) );
//STRIP001     pImpl->aSpotRight  = Rectangle( Point( pImpl->aRightLine.aStartPos.X() - 3, 0 ),
//STRIP001                              pImpl->aSpotLeft.GetSize() );
//STRIP001     pImpl->aSpotTop        = Rectangle( Point( pImpl->aTopLine.aStartPos.X(), 0 ),
//STRIP001                              Size( pImpl->aRectFrame.GetWidth(),
//STRIP001                                    pImpl->aTopLine.aStartPos.Y() + 3 ) );
//STRIP001     pImpl->aSpotBottom = Rectangle( pImpl->aBottomLine.aStartPos - Point( 0, 3 ),
//STRIP001                              pImpl->aSpotTop.GetSize() );
//STRIP001     pImpl->aSpotHor        = ( pImpl->eSel == SVX_FRMSELTYPE_TABLE )
//STRIP001                   ? Rectangle( pImpl->aHorLine.aStartPos + Point( 0, -2 ),
//STRIP001                                Size( pImpl->aRectFrame.GetWidth(), 5 ) )
//STRIP001 				  : Rectangle( Point( -1, -1 ), Size(- 1, -1 ) );
//STRIP001     pImpl->aSpotVer        = ( pImpl->eSel == SVX_FRMSELTYPE_TABLE )
//STRIP001                   ? Rectangle( pImpl->aVerLine.aStartPos + Point( -2, 0 ),
//STRIP001                                Size( 5, pImpl->aRectFrame.GetHeight() ) )
//STRIP001 				  : Rectangle( Point( -1, -1 ), Size( -1, -1 ) );
//STRIP001 
//STRIP001     const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();
//STRIP001     /*
//STRIP001 	 * Initialisieren der Bitmap:
//STRIP001 	 */
//STRIP001     aVirDev.SetOutputSizePixel( aSzParent );
//STRIP001     aVirDev.SetLineColor();
//STRIP001 
//STRIP001     aVirDev.SetFillColor( GetDisplayBackgroundColor( rStyleSettings ) );
//STRIP001     aVirDev.DrawRect( Rectangle( Point( 0, 0 ), aSzParent ) );
//STRIP001 
//STRIP001 	DrawContents_Impl( aVirDev );
//STRIP001 
//STRIP001 	/*
//STRIP001 	 * Malen der vier Eck-Winkel:
//STRIP001 	 */
//STRIP001     aVirDev.SetLineColor( rStyleSettings.GetFieldTextColor() );
//STRIP001 
//STRIP001 	// links/rechts oben:
//STRIP001 	aVirDev.DrawLine( Point( 10, 15 ), Point( 15, 15 ) );
//STRIP001 	aVirDev.DrawLine( Point( 15, 15 ), Point( 15, 10 ) );
//STRIP001 	aVirDev.DrawLine( Point( nX - 10, 15 ), Point( nX - 15, 15 ) );
//STRIP001 	aVirDev.DrawLine( Point( nX - 15, 15 ), Point( nX - 15, 10 ) );
//STRIP001 
//STRIP001 	// links/rechts unten:
//STRIP001 	aVirDev.DrawLine( Point( 10, nY - 15 ), Point( 15, nY - 15 ) );
//STRIP001 	aVirDev.DrawLine( Point( 15, nY - 15 ), Point( 15, nY - 10 ) );
//STRIP001 	aVirDev.DrawLine( Point( nX -10, nY - 15 ), Point( nX - 15, nY - 15 ) );
//STRIP001 	aVirDev.DrawLine( Point( nX -15, nY - 15 ), Point( nX - 15, nY - 10 ) );
//STRIP001 
//STRIP001 	/*
//STRIP001 	 * Tabelle: Malen der vier Mitte-Winkel:
//STRIP001 	 */
//STRIP001     if ( pImpl->eSel == SVX_FRMSELTYPE_TABLE )
//STRIP001 	{
//STRIP001 		// links/rechts
//STRIP001 		aVirDev.DrawLine( Point( 10, nYMid ),       Point( 15, nYMid ) );
//STRIP001 		aVirDev.DrawLine( Point( 15, nYMid-2 ),     Point( 15, nYMid+2 ) );
//STRIP001 		aVirDev.DrawLine( Point( nX-10, nYMid ),    Point( nX-15, nYMid ) );
//STRIP001 		aVirDev.DrawLine( Point( nX-15, nYMid-2 ),  Point( nX-15, nYMid+2 ) );
//STRIP001 
//STRIP001 		// horizontal/vertikal
//STRIP001 		aVirDev.DrawLine( Point( nXMid, 10 ),       Point( nXMid, 15 ) );
//STRIP001 		aVirDev.DrawLine( Point( nXMid-2, 15 ),     Point( nXMid+2, 15 ) );
//STRIP001 		aVirDev.DrawLine( Point( nXMid, nY-10 ),    Point( nXMid, nY-15 ) );
//STRIP001 		aVirDev.DrawLine( Point( nXMid-2, nY-15 ),  Point( nXMid+2, nY-15 ) );
//STRIP001 	}
//STRIP001     pImpl->aBackBmp = aVirDev.GetBitmap( Point( 0, 0 ), aSzParent );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFrameSelector::DrawFrameLine_Impl( OutputDevice& rVirDev, Point from,
//STRIP001 	Point to, BOOL bHor, SvxLineStruct& dline, SvxLineStruct& lt,
//STRIP001 	SvxLineStruct& lLine, SvxLineStruct& lb, SvxLineStruct& rt,
//STRIP001 	SvxLineStruct& rLine, SvxLineStruct& rb )
//STRIP001 {
//STRIP001 	short diffArr[4];       // Kreuzungspunkt-Differenzen
//STRIP001 	short nHeight = 0;
//STRIP001 	Point from2( from );
//STRIP001 	Point to2( to );
//STRIP001 
//STRIP001 	if ( bHor ) // horizontale Linien
//STRIP001 	{
//STRIP001 		// Berechnung der Differenzen der Linienlaenge
//STRIP001 		// in den Kreuzungspunkten:
//STRIP001 		LinkLine( dline, lt, lLine, lb, rt, rLine, rb, diffArr );
//STRIP001 		nHeight = dline.nLeft + dline.nMiddle + dline.nRight;
//STRIP001 
//STRIP001 		from.Y() -= nHeight/2;
//STRIP001 		to.Y()   -= nHeight/2;
//STRIP001 		to.Y()   += ( dline.nLeft - 1 );
//STRIP001 
//STRIP001 		from.X() += diffArr[0];
//STRIP001 		to.X()   += diffArr[2];
//STRIP001 
//STRIP001 		rVirDev.DrawRect( Rectangle( from, to ) );
//STRIP001 
//STRIP001 		// noch eine zweite Linie zu malen?
//STRIP001 		if ( dline.nRight != 0 )
//STRIP001 		{
//STRIP001 			from2.Y() -= nHeight / 2;
//STRIP001 			from2.Y() += dline.nLeft + dline.nMiddle;
//STRIP001 			to2.Y()   -= nHeight / 2;
//STRIP001 			to2.Y()   += dline.nMiddle + dline.nLeft;
//STRIP001 			to2.Y()   += ( dline.nRight - 1 );
//STRIP001 			from2.X() += diffArr[1];
//STRIP001 			to2.X()   += diffArr[3];
//STRIP001 			rVirDev.DrawRect( Rectangle( from2, to2 ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else // vertikale Linien
//STRIP001 	{
//STRIP001 		// Berechnung der Differenzen der Linienlaenge
//STRIP001 		// in den Kreuzungspunkten:
//STRIP001 		LinkLine( dline, lt, lLine, lb, rt, rLine, rb, diffArr );
//STRIP001 		nHeight = dline.nLeft + dline.nMiddle + dline.nRight;
//STRIP001 
//STRIP001 		from.X() -= nHeight / 2;
//STRIP001 		to.X()   -= nHeight / 2;
//STRIP001 		to.X()   += ( dline.nLeft - 1 );
//STRIP001 		from.Y() -= diffArr[2];
//STRIP001 		to.Y()   -= diffArr[0];
//STRIP001 		rVirDev.DrawRect( Rectangle( from, to ) );
//STRIP001 
//STRIP001 		// noch eine zweite Linie zu malen?
//STRIP001 		if ( dline.nRight != 0 )
//STRIP001 		{
//STRIP001 			from2.X() -= nHeight / 2;
//STRIP001 			from2.X() += dline.nLeft + dline.nMiddle;
//STRIP001 			to2.X()   -= nHeight / 2;
//STRIP001 			to2.X()   += dline.nMiddle + dline.nLeft;
//STRIP001 			to2.X()   += ( dline.nRight - 1 );
//STRIP001 			from2.Y() -= diffArr[3];
//STRIP001 			to2.Y()   -= diffArr[1];
//STRIP001 			rVirDev.DrawRect( Rectangle( from2, to2 ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	/*
//STRIP001 	 * Anpassen des umgebenden Rectangles:
//STRIP001 	 */
//STRIP001 	long x1 = Min( from.X(), from2.X() );
//STRIP001 	long x2 = Max( to.X(),   to2.X()   );
//STRIP001 	long y1 = Min( from.Y(), from2.Y() );
//STRIP001 	long y2 = Max( to.Y(),   to2.Y()   );
//STRIP001 
//STRIP001     if ( x1 < pImpl->aBoundingRect.Left() )
//STRIP001         pImpl->aBoundingRect.Left() = x1;
//STRIP001     else if ( x1 > pImpl->aBoundingRect.Right() )
//STRIP001         pImpl->aBoundingRect.Right() = x1;
//STRIP001 
//STRIP001     if ( x2 < pImpl->aBoundingRect.Left() )
//STRIP001         pImpl->aBoundingRect.Left() = x2;
//STRIP001     else if ( x2 > pImpl->aBoundingRect.Right() )
//STRIP001         pImpl->aBoundingRect.Right() = x2;
//STRIP001 
//STRIP001     if ( y1 < pImpl->aBoundingRect.Top() )
//STRIP001         pImpl->aBoundingRect.Top() = y1;
//STRIP001     else if ( y1 > pImpl->aBoundingRect.Bottom() )
//STRIP001         pImpl->aBoundingRect.Bottom() = y1;
//STRIP001 
//STRIP001     if ( y2 < pImpl->aBoundingRect.Top() )
//STRIP001         pImpl->aBoundingRect.Top() = y2;
//STRIP001     else if ( y2 > pImpl->aBoundingRect.Bottom() )
//STRIP001         pImpl->aBoundingRect.Bottom() = y2;
//STRIP001 }
//STRIP001 
//STRIP001 // class SvxFrameSelector ------------------------------------------------
//STRIP001 
//STRIP001 void SvxFrameSelector::HideLines()
//STRIP001 {
//STRIP001     pImpl->aLeftLine.aState    =
//STRIP001     pImpl->aRightLine.aState   =
//STRIP001     pImpl->aTopLine.aState     =
//STRIP001     pImpl->aBottomLine.aState  =
//STRIP001     pImpl->aHorLine.aState     =
//STRIP001     pImpl->aVerLine.aState     = SVX_FRMLINESTATE_HIDE;
//STRIP001     pImpl->aLeftLine.aStyle    =
//STRIP001     pImpl->aRightLine.aStyle   =
//STRIP001     pImpl->aTopLine.aStyle     =
//STRIP001     pImpl->aBottomLine.aStyle  =
//STRIP001     pImpl->aHorLine.aStyle     =
//STRIP001     pImpl->aHorLine.aStyle     =
//STRIP001     pImpl->aVerLine.aStyle     = SvxFrameLine::NO_LINE;
//STRIP001 
//STRIP001 	ShowLines();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFrameSelector::ShowLines()
//STRIP001 {
//STRIP001 	VirtualDevice   aVirDev;
//STRIP001 	Color           aFillColor;
//STRIP001     const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();
//STRIP001 	const Color aFieldColor = rStyleSettings.GetFieldColor();
//STRIP001     Color aBackgroundColor = aFieldColor; //was: COL_WHITE
//STRIP001 
//STRIP001     aVirDev.SetOutputSizePixel( pImpl->aBackBmp.GetSizePixel() );
//STRIP001     aVirDev.DrawBitmap( Point( 0, 0 ), pImpl->aBackBmp );
//STRIP001 
//STRIP001 	// gesamten Rahmen loeschen und Inhalt malen
//STRIP001 	aVirDev.SetLineColor();
//STRIP001     aVirDev.SetFillColor( aBackgroundColor );
//STRIP001     aVirDev.DrawRect( pImpl->aBoundingRect );
//STRIP001 	DrawContents_Impl( aVirDev );
//STRIP001     pImpl->aBoundingRect = pImpl->aRectFrame;
//STRIP001 
//STRIP001 	/*
//STRIP001 	 * Zeichnen aller Linien:
//STRIP001 	 * ----------------------
//STRIP001 	 * Eine Linie wird in zwei Abschnitten gemalt, um die Kreuzungs-
//STRIP001 	 * punkte mit anderen Linien beruecksichtigen zu koennen.
//STRIP001 	 * Diese Aufgabe uebernimmt die Methode DrawFrameLine_Impl().
//STRIP001 	 */
//STRIP001 
//STRIP001 	// innere Linien: ---------------------------------------------
//STRIP001 
//STRIP001     if ( pImpl->eSel == SVX_FRMSELTYPE_TABLE &&
//STRIP001          ( pImpl->aVerLine.aState == SVX_FRMLINESTATE_SHOW ||
//STRIP001            pImpl->aVerLine.aState == SVX_FRMLINESTATE_DONT_CARE ) )
//STRIP001 	{
//STRIP001         if ( pImpl->aVerLine.aState == SVX_FRMLINESTATE_SHOW )
//STRIP001             aFillColor = GetPaintColor( pImpl->aVerLine.aColor );
//STRIP001 		else
//STRIP001 			aFillColor = Color( COL_LIGHTGRAY );
//STRIP001 
//STRIP001 		aVirDev.SetLineColor();
//STRIP001         if(aFieldColor == aFillColor)
//STRIP001 			aFillColor.Invert();
//STRIP001         aVirDev.SetFillColor( aFillColor );
//STRIP001 
//STRIP001 		DrawFrameLine_Impl( aVirDev,
//STRIP001             pImpl->aVerLine.aStartPos,
//STRIP001             pImpl->aVerLine.aMidPos,
//STRIP001 			FALSE,
//STRIP001             pImpl->aVerLine.aStyle,    // dline
//STRIP001             pImpl->aHorLine.aStyle,    // rb
//STRIP001             pImpl->aVerLine.aStyle,    // lLine
//STRIP001             pImpl->aHorLine.aStyle,    // rt
//STRIP001             pImpl->aTopLine.aStyle,    // lb
//STRIP001 			SvxFrameLine::NO_LINE,  // rLine
//STRIP001             pImpl->aTopLine.aStyle     // lt
//STRIP001 		);
//STRIP001 
//STRIP001 		DrawFrameLine_Impl( aVirDev,
//STRIP001             pImpl->aVerLine.aMidPos,
//STRIP001             pImpl->aVerLine.aEndPos,
//STRIP001 			FALSE,
//STRIP001             pImpl->aVerLine.aStyle,    // dline
//STRIP001             pImpl->aBottomLine.aStyle, // rb
//STRIP001 			SvxFrameLine::NO_LINE,  // lLine
//STRIP001             pImpl->aBottomLine.aStyle, // rb
//STRIP001             pImpl->aHorLine.aStyle,    // lb
//STRIP001             pImpl->aVerLine.aStyle,    // rLine
//STRIP001             pImpl->aHorLine.aStyle     // lt
//STRIP001 		);
//STRIP001 	}
//STRIP001 
//STRIP001     if ( pImpl->eSel == SVX_FRMSELTYPE_TABLE &&
//STRIP001          ( pImpl->aHorLine.aState == SVX_FRMLINESTATE_SHOW ||
//STRIP001            pImpl->aHorLine.aState == SVX_FRMLINESTATE_DONT_CARE ) )
//STRIP001 	{
//STRIP001         if ( pImpl->aHorLine.aState == SVX_FRMLINESTATE_SHOW )
//STRIP001             aFillColor = GetPaintColor( pImpl->aHorLine.aColor );
//STRIP001 		else
//STRIP001 			aFillColor = Color( COL_LIGHTGRAY );
//STRIP001 
//STRIP001 		aVirDev.SetLineColor();
//STRIP001         if(aFieldColor == aFillColor)
//STRIP001 			aFillColor.Invert();
//STRIP001         aVirDev.SetFillColor( aFillColor );
//STRIP001 
//STRIP001 		DrawFrameLine_Impl( aVirDev,
//STRIP001             pImpl->aHorLine.aStartPos,
//STRIP001             pImpl->aHorLine.aMidPos,
//STRIP001 			TRUE,
//STRIP001             pImpl->aHorLine.aStyle,    // dline
//STRIP001             pImpl->aLeftLine.aStyle,   // lt
//STRIP001 			SvxFrameLine::NO_LINE,  // lLine
//STRIP001             pImpl->aLeftLine.aStyle,   // lb
//STRIP001             pImpl->aVerLine.aStyle,    // rt
//STRIP001             pImpl->aHorLine.aStyle,    // rLine
//STRIP001             pImpl->aVerLine.aStyle     // rb
//STRIP001 		);
//STRIP001 
//STRIP001 		DrawFrameLine_Impl( aVirDev,
//STRIP001             pImpl->aHorLine.aMidPos,
//STRIP001             pImpl->aHorLine.aEndPos,
//STRIP001 			TRUE,
//STRIP001             pImpl->aHorLine.aStyle,    // dline
//STRIP001             pImpl->aVerLine.aStyle,    // lt
//STRIP001             pImpl->aHorLine.aStyle,    // lLine
//STRIP001             pImpl->aVerLine.aStyle,    // lb
//STRIP001             pImpl->aRightLine.aStyle,  // rt
//STRIP001 			SvxFrameLine::NO_LINE,  // rLine
//STRIP001             pImpl->aRightLine.aStyle   // rb
//STRIP001 		);
//STRIP001 	}
//STRIP001 
//STRIP001 	// aeussere Linien: -------------------------------------------
//STRIP001 
//STRIP001     if ( pImpl->aLeftLine.aState == SVX_FRMLINESTATE_SHOW ||
//STRIP001          pImpl->aLeftLine.aState == SVX_FRMLINESTATE_DONT_CARE )
//STRIP001 	{
//STRIP001         if ( pImpl->aLeftLine.aState == SVX_FRMLINESTATE_SHOW )
//STRIP001             aFillColor = GetPaintColor( pImpl->aLeftLine.aColor );
//STRIP001 		else
//STRIP001 			aFillColor = Color( COL_LIGHTGRAY );
//STRIP001 
//STRIP001 		aVirDev.SetLineColor();
//STRIP001         if(aFieldColor == aFillColor)
//STRIP001 			aFillColor.Invert();
//STRIP001 		aVirDev.SetFillColor( aFillColor );
//STRIP001 
//STRIP001 		DrawFrameLine_Impl( aVirDev,
//STRIP001             pImpl->aLeftLine.aStartPos,
//STRIP001             pImpl->aLeftLine.aMidPos,
//STRIP001 			FALSE,
//STRIP001             pImpl->aLeftLine.aStyle,   // dline
//STRIP001 			SvxFrameLine::NO_LINE,  // lb
//STRIP001             pImpl->aLeftLine.aStyle,   // lLine
//STRIP001             pImpl->aHorLine.aStyle,    // lt
//STRIP001 			SvxFrameLine::NO_LINE,  // rb
//STRIP001 			SvxFrameLine::NO_LINE,  // rLine
//STRIP001             pImpl->aTopLine.aStyle     // rt
//STRIP001 		);
//STRIP001 
//STRIP001 		DrawFrameLine_Impl( aVirDev,
//STRIP001             pImpl->aLeftLine.aMidPos,
//STRIP001             pImpl->aLeftLine.aEndPos,
//STRIP001 			FALSE,
//STRIP001             pImpl->aLeftLine.aStyle,   // dline
//STRIP001 			SvxFrameLine::NO_LINE,  // lb
//STRIP001 			SvxFrameLine::NO_LINE,  // lLine
//STRIP001             pImpl->aBottomLine.aStyle, // lt
//STRIP001 			SvxFrameLine::NO_LINE,  // rb
//STRIP001             pImpl->aLeftLine.aStyle,   // rLine
//STRIP001             pImpl->aHorLine.aStyle     // rt
//STRIP001 		);
//STRIP001 	}
//STRIP001 
//STRIP001     if ( pImpl->aRightLine.aState == SVX_FRMLINESTATE_SHOW ||
//STRIP001          pImpl->aRightLine.aState == SVX_FRMLINESTATE_DONT_CARE )
//STRIP001 	{
//STRIP001         if ( pImpl->aRightLine.aState == SVX_FRMLINESTATE_SHOW )
//STRIP001             aFillColor = GetPaintColor( pImpl->aRightLine.aColor );
//STRIP001 		else
//STRIP001 			aFillColor = Color( COL_LIGHTGRAY );
//STRIP001 
//STRIP001 		aVirDev.SetLineColor();
//STRIP001         if(aFieldColor == aFillColor)
//STRIP001 			aFillColor.Invert();
//STRIP001 		aVirDev.SetFillColor( aFillColor );
//STRIP001 
//STRIP001 		DrawFrameLine_Impl( aVirDev,
//STRIP001             pImpl->aRightLine.aStartPos,
//STRIP001             pImpl->aRightLine.aMidPos,
//STRIP001 			FALSE,
//STRIP001             pImpl->aRightLine.aStyle,  // dline
//STRIP001             pImpl->aHorLine.aStyle,    // rb
//STRIP001             pImpl->aRightLine.aStyle,  // lLine
//STRIP001 			SvxFrameLine::NO_LINE,  // rt
//STRIP001             pImpl->aTopLine.aStyle,    // lb
//STRIP001 			SvxFrameLine::NO_LINE,  // eLine
//STRIP001 			SvxFrameLine::NO_LINE   // lt
//STRIP001 		);
//STRIP001 
//STRIP001 		DrawFrameLine_Impl( aVirDev,
//STRIP001             pImpl->aRightLine.aMidPos,
//STRIP001             pImpl->aRightLine.aEndPos,
//STRIP001 			FALSE,
//STRIP001             pImpl->aRightLine.aStyle,  // dline
//STRIP001             pImpl->aBottomLine.aStyle, // rb
//STRIP001 			SvxFrameLine::NO_LINE,  // lLine
//STRIP001 			SvxFrameLine::NO_LINE,  // lt
//STRIP001             pImpl->aHorLine.aStyle,    // lb
//STRIP001             pImpl->aRightLine.aStyle,  // lLine
//STRIP001 			SvxFrameLine::NO_LINE   // rt
//STRIP001 		);
//STRIP001 	}
//STRIP001 
//STRIP001     if ( pImpl->aTopLine.aState == SVX_FRMLINESTATE_SHOW ||
//STRIP001          pImpl->aTopLine.aState == SVX_FRMLINESTATE_DONT_CARE )
//STRIP001 	{
//STRIP001         if ( pImpl->aTopLine.aState == SVX_FRMLINESTATE_SHOW )
//STRIP001             aFillColor = GetPaintColor( pImpl->aTopLine.aColor );
//STRIP001 		else
//STRIP001 			aFillColor = Color( COL_LIGHTGRAY );
//STRIP001 
//STRIP001 		aVirDev.SetLineColor();
//STRIP001         if(aFieldColor == aFillColor)
//STRIP001 			aFillColor.Invert();
//STRIP001 		aVirDev.SetFillColor( aFillColor );
//STRIP001 
//STRIP001 		DrawFrameLine_Impl( aVirDev,
//STRIP001             pImpl->aTopLine.aStartPos,
//STRIP001             pImpl->aTopLine.aMidPos,
//STRIP001 			TRUE,
//STRIP001             pImpl->aTopLine.aStyle,    // dline
//STRIP001 			SvxFrameLine::NO_LINE,  // lt
//STRIP001 			SvxFrameLine::NO_LINE,  // lLine
//STRIP001             pImpl->aLeftLine.aStyle,   // lb
//STRIP001 			SvxFrameLine::NO_LINE,  // rt
//STRIP001             pImpl->aTopLine.aStyle,    // rLine
//STRIP001             pImpl->aVerLine.aStyle     // rb
//STRIP001 		);
//STRIP001 
//STRIP001 		DrawFrameLine_Impl( aVirDev,
//STRIP001             pImpl->aTopLine.aMidPos,
//STRIP001             pImpl->aTopLine.aEndPos,
//STRIP001 			TRUE,
//STRIP001             pImpl->aTopLine.aStyle,    // dline
//STRIP001 			SvxFrameLine::NO_LINE,  // lt
//STRIP001             pImpl->aTopLine.aStyle,    // lLine
//STRIP001             pImpl->aVerLine.aStyle,    // lb
//STRIP001 			SvxFrameLine::NO_LINE,  // rt
//STRIP001 			SvxFrameLine::NO_LINE,  // rLine
//STRIP001             pImpl->aRightLine.aStyle   // rb
//STRIP001 		);
//STRIP001 	}
//STRIP001 
//STRIP001     if ( pImpl->aBottomLine.aState == SVX_FRMLINESTATE_SHOW ||
//STRIP001          pImpl->aBottomLine.aState == SVX_FRMLINESTATE_DONT_CARE )
//STRIP001 	{
//STRIP001         if ( pImpl->aBottomLine.aState == SVX_FRMLINESTATE_SHOW )
//STRIP001             aFillColor = GetPaintColor( pImpl->aBottomLine.aColor );
//STRIP001 		else
//STRIP001 			aFillColor = Color( COL_LIGHTGRAY );
//STRIP001 
//STRIP001 		aVirDev.SetLineColor();
//STRIP001         if(aFieldColor == aFillColor)
//STRIP001 			aFillColor.Invert();
//STRIP001 		aVirDev.SetFillColor( aFillColor );
//STRIP001 
//STRIP001 		DrawFrameLine_Impl( aVirDev,
//STRIP001             pImpl->aBottomLine.aStartPos,
//STRIP001             pImpl->aBottomLine.aMidPos,
//STRIP001 			TRUE,
//STRIP001             pImpl->aBottomLine.aStyle, // dline
//STRIP001             pImpl->aLeftLine.aStyle,   // lt
//STRIP001 			SvxFrameLine::NO_LINE,  // lLine
//STRIP001 			SvxFrameLine::NO_LINE,  // lb
//STRIP001             pImpl->aVerLine.aStyle,    // rt
//STRIP001             pImpl->aBottomLine.aStyle, // rLine
//STRIP001 			SvxFrameLine::NO_LINE   // rb
//STRIP001 		);
//STRIP001 
//STRIP001 		DrawFrameLine_Impl( aVirDev,
//STRIP001             pImpl->aBottomLine.aMidPos,
//STRIP001             pImpl->aBottomLine.aEndPos,
//STRIP001 			TRUE,
//STRIP001             pImpl->aBottomLine.aStyle, // dline
//STRIP001             pImpl->aVerLine.aStyle,    // lt
//STRIP001             pImpl->aBottomLine.aStyle, // lLine
//STRIP001 			SvxFrameLine::NO_LINE,  // lb
//STRIP001             pImpl->aRightLine.aStyle,  // rt
//STRIP001 			SvxFrameLine::NO_LINE,  // rLine
//STRIP001 			SvxFrameLine::NO_LINE   // rb
//STRIP001 		);
//STRIP001 	}
//STRIP001 
//STRIP001     pImpl->aBackBmp = aVirDev.GetBitmap( Point(0,0), pImpl->aBackBmp.GetSizePixel() );
//STRIP001 
//STRIP001 //    if ( eShadow != SVX_FRMSHADOW_NONE )
//STRIP001 //        ShowShadow();
//STRIP001 //    else
//STRIP001 		Invalidate( INVALIDATE_NOERASE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFrameSelector::SetCurLineStyle( const SvxLineStruct& rStyle )
//STRIP001 {
//STRIP001     pImpl->aCurLineStyle = rStyle;
//STRIP001 
//STRIP001     if ( pImpl->aLeftLine.bIsSelected )      pImpl->aLeftLine.SetStyle( rStyle );
//STRIP001     if ( pImpl->aRightLine.bIsSelected )     pImpl->aRightLine.SetStyle( rStyle );
//STRIP001     if ( pImpl->aTopLine.bIsSelected )       pImpl->aTopLine.SetStyle( rStyle );
//STRIP001     if ( pImpl->aBottomLine.bIsSelected )    pImpl->aBottomLine.SetStyle( rStyle );
//STRIP001     if ( pImpl->aHorLine.bIsSelected )       pImpl->aHorLine.SetStyle( rStyle );
//STRIP001     if ( pImpl->aVerLine.bIsSelected )       pImpl->aVerLine.SetStyle( rStyle );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFrameSelector::SetCurLineColor( const Color& aColor )
//STRIP001 {
//STRIP001     pImpl->aCurLineCol = aColor;
//STRIP001 
//STRIP001     if ( pImpl->aLeftLine.bIsSelected )      pImpl->aLeftLine.aColor   = aColor;
//STRIP001     if ( pImpl->aRightLine.bIsSelected )     pImpl->aRightLine.aColor  = aColor;
//STRIP001     if ( pImpl->aTopLine.bIsSelected )       pImpl->aTopLine.aColor    = aColor;
//STRIP001     if ( pImpl->aBottomLine.bIsSelected )    pImpl->aBottomLine.aColor = aColor;
//STRIP001     if ( pImpl->aHorLine.bIsSelected )       pImpl->aHorLine.aColor    = aColor;
//STRIP001     if ( pImpl->aVerLine.bIsSelected )       pImpl->aVerLine.aColor    = aColor;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFrameSelector::DrawContents_Impl( OutputDevice& rVirDev )
//STRIP001 {
//STRIP001 	/*
//STRIP001 	 * Malen des Inhaltes:
//STRIP001 	 */
//STRIP001 	if( pImpl->bHC )
//STRIP001 		return;
//STRIP001 
//STRIP001     if ( pImpl->eSel == SVX_FRMSELTYPE_TABLE )
//STRIP001 	{
//STRIP001 		Color aPrevLineColor = rVirDev.GetLineColor();
//STRIP001 		rVirDev.SetLineColor( Color( COL_LIGHTGRAY ) );
//STRIP001 		Color aPrevFillColor = rVirDev.GetFillColor();
//STRIP001 		rVirDev.SetFillColor( Color( COL_LIGHTGRAY ) );
//STRIP001 
//STRIP001 		Size aContentsSize =
//STRIP001             Size( pImpl->aVerLine.aStartPos.X() - pImpl->aLeftLine.aStartPos.X() - 8,
//STRIP001                   pImpl->aHorLine.aStartPos.Y() - pImpl->aTopLine.aStartPos.Y() - 8 );
//STRIP001 
//STRIP001 		// links-oben
//STRIP001         rVirDev.DrawRect( Rectangle( pImpl->aLeftLine.aStartPos + Point( 4, 4 ),
//STRIP001 									 aContentsSize ) );
//STRIP001 		// rechts-oben
//STRIP001         rVirDev.DrawRect( Rectangle( pImpl->aVerLine.aStartPos + Point( 4, 4 ),
//STRIP001 									 aContentsSize ) );
//STRIP001 		// links-unten
//STRIP001         rVirDev.DrawRect( Rectangle( pImpl->aHorLine.aStartPos + Point( 4, 4 ),
//STRIP001 									 aContentsSize ) );
//STRIP001 		// rechts-unten
//STRIP001         rVirDev.DrawRect( Rectangle( pImpl->aHorLine.aMidPos + Point( 4, 4 ),
//STRIP001 									 aContentsSize ) );
//STRIP001 
//STRIP001 		rVirDev.SetLineColor( aPrevLineColor );
//STRIP001 		rVirDev.SetFillColor( aPrevFillColor);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		Color aPrevLineColor = rVirDev.GetLineColor();
//STRIP001 		rVirDev.SetLineColor( Color( COL_LIGHTGRAY ) );
//STRIP001 		Color aPrevFillColor = rVirDev.GetFillColor();
//STRIP001 		rVirDev.SetFillColor( Color( COL_LIGHTGRAY ) );
//STRIP001 		Size aContentsSize =
//STRIP001             Size( pImpl->aRightLine.aStartPos.X() - pImpl->aLeftLine.aStartPos.X() - 8 ,
//STRIP001                   pImpl->aBottomLine.aStartPos.Y() - pImpl->aLeftLine.aStartPos.Y() - 8 );
//STRIP001 
//STRIP001         rVirDev.DrawRect( Rectangle( pImpl->aLeftLine.aStartPos + Point( 4, 4 ),
//STRIP001 									 aContentsSize ) );
//STRIP001 
//STRIP001 	/* symbolisierter Paragraph ist nicht gewuenscht - vielleicht spaeter mal wieder...
//STRIP001 		Size aContentsSize =
//STRIP001             Size( pImpl->aRightLine.aStartPos.X() - pImpl->aLeftLine.aStartPos.X() - 8,
//STRIP001                   pImpl->aBottomLine.aStartPos.Y() - pImpl->aLeftLine.aStartPos.Y() - 13 );
//STRIP001 
//STRIP001         rVirDev.DrawRect( Rectangle( pImpl->aLeftLine.aStartPos + Point( 4, 4 ),
//STRIP001 									 aContentsSize ) );
//STRIP001         rVirDev.DrawRect( Rectangle( pImpl->aLeftLine.aEndPos + Point( 4, -13 ),
//STRIP001 									 Size( 20, 8 ) ) );
//STRIP001 	*/
//STRIP001 		/* -------------------------------------------------------------------
//STRIP001 			kann StarWriter noch nicht - vielleicht spaeter mal:
//STRIP001 			Size    aContentsSize =
//STRIP001                     Size(  pImpl->aRightLine.aStartPos.X()
//STRIP001                          - pImpl->aLeftLine.aStartPos.X()
//STRIP001 						 - 8,
//STRIP001                            pImpl->aHorLine.aStartPos.Y()
//STRIP001                          - pImpl->aLeftLine.aStartPos.Y()
//STRIP001 						 - 13 );
//STRIP001 
//STRIP001 			// oben
//STRIP001             rVirDev.DrawRect( Rectangle( pImpl->aLeftLine.aStartPos + Point(4,4),
//STRIP001 										 aContentsSize ) );
//STRIP001             rVirDev.DrawRect( Rectangle( pImpl->aLeftLine.aMidPos + Point(4,-13),
//STRIP001 										 Size(20,8) ) );
//STRIP001 			// unten
//STRIP001             rVirDev.DrawRect( Rectangle( pImpl->aLeftLine.aMidPos + Point(4,4),
//STRIP001 										 aContentsSize ) );
//STRIP001             rVirDev.DrawRect( Rectangle( pImpl->aLeftLine.aEndPos + Point(4,-13),
//STRIP001 										 Size(20,8) ) );
//STRIP001 		--------------------------------------------------------------------*/
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFrameSelector::SelectLine( SvxFrameSelectorLine eNewLine, BOOL bSet )
//STRIP001 {
//STRIP001 	VirtualDevice aVirDev;
//STRIP001     const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();
//STRIP001 
//STRIP001     Color aDrawColor(
//STRIP001         ( bSet && ( eNewLine != SVX_FRMSELLINE_NONE ) ) ?
//STRIP001             rStyleSettings.GetFieldTextColor() : rStyleSettings.GetFieldColor() );
//STRIP001 
//STRIP001     long nX    = pImpl->aBackBmp.GetSizePixel().Width();
//STRIP001     long nY    = pImpl->aBackBmp.GetSizePixel().Height();
//STRIP001     long nXMid = pImpl->aVerLine.aStartPos.X();
//STRIP001     long nYMid = pImpl->aHorLine.aStartPos.Y();
//STRIP001 
//STRIP001     aVirDev.SetOutputSizePixel( pImpl->aBackBmp.GetSizePixel() );
//STRIP001     aVirDev.DrawBitmap( Point( 0, 0 ), pImpl->aBackBmp );
//STRIP001 
//STRIP001 	switch ( eNewLine )
//STRIP001 	{
//STRIP001 		case SVX_FRMSELLINE_LEFT:
//STRIP001 		{
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( 13, 3 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_DOWN );
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( 13, nY - 8 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_UP );
//STRIP001             pImpl->aLeftLine.bIsSelected = bSet;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SVX_FRMSELLINE_RIGHT:
//STRIP001 		{
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( nX - 17, 3 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_DOWN );
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( nX - 17, nY - 8 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_UP );
//STRIP001             pImpl->aRightLine.bIsSelected = bSet;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SVX_FRMSELLINE_TOP:
//STRIP001 		{
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( 3, 13 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_RIGHT );
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( nX - 8, 13 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_LEFT );
//STRIP001             pImpl->aTopLine.bIsSelected = bSet;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SVX_FRMSELLINE_BOTTOM:
//STRIP001 		{
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( 3, nY - 17 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_RIGHT );
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( nX - 8, nY - 17 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_LEFT );
//STRIP001             pImpl->aBottomLine.bIsSelected = bSet;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SVX_FRMSELLINE_HOR:
//STRIP001         if ( pImpl->eSel == SVX_FRMSELTYPE_TABLE )
//STRIP001 		{
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( 3, nYMid - 2 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_RIGHT );
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( nX - 8, nYMid - 2 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_LEFT );
//STRIP001             pImpl->aHorLine.bIsSelected = bSet;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SVX_FRMSELLINE_VER:
//STRIP001         if ( pImpl->eSel == SVX_FRMSELTYPE_TABLE )
//STRIP001 		{
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( nXMid - 2, 3 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_DOWN);
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( nXMid - 2, nY - 8 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_UP );
//STRIP001             pImpl->aVerLine.bIsSelected = bSet;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SVX_FRMSELLINE_NONE:
//STRIP001 		{
//STRIP001 			// links
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( 13, 3 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_DOWN );
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( 13, nY - 8 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_UP );
//STRIP001 			// rechts
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( nX - 17, 3 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_DOWN );
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( nX - 17, nY - 8 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_UP );
//STRIP001 			// oben
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( 3, 13 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_RIGHT );
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( nX - 8, 13 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_LEFT );
//STRIP001 			// unten
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( 3, nY - 17 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_RIGHT );
//STRIP001 			DrawSelArrow_Impl( aVirDev, Point( nX - 8, nY - 17 ), aDrawColor,
//STRIP001 						  SVX_SELARROWTYPE_LEFT );
//STRIP001 
//STRIP001             if ( pImpl->eSel == SVX_FRMSELTYPE_TABLE )
//STRIP001 			{
//STRIP001 				// horizontal
//STRIP001 				DrawSelArrow_Impl( aVirDev, Point( 3, nYMid-2 ), aDrawColor,
//STRIP001 							  SVX_SELARROWTYPE_RIGHT );
//STRIP001 				DrawSelArrow_Impl( aVirDev, Point( nX - 8, nYMid - 2 ), aDrawColor,
//STRIP001 							  SVX_SELARROWTYPE_LEFT );
//STRIP001 
//STRIP001 				// vertikal
//STRIP001 				DrawSelArrow_Impl( aVirDev, Point( nXMid - 2, 3 ),aDrawColor,
//STRIP001 							  SVX_SELARROWTYPE_DOWN );
//STRIP001 				DrawSelArrow_Impl( aVirDev, Point( nXMid - 2, nY - 8 ), aDrawColor,
//STRIP001 							  SVX_SELARROWTYPE_UP );
//STRIP001 			}
//STRIP001 
//STRIP001             pImpl->aLeftLine.bIsSelected     =
//STRIP001             pImpl->aRightLine.bIsSelected    =
//STRIP001             pImpl->aTopLine.bIsSelected      =
//STRIP001             pImpl->aBottomLine.bIsSelected   =
//STRIP001             pImpl->aHorLine.bIsSelected      =
//STRIP001             pImpl->aVerLine.bIsSelected      = FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001     pImpl->aBackBmp = aVirDev.GetBitmap( Point( 0, 0 ), pImpl->aBackBmp.GetSizePixel() );
//STRIP001 	Invalidate( INVALIDATE_NOERASE );
//STRIP001 	if(aSelectLink.IsSet())
//STRIP001 		aSelectLink.Call(0);
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFrameSelector::DrawSelArrow_Impl(
//STRIP001 
//STRIP001 	OutputDevice& rDev, Point aPos, Color aCol, SvxSelArrowType eType )
//STRIP001 {
//STRIP001 	Point   aPtArray[5];
//STRIP001 	Color	aPrevLineColor = rDev.GetLineColor();
//STRIP001 	Color	aPrevFillColor = rDev.GetFillColor();
//STRIP001 	rDev.SetLineColor( aCol );
//STRIP001 	rDev.SetFillColor( aCol );
//STRIP001 
//STRIP001 	switch ( eType )
//STRIP001 	{
//STRIP001 		case SVX_SELARROWTYPE_LEFT:
//STRIP001 			aPtArray[0] = aPos + Point( 3, 0 );
//STRIP001 			aPtArray[1] = aPos + Point( 4, 4 );
//STRIP001 			aPtArray[2] = aPos + Point( 1, 1 );
//STRIP001 			aPtArray[3] = aPos + Point( 2, 3 );
//STRIP001 			aPtArray[4] = aPos + Point( 0, 2 );
//STRIP001 			break;
//STRIP001 		case SVX_SELARROWTYPE_RIGHT:
//STRIP001 			aPtArray[0] = aPos;
//STRIP001 			aPtArray[1] = aPos + Point( 1, 4 );
//STRIP001 			aPtArray[2] = aPos + Point( 2, 1 );
//STRIP001 			aPtArray[3] = aPos + Point( 3, 3 );
//STRIP001 			aPtArray[4] = aPos + Point( 4, 2 );
//STRIP001 			break;
//STRIP001 		case SVX_SELARROWTYPE_UP:
//STRIP001 			aPtArray[0] = aPos + Point( 0, 3 );
//STRIP001 			aPtArray[1] = aPos + Point( 4, 4 );
//STRIP001 			aPtArray[2] = aPos + Point( 1, 1 );
//STRIP001 			aPtArray[3] = aPos + Point( 3, 2 );
//STRIP001 			aPtArray[4] = aPos + Point( 2, 0 );
//STRIP001 			break;
//STRIP001 		case SVX_SELARROWTYPE_DOWN:
//STRIP001 			aPtArray[0] = aPos;
//STRIP001 			aPtArray[1] = aPos + Point( 4, 1 );
//STRIP001 			aPtArray[2] = aPos + Point( 1, 2 );
//STRIP001 			aPtArray[3] = aPos + Point( 3, 3 );
//STRIP001 			aPtArray[4] = aPos + Point( 2, 4 );
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	rDev.DrawRect( Rectangle( aPtArray[0], aPtArray[1] ) );
//STRIP001 	rDev.DrawRect( Rectangle( aPtArray[2], aPtArray[3] ) );
//STRIP001 	rDev.DrawLine( aPtArray[4], aPtArray[4] );
//STRIP001 	rDev.SetLineColor( aPrevLineColor );
//STRIP001 	rDev.SetFillColor( aPrevFillColor );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 void lcl_InvertTracking(Window& rWin, const SvxFrameLine& rLine, sal_Bool bHori)
//STRIP001 {
//STRIP001     Rectangle aCompleteRect;
//STRIP001     aCompleteRect.Left() = bHori ? rLine.GetStartPos().X() : rLine.GetStartPos().X() - 2;
//STRIP001     aCompleteRect.Right() = bHori ? rLine.GetEndPos().X() : rLine.GetEndPos().X() + 2;
//STRIP001     aCompleteRect.Top() = bHori ? rLine.GetStartPos().Y() - 2 : rLine.GetStartPos().Y();
//STRIP001     aCompleteRect.Bottom() = bHori ? rLine.GetStartPos().Y() + 2 : rLine.GetEndPos().Y();
//STRIP001     rWin.InvertTracking(aCompleteRect, SHOWTRACK_SMALL | SHOWTRACK_WINDOW);
//STRIP001 }
//STRIP001 
//STRIP001 void SvxFrameSelector::Paint( const Rectangle& )
//STRIP001 {
//STRIP001     DrawBitmap( Point( 0, 0 ), pImpl->aBackBmp );
//STRIP001     if(HasFocus())
//STRIP001     {
//STRIP001         if(pImpl->aLeftLine.bIsSelected || pImpl->aRightLine.bIsSelected ||
//STRIP001             pImpl->aTopLine.bIsSelected || pImpl->aBottomLine.bIsSelected ||
//STRIP001                 pImpl->aHorLine.bIsSelected || pImpl->aVerLine.bIsSelected )
//STRIP001         {
//STRIP001             if(pImpl->aLeftLine.bIsSelected)
//STRIP001                 lcl_InvertTracking(*this, pImpl->aLeftLine, sal_False);
//STRIP001             if(pImpl->aRightLine.bIsSelected)
//STRIP001                 lcl_InvertTracking(*this, pImpl->aRightLine, sal_False);
//STRIP001             if(pImpl->aTopLine.bIsSelected)
//STRIP001                 lcl_InvertTracking(*this, pImpl->aTopLine, sal_True);
//STRIP001             if(pImpl->aBottomLine.bIsSelected)
//STRIP001                 lcl_InvertTracking(*this, pImpl->aBottomLine, sal_True);
//STRIP001             if(pImpl->aHorLine.bIsSelected)
//STRIP001                 lcl_InvertTracking(*this, pImpl->aHorLine, sal_True);
//STRIP001             if(pImpl->aVerLine.bIsSelected)
//STRIP001                 lcl_InvertTracking(*this, pImpl->aVerLine, sal_False);
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             Size aSize = GetSizePixel();
//STRIP001             aSize.Width() -= 3;
//STRIP001             aSize.Height() -= 3;
//STRIP001             Rectangle aCompleteRect(Point(0, 0), aSize);
//STRIP001             InvertTracking(aCompleteRect, SHOWTRACK_SMALL | SHOWTRACK_WINDOW);
//STRIP001         }
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFrameSelector::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	if ( rMEvt.IsLeft() && ( rMEvt.GetClicks() == 1 ) )
//STRIP001 	{
//STRIP001 		CaptureMouse();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFrameSelector::MouseButtonUp( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	/* Verhalten bei Mausclicks:
//STRIP001 	 * -------------------------
//STRIP001 	 * o nur Einfachclicks
//STRIP001 	 * o Shift-Einfachclick -> Mehrfachselektion
//STRIP001 	 * o einzelne Linien:
//STRIP001 	 *   - ist die Linie bereits selektiert -> an/aus-Toggle
//STRIP001 	 *   - sonst -> an
//STRIP001 	 * o Kreuzungspunkt vertikal/horizontal (Mitte)
//STRIP001 	 *   - ist eine oder keine Linie selektiert -> an
//STRIP001 	 *   - sonst -> an/aus-Toggle beide
//STRIP001 	 * o Click auf die gleiche Linie -> Toggle SHOW/HIDE/DONT_CARE
//STRIP001 	 */
//STRIP001 
//STRIP001 	BOOL bWasSelected = IsAnyLineSelected_Impl();
//STRIP001 	GrabFocus();
//STRIP001 	if ( !bWasSelected )
//STRIP001 		pImpl->aTopLine.bIsSelected = FALSE;
//STRIP001 
//STRIP001 	
//STRIP001 	if ( rMEvt.IsLeft() )
//STRIP001 	{
//STRIP001 		Point aBtnUpPos( rMEvt.GetPosPixel() );
//STRIP001 
//STRIP001         if ( !bIsClicked && !pImpl->bIsDontCare )
//STRIP001 		{
//STRIP001 			bIsClicked = TRUE;
//STRIP001 
//STRIP001 			// wenn Linien auf DontCare sind, muessen diese auf HIDE
//STRIP001 			// gesetzt werden (ausser der aktuellen Linie)
//STRIP001 			typedef ::std::pair<SvxFrameLine*,Rectangle*> TOuterPair;
//STRIP001 			TOuterPair eTypes[] =	{ 
//STRIP001 										TOuterPair(&pImpl->aLeftLine,&pImpl->aSpotLeft),
//STRIP001 										TOuterPair(&pImpl->aRightLine,&pImpl->aSpotRight),
//STRIP001 										TOuterPair(&pImpl->aTopLine,&pImpl->aSpotTop),
//STRIP001 										TOuterPair(&pImpl->aBottomLine,&pImpl->aSpotBottom),
//STRIP001 										TOuterPair(&pImpl->aVerLine,&pImpl->aSpotVer),
//STRIP001 										TOuterPair(&pImpl->aHorLine,&pImpl->aSpotHor)
//STRIP001 									};
//STRIP001 
//STRIP001 			for (sal_Int32 i=0; i < sizeof(eTypes)/sizeof(TOuterPair); ++i)
//STRIP001 			{
//STRIP001 
//STRIP001 				if ( eTypes[i].first->aState == SVX_FRMLINESTATE_DONT_CARE &&
//STRIP001 					 !eTypes[i].second->IsInside( aBtnUpPos ) )
//STRIP001 				{
//STRIP001 					eTypes[i].first->SetStyle( SvxFrameLine::NO_LINE );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001         if ( pImpl->aSpotLeft.IsInside( aBtnUpPos ) )
//STRIP001 		{
//STRIP001             LineClicked_Impl( pImpl->aLeftLine, rMEvt.IsShift(),
//STRIP001 						 ( rMEvt.GetClicks() != 1 ) );
//STRIP001 			SelectLine( SVX_FRMSELLINE_LEFT );
//STRIP001 		}
//STRIP001         else if ( pImpl->aSpotRight.IsInside( aBtnUpPos ) )
//STRIP001 		{
//STRIP001             LineClicked_Impl( pImpl->aRightLine, rMEvt.IsShift(),
//STRIP001 						 ( rMEvt.GetClicks() != 1 ) );
//STRIP001 			SelectLine( SVX_FRMSELLINE_RIGHT );
//STRIP001 		}
//STRIP001         else if ( pImpl->aSpotTop.IsInside( aBtnUpPos ) )
//STRIP001 		{
//STRIP001             LineClicked_Impl( pImpl->aTopLine, rMEvt.IsShift(),
//STRIP001 						 ( rMEvt.GetClicks() != 1 ) );
//STRIP001 			SelectLine( SVX_FRMSELLINE_TOP );
//STRIP001 		}
//STRIP001         else if ( pImpl->aSpotBottom.IsInside( aBtnUpPos ) )
//STRIP001 		{
//STRIP001             LineClicked_Impl( pImpl->aBottomLine, rMEvt.IsShift(),
//STRIP001 						 ( rMEvt.GetClicks() != 1 ) );
//STRIP001 			SelectLine( SVX_FRMSELLINE_BOTTOM );
//STRIP001 		}
//STRIP001         else if ( pImpl->aSpotVer.IsInside( aBtnUpPos ) &&
//STRIP001                   pImpl->aSpotHor.IsInside( aBtnUpPos ) )
//STRIP001 		{
//STRIP001             if ( !pImpl->aHorLine.bIsSelected || !pImpl->aVerLine.bIsSelected )
//STRIP001 			{
//STRIP001                 pImpl->aVerLine.aColor   =
//STRIP001                 pImpl->aHorLine.aColor   = pImpl->aCurLineCol;
//STRIP001                 pImpl->aVerLine.SetStyle( pImpl->aCurLineStyle );
//STRIP001                 pImpl->aHorLine.SetStyle( pImpl->aCurLineStyle );
//STRIP001 
//STRIP001 				if ( !rMEvt.IsShift() )
//STRIP001 					SelectLine( SVX_FRMSELLINE_NONE );
//STRIP001 
//STRIP001 				SelectLine( SVX_FRMSELLINE_VER );
//STRIP001 				SelectLine( SVX_FRMSELLINE_HOR );
//STRIP001 			}
//STRIP001             else if ( pImpl->aHorLine.bIsSelected && pImpl->aVerLine.bIsSelected )
//STRIP001 			{
//STRIP001 				if ( !rMEvt.IsShift() )
//STRIP001 					SelectLine( SVX_FRMSELLINE_NONE );
//STRIP001 				SelectLine( SVX_FRMSELLINE_VER );
//STRIP001 				SelectLine( SVX_FRMSELLINE_HOR );
//STRIP001                 LineClicked_Impl( pImpl->aVerLine, TRUE, ( rMEvt.GetClicks() != 1 ) );
//STRIP001                 LineClicked_Impl( pImpl->aHorLine, TRUE, ( rMEvt.GetClicks() != 1 ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001         else if ( pImpl->aSpotVer.IsInside( aBtnUpPos ) )
//STRIP001 		{
//STRIP001             LineClicked_Impl( pImpl->aVerLine, rMEvt.IsShift(),
//STRIP001 						 ( rMEvt.GetClicks() != 1 ) );
//STRIP001 			SelectLine( SVX_FRMSELLINE_VER );
//STRIP001 		}
//STRIP001         else if ( pImpl->aSpotHor.IsInside( aBtnUpPos ) )
//STRIP001 		{
//STRIP001             LineClicked_Impl( pImpl->aHorLine, rMEvt.IsShift(),
//STRIP001 						 ( rMEvt.GetClicks() != 1 ) );
//STRIP001 			SelectLine( SVX_FRMSELLINE_HOR );
//STRIP001 		}
//STRIP001 		ShowLines();
//STRIP001 		ReleaseMouse();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFrameSelector::LineClicked_Impl( SvxFrameLine& aLine,
//STRIP001 								 BOOL bShiftPressed,
//STRIP001 								 BOOL bDoubleClick )
//STRIP001 {
//STRIP001 	if ( aLine.bIsSelected )
//STRIP001 	{
//STRIP001         int nMod = pImpl->bIsDontCare ? 3 : 2;
//STRIP001         aLine.aState = SvxFrameLineState(
//STRIP001             ( ( (int)aLine.aState ) + ( ( !bDoubleClick ) ? 1 : 2 ) ) % nMod );
//STRIP001 
//STRIP001         switch ( aLine.aState )
//STRIP001 		{
//STRIP001 			case SVX_FRMLINESTATE_SHOW:
//STRIP001                 aLine.SetStyle( pImpl->aCurLineStyle );
//STRIP001                 aLine.aColor = pImpl->aCurLineCol;
//STRIP001 				break;
//STRIP001 			case SVX_FRMLINESTATE_HIDE:
//STRIP001 				aLine.SetStyle( SvxFrameLine::NO_LINE );
//STRIP001 				break;
//STRIP001 			case SVX_FRMLINESTATE_DONT_CARE:
//STRIP001                 aLine.aStyle = SvxFrameLine::THICK_LINE;
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001         aLine.aState = SVX_FRMLINESTATE_SHOW;
//STRIP001         aLine.aColor    = pImpl->aCurLineCol;
//STRIP001         aLine.SetStyle( pImpl->aCurLineStyle );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !bShiftPressed )
//STRIP001 		SelectLine( SVX_FRMSELLINE_NONE );
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 BOOL SvxFrameSelector::IsAnyLineSelected_Impl() const
//STRIP001 {
//STRIP001     return ( pImpl->aLeftLine.bIsSelected ||
//STRIP001         pImpl->aRightLine.bIsSelected ||
//STRIP001         pImpl->aTopLine.bIsSelected ||
//STRIP001         pImpl->aBottomLine.bIsSelected ||
//STRIP001         pImpl->aHorLine.bIsSelected ||
//STRIP001         pImpl->aVerLine.bIsSelected );
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 SvxFrameSelectorLine SvxFrameSelector::GetFirstSelLineForKey_Impl()const
//STRIP001 {
//STRIP001     SvxFrameSelectorLine eRet = SVX_FRMSELLINE_NONE;
//STRIP001     if( pImpl->aTopLine.bIsSelected )
//STRIP001         eRet = SVX_FRMSELLINE_TOP;
//STRIP001     else if( pImpl->aLeftLine.bIsSelected )
//STRIP001         eRet = SVX_FRMSELLINE_LEFT;
//STRIP001     else if( SVX_FRMSELTYPE_TABLE == pImpl->eSel)
//STRIP001     {
//STRIP001         if( pImpl->aVerLine.bIsSelected )
//STRIP001             eRet = SVX_FRMSELLINE_VER;
//STRIP001         else if( pImpl->aHorLine.bIsSelected )
//STRIP001             eRet = SVX_FRMSELLINE_HOR;
//STRIP001     }
//STRIP001     if( SVX_FRMSELLINE_NONE == eRet )
//STRIP001     {
//STRIP001         if(pImpl->aRightLine.bIsSelected )
//STRIP001             eRet = SVX_FRMSELLINE_RIGHT;
//STRIP001         else if( pImpl->aBottomLine.bIsSelected )
//STRIP001             eRet = SVX_FRMSELLINE_BOTTOM;
//STRIP001     }
//STRIP001     return eRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL	SvxFrameSelector::IsAnyLineSet() const
//STRIP001 {
//STRIP001     if( pImpl->aLeftLine.aState    == SVX_FRMLINESTATE_SHOW ||
//STRIP001         pImpl->aRightLine.aState   == SVX_FRMLINESTATE_SHOW ||
//STRIP001         pImpl->aTopLine.aState     == SVX_FRMLINESTATE_SHOW ||
//STRIP001         pImpl->aBottomLine.aState  == SVX_FRMLINESTATE_SHOW ||
//STRIP001         pImpl->aHorLine.aState     == SVX_FRMLINESTATE_SHOW ||
//STRIP001         pImpl->aVerLine.aState     == SVX_FRMLINESTATE_SHOW )
//STRIP001 		return TRUE;
//STRIP001 	else
//STRIP001 		return FALSE;
//STRIP001 }
//STRIP001 /* -----------------------------25.01.2002 10:25------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxFrameSelector::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	Window::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if( ( rDCEvt.GetType() == DATACHANGED_SETTINGS ) && ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001 	{
//STRIP001 		pImpl->SetHC( this );
//STRIP001 		InitBitmap_Impl();
//STRIP001 		ShowLines();
//STRIP001 	}
//STRIP001 }
//STRIP001 /* -----------------------------20.03.2002 14:31------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 SvxFrameSelectorLine lcl_GetNextStep(
//STRIP001     const SvxFrameSelectorLine eCurLine, USHORT nKeyCode, BOOL bIsTable)
//STRIP001 {
//STRIP001     //the first entry in the array contains the last reachable line
//STRIP001     //if the current line is found at the beginning of the
//STRIP001     static const SvxFrameSelectorLine aLeftArr[]  =
//STRIP001         {SVX_FRMSELLINE_LEFT, SVX_FRMSELLINE_VER, SVX_FRMSELLINE_BOTTOM,
//STRIP001         SVX_FRMSELLINE_HOR, SVX_FRMSELLINE_TOP, SVX_FRMSELLINE_RIGHT};
//STRIP001     static const SvxFrameSelectorLine aRightArr[]  =
//STRIP001         {SVX_FRMSELLINE_RIGHT, SVX_FRMSELLINE_TOP, SVX_FRMSELLINE_HOR,
//STRIP001         SVX_FRMSELLINE_BOTTOM, SVX_FRMSELLINE_VER, SVX_FRMSELLINE_LEFT};
//STRIP001     static const SvxFrameSelectorLine aUpArr[]  =
//STRIP001         {SVX_FRMSELLINE_TOP, SVX_FRMSELLINE_VER, SVX_FRMSELLINE_RIGHT,
//STRIP001         SVX_FRMSELLINE_HOR, SVX_FRMSELLINE_LEFT, SVX_FRMSELLINE_BOTTOM};
//STRIP001     static const SvxFrameSelectorLine aDownArr[]  =
//STRIP001         {SVX_FRMSELLINE_BOTTOM, SVX_FRMSELLINE_LEFT, SVX_FRMSELLINE_HOR,
//STRIP001         SVX_FRMSELLINE_RIGHT, SVX_FRMSELLINE_VER, SVX_FRMSELLINE_TOP};
//STRIP001     const SvxFrameSelectorLine* pMoveArray = 0;
//STRIP001     BOOL bHLines = TRUE;
//STRIP001     switch(nKeyCode)
//STRIP001     {
//STRIP001         case KEY_UP : pMoveArray = aUpArr;break;
//STRIP001         case KEY_DOWN :pMoveArray = aDownArr;break;
//STRIP001         case KEY_LEFT :pMoveArray = aLeftArr; bHLines = FALSE;   break;
//STRIP001         case KEY_RIGHT :pMoveArray = aRightArr; bHLines = FALSE; break;
//STRIP001     }
//STRIP001     SvxFrameSelectorLine eRetLine = eCurLine;
//STRIP001     if(pMoveArray)
//STRIP001     {
//STRIP001         for(USHORT i = 0; i < SVX_FRMSELLINE_VER; i++)
//STRIP001         {
//STRIP001             if(eCurLine == pMoveArray[i])
//STRIP001             {
//STRIP001                 if(i)
//STRIP001                 {
//STRIP001                     eRetLine = pMoveArray[--i];
//STRIP001                     //make sure that no non-existing lines can be reached
//STRIP001                     //and vertical travel selects horizontal lines and vice versa
//STRIP001                     while((!bIsTable &&
//STRIP001                         (SVX_FRMSELLINE_VER == eRetLine || SVX_FRMSELLINE_HOR == eRetLine))||
//STRIP001                         (bHLines && (SVX_FRMSELLINE_VER  == eRetLine||  SVX_FRMSELLINE_LEFT == eRetLine || SVX_FRMSELLINE_RIGHT == eRetLine))||
//STRIP001                         (!bHLines && (SVX_FRMSELLINE_TOP  == eRetLine||  SVX_FRMSELLINE_BOTTOM == eRetLine || SVX_FRMSELLINE_HOR == eRetLine)))
//STRIP001                         eRetLine = pMoveArray[--i];
//STRIP001                 }
//STRIP001                 break;
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001    return eRetLine;
//STRIP001 }
//STRIP001 /* -----------------------------17.07.2002 15:33-by LLA-----------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxFrameSelector::ToggleOneLine(SvxFrameLine &aCurLine)
//STRIP001 {
//STRIP001 	// PRE: an initialised SvxFrameLine as reference, we will change it!
//STRIP001 
//STRIP001 	if (aCurLine.GetState() == SVX_FRMLINESTATE_HIDE)
//STRIP001 	{
//STRIP001 		aCurLine.SetState(SVX_FRMLINESTATE_SHOW);
//STRIP001 		//	aCurLine.aStyle = SvxFrameLine::THIN_LINE;
//STRIP001 		aCurLine.SetStyle( pImpl->aCurLineStyle );
//STRIP001         aCurLine.aColor = pImpl->aCurLineCol;
//STRIP001 	}
//STRIP001 	else if (aCurLine.GetState() == SVX_FRMLINESTATE_SHOW)
//STRIP001 	{
//STRIP001 		aCurLine.SetState(SVX_FRMLINESTATE_HIDE);
//STRIP001 		aCurLine.SetStyle( SvxFrameLine::NO_LINE );
//STRIP001 	}
//STRIP001 	// No need to handle SVX_FRMLINESTATE_DONT_CARE
//STRIP001 	// else 
//STRIP001 	// {
//STRIP001 	// }
//STRIP001 }
//STRIP001 
//STRIP001 void SvxFrameSelector::ToggleAllSelectedLines()
//STRIP001 {
//STRIP001     
//STRIP001     if( pImpl->aTopLine.bIsSelected )    ToggleOneLine(pImpl->aTopLine); 
//STRIP001     if( pImpl->aLeftLine.bIsSelected )	 ToggleOneLine(pImpl->aLeftLine); 
//STRIP001 	if( pImpl->aRightLine.bIsSelected )	 ToggleOneLine(pImpl->aRightLine);
//STRIP001 	if( pImpl->aBottomLine.bIsSelected ) ToggleOneLine(pImpl->aBottomLine);    
//STRIP001 
//STRIP001 	// LLA: special extended?
//STRIP001     if( SVX_FRMSELTYPE_TABLE == pImpl->eSel)
//STRIP001     {
//STRIP001         if( pImpl->aVerLine.bIsSelected ) ToggleOneLine(pImpl->aVerLine);
//STRIP001 		if( pImpl->aHorLine.bIsSelected ) ToggleOneLine(pImpl->aHorLine);
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------------------01.02.2002 13:50------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxFrameSelector::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001     sal_Bool bHandled = sal_False;
//STRIP001     KeyCode aKeyCode = rKEvt.GetKeyCode();
//STRIP001     if ( !aKeyCode.GetModifier())
//STRIP001     {
//STRIP001         USHORT nCode = aKeyCode.GetCode();
//STRIP001         switch(nCode)
//STRIP001         {
//STRIP001             case KEY_SPACE:
//STRIP001                 //toggle current line type
//STRIP001                 // LineClicked_Impl(GetLine(eCurLine), FALSE, FALSE);
//STRIP001                 // SelectLine(eCurLine, TRUE);
//STRIP001 				ToggleAllSelectedLines();
//STRIP001                 ShowLines();
//STRIP001                 bHandled = sal_True;
//STRIP001             break;
//STRIP001             case KEY_UP :
//STRIP001             case KEY_DOWN :
//STRIP001             case KEY_LEFT :
//STRIP001             case KEY_RIGHT :
//STRIP001             {
//STRIP001 		        SvxFrameSelectorLine eCurLine = GetFirstSelLineForKey_Impl();
//STRIP001 
//STRIP001                 BOOL bIsTable = SVX_FRMSELTYPE_TABLE == pImpl->eSel;
//STRIP001                 SvxFrameSelectorLine eFoundLine = lcl_GetNextStep(eCurLine, nCode, bIsTable);
//STRIP001                 if(eFoundLine != eCurLine)
//STRIP001                 {
//STRIP001                     SelectLine( SVX_FRMSELLINE_NONE );
//STRIP001 					SelectLine(eFoundLine, TRUE);
//STRIP001                 }
//STRIP001             }
//STRIP001             break;
//STRIP001         }
//STRIP001     }
//STRIP001     if(!bHandled)
//STRIP001         Window::KeyInput(rKEvt);
//STRIP001 }
//STRIP001 /* -----------------------------01.02.2002 15:34------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxFrameSelector::GetFocus()
//STRIP001 {
//STRIP001     if(!IsAnyLineSelected_Impl())
//STRIP001         SelectLine( SVX_FRMSELLINE_TOP, true ); 
//STRIP001     Invalidate();
//STRIP001     if(pImpl->xAccess.is())
//STRIP001         pImpl->pAccess->NotifyFocusListeners(sal_True);
//STRIP001     Control::GetFocus();
//STRIP001 }
//STRIP001 /* -----------------------------01.02.2002 15:34------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxFrameSelector::LoseFocus()
//STRIP001 {
//STRIP001     Invalidate();
//STRIP001     if(pImpl->xAccess.is())
//STRIP001         pImpl->pAccess->NotifyFocusListeners(sal_True);
//STRIP001     Control::LoseFocus();
//STRIP001 }
//STRIP001 /* -----------------------------01.02.2002 16:54------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 SvxFrameLine&       SvxFrameSelector::GetLine(SvxFrameSelectorLine eWhich)
//STRIP001 {
//STRIP001     SvxFrameLine* pRet = 0;
//STRIP001     switch(eWhich)
//STRIP001     {
//STRIP001         case SVX_FRMSELLINE_TOP:        pRet = &pImpl->aTopLine;    break;
//STRIP001         case SVX_FRMSELLINE_BOTTOM:     pRet = &pImpl->aBottomLine; break;
//STRIP001         case SVX_FRMSELLINE_LEFT:       pRet = &pImpl->aLeftLine;   break;
//STRIP001         case SVX_FRMSELLINE_RIGHT:      pRet = &pImpl->aRightLine;  break;
//STRIP001         case SVX_FRMSELLINE_HOR:        pRet = &pImpl->aHorLine;    break;
//STRIP001         case SVX_FRMSELLINE_NONE:
//STRIP001                 DBG_ERROR("wrong line selected!")
//STRIP001         case SVX_FRMSELLINE_VER:        pRet = &pImpl->aVerLine;    break;
//STRIP001     }
//STRIP001     return *pRet;
//STRIP001 }
//STRIP001 /* -----------------------------04.02.2002 14:14------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 uno::Reference< XAccessible > SvxFrameSelector::CreateAccessible()
//STRIP001 {
//STRIP001     if(!pImpl->xAccess.is())
//STRIP001         pImpl->xAccess = pImpl->pAccess =
//STRIP001             new SvxFrameSelectorAccessible_Impl(*this, SVX_FRMSELLINE_NONE);
//STRIP001     return pImpl->xAccess;
//STRIP001 }
//STRIP001 /* -----------------------------05.02.2002 15:46------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 SvxFrameSelector_Impl::SvxFrameSelector_Impl( const SvxFrameSelector* pThis ) :
//STRIP001         eSel            ( SVX_FRMSELTYPE_PARAGRAPH ),
//STRIP001         aCurLineStyle ( SvxFrameLine::NO_LINE ),
//STRIP001         aCurLineCol   ( COL_BLACK ),
//STRIP001         pAccess(0),
//STRIP001         bIsDontCare     ( sal_False )
//STRIP001 {
//STRIP001     for(sal_Int16 i = 0; i < 6; i++)
//STRIP001         pChildren[i] = 0;
//STRIP001 
//STRIP001 	SetHC( pThis );
//STRIP001 }
//STRIP001 /* -----------------------------05.02.2002 15:47------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 SvxFrameSelector_Impl::~SvxFrameSelector_Impl()
//STRIP001 {
//STRIP001     if(pAccess)
//STRIP001         pAccess->Invalidate();
//STRIP001     for(sal_Int16 i = 0; i < 6; i++)
//STRIP001         if(pChildren[i])
//STRIP001             pChildren[i]->Invalidate();
//STRIP001 }
//STRIP001 /* -----------------------------05.02.2002 15:47------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 uno::Reference< XAccessible >
//STRIP001     SvxFrameSelector_Impl::GetChildAccessible(
//STRIP001         SvxFrameSelector& rFrmSel, SvxFrameSelectorLine eWhich)
//STRIP001 {
//STRIP001     DBG_ASSERT(eWhich >= SVX_FRMSELLINE_LEFT && eWhich <= SVX_FRMSELLINE_VER, "wrong line type")
//STRIP001     if(!pChildren[eWhich -1])
//STRIP001         xChildren[eWhich -1] = pChildren[eWhich -1] =
//STRIP001             new SvxFrameSelectorAccessible_Impl(rFrmSel, eWhich);
//STRIP001     return pChildren[eWhich -1];
//STRIP001 }
//STRIP001 /* -----------------------------13.02.2002 13:28------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 const Rectangle& SvxFrameSelector_Impl::GetLineSpot(SvxFrameSelectorLine eWhich) const
//STRIP001 {
//STRIP001     const Rectangle* pRet = 0;
//STRIP001     switch(eWhich)
//STRIP001     {
//STRIP001         case SVX_FRMSELLINE_LEFT    : pRet = &aSpotLeft;      break;
//STRIP001         case SVX_FRMSELLINE_RIGHT   : pRet = &aSpotRight;     break;
//STRIP001         case SVX_FRMSELLINE_TOP     : pRet = &aSpotTop;       break;
//STRIP001         case SVX_FRMSELLINE_BOTTOM  : pRet = &aSpotBottom;    break;
//STRIP001         case SVX_FRMSELLINE_HOR     : pRet = &aSpotHor;       break;
//STRIP001         case SVX_FRMSELLINE_VER     : pRet = &aSpotVer;       break;
//STRIP001     };
//STRIP001     return *pRet;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void SvxFrameSelector_Impl::SetHC( const SvxFrameSelector* pCntrl )
//STRIP001 {
//STRIP001 	if( pCntrl && pCntrl->GetDisplayBackgroundColor().IsDark() )
//STRIP001 	{
//STRIP001 		bHC = TRUE;
//STRIP001 		aPaintLineCol = pCntrl->GetSettings().GetStyleSettings().GetLabelTextColor();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		bHC = FALSE;
//STRIP001 }
}
