/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_ctrdial.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:39:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <math.h>
#pragma hdrstop

#include "ctrdial.hxx"

#ifndef _SV_BITMAP_HXX
#include <vcl/bitmap.hxx>
#endif
//#ifndef _SV_SYSTEM_HXX
//#include <vcl/system.hxx>
//#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
#include <svtools/colorcfg.hxx>
#endif
namespace binfilter {

// static functions

//STRIP001 inline static Color GetBackgroundColor( const StyleSettings& rStyleSettings )
//STRIP001 {
//STRIP001 	return rStyleSettings.GetDialogColor();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 inline static Color GetTextColor( const StyleSettings& rStyleSettings )
//STRIP001 {
//STRIP001 	svtools::ColorConfig aColorConfig;
//STRIP001 	Color aWindowTextColor( aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor );
//STRIP001 	return aWindowTextColor;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 inline static Color GetButtonTextColor( const StyleSettings& rStyleSettings )
//STRIP001 {
//STRIP001 	return rStyleSettings.GetButtonTextColor();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 inline static Color GetHighlightColor( const StyleSettings& rStyleSettings )
//STRIP001 {
//STRIP001 	return rStyleSettings.GetHighlightColor();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 inline static Color GetNonHighlightColor( const StyleSettings& rStyleSettings )
//STRIP001 {
//STRIP001 	return rStyleSettings.GetMenuColor();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 inline static Color GetDisabledColor( const StyleSettings& rStyleSettings )
//STRIP001 {
//STRIP001 	return rStyleSettings.GetDisableColor();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 inline static void GetColors( const StyleSettings& rStyleSettings, Color& rBackGround, Color& rText )
//STRIP001 {
//STRIP001 	rBackGround = ::GetBackgroundColor( rStyleSettings );
//STRIP001 	rText = ::GetTextColor( rStyleSettings );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 inline void SvxCtrDialBmp::GetColors( Color& rBackGround, Color& rText ) const
//STRIP001 {
//STRIP001     ::GetColors( GetStyleSettings(), rBackGround, rText );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 inline Color SvxCtrDialBmp::GetBackgroundColor( void ) const
//STRIP001 {
//STRIP001     return ::GetBackgroundColor( GetStyleSettings() );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 inline Color SvxCtrDialBmp::GetTextColor( void ) const
//STRIP001 {
//STRIP001     return ::GetTextColor( GetStyleSettings() );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 inline Color SvxCtrDialBmp::GetButtonTextColor( void ) const
//STRIP001 {
//STRIP001     return ::GetButtonTextColor( GetStyleSettings() );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 inline Color SvxCtrDialBmp::GetHighlightColor( void ) const
//STRIP001 {
//STRIP001     return ::GetHighlightColor( GetStyleSettings() );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 inline Color SvxCtrDialBmp::GetNonHighlightColor( void ) const
//STRIP001 {
//STRIP001     return ::GetNonHighlightColor( GetStyleSettings() );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 inline Color SvxCtrDialBmp::GetDisabledColor( void ) const
//STRIP001 {
//STRIP001     return ::GetDisabledColor( GetStyleSettings() );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void SvxCtrDialBmp::DrawBackground( BOOL bEnabled )
//STRIP001 {
//STRIP001     SetLineColor();
//STRIP001     SetFillColor( GetBackgroundColor() );
//STRIP001     DrawRect( aDrawRect );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxCtrDialBmp::DrawShadow( BOOL bEnabled )
//STRIP001 {
//STRIP001     EnableRTL( true ); // #107807# draw 3D effect in correct direction
//STRIP001 
//STRIP001     SetLineColor();
//STRIP001 
//STRIP001     BYTE nDiff = bEnabled ? 0x18 : 0x10;
//STRIP001     Color aColor( GetBackgroundColor() );
//STRIP001     aColor.DecreaseLuminance( nDiff );
//STRIP001     SetFillColor( aColor );
//STRIP001     DrawPie( aDrawRect, aDrawRect.BottomCenter(), aDrawRect.TopRight() );
//STRIP001 
//STRIP001     aColor.DecreaseLuminance( nDiff );
//STRIP001     SetFillColor( aColor );
//STRIP001     DrawPie( aDrawRect, aDrawRect.BottomRight(), aDrawRect.RightCenter() );
//STRIP001 
//STRIP001     aColor = GetBackgroundColor();
//STRIP001     aColor.IncreaseLuminance( nDiff );
//STRIP001     SetFillColor( aColor );
//STRIP001     DrawPie( aDrawRect, aDrawRect.TopCenter(), aDrawRect.BottomLeft() );
//STRIP001 
//STRIP001     aColor.IncreaseLuminance( nDiff );
//STRIP001     SetFillColor( aColor );
//STRIP001     DrawPie( aDrawRect, aDrawRect.TopLeft(), aDrawRect.LeftCenter() );
//STRIP001 
//STRIP001     EnableRTL( false );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxCtrDialBmp::DrawCalibration( BOOL bEnabled )
//STRIP001 {
//STRIP001     Point	aStartPos( nCenterX, nCenterY );
//STRIP001     Point	aPos;
//STRIP001     BYTE	nDiff = bEnabled ? 0x18 : 0x10;
//STRIP001     double	fAlpha;
//STRIP001     short	nX, nY;
//STRIP001 
//STRIP001 	Color	aFullColor( bEnabled? GetTextColor() : GetDisabledColor() );
//STRIP001 	Color	aLightColor( aFullColor );
//STRIP001 	if( aFullColor.GetLuminance() < GetBackgroundColor().GetLuminance() )
//STRIP001 		// lines darker than background -> make lighter
//STRIP001 		aLightColor.IncreaseLuminance( nDiff );
//STRIP001 	else
//STRIP001 		aLightColor.DecreaseLuminance( nDiff );
//STRIP001 
//STRIP001     for( short nAng = 0; nAng < 360; nAng += 15 )
//STRIP001 	{
//STRIP001         if( nAng % 45 )
//STRIP001 			SetLineColor( aLightColor );
//STRIP001         else
//STRIP001 			SetLineColor( aFullColor );
//STRIP001 
//STRIP001         fAlpha = nAng * F_PI180;
//STRIP001         nX = (short)( -nCenterX * cos( fAlpha ) );
//STRIP001         nY = (short)( nCenterY * sin( fAlpha ) );
//STRIP001         if( nY > 0 ) nY++;
//STRIP001         aPos = Point( nCenterX - nX, nCenterY - nY );
//STRIP001         DrawLine( aStartPos, aPos );
//STRIP001 	}
//STRIP001 
//STRIP001     Rectangle a4Rect( aDrawRect.Left() + 8, aDrawRect.Top() + 8,
//STRIP001                       aDrawRect.Right() - 8, aDrawRect.Bottom() - 8);
//STRIP001     SetLineColor();
//STRIP001     SetFillColor( GetBackgroundColor() );
//STRIP001     DrawEllipse( a4Rect );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxCtrDialBmp::InitBitmap( const Size& rSize )
//STRIP001 {
//STRIP001     aDrawRect.SetPos( Point() );
//STRIP001     aDrawRect.SetSize( rSize );
//STRIP001     nCenterX = rSize.Width() / 2;
//STRIP001     nCenterY = rSize.Height() / 2;
//STRIP001     SetOutputSize( rSize );
//STRIP001     SetBackground();
//STRIP001     SetFillColor( GetBackgroundColor() );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxCtrDialBmp::InitBitmap( const Size& rSize, const Font& rFont )
//STRIP001 {
//STRIP001     InitBitmap( rSize );
//STRIP001     SetFont( rFont );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxCtrDialBmp::DrawBackgrBitmap( const Size& rSize, BOOL bEnabled )
//STRIP001 {
//STRIP001     InitBitmap( rSize );
//STRIP001     DrawBackground( bEnabled );
//STRIP001     DrawShadow( bEnabled );
//STRIP001     DrawCalibration( bEnabled );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxCtrDialBmp::DrawBackgrBitmap( const SvxCtrDialBmp& rSrc )
//STRIP001 {
//STRIP001     DrawBitmap( Point(), rSrc.GetBitmap( Point(), aDrawRect.GetSize() ) );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxCtrDialBmp::DrawElements( const String& rText, short nDelta, BOOL bEnabled )
//STRIP001 {
//STRIP001     Font	aFont = GetFont();
//STRIP001 	const BOOL	bMain = ( nDelta % 450 ) != 0;
//STRIP001 	Color		aTextColor( bEnabled? GetTextColor() : GetDisabledColor() );
//STRIP001 	Color		aBtnTextColor( bEnabled? GetButtonTextColor() : GetDisabledColor() );
//STRIP001 
//STRIP001 	aFont.SetColor( aBtnTextColor );
//STRIP001     aFont.SetOrientation( nDelta );
//STRIP001 	aFont.SetWeight( WEIGHT_BOLD );
//STRIP001     SetFont( aFont );
//STRIP001 
//STRIP001     double		fAlpha = nDelta * F_PI1800;
//STRIP001     double		fWidth = GetTextWidth( rText ) / 2;
//STRIP001     double		fHeight = GetTextHeight() / 2;
//STRIP001     Point		aPos(	(short)(nCenterX - fWidth * cos( fAlpha ) - fHeight * sin( fAlpha )),
//STRIP001 						(short)(nCenterY + fWidth * sin( fAlpha ) - fHeight * cos( fAlpha )) );
//STRIP001 
//STRIP001     DrawText( aPos, rText );
//STRIP001 
//STRIP001     short		nX = (short)((4 - nCenterX) * cos( fAlpha ));
//STRIP001     short		nY = (short)((nCenterY - 4) * sin( fAlpha ));
//STRIP001     aPos.X() = nCenterX - nX;
//STRIP001     aPos.Y() = nCenterY - nY;
//STRIP001     short		nSize = bMain? 2 : 3;
//STRIP001 
//STRIP001     SetLineColor( aTextColor );
//STRIP001     SetFillColor( Color( bEnabled ? (bMain? GetNonHighlightColor() : GetHighlightColor() ) : GetDisabledColor() ) );
//STRIP001 	DrawEllipse( Rectangle( aPos.X() - nSize, aPos.Y() - nSize, aPos.X() + nSize, aPos.Y() + nSize ) );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 inline void SvxCtrDial::GetColors( Color& rBackGround, Color& rText ) const
//STRIP001 {
//STRIP001 	::GetColors( GetSettings().GetStyleSettings(), rBackGround, rText );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Member:		SvxCtrDial										Datum:08.09.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxCtrDial
//STRIP001 #*
//STRIP001 #*  Funktion:	Konstruktor der Klasse SvxCtrDial
//STRIP001 #*
//STRIP001 #*  Input:		---
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 SvxCtrDial::SvxCtrDial( Window* pParent, Size aSize, WinBits nWinStyle) :
//STRIP001 	Control( pParent, nWinStyle ),
//STRIP001     aEnabledBmp( *this ),
//STRIP001     aDisabledBmp( *this ),
//STRIP001     aBufferBmp( *this )
//STRIP001 {
//STRIP001 	DBG_ASSERT( pParent, "-SvxCtrDial::SvxCtrDial(): no parent, no cookies!" );
//STRIP001 
//STRIP001 	aWinSize = aSize;
//STRIP001 	aRotFont = pParent->GetFont();
//STRIP001     Init();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Member:		SvxCtrDial									Datum:08.09.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxCtrDial
//STRIP001 #*
//STRIP001 #*  Funktion:	Konstruktor der Klasse SvxCtrDial
//STRIP001 #*
//STRIP001 #*  Input:		---
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 SvxCtrDial::SvxCtrDial( Window* pParent,Size aSize, Font aFont, WinBits nWinStyle) :
//STRIP001 	Control( pParent, nWinStyle ),
//STRIP001     aEnabledBmp( *this ),
//STRIP001     aDisabledBmp( *this ),
//STRIP001     aBufferBmp( *this )
//STRIP001 {
//STRIP001 	DBG_ASSERT( pParent, "-SvxCtrDial::SvxCtrDial(): no parent, no cookies!" );
//STRIP001 
//STRIP001 	aWinSize = aSize;
//STRIP001 	aRotFont = aFont;
//STRIP001 	Init();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Member:		SvxCtrDial									Datum:08.09.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		MD_Test
//STRIP001 #*
//STRIP001 #*  Funktion:	Konstruktor der Klasse SvxCtrDial
//STRIP001 #*
//STRIP001 #*  Input:		---
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 SvxCtrDial::SvxCtrDial( Window* pParent, const ResId& rResId) :
//STRIP001 	Control( pParent, rResId ),
//STRIP001     aEnabledBmp( *this ),
//STRIP001     aDisabledBmp( *this ),
//STRIP001     aBufferBmp( *this )
//STRIP001 {
//STRIP001 	DBG_ASSERT( pParent, "-SvxCtrDial::SvxCtrDial(): no parent, no cookies!" );
//STRIP001 
//STRIP001 	aWinSize = GetOutputSizePixel();
//STRIP001 	aRotFont = OutputDevice::GetDefaultFont(
//STRIP001 		DEFAULTFONT_UI_SANS, Application::GetSettings().GetUILanguage(), DEFAULTFONT_FLAGS_ONLYONE );
//STRIP001 	Init();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*  Member:     Init                                        Datum:16.05.01
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxCtrDial
//STRIP001 #*
//STRIP001 #*  Funktion:   common constructor instructions
//STRIP001 #*
//STRIP001 #*  Input:		---
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 void SvxCtrDial::Init()
//STRIP001 {
//STRIP001     EnableRTL( false ); // #107807# don't mirror mouse handling
//STRIP001     bNoSel = false;
//STRIP001 	nDelta = 0;
//STRIP001 	aRotFont.SetTransparent( TRUE );
//STRIP001 	SetOutputSizePixel( aWinSize );
//STRIP001 	nCenterX = aWinSize.Width() / 2;
//STRIP001 	nCenterY = aWinSize.Height() / 2;
//STRIP001 	SetBackground();
//STRIP001 	aEnabledBmp.DrawBackgrBitmap( aWinSize, TRUE );
//STRIP001 	aDisabledBmp.DrawBackgrBitmap( aWinSize, FALSE );
//STRIP001 	aBufferBmp.InitBitmap( aWinSize, aRotFont );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Member:		Paint										Datum:08.09.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxCtrDial
//STRIP001 #*
//STRIP001 #*  Funktion:	Aktualisiert den Control und zeichnet den
//STRIP001 #*				gedrehten Text.
//STRIP001 #*
//STRIP001 #*  Input:		---
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 void SvxCtrDial::Paint( const Rectangle& aRect )
//STRIP001 {
//STRIP001     DrawBitmap( Point(), aBufferBmp.GetBitmap( Point(), aWinSize ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*  Member:     Invalidate                                  Datum:16.05.01
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxCtrDial
//STRIP001 #*
//STRIP001 #*  Funktion:	Aktualisiert den Control und zeichnet den
//STRIP001 #*				gedrehten Text.
//STRIP001 #*
//STRIP001 #*  Input:		---
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 void SvxCtrDial::Invalidate()
//STRIP001 {
//STRIP001     aBufferBmp.DrawBackgrBitmap( IsEnabled() ? aEnabledBmp : aDisabledBmp );
//STRIP001     if( !bNoSel )
//STRIP001         aBufferBmp.DrawElements( GetText(), nDelta, IsEnabled() );
//STRIP001     Control::Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 /**************************************************************************/
//STRIP001 
//STRIP001 void SvxCtrDial::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001     if( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001     {
//STRIP001         Init();
//STRIP001         Invalidate();
//STRIP001         Paint( Rectangle( Point(), aWinSize ) );
//STRIP001     }
//STRIP001 	else
//STRIP001         Control::DataChanged( rDCEvt );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Member:		MouseButtonDown								Datum:08.09.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxCtrDial
//STRIP001 #*
//STRIP001 #*  Funktion:	Reagiert auf einen einzelnen Mouse-Event. Hierbei
//STRIP001 #*				wird die aktuelle Maus- Koordinate ermittelt und
//STRIP001 #*				der entsprechende Winkel eingestellt. Anschliessend
//STRIP001 #*				wird die Ausgabe aktualisiert.
//STRIP001 #*
//STRIP001 #*  Input:		---
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 void SvxCtrDial::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	double x;
//STRIP001 	double y;
//STRIP001 	double h,h1;
//STRIP001 	double nAlpha;
//STRIP001 	Point aPos=rMEvt.GetPosPixel();
//STRIP001 
//STRIP001 	CaptureMouse();
//STRIP001 
//STRIP001 	if(rMEvt.IsLeft())
//STRIP001 	{
//STRIP001 		x=aPos.X()-nCenterX;
//STRIP001 		y=nCenterY-aPos.Y();
//STRIP001 
//STRIP001 		h=sqrt(x*x+y*y);
//STRIP001 
//STRIP001 		if(h!=0)
//STRIP001 		{
//STRIP001             h1 = acos( x / h );
//STRIP001             nAlpha = h1 / F_PI1800;
//STRIP001 			if(y>=0)
//STRIP001 			{
//STRIP001 				nDelta=(short) (150.*floor(nAlpha/150.+0.5));
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				nDelta=(short) (150.*floor((3600-nAlpha)/150.+0.5));
//STRIP001 			}
//STRIP001 			if(nDelta==3600) nDelta=0;
//STRIP001 		}
//STRIP001 
//STRIP001         bNoSel = false;
//STRIP001 		Invalidate();
//STRIP001 		Update();
//STRIP001 		CtrModified();
//STRIP001 	}
//STRIP001 	Control::MouseButtonDown(rMEvt );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Member:		MouseButtonUp								Datum:08.09.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxCtrDial
//STRIP001 #*
//STRIP001 #*  Funktion:	Ende einer Benutzeraktion mit der Maus. Es werden
//STRIP001 #*				die aktuelle Maus- Koordinate ermittelt und der
//STRIP001 #*				entsprechende Winkel eingestellt. Anschliessend
//STRIP001 #*				wird die Ausgabe aktualisiert.
//STRIP001 #*
//STRIP001 #*  Input:		---
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 void SvxCtrDial::MouseButtonUp( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	ReleaseMouse();
//STRIP001 
//STRIP001 	Control::MouseButtonUp(rMEvt );
//STRIP001 	CtrMouseUp();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Member:		MouseMove									Datum:08.09.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxCtrDial
//STRIP001 #*
//STRIP001 #*  Funktion:	Reagiert kontinuierlich auf Mausbewegungen. Hierbei
//STRIP001 #*				wird die aktuelle Maus- Koordinate ermittelt und
//STRIP001 #*				der entsprechende Winkel eingestellt. Anschliessend
//STRIP001 #*				wird die Ausgabe aktualisiert.
//STRIP001 #*
//STRIP001 #*  Input:		---
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 void SvxCtrDial::MouseMove( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	double x;
//STRIP001 	double y;
//STRIP001 	double h,h1;
//STRIP001 	double nAlpha;
//STRIP001 	Point aPos=rMEvt.GetPosPixel();
//STRIP001 
//STRIP001 	if(rMEvt.IsLeft() && IsMouseCaptured())
//STRIP001 	{
//STRIP001 		x=aPos.X()-nCenterX;
//STRIP001 		y=nCenterY-aPos.Y();
//STRIP001 
//STRIP001 		h=sqrt(x*x+y*y);
//STRIP001 
//STRIP001 		if(h!=0)
//STRIP001 		{
//STRIP001 			h1=acos(x/h);
//STRIP001             nAlpha= h1 / F_PI1800;
//STRIP001 			if(y>=0)
//STRIP001 			{
//STRIP001 				nDelta=(short) floor(nAlpha+0.5);
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				nDelta=(short) floor(3600.5-nAlpha);
//STRIP001 			}
//STRIP001 			if(nDelta==3600) nDelta=0;
//STRIP001 		}
//STRIP001 		Invalidate();
//STRIP001 		Update();
//STRIP001 		CtrModified();
//STRIP001 	}
//STRIP001 	Control::MouseMove(rMEvt );
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #************************************************************************/
//STRIP001 USHORT SvxCtrDial::GetOrientation()
//STRIP001 {
//STRIP001 	return (USHORT ) nDelta/10;
//STRIP001 }
//STRIP001 
//STRIP001 void SvxCtrDial::SetOrientation(short nAlpha)
//STRIP001 {
//STRIP001     bNoSel = false;
//STRIP001 	if(nAlpha>360)
//STRIP001 	{
//STRIP001 		nAlpha=nAlpha % 360;
//STRIP001 	}
//STRIP001 	else if(nAlpha<0)
//STRIP001 	{
//STRIP001 		nAlpha=nAlpha % 360;
//STRIP001 		nAlpha=360+nAlpha;
//STRIP001 	}
//STRIP001 
//STRIP001 	nDelta=nAlpha*10;
//STRIP001 	Invalidate();
//STRIP001 	Update();
//STRIP001 }
//STRIP001 
//STRIP001 bool SvxCtrDial::HasOrientation() const
//STRIP001 {
//STRIP001     return !bNoSel;
//STRIP001 }
//STRIP001 
//STRIP001 void SvxCtrDial::SetNoOrientation()
//STRIP001 {
//STRIP001     bNoSel = true;
//STRIP001     Invalidate();
//STRIP001     Update();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Member:		CtrModified									Datum:11.09.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxCtrDial
//STRIP001 #*
//STRIP001 #*  Funktion:	Teilt einem installierten Handler mit, dass
//STRIP001 #*				eine Veraenderung eingetreten ist.
//STRIP001 #*
//STRIP001 #*  Input:		---
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 void SvxCtrDial::CtrModified()
//STRIP001 {
//STRIP001 	aCtrModifiedLink.Call( this );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Member:		CtrModified									Datum:11.09.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxCtrDial
//STRIP001 #*
//STRIP001 #*  Funktion:	Teilt einem installierten Handler mit, dass
//STRIP001 #*				die Maus losgelassen wurde.
//STRIP001 #*
//STRIP001 #*  Input:		---
//STRIP001 #*
//STRIP001 #*	Output:		---
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 void SvxCtrDial::CtrMouseUp()
//STRIP001 {
//STRIP001 	aMouseUpLink.Call( this );
//STRIP001 }


}
