/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx__bmpmask.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:33:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SV_WRKWIN_HXX
// auto strip #include <vcl/wrkwin.hxx>
// auto strip #endif
// auto strip #ifndef _SHL_HXX
// auto strip #include <tools/shl.hxx>
// auto strip #endif
// auto strip #ifndef _SV_METAACT_HXX
// auto strip #include <vcl/metaact.hxx>
// auto strip #endif
// auto strip #ifndef _VALUESET_HXX
// auto strip #include <svtools/valueset.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SV_COLRDLG_HXX
// auto strip #include <svtools/colrdlg.hxx>
// auto strip #endif

#pragma hdrstop

#define BMPMASK_PRIVATE

// auto strip #include <dialmgr.hxx>
#include <bmpmask.hxx>
#include <dialogs.hrc>
#include <bmpmask.hrc>
#include <svxids.hrc>
namespace binfilter {

//-------------------------------------------------------------------------

//STRIP001 #define BMP_RESID(nId)  ResId(nId, DIALOG_MGR())
//STRIP001 #define TRANSP_STRING	"Transparent"
//STRIP001 #define TRANSP_COL		(Color( 252, 252, 252 ))
//STRIP001 #define OWN_CALLMODE	SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD

//-------------------------------------------------------------------------

//STRIP001 #define TEST_COLS()													\
//STRIP001 {																	\
//STRIP001 	nR = aCol.GetRed(); nG = aCol.GetGreen(); nB = aCol.GetBlue();	\
//STRIP001 	for( i = 0; i < nCount; i++ )									\
//STRIP001 	{																\
//STRIP001 		if ( ( pMinR[i] <= nR ) && ( pMaxR[i] >= nR ) &&			\
//STRIP001 			 ( pMinG[i] <= nG ) && ( pMaxG[i] >= nG ) &&			\
//STRIP001 			 ( pMinB[i] <= nB ) && ( pMaxB[i] >= nB ) )				\
//STRIP001 		{															\
//STRIP001 			aCol = pDstCols[i];	bReplace = TRUE; break;				\
//STRIP001 		}															\
//STRIP001 	}																\
//STRIP001 }

// -------------------------------------------------------------------------

/*N*/ SFX_IMPL_DOCKINGWINDOW( SvxBmpMaskChildWindow, SID_BMPMASK )

// -------------------------------------------------------------------------

//STRIP001 class ColorWindow : public Control
//STRIP001 {
//STRIP001 	Color       aColor;
//STRIP001 
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 				ColorWindow( Window* pParent, WinBits nWinStyle ) :
//STRIP001 					Control( pParent, nWinStyle ),
//STRIP001 					aColor( COL_WHITE ) {};
//STRIP001 
//STRIP001 				ColorWindow( Window* pParent, const ResId& rId ) :
//STRIP001 					Control( pParent, rId ),
//STRIP001 					aColor( COL_WHITE ) {};
//STRIP001 
//STRIP001 	void        SetColor( const Color& rColor )
//STRIP001 				{
//STRIP001 					aColor = rColor;
//STRIP001 					Invalidate();
//STRIP001 				}
//STRIP001 
//STRIP001 	virtual void Paint( const Rectangle& rRect );
//STRIP001 };

//-------------------------------------------------------------------------

//STRIP001 class MaskSet : public ValueSet
//STRIP001 {
//STRIP001 	SvxBmpMask*     pSvxBmpMask;
//STRIP001 
//STRIP001 
//STRIP001 public:
//STRIP001 					MaskSet( SvxBmpMask* pParent, WinBits nWinStyle );
//STRIP001 					MaskSet( SvxBmpMask* pParent, const ResId& rId );
//STRIP001 
//STRIP001 	virtual void    Select();
//STRIP001 	virtual void KeyInput( const KeyEvent& rKEvt );
//STRIP001 	virtual void GetFocus();
//STRIP001 
//STRIP001 	void onEditColor();
//STRIP001 };

//-------------------------------------------------------------------------

//STRIP001 MaskSet::MaskSet( SvxBmpMask* pParent, WinBits nWinStyle ) :
//STRIP001 			ValueSet        ( pParent, nWinStyle ),
//STRIP001 			pSvxBmpMask     ( pParent )
//STRIP001 {
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 MaskSet::MaskSet( SvxBmpMask* pParent, const ResId& rId ) :
//STRIP001 			ValueSet        ( pParent, rId ),
//STRIP001 			pSvxBmpMask     ( pParent )
//STRIP001 {
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void MaskSet::Select()
//STRIP001 {
//STRIP001 	ValueSet::Select();
//STRIP001 
//STRIP001 	pSvxBmpMask->onSelect( this );
//STRIP001 }

//STRIP001 void MaskSet::GetFocus()
//STRIP001 {
//STRIP001 	SelectItem( 1 );
//STRIP001 	pSvxBmpMask->onSelect( this );
//STRIP001 }

//STRIP001 void MaskSet::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001     KeyCode aCode = rKEvt.GetKeyCode();
//STRIP001 
//STRIP001 	// if the key has a modifier we don't care
//STRIP001     if( aCode.GetModifier() )
//STRIP001     {
//STRIP001         ValueSet::KeyInput( rKEvt );
//STRIP001     }
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// check for keys that interests us
//STRIP001 		switch ( aCode.GetCode() )
//STRIP001 		{
//STRIP001 			case KEY_SPACE:
//STRIP001 				onEditColor();
//STRIP001 				break;
//STRIP001 			default:
//STRIP001 		        ValueSet::KeyInput( rKEvt );
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 }

//STRIP001 void MaskSet::onEditColor()
//STRIP001 {
//STRIP001 	SvColorDialog* pColorDlg = new SvColorDialog( GetParent() );
//STRIP001 
//STRIP001 	pColorDlg->SetColor(GetItemColor(1));
//STRIP001 
//STRIP001 	if( pColorDlg->Execute() )
//STRIP001 		SetItemColor( 1, pColorDlg->GetColor() );
//STRIP001 
//STRIP001 	delete pColorDlg;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 class MaskData
//STRIP001 {
//STRIP001 	SvxBmpMask*		pMask;
//STRIP001 	BOOL			bIsReady;
//STRIP001 	BOOL			bExecState;
//STRIP001 	SfxBindings&	rBindings;
//STRIP001 
//STRIP001 public:
//STRIP001 				MaskData( SvxBmpMask* pBmpMask, SfxBindings& rBind );
//STRIP001 
//STRIP001 	BOOL		IsCbxReady() const { return bIsReady; }
//STRIP001 	void		SetExecState( BOOL bState ) { bExecState = bState; }
//STRIP001 	BOOL		IsExecReady() const { return bExecState; }
//STRIP001 
//STRIP001 				DECL_LINK( PipetteHdl, ToolBox* pTbx );
//STRIP001 				DECL_LINK( CbxHdl, CheckBox* pCbx );
//STRIP001 				DECL_LINK( CbxTransHdl, CheckBox* pCbx );
//STRIP001 				DECL_LINK( FocusLbHdl, ColorLB* pLb );
//STRIP001 				DECL_LINK( ExecHdl, PushButton* pBtn );
//STRIP001 };

//-------------------------------------------------------------------------

//STRIP001 MaskData::MaskData( SvxBmpMask* pBmpMask, SfxBindings& rBind ) :
//STRIP001 
//STRIP001 	pMask       ( pBmpMask ),
//STRIP001 	bIsReady    ( FALSE ),
//STRIP001 	bExecState  ( FALSE ),
//STRIP001 	rBindings	( rBind )
//STRIP001 
//STRIP001 {
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 IMPL_LINK( MaskData, PipetteHdl, ToolBox*, pTbx )
//STRIP001 {
//STRIP001 	SfxBoolItem aBItem( SID_BMPMASK_PIPETTE,
//STRIP001 						pTbx->IsItemChecked( TBI_PIPETTE ) );
//STRIP001 
//STRIP001 	rBindings.GetDispatcher()->Execute( SID_BMPMASK_PIPETTE, OWN_CALLMODE, &aBItem, 0L );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 IMPL_LINK( MaskData, CbxHdl, CheckBox*, pCbx )
//STRIP001 {
//STRIP001 	bIsReady =  pMask->aCbx1.IsChecked() || pMask->aCbx2.IsChecked() ||
//STRIP001 				pMask->aCbx3.IsChecked() || pMask->aCbx4.IsChecked();
//STRIP001 
//STRIP001 	if ( bIsReady && IsExecReady() )
//STRIP001 		pMask->aBtnExec.Enable();
//STRIP001 	else
//STRIP001 		pMask->aBtnExec.Disable();
//STRIP001 
//STRIP001 	// Wenn eine Checkbox gecheckt wurde, wird die Pipette enabled
//STRIP001 	if ( pCbx->IsChecked() )
//STRIP001 	{
//STRIP001 		MaskSet* pSet = NULL;
//STRIP001 
//STRIP001 		if ( pCbx == &( pMask->aCbx1 ) )
//STRIP001 			pSet = pMask->pQSet1;
//STRIP001 		else if ( pCbx == &( pMask->aCbx2 ) )
//STRIP001 			pSet = pMask->pQSet2;
//STRIP001 		else if ( pCbx == &( pMask->aCbx3 ) )
//STRIP001 			pSet = pMask->pQSet3;
//STRIP001 		else // if ( pCbx == &( pMask->aCbx4 ) )
//STRIP001 			pSet = pMask->pQSet4;
//STRIP001 
//STRIP001 		pSet->SelectItem( 1 );
//STRIP001 		pSet->Select();
//STRIP001 
//STRIP001 		pMask->aTbxPipette.CheckItem( TBI_PIPETTE, TRUE );
//STRIP001 		PipetteHdl( &( pMask->aTbxPipette ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 IMPL_LINK( MaskData, CbxTransHdl, CheckBox*, pCbx )
//STRIP001 {
//STRIP001 	if ( bIsReady = pCbx->IsChecked() )
//STRIP001 	{
//STRIP001 		pMask->pQSet1->Disable();
//STRIP001 		pMask->pQSet2->Disable();
//STRIP001 		pMask->pQSet3->Disable();
//STRIP001 		pMask->pQSet4->Disable();
//STRIP001 		pMask->pCtlPipette->Disable();
//STRIP001 		pMask->aCbx1.Disable();
//STRIP001 		pMask->aSp1.Disable();
//STRIP001 		pMask->aCbx2.Disable();
//STRIP001 		pMask->aSp2.Disable();
//STRIP001 		pMask->aCbx3.Disable();
//STRIP001 		pMask->aSp3.Disable();
//STRIP001 		pMask->aCbx4.Disable();
//STRIP001 		pMask->aSp4.Disable();
//STRIP001 		pMask->aTbxPipette.Disable();
//STRIP001 
//STRIP001 		pMask->aLbColor1.Disable();
//STRIP001 		pMask->aLbColor2.Disable();
//STRIP001 		pMask->aLbColor3.Disable();
//STRIP001 		pMask->aLbColor4.Disable();
//STRIP001 		pMask->aLbColorTrans.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pMask->pQSet1->Enable();
//STRIP001 		pMask->pQSet2->Enable();
//STRIP001 		pMask->pQSet3->Enable();
//STRIP001 		pMask->pQSet4->Enable();
//STRIP001 		pMask->pCtlPipette->Enable();
//STRIP001 		pMask->aCbx1.Enable();
//STRIP001 		pMask->aSp1.Enable();
//STRIP001 		pMask->aCbx2.Enable();
//STRIP001 		pMask->aSp2.Enable();
//STRIP001 		pMask->aCbx3.Enable();
//STRIP001 		pMask->aSp3.Enable();
//STRIP001 		pMask->aCbx4.Enable();
//STRIP001 		pMask->aSp4.Enable();
//STRIP001 		pMask->aTbxPipette.Enable();
//STRIP001 
//STRIP001 		pMask->aLbColor1.Enable();
//STRIP001 		pMask->aLbColor2.Enable();
//STRIP001 		pMask->aLbColor3.Enable();
//STRIP001 		pMask->aLbColor4.Enable();
//STRIP001 		pMask->aLbColorTrans.Disable();
//STRIP001 
//STRIP001 		bIsReady = pMask->aCbx1.IsChecked() || pMask->aCbx2.IsChecked() ||
//STRIP001 				   pMask->aCbx3.IsChecked() || pMask->aCbx4.IsChecked();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bIsReady && IsExecReady() )
//STRIP001 		pMask->aBtnExec.Enable();
//STRIP001 	else
//STRIP001 		pMask->aBtnExec.Disable();
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 IMPL_LINK( MaskData, FocusLbHdl, ColorLB*, pLb )
//STRIP001 {
//STRIP001 	pMask->pQSet1->SelectItem( pLb == &( pMask->aLbColor1 ) ? 1 : 0 );
//STRIP001 	pMask->pQSet2->SelectItem( pLb == &( pMask->aLbColor2 ) ? 1 : 0 );
//STRIP001 	pMask->pQSet3->SelectItem( pLb == &( pMask->aLbColor3 ) ? 1 : 0 );
//STRIP001 	pMask->pQSet4->SelectItem( pLb == &( pMask->aLbColor4 ) ? 1 : 0 );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 IMPL_LINK( MaskData, ExecHdl, PushButton*, pBtn )
//STRIP001 {
//STRIP001 	SfxBoolItem aBItem( SID_BMPMASK_EXEC, TRUE );
//STRIP001 	rBindings.GetDispatcher()->Execute( SID_BMPMASK_EXEC, OWN_CALLMODE, &aBItem, 0L );
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void ColorWindow::Paint( const Rectangle &Rect )
//STRIP001 {
//STRIP001 	const Color& rOldLineColor = GetLineColor();
//STRIP001 	const Color& rOldFillColor = GetFillColor();
//STRIP001 
//STRIP001 	SetLineColor( aColor );
//STRIP001 	SetFillColor( aColor );
//STRIP001 
//STRIP001 	DrawRect( Rectangle( Point(), GetSizePixel() ) );
//STRIP001 
//STRIP001 	SetLineColor( rOldLineColor );
//STRIP001 	SetFillColor( rOldFillColor );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 SvxBmpMaskSelectItem::SvxBmpMaskSelectItem( USHORT nId, SvxBmpMask& rMask,
//STRIP001 											SfxBindings& rBindings ) :
//STRIP001 			SfxControllerItem   ( nId, rBindings ),
//STRIP001 			rBmpMask            ( rMask)
//STRIP001 {
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SvxBmpMaskSelectItem::StateChanged( USHORT nSID, SfxItemState eState,
//STRIP001 										 const SfxPoolItem* pItem )
//STRIP001 {
//STRIP001 	if ( ( nSID == SID_BMPMASK_EXEC ) && pItem )
//STRIP001 	{
//STRIP001 		const SfxBoolItem* pStateItem = PTR_CAST( SfxBoolItem, pItem );
//STRIP001 
//STRIP001 		DBG_ASSERT( pStateItem || pItem == 0, "SfxBoolItem erwartet");
//STRIP001 
//STRIP001 		rBmpMask.SetExecState( pStateItem->GetValue() );
//STRIP001 	}
//STRIP001 }

//-------------------------------------------------------------------------

/*N*/ SvxBmpMaskChildWindow::SvxBmpMaskChildWindow( Window* pParent, USHORT nId,
/*N*/ 											  SfxBindings* pBindings,
/*N*/ 											  SfxChildWinInfo* pInfo ) :
/*N*/ 		SfxChildWindow( pParent, nId )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	pWindow = new SvxBmpMask( pBindings, this, pParent,
//STRIP001 							  BMP_RESID( RID_SVXDLG_BMPMASK ) );
//STRIP001 	SvxBmpMask* pDlg = (SvxBmpMask*) pWindow;
//STRIP001 
//STRIP001 	eChildAlignment = SFX_ALIGN_NOALIGNMENT;
//STRIP001 
//STRIP001 	pDlg->Initialize( pInfo );
/*N*/ }

//-------------------------------------------------------------------------

//STRIP001 SvxBmpMask::SvxBmpMask( SfxBindings *pBindinx,
//STRIP001 						SfxChildWindow *pCW,
//STRIP001 						Window* pParent,
//STRIP001 						const ResId& rResId ) :
//STRIP001 		SfxDockingWindow	( pBindinx, pCW, pParent, rResId ),
//STRIP001 		aTbxPipette			( this, ResId( TBX_PIPETTE ) ),
//STRIP001 		pCtlPipette			( new ColorWindow( this, ResId( WND_PIPETTE ) ) ),
//STRIP001 		aBtnExec			( this, ResId( BTN_EXEC ) ),
//STRIP001 
//STRIP001         aCbx1				( this, ResId( CBX_1 ) ),
//STRIP001 		pQSet1				( new MaskSet( this, ResId( QCOL_1 ) ) ),
//STRIP001 		aSp1				( this, ResId( SP_1 ) ),
//STRIP001 		aLbColor1			( this, ResId ( LB_1 ) ),
//STRIP001 
//STRIP001 		aCbx2				( this, ResId( CBX_2 ) ),
//STRIP001 		pQSet2				( new MaskSet( this, ResId( QCOL_2 ) ) ),
//STRIP001 		aSp2				( this, ResId( SP_2 ) ),
//STRIP001 		aLbColor2			( this, ResId ( LB_2 ) ),
//STRIP001 
//STRIP001 		aCbx3				( this, ResId( CBX_3 ) ),
//STRIP001 		pQSet3				( new MaskSet( this, ResId( QCOL_3 ) ) ),
//STRIP001 		aSp3				( this, ResId( SP_3 ) ),
//STRIP001 		aLbColor3			( this, ResId ( LB_3 ) ),
//STRIP001 
//STRIP001 		aCbx4				( this, ResId( CBX_4 ) ),
//STRIP001 		pQSet4				( new MaskSet( this, ResId( QCOL_4 ) ) ),
//STRIP001 		aSp4				( this, ResId( SP_4 ) ),
//STRIP001 		aLbColor4			( this, ResId ( LB_4 ) ),
//STRIP001 
//STRIP001 		aCbxTrans			( this, ResId( CBX_TRANS ) ),
//STRIP001 		aGrpQ				( this, ResId( GRP_Q ) ),
//STRIP001 		pColTab				( NULL ),
//STRIP001 		pData				( new MaskData( this, *pBindinx ) ),
//STRIP001 		aPipetteColor		( COL_WHITE ),
//STRIP001 		aSelItem			( SID_BMPMASK_EXEC, *this, *pBindinx ),
//STRIP001 		aLbColorTrans		( this, ResId ( LB_TRANS ) ),
//STRIP001 		aFt1				( this, ResId ( FT_1 ) ),
//STRIP001 		aFt2				( this, ResId ( FT_2 ) ),
//STRIP001 		aFt3				( this, ResId ( FT_3 ) ),
//STRIP001 		maImgPipette		( ResId ( IMG_PIPETTE ) ),
//STRIP001 		maImgPipetteH		( ResId ( IMG_PIPETTE_H ) )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	ApplyStyle();
//STRIP001 
//STRIP001 	aTbxPipette.SetSizePixel( aTbxPipette.CalcWindowSizePixel() );
//STRIP001 	aTbxPipette.SetSelectHdl( LINK( pData, MaskData, PipetteHdl ) );
//STRIP001 	aBtnExec.SetClickHdl( LINK( pData, MaskData, ExecHdl ) );
//STRIP001 
//STRIP001 	aCbx1.SetClickHdl( LINK( pData, MaskData, CbxHdl ) );
//STRIP001 	aCbx2.SetClickHdl( LINK( pData, MaskData, CbxHdl ) );
//STRIP001 	aCbx3.SetClickHdl( LINK( pData, MaskData, CbxHdl ) );
//STRIP001 	aCbx4.SetClickHdl( LINK( pData, MaskData, CbxHdl ) );
//STRIP001 	aCbxTrans.SetClickHdl( LINK( pData, MaskData, CbxTransHdl ) );
//STRIP001 
//STRIP001     SetAccessibleNames ();
//STRIP001 
//STRIP001 	aLbColor1.SetGetFocusHdl( LINK( pData, MaskData, FocusLbHdl ) );
//STRIP001 	aLbColor2.SetGetFocusHdl( LINK( pData, MaskData, FocusLbHdl ) );
//STRIP001 	aLbColor3.SetGetFocusHdl( LINK( pData, MaskData, FocusLbHdl ) );
//STRIP001 	aLbColor4.SetGetFocusHdl( LINK( pData, MaskData, FocusLbHdl ) );
//STRIP001     aLbColorTrans.Disable();
//STRIP001 
//STRIP001 	aSp1.SetValue( 10 );
//STRIP001 	aSp2.SetValue( 10 );
//STRIP001 	aSp3.SetValue( 10 );
//STRIP001 	aSp4.SetValue( 10 );
//STRIP001 
//STRIP001 	pQSet1->SetStyle( pQSet1->GetStyle() | WB_DOUBLEBORDER | WB_ITEMBORDER );
//STRIP001 	pQSet1->SetColCount( 1 );
//STRIP001 	pQSet1->SetLineCount( 1 );
//STRIP001 //	pQSet1->SetExtraSpacing( 1 );
//STRIP001 	pQSet1->InsertItem( 1, aPipetteColor );
//STRIP001 	pQSet1->SelectItem( 1 );
//STRIP001 
//STRIP001 	pQSet2->SetStyle( pQSet2->GetStyle() | WB_DOUBLEBORDER | WB_ITEMBORDER );
//STRIP001 	pQSet2->SetColCount( 1 );
//STRIP001 	pQSet2->SetLineCount( 1 );
//STRIP001 //	pQSet2->SetExtraSpacing( 1 );
//STRIP001 	pQSet2->InsertItem( 1, aPipetteColor );
//STRIP001 	pQSet2->SelectItem( 0 );
//STRIP001 
//STRIP001 	pQSet3->SetStyle( pQSet3->GetStyle() | WB_DOUBLEBORDER | WB_ITEMBORDER );
//STRIP001 	pQSet3->SetColCount( 1 );
//STRIP001 	pQSet3->SetLineCount( 1 );
//STRIP001 //	pQSet3->SetExtraSpacing( 1 );
//STRIP001 	pQSet3->InsertItem( 1, aPipetteColor );
//STRIP001 	pQSet3->SelectItem( 0 );
//STRIP001 
//STRIP001 	pQSet4->SetStyle( pQSet4->GetStyle() | WB_DOUBLEBORDER | WB_ITEMBORDER );
//STRIP001 	pQSet4->SetColCount( 1 );
//STRIP001 	pQSet4->SetLineCount( 1 );
//STRIP001 //	pQSet4->SetExtraSpacing( 1 );
//STRIP001 	pQSet4->InsertItem( 1, aPipetteColor );
//STRIP001 	pQSet4->SelectItem( 0 );
//STRIP001 
//STRIP001 	pQSet1->Show();
//STRIP001 	pQSet2->Show();
//STRIP001 	pQSet3->Show();
//STRIP001 	pQSet4->Show();
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 SvxBmpMask::~SvxBmpMask()
//STRIP001 {
//STRIP001 	delete pQSet1;
//STRIP001 	delete pQSet2;
//STRIP001 	delete pQSet3;
//STRIP001 	delete pQSet4;
//STRIP001 	delete pCtlPipette;
//STRIP001 	delete pData;
//STRIP001 }

//-------------------------------------------------------------------------

/** is called by a MaskSet when it is selected */
//STRIP001 void SvxBmpMask::onSelect( MaskSet* pSet )
//STRIP001 {
//STRIP001 	// automaticaly set focus to the corresponding listbox
//STRIP001 /*
//STRIP001 	if( pSet == pQSet1 )
//STRIP001 		aLbColor1.GrabFocus();
//STRIP001 	else if( pSet == pQSet2 )
//STRIP001 		aLbColor2.GrabFocus();
//STRIP001 	else if( pSet == pQSet2 )
//STRIP001 		aLbColor3.GrabFocus();
//STRIP001 	else if( pSet == pQSet2 )
//STRIP001 		aLbColor4.GrabFocus();
//STRIP001 */
//STRIP001 
//STRIP001 	// now deselect all other value sets
//STRIP001 	if( pSet != pQSet1 )
//STRIP001 		pQSet1->SelectItem( 0 );
//STRIP001 
//STRIP001 	if( pSet != pQSet2 )
//STRIP001 		pQSet2->SelectItem( 0 );
//STRIP001 
//STRIP001 	if( pSet != pQSet3 )
//STRIP001 		pQSet3->SelectItem( 0 );
//STRIP001 
//STRIP001 	if( pSet != pQSet4 )
//STRIP001 		pQSet4->SelectItem( 0 );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 BOOL SvxBmpMask::Close()
//STRIP001 {
//STRIP001 	SfxBoolItem aItem2( SID_BMPMASK_PIPETTE, FALSE );
//STRIP001 	GetBindings().GetDispatcher()->Execute( SID_BMPMASK_PIPETTE, OWN_CALLMODE, &aItem2, 0L );
//STRIP001 
//STRIP001 	return SfxDockingWindow::Close();
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 BOOL SvxBmpMask::NeedsColorTable() const
//STRIP001 {
//STRIP001 	return ( aLbColor1.GetEntryCount() == 0 );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SvxBmpMask::SetColorTable( const XColorTable* pTable )
//STRIP001 {
//STRIP001 	if ( pTable && ( pTable != pColTab ) )
//STRIP001 	{
//STRIP001 		const String aTransp( BMP_RESID( RID_SVXDLG_BMPMASK_STR_TRANSP ) );
//STRIP001 
//STRIP001 		pColTab = pTable;
//STRIP001 
//STRIP001 		aLbColorTrans.Fill( pColTab );
//STRIP001 		aLbColorTrans.SelectEntryPos( 0 );
//STRIP001 
//STRIP001 		aLbColor1.Fill( pColTab );
//STRIP001 		aLbColor1.InsertEntry( TRANSP_COL, aTransp, 0 );
//STRIP001 		aLbColor1.SelectEntryPos( 0 );
//STRIP001 
//STRIP001 		aLbColor2.Fill( pColTab );
//STRIP001 		aLbColor2.InsertEntry( TRANSP_COL, aTransp, 0 );
//STRIP001 		aLbColor2.SelectEntryPos( 0 );
//STRIP001 
//STRIP001 		aLbColor3.Fill( pColTab );
//STRIP001 		aLbColor3.InsertEntry( TRANSP_COL, aTransp, 0 );
//STRIP001 		aLbColor3.SelectEntryPos( 0 );
//STRIP001 
//STRIP001 		aLbColor4.Fill( pColTab );
//STRIP001 		aLbColor4.InsertEntry( TRANSP_COL, aTransp, 0 );
//STRIP001 		aLbColor4.SelectEntryPos( 0 );
//STRIP001 	}
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SvxBmpMask::SetColor( const Color& rColor )
//STRIP001 {
//STRIP001 	aPipetteColor = rColor;
//STRIP001 	pCtlPipette->SetColor( aPipetteColor );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SvxBmpMask::PipetteClicked()
//STRIP001 {
//STRIP001 	if( pQSet1->GetSelectItemId() == 1 )
//STRIP001 	{
//STRIP001 		aCbx1.Check( TRUE );
//STRIP001 		pData->CbxHdl( &aCbx1 );
//STRIP001 		pQSet1->SetItemColor( 1, aPipetteColor );
//STRIP001 	}
//STRIP001 	else if( pQSet2->GetSelectItemId() == 1 )
//STRIP001 	{
//STRIP001 		aCbx2.Check( TRUE );
//STRIP001 		pData->CbxHdl( &aCbx2 );
//STRIP001 		pQSet2->SetItemColor( 1, aPipetteColor );
//STRIP001 	}
//STRIP001 	else if( pQSet3->GetSelectItemId() == 1 )
//STRIP001 	{
//STRIP001 		aCbx3.Check( TRUE );
//STRIP001 		pData->CbxHdl( &aCbx3 );
//STRIP001 		pQSet3->SetItemColor( 1, aPipetteColor );
//STRIP001 	}
//STRIP001 	else if( pQSet4->GetSelectItemId() == 1 )
//STRIP001 	{
//STRIP001 		aCbx4.Check( TRUE );
//STRIP001 		pData->CbxHdl( &aCbx4 );
//STRIP001 		pQSet4->SetItemColor( 1, aPipetteColor );
//STRIP001 	}
//STRIP001 
//STRIP001 	aTbxPipette.CheckItem( TBI_PIPETTE, FALSE );
//STRIP001 	pData->PipetteHdl( &aTbxPipette );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SvxBmpMask::SetExecState( BOOL bEnable )
//STRIP001 {
//STRIP001 	pData->SetExecState( bEnable );
//STRIP001 
//STRIP001 	if ( pData->IsExecReady() && pData->IsCbxReady() )
//STRIP001 		aBtnExec.Enable();
//STRIP001 	else
//STRIP001 		aBtnExec.Disable();
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 USHORT SvxBmpMask::InitColorArrays( Color* pSrcCols, Color* pDstCols, ULONG* pTols )
//STRIP001 {
//STRIP001 	USHORT  nCount = 0;
//STRIP001 
//STRIP001 	if ( aCbx1.IsChecked() )
//STRIP001 	{
//STRIP001 		pSrcCols[nCount] = pQSet1->GetItemColor( 1 );
//STRIP001 		pDstCols[nCount] = aLbColor1.GetSelectEntryColor();
//STRIP001 		pTols[nCount++] = aSp1.GetValue();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( aCbx2.IsChecked() )
//STRIP001 	{
//STRIP001 		pSrcCols[nCount] = pQSet2->GetItemColor( 1 );
//STRIP001 		pDstCols[nCount] = aLbColor2.GetSelectEntryColor();
//STRIP001 		pTols[nCount++] = aSp2.GetValue();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( aCbx3.IsChecked() )
//STRIP001 	{
//STRIP001 		pSrcCols[nCount] = pQSet3->GetItemColor( 1 );
//STRIP001 		pDstCols[nCount] = aLbColor3.GetSelectEntryColor();
//STRIP001 		pTols[nCount++] = aSp3.GetValue();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( aCbx4.IsChecked() )
//STRIP001 	{
//STRIP001 		pSrcCols[nCount] = pQSet4->GetItemColor( 1 );
//STRIP001 		pDstCols[nCount] = aLbColor4.GetSelectEntryColor();
//STRIP001 		pTols[nCount++] = aSp4.GetValue();
//STRIP001 	}
//STRIP001 
//STRIP001 	return nCount;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 Bitmap SvxBmpMask::ImpMask( const Bitmap& rBitmap )
//STRIP001 {
//STRIP001 	Bitmap			aBitmap( rBitmap );
//STRIP001 	Color			pSrcCols[4];
//STRIP001 	Color			pDstCols[4];
//STRIP001 	ULONG			pTols[4];
//STRIP001 	const USHORT	nCount = InitColorArrays( pSrcCols, pDstCols, pTols );
//STRIP001 
//STRIP001 	EnterWait();
//STRIP001 	aBitmap.Replace( pSrcCols, pDstCols, nCount, pTols );
//STRIP001 	LeaveWait();
//STRIP001 
//STRIP001 	return aBitmap;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 BitmapEx SvxBmpMask::ImpMask( const BitmapEx& rBitmapEx )
//STRIP001 {
//STRIP001 	return BitmapEx( ImpMask( rBitmapEx.GetBitmap() ), rBitmapEx.GetMask() );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 BitmapEx SvxBmpMask::ImpMaskTransparent( const BitmapEx& rBitmapEx, const Color& rColor, const long nTol )
//STRIP001 {
//STRIP001 	EnterWait();
//STRIP001 
//STRIP001 	BitmapEx	aBmpEx;
//STRIP001 	Bitmap		aMask( rBitmapEx.GetBitmap().CreateMask( rColor, nTol ) );
//STRIP001 
//STRIP001 	if( rBitmapEx.IsTransparent() )
//STRIP001 		aMask.CombineSimple( rBitmapEx.GetMask(), BMP_COMBINE_OR );
//STRIP001 
//STRIP001 	aBmpEx = BitmapEx( rBitmapEx.GetBitmap(), aMask );
//STRIP001 	LeaveWait();
//STRIP001 
//STRIP001 	return aBmpEx;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 Animation SvxBmpMask::ImpMask( const Animation& rAnimation )
//STRIP001 {
//STRIP001 	Animation	aAnimation( rAnimation );
//STRIP001 	Color		pSrcCols[4];
//STRIP001 	Color		pDstCols[4];
//STRIP001 	ULONG		pTols[4];
//STRIP001 	USHORT		nCount = InitColorArrays( pSrcCols, pDstCols, pTols );
//STRIP001 	USHORT		nAnimationCount = aAnimation.Count();
//STRIP001 
//STRIP001 	for( USHORT i = 0; i < nAnimationCount; i++ )
//STRIP001 	{
//STRIP001 		AnimationBitmap aAnimBmp( aAnimation.Get( i ) );
//STRIP001 		aAnimBmp.aBmpEx = Mask( aAnimBmp.aBmpEx ).GetBitmapEx();
//STRIP001 		aAnimation.Replace( aAnimBmp, i );
//STRIP001 	}
//STRIP001 
//STRIP001 	return aAnimation;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 GDIMetaFile SvxBmpMask::ImpMask( const GDIMetaFile& rMtf )
//STRIP001 {
//STRIP001 	GDIMetaFile aMtf;
//STRIP001 	Color		pSrcCols[4];
//STRIP001 	Color		pDstCols[4];
//STRIP001 	ULONG		pTols[4];
//STRIP001 	USHORT      nCount = InitColorArrays( pSrcCols, pDstCols, pTols );
//STRIP001 	BOOL		pTrans[4];
//STRIP001 
//STRIP001 	// Falls keine Farben ausgewaehlt, kopieren wir nur das Mtf
//STRIP001 	if( !nCount )
//STRIP001 		aMtf = rMtf;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		Color       aCol;
//STRIP001 		long        nVal;
//STRIP001 		long        nTol;
//STRIP001 		long        nR;
//STRIP001 		long        nG;
//STRIP001 		long        nB;
//STRIP001 		long*       pMinR = new long[nCount];
//STRIP001 		long*       pMaxR = new long[nCount];
//STRIP001 		long*       pMinG = new long[nCount];
//STRIP001 		long*       pMaxG = new long[nCount];
//STRIP001 		long*       pMinB = new long[nCount];
//STRIP001 		long*       pMaxB = new long[nCount];
//STRIP001 		USHORT      i;
//STRIP001 		BOOL        bReplace;
//STRIP001 
//STRIP001 		aMtf.SetPrefSize( rMtf.GetPrefSize() );
//STRIP001 		aMtf.SetPrefMapMode( rMtf.GetPrefMapMode() );
//STRIP001 
//STRIP001 		// Farbvergleichsarrays vorbereiten
//STRIP001 		for( i = 0; i < nCount; i++ )
//STRIP001 		{
//STRIP001 			nTol = ( pTols[i] * 255L ) / 100L;
//STRIP001 
//STRIP001 			nVal = ( (long) pSrcCols[i].GetRed() );
//STRIP001 			pMinR[i] = Max( nVal - nTol, 0L );
//STRIP001 			pMaxR[i] = Min( nVal + nTol, 255L );
//STRIP001 
//STRIP001 			nVal = ( (long) pSrcCols[i].GetGreen() );
//STRIP001 			pMinG[i] = Max( nVal - nTol, 0L );
//STRIP001 			pMaxG[i] = Min( nVal + nTol, 255L );
//STRIP001 
//STRIP001 			nVal = ( (long) pSrcCols[i].GetBlue() );
//STRIP001 			pMinB[i] = Max( nVal - nTol, 0L );
//STRIP001 			pMaxB[i] = Min( nVal + nTol, 255L );
//STRIP001 
//STRIP001 			pTrans[ i ] = ( pDstCols[ i ] == TRANSP_COL );
//STRIP001 		}
//STRIP001 
//STRIP001 		// Actions untersuchen und Farben ggf. ersetzen
//STRIP001 		for( ULONG nAct = 0UL, nActCount = rMtf.GetActionCount(); nAct < nActCount; nAct++ )
//STRIP001 		{
//STRIP001 			MetaAction* pAction = rMtf.GetAction( nAct );
//STRIP001 
//STRIP001 			bReplace = FALSE;
//STRIP001 
//STRIP001 			switch( pAction->GetType() )
//STRIP001 			{
//STRIP001 				case( META_PIXEL_ACTION ):
//STRIP001 				{
//STRIP001 					MetaPixelAction* pAct = (MetaPixelAction*) pAction;
//STRIP001 
//STRIP001 					aCol = pAct->GetColor();
//STRIP001 					TEST_COLS();
//STRIP001 
//STRIP001 					if( bReplace )
//STRIP001 						pAct = new MetaPixelAction( pAct->GetPoint(), aCol );
//STRIP001 					else
//STRIP001 						pAct->Duplicate();
//STRIP001 
//STRIP001 					aMtf.AddAction( pAct );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case( META_LINECOLOR_ACTION ):
//STRIP001 				{
//STRIP001 					MetaLineColorAction* pAct = (MetaLineColorAction*) pAction;
//STRIP001 
//STRIP001 					aCol = pAct->GetColor();
//STRIP001 					TEST_COLS();
//STRIP001 
//STRIP001 					if( bReplace )
//STRIP001 						pAct = new MetaLineColorAction( aCol, !pTrans[ i ] );
//STRIP001 					else
//STRIP001 						pAct->Duplicate();
//STRIP001 
//STRIP001 					aMtf.AddAction( pAct );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case( META_FILLCOLOR_ACTION ):
//STRIP001 				{
//STRIP001 					MetaFillColorAction* pAct = (MetaFillColorAction*) pAction;
//STRIP001 
//STRIP001 					aCol = pAct->GetColor();
//STRIP001 					TEST_COLS();
//STRIP001 
//STRIP001 					if( bReplace )
//STRIP001 						pAct = new MetaFillColorAction( aCol, !pTrans[ i ] );
//STRIP001 					else
//STRIP001 						pAct->Duplicate();
//STRIP001 
//STRIP001 					aMtf.AddAction( pAct );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case( META_TEXTCOLOR_ACTION ):
//STRIP001 				{
//STRIP001 					MetaTextColorAction* pAct = (MetaTextColorAction*) pAction;
//STRIP001 
//STRIP001 					aCol = pAct->GetColor();
//STRIP001 					TEST_COLS();
//STRIP001 
//STRIP001 					if( bReplace )
//STRIP001 						pAct = new MetaTextColorAction( aCol );
//STRIP001 					else
//STRIP001 						pAct->Duplicate();
//STRIP001 
//STRIP001 					aMtf.AddAction( pAct );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case( META_TEXTFILLCOLOR_ACTION ):
//STRIP001 				{
//STRIP001 					MetaTextFillColorAction* pAct = (MetaTextFillColorAction*) pAction;
//STRIP001 
//STRIP001 					aCol = pAct->GetColor();
//STRIP001 					TEST_COLS();
//STRIP001 
//STRIP001 					if( bReplace )
//STRIP001 						pAct = new MetaTextFillColorAction( aCol, !pTrans[ i ] );
//STRIP001 					else
//STRIP001 						pAct->Duplicate();
//STRIP001 
//STRIP001 					aMtf.AddAction( pAct );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case( META_FONT_ACTION ):
//STRIP001 				{
//STRIP001 					MetaFontAction* pAct = (MetaFontAction*) pAction;
//STRIP001 					Font			aFont( pAct->GetFont() );
//STRIP001 
//STRIP001 					aCol = aFont.GetColor();
//STRIP001 					TEST_COLS();
//STRIP001 
//STRIP001 					if( bReplace )
//STRIP001 					{
//STRIP001 						aFont.SetColor( aCol );
//STRIP001 						pAct = new MetaFontAction( aFont );
//STRIP001 					}
//STRIP001 					else
//STRIP001 						pAct->Duplicate();
//STRIP001 
//STRIP001 					aMtf.AddAction( pAct );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case( META_WALLPAPER_ACTION ):
//STRIP001 				{
//STRIP001 					MetaWallpaperAction*	pAct = (MetaWallpaperAction*) pAction;
//STRIP001 					Wallpaper				aWall( pAct->GetWallpaper() );
//STRIP001 
//STRIP001 					aCol = aWall.GetColor();
//STRIP001 					TEST_COLS();
//STRIP001 
//STRIP001 					if( bReplace )
//STRIP001 					{
//STRIP001 						aWall.SetColor( aCol );
//STRIP001 						pAct = new MetaWallpaperAction( pAct->GetRect(), aWall );
//STRIP001 					}
//STRIP001 					else
//STRIP001 						pAct->Duplicate();
//STRIP001 
//STRIP001 					aMtf.AddAction( pAct );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case( META_BMP_ACTION ):
//STRIP001 				{
//STRIP001 					MetaBmpAction*	pAct = (MetaBmpAction*) pAction;
//STRIP001 					const Bitmap	aBmp( Mask( pAct->GetBitmap() ).GetBitmap() );
//STRIP001 
//STRIP001 					pAct = new MetaBmpAction( pAct->GetPoint(), aBmp );
//STRIP001 					aMtf.AddAction( pAct );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case( META_BMPSCALE_ACTION ):
//STRIP001 				{
//STRIP001 					MetaBmpScaleAction* pAct = (MetaBmpScaleAction*) pAction;
//STRIP001 					const Bitmap		aBmp( Mask( pAct->GetBitmap() ).GetBitmap() );
//STRIP001 
//STRIP001 					pAct = new MetaBmpScaleAction( pAct->GetPoint(), pAct->GetSize(), aBmp );
//STRIP001 					aMtf.AddAction( pAct );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case( META_BMPSCALEPART_ACTION ):
//STRIP001 				{
//STRIP001 					MetaBmpScalePartAction* pAct = (MetaBmpScalePartAction*) pAction;
//STRIP001 					const Bitmap			aBmp( Mask( pAct->GetBitmap() ).GetBitmap() );
//STRIP001 
//STRIP001 					pAct = new MetaBmpScalePartAction( pAct->GetDestPoint(), pAct->GetDestSize(),
//STRIP001 													   pAct->GetSrcPoint(), pAct->GetSrcSize(), aBmp );
//STRIP001 					aMtf.AddAction( pAct );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case( META_BMPEX_ACTION ):
//STRIP001 				{
//STRIP001 					MetaBmpExAction*	pAct = (MetaBmpExAction*) pAction;
//STRIP001 					const BitmapEx		aBmpEx( Mask( pAct->GetBitmapEx() ).GetBitmapEx() );
//STRIP001 
//STRIP001 					pAct = new MetaBmpExAction( pAct->GetPoint(), aBmpEx );
//STRIP001 					aMtf.AddAction( pAct );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case( META_BMPEXSCALE_ACTION ):
//STRIP001 				{
//STRIP001 					MetaBmpExScaleAction*	pAct = (MetaBmpExScaleAction*) pAction;
//STRIP001 					const BitmapEx			aBmpEx( Mask( pAct->GetBitmapEx() ).GetBitmapEx() );
//STRIP001 
//STRIP001 					pAct = new MetaBmpExScaleAction( pAct->GetPoint(), pAct->GetSize(), aBmpEx );
//STRIP001 					aMtf.AddAction( pAct );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case( META_BMPEXSCALEPART_ACTION ):
//STRIP001 				{
//STRIP001 					MetaBmpExScalePartAction*	pAct = (MetaBmpExScalePartAction*) pAction;
//STRIP001 					const BitmapEx				aBmpEx( Mask( pAct->GetBitmapEx() ).GetBitmapEx() );
//STRIP001 
//STRIP001 					pAct = new MetaBmpExScalePartAction( pAct->GetDestPoint(), pAct->GetDestSize(),
//STRIP001 														 pAct->GetSrcPoint(), pAct->GetSrcSize(), aBmpEx );
//STRIP001 					aMtf.AddAction( pAct );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				default:
//STRIP001 				{
//STRIP001 					pAction->Duplicate();
//STRIP001 					aMtf.AddAction( pAction );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		delete[] pMinR;
//STRIP001 		delete[] pMaxR;
//STRIP001 		delete[] pMinG;
//STRIP001 		delete[] pMaxG;
//STRIP001 		delete[] pMinB;
//STRIP001 		delete[] pMaxB;
//STRIP001 	}
//STRIP001 
//STRIP001 	LeaveWait();
//STRIP001 
//STRIP001 	return aMtf;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 BitmapEx SvxBmpMask::ImpReplaceTransparency( const BitmapEx& rBmpEx, const Color& rColor )
//STRIP001 {
//STRIP001 	if( rBmpEx.IsTransparent() )
//STRIP001 	{
//STRIP001 		Bitmap aBmp( rBmpEx.GetBitmap() );
//STRIP001 		aBmp.Replace( rBmpEx.GetMask(), rColor );
//STRIP001 		return aBmp;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return rBmpEx;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 Animation SvxBmpMask::ImpReplaceTransparency( const Animation& rAnim, const Color& rColor )
//STRIP001 {
//STRIP001 	Animation	aAnimation( rAnim );
//STRIP001 	USHORT		nAnimationCount = aAnimation.Count();
//STRIP001 
//STRIP001 	for( USHORT i = 0; i < nAnimationCount; i++ )
//STRIP001 	{
//STRIP001 		AnimationBitmap aAnimBmp( aAnimation.Get( i ) );
//STRIP001 		aAnimBmp.aBmpEx = ImpReplaceTransparency( aAnimBmp.aBmpEx, rColor );
//STRIP001 		aAnimation.Replace( aAnimBmp, i );
//STRIP001 	}
//STRIP001 
//STRIP001 	return aAnimation;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 GDIMetaFile SvxBmpMask::ImpReplaceTransparency( const GDIMetaFile& rMtf, const Color& rColor )
//STRIP001 {
//STRIP001 	VirtualDevice	aVDev;
//STRIP001 	GDIMetaFile		aMtf;
//STRIP001 	const MapMode&	rPrefMap = rMtf.GetPrefMapMode();
//STRIP001 	const Size&		rPrefSize = rMtf.GetPrefSize();
//STRIP001 	const ULONG		nActionCount = rMtf.GetActionCount();
//STRIP001 
//STRIP001 	aVDev.EnableOutput( FALSE );
//STRIP001 	aMtf.Record( &aVDev );
//STRIP001 	aMtf.SetPrefSize( rPrefSize );
//STRIP001 	aMtf.SetPrefMapMode( rPrefMap );
//STRIP001 	aVDev.SetLineColor( rColor );
//STRIP001 	aVDev.SetFillColor( rColor );
//STRIP001 
//STRIP001 	// Actions nacheinander abspielen; zuerst
//STRIP001 	// den gesamten Bereich auf die Ersatzfarbe setzen
//STRIP001 	aVDev.DrawRect( Rectangle( rPrefMap.GetOrigin(), rPrefSize ) );
//STRIP001 	for ( ULONG i = 0; i < nActionCount; i++ )
//STRIP001 	{
//STRIP001 		MetaAction* pAct = rMtf.GetAction( i );
//STRIP001 
//STRIP001 		pAct->Duplicate();
//STRIP001 		aMtf.AddAction( pAct );
//STRIP001 	}
//STRIP001 
//STRIP001 	aMtf.Stop();
//STRIP001 	aMtf.WindStart();
//STRIP001 
//STRIP001 	return aMtf;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 Graphic SvxBmpMask::Mask( const Graphic& rGraphic )
//STRIP001 {
//STRIP001 	Graphic		aGraphic( rGraphic );
//STRIP001 	const Color	aReplColor( aLbColorTrans.GetSelectEntryColor() );
//STRIP001 
//STRIP001 	switch( rGraphic.GetType() )
//STRIP001 	{
//STRIP001 		case( GRAPHIC_BITMAP ):
//STRIP001 		{
//STRIP001 			if( rGraphic.IsAnimated() )
//STRIP001 			{
//STRIP001 				// Transparenz ersetzen?
//STRIP001 				if ( aCbxTrans.IsChecked() )
//STRIP001 					aGraphic = ImpReplaceTransparency( rGraphic.GetAnimation(), aReplColor );
//STRIP001 				else
//STRIP001 					aGraphic = ImpMask( rGraphic.GetAnimation() );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// Transparenz ersetzen?
//STRIP001 				if( aCbxTrans.IsChecked() )
//STRIP001 				{
//STRIP001 					if( aGraphic.IsTransparent() )
//STRIP001 					{
//STRIP001 						BitmapEx	aBmpEx( ImpReplaceTransparency( aGraphic.GetBitmapEx(), aReplColor ) );
//STRIP001 						const Size	aSize( aBmpEx.GetSizePixel() );
//STRIP001 
//STRIP001 						if( aSize.Width() && aSize.Height() )
//STRIP001 							aGraphic = aBmpEx;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					Color	pSrcCols[4];
//STRIP001 					Color	pDstCols[4];
//STRIP001 					ULONG	pTols[4];
//STRIP001 					USHORT	nCount = InitColorArrays( pSrcCols, pDstCols, pTols );
//STRIP001 
//STRIP001 					if( nCount )
//STRIP001 					{
//STRIP001 						// erstmal alle Transparent-Farben setzen
//STRIP001 						for( USHORT i = 0; i < nCount; i++ )
//STRIP001 						{
//STRIP001 							// Haben wir eine Transparenzfarbe?
//STRIP001 							if( pDstCols[i] == TRANSP_COL )
//STRIP001 							{
//STRIP001 								BitmapEx	aBmpEx( ImpMaskTransparent( aGraphic.GetBitmapEx(),
//STRIP001 																		pSrcCols[ i ], pTols[ i ] ) );
//STRIP001 								const Size	aSize( aBmpEx.GetSizePixel() );
//STRIP001 
//STRIP001 								if( aSize.Width() && aSize.Height() )
//STRIP001 									aGraphic = aBmpEx;
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						// jetzt noch einmal mit den normalen Farben ersetzen
//STRIP001 						Bitmap	aBitmap( ImpMask( aGraphic.GetBitmap() ) );
//STRIP001 						Size	aSize( aBitmap.GetSizePixel() );
//STRIP001 
//STRIP001 						if ( aSize.Width() && aSize.Height() )
//STRIP001 						{
//STRIP001 							if ( aGraphic.IsTransparent() )
//STRIP001 								aGraphic = Graphic( BitmapEx( aBitmap, aGraphic.GetBitmapEx().GetMask() ) );
//STRIP001 							else
//STRIP001 								aGraphic = aBitmap;
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( GRAPHIC_GDIMETAFILE ):
//STRIP001 		{
//STRIP001 			GDIMetaFile	aMtf( aGraphic.GetGDIMetaFile() );
//STRIP001 
//STRIP001 			// Transparenz ersetzen?
//STRIP001 			if( aCbxTrans.IsChecked() )
//STRIP001 				aMtf = ImpReplaceTransparency( aMtf, aReplColor );
//STRIP001 			else
//STRIP001 				aMtf = ImpMask( aMtf );
//STRIP001 
//STRIP001 			Size aSize( aMtf.GetPrefSize() );
//STRIP001 			if ( aSize.Width() && aSize.Height() )
//STRIP001 				aGraphic = Graphic( aMtf );
//STRIP001 			else
//STRIP001 				aGraphic = rGraphic;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			aGraphic = rGraphic;
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aGraphic != rGraphic )
//STRIP001 	{
//STRIP001 		aGraphic.SetPrefSize( rGraphic.GetPrefSize() );
//STRIP001 		aGraphic.SetPrefMapMode( rGraphic.GetPrefMapMode() );
//STRIP001 	}
//STRIP001 
//STRIP001 	return aGraphic;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 BOOL SvxBmpMask::IsEyedropping() const
//STRIP001 {
//STRIP001 	return aTbxPipette.IsItemChecked( TBI_PIPETTE );
//STRIP001 }

//STRIP001 void SvxBmpMask::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001     SfxDockingWindow::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001             ApplyStyle();
//STRIP001 }

//STRIP001 void SvxBmpMask::ApplyStyle()
//STRIP001 {
//STRIP001 	bool bHighContrast = (bHighContrast = GetDisplayBackground().GetColor().IsDark() != 0);
//STRIP001 
//STRIP001 	aTbxPipette.SetItemImage( TBI_PIPETTE, bHighContrast ? maImgPipetteH : maImgPipette );
//STRIP001 }


/** Set an accessible name for the source color check boxes.  Without this
    the lengthy description is read.
*/
//STRIP001 void SvxBmpMask::SetAccessibleNames (void)
//STRIP001 {
//STRIP001     String sSourceColor (BMP_RESID( RID_SVXDLG_BMPMASK_STR_SOURCECOLOR));
//STRIP001     String sSourceColorN;
//STRIP001 
//STRIP001     sSourceColorN = sSourceColor;
//STRIP001     sSourceColorN.AppendAscii (RTL_CONSTASCII_STRINGPARAM (" 1"));
//STRIP001     aCbx1.SetAccessibleName (sSourceColorN);
//STRIP001 
//STRIP001     sSourceColorN = sSourceColor;
//STRIP001     sSourceColorN.AppendAscii (RTL_CONSTASCII_STRINGPARAM (" 2"));
//STRIP001     aCbx2.SetAccessibleName (sSourceColorN);
//STRIP001 
//STRIP001     sSourceColorN = sSourceColor;
//STRIP001     sSourceColorN.AppendAscii (RTL_CONSTASCII_STRINGPARAM (" 3"));
//STRIP001     aCbx3.SetAccessibleName (sSourceColorN);
//STRIP001 
//STRIP001     sSourceColorN = sSourceColor;
//STRIP001     sSourceColorN.AppendAscii (RTL_CONSTASCII_STRINGPARAM (" 4"));
//STRIP001     aCbx4.SetAccessibleName (sSourceColorN);
//STRIP001 }
}
