/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_mnuitem.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:41:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef SOLARIS
// HACK: prevent conflict between STLPORT and Workshop headers on Solaris 8
#include <ctime>
#endif

#include <string> // HACK: prevent conflict between STLPORT and Workshop includes

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_XDISPATCH_HPP_
// auto strip #include <com/sun/star/frame/XDispatch.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_XDISPATCHPROVIDER_HPP_
// auto strip #include <com/sun/star/frame/XDispatchProvider.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
// auto strip #include <com/sun/star/frame/XFrame.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_URL_HPP_
// auto strip #include <com/sun/star/util/URL.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
// auto strip #include <com/sun/star/beans/PropertyValue.hpp>
// auto strip #endif
// auto strip #ifndef _UNOTOOLS_PROCESSFACTORY_HXX
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
// auto strip #include <com/sun/star/util/XURLTransformer.hpp>
// auto strip #endif
// auto strip #ifndef _UNOTOOLS_PROCESSFACTORY_HXX
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif

// auto strip #ifndef _URLOBJ_HXX
// auto strip #include <tools/urlobj.hxx>
// auto strip #endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
// auto strip #ifndef _SVTOOLS_IMAGEMGR_HXX
// auto strip #include <svtools/imagemgr.hxx>
// auto strip #endif
// auto strip #ifndef INCLUDED_SVTOOLS_MENUOPTIONS_HXX
// auto strip #include <svtools/menuoptions.hxx>
// auto strip #endif
// auto strip #include <framework/menuconfiguration.hxx>
#pragma hdrstop

// auto strip #include "appdata.hxx"
#include "sfx.hrc"
#include "msgpool.hxx"
// auto strip #include "msgdescr.hxx"
// auto strip #include "msg.hxx"
// auto strip #include "bindings.hxx"
#include "dispatch.hxx"
// auto strip #include "idpool.hxx"
#include "sfxtypes.hxx"
#include "macrconf.hxx"
#include "virtmenu.hxx"
// auto strip #include "mnuitem.hxx"
#include "tbxctrl.hxx"
#include "arrdecl.hxx"
// auto strip #include "module.hxx"

#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

// auto strip #include "unoctitm.hxx"
#include "viewfrm.hxx"
// auto strip #include "imgmgr.hxx"
// auto strip #include "imagemgr.hxx"
// auto strip #include "sfxresid.hxx"
#include "../doc/doc.hrc"
// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif

namespace binfilter {

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::util;

//====================================================================

//STRIP001 class SfxEnumMenu: public PopupMenu
//STRIP001 {
//STRIP001 	USHORT			nSlot;
//STRIP001 	SfxEnumItem    *pItem;
//STRIP001     SfxBindings*    pBindings;
//STRIP001 
//STRIP001 protected:
//STRIP001 	virtual void	Select();
//STRIP001 
//STRIP001 public:
//STRIP001                     SfxEnumMenu( USHORT nSlot, SfxBindings* pBind, const SfxEnumItem &rItem );
//STRIP001 					~SfxEnumMenu();
//STRIP001 };

//=========================================================================

//STRIP001 SfxEnumMenu::SfxEnumMenu( USHORT nSlotId, SfxBindings* pBind, const SfxEnumItem &rItem ):
//STRIP001 	nSlot( nSlotId ),
//STRIP001     pItem( (SfxEnumItem*) rItem.Clone() ),
//STRIP001     pBindings( pBind )
//STRIP001 {
//STRIP001 	for ( USHORT nVal = 0; nVal < pItem->GetValueCount(); ++nVal )
//STRIP001 		InsertItem( nVal+1, pItem->GetValueTextByPos(nVal) );
//STRIP001 	CheckItem( pItem->GetValue() + 1, TRUE );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 SfxEnumMenu::~SfxEnumMenu()
//STRIP001 {
//STRIP001 	delete pItem;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxEnumMenu::Select()
//STRIP001 {
//STRIP001 	pItem->SetValue( GetCurItemId()-1 );
//STRIP001     pBindings->GetDispatcher()->Execute( nSlot,
//STRIP001 				SFX_CALLMODE_ASYNCHRON|SFX_CALLMODE_RECORD,
//STRIP001 				pItem, 0L, 0L );
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 void SfxMenuControl::SetOwnMenu( SfxVirtualMenu* pMenu )
//STRIP001 {
//STRIP001 	pOwnMenu = pMenu;
//STRIP001 	if ( pSubMenu )
//STRIP001 		pSubMenu->SetParentMenu( pMenu );
//STRIP001 }


//--------------------------------------------------------------------

// binds the instance to the specified id and assignes the title

/*N*/ void SfxMenuControl::Bind( SfxVirtualMenu* pOwn,
/*N*/ 						   USHORT nId, const String& rTitle,
/*N*/ 						   const String &rHelpText,
/*N*/ 						   SfxBindings &rBindings )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	aTitle = rTitle;
/*N*/ 	aHelpText = rHelpText;
/*N*/ 	pOwnMenu = pOwn;
/*N*/ 	pSubMenu = 0;
/*N*/ 	if ( pOwn )
/*N*/ 		SfxControllerItem::Bind(nId, &rBindings);
/*N*/ 	else
/*?*/ 		SetId( nId );
/*N*/ 
/*N*/ 	DBG( CheckConfigure_Impl(SFX_SLOT_MENUCONFIG) );
/*N*/ }


//--------------------------------------------------------------------

// binds the item to the specified menu and assignes the title

/*N*/ void SfxMenuControl::Bind( SfxVirtualMenu* pOwn,
/*N*/ 						   USHORT nId, SfxVirtualMenu& rMenu,
/*N*/ 						   const String& rTitle, const String &rHelpText,
/*N*/ 						   SfxBindings &rBindings )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	if ( nId == SID_NONE )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 nId = SFX_SLOTPOOL().GetIdPool().Get();
/*N*/ 	SetId( nId );
/*N*/ 	SetBindings(rBindings);
/*N*/ 	pOwnMenu = pOwn;
/*N*/ 	pSubMenu = &rMenu;
/*N*/ 	aTitle = rTitle;
/*N*/ 	aHelpText = rHelpText;
/*N*/ }

//--------------------------------------------------------------------

// ctor for explicit registration

//STRIP001 SfxMenuControl::SfxMenuControl( BOOL bShowStrings )
//STRIP001 :	pOwnMenu(0),
//STRIP001 	pSubMenu(0),
//STRIP001 	b_ShowStrings(bShowStrings)
//STRIP001 {
//STRIP001 	DBG_MEMTEST();
//STRIP001 }

//--------------------------------------------------------------------

// ctor for array

/*N*/ SfxMenuControl::SfxMenuControl():
/*N*/ 	pOwnMenu(0),
/*N*/ 	pSubMenu(0),
/*N*/ 	b_ShowStrings(FALSE)
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ }

//--------------------------------------------------------------------

/*?*/ SfxMenuControl::SfxMenuControl(USHORT nId, SfxBindings& rBindings):
/*?*/ 	SfxControllerItem(nId, rBindings),
/*?*/ 	pOwnMenu(0),
/*?*/ 	pSubMenu(0),
/*?*/ 	b_ShowStrings(FALSE)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	DBG_MEMTEST();
//STRIP001 
//STRIP001 	// Dieser Ctor soll es erm"oglichen, w"ahrend der Konstruktion schon
//STRIP001 	// auf die Bindings zur"uckgreifen zu k"onnen, aber gebunden wird
//STRIP001 	// wie immer erst sp"ater. Anwendung z.B. wenn im ctor der abgeleiteten
//STRIP001 	// Klasse z.B. ein StatusForwarder erzeugt werden soll.
//STRIP001 	UnBind();
/*?*/ }


//--------------------------------------------------------------------

// dtor

/*N*/ SfxMenuControl::~SfxMenuControl()
/*N*/ {
/*N*/ 	if ( SfxMacroConfig::IsMacroSlot( GetId() ) )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 SFX_APP()->GetMacroConfig()->ReleaseSlotId(GetId());
/*N*/ 	delete pSubMenu;
/*N*/ }

//STRIP001 void SfxMenuControl::RemovePopup()
//STRIP001 {
//STRIP001 	DELETEZ( pSubMenu );
//STRIP001 }

//--------------------------------------------------------------------

// changes the state in the virtual menu

/*N*/ void SfxMenuControl::StateChanged
/*N*/ (
/*N*/ 	USHORT 				nSID,
/*N*/ 	SfxItemState		eState,
/*N*/ 	const SfxPoolItem* 	pState
/*N*/ )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_ASSERT( nSID == GetId(), "strange SID" );
/*N*/ 	DBG_ASSERT( pOwnMenu != 0, "setting state to dangling SfxMenuControl" );
/*N*/ 
/*N*/ 	FASTBOOL bIsObjMenu =
/*N*/ 				GetId() >= SID_OBJECTMENU0 && GetId() < SID_OBJECTMENU_LAST;
/*N*/ 
/*N*/ 	// enabled/disabled-Flag pauschal korrigieren
/*N*/ 	pOwnMenu->EnableItem( GetId(), bIsObjMenu
/*N*/ 				? 0 != pOwnMenu->GetSVMenu()->GetPopupMenu( GetId() )
/*N*/ 				: eState != SFX_ITEM_DISABLED );
/*N*/ 
/*N*/ 	if ( eState != SFX_ITEM_AVAILABLE )
/*N*/ 	{
/*N*/ 		// checken nur bei nicht-Object-Menus
/*N*/ 		if ( !bIsObjMenu )
/*N*/ 			pOwnMenu->CheckItem( GetId(), FALSE );
/*N*/ 
/*N*/ 		// SetItemText flackert in MenuBar insbes. unter OS/2 (Bug #20658)
/*N*/ 		if ( // !bIsObjMenu && nicht wegen "Format/Datenbank"
/*N*/ 			 pOwnMenu->GetSVMenu()->GetItemText( GetId() ) != GetTitle() )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pOwnMenu->SetItemText( GetId(), GetTitle() );
/*N*/ 
/*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	// ggf. das alte Enum-Menu entfernen/loeschen
/*N*/ 	//! delete pOwnMenu->GetMenu().ChangePopupMenu( GetId(), 0 );
/*N*/ 
/*N*/ 	FASTBOOL bCheck = FALSE;
/*N*/ 	if ( pState->ISA(SfxBoolItem) )
/*N*/ 	{
/*N*/ 		// BoolItem fuer checken
/*N*/ 		DBG_ASSERT( GetId() < SID_OBJECTMENU0 || GetId() > SID_OBJECTMENU_LAST,
/*N*/ 					"SfxBoolItem not allowed for SID_OBJECTMENUx" );
/*N*/ 		bCheck = ((const SfxBoolItem*)pState)->GetValue();
/*N*/ 	}
/*N*/ 	else if ( pState->ISA(SfxEnumItemInterface) &&
/*N*/ 			  ((SfxEnumItemInterface *)pState)->HasBoolValue() )
/*N*/ 	{
/*N*/ 		// EnumItem wie Bool behandeln
/*?*/ 		DBG_ASSERT( GetId() < SID_OBJECTMENU0 || GetId() > SID_OBJECTMENU_LAST,
/*?*/ 					"SfxEnumItem not allowed for SID_OBJECTMENUx" );
/*?*/ 		bCheck = ((SfxEnumItemInterface *)pState)->GetBoolValue();
/*N*/ 	}
/*N*/ 	else if ( ( b_ShowStrings || bIsObjMenu ) && pState->ISA(SfxStringItem) )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP");//STRIP001 
//STRIP001 /*?*/ 		// MenuText aus SfxStringItem holen
//STRIP001 /*?*/ 		String aStr( ((const SfxStringItem*)pState)->GetValue() );
//STRIP001 /*?*/ 		if ( aStr.CompareToAscii("($1)",4) == COMPARE_EQUAL )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			String aEntry(SfxResId(STR_UPDATEDOC));
//STRIP001 /*?*/ 			aEntry += ' ';
//STRIP001 /*?*/ 			aEntry += aStr.Copy(4);
//STRIP001 /*?*/ 			aStr = aEntry;
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		else if ( aStr.CompareToAscii("($2)",4) == COMPARE_EQUAL )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			String aEntry(SfxResId(STR_CLOSEDOC_ANDRETURN));
//STRIP001 /*?*/ 			aEntry += aStr.Copy(4);
//STRIP001 /*?*/ 			aStr = aEntry;
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		pOwnMenu->SetItemText( GetId(), aStr );
/*N*/ 	}
/*N*/ 
/*N*/ #ifdef enum_item_menu_ok
/*?*/ 	else if ( aType == TYPE(SfxEnumItem) )
/*?*/ 	{
/*?*/ 		DBG_ASSERT( GetId() < SID_OBJECTMENU0 || GetId() > SID_OBJECTMENU_LAST,
/*?*/ 					"SfxEnumItem not allowed for SID_OBJECTMENUx" );
/*?*/         pOwnMenu->GetMenu().ChangePopupMenu( GetId(), &GetBindings(),
/*?*/ 			new SfxEnumMenu( GetId(), *(const SfxEnumItem*)pState ) );
/*?*/ 	}
/*N*/ #endif
/*N*/ 
/*N*/ 	pOwnMenu->CheckItem( GetId(), bCheck );
/*N*/ }

//--------------------------------------------------------------------

/*?*/ SfxMenuControl* SfxMenuControl::CreateImpl( USHORT nId, Menu &rMenu, SfxBindings &rBindings )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;//STRIP001 
//STRIP001 	return new SfxMenuControl( TRUE );
/*?*/ }

//--------------------------------------------------------------------

/*N*/ void SfxMenuControl::RegisterControl( USHORT nSlotId, SfxModule *pMod )
/*N*/ {
/*N*/ 	SFX_APP()->RegisterMenuControl( pMod, new SfxMenuCtrlFactory(
/*N*/ 				SfxMenuControl::CreateImpl, TYPE(SfxStringItem), nSlotId ) );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxMenuControl* SfxMenuControl::CreateControl( USHORT nId, Menu &rMenu, SfxBindings &rBindings )
/*N*/ {
/*N*/ 	TypeId aSlotType = SFX_SLOTPOOL().GetSlotType(nId);
/*N*/ 	if ( aSlotType )
/*N*/ 	{
/*N*/ 		SfxApplication *pApp = SFX_APP();
/*N*/ 		SfxDispatcher *pDisp = rBindings.GetDispatcher_Impl();
/*N*/ 		SfxModule *pMod = pDisp ? pApp->GetActiveModule( pDisp->GetFrame() ) :0;
/*N*/ 		if ( pMod )
/*N*/ 		{
/*N*/ 			SfxMenuCtrlFactArr_Impl *pFactories = pMod->GetMenuCtrlFactories_Impl();
/*N*/ 			if ( pFactories )
/*N*/ 			{
/*N*/ 				SfxMenuCtrlFactArr_Impl &rFactories = *pFactories;
/*N*/ 				for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
/*N*/ 					if ( rFactories[nFactory]->nTypeId == aSlotType &&
/*N*/ 						 ( ( rFactories[nFactory]->nSlotId == 0 ) ||
/*N*/ 						   ( rFactories[nFactory]->nSlotId == nId) ) )
/*?*/ 						return rFactories[nFactory]->pCtor( nId, rMenu, rBindings );
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		SfxMenuCtrlFactArr_Impl &rFactories = pApp->GetMenuCtrlFactories_Impl();
/*N*/ 
/*N*/ 		for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
/*N*/ 			if ( rFactories[nFactory]->nTypeId == aSlotType &&
/*N*/ 				 ( ( rFactories[nFactory]->nSlotId == 0 ) ||
/*N*/ 				   ( rFactories[nFactory]->nSlotId == nId) ) )
/*?*/ 				return rFactories[nFactory]->pCtor( nId, rMenu, rBindings );
/*N*/ 	}
/*N*/ 	return 0;
/*N*/ }



#if SUPD>633
//STRIP001 BOOL SfxMenuControl::IsSpecialControl( USHORT nId, SfxModule* pMod  )
//STRIP001 {
//STRIP001 	TypeId aSlotType = SFX_SLOTPOOL().GetSlotType( nId );
//STRIP001 	if ( aSlotType )
//STRIP001 	{
//STRIP001 		if ( pMod )
//STRIP001 		{
//STRIP001 			SfxMenuCtrlFactArr_Impl *pFactories = pMod->GetMenuCtrlFactories_Impl();
//STRIP001 			if ( pFactories )
//STRIP001 			{
//STRIP001 				SfxMenuCtrlFactArr_Impl &rFactories = *pFactories;
//STRIP001 				for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
//STRIP001 					if ( rFactories[nFactory]->nTypeId == aSlotType &&
//STRIP001 						 ( ( rFactories[nFactory]->nSlotId == 0 ) ||
//STRIP001 						   ( rFactories[nFactory]->nSlotId == nId) ) )
//STRIP001 						return TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001         SfxMenuCtrlFactArr_Impl &rFactories = SFX_APP()->GetMenuCtrlFactories_Impl();
//STRIP001 
//STRIP001 		for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
//STRIP001 			if ( rFactories[nFactory]->nTypeId == aSlotType &&
//STRIP001 				 ( ( rFactories[nFactory]->nSlotId == 0 ) ||
//STRIP001 				   ( rFactories[nFactory]->nSlotId == nId) ) )
//STRIP001 				return TRUE;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
#else
//STRIP001 BOOL SfxMenuControl::IsSpecialControl( USHORT nId, SfxBindings& rBindings  )
//STRIP001 {
//STRIP001 	TypeId aSlotType = SFX_SLOTPOOL().GetSlotType( nId );
//STRIP001 	if ( aSlotType )
//STRIP001 	{
//STRIP001 		SfxApplication *pApp = SFX_APP();
//STRIP001 		SfxDispatcher *pDisp = rBindings.GetDispatcher_Impl();
//STRIP001 		SfxModule *pMod = pDisp ? pApp->GetActiveModule( pDisp->GetFrame() ) :0;
//STRIP001 		if ( pMod )
//STRIP001 		{
//STRIP001 			SfxMenuCtrlFactArr_Impl *pFactories = pMod->GetMenuCtrlFactories_Impl();
//STRIP001 			if ( pFactories )
//STRIP001 			{
//STRIP001 				SfxMenuCtrlFactArr_Impl &rFactories = *pFactories;
//STRIP001 				for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
//STRIP001 					if ( rFactories[nFactory]->nTypeId == aSlotType &&
//STRIP001 						 ( ( rFactories[nFactory]->nSlotId == 0 ) ||
//STRIP001 						   ( rFactories[nFactory]->nSlotId == nId) ) )
//STRIP001 						return TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		SfxMenuCtrlFactArr_Impl &rFactories = pApp->GetMenuCtrlFactories_Impl();
//STRIP001 
//STRIP001 		for ( USHORT nFactory = 0; nFactory < rFactories.Count(); ++nFactory )
//STRIP001 			if ( rFactories[nFactory]->nTypeId == aSlotType &&
//STRIP001 				 ( ( rFactories[nFactory]->nSlotId == 0 ) ||
//STRIP001 				   ( rFactories[nFactory]->nSlotId == nId) ) )
//STRIP001 				return TRUE;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
#endif

//--------------------------------------------------------------------

/*?*/ PopupMenu* SfxMenuControl::GetPopup () const
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;//STRIP001 
//STRIP001 	if (GetPopupMenu())
//STRIP001 		return (PopupMenu*)GetPopupMenu()->GetSVMenu();
//STRIP001 	else
//STRIP001 		return 0;
/*?*/ }

long Select_Impl( void* pHdl, void* pVoid );

/*N*/ SFX_IMPL_MENU_CONTROL( SfxAppMenuControl_Impl, SfxStringItem );

/*?*/ SfxAppMenuControl_Impl::SfxAppMenuControl_Impl(
/*?*/ 	USHORT nPos, Menu& rMenu, SfxBindings& rBindings )
/*?*/ 	: SfxMenuControl( nPos, rBindings ), pMenu(0)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	String aText = rMenu.GetItemText( nPos );
//STRIP001 	SfxApplication* pApp = SFX_APP();
//STRIP001 	SfxAppData_Impl* pImpl = pApp->Get_Impl();
//STRIP001 
//STRIP001 	// Determine the current background color setting for menus
//STRIP001 	const StyleSettings& rSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 	BOOL bIsHiContrastMode	= rSettings.GetMenuColor().IsDark();
//STRIP001 	m_bWasHiContrastMode	= bIsHiContrastMode;
//STRIP001 	m_bShowMenuImages		= SvtMenuOptions().IsMenuIconsEnabled();
//STRIP001 
//STRIP001     Reference< ::com::sun::star::lang::XMultiServiceFactory> aXMultiServiceFactory(::legacy_binfilters::getLegacyProcessServiceFactory());
//STRIP001     ::framework::MenuConfiguration aConf( aXMultiServiceFactory );
//STRIP001     Reference< ::com::sun::star::frame::XFrame> aXFrame( GetBindings().GetDispatcher_Impl()->GetFrame()->GetFrame()->GetFrameInterface() );
//STRIP001     pMenu = aConf.CreateBookmarkMenu( aXFrame, GetId() == SID_NEWDOCDIRECT ? BOOKMARK_NEWMENU : BOOKMARK_WIZARDMENU );
//STRIP001 	if( pMenu )
//STRIP001     {
//STRIP001         pMenu->SetSelectHdl( Link( &(this->GetBindings()), Select_Impl ) );
//STRIP001 		pMenu->SetActivateHdl( LINK(this, SfxAppMenuControl_Impl, Activate) );
//STRIP001         rMenu.SetPopupMenu( nPos, pMenu );
//STRIP001     }
/*?*/ }

//STRIP001 SfxAppMenuControl_Impl::~SfxAppMenuControl_Impl()
//STRIP001 {
//STRIP001     delete pMenu;
//STRIP001 }

//STRIP001 IMPL_LINK( SfxAppMenuControl_Impl, Activate, Menu *, pMenu )
//STRIP001 {
//STRIP001 	if ( pMenu )
//STRIP001 	{
//STRIP001 		BOOL bShowMenuImages = SvtMenuOptions().IsMenuIconsEnabled();
//STRIP001 		const StyleSettings& rSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 		BOOL bIsHiContrastMode = rSettings.GetMenuColor().IsDark();
//STRIP001 
//STRIP001 		if (( bIsHiContrastMode != m_bWasHiContrastMode	) ||
//STRIP001 			( bShowMenuImages != m_bShowMenuImages		)	 )
//STRIP001 		{
//STRIP001 			m_bWasHiContrastMode	= bIsHiContrastMode;
//STRIP001 			m_bShowMenuImages		= bShowMenuImages;
//STRIP001 
//STRIP001 			USHORT nCount = pMenu->GetItemCount();
//STRIP001 			for ( USHORT nSVPos = 0; nSVPos < nCount; nSVPos++ )
//STRIP001 			{
//STRIP001 				USHORT nId = pMenu->GetItemId( nSVPos );
//STRIP001 				if ( pMenu->GetItemType( nSVPos ) != MENUITEM_SEPARATOR )
//STRIP001 				{
//STRIP001 					if ( bShowMenuImages )
//STRIP001 					{
//STRIP001 						sal_Bool		bImageSet = sal_False;
//STRIP001 						::rtl::OUString aImageId;
//STRIP001 						::framework::MenuConfiguration::Attributes* pMenuAttributes =
//STRIP001 							(::framework::MenuConfiguration::Attributes*)pMenu->GetUserValue( nId );
//STRIP001 
//STRIP001 						if ( pMenuAttributes )
//STRIP001 							aImageId = pMenuAttributes->aImageId; // Retrieve image id from menu attributes
//STRIP001 
//STRIP001                         if ( aImageId.getLength() > 0 )
//STRIP001 						{
//STRIP001                             Reference< ::com::sun::star::frame::XFrame > xFrame;
//STRIP001 							Image aImage = GetImage( xFrame, aImageId, FALSE, bIsHiContrastMode );
//STRIP001 							if ( !!aImage )
//STRIP001 							{
//STRIP001 								bImageSet = sal_True;
//STRIP001 								pMenu->SetItemImage( nId, aImage );
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						String aCmd( pMenu->GetItemCommand( nId ) );
//STRIP001 						if ( !bImageSet && aCmd.Len() )
//STRIP001 						{
//STRIP001 							Image aImage = SvFileInformationManager::GetImage( aCmd, FALSE, bIsHiContrastMode );
//STRIP001 							if ( !!aImage )
//STRIP001 								pMenu->SetItemImage( nId, aImage );
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else
//STRIP001 						pMenu->SetItemImage( nId, Image() );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 SfxUnoMenuControl* SfxMenuControl::CreateControl( const String& rCmd,
//STRIP001 		USHORT nId, Menu& rMenu, SfxBindings &rBindings, SfxVirtualMenu* pVirt )
//STRIP001 {
//STRIP001 	return new SfxUnoMenuControl( rCmd, nId, rMenu, rBindings, pVirt );
//STRIP001 }

//STRIP001 SfxUnoMenuControl::SfxUnoMenuControl( const String& rCmd, USHORT nId,
//STRIP001 	Menu& rMenu, SfxBindings& rBindings, SfxVirtualMenu* pVirt )
//STRIP001 	: SfxMenuControl( nId, rBindings )
//STRIP001 {
//STRIP001 	Bind( pVirt, nId, rMenu.GetItemText(nId),
//STRIP001 						rMenu.GetHelpText(nId), rBindings);
//STRIP001 	UnBind();
//STRIP001 	pUnoCtrl = new SfxUnoControllerItem( this, rBindings, rCmd );
//STRIP001 	pUnoCtrl->acquire();
//STRIP001 	pUnoCtrl->GetNewDispatch();
//STRIP001 }

//STRIP001 SfxUnoMenuControl::~SfxUnoMenuControl()
//STRIP001 {
//STRIP001 	pUnoCtrl->UnBind();
//STRIP001 	pUnoCtrl->release();
//STRIP001 }

//STRIP001 void SfxUnoMenuControl::Select()
//STRIP001 {
//STRIP001 	pUnoCtrl->Execute();
//STRIP001 }
}
