/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_inettbc.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:39:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "inettbc.hxx"

#pragma hdrstop

#ifndef _COM_SUN_STAR_UNO_ANY_H_
#include <com/sun/star/uno/Any.h>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
// auto strip #ifndef _SFXCANCEL_HXX //autogen
// auto strip #include <svtools/cancel.hxx>
// auto strip #endif
#ifndef INCLUDED_SVTOOLS_HISTORYOPTIONS_HXX
#include <svtools/historyoptions.hxx>
#endif
#include <vcl/toolbox.hxx>
// auto strip #ifndef _VOS_THREAD_HXX //autogen
// auto strip #include <vos/thread.hxx>
// auto strip #endif
// auto strip #ifndef _VOS_MUTEX_HXX //autogen
// auto strip #include <vos/mutex.hxx>
// auto strip #endif

// auto strip #include <svtools/itemset.hxx>
// auto strip #include <svtools/urihelper.hxx>
// auto strip #include <svtools/pathoptions.hxx>
// auto strip #include <svtools/asynclink.hxx>
#include <svtools/inettbc.hxx>

#include <unotools/localfilehelper.hxx>

#include "sfx.hrc"
#include "dispatch.hxx"
// auto strip #include "viewfrm.hxx"
// auto strip #include "objsh.hxx"
// auto strip #include "referers.hxx"
// auto strip #include "sfxtypes.hxx"
// auto strip #include "helper.hxx"
#include "so3/staticbaseurl.hxx"
namespace binfilter {

//***************************************************************************
// SfxURLToolBoxControl_Impl
//***************************************************************************

/*N*/ SFX_IMPL_TOOLBOX_CONTROL(SfxURLToolBoxControl_Impl,SfxStringItem)

/*N*/ SfxURLToolBoxControl_Impl::SfxURLToolBoxControl_Impl( USHORT nId ,
/*N*/ 												ToolBox& rBox ,
/*N*/ 												SfxBindings& rBindings )
/*N*/ 		: SfxToolBoxControl( nId , rBox , rBindings )
/*N*/ 		, aURLForwarder( SID_CURRENT_URL, *this )
/*N*/ {
/*N*/ }

/*N*/ SvtURLBox* SfxURLToolBoxControl_Impl::GetURLBox() const
/*N*/ {
/*N*/ 	return (SvtURLBox*) GetToolBox().GetItemWindow(GetId());
/*N*/ }

//***************************************************************************

//STRIP001 void SfxURLToolBoxControl_Impl::OpenURL( const String& rName, BOOL bNew ) const
//STRIP001 {
//STRIP001     String aName;
//STRIP001     String aFilter;
//STRIP001     String aOptions;
//STRIP001 
//STRIP001     INetURLObject aObj( rName );
//STRIP001     if ( aObj.GetProtocol() == INET_PROT_NOT_VALID )
//STRIP001     {
//STRIP001         String aBaseURL = GetURLBox()->GetBaseURL();
//STRIP001         aName = SvtURLBox::ParseSmart( rName, aBaseURL, SvtPathOptions().GetWorkPath() );
//STRIP001     }
//STRIP001     else
//STRIP001         aName = rName;
//STRIP001 
//STRIP001 	if ( !aName.Len() )
//STRIP001 		return;
//STRIP001 
//STRIP001     SfxViewFrame *pViewFrame = SfxViewFrame::Current();
//STRIP001     DBG_ASSERT( pViewFrame, "No ViewFrame ?!" );
//STRIP001     if ( pViewFrame )
//STRIP001     {
//STRIP001         pViewFrame = pViewFrame->GetTopViewFrame();
//STRIP001         SfxAllItemSet aSet( pViewFrame->GetPool() );
//STRIP001         aSet.Put( SfxStringItem( SID_FILE_NAME, aName ) );
//STRIP001         aSet.Put( SfxFrameItem( SID_DOCFRAME , pViewFrame ? pViewFrame->GetFrame() : 0 ) );
//STRIP001         aSet.Put( SfxStringItem( SID_REFERER, DEFINE_CONST_UNICODE(SFX_REFERER_USER) ) );
//STRIP001         aSet.Put( SfxStringItem( SID_TARGETNAME, String::CreateFromAscii("_default") ) );
//STRIP001 
//STRIP001         if ( aFilter.Len() )
//STRIP001         {
//STRIP001             aSet.Put( SfxStringItem( SID_FILTER_NAME, aFilter ) );
//STRIP001             aSet.Put( SfxStringItem( SID_FILE_FILTEROPTIONS, aOptions ) );
//STRIP001         }
//STRIP001 
//STRIP001         SFX_APP()->GetAppDispatcher_Impl()->Execute( SID_OPENURL, SFX_CALLMODE_RECORD, aSet );
//STRIP001     }
//STRIP001 }

/*N*/ Window* SfxURLToolBoxControl_Impl::CreateItemWindow( Window* pParent )
/*N*/ {
/*N*/ 	SvtURLBox* pURLBox = new SvtURLBox( pParent );
/*N*/     pURLBox->SetOpenHdl( LINK( this, SfxURLToolBoxControl_Impl, OpenHdl ) );
/*N*/     pURLBox->SetSelectHdl( LINK( this, SfxURLToolBoxControl_Impl, SelectHdl ) );
/*N*/ 	return pURLBox;
/*N*/ }

/*N*/ IMPL_LINK( SfxURLToolBoxControl_Impl, SelectHdl, void*, pVoid )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     SvtURLBox* pURLBox = GetURLBox();
//STRIP001     String aName( pURLBox->GetURL() );
//STRIP001 
//STRIP001     if ( !pURLBox->IsTravelSelect() && aName.Len() )
//STRIP001 	{
//STRIP001 /*
//STRIP001         aName = so3::StaticBaseUrl::SmartRelToAbs( aName );
//STRIP001         SfxPickList_Impl*  pPickList = SfxPickList_Impl::Get();
//STRIP001         SfxPickEntry_Impl* pEntry = pPickList->GetHistoryPickEntryFromTitle( aName );
//STRIP001         if ( !pEntry )
//STRIP001             pPickList->SetCurHistoryPos( pURLBox->GetEntryPos( aName ) );
//STRIP001  */
//STRIP001         OpenURL( aName, FALSE );
//STRIP001     }
//STRIP001 
/*N*/     return 1L;
/*N*/ }

/*N*/ IMPL_LINK( SfxURLToolBoxControl_Impl, OpenHdl, void*, pVoid )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     SvtURLBox* pURLBox = GetURLBox();
//STRIP001     OpenURL( pURLBox->GetURL(), pURLBox->IsCtrlOpen() );
//STRIP001     SfxViewFrame* pFrm = SfxViewFrame::Current();
//STRIP001     if( pFrm )
//STRIP001         pFrm->GetFrame()->GrabFocusOnComponent_Impl();
/*N*/     return 1L;
/*N*/ }

//***************************************************************************

/*N*/ void SfxURLToolBoxControl_Impl::StateChanged
/*N*/ (
/*N*/ 	USHORT              nSID,
/*N*/ 	SfxItemState        eState,
/*N*/ 	const SfxPoolItem*  pState
/*N*/ )
/*N*/ {
/*N*/ 	if( nSID == SID_FOCUSURLBOX )
/*N*/ 	{
/*?*/ 		if ( GetURLBox()->IsVisible() )
/*?*/ 			GetURLBox()->GrabFocus();
/*N*/ 	}
/*N*/ 	else if ( !GetURLBox()->IsModified() && SFX_ITEM_AVAILABLE == eState )
/*N*/ 	{
/*N*/ 		SvtURLBox* pURLBox = GetURLBox();
/*N*/ 		pURLBox->Clear();
/*N*/ 
/*N*/         ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue > > lList = SvtHistoryOptions().GetList(eHISTORY);
/*N*/         for (sal_Int32 i=0; i<lList.getLength(); ++i)
/*N*/         {
/*N*/             ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue > lProps = lList[i];
/*N*/             for (sal_Int32 p=0; p<lProps.getLength(); ++p)
/*N*/             {
/*N*/                 if (lProps[p].Name != HISTORY_PROPERTYNAME_URL)
/*N*/                     continue;
/*N*/ 
/*N*/                 ::rtl::OUString sURL;
/*N*/                 if (!(lProps[p].Value>>=sURL) || !sURL.getLength())
/*N*/                     continue;
/*N*/ 
/*N*/                 INetURLObject aURL    ( sURL );
/*N*/                 String        sMainURL( aURL.GetMainURL( INetURLObject::DECODE_WITH_CHARSET ) );
/*N*/                 String        sFile;
/*N*/ 
/*N*/                 if (::utl::LocalFileHelper::ConvertURLToSystemPath(sMainURL,sFile))
/*?*/                     pURLBox->InsertEntry(sFile);
/*N*/                 else
/*N*/                     pURLBox->InsertEntry(sMainURL);
/*N*/             }
/*N*/         }
/*N*/ 
/*N*/ 		const SfxStringItem *pURL = PTR_CAST(SfxStringItem,pState);
/*N*/ 		String aRep( pURL->GetValue() );
/*N*/ 		INetURLObject aURL( aRep );
/*N*/ 		INetProtocol eProt = aURL.GetProtocol();
/*N*/         if ( eProt == INET_PROT_FILE )
/*N*/         {
/*?*/             pURLBox->SetText( aURL.PathToFileName() );
/*N*/         }
/*N*/         else
/*N*/             pURLBox->SetText( aURL.GetURLNoPass() );
/*N*/ 	}
/*N*/ }

//***************************************************************************
// SfxCancelToolBoxControl_Impl
//***************************************************************************

/*N*/ SFX_IMPL_TOOLBOX_CONTROL(SfxCancelToolBoxControl_Impl,SfxBoolItem)

//***************************************************************************

/*N*/ SfxCancelToolBoxControl_Impl::SfxCancelToolBoxControl_Impl
/*N*/ (
/*N*/ 	USHORT nId,
/*N*/ 	ToolBox& rBox,
/*N*/ 	SfxBindings& rBindings
/*N*/ )
/*N*/ :   SfxToolBoxControl( nId, rBox, rBindings )
/*N*/ {
/*N*/ }

//***************************************************************************

//STRIP001 SfxPopupWindowType SfxCancelToolBoxControl_Impl::GetPopupWindowType() const
//STRIP001 {
//STRIP001 	return SFX_POPUPWINDOW_ONTIMEOUT;
//STRIP001 }

//***************************************************************************

//STRIP001 SfxPopupWindow* SfxCancelToolBoxControl_Impl::CreatePopupWindow()
//STRIP001 {
//STRIP001 	PopupMenu aMenu;
//STRIP001 	BOOL bExecute = FALSE, bSeparator = FALSE;
//STRIP001 	USHORT nIndex = 1;
//STRIP001 	for ( SfxCancelManager *pCancelMgr = SfxViewFrame::Current()->GetTopViewFrame()->GetCancelManager();
//STRIP001 		  pCancelMgr;
//STRIP001 		  pCancelMgr = pCancelMgr->GetParent() )
//STRIP001 	{
//STRIP001 		for ( USHORT n=0; n<pCancelMgr->GetCancellableCount(); ++n )
//STRIP001 		{
//STRIP001 			if ( !n && bSeparator )
//STRIP001 			{
//STRIP001 				aMenu.InsertSeparator();
//STRIP001 				bSeparator = FALSE;
//STRIP001 			}
//STRIP001 			String aItemText = pCancelMgr->GetCancellable(n)->GetTitle();
//STRIP001 			if ( aItemText.Len() > 50 )
//STRIP001 			{
//STRIP001 				aItemText.Erase( 48 );
//STRIP001 				aItemText += DEFINE_CONST_UNICODE("...");
//STRIP001 			}
//STRIP001 			aMenu.InsertItem( nIndex++, aItemText );
//STRIP001 			bExecute = TRUE;
//STRIP001 			bSeparator = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	ToolBox& rToolBox = GetToolBox();
//STRIP001 	USHORT nId = bExecute ? nId = aMenu.Execute( &rToolBox, rToolBox.GetPointerPosPixel() ) : 0;
//STRIP001 	GetToolBox().EndSelection();
//STRIP001 	ClearCache();
//STRIP001 	UpdateSlot();
//STRIP001 	if ( nId )
//STRIP001 	{
//STRIP001 		String aSearchText = aMenu.GetItemText(nId);
//STRIP001 		for ( SfxCancelManager *pCancelMgr = SfxViewFrame::Current()->GetTopViewFrame()->GetCancelManager();
//STRIP001 			  pCancelMgr;
//STRIP001 			  pCancelMgr = pCancelMgr->GetParent() )
//STRIP001 		{
//STRIP001 			for ( USHORT n = 0; n < pCancelMgr->GetCancellableCount(); ++n )
//STRIP001 			{
//STRIP001 				SfxCancellable *pCancel = pCancelMgr->GetCancellable(n);
//STRIP001 				String aItemText = pCancel->GetTitle();
//STRIP001 				if ( aItemText.Len() > 50 )
//STRIP001 				{
//STRIP001 					aItemText.Erase( 48 );
//STRIP001 					aItemText += DEFINE_CONST_UNICODE("...");
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( aItemText == aSearchText )
//STRIP001 				{
//STRIP001 					pCancel->Cancel();
//STRIP001 					return 0;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

//***************************************************************************

/*N*/ void SfxCancelToolBoxControl_Impl::StateChanged
/*N*/ (
/*N*/ 	USHORT              nSID,
/*N*/ 	SfxItemState        eState,
/*N*/ 	const SfxPoolItem*  pState
/*N*/ )
/*N*/ {
/*N*/ 	SfxVoidItem aVoidItem( nSID );
/*N*/ 	//SfxToolBoxControl::StateChanged( nSID, eState, pState ? &aVoidItem : 0 );
/*N*/ 	SfxToolBoxControl::StateChanged( nSID, eState, pState );
/*N*/ }
}
