/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_tplcitem.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:04:54 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// INCLUDE ---------------------------------------------------------------

#include <svtools/intitem.hxx>

#pragma hdrstop

// auto strip #include "templdlg.hxx"
#include "bindings.hxx"
#include "tplpitem.hxx"
#include "tplcitem.hxx"
#include "templdgi.hxx"

#include "sfx.hrc"
#include "dialog.hrc"
namespace binfilter {

// STATIC DATA -----------------------------------------------------------

// Konstruktor

/*N*/ SfxTemplateControllerItem::SfxTemplateControllerItem(
/*N*/ 		USHORT nId,					// ID
/*N*/ 		SfxCommonTemplateDialog_Impl &rDlg,	// Controller-Instanz, dem dieses Item zugeordnet ist.
/*N*/ 		SfxBindings &rBindings):
/*N*/ 	SfxControllerItem(nId, rBindings),
/*N*/     rTemplateDlg(rDlg),
/*N*/     nWaterCanState(0xff),
/*N*/     nUserEventId(0)
/*N*/ {
/*N*/ }
// -----------------------------------------------------------------------
/*N*/ SfxTemplateControllerItem::~SfxTemplateControllerItem()
/*N*/ {
/*N*/     if(nUserEventId)
/*?*/         Application::RemoveUserEvent(nUserEventId);
/*N*/ }

// -----------------------------------------------------------------------

// Benachrichtigung "uber Status"anderung; wird an den
// im Konstruktor "ubergebenen Controller propagiert

/*N*/ void SfxTemplateControllerItem::StateChanged( USHORT nSID, SfxItemState eState,
/*N*/ 											  const SfxPoolItem* pItem )
/*N*/ {
/*N*/ 	switch(nSID)
/*N*/ 	{
/*N*/ 		case SID_STYLE_FAMILY1:
/*N*/ 		case SID_STYLE_FAMILY2:
/*N*/ 		case SID_STYLE_FAMILY3:
/*N*/ 		case SID_STYLE_FAMILY4:
/*N*/ 		case SID_STYLE_FAMILY5:
/*N*/ 		{
/*N*/ 			FASTBOOL bAvailable = SFX_ITEM_AVAILABLE == eState;
/*N*/ 			if ( !bAvailable )
/*N*/ 				rTemplateDlg.SetFamilyState(GetId(), 0);
/*N*/ 			else {
/*N*/ 				const SfxTemplateItem *pStateItem = PTR_CAST(
/*N*/ 					SfxTemplateItem, pItem);
/*N*/ 				DBG_ASSERT(pStateItem != 0, "SfxTemplateItem erwartet");
/*N*/ 				rTemplateDlg.SetFamilyState( GetId(), pStateItem );
/*N*/ 			}
/*N*/ 			BOOL bDisable = eState == SFX_ITEM_DISABLED;
/*N*/ 			// Familie Disablen
/*N*/ 			USHORT nFamily;
/*N*/ 			switch( GetId())
/*N*/ 			{
/*N*/ 				case SID_STYLE_FAMILY1:
/*N*/ 					nFamily = 1; break;
/*N*/ 				case SID_STYLE_FAMILY2:
/*N*/ 					nFamily = 2; break;
/*N*/ 				case SID_STYLE_FAMILY3:
/*N*/ 					nFamily = 3; break;
/*N*/ 				case SID_STYLE_FAMILY4:
/*N*/ 					nFamily = 4; break;
/*N*/ 				case SID_STYLE_FAMILY5:
/*N*/ 					nFamily = 5; break;
/*N*/ 				default: DBG_ERROR("unbekannte StyleFamily"); break;
/*N*/ 			}
/*N*/ 			rTemplateDlg.EnableFamilyItem( nFamily, !bDisable );
/*N*/ 			break;
/*N*/ 		}
/*N*/ 		case SID_STYLE_WATERCAN:
/*N*/ 		{
/*N*/ 			if ( eState == SFX_ITEM_DISABLED )
/*N*/                 nWaterCanState = 0xff;
/*N*/             else if( eState == SFX_ITEM_AVAILABLE )
/*N*/ 			{
/*N*/ 				const SfxBoolItem *pStateItem = PTR_CAST(SfxBoolItem, pItem);
/*N*/ 				DBG_ASSERT(pStateItem != 0, "BoolItem erwartet");
/*N*/                 nWaterCanState = pStateItem->GetValue() ? 1 : 0;
/*N*/             }
/*N*/             //not necessary if the last event is still on the way
/*N*/ 			if(!nUserEventId)
/*N*/ 				nUserEventId = Application::PostUserEvent( STATIC_LINK(
/*N*/ 							this, SfxTemplateControllerItem, SetWaterCanStateHdl_Impl ) );
/*N*/ 			break;
/*N*/ 		}
/*N*/ 		case SID_STYLE_EDIT:
/*N*/ 			rTemplateDlg.EnableEdit( SFX_ITEM_DISABLED != eState );
/*N*/ 			break;
/*N*/ 		case SID_STYLE_DELETE:
/*N*/ 			rTemplateDlg.EnableDel( SFX_ITEM_DISABLED != eState );
/*N*/ 			break;
/*N*/ 		case SID_STYLE_NEW_BY_EXAMPLE:
/*N*/ 
/*N*/ 			rTemplateDlg.EnableExample_Impl(
/*N*/ 				GetId(), SFX_ITEM_DISABLED != eState );
/*N*/ 			break;
/*N*/ 		case SID_STYLE_UPDATE_BY_EXAMPLE:
/*N*/ 		{
/*N*/ 			rTemplateDlg.EnableExample_Impl(
/*N*/ 				GetId(), eState != SFX_ITEM_DISABLED );
/*N*/ 			// Das Select Disabled dann, falls enabled und Style Readonly
/*			String aStr = rTemplateDlg.GetSelectedEntry();
			if( aStr.Len() ) rTemplateDlg.SelectStyle( aStr ); */
/*N*/ 			break;
/*N*/ 		}
/*N*/ 		case SID_STYLE_NEW:
/*N*/ 		{
/*N*/ 			rTemplateDlg.EnableNew( SFX_ITEM_DISABLED != eState );
/*N*/ 			break;
/*N*/ 		}
/*N*/ 		case SID_STYLE_DRAGHIERARCHIE:
/*N*/ 		{
/*N*/ 			rTemplateDlg.EnableTreeDrag( SFX_ITEM_DISABLED != eState );
/*N*/ 			break;
/*N*/ 		}
/*N*/ 		case SID_STYLE_FAMILY :
/*N*/ 		{
/*N*/ 			const SfxUInt16Item *pStateItem = PTR_CAST( SfxUInt16Item, pItem);
/*N*/ 			if (pStateItem)
/*N*/ 				rTemplateDlg.SetFamily( pStateItem->GetValue() );
/*N*/ 			break;
/*N*/ 		}
/*N*/ 	}
/*N*/ }
/* -----------------------------05.09.2001 10:48------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ IMPL_STATIC_LINK(SfxTemplateControllerItem, SetWaterCanStateHdl_Impl,
/*N*/                                     SfxTemplateControllerItem*, EMPTYARG)
/*N*/ {
/*N*/     pThis->nUserEventId = 0;
/*N*/     SfxBoolItem* pState = 0;
/*N*/     switch(pThis->nWaterCanState)
/*N*/     {
/*N*/         case 0 :
/*N*/         case 1 :
/*N*/             pState = new SfxBoolItem(SID_STYLE_WATERCAN, pThis->nWaterCanState ? TRUE : FALSE);
/*N*/         break;
/*N*/     }
/*N*/     pThis->rTemplateDlg.SetWaterCanState(pState);
/*N*/     delete pState;
/*N*/     return 0;
/*N*/ }

}
