/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_newhelp.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:28:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "newhelp.hxx"
#include "sfxuno.hxx"
#include "sfxresid.hxx"
#include "helpinterceptor.hxx"
#include "helper.hxx"
#include "msgpool.hxx"
#include "app.hxx"
#include "sfxtypes.hxx"
#include "panelist.hxx"
#include "imgmgr.hxx"

#include "app.hrc"
#include "newhelp.hrc"
#include "helpid.hrc"

#include <hash_map>

#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif
#ifndef _UNOTOOLS_PROCESSFACTORY_HXX
#include <comphelper/processfactory.hxx>
#endif
#ifndef _TOOLKIT_HELPER_VCLUNOHELPER_HXX_
#include <toolkit/helper/vclunohelper.hxx>
#endif

#ifndef _COM_SUN_STAR_UTIL_XCLOSEABLE_HPP_
#include <com/sun/star/util/XCloseable.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_CLOSEVETOEXCEPTION_HPP_
#include <com/sun/star/util/CloseVetoException.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HPP_
#include <com/sun/star/lang/DisposedException.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_POSSIZE_HPP_
#include <com/sun/star/awt/PosSize.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_XWINDOW_HPP_
#include <com/sun/star/awt/XWindow.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTY_HPP_
#include <com/sun/star/beans/Property.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSETINFO_HPP_
#include <com/sun/star/beans/XPropertySetInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XINDEXACCESS_HPP_
#include <com/sun/star/container/XIndexAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_DISPATCHRESULTSTATE_HPP_
#include <com/sun/star/frame/DispatchResultState.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCH_HPP_
#include <com/sun/star/frame/XDispatch.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCHPROVIDER_HPP_
#include <com/sun/star/frame/XDispatchProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCHPROVIDERINTERCEPTION_HPP_
#include <com/sun/star/frame/XDispatchProviderInterception.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif
#ifndef _COM_SUN_STAR_TEXT_XBREAKITERATOR_HPP_
#include <com/sun/star/i18n/XBreakIterator.hpp>
#endif
#ifndef _COM_SUN_STAR_I18N_WORDTYPE_HPP_
#include <com/sun/star/i18n/WordType.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_STYLE_XSTYLE_HPP_
#include <com/sun/star/style/XStyle.hpp>
#endif
#ifndef _COM_SUN_STAR_STYLE_XSTYLEFAMILIESSUPPLIER_HPP_
#include <com/sun/star/style/XStyleFamiliesSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_TEXT_XTEXT_HPP_
#include <com/sun/star/text/XText.hpp>
#endif
#ifndef _COM_SUN_STAR_TEXT_XTEXTCURSOR_HPP_
#include <com/sun/star/text/XTextCursor.hpp>
#endif
#ifndef _COM_SUN_STAR_TEXT_XTEXTRANGE_HPP_
#include <com/sun/star/text/XTextRange.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_COMMANDABORTEDEXCEPTION_HPP_
#include <com/sun/star/ucb/CommandAbortedException.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_URL_HPP_
#include <com/sun/star/util/URL.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XSEARCHABLE_HPP_
#include <com/sun/star/util/XSearchable.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XSEARCHDESCRIPTOR_HPP_
#include <com/sun/star/util/XSearchDescriptor.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
#include <com/sun/star/util/XURLTransformer.hpp>
#endif
#ifndef _COM_SUN_STAR_VIEW_XSELECTIONSUPPLIER_HPP_
#include <com/sun/star/view/XSelectionSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_VIEW_XVIEWSETTINGSSUPPLIER_HPP_
#include <com/sun/star/view/XViewSettingsSupplier.hpp>
#endif

#ifndef INCLUDED_SVTOOLS_HISTORYOPTIONS_HXX
#include <svtools/historyoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_MENUOPTIONS_HXX
#include <svtools/menuoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_VIEWOPTIONS_HXX
#include <svtools/viewoptions.hxx>
#endif

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _CACHESTR_HXX
#include <tools/cachestr.hxx>
#endif
#ifndef _UNOTOOLS_STREAMHELPER_HXX_
#include <unotools/streamhelper.hxx>
#endif
#ifndef _SVTOOLS_IMAGEMGR_HXX
#include <svtools/imagemgr.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_MISCOPT_HXX
#include <svtools/miscopt.hxx>
#endif
#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif
#ifndef _VCL_UNOHELP_HXX
#include <vcl/unohelp.hxx>
#endif
#ifndef _VCL_I18NHELP_HXX
#include <vcl/i18nhelp.hxx>
#endif

#include <ucbhelper/content.hxx>
#include <vcl/msgbox.hxx>
#include <vcl/waitobj.hxx>
#include <unotools/ucbhelper.hxx>

#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {

using namespace ::ucb;
using namespace ::com::sun::star::ucb;

using namespace ::com::sun::star;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::i18n;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::style;
using namespace ::com::sun::star::text;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::view;

//STRIP001 extern void AppendConfigToken_Impl( String& rURL, sal_Bool bQuestionMark ); // sfxhelp.cxx
//STRIP001 
//STRIP001 // defines ---------------------------------------------------------------
//STRIP001 
//STRIP001 #define SPLITSET_ID			0
//STRIP001 #define COLSET_ID			1
//STRIP001 #define INDEXWIN_ID			2
//STRIP001 #define TEXTWIN_ID			3
//STRIP001 
//STRIP001 #define TOOLBOX_OFFSET		3
//STRIP001 
//STRIP001 #define TBI_INDEX			1001
//STRIP001 #define TBI_BACKWARD		1002
//STRIP001 #define TBI_FORWARD			1003
//STRIP001 #define TBI_START			1004
//STRIP001 #define TBI_PRINT			1005
//STRIP001 #define TBI_COPY			1006
//STRIP001 #define TBI_BOOKMARKS		1007
//STRIP001 #define TBI_SEARCHDIALOG	1008
//STRIP001 #define TBI_SOURCEVIEW		1009
//STRIP001 #define TBI_SELECTIONMODE   1010
//STRIP001 
//STRIP001 #define CONFIGNAME_HELPWIN		DEFINE_CONST_UNICODE("OfficeHelp")
//STRIP001 #define CONFIGNAME_INDEXWIN		DEFINE_CONST_UNICODE("OfficeHelpIndex")
//STRIP001 #define CONFIGNAME_SEARCHPAGE	DEFINE_CONST_UNICODE("OfficeHelpSearch")
//STRIP001 #define IMAGE_URL				DEFINE_CONST_UNICODE("private:factory/")
//STRIP001 
//STRIP001 #define PROPERTY_KEYWORDLIST	DEFINE_CONST_OUSTRING("KeywordList")
//STRIP001 #define PROPERTY_KEYWORDREF		DEFINE_CONST_OUSTRING("KeywordRef")
//STRIP001 #define PROPERTY_ANCHORREF		DEFINE_CONST_OUSTRING("KeywordAnchorForRef")
//STRIP001 #define PROPERTY_TITLEREF		DEFINE_CONST_OUSTRING("KeywordTitleForRef")
//STRIP001 #define PROPERTY_TITLE			DEFINE_CONST_OUSTRING("Title")
//STRIP001 #define HELP_URL				DEFINE_CONST_OUSTRING("vnd.sun.star.help://")
//STRIP001 #define HELP_SEARCH_TAG			DEFINE_CONST_OUSTRING("/?Query=")
//STRIP001 
//STRIP001 #define USERITEM_NAME			::rtl::OUString::createFromAscii( "UserItem" )
//STRIP001 
//STRIP001 #define PARSE_URL( aURL ) \
//STRIP001     Reference < XURLTransformer > xTrans( ::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance( \
//STRIP001             DEFINE_CONST_UNICODE("com.sun.star.util.URLTransformer" )), UNO_QUERY ); \
//STRIP001     xTrans->parseStrict( aURL )
//STRIP001 
//STRIP001 #define GET_SLOT_NAME( nId ) \
//STRIP001 	SFX_SLOTPOOL().GetSlotName_Impl( nId )
//STRIP001 
//STRIP001 //.........................................................................
//STRIP001 namespace sfx2
//STRIP001 {
//STRIP001 //.........................................................................
//STRIP001 
//STRIP001 	void HandleTaskPaneList( Window* pWindow, BOOL bAddToList )
//STRIP001 	{
//STRIP001 		Window* pParent = pWindow->GetParent();
//STRIP001 		DBG_ASSERT( pParent, "HandleTaskPaneList(): every window here should have a parent" );
//STRIP001 
//STRIP001 		SystemWindow* pSysWin = pParent->GetSystemWindow();
//STRIP001 		if( pSysWin )
//STRIP001 		{
//STRIP001 			TaskPaneList* pTaskPaneList = pSysWin->GetTaskPaneList();
//STRIP001 			if( pTaskPaneList )
//STRIP001 			{
//STRIP001 				if( bAddToList )
//STRIP001 					pTaskPaneList->AddWindow( pWindow );
//STRIP001 				else
//STRIP001 					pTaskPaneList->RemoveWindow( pWindow );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	/** Prepare a search string for searching or selecting.
//STRIP001 		For searching every search word needs the postfix '*' and the delimiter ' ' if necessary.
//STRIP001 		For selecting the delimiter '|' is required to search with regular expressions.
//STRIP001 		Samples:
//STRIP001 		search string | output for searching | output for selecting
//STRIP001 		-----------------------------------------------------------
//STRIP001 		"text"        | "text*"              | "text"
//STRIP001 		"text*"       | "text*"              | "text"
//STRIP001 		"text menu"   | "text* menu*"        | "text|menu"
//STRIP001 	*/
//STRIP001 	String PrepareSearchString( const String& rSearchString,
//STRIP001 								Reference< XBreakIterator > xBreak, bool bForSearch )
//STRIP001 	{
//STRIP001 		String sSearchStr;
//STRIP001 		sal_Int32 nStartPos = 0;
//STRIP001 		const Locale aLocale = Application::GetSettings().GetUILocale();
//STRIP001 		Boundary aBoundary = xBreak->getWordBoundary(
//STRIP001 			rSearchString, nStartPos, aLocale, WordType::ANYWORD_IGNOREWHITESPACES, sal_True );
//STRIP001 
//STRIP001 		while ( aBoundary.startPos != aBoundary.endPos )
//STRIP001 		{
//STRIP001 			nStartPos = aBoundary.startPos;
//STRIP001 			String sSearchToken( rSearchString.Copy(
//STRIP001 				(USHORT)aBoundary.startPos, (USHORT)aBoundary.endPos - (USHORT)aBoundary.startPos ) );
//STRIP001 			if ( bForSearch && sSearchToken.GetChar( sSearchToken.Len() - 1 ) != '*' )
//STRIP001 				sSearchToken += '*';
//STRIP001 
//STRIP001 			if ( sSearchToken.Len() > 1 ||
//STRIP001 				 ( sSearchToken.Len() > 0 && sSearchToken.GetChar( 0 ) != '*' ) )
//STRIP001 			{
//STRIP001 				if ( sSearchStr.Len() > 0 )
//STRIP001 				{
//STRIP001 					if ( bForSearch )
//STRIP001 						sSearchStr += ' ';
//STRIP001 					else
//STRIP001 						sSearchStr += '|';
//STRIP001 				}
//STRIP001 				sSearchStr += sSearchToken;
//STRIP001 			}
//STRIP001 			aBoundary = xBreak->nextWord( rSearchString, nStartPos,
//STRIP001 										  aLocale, WordType::ANYWORD_IGNOREWHITESPACES );
//STRIP001 		}
//STRIP001 
//STRIP001 		return sSearchStr;
//STRIP001 	}
//STRIP001 //.........................................................................
//STRIP001 // namespace sfx2
//STRIP001 }
//STRIP001 //.........................................................................
//STRIP001 
//STRIP001 // struct IndexEntry_Impl ------------------------------------------------
//STRIP001 
//STRIP001 struct IndexEntry_Impl
//STRIP001 {
//STRIP001 	sal_Bool		m_bSubEntry;
//STRIP001 	String			m_aURL;
//STRIP001 
//STRIP001 	IndexEntry_Impl( const String& rURL, sal_Bool bSubEntry ) :
//STRIP001 		m_bSubEntry( bSubEntry ), m_aURL( rURL ) {}
//STRIP001 };
//STRIP001 
//STRIP001 #define NEW_ENTRY( url, bool ) \
//STRIP001 	(void*)(ULONG)( new IndexEntry_Impl( url, bool ) )
//STRIP001 
//STRIP001 // class OpenStatusListener_Impl -----------------------------------------
//STRIP001 
//STRIP001 void SAL_CALL OpenStatusListener_Impl::dispatchFinished( const DispatchResultEvent& aEvent ) throw(RuntimeException)
//STRIP001 {
//STRIP001    	m_bSuccess = ( aEvent.State == DispatchResultState::SUCCESS );
//STRIP001    	m_bFinished = sal_True;
//STRIP001 	m_aOpenLink.Call( this );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SAL_CALL OpenStatusListener_Impl::disposing( const EventObject& Source ) throw(RuntimeException)
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // struct ContentEntry_Impl ----------------------------------------------
//STRIP001 
//STRIP001 struct ContentEntry_Impl
//STRIP001 {
//STRIP001 	String		aURL;
//STRIP001 	sal_Bool	bIsFolder;
//STRIP001 
//STRIP001 	ContentEntry_Impl( const String& rURL, sal_Bool bFolder ) :
//STRIP001 		aURL( rURL ), bIsFolder( bFolder ) {}
//STRIP001 };
//STRIP001 
//STRIP001 // ContentListBox_Impl ---------------------------------------------------
//STRIP001 
//STRIP001 ContentListBox_Impl::ContentListBox_Impl( Window* pParent, const ResId& rResId ) :
//STRIP001 
//STRIP001 	SvTreeListBox( pParent, rResId ),
//STRIP001 
//STRIP001 	aOpenBookImage		( SfxResId( IMG_HELP_CONTENT_BOOK_OPEN ) ),
//STRIP001 	aClosedBookImage	( SfxResId( IMG_HELP_CONTENT_BOOK_CLOSED ) ),
//STRIP001 	aOpenChapterImage	( SfxResId( IMG_HELP_CONTENT_CHAPTER_OPEN ) ),
//STRIP001 	aClosedChapterImage	( SfxResId( IMG_HELP_CONTENT_CHAPTER_CLOSED ) ),
//STRIP001 	aDocumentImage		( SfxResId( IMG_HELP_CONTENT_DOC ) )
//STRIP001 
//STRIP001 {
//STRIP001 	SetWindowBits( WB_HIDESELECTION | WB_HSCROLL );
//STRIP001 
//STRIP001 	SetEntryHeight( 16 );
//STRIP001 	SetSelectionMode( SINGLE_SELECTION );
//STRIP001 	SetSpaceBetweenEntries( 2 );
//STRIP001 	SetNodeBitmaps( aClosedBookImage, aOpenBookImage );
//STRIP001 
//STRIP001 	SetSublistOpenWithReturn();
//STRIP001 	SetSublistOpenWithLeftRight();
//STRIP001 
//STRIP001 	InitRoot();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 ContentListBox_Impl::~ContentListBox_Impl()
//STRIP001 {
//STRIP001 	USHORT nPos = 0;
//STRIP001 	SvLBoxEntry* pEntry = GetEntry( nPos++ );
//STRIP001 	while ( pEntry )
//STRIP001 	{
//STRIP001 		::rtl::OUString aTemp( GetEntryText( pEntry ) );
//STRIP001 		ClearChildren( pEntry );
//STRIP001 		delete (ContentEntry_Impl*)pEntry->GetUserData();
//STRIP001 		pEntry = GetEntry( nPos++ );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void ContentListBox_Impl::InitRoot()
//STRIP001 {
//STRIP001 	String aHelpTreeviewURL( DEFINE_CONST_UNICODE("vnd.sun.star.hier://com.sun.star.help.TreeView/") );
//STRIP001 	::com::sun::star::uno::Sequence< ::rtl::OUString > aList =
//STRIP001 		SfxContentHelper::GetHelpTreeViewContents( aHelpTreeviewURL );
//STRIP001 
//STRIP001 	const ::rtl::OUString* pEntries  = aList.getConstArray();
//STRIP001 	UINT32 i, nCount = aList.getLength();
//STRIP001 	for ( i = 0; i < nCount; ++i )
//STRIP001 	{
//STRIP001 		String aRow( pEntries[i] );
//STRIP001 		String aTitle, aURL;
//STRIP001 		xub_StrLen nIdx = 0;
//STRIP001 		aTitle = aRow.GetToken( 0, '\t', nIdx );
//STRIP001 		aURL = aRow.GetToken( 0, '\t', nIdx );
//STRIP001 		sal_Unicode cFolder = aRow.GetToken( 0, '\t', nIdx ).GetChar(0);
//STRIP001 		sal_Bool bIsFolder = ( '1' == cFolder );
//STRIP001 		SvLBoxEntry* pEntry = InsertEntry( aTitle, aOpenBookImage, aClosedBookImage, NULL, TRUE );
//STRIP001 		if ( bIsFolder )
//STRIP001 			pEntry->SetUserData( new ContentEntry_Impl( aURL, sal_True ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void ContentListBox_Impl::ClearChildren( SvLBoxEntry* pParent )
//STRIP001 {
//STRIP001 	SvLBoxEntry* pEntry = FirstChild( pParent );
//STRIP001 	while ( pEntry )
//STRIP001 	{
//STRIP001 		::rtl::OUString aTemp( GetEntryText( pEntry ) );
//STRIP001 		ClearChildren( pEntry );
//STRIP001 		delete (ContentEntry_Impl*)pEntry->GetUserData();
//STRIP001 		pEntry = NextSibling( pEntry );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void ContentListBox_Impl::RequestingChilds( SvLBoxEntry* pParent )
//STRIP001 {
//STRIP001 	try
//STRIP001 	{
//STRIP001 		if ( !pParent->HasChilds() )
//STRIP001 		{
//STRIP001 			if ( pParent->GetUserData() )
//STRIP001 			{
//STRIP001 				String aURL( ( (ContentEntry_Impl*)pParent->GetUserData()  )->aURL );
//STRIP001 				::com::sun::star::uno::Sequence< ::rtl::OUString > aList =
//STRIP001 					SfxContentHelper::GetHelpTreeViewContents( aURL );
//STRIP001 
//STRIP001 				const ::rtl::OUString* pEntries  = aList.getConstArray();
//STRIP001 				UINT32 i, nCount = aList.getLength();
//STRIP001 				for ( i = 0; i < nCount; ++i )
//STRIP001 				{
//STRIP001 					String aRow( pEntries[i] );
//STRIP001 					String aTitle, aURL;
//STRIP001 					xub_StrLen nIdx = 0;
//STRIP001 					aTitle = aRow.GetToken( 0, '\t', nIdx );
//STRIP001 					aURL = aRow.GetToken( 0, '\t', nIdx );
//STRIP001 					sal_Unicode cFolder = aRow.GetToken( 0, '\t', nIdx ).GetChar(0);
//STRIP001 					sal_Bool bIsFolder = ( '1' == cFolder );
//STRIP001 					SvLBoxEntry* pEntry = NULL;
//STRIP001 					if ( bIsFolder )
//STRIP001 					{
//STRIP001 						pEntry = InsertEntry( aTitle, aOpenChapterImage, aClosedChapterImage, pParent, TRUE );
//STRIP001 						pEntry->SetUserData( new ContentEntry_Impl( aURL, sal_True ) );
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						pEntry = InsertEntry( aTitle, aDocumentImage, aDocumentImage, pParent );
//STRIP001                     	Any aAny( ::utl::UCBContentHelper::GetProperty( aURL, String(RTL_CONSTASCII_USTRINGPARAM("TargetURL" ) ) ) );
//STRIP001 						::rtl::OUString aTargetURL;
//STRIP001 						if ( aAny >>=  aTargetURL )
//STRIP001 							pEntry->SetUserData( new ContentEntry_Impl( aTargetURL, sal_False ) );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch( Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERROR( "ContentListBox_Impl::RequestingChilds(): unexpected exception" );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long ContentListBox_Impl::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	sal_Bool bHandled = sal_False;
//STRIP001 	if ( rNEvt.GetType() == EVENT_KEYINPUT &&
//STRIP001 		 KEY_RETURN == rNEvt.GetKeyEvent()->GetKeyCode().GetCode() )
//STRIP001 	{
//STRIP001 		GetDoubleClickHdl().Call( NULL );
//STRIP001 		bHandled = sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bHandled ? 1 : SvTreeListBox::Notify( rNEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 String ContentListBox_Impl::GetSelectEntry() const
//STRIP001 {
//STRIP001 	String aRet;
//STRIP001 	SvLBoxEntry* pEntry = FirstSelected();
//STRIP001 	if ( pEntry && !( (ContentEntry_Impl*)pEntry->GetUserData()  )->bIsFolder )
//STRIP001 		aRet = ( (ContentEntry_Impl*)pEntry->GetUserData() )->aURL;
//STRIP001 	return aRet;
//STRIP001 }
//STRIP001 
//STRIP001 // class HelpTabPage_Impl ------------------------------------------------
//STRIP001 
//STRIP001 HelpTabPage_Impl::HelpTabPage_Impl( Window* pParent, const ResId& rResId ) :
//STRIP001 
//STRIP001 	TabPage( pParent, rResId )
//STRIP001 
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // class ContentTabPage_Impl ---------------------------------------------
//STRIP001 
//STRIP001 ContentTabPage_Impl::ContentTabPage_Impl( Window* pParent ) :
//STRIP001 
//STRIP001 	HelpTabPage_Impl( pParent, SfxResId( TP_HELP_CONTENT ) ),
//STRIP001 
//STRIP001 	aContentBox( this, ResId( LB_CONTENTS ) )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	aContentBox.Show();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void ContentTabPage_Impl::Resize()
//STRIP001 {
//STRIP001 	Size aSize = GetOutputSizePixel();
//STRIP001 	aSize.Width() -= 8;
//STRIP001 	aSize.Height() -= 8;
//STRIP001 	aContentBox.SetPosSizePixel( Point( 4, 4 ), aSize );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void ContentTabPage_Impl::ActivatePage()
//STRIP001 {
//STRIP001 	SetFocusOnBox();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 Control* ContentTabPage_Impl::GetLastFocusControl()
//STRIP001 {
//STRIP001 	return &aContentBox;
//STRIP001 }
//STRIP001 
//STRIP001 // class IndexBox_Impl ---------------------------------------------------
//STRIP001 
//STRIP001 IndexBox_Impl::IndexBox_Impl( Window* pParent, const ResId& rResId ) :
//STRIP001 
//STRIP001 	::com::boBox( pParent, rResId )
//STRIP001 
//STRIP001 {
//STRIP001 	EnableAutocomplete( TRUE );
//STRIP001     EnableUserDraw( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IndexBox_Impl::UserDraw( const UserDrawEvent& rUDEvt )
//STRIP001 {
//STRIP001 	IndexEntry_Impl* pEntry = (IndexEntry_Impl*)(ULONG)GetEntryData( rUDEvt.GetItemId() );
//STRIP001 	if ( pEntry && pEntry->m_bSubEntry )
//STRIP001 	{
//STRIP001 		// indent sub entries
//STRIP001 		Point aPos( rUDEvt.GetRect().TopLeft() );
//STRIP001 		aPos.X() += 8;
//STRIP001 		aPos.Y() += ( rUDEvt.GetRect().GetHeight() - rUDEvt.GetDevice()->GetTextHeight() ) / 2;
//STRIP001 		String aEntry( GetEntry( rUDEvt.GetItemId() ) );
//STRIP001 		USHORT nPos = aEntry.Search( ';' );
//STRIP001 		rUDEvt.GetDevice()->DrawText( aPos, ( nPos != STRING_NOTFOUND ) ? aEntry.Copy( nPos + 1 ) : aEntry );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		DrawEntry( rUDEvt, FALSE, TRUE, TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long IndexBox_Impl::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	sal_Bool bHandled = sal_False;
//STRIP001 	if ( rNEvt.GetType() == EVENT_KEYINPUT &&
//STRIP001 		 KEY_RETURN == rNEvt.GetKeyEvent()->GetKeyCode().GetCode() )
//STRIP001 	{
//STRIP001 		SelectExecutableEntry();
//STRIP001 		GetDoubleClickHdl().Call( NULL );
//STRIP001 		bHandled = sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bHandled ? 1 : ComboBox::Notify( rNEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IndexBox_Impl::SelectExecutableEntry()
//STRIP001 {
//STRIP001 	sal_Bool bSelectNew = sal_False;
//STRIP001 	USHORT nPos = GetEntryPos( GetText() );
//STRIP001 	if ( nPos != COMBOBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		USHORT nOldPos = nPos;
//STRIP001 		String aEntryText;
//STRIP001 		IndexEntry_Impl* pEntry = (IndexEntry_Impl*)(ULONG)GetEntryData( nPos );
//STRIP001 		USHORT nCount = GetEntryCount();
//STRIP001 		while ( nPos < nCount && ( !pEntry || pEntry->m_aURL.Len() == 0 ) )
//STRIP001 		{
//STRIP001 			pEntry = (IndexEntry_Impl*)(ULONG)GetEntryData( ++nPos );
//STRIP001 			aEntryText = GetEntry( nPos );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( nOldPos != nPos )
//STRIP001 			SetText( aEntryText );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // class IndexTabPage_Impl -----------------------------------------------
//STRIP001 
//STRIP001 IndexTabPage_Impl::IndexTabPage_Impl( Window* pParent ) :
//STRIP001 
//STRIP001 	HelpTabPage_Impl( pParent, SfxResId( TP_HELP_INDEX ) ),
//STRIP001 
//STRIP001 	aExpressionFT	( this, ResId( FT_EXPRESSION ) ),
//STRIP001 	aIndexCB		( this, ResId( CB_INDEX ) ),
//STRIP001 	aOpenBtn		( this, ResId( PB_OPEN_INDEX ) ),
//STRIP001 
//STRIP001 	bIsActivated	( sal_False )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	aOpenBtn.SetClickHdl( LINK( this, IndexTabPage_Impl, OpenHdl ) );
//STRIP001 	Link aTimeoutLink = LINK( this, IndexTabPage_Impl, TimeoutHdl );
//STRIP001 	aFactoryTimer.SetTimeoutHdl( aTimeoutLink );
//STRIP001 	aFactoryTimer.SetTimeout( 300 );
//STRIP001 	aKeywordTimer.SetTimeoutHdl( aTimeoutLink );
//STRIP001 	aFactoryTimer.SetTimeout( 300 );
//STRIP001 
//STRIP001 	nMinWidth = aOpenBtn.GetSizePixel().Width();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IndexTabPage_Impl::~IndexTabPage_Impl()
//STRIP001 {
//STRIP001 	ClearIndex();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 namespace sfx2 {
//STRIP001 
//STRIP001 	struct equalOUString
//STRIP001 	{
//STRIP001 		bool operator()( const ::rtl::OUString& rKey1, const ::rtl::OUString& rKey2 ) const
//STRIP001 		{
//STRIP001 			return !!( rKey1 == rKey2 );
//STRIP001 		}
//STRIP001 	};
//STRIP001 
//STRIP001 
//STRIP001 	struct hashOUString
//STRIP001 	{
//STRIP001 		size_t operator()( const ::rtl::OUString& rName ) const
//STRIP001 		{
//STRIP001 			return rName.hashCode();
//STRIP001 		}
//STRIP001 	};
//STRIP001 
//STRIP001 	typedef ::std::hash_map< ::rtl::OUString, int, hashOUString, equalOUString > KeywordInfo;
//STRIP001 }
//STRIP001 
//STRIP001 #define UNIFY_AND_INSERT_TOKEN( aToken )															\
//STRIP001     it =																							\
//STRIP001     aInfo.insert( sfx2::KeywordInfo::value_type( aToken, 0 ) ).first;								\
//STRIP001     if ( ( tmp = it->second++ ) != 0 )																\
//STRIP001        nPos = aIndexCB.InsertEntry( aToken + ::rtl::OUString( append, tmp ) );						\
//STRIP001     else																							\
//STRIP001        nPos = aIndexCB.InsertEntry( aToken )
//STRIP001 
//STRIP001 #define INSERT_DATA( j )																			\
//STRIP001 	if ( aAnchorList[j].getLength() > 0 )															\
//STRIP001 	{																								\
//STRIP001 		aData.append( aRefList[j] ).append( sal_Unicode('#') ).append( aAnchorList[j] );			\
//STRIP001 		aIndexCB.SetEntryData( nPos, NEW_ENTRY( aData.makeStringAndClear(), insert ) );				\
//STRIP001 	}																								\
//STRIP001 	else																							\
//STRIP001 		aIndexCB.SetEntryData( nPos, NEW_ENTRY( aRefList[j], insert ) );
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IndexTabPage_Impl::InitializeIndex()
//STRIP001 {
//STRIP001 	WaitObject( this );
//STRIP001 
//STRIP001 	// By now more than 256 equal entries are not allowed
//STRIP001 	sal_Unicode append[256];
//STRIP001 	for( int k = 0; k < 256; ++k )
//STRIP001 		append[k] = sal_Unicode( ' ' );
//STRIP001 
//STRIP001 	sfx2::KeywordInfo aInfo;
//STRIP001 	aIndexCB.SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		::rtl::OUString aURL = HELP_URL;
//STRIP001 		aURL += ::rtl::OUString( sFactory );
//STRIP001 
//STRIP001 		String aTemp = aURL;
//STRIP001 		AppendConfigToken_Impl( aTemp, sal_True );
//STRIP001 		aURL = aTemp;
//STRIP001 
//STRIP001 		Content aCnt( aURL, Reference< ::com::sun::star::ucb::XCommandEnvironment > () );
//STRIP001 		::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySetInfo > xInfo = aCnt.getProperties();
//STRIP001 		if ( xInfo->hasPropertyByName( PROPERTY_ANCHORREF ) )
//STRIP001 		{
//STRIP001 			::com::sun::star::uno::Sequence< ::rtl::OUString > aPropSeq( 4 );
//STRIP001 			aPropSeq[0] = PROPERTY_KEYWORDLIST;
//STRIP001 			aPropSeq[1] = PROPERTY_KEYWORDREF;
//STRIP001 			aPropSeq[2] = PROPERTY_ANCHORREF;
//STRIP001 			aPropSeq[3] = PROPERTY_TITLEREF;
//STRIP001 
//STRIP001 			// abi: use one possibly remote call only
//STRIP001 			::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any > aAnySeq =
//STRIP001 				  aCnt.getPropertyValues( aPropSeq );
//STRIP001 
//STRIP001 			::com::sun::star::uno::Sequence< ::rtl::OUString > aKeywordList;
//STRIP001 			::com::sun::star::uno::Sequence< ::com::sun::star::uno::Sequence< ::rtl::OUString > > aKeywordRefList;
//STRIP001 			::com::sun::star::uno::Sequence< ::com::sun::star::uno::Sequence< ::rtl::OUString > > aAnchorRefList;
//STRIP001 			::com::sun::star::uno::Sequence< ::com::sun::star::uno::Sequence< ::rtl::OUString > > aTitleRefList;
//STRIP001 
//STRIP001 			if ( ( aAnySeq[0] >>= aKeywordList ) && ( aAnySeq[1] >>= aKeywordRefList ) &&
//STRIP001 				 ( aAnySeq[2] >>= aAnchorRefList ) && ( aAnySeq[3] >>= aTitleRefList ) )
//STRIP001 			{
//STRIP001 				sal_Bool insert;
//STRIP001 				USHORT nPos;
//STRIP001 				int ndx,tmp;
//STRIP001 				::rtl::OUString aIndex, aTempString;
//STRIP001 				::rtl::OUStringBuffer aData( 128 );            // Capacity of up to 128 characters
//STRIP001 				sfx2::KeywordInfo::iterator it;
//STRIP001 
//STRIP001 				for ( int i = 0; i < aKeywordList.getLength(); ++i )
//STRIP001 				{
//STRIP001 					// abi: Do not copy, but use references
//STRIP001 					const ::rtl::OUString& aKeywordPair = aKeywordList[i];
//STRIP001 					DBG_ASSERT( aKeywordPair.getLength() > 0, "invalid help index" );
//STRIP001 					const ::com::sun::star::uno::Sequence< ::rtl::OUString >& aRefList = aKeywordRefList[i];
//STRIP001 					const ::com::sun::star::uno::Sequence< ::rtl::OUString >& aAnchorList = aAnchorRefList[i];
//STRIP001 					const ::com::sun::star::uno::Sequence< ::rtl::OUString >& aTitleList = aTitleRefList[i];
//STRIP001 
//STRIP001 					DBG_ASSERT( aRefList.getLength() == aAnchorList.getLength(),"reference list and title list of different length" );
//STRIP001 
//STRIP001 					insert = ( ( ndx = aKeywordPair.indexOf( sal_Unicode( ';' ) ) ) == -1 ? sal_False : sal_True );
//STRIP001 
//STRIP001 					if ( insert )
//STRIP001 					{
//STRIP001 						aTempString = aKeywordPair.copy( 0, ndx );
//STRIP001 						if ( aIndex != aTempString )
//STRIP001 						{
//STRIP001 							aIndex = aTempString;
//STRIP001 							UNIFY_AND_INSERT_TOKEN( aTempString );
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else
//STRIP001 						aIndex = ::rtl::OUString();
//STRIP001 
//STRIP001 					// Assume the token is trimed
//STRIP001 					UNIFY_AND_INSERT_TOKEN( aKeywordPair );
//STRIP001 
//STRIP001 					sal_uInt32 nRefListLen = aRefList.getLength();
//STRIP001 
//STRIP001 					DBG_ASSERT( aAnchorList.getLength(), "*IndexTabPage_Impl::InitializeIndex(): AnchorList is empty!" );			\
//STRIP001 					DBG_ASSERT( nRefListLen, "*IndexTabPage_Impl::InitializeIndex(): RefList is empty!" );			\
//STRIP001 
//STRIP001 					if ( aAnchorList.getLength() && nRefListLen )
//STRIP001 					{
//STRIP001 						INSERT_DATA( 0 );
//STRIP001 					}
//STRIP001 
//STRIP001 					for ( sal_uInt32 j = 1; j < nRefListLen ; ++j )
//STRIP001 					{
//STRIP001 						aData
//STRIP001 							.append( aKeywordPair )
//STRIP001 							.append( sal_Unicode(' ') )
//STRIP001 							.append( sal_Unicode('-') )
//STRIP001 							.append( sal_Unicode(' ') )
//STRIP001 							.append( aTitleList[j] );
//STRIP001 
//STRIP001 						aTempString = aData.makeStringAndClear();
//STRIP001 						UNIFY_AND_INSERT_TOKEN( aTempString );
//STRIP001 						INSERT_DATA( j );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch( Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERROR( "IndexTabPage_Impl::InitializeIndex(): unexpected exception" );
//STRIP001 	}
//STRIP001 
//STRIP001 	aIndexCB.SetUpdateMode( TRUE );
//STRIP001 
//STRIP001 	if ( sKeyword.Len() > 0 )
//STRIP001 		aKeywordLink.Call( this );
//STRIP001 }
//STRIP001 
//STRIP001 #undef INSERT_DATA
//STRIP001 #undef UNIFY_AND_INSERT_TOKEN
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IndexTabPage_Impl::ClearIndex()
//STRIP001 {
//STRIP001 	USHORT nCount = aIndexCB.GetEntryCount();
//STRIP001 	for ( USHORT i = 0; i < nCount; ++i )
//STRIP001 		delete (IndexEntry_Impl*)(ULONG)aIndexCB.GetEntryData(i);
//STRIP001 	aIndexCB.Clear();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( IndexTabPage_Impl, OpenHdl, PushButton*, EMPTYARG )
//STRIP001 {
//STRIP001 	aIndexCB.SelectExecutableEntry();
//STRIP001 	aIndexCB.GetDoubleClickHdl().Call( &aIndexCB );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( IndexTabPage_Impl, TimeoutHdl, Timer*, pTimer )
//STRIP001 {
//STRIP001 	if ( &aFactoryTimer == pTimer )
//STRIP001 		InitializeIndex();
//STRIP001 	else if ( &aKeywordTimer == pTimer && sKeyword.Len() > 0 )
//STRIP001 		aKeywordLink.Call( this );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IndexTabPage_Impl::Resize()
//STRIP001 {
//STRIP001 	Size aSize = GetSizePixel();
//STRIP001 	if ( aSize.Width() < nMinWidth )
//STRIP001 		aSize.Width() = nMinWidth;
//STRIP001 	Point aPnt = aExpressionFT.GetPosPixel();
//STRIP001 	long nDelta = ( aPnt.X() / 2 );
//STRIP001 	Size aNewSize = aExpressionFT.GetSizePixel();
//STRIP001 	aNewSize.Width() = aSize.Width() - ( aPnt.X() * 2 );
//STRIP001 	aExpressionFT.SetSizePixel( aNewSize );
//STRIP001 
//STRIP001 	Size a6Size = LogicToPixel( Size( 6, 6 ), MAP_APPFONT );
//STRIP001 	Size aBtnSize = aOpenBtn.GetSizePixel();
//STRIP001 
//STRIP001 	aPnt = aIndexCB.GetPosPixel();
//STRIP001 	aNewSize = aIndexCB.GetSizePixel();
//STRIP001 	aNewSize.Width() = aSize.Width() - ( aPnt.X() * 2 );
//STRIP001 	aNewSize.Height() = aSize.Height() - aPnt.Y();
//STRIP001 	aNewSize.Height() -= ( aBtnSize.Height() + ( a6Size.Height() * 3 / 2 ) );
//STRIP001 	aIndexCB.SetSizePixel( aNewSize );
//STRIP001 
//STRIP001 	aPnt.X() += ( aNewSize.Width() - aBtnSize.Width() );
//STRIP001 	aPnt.Y() += aNewSize.Height() + ( a6Size.Height() / 2 );
//STRIP001 	long nMinX = aIndexCB.GetPosPixel().X();
//STRIP001 	if ( aPnt.X() < nMinX )
//STRIP001 		aPnt.X() = nMinX;
//STRIP001 	aOpenBtn.SetPosPixel( aPnt );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IndexTabPage_Impl::ActivatePage()
//STRIP001 {
//STRIP001 	if ( !bIsActivated )
//STRIP001 	{
//STRIP001 		bIsActivated = sal_True;
//STRIP001 		aFactoryTimer.Start();
//STRIP001 	}
//STRIP001 
//STRIP001 	SetFocusOnBox();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 Control* IndexTabPage_Impl::GetLastFocusControl()
//STRIP001 {
//STRIP001 	return &aOpenBtn;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IndexTabPage_Impl::SetDoubleClickHdl( const Link& rLink )
//STRIP001 {
//STRIP001 	aIndexCB.SetDoubleClickHdl( rLink );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IndexTabPage_Impl::SetFactory( const String& rFactory )
//STRIP001 {
//STRIP001 	DBG_ASSERT( rFactory.Len() > 0, "empty factory" );
//STRIP001 
//STRIP001 	if ( rFactory != sFactory )
//STRIP001 	{
//STRIP001 		sFactory = rFactory;
//STRIP001 		ClearIndex();
//STRIP001 		if ( bIsActivated )
//STRIP001 			aFactoryTimer.Start();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 String IndexTabPage_Impl::GetSelectEntry() const
//STRIP001 {
//STRIP001 	String aRet;
//STRIP001 	IndexEntry_Impl* pEntry = (IndexEntry_Impl*)(ULONG)aIndexCB.GetEntryData( aIndexCB.GetEntryPos( aIndexCB.GetText() ) );
//STRIP001 	if ( pEntry )
//STRIP001 		aRet = pEntry->m_aURL;
//STRIP001 	return aRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IndexTabPage_Impl::SetKeyword( const String& rKeyword )
//STRIP001 {
//STRIP001 	sKeyword = rKeyword;
//STRIP001 
//STRIP001 	if ( aIndexCB.GetEntryCount() > 0 )
//STRIP001 		aKeywordTimer.Start();
//STRIP001 	else if ( !bIsActivated )
//STRIP001 		aFactoryTimer.Start();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool IndexTabPage_Impl::HasKeyword() const
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001 	if ( sKeyword.Len() > 0 )
//STRIP001 	{
//STRIP001 		USHORT nPos = aIndexCB.GetEntryPos( sKeyword );
//STRIP001 		bRet = ( nPos != LISTBOX_ENTRY_NOTFOUND );
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 //added by BerryJia for fixing Bug98251, 2002-12-11
//STRIP001 sal_Bool IndexTabPage_Impl::HasKeywordIgnoreCase()
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001 	if ( sKeyword.Len() > 0 )
//STRIP001 	{
//STRIP001 		USHORT nEntries = aIndexCB.GetEntryCount();
//STRIP001 		String sIndexItem;
//STRIP001 		const vcl::I18nHelper& rI18nHelper = GetSettings().GetLocaleI18nHelper();
//STRIP001 		for ( USHORT n = 0; n < nEntries; n++)
//STRIP001 		{
//STRIP001 			sIndexItem = aIndexCB.GetEntry( n );
//STRIP001 			if (rI18nHelper.MatchString( sIndexItem, sKeyword ))
//STRIP001 			{
//STRIP001 				sKeyword = sIndexItem;
//STRIP001 				bRet = sal_True;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IndexTabPage_Impl::OpenKeyword()
//STRIP001 {
//STRIP001 	if ( sKeyword.Len() > 0 )
//STRIP001 	{
//STRIP001 		aIndexCB.SetText( sKeyword );
//STRIP001 		aIndexCB.GetDoubleClickHdl().Call( NULL );
//STRIP001 		sKeyword.Erase();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // class SearchBox_Impl --------------------------------------------------
//STRIP001 
//STRIP001 long SearchBox_Impl::PreNotify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	sal_Bool bHandled = sal_False;
//STRIP001 	if ( !IsInDropDown() &&
//STRIP001 		 rNEvt.GetWindow() == GetSubEdit() &&
//STRIP001 		 rNEvt.GetType() == EVENT_KEYINPUT &&
//STRIP001 		 KEY_RETURN == rNEvt.GetKeyEvent()->GetKeyCode().GetCode() )
//STRIP001 	{
//STRIP001 		aSearchLink.Call( NULL );
//STRIP001 		bHandled = sal_True;
//STRIP001 	}
//STRIP001 	return bHandled ? 1 : ComboBox::PreNotify( rNEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SearchBox_Impl::Select()
//STRIP001 {
//STRIP001 	if ( !IsTravelSelect() )
//STRIP001 		aSearchLink.Call( NULL );
//STRIP001 }
//STRIP001 
//STRIP001 // class SearchResultsBox_Impl -------------------------------------------
//STRIP001 
//STRIP001 long SearchResultsBox_Impl::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	sal_Bool bHandled = sal_False;
//STRIP001 	if ( rNEvt.GetType() == EVENT_KEYINPUT &&
//STRIP001 		 KEY_RETURN == rNEvt.GetKeyEvent()->GetKeyCode().GetCode() )
//STRIP001 	{
//STRIP001 		GetDoubleClickHdl().Call( NULL );
//STRIP001 		bHandled = sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bHandled ? 1 : ListBox::Notify( rNEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // class SearchTabPage_Impl ----------------------------------------------
//STRIP001 
//STRIP001 SearchTabPage_Impl::SearchTabPage_Impl( Window* pParent ) :
//STRIP001 
//STRIP001 	HelpTabPage_Impl( pParent, SfxResId( TP_HELP_SEARCH ) ),
//STRIP001 
//STRIP001 	aSearchFT		( this, ResId( FT_SEARCH ) ),
//STRIP001 	aSearchED		( this, ResId( ED_SEARCH ) ),
//STRIP001 	aSearchBtn		( this, ResId( PB_SEARCH ) ),
//STRIP001 	aFullWordsCB	( this, ResId( CB_FULLWORDS ) ),
//STRIP001 	aScopeCB		( this, ResId( CB_SCOPE ) ),
//STRIP001 	aResultsLB		( this, ResId( LB_RESULT ) ),
//STRIP001 	aOpenBtn		( this, ResId( PB_OPEN_SEARCH ) ),
//STRIP001 	xBreakIterator	( vcl::unohelper::CreateBreakIterator() )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	Link aLink = LINK( this, SearchTabPage_Impl, SearchHdl );
//STRIP001 	aSearchED.SetSearchLink( aLink );
//STRIP001 	aSearchBtn.SetClickHdl( aLink );
//STRIP001 	aSearchED.SetModifyHdl( LINK( this, SearchTabPage_Impl, ModifyHdl ) );
//STRIP001 	aOpenBtn.SetClickHdl( LINK( this, SearchTabPage_Impl, OpenHdl ) );
//STRIP001 
//STRIP001 	aMinSize = GetSizePixel();
//STRIP001 
//STRIP001 	SvtViewOptions aViewOpt( E_TABPAGE, CONFIGNAME_SEARCHPAGE );
//STRIP001 	if ( aViewOpt.Exists() )
//STRIP001 	{
//STRIP001 		String aUserData;
//STRIP001 		Any aUserItem = aViewOpt.GetUserItem( USERITEM_NAME );
//STRIP001 		::rtl::OUString aTemp;
//STRIP001 		if ( aUserItem >>= aTemp )
//STRIP001 		{
//STRIP001 			aUserData = String( aTemp );
//STRIP001 			BOOL bChecked = ( 1 == aUserData.GetToken(0).ToInt32() ) ? TRUE : FALSE;
//STRIP001 			aFullWordsCB.Check( bChecked );
//STRIP001 			bChecked = ( 1 == aUserData.GetToken(1).ToInt32() ) ? TRUE : FALSE;
//STRIP001 			aScopeCB.Check( bChecked );
//STRIP001 
//STRIP001 			for ( USHORT i = 2; i < aUserData.GetTokenCount(); ++i )
//STRIP001 			{
//STRIP001 				String aToken = aUserData.GetToken(i);
//STRIP001 				aSearchED.InsertEntry( INetURLObject::decode(
//STRIP001 					aToken, '%', INetURLObject::DECODE_WITH_CHARSET ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	ModifyHdl( &aSearchED );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SearchTabPage_Impl::~SearchTabPage_Impl()
//STRIP001 {
//STRIP001 	SvtViewOptions aViewOpt( E_TABPAGE, CONFIGNAME_SEARCHPAGE );
//STRIP001 	sal_Int32 nChecked = aFullWordsCB.IsChecked() ? 1 : 0;
//STRIP001 	String aUserData = String::CreateFromInt32( nChecked );
//STRIP001 	aUserData += ';';
//STRIP001 	nChecked = aScopeCB.IsChecked() ? 1 : 0;
//STRIP001 	aUserData += String::CreateFromInt32( nChecked );
//STRIP001 	aUserData += ';';
//STRIP001 	USHORT nCount = Min( aSearchED.GetEntryCount(), (USHORT)10 );  // save only 10 entries
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < nCount; ++i )
//STRIP001 	{
//STRIP001 		String aText = aSearchED.GetEntry(i);
//STRIP001 		aUserData += INetURLObject::encode(
//STRIP001 			aText, INetURLObject::PART_UNO_PARAM_VALUE, '%', INetURLObject::ENCODE_ALL );
//STRIP001 		aUserData += ';';
//STRIP001 	}
//STRIP001 
//STRIP001 	aUserData.EraseTrailingChars(';');
//STRIP001 	Any aUserItem = makeAny( ::rtl::OUString( aUserData ) );
//STRIP001 	aViewOpt.SetUserItem( USERITEM_NAME, aUserItem );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SearchTabPage_Impl::ClearSearchResults()
//STRIP001 {
//STRIP001 	USHORT nCount = aResultsLB.GetEntryCount();
//STRIP001 	for ( USHORT i = 0; i < nCount; ++i )
//STRIP001 		delete (String*)(ULONG)aResultsLB.GetEntryData(i);
//STRIP001 	aResultsLB.Clear();
//STRIP001 	aResultsLB.Update();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SearchTabPage_Impl::RememberSearchText( const String& rSearchText )
//STRIP001 {
//STRIP001 	for ( USHORT i = 0; i < aSearchED.GetEntryCount(); ++i )
//STRIP001 	{
//STRIP001 		if ( rSearchText == aSearchED.GetEntry(i) )
//STRIP001 		{
//STRIP001 			aSearchED.RemoveEntry(i);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	aSearchED.InsertEntry( rSearchText, 0 );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SearchTabPage_Impl, SearchHdl, PushButton*, EMPTYARG )
//STRIP001 {
//STRIP001 	String aSearchText = TRIM( aSearchED.GetText() );
//STRIP001 	if ( aSearchText.Len() > 0 )
//STRIP001 	{
//STRIP001 		EnterWait();
//STRIP001 		ClearSearchResults();
//STRIP001 		RememberSearchText( aSearchText );
//STRIP001 		String aSearchURL = HELP_URL;
//STRIP001 		aSearchURL += aFactory;
//STRIP001 		aSearchURL += String( HELP_SEARCH_TAG );
//STRIP001 		if ( !aFullWordsCB.IsChecked() )
//STRIP001 			aSearchText = sfx2::PrepareSearchString( aSearchText, xBreakIterator, true );
//STRIP001 		aSearchURL += aSearchText;
//STRIP001 		AppendConfigToken_Impl( aSearchURL, sal_False );
//STRIP001 		if ( aScopeCB.IsChecked() )
//STRIP001 			aSearchURL += DEFINE_CONST_UNICODE("&Scope=Heading");
//STRIP001 		Sequence< ::rtl::OUString > aFactories = SfxContentHelper::GetResultSet( aSearchURL );
//STRIP001 		const ::rtl::OUString* pFacs  = aFactories.getConstArray();
//STRIP001 		UINT32 i, nCount = aFactories.getLength();
//STRIP001 		for ( i = 0; i < nCount; ++i )
//STRIP001 		{
//STRIP001 			String aRow( pFacs[i] );
//STRIP001 			String aTitle, aType;
//STRIP001 			xub_StrLen nIdx = 0;
//STRIP001 			aTitle = aRow.GetToken( 0, '\t', nIdx );
//STRIP001 			aType = aRow.GetToken( 0, '\t', nIdx );
//STRIP001 			String* pURL = new String( aRow.GetToken( 0, '\t', nIdx ) );
//STRIP001 			USHORT nPos = aResultsLB.InsertEntry( aTitle );
//STRIP001 			aResultsLB.SetEntryData( nPos, (void*)(ULONG)pURL );
//STRIP001 		}
//STRIP001 		LeaveWait();
//STRIP001 
//STRIP001 		if ( !nCount )
//STRIP001 		{
//STRIP001 			InfoBox aBox( this, SfxResId( RID_INFO_NOSEARCHRESULTS ) );
//STRIP001 			aBox.SetText( String( SfxResId( STR_HELP_WINDOW_TITLE ) ) );
//STRIP001 			aBox.Execute();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SearchTabPage_Impl, OpenHdl, PushButton*, EMPTYARG )
//STRIP001 {
//STRIP001 	aResultsLB.GetDoubleClickHdl().Call( &aResultsLB );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SearchTabPage_Impl, ModifyHdl, Edit*, EMPTYARG )
//STRIP001 {
//STRIP001 	String aSearchText = TRIM( aSearchED.GetText() );
//STRIP001 	aSearchBtn.Enable( aSearchText.Len() > 0 );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SearchTabPage_Impl::Resize()
//STRIP001 {
//STRIP001 	Size a6Size = LogicToPixel( Size( 6, 6 ), MAP_APPFONT );
//STRIP001 	Size aSize = GetSizePixel();
//STRIP001 	if ( aSize.Width() < aMinSize.Width() )
//STRIP001 		aSize.Width() = aMinSize.Width();
//STRIP001 	Point aPnt = aSearchFT.GetPosPixel();
//STRIP001 	Size aNewSize = aSearchFT.GetSizePixel();
//STRIP001 	aNewSize.Width() = aSize.Width() - ( aPnt.X() * 2 );
//STRIP001 	aSearchFT.SetSizePixel( aNewSize );
//STRIP001 	aNewSize.Height() = aResultsLB.GetSizePixel().Height();
//STRIP001 	aResultsLB.SetSizePixel( aNewSize );
//STRIP001 	aNewSize = aSearchED.GetSizePixel();
//STRIP001 	aNewSize.Width() = aSize.Width() - ( aPnt.X() * 2 ) -
//STRIP001 					   ( aSearchBtn.GetSizePixel().Width() + ( aPnt.X() / 2 ) );
//STRIP001 	aSearchED.SetSizePixel( aNewSize );
//STRIP001 	Point aNewPnt = aSearchBtn.GetPosPixel();
//STRIP001 	aNewPnt.X() = aPnt.X() + aNewSize.Width() + ( aPnt.X() / 2 );
//STRIP001 	aSearchBtn.SetPosPixel( aNewPnt );
//STRIP001 
//STRIP001 	if ( aSize.Height() > aMinSize.Height() )
//STRIP001 	{
//STRIP001 		long n3Height = a6Size.Height() / 2;
//STRIP001 		Size aBtnSize = aOpenBtn.GetSizePixel();
//STRIP001 		long nExtraHeight = aBtnSize.Height() + n3Height;
//STRIP001 
//STRIP001 		Point aPnt = aResultsLB.GetPosPixel();
//STRIP001 		Size aNewSize = aResultsLB.GetSizePixel();
//STRIP001 		aNewSize.Height() = aSize.Height() - aPnt.Y();
//STRIP001 		aNewSize.Height() -= ( nExtraHeight + ( a6Size.Height() * 3 / 2 ) );
//STRIP001 		aResultsLB.SetSizePixel( aNewSize );
//STRIP001 
//STRIP001 		aPnt.X() += ( aNewSize.Width() - aBtnSize.Width() );
//STRIP001 		aPnt.Y() += aNewSize.Height() + a6Size.Height();
//STRIP001 		aOpenBtn.SetPosPixel( aPnt );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SearchTabPage_Impl::ActivatePage()
//STRIP001 {
//STRIP001 	aSearchED.GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 Control* SearchTabPage_Impl::GetLastFocusControl()
//STRIP001 {
//STRIP001 	return &aOpenBtn;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SearchTabPage_Impl::SetDoubleClickHdl( const Link& rLink )
//STRIP001 {
//STRIP001 	aResultsLB.SetDoubleClickHdl( rLink );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 String SearchTabPage_Impl::GetSelectEntry() const
//STRIP001 {
//STRIP001 	String aRet;
//STRIP001 	String* pData = (String*)(ULONG)aResultsLB.GetEntryData( aResultsLB.GetSelectEntryPos() );
//STRIP001 	if ( pData )
//STRIP001 		aRet = String( *pData );
//STRIP001 	return aRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SearchTabPage_Impl::ClearPage()
//STRIP001 {
//STRIP001 	ClearSearchResults();
//STRIP001 	aSearchED.SetText( String() );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SearchTabPage_Impl::OpenKeyword( const String& rKeyword )
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001 	aSearchED.SetText( rKeyword );
//STRIP001 	SearchHdl( NULL );
//STRIP001 	if ( aResultsLB.GetEntryCount() > 0 )
//STRIP001 	{
//STRIP001 		// found keyword -> open it
//STRIP001 		aResultsLB.SelectEntryPos(0);
//STRIP001 		OpenHdl( NULL );
//STRIP001 		bRet = sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // class BookmarksTabPage_Impl -------------------------------------------
//STRIP001 
//STRIP001 void GetBookmarkEntry_Impl
//STRIP001 (
//STRIP001 	Sequence< PropertyValue >& aBookmarkEntry,
//STRIP001 	::rtl::OUString& rTitle,
//STRIP001 	::rtl::OUString& rURL
//STRIP001 )
//STRIP001 {
//STRIP001 	for ( int i = 0; i < aBookmarkEntry.getLength(); i++ )
//STRIP001 	{
//STRIP001 		PropertyValue aValue = aBookmarkEntry[i];
//STRIP001 		if ( aValue.Name == HISTORY_PROPERTYNAME_URL )
//STRIP001 			aValue.Value >>= rURL;
//STRIP001 		else if ( aValue.Name == HISTORY_PROPERTYNAME_TITLE )
//STRIP001 			aValue.Value >>= rTitle;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BookmarksBox_Impl::BookmarksBox_Impl( Window* pParent, const ResId& rResId ) :
//STRIP001 
//STRIP001 	ListBox( pParent, rResId )
//STRIP001 
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BookmarksBox_Impl::~BookmarksBox_Impl()
//STRIP001 {
//STRIP001 	// save bookmarks to configuration
//STRIP001 	SvtHistoryOptions aHistOpt;
//STRIP001 	aHistOpt.Clear( eHELPBOOKMARKS );
//STRIP001 	::rtl::OUString sEmpty;
//STRIP001 	USHORT nCount = GetEntryCount();
//STRIP001 	for ( USHORT i = 0; i < nCount; ++i )
//STRIP001 	{
//STRIP001 		String aTitle = GetEntry(i);
//STRIP001 		String* pURL = (String*)(ULONG)GetEntryData(i);
//STRIP001 		aHistOpt.AppendItem( eHELPBOOKMARKS, ::rtl::OUString( *pURL ), sEmpty, ::rtl::OUString( aTitle ), sEmpty );
//STRIP001 		delete pURL;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void BookmarksBox_Impl::DoAction( USHORT nAction )
//STRIP001 {
//STRIP001 	switch ( nAction )
//STRIP001 	{
//STRIP001 		case MID_OPEN :
//STRIP001 			GetDoubleClickHdl().Call( NULL );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case MID_RENAME :
//STRIP001 	   	{
//STRIP001 			USHORT nPos = GetSelectEntryPos();
//STRIP001 			if ( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 			{
//STRIP001 				SfxAddHelpBookmarkDialog_Impl aDlg( this, sal_True );
//STRIP001 				aDlg.SetTitle( GetEntry( nPos ) );
//STRIP001 				if ( aDlg.Execute() == RET_OK )
//STRIP001 				{
//STRIP001 					String* pURL = (String*)(ULONG)GetEntryData( nPos );
//STRIP001 					RemoveEntry( nPos );
//STRIP001 					String aImageURL = IMAGE_URL;
//STRIP001 					aImageURL += INetURLObject( *pURL ).GetHost();
//STRIP001 					nPos = InsertEntry( aDlg.GetTitle(), SvFileInformationManager::GetImage( aImageURL ) );
//STRIP001 					SetEntryData( nPos, (void*)(ULONG)( new String( *pURL ) ) );
//STRIP001 					SelectEntryPos( nPos );
//STRIP001 					delete pURL;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case MID_DELETE :
//STRIP001 		{
//STRIP001 			USHORT nPos = GetSelectEntryPos();
//STRIP001 			if ( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 			{
//STRIP001 				RemoveEntry( nPos );
//STRIP001 				USHORT nCount = GetEntryCount();
//STRIP001 				if ( nCount )
//STRIP001 				{
//STRIP001 					if ( nPos >= nCount )
//STRIP001 						nPos = nCount - 1;
//STRIP001 					SelectEntryPos( nPos );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long BookmarksBox_Impl::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	long nRet = 0;
//STRIP001 	USHORT nType = rNEvt.GetType();
//STRIP001 	if ( EVENT_KEYINPUT == nType )
//STRIP001 	{
//STRIP001 		USHORT nCode = rNEvt.GetKeyEvent()->GetKeyCode().GetCode();
//STRIP001 		if ( KEY_DELETE == nCode && GetEntryCount() > 0 )
//STRIP001 		{
//STRIP001 			DoAction( MID_DELETE );
//STRIP001 			nRet = 1;
//STRIP001 		}
//STRIP001 		else if ( KEY_RETURN == nCode )
//STRIP001 		{
//STRIP001 			GetDoubleClickHdl().Call( NULL );
//STRIP001 			nRet = 1;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( EVENT_COMMAND == nType )
//STRIP001 	{
//STRIP001 		const CommandEvent* pCEvt = rNEvt.GetCommandEvent();
//STRIP001 		if ( pCEvt->GetCommand() == COMMAND_CONTEXTMENU )
//STRIP001 		{
//STRIP001 			PopupMenu aMenu( SfxResId( MENU_HELP_BOOKMARKS ) );
//STRIP001             sal_uInt16 nId = aMenu.Execute( this, pCEvt->GetMousePosPixel() );
//STRIP001 			if ( nId != MENU_ITEM_NOTFOUND )
//STRIP001 				DoAction( nId );
//STRIP001 			nRet = 1;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet ? nRet : ListBox::Notify( rNEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // class BookmarksTabPage_Impl -------------------------------------------
//STRIP001 
//STRIP001 BookmarksTabPage_Impl::BookmarksTabPage_Impl( Window* pParent ) :
//STRIP001 
//STRIP001 	HelpTabPage_Impl( pParent, SfxResId( TP_HELP_BOOKMARKS ) ),
//STRIP001 
//STRIP001 	aBookmarksFT	( this, ResId( FT_BOOKMARKS ) ),
//STRIP001 	aBookmarksBox	( this, ResId( LB_BOOKMARKS ) ),
//STRIP001 	aBookmarksPB	( this, ResId( PB_BOOKMARKS ) )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	nMinWidth = aBookmarksPB.GetSizePixel().Width();
//STRIP001 
//STRIP001 	aBookmarksPB.SetClickHdl( LINK( this, BookmarksTabPage_Impl, OpenHdl ) );
//STRIP001 
//STRIP001 	// load bookmarks from configuration
//STRIP001 	Sequence< Sequence< PropertyValue > > aBookmarkSeq;
//STRIP001 	aBookmarkSeq = SvtHistoryOptions().GetList( eHELPBOOKMARKS );
//STRIP001 
//STRIP001 	::rtl::OUString aTitle;
//STRIP001 	::rtl::OUString aURL;
//STRIP001 
//STRIP001 	UINT32 i, nCount = aBookmarkSeq.getLength();
//STRIP001 	for ( i = 0; i < nCount; ++i )
//STRIP001 	{
//STRIP001 		GetBookmarkEntry_Impl( aBookmarkSeq[i], aTitle, aURL );
//STRIP001 		AddBookmarks( aTitle, aURL );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( BookmarksTabPage_Impl, OpenHdl, PushButton*, EMPTYARG )
//STRIP001 {
//STRIP001 	aBookmarksBox.GetDoubleClickHdl().Call( &aBookmarksBox );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void BookmarksTabPage_Impl::Resize()
//STRIP001 {
//STRIP001 	Size aSize = GetSizePixel();
//STRIP001 	if ( aSize.Width() < nMinWidth )
//STRIP001 		aSize.Width() = nMinWidth;
//STRIP001 	Point aPnt = aBookmarksFT.GetPosPixel();
//STRIP001 	long nDelta = ( aPnt.X() / 2 );
//STRIP001 	Size aNewSize = aBookmarksFT.GetSizePixel();
//STRIP001 	aNewSize.Width() = aSize.Width() - ( aPnt.X() * 2 );
//STRIP001 	aBookmarksFT.SetSizePixel( aNewSize );
//STRIP001 
//STRIP001 	Size a6Size = LogicToPixel( Size( 6, 6 ), MAP_APPFONT );
//STRIP001 	Size aBtnSize = aBookmarksPB.GetSizePixel();
//STRIP001 
//STRIP001 	aPnt = aBookmarksBox.GetPosPixel();
//STRIP001 	aNewSize = aBookmarksBox.GetSizePixel();
//STRIP001 	aNewSize.Width() = aSize.Width() - ( aPnt.X() * 2 );
//STRIP001 	aNewSize.Height() = aSize.Height() - aPnt.Y();
//STRIP001 	aNewSize.Height() -= ( aBtnSize.Height() + ( a6Size.Height() * 3 / 2 ) );
//STRIP001 	aBookmarksBox.SetSizePixel( aNewSize );
//STRIP001 
//STRIP001 	aPnt.X() += ( aNewSize.Width() - aBtnSize.Width() );
//STRIP001 	aPnt.Y() += aNewSize.Height() + ( a6Size.Height() / 2 );
//STRIP001 	long nMinX = aBookmarksBox.GetPosPixel().X();
//STRIP001 	if ( aPnt.X() < nMinX )
//STRIP001 		aPnt.X() = nMinX;
//STRIP001 	aBookmarksPB.SetPosPixel( aPnt );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void BookmarksTabPage_Impl::ActivatePage()
//STRIP001 {
//STRIP001 	SetFocusOnBox();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 Control* BookmarksTabPage_Impl::GetLastFocusControl()
//STRIP001 {
//STRIP001 	return &aBookmarksPB;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void BookmarksTabPage_Impl::SetDoubleClickHdl( const Link& rLink )
//STRIP001 {
//STRIP001 	aBookmarksBox.SetDoubleClickHdl( rLink );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 String BookmarksTabPage_Impl::GetSelectEntry() const
//STRIP001 {
//STRIP001 	String aRet;
//STRIP001 	String* pData = (String*)(ULONG)aBookmarksBox.GetEntryData( aBookmarksBox.GetSelectEntryPos() );
//STRIP001 	if ( pData )
//STRIP001 		aRet = String( *pData );
//STRIP001 	return aRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void BookmarksTabPage_Impl::AddBookmarks( const String& rTitle, const String& rURL )
//STRIP001 {
//STRIP001 	String aImageURL = IMAGE_URL;
//STRIP001 	aImageURL += INetURLObject( rURL ).GetHost();
//STRIP001 	USHORT nPos = aBookmarksBox.InsertEntry( rTitle, SvFileInformationManager::GetImage( aImageURL ) );
//STRIP001 	aBookmarksBox.SetEntryData( nPos, (void*)(ULONG)( new String( rURL ) ) );
//STRIP001 }
//STRIP001 
//STRIP001 // class SfxHelpIndexWindow_Impl -----------------------------------------
//STRIP001 
//STRIP001 SfxHelpIndexWindow_Impl::SfxHelpIndexWindow_Impl( SfxHelpWindow_Impl* _pParent ) :
//STRIP001 
//STRIP001 	Window( _pParent, SfxResId( WIN_HELP_INDEX ) ),
//STRIP001 
//STRIP001 	aActiveLB	( this, ResId( LB_ACTIVE ) ),
//STRIP001 	aActiveLine	( this, ResId( FL_ACTIVE ) ),
//STRIP001 	aTabCtrl	( this, ResId( TC_INDEX ) ),
//STRIP001 
//STRIP001 	pParentWin	( _pParent ),
//STRIP001 
//STRIP001 	pCPage		( NULL ),
//STRIP001 	pIPage		( NULL ),
//STRIP001 	pSPage		( NULL ),
//STRIP001 	pBPage		( NULL )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	sfx2::AddToTaskPaneList( this );
//STRIP001 
//STRIP001 	aTabCtrl.SetActivatePageHdl( LINK( this, SfxHelpIndexWindow_Impl, ActivatePageHdl ) );
//STRIP001 	aTabCtrl.Show();
//STRIP001 
//STRIP001 	sal_Int32 nPageId = HELP_INDEX_PAGE_INDEX;
//STRIP001 	SvtViewOptions aViewOpt( E_TABDIALOG, CONFIGNAME_INDEXWIN );
//STRIP001 	if ( aViewOpt.Exists() )
//STRIP001 		nPageId = aViewOpt.GetPageID();
//STRIP001 	aTabCtrl.SetCurPageId( (USHORT)nPageId );
//STRIP001 	ActivatePageHdl( &aTabCtrl );
//STRIP001 	aActiveLB.SetSelectHdl( LINK( this, SfxHelpIndexWindow_Impl, SelectHdl ) );
//STRIP001 	nMinWidth = ( aActiveLB.GetSizePixel().Width() / 2 );
//STRIP001 
//STRIP001 	if ( !pIPage )
//STRIP001 		pIPage = new IndexTabPage_Impl( &aTabCtrl );
//STRIP001 	pIPage->SetKeywordHdl( LINK( this, SfxHelpIndexWindow_Impl, KeywordHdl ) );
//STRIP001 
//STRIP001 	aTimer.SetTimeoutHdl( LINK( this, SfxHelpIndexWindow_Impl, InitHdl ) );
//STRIP001 	aTimer.SetTimeout( 200 );
//STRIP001 	aTimer.Start();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxHelpIndexWindow_Impl::~SfxHelpIndexWindow_Impl()
//STRIP001 {
//STRIP001 	sfx2::RemoveFromTaskPaneList( this );
//STRIP001 
//STRIP001 	DELETEZ( pCPage );
//STRIP001 	DELETEZ( pIPage );
//STRIP001 	DELETEZ( pSPage );
//STRIP001 	DELETEZ( pBPage );
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < aActiveLB.GetEntryCount(); ++i )
//STRIP001 		delete (String*)(ULONG)aActiveLB.GetEntryData(i);
//STRIP001 
//STRIP001 	SvtViewOptions aViewOpt( E_TABDIALOG, CONFIGNAME_INDEXWIN );
//STRIP001 	aViewOpt.SetPageID( (sal_Int32)aTabCtrl.GetCurPageId() );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpIndexWindow_Impl::Initialize()
//STRIP001 {
//STRIP001 	String aHelpURL = HELP_URL;
//STRIP001 	AppendConfigToken_Impl( aHelpURL, sal_True );
//STRIP001 	Sequence< ::rtl::OUString > aFactories = SfxContentHelper::GetResultSet( aHelpURL );
//STRIP001 	const ::rtl::OUString* pFacs  = aFactories.getConstArray();
//STRIP001 	UINT32 i, nCount = aFactories.getLength();
//STRIP001 	for ( i = 0; i < nCount; ++i )
//STRIP001 	{
//STRIP001 		String aRow( pFacs[i] );
//STRIP001 		String aTitle, aType, aURL;
//STRIP001 		xub_StrLen nIdx = 0;
//STRIP001 		aTitle = aRow.GetToken( 0, '\t', nIdx );
//STRIP001 		aType = aRow.GetToken( 0, '\t', nIdx );
//STRIP001 		aURL = aRow.GetToken( 0, '\t', nIdx );
//STRIP001 		String* pFactory = new String( INetURLObject( aURL ).GetHost() );
//STRIP001 		USHORT nPos = aActiveLB.InsertEntry( aTitle );
//STRIP001 		aActiveLB.SetEntryData( nPos, (void*)(ULONG)pFactory );
//STRIP001 	}
//STRIP001 
//STRIP001 	aActiveLB.SetDropDownLineCount( (USHORT)nCount );
//STRIP001 	if ( aActiveLB.GetSelectEntryPos() == LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		SetActiveFactory();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpIndexWindow_Impl::SetActiveFactory()
//STRIP001 {
//STRIP001 	DBG_ASSERT( pIPage, "index page not initialized" );
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < aActiveLB.GetEntryCount(); ++i )
//STRIP001 	{
//STRIP001 		String* pFactory = (String*)(ULONG)aActiveLB.GetEntryData(i);
//STRIP001 		pFactory->ToLowerAscii();
//STRIP001 		if ( *pFactory == pIPage->GetFactory() )
//STRIP001 		{
//STRIP001 			if ( aActiveLB.GetSelectEntryPos() != i )
//STRIP001 			{
//STRIP001 				aActiveLB.SelectEntryPos(i);
//STRIP001 				aSelectFactoryLink.Call( NULL );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 HelpTabPage_Impl* SfxHelpIndexWindow_Impl::GetCurrentPage( USHORT& rCurId )
//STRIP001 {
//STRIP001 	rCurId = aTabCtrl.GetCurPageId();
//STRIP001 	HelpTabPage_Impl* pPage = NULL;
//STRIP001 
//STRIP001 	switch ( rCurId )
//STRIP001 	{
//STRIP001 		case HELP_INDEX_PAGE_CONTENTS:
//STRIP001 		{
//STRIP001 			if ( !pCPage )
//STRIP001 				pCPage = new ContentTabPage_Impl( &aTabCtrl );
//STRIP001 			pPage = pCPage;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case HELP_INDEX_PAGE_INDEX:
//STRIP001 		{
//STRIP001 			if ( !pIPage )
//STRIP001 				pIPage = new IndexTabPage_Impl( &aTabCtrl );
//STRIP001 			pPage = pIPage;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case HELP_INDEX_PAGE_SEARCH:
//STRIP001 		{
//STRIP001 			if ( !pSPage )
//STRIP001 				pSPage = new SearchTabPage_Impl( &aTabCtrl );
//STRIP001 			pPage = pSPage;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case HELP_INDEX_PAGE_BOOKMARKS:
//STRIP001 		{
//STRIP001 			if ( !pBPage )
//STRIP001 				pBPage = new BookmarksTabPage_Impl( &aTabCtrl );
//STRIP001 			pPage = pBPage;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	DBG_ASSERT( pPage, "SfxHelpIndexWindow_Impl::GetCurrentPage(): no current page" );
//STRIP001 	return pPage;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxHelpIndexWindow_Impl, ActivatePageHdl, TabControl *, pTabCtrl )
//STRIP001 {
//STRIP001 	USHORT nId = 0;
//STRIP001 	TabPage* pPage = GetCurrentPage( nId );
//STRIP001 	pTabCtrl->SetTabPage( nId, pPage );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxHelpIndexWindow_Impl, SelectHdl, ListBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	aTimer.Start();
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxHelpIndexWindow_Impl, InitHdl, Timer *, EMPTYARG )
//STRIP001 {
//STRIP001 	Initialize();
//STRIP001 
//STRIP001 	// now use the timer for selection
//STRIP001 	aTimer.SetTimeoutHdl( LINK( this, SfxHelpIndexWindow_Impl, SelectFactoryHdl ) );
//STRIP001 	aTimer.SetTimeout( 1000 );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxHelpIndexWindow_Impl, SelectFactoryHdl, Timer *, EMPTYARG )
//STRIP001 {
//STRIP001 	String* pFactory = (String*)(ULONG)aActiveLB.GetEntryData( aActiveLB.GetSelectEntryPos() );
//STRIP001 	if ( pFactory )
//STRIP001 	{
//STRIP001 		String aFactory( *pFactory );
//STRIP001 		aFactory.ToLowerAscii();
//STRIP001 		SetFactory( aFactory, sal_False );
//STRIP001 		aSelectFactoryLink.Call( this );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxHelpIndexWindow_Impl, KeywordHdl, IndexTabPage_Impl *, EMPTYARG )
//STRIP001 {
//STRIP001 	// keyword found on index?
//STRIP001 	sal_Bool bIndex = pIPage->HasKeyword();
//STRIP001 	//The following two lines are added by BerryJia for fixing Bug98251, 2002-12-11
//STRIP001 	if( !bIndex)
//STRIP001 		bIndex = pIPage->HasKeywordIgnoreCase();
//STRIP001 	// then set index or search page as current.
//STRIP001 	USHORT nPageId = ( bIndex ) ? HELP_INDEX_PAGE_INDEX :  HELP_INDEX_PAGE_SEARCH;
//STRIP001 	if ( nPageId != aTabCtrl.GetCurPageId() )
//STRIP001 	{
//STRIP001 		aTabCtrl.SetCurPageId( nPageId );
//STRIP001 		ActivatePageHdl( &aTabCtrl );
//STRIP001 	}
//STRIP001 
//STRIP001 	// at last we open the keyword
//STRIP001 	if ( bIndex )
//STRIP001 		pIPage->OpenKeyword();
//STRIP001 	else if ( !pSPage->OpenKeyword( sKeyword ) )
//STRIP001 		pParentWin->ShowStartPage();
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpIndexWindow_Impl::Resize()
//STRIP001 {
//STRIP001 	Size aSize = GetOutputSizePixel();
//STRIP001 	if ( aSize.Width() < nMinWidth )
//STRIP001 		aSize.Width() = nMinWidth;
//STRIP001 
//STRIP001 	Point aPnt = aActiveLB.GetPosPixel();
//STRIP001 	Size aNewSize = aActiveLB.GetSizePixel();
//STRIP001 	aNewSize.Width() = aSize.Width() - ( aPnt.X() * 2 );
//STRIP001 	aActiveLB.SetSizePixel( aNewSize );
//STRIP001 	aPnt = aActiveLine.GetPosPixel();
//STRIP001 	aNewSize = aActiveLine.GetSizePixel();
//STRIP001 	aNewSize.Width() = aSize.Width() - ( aPnt.X() * 2 );
//STRIP001 	aActiveLine.SetSizePixel( aNewSize );
//STRIP001 	aPnt = aTabCtrl.GetPosPixel();
//STRIP001 	aNewSize = aSize;
//STRIP001 	aSize.Width() -= aPnt.X();
//STRIP001 	aSize.Height() -= aPnt.Y();
//STRIP001 	aTabCtrl.SetSizePixel( aSize );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long SfxHelpIndexWindow_Impl::PreNotify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	long nDone = 0;
//STRIP001 	USHORT nType = rNEvt.GetType();
//STRIP001 	if ( EVENT_KEYINPUT == nType && rNEvt.GetKeyEvent() )
//STRIP001 	{
//STRIP001 	 	const KeyCode& rKeyCode = rNEvt.GetKeyEvent()->GetKeyCode();
//STRIP001 
//STRIP001 		if ( rKeyCode.GetCode() == KEY_TAB )
//STRIP001 		{
//STRIP001 			// don't exit index pane with <TAB>
//STRIP001 			USHORT nPageId = 0;
//STRIP001 			HelpTabPage_Impl* pCurPage = GetCurrentPage( nPageId );
//STRIP001 			Control* pControl = pCurPage->GetLastFocusControl();
//STRIP001 			BOOL bShift = rKeyCode.IsShift();
//STRIP001 			BOOL bCtrl = rKeyCode.IsMod1();
//STRIP001 			if ( !bCtrl && bShift && aActiveLB.HasChildPathFocus() )
//STRIP001 			{
//STRIP001 				pControl->GrabFocus();
//STRIP001 				nDone = 1;
//STRIP001 			}
//STRIP001 			else if ( !bCtrl && !bShift && pControl->HasChildPathFocus() )
//STRIP001 			{
//STRIP001 				aActiveLB.GrabFocus();
//STRIP001 				nDone = 1;
//STRIP001 			}
//STRIP001 			else if ( bCtrl )
//STRIP001 			{
//STRIP001 				// <CTRL><TAB> moves through the pages
//STRIP001 				if ( nPageId < HELP_INDEX_PAGE_LAST )
//STRIP001 					nPageId++;
//STRIP001 				else
//STRIP001 					nPageId = HELP_INDEX_PAGE_FIRST;
//STRIP001 				aTabCtrl.SetCurPageId( (USHORT)nPageId );
//STRIP001 				ActivatePageHdl( &aTabCtrl );
//STRIP001 				nDone = 1;
//STRIP001 			}
//STRIP001  		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return nDone ? nDone : Window::PreNotify( rNEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpIndexWindow_Impl::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	Window::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if ( ( ( rDCEvt.GetType() == DATACHANGED_SETTINGS )	||
//STRIP001 		   ( rDCEvt.GetType() == DATACHANGED_DISPLAY ) ) &&
//STRIP001 		 ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001 	{
//STRIP001 		SetBackground( Wallpaper( GetSettings().GetStyleSettings().GetFaceColor() ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpIndexWindow_Impl::SetDoubleClickHdl( const Link& rLink )
//STRIP001 {
//STRIP001 	if ( !pCPage )
//STRIP001 		pCPage = new ContentTabPage_Impl( &aTabCtrl );
//STRIP001 	pCPage->SetOpenHdl( rLink );
//STRIP001 	if ( !pIPage )
//STRIP001 		pIPage = new IndexTabPage_Impl( &aTabCtrl );
//STRIP001 	pIPage->SetDoubleClickHdl( rLink );
//STRIP001 	if ( !pSPage )
//STRIP001 		pSPage = new SearchTabPage_Impl( &aTabCtrl );
//STRIP001 	pSPage->SetDoubleClickHdl( rLink );
//STRIP001 	if ( !pBPage )
//STRIP001 		pBPage = new BookmarksTabPage_Impl( &aTabCtrl );
//STRIP001 	pBPage->SetDoubleClickHdl( rLink );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpIndexWindow_Impl::SetFactory( const String& rFactory, sal_Bool bActive )
//STRIP001 {
//STRIP001 	if ( rFactory.Len() > 0 )
//STRIP001 	{
//STRIP001 		if ( !pIPage )
//STRIP001 			pIPage = new IndexTabPage_Impl( &aTabCtrl );
//STRIP001 		pIPage->SetFactory( rFactory );
//STRIP001 		if ( !pSPage )
//STRIP001 			pSPage = new SearchTabPage_Impl( &aTabCtrl );
//STRIP001 		pSPage->SetFactory( rFactory );
//STRIP001 
//STRIP001 		if ( bActive )
//STRIP001 			SetActiveFactory();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 String SfxHelpIndexWindow_Impl::GetSelectEntry() const
//STRIP001 {
//STRIP001 	String sRet;
//STRIP001 
//STRIP001 	switch ( aTabCtrl.GetCurPageId() )
//STRIP001 	{
//STRIP001 		case HELP_INDEX_PAGE_CONTENTS:
//STRIP001 			sRet = pCPage->GetSelectEntry();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case HELP_INDEX_PAGE_INDEX:
//STRIP001 			sRet = pIPage->GetSelectEntry();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case HELP_INDEX_PAGE_SEARCH:
//STRIP001 			sRet = pSPage->GetSelectEntry();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case HELP_INDEX_PAGE_BOOKMARKS:
//STRIP001 			sRet = pBPage->GetSelectEntry();
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return sRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpIndexWindow_Impl::AddBookmarks( const String& rTitle, const String& rURL )
//STRIP001 {
//STRIP001 	if ( !pBPage )
//STRIP001 		pBPage = new BookmarksTabPage_Impl( &aTabCtrl );
//STRIP001 	pBPage->AddBookmarks( rTitle, rURL );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpIndexWindow_Impl::ClearSearchPage()
//STRIP001 {
//STRIP001 	if ( pSPage )
//STRIP001 		pSPage->ClearPage();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpIndexWindow_Impl::GrabFocusBack()
//STRIP001 {
//STRIP001 	if ( aTabCtrl.GetCurPageId() == HELP_INDEX_PAGE_CONTENTS && pCPage )
//STRIP001 		pCPage->SetFocusOnBox();
//STRIP001 	else if ( aTabCtrl.GetCurPageId() == HELP_INDEX_PAGE_INDEX && pIPage )
//STRIP001 		pIPage->SetFocusOnBox();
//STRIP001 	else if ( aTabCtrl.GetCurPageId() == HELP_INDEX_PAGE_SEARCH && pSPage )
//STRIP001 		pSPage->SetFocusOnBox();
//STRIP001 	else if ( aTabCtrl.GetCurPageId() == HELP_INDEX_PAGE_BOOKMARKS && pBPage )
//STRIP001 		pBPage->SetFocusOnBox();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SfxHelpIndexWindow_Impl::HasFocusOnEdit() const
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001 	if ( aTabCtrl.GetCurPageId() == HELP_INDEX_PAGE_INDEX && pIPage )
//STRIP001 		bRet = pIPage->HasFocusOnEdit();
//STRIP001 	else if ( aTabCtrl.GetCurPageId() == HELP_INDEX_PAGE_SEARCH && pSPage )
//STRIP001 		bRet = pSPage->HasFocusOnEdit();
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 String SfxHelpIndexWindow_Impl::GetSearchText() const
//STRIP001 {
//STRIP001 	String sRet;
//STRIP001 	if ( aTabCtrl.GetCurPageId() == HELP_INDEX_PAGE_SEARCH && pSPage )
//STRIP001 		sRet = pSPage->GetSearchText();
//STRIP001 	return sRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SfxHelpIndexWindow_Impl::IsFullWordSearch() const
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001 	if ( aTabCtrl.GetCurPageId() == HELP_INDEX_PAGE_SEARCH && pSPage )
//STRIP001 		bRet = pSPage->IsFullWordSearch();
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpIndexWindow_Impl::OpenKeyword( const String& rKeyword )
//STRIP001 {
//STRIP001 	sKeyword = rKeyword;
//STRIP001 	DBG_ASSERT( pIPage, "invalid index page" );
//STRIP001 	pIPage->SetKeyword( sKeyword );
//STRIP001 }
//STRIP001 
//STRIP001 // class TextWin_Impl ----------------------------------------------------
//STRIP001 
//STRIP001 TextWin_Impl::TextWin_Impl( Window* p ) : DockingWindow( p, 0 )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 TextWin_Impl::~TextWin_Impl()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 long TextWin_Impl::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	if( ( rNEvt.GetType() == EVENT_KEYINPUT ) && rNEvt.GetKeyEvent()->GetKeyCode().GetCode() == KEY_TAB )
//STRIP001 		return GetParent()->Notify( rNEvt );
//STRIP001 	else
//STRIP001 		return DockingWindow::Notify( rNEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // class SfxHelpTextWindow_Impl ------------------------------------------
//STRIP001 
//STRIP001 SfxHelpTextWindow_Impl::SfxHelpTextWindow_Impl( SfxHelpWindow_Impl* pParent ) :
//STRIP001 
//STRIP001 	Window( pParent, WB_CLIPCHILDREN | WB_TABSTOP ),
//STRIP001 
//STRIP001 	aToolBox		( this, 0 ),
//STRIP001 	pHelpWin		( pParent ),
//STRIP001 	pTextWin		( new TextWin_Impl( this ) ),
//STRIP001 	bIsDebug		( sal_False ),
//STRIP001 	bIsInClose		( sal_False ),
//STRIP001 	aIndexOnText	( SfxResId( STR_HELP_BUTTON_INDEX_ON ) ),
//STRIP001 	aIndexOffText	( SfxResId( STR_HELP_BUTTON_INDEX_OFF ) ),
//STRIP001 	aIndexOnImage	( SfxResId( IMG_HELP_TOOLBOX_INDEX_ON ) ),
//STRIP001     aIndexOffImage  ( SfxResId( IMG_HELP_TOOLBOX_INDEX_OFF ) )
//STRIP001 {
//STRIP001 	sfx2::AddToTaskPaneList( &aToolBox );
//STRIP001 
//STRIP001     xFrame = Reference < XFrame > ( ::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance(
//STRIP001 		DEFINE_CONST_UNICODE("com.sun.star.frame.Frame") ), UNO_QUERY );
//STRIP001     xFrame->initialize( VCLUnoHelper::GetInterface ( pTextWin ) );
//STRIP001     xFrame->setName( DEFINE_CONST_UNICODE("OFFICE_HELP") );
//STRIP001 
//STRIP001 	aToolBox.SetHelpId( HID_HELP_TOOLBOX );
//STRIP001 
//STRIP001 	aToolBox.InsertItem( TBI_INDEX, aIndexOffText );
//STRIP001 	aToolBox.SetHelpId( TBI_INDEX, HID_HELP_TOOLBOXITEM_INDEX );
//STRIP001 	aToolBox.InsertSeparator();
//STRIP001 	aToolBox.InsertItem( TBI_BACKWARD, String( SfxResId( STR_HELP_BUTTON_PREV ) ) );
//STRIP001 	aToolBox.SetHelpId( TBI_BACKWARD, HID_HELP_TOOLBOXITEM_BACKWARD );
//STRIP001 	aToolBox.InsertItem( TBI_FORWARD, String( SfxResId( STR_HELP_BUTTON_NEXT ) ) );
//STRIP001 	aToolBox.SetHelpId( TBI_FORWARD, HID_HELP_TOOLBOXITEM_FORWARD );
//STRIP001 	aToolBox.InsertItem( TBI_START, String( SfxResId( STR_HELP_BUTTON_START ) ) );
//STRIP001 	aToolBox.SetHelpId( TBI_START, HID_HELP_TOOLBOXITEM_START );
//STRIP001 	aToolBox.InsertSeparator();
//STRIP001 	aToolBox.InsertItem( TBI_PRINT, String( SfxResId( STR_HELP_BUTTON_PRINT ) ) );
//STRIP001 	aToolBox.SetHelpId( TBI_PRINT, HID_HELP_TOOLBOXITEM_PRINT );
//STRIP001 	aToolBox.InsertItem( TBI_BOOKMARKS, String( SfxResId( STR_HELP_BUTTON_ADDBOOKMARK ) ) );
//STRIP001 	aToolBox.SetHelpId( TBI_BOOKMARKS, HID_HELP_TOOLBOXITEM_BOOKMARKS );
//STRIP001 	InitToolBoxImages();
//STRIP001 	aToolBox.Show();
//STRIP001 
//STRIP001 	aSelectTimer.SetTimeoutHdl( LINK( this, SfxHelpTextWindow_Impl, SelectHdl ) );
//STRIP001 	aSelectTimer.SetTimeout( 1000 );
//STRIP001 
//STRIP001 	char* pEnv = getenv( "help_debug" );
//STRIP001 	if ( pEnv )
//STRIP001 		bIsDebug = sal_True;
//STRIP001 
//STRIP001 	SvtMiscOptions().AddListener( LINK( this, SfxHelpTextWindow_Impl, NotifyHdl ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxHelpTextWindow_Impl::~SfxHelpTextWindow_Impl()
//STRIP001 {
//STRIP001 	sfx2::RemoveFromTaskPaneList( &aToolBox );
//STRIP001 
//STRIP001 	bIsInClose = sal_True;
//STRIP001 	SvtMiscOptions().RemoveListener( LINK( this, SfxHelpTextWindow_Impl, NotifyHdl ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SfxHelpTextWindow_Impl::HasSelection() const
//STRIP001 {
//STRIP001 	// is there any selection in the text and not only a cursor?
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Reference < XSelectionSupplier > xSelSup( xFrame->getController(), UNO_QUERY );
//STRIP001 		if ( xSelSup.is() )
//STRIP001 		{
//STRIP001 			// we have a selection, but perhaps it's only a cursor (a collapsed selection)
//STRIP001 			bRet = sal_True;
//STRIP001 			Any aAny = xSelSup->getSelection();
//STRIP001 			Reference < XIndexAccess > xSelection;
//STRIP001 			if ( aAny >>= xSelection )
//STRIP001 			{
//STRIP001 				if ( xSelection->getCount() == 1 )
//STRIP001 				{
//STRIP001 					aAny = xSelection->getByIndex(0);
//STRIP001 					Reference < XTextRange > xRange;
//STRIP001 					if ( aAny >>= xRange )
//STRIP001 					{
//STRIP001 						Reference < XText > xText = xRange->getText();
//STRIP001 						Reference < XTextCursor > xCursor = xText->createTextCursorByRange( xRange );
//STRIP001 						bRet = !xCursor->isCollapsed();
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch( Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERROR( "SfxHelpTextWindow_Impl::HasSelection(): unexpected exception" );
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpTextWindow_Impl::InitToolBoxImages()
//STRIP001 {
//STRIP001 	sal_Bool bLarge = ( SfxImageManager::GetCurrentSymbolSet() == SFX_SYMBOLS_LARGE );
//STRIP001 	sal_Bool bHiContrast = GetBackground().GetColor().IsDark();
//STRIP001 
//STRIP001 	aIndexOnImage = Image( SfxResId(
//STRIP001 		bLarge ? bHiContrast ? IMG_HELP_TOOLBOX_HCL_INDEX_ON : IMG_HELP_TOOLBOX_L_INDEX_ON
//STRIP001 			   : bHiContrast ? IMG_HELP_TOOLBOX_HC_INDEX_ON : IMG_HELP_TOOLBOX_INDEX_ON ) );
//STRIP001 	aIndexOffImage = Image( SfxResId(
//STRIP001 		bLarge ? bHiContrast ? IMG_HELP_TOOLBOX_HCL_INDEX_OFF : IMG_HELP_TOOLBOX_L_INDEX_OFF
//STRIP001 			   : bHiContrast ? IMG_HELP_TOOLBOX_HC_INDEX_OFF : IMG_HELP_TOOLBOX_INDEX_OFF ) );
//STRIP001 	aToolBox.SetItemImage( TBI_INDEX, bIsIndexOn ? aIndexOffImage : aIndexOnImage );
//STRIP001 
//STRIP001 	aToolBox.SetItemImage( TBI_BACKWARD, Image( SfxResId(
//STRIP001 		bLarge ? bHiContrast ? IMG_HELP_TOOLBOX_HCL_PREV : IMG_HELP_TOOLBOX_L_PREV
//STRIP001 			   : bHiContrast ? IMG_HELP_TOOLBOX_HC_PREV : IMG_HELP_TOOLBOX_PREV ) ) );
//STRIP001 	aToolBox.SetItemImage( TBI_FORWARD, Image( SfxResId(
//STRIP001 		bLarge ? bHiContrast ? IMG_HELP_TOOLBOX_HCL_NEXT : IMG_HELP_TOOLBOX_L_NEXT
//STRIP001 			   : bHiContrast ? IMG_HELP_TOOLBOX_HC_NEXT : IMG_HELP_TOOLBOX_NEXT ) ) );
//STRIP001 	aToolBox.SetItemImage( TBI_START, Image( SfxResId(
//STRIP001 		bLarge ? bHiContrast ? IMG_HELP_TOOLBOX_HCL_START : IMG_HELP_TOOLBOX_L_START
//STRIP001 			   : bHiContrast ? IMG_HELP_TOOLBOX_HC_START : IMG_HELP_TOOLBOX_START ) ) );
//STRIP001 	aToolBox.SetItemImage( TBI_PRINT, Image( SfxResId(
//STRIP001 		bLarge ? bHiContrast ? IMG_HELP_TOOLBOX_HCL_PRINT : IMG_HELP_TOOLBOX_L_PRINT
//STRIP001 			   : bHiContrast ? IMG_HELP_TOOLBOX_HC_PRINT : IMG_HELP_TOOLBOX_PRINT ) ) );
//STRIP001 	aToolBox.SetItemImage( TBI_BOOKMARKS, Image( SfxResId(
//STRIP001 		bLarge ? bHiContrast ? IMG_HELP_TOOLBOX_HCL_BOOKMARKS : IMG_HELP_TOOLBOX_L_BOOKMARKS
//STRIP001 			   : bHiContrast ? IMG_HELP_TOOLBOX_HC_BOOKMARKS : IMG_HELP_TOOLBOX_BOOKMARKS ) ) );
//STRIP001 
//STRIP001 	Size aSize = aToolBox.CalcWindowSizePixel();
//STRIP001 	aSize.Height() += TOOLBOX_OFFSET;
//STRIP001 	aToolBox.SetPosSizePixel( Point( 0, TOOLBOX_OFFSET ), aSize );
//STRIP001 
//STRIP001 	SvtMiscOptions aMiscOptions;
//STRIP001 	if ( aMiscOptions.GetToolboxStyle() != aToolBox.GetOutStyle() )
//STRIP001 		aToolBox.SetOutStyle( aMiscOptions.GetToolboxStyle() );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 Reference< XBreakIterator > SfxHelpTextWindow_Impl::GetBreakIterator()
//STRIP001 {
//STRIP001 	if ( !xBreakIterator.is() )
//STRIP001 		xBreakIterator = vcl::unohelper::CreateBreakIterator();
//STRIP001     DBG_ASSERT( xBreakIterator.is(), "Could not create BreakIterator" );
//STRIP001 	return xBreakIterator;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxHelpTextWindow_Impl, SelectHdl, Timer*, EMPTYARG )
//STRIP001 {
//STRIP001 	try
//STRIP001 	{
//STRIP001 		// select the words, which are equal to the search text of the search page
//STRIP001 		Reference < XController > xController = xFrame->getController();
//STRIP001 		if ( xController.is() )
//STRIP001 		{
//STRIP001 			// get document
//STRIP001 			Reference < XSearchable > xSearchable( xController->getModel(), UNO_QUERY );
//STRIP001 			if ( xSearchable.is() )
//STRIP001 			{
//STRIP001 				// create descriptor, set string and find all words
//STRIP001 				Reference < XSearchDescriptor > xSrchDesc = xSearchable->createSearchDescriptor();
//STRIP001 				Reference < XPropertySet > xPropSet( xSrchDesc, UNO_QUERY );
//STRIP001 				xPropSet->setPropertyValue( DEFINE_CONST_OUSTRING("SearchRegularExpression"),
//STRIP001 											makeAny( sal_Bool( sal_True ) ) );
//STRIP001 				if ( bIsFullWordSearch )
//STRIP001 					xPropSet->setPropertyValue( DEFINE_CONST_OUSTRING("SearchWords"),
//STRIP001 												makeAny( sal_Bool( sal_True ) ) );
//STRIP001 
//STRIP001 				String sSearchString = sfx2::PrepareSearchString( aSearchText, GetBreakIterator(), false );
//STRIP001 				xSrchDesc->setSearchString( sSearchString );
//STRIP001 				Reference< XIndexAccess > xSelection = xSearchable->findAll( xSrchDesc );
//STRIP001 
//STRIP001 				// then select all found words
//STRIP001 				Reference < XSelectionSupplier > xSelectionSup( xController, UNO_QUERY );
//STRIP001 				if ( xSelectionSup.is() )
//STRIP001 				{
//STRIP001 			    	Any aAny;
//STRIP001 					aAny <<= xSelection;
//STRIP001 					xSelectionSup->select( aAny );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch( Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERROR( "SfxHelpTextWindow_Impl::SelectHdl(): unexpected exception" );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 1;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxHelpTextWindow_Impl, NotifyHdl, SvtMiscOptions*, pOptions )
//STRIP001 {
//STRIP001 	InitToolBoxImages();
//STRIP001 	Resize();
//STRIP001 	aToolBox.Invalidate();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpTextWindow_Impl::Resize()
//STRIP001 {
//STRIP001 	Size aWinSize = GetOutputSizePixel();
//STRIP001 	Size aSize = aToolBox.GetSizePixel();
//STRIP001 	aSize.Width() = aWinSize.Width();
//STRIP001 	aToolBox.SetSizePixel( aSize );
//STRIP001 
//STRIP001 	long nToolBoxHeight = aSize.Height() + TOOLBOX_OFFSET;
//STRIP001 	aSize = aWinSize;
//STRIP001 	aSize.Height() -= nToolBoxHeight;
//STRIP001 	pTextWin->SetPosSizePixel( Point( 0, nToolBoxHeight  ), aSize );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 bool isHandledKey( const KeyCode& _rKeyCode )
//STRIP001 {
//STRIP001 	bool bRet = false;
//STRIP001 	USHORT nCode = _rKeyCode.GetCode();
//STRIP001 
//STRIP001 	// the keys <CTRL><A> (select all), <CTRL><C> (copy) and <CTRL><P> (print)
//STRIP001 	// were handled in help
//STRIP001 	if ( _rKeyCode.IsMod1() &&
//STRIP001 		 ( KEY_A == nCode || KEY_C == nCode || KEY_P == nCode ) )
//STRIP001 		bRet = true;
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long SfxHelpTextWindow_Impl::PreNotify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	long nDone = 0;
//STRIP001 	USHORT nType = rNEvt.GetType();
//STRIP001 	if ( EVENT_COMMAND == nType && rNEvt.GetCommandEvent() )
//STRIP001 	{
//STRIP001 		const CommandEvent* pCmdEvt = rNEvt.GetCommandEvent();
//STRIP001 		Window* pCmdWin = rNEvt.GetWindow();
//STRIP001 
//STRIP001 		if ( pCmdEvt->GetCommand() == COMMAND_CONTEXTMENU && pCmdWin != this && pCmdWin != &aToolBox )
//STRIP001 		{
//STRIP001 			sal_Bool bHiContrast = GetSettings().GetStyleSettings().GetMenuColor().IsDark();
//STRIP001 			Point aPos;
//STRIP001 			if ( pCmdEvt->IsMouseEvent() )
//STRIP001 				aPos = pCmdEvt->GetMousePosPixel();
//STRIP001 			else
//STRIP001 				aPos = Point( pTextWin->GetPosPixel().X() + 20, 20 );
//STRIP001 			aPos.Y() += pTextWin->GetPosPixel().Y();
//STRIP001 			PopupMenu aMenu;
//STRIP001 			if ( bIsIndexOn )
//STRIP001 				aMenu.InsertItem( TBI_INDEX, aIndexOffText, Image( SfxResId(
//STRIP001 					bHiContrast ? IMG_HELP_TOOLBOX_HC_INDEX_OFF : IMG_HELP_TOOLBOX_INDEX_OFF ) ) );
//STRIP001 			else
//STRIP001 				aMenu.InsertItem( TBI_INDEX, aIndexOnText, Image( SfxResId(
//STRIP001 					bHiContrast ? IMG_HELP_TOOLBOX_HC_INDEX_ON : IMG_HELP_TOOLBOX_INDEX_ON ) ) );
//STRIP001 			aMenu.SetHelpId( TBI_INDEX, HID_HELP_TOOLBOXITEM_INDEX );
//STRIP001 			aMenu.InsertSeparator();
//STRIP001 			aMenu.InsertItem( TBI_BACKWARD, String( SfxResId( STR_HELP_BUTTON_PREV ) ),
//STRIP001 				Image( SfxResId( bHiContrast ? IMG_HELP_TOOLBOX_HC_PREV : IMG_HELP_TOOLBOX_PREV ) ) );
//STRIP001 			aMenu.SetHelpId( TBI_BACKWARD, HID_HELP_TOOLBOXITEM_BACKWARD );
//STRIP001 			aMenu.EnableItem( TBI_BACKWARD, pHelpWin->HasHistoryPredecessor() );
//STRIP001 			aMenu.InsertItem( TBI_FORWARD, String( SfxResId( STR_HELP_BUTTON_NEXT ) ),
//STRIP001 				Image( SfxResId( bHiContrast ? IMG_HELP_TOOLBOX_HC_NEXT : IMG_HELP_TOOLBOX_NEXT ) ) );
//STRIP001 			aMenu.SetHelpId( TBI_FORWARD, HID_HELP_TOOLBOXITEM_FORWARD );
//STRIP001 			aMenu.EnableItem( TBI_FORWARD, pHelpWin->HasHistorySuccessor() );
//STRIP001 			aMenu.InsertItem( TBI_START, String( SfxResId( STR_HELP_BUTTON_START ) ),
//STRIP001 				Image( SfxResId( bHiContrast ? IMG_HELP_TOOLBOX_HC_START : IMG_HELP_TOOLBOX_START ) ) );
//STRIP001 			aMenu.SetHelpId( TBI_START, HID_HELP_TOOLBOXITEM_START );
//STRIP001 			aMenu.InsertSeparator();
//STRIP001 			aMenu.InsertItem( TBI_PRINT, String( SfxResId( STR_HELP_BUTTON_PRINT ) ),
//STRIP001 				Image( SfxResId( bHiContrast ? IMG_HELP_TOOLBOX_HC_PRINT : IMG_HELP_TOOLBOX_PRINT ) ) );
//STRIP001 			aMenu.SetHelpId( TBI_PRINT, HID_HELP_TOOLBOXITEM_PRINT );
//STRIP001 			aMenu.InsertItem( TBI_BOOKMARKS, String( SfxResId( STR_HELP_BUTTON_ADDBOOKMARK ) ),
//STRIP001 				Image( SfxResId( bHiContrast ? IMG_HELP_TOOLBOX_HC_BOOKMARKS : IMG_HELP_TOOLBOX_BOOKMARKS ) ) );
//STRIP001 			aMenu.SetHelpId( TBI_BOOKMARKS, HID_HELP_TOOLBOXITEM_BOOKMARKS );
//STRIP001 			aMenu.InsertSeparator();
//STRIP001             aMenu.InsertItem( TBI_SELECTIONMODE, String( SfxResId( STR_HELP_MENU_TEXT_SELECTION_MODE ) ) );
//STRIP001             aMenu.SetHelpId( TBI_SELECTIONMODE, HID_HELP_TEXT_SELECTION_MODE );
//STRIP001             Reference < XDispatchProvider > xProv( xFrame, UNO_QUERY );
//STRIP001             URL aURL;
//STRIP001             aURL.Complete = DEFINE_CONST_UNICODE(".uno:SelectTextMode");
//STRIP001 			PARSE_URL( aURL );
//STRIP001 			Reference < XDispatch > xDisp = xProv.is() ?
//STRIP001                     xProv->queryDispatch( aURL, ::rtl::OUString(), 0 ) : Reference < XDispatch >();
//STRIP001             if(xDisp.is())
//STRIP001             {
//STRIP001                 HelpStatusListener_Impl* pStateListener;
//STRIP001                 Reference<XStatusListener>xStateListener = pStateListener =
//STRIP001                                         new HelpStatusListener_Impl(xDisp, aURL );
//STRIP001                 FeatureStateEvent rEvent = pStateListener->GetStateEvent();
//STRIP001 				sal_Bool bCheck = sal_False;
//STRIP001                 rEvent.State >>= bCheck;
//STRIP001                 aMenu.CheckItem(TBI_SELECTIONMODE, bCheck);
//STRIP001             }
//STRIP001             aMenu.InsertSeparator();
//STRIP001 			aMenu.InsertItem( TBI_COPY, GET_SLOT_NAME( SID_COPY ),
//STRIP001 				Image( SfxResId( bHiContrast ? IMG_HELP_TOOLBOX_HC_COPY : IMG_HELP_TOOLBOX_COPY ) ) );
//STRIP001 			aMenu.SetHelpId( TBI_COPY, SID_COPY );
//STRIP001 			aMenu.EnableItem( TBI_COPY, HasSelection() );
//STRIP001 
//STRIP001 			if ( bIsDebug )
//STRIP001 			{
//STRIP001 				aMenu.InsertSeparator();
//STRIP001 				aMenu.InsertItem( TBI_SOURCEVIEW, String( SfxResId( STR_HELP_BUTTON_SOURCEVIEW ) ) );
//STRIP001 			}
//STRIP001 
//STRIP001 			if( SvtMenuOptions().IsEntryHidingEnabled() == sal_False )
//STRIP001 				aMenu.SetMenuFlags( aMenu.GetMenuFlags() | MENU_FLAG_HIDEDISABLEDENTRIES );
//STRIP001 
//STRIP001 			USHORT nId = aMenu.Execute( this, aPos );
//STRIP001 			pHelpWin->DoAction( nId );
//STRIP001 			nDone = 1;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( EVENT_KEYINPUT == nType && rNEvt.GetKeyEvent() )
//STRIP001 	{
//STRIP001 	 	const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
//STRIP001 	 	const KeyCode& rKeyCode = pKEvt->GetKeyCode();
//STRIP001 		USHORT nKeyGroup = rKeyCode.GetGroup();
//STRIP001 		if ( KEYGROUP_ALPHA == nKeyGroup &&  !isHandledKey( rKeyCode ) )
//STRIP001 		{
//STRIP001 			// do nothing disables the writer accelerators
//STRIP001 			nDone = 1;
//STRIP001  		}
//STRIP001 		else if ( rKeyCode.IsMod1() && rKeyCode.GetCode() == KEY_F4 )
//STRIP001 		{
//STRIP001 			// <STRG><F4> -> close top frame
//STRIP001 			pHelpWin->CloseWindow();
//STRIP001 			nDone = 1;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return nDone ? nDone : Window::PreNotify( rNEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpTextWindow_Impl::GetFocus()
//STRIP001 {
//STRIP001 	if ( !bIsInClose )
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			if( xFrame.is() )
//STRIP001 			{
//STRIP001 				Reference< ::com::sun::star::awt::XWindow >	xWindow = xFrame->getComponentWindow();
//STRIP001 				if( xWindow.is() )
//STRIP001 					xWindow->setFocus();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		catch( Exception& )
//STRIP001 		{
//STRIP001 			DBG_ERRORFILE( "SfxHelpTextWindow_Impl::GetFocus(): unexpected exception" );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpTextWindow_Impl::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	Window::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if ( ( ( rDCEvt.GetType() == DATACHANGED_SETTINGS )	||
//STRIP001 		   ( rDCEvt.GetType() == DATACHANGED_DISPLAY ) ) &&
//STRIP001 		 ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001 	{
//STRIP001 		SetBackground( Wallpaper( GetSettings().GetStyleSettings().GetFaceColor() ) );
//STRIP001 		InitToolBoxImages();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpTextWindow_Impl::ToggleIndex( sal_Bool bOn )
//STRIP001 {
//STRIP001 	bIsIndexOn = bOn;
//STRIP001 	if ( bIsIndexOn )
//STRIP001 	{
//STRIP001 		aToolBox.SetItemImage( TBI_INDEX, aIndexOffImage );
//STRIP001 		aToolBox.SetItemText( TBI_INDEX, aIndexOffText );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aToolBox.SetItemImage( TBI_INDEX, aIndexOnImage );
//STRIP001 		aToolBox.SetItemText( TBI_INDEX, aIndexOnText );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpTextWindow_Impl::SelectSearchText( const String& rSearchText, sal_Bool _bIsFullWordSearch )
//STRIP001 {
//STRIP001 	aSearchText = rSearchText;
//STRIP001 	bIsFullWordSearch = _bIsFullWordSearch;
//STRIP001 	aSelectTimer.Start();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpTextWindow_Impl::SetPageStyleHeaderOff() const
//STRIP001 {
//STRIP001 #ifdef DBG_UTIL
//STRIP001 	sal_Bool bSetOff = sal_False;
//STRIP001 #endif
//STRIP001 	// set off the pagestyle header to prevent print output of the help URL
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Reference < XController > xController = xFrame->getController();
//STRIP001 		Reference < XSelectionSupplier > xSelSup( xController, UNO_QUERY );
//STRIP001 		if ( xSelSup.is() )
//STRIP001 		{
//STRIP001 			Reference < XIndexAccess > xSelection;
//STRIP001 			if ( xSelSup->getSelection() >>= xSelection )
//STRIP001 			{
//STRIP001 				Reference < XTextRange > xRange;
//STRIP001 				if ( xSelection->getByIndex(0) >>= xRange )
//STRIP001 				{
//STRIP001 					Reference < XText > xText = xRange->getText();
//STRIP001 					Reference < XPropertySet > xProps( xText->createTextCursorByRange( xRange ), UNO_QUERY );
//STRIP001 					::rtl::OUString sStyleName;
//STRIP001 					if ( xProps->getPropertyValue( DEFINE_CONST_OUSTRING("PageStyleName") ) >>= sStyleName )
//STRIP001 					{
//STRIP001 						Reference < XStyleFamiliesSupplier > xStyles( xController->getModel(), UNO_QUERY );
//STRIP001 						Reference < XNameContainer > xContainer;
//STRIP001 						if ( xStyles->getStyleFamilies()->getByName( DEFINE_CONST_OUSTRING("PageStyles") )
//STRIP001 							 >>= xContainer )
//STRIP001 						{
//STRIP001 							Reference < XStyle > xStyle;
//STRIP001 							if ( xContainer->getByName( sStyleName ) >>= xStyle )
//STRIP001 							{
//STRIP001 								Reference < XPropertySet > xPropSet( xStyle, UNO_QUERY );
//STRIP001 								xPropSet->setPropertyValue( DEFINE_CONST_OUSTRING("HeaderIsOn"),
//STRIP001 															makeAny( sal_Bool( sal_False ) ) );
//STRIP001 #ifdef DBG_UTIL
//STRIP001 								bSetOff = sal_True;
//STRIP001 #endif
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch( Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "SfxHelpTextWindow_Impl::SetPageStyleHeaderOff(): unexpected exception" );
//STRIP001 	}
//STRIP001 
//STRIP001 #ifdef DBG_UTIL
//STRIP001 	if ( !bSetOff )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "SfxHelpTextWindow_Impl::SetPageStyleHeaderOff(): set off failed" );
//STRIP001 	}
//STRIP001 #endif
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpTextWindow_Impl::CloseFrame()
//STRIP001 {
//STRIP001 	bIsInClose = sal_True;
//STRIP001     try
//STRIP001     {
//STRIP001         ::com::sun::star::uno::Reference< ::com::sun::star::util::XCloseable > xCloseable  ( xFrame, ::com::sun::star::uno::UNO_QUERY );
//STRIP001         if (xCloseable.is())
//STRIP001             xCloseable->close(sal_True);
//STRIP001     }
//STRIP001     catch( ::com::sun::star::util::CloseVetoException& )
//STRIP001     {
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // class SfxHelpWindow_Impl ----------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpWindow_Impl::Resize()
//STRIP001 {
//STRIP001 	SplitWindow::Resize();
//STRIP001 	InitSizes();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpWindow_Impl::Split()
//STRIP001 {
//STRIP001 	static long	nMinSplitSize = 5;
//STRIP001 	static long nMaxSplitSize = 99 - nMinSplitSize;
//STRIP001 
//STRIP001 	SplitWindow::Split();
//STRIP001 
//STRIP001 	nIndexSize = GetItemSize( INDEXWIN_ID );
//STRIP001 	nTextSize = GetItemSize( TEXTWIN_ID );
//STRIP001 
//STRIP001 	BOOL		bMod = FALSE;
//STRIP001 	if( nIndexSize < nMinSplitSize )
//STRIP001 	{
//STRIP001 		nIndexSize = nMinSplitSize;
//STRIP001 		nTextSize = nMaxSplitSize;
//STRIP001 
//STRIP001 		bMod = TRUE;
//STRIP001 	}
//STRIP001 	else if( nTextSize < nMinSplitSize )
//STRIP001 	{
//STRIP001 		nTextSize = nMinSplitSize;
//STRIP001 		nIndexSize = nMaxSplitSize;
//STRIP001 
//STRIP001 		bMod = TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		bMod = FALSE;
//STRIP001 
//STRIP001 	if( bMod )
//STRIP001 	{
//STRIP001 		SetItemSize( INDEXWIN_ID, nIndexSize );
//STRIP001 		SetItemSize( TEXTWIN_ID, nTextSize );
//STRIP001 	}
//STRIP001 
//STRIP001 	InitSizes();
//STRIP001 
//STRIP001 //!	pIndexWin->UpdateTabControl();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpWindow_Impl::GetFocus()
//STRIP001 {
//STRIP001 	pTextWin->GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpWindow_Impl::MakeLayout()
//STRIP001 {
//STRIP001 	if ( nHeight > 0 && xWindow.is() )
//STRIP001 	{
//STRIP001        	Window* pScreenWin = VCLUnoHelper::GetWindow( xWindow );
//STRIP001        	pScreenWin->Hide();
//STRIP001 
//STRIP001 		::com::sun::star::awt::Rectangle aRect = xWindow->getPosSize();
//STRIP001 		sal_Int32 nOldWidth = bIndex ? nCollapseWidth : nExpandWidth;
//STRIP001 		sal_Int32 nWidth = bIndex ? nExpandWidth : nCollapseWidth;
//STRIP001     	xWindow->setPosSize( aRect.X, aRect.Y, nWidth, nHeight, ::com::sun::star::awt::PosSize::SIZE );
//STRIP001 
//STRIP001 		if ( aRect.Width > 0 && aRect.Height > 0 )
//STRIP001 		{
//STRIP001 			Rectangle aScreenRect = pScreenWin->GetClientWindowExtentsRelative( NULL );
//STRIP001     		Point aNewPos = aScreenRect.TopLeft();
//STRIP001 			sal_Int32 nDiffWidth = nOldWidth - nWidth;
//STRIP001 			aNewPos.X() += nDiffWidth;
//STRIP001 			pScreenWin->SetPosPixel( aNewPos );
//STRIP001 		}
//STRIP001 		else if ( aWinPos.X() > 0 && aWinPos.Y() > 0 )
//STRIP001 			pScreenWin->SetPosPixel( aWinPos );
//STRIP001 
//STRIP001        	pScreenWin->Show();
//STRIP001 	}
//STRIP001 
//STRIP001 	Clear();
//STRIP001 
//STRIP001 	if ( bIndex )
//STRIP001 	{
//STRIP001 		pIndexWin->Show();
//STRIP001 		InsertItem( COLSET_ID, 100, SPLITWINDOW_APPEND, SPLITSET_ID, SWIB_PERCENTSIZE | SWIB_COLSET );
//STRIP001 		InsertItem( INDEXWIN_ID, pIndexWin, nIndexSize, SPLITWINDOW_APPEND, COLSET_ID, SWIB_PERCENTSIZE );
//STRIP001 		InsertItem( TEXTWIN_ID, pTextWin, nTextSize, SPLITWINDOW_APPEND, COLSET_ID, SWIB_PERCENTSIZE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pIndexWin->Hide();
//STRIP001 		InsertItem( COLSET_ID, 100, SPLITWINDOW_APPEND, SPLITSET_ID, SWIB_PERCENTSIZE | SWIB_COLSET );
//STRIP001 		InsertItem( TEXTWIN_ID, pTextWin, 100, SPLITWINDOW_APPEND, 1, SWIB_PERCENTSIZE );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpWindow_Impl::InitSizes()
//STRIP001 {
//STRIP001 	if ( xWindow.is() )
//STRIP001 	{
//STRIP001 		::com::sun::star::awt::Rectangle aRect = xWindow->getPosSize();
//STRIP001 		nHeight = aRect.Height;
//STRIP001 
//STRIP001 		if ( bIndex )
//STRIP001 		{
//STRIP001 			nExpandWidth = aRect.Width;
//STRIP001 			nCollapseWidth = nExpandWidth * nTextSize / 100;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nCollapseWidth = aRect.Width;
//STRIP001 			nExpandWidth = nCollapseWidth * 100 / nTextSize;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpWindow_Impl::LoadConfig()
//STRIP001 {
//STRIP001  	SvtViewOptions aViewOpt( E_WINDOW, CONFIGNAME_HELPWIN );
//STRIP001 	if ( aViewOpt.Exists() )
//STRIP001 	{
//STRIP001 		bIndex = aViewOpt.IsVisible();
//STRIP001 		String aUserData;
//STRIP001 		Any aUserItem = aViewOpt.GetUserItem( USERITEM_NAME );
//STRIP001 		::rtl::OUString aTemp;
//STRIP001 		if ( aUserItem >>= aTemp )
//STRIP001 		{
//STRIP001 			aUserData = String( aTemp );
//STRIP001 			DBG_ASSERT( aUserData.GetTokenCount() == 6, "invalid user data" );
//STRIP001 			USHORT nIdx = 0;
//STRIP001 			nIndexSize = aUserData.GetToken( 0, ';', nIdx ).ToInt32();
//STRIP001 			nTextSize = aUserData.GetToken( 0, ';', nIdx ).ToInt32();
//STRIP001 			sal_Int32 nWidth = aUserData.GetToken( 0, ';', nIdx ).ToInt32();
//STRIP001 			nHeight = aUserData.GetToken( 0, ';', nIdx ).ToInt32();
//STRIP001 			aWinPos.X() = aUserData.GetToken( 0, ';', nIdx ).ToInt32();
//STRIP001 			aWinPos.Y() = aUserData.GetToken( 0, ';', nIdx ).ToInt32();
//STRIP001 			if ( bIndex )
//STRIP001 			{
//STRIP001 				nExpandWidth = nWidth;
//STRIP001 				nCollapseWidth = nExpandWidth * nTextSize / 100;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				nCollapseWidth = nWidth;
//STRIP001 				nExpandWidth = nCollapseWidth * 100 / nTextSize;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		pTextWin->ToggleIndex( bIndex );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpWindow_Impl::SaveConfig()
//STRIP001 {
//STRIP001 	SvtViewOptions aViewOpt( E_WINDOW, CONFIGNAME_HELPWIN );
//STRIP001 	sal_Int32 nW = 0, nH = 0;
//STRIP001 
//STRIP001 	if ( xWindow.is() )
//STRIP001 	{
//STRIP001 		::com::sun::star::awt::Rectangle aRect = xWindow->getPosSize();
//STRIP001 		nW = aRect.Width;
//STRIP001 		nH = aRect.Height;
//STRIP001 	}
//STRIP001 
//STRIP001 	aViewOpt.SetVisible( bIndex );
//STRIP001 	String aUserData = String::CreateFromInt32( nIndexSize );
//STRIP001 	aUserData += ';';
//STRIP001 	aUserData += String::CreateFromInt32( nTextSize );
//STRIP001 	aUserData += ';';
//STRIP001 	aUserData += String::CreateFromInt32( nW );
//STRIP001 	aUserData += ';';
//STRIP001 	aUserData += String::CreateFromInt32( nH );
//STRIP001 
//STRIP001    	Window* pScreenWin = VCLUnoHelper::GetWindow( xWindow );
//STRIP001 	aWinPos = pScreenWin->GetWindowExtentsRelative( NULL ).TopLeft();
//STRIP001 	aUserData += ';';
//STRIP001 	aUserData += String::CreateFromInt32( aWinPos.X() );
//STRIP001 	aUserData += ';';
//STRIP001 	aUserData += String::CreateFromInt32( aWinPos.Y() );
//STRIP001 
//STRIP001 	aViewOpt.SetUserItem( USERITEM_NAME, makeAny( ::rtl::OUString( aUserData ) ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpWindow_Impl::ShowStartPage()
//STRIP001 {
//STRIP001 	String aStartURL;
//STRIP001 	aStartURL = HELP_URL;
//STRIP001 	aStartURL += pIndexWin->GetFactory();
//STRIP001 	aStartURL += DEFINE_CONST_UNICODE("/start");
//STRIP001 	AppendConfigToken_Impl( aStartURL, sal_True );
//STRIP001 
//STRIP001 	URL aURL;
//STRIP001 	aURL.Complete = aStartURL;
//STRIP001 	PARSE_URL( aURL );
//STRIP001 
//STRIP001 	String aTarget( DEFINE_CONST_UNICODE("_self") );
//STRIP001     Reference < XDispatchProvider > xProv( pTextWin->getFrame(), UNO_QUERY );
//STRIP001     Reference < XDispatch > xDisp = xProv.is() ?
//STRIP001 		xProv->queryDispatch( aURL, aTarget, 0 ) : Reference < XDispatch >();
//STRIP001 
//STRIP001 	if ( xDisp.is() )
//STRIP001 	{
//STRIP001 		Sequence < PropertyValue > aArgs( 1 );
//STRIP001         aArgs[0].Name = DEFINE_CONST_UNICODE("ReadOnly");
//STRIP001 		BOOL bReadOnly = TRUE;
//STRIP001         aArgs[0].Value <<= bReadOnly;
//STRIP001 		if ( !IsWait() )
//STRIP001 			EnterWait();
//STRIP001 //		( (OpenStatusListener_Impl*)xOpenListener.get() )->AddListener( xDisp, aURL );
//STRIP001         xDisp->dispatch( aURL, aArgs );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxHelpWindow_Impl, SelectHdl, ToolBox* , pToolBox )
//STRIP001 {
//STRIP001 	if ( pToolBox )
//STRIP001 	{
//STRIP001 		bGrabFocusToToolBox = pToolBox->HasChildPathFocus();
//STRIP001 		DoAction( pToolBox->GetCurItemId() );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 1;
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxHelpWindow_Impl, OpenHdl, SfxHelpIndexWindow_Impl* , EMPTYARG )
//STRIP001 {
//STRIP001 	String aEntry = pIndexWin->GetSelectEntry();
//STRIP001 
//STRIP001 	if ( aEntry.Len() > 0 )
//STRIP001 	{
//STRIP001 		INetURLObject aObj( aEntry );
//STRIP001 		if ( aObj.GetProtocol() != INET_PROT_VND_SUN_STAR_HELP )
//STRIP001 		{
//STRIP001 			String aId, aAnchor('#');
//STRIP001 			if ( aEntry.GetTokenCount( '#' ) == 2 )
//STRIP001 			{
//STRIP001 				aId = aEntry.GetToken( 0, '#' );
//STRIP001 				aAnchor += aEntry.GetToken( 1, '#' );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aId = aEntry;
//STRIP001 
//STRIP001 			aEntry = HELP_URL;
//STRIP001 			aEntry += pIndexWin->GetFactory();
//STRIP001 			aEntry += '/';
//STRIP001 			aEntry += aId;
//STRIP001 			AppendConfigToken_Impl( aEntry, sal_True );
//STRIP001 			if ( aAnchor.Len() > 1 )
//STRIP001 				aEntry += aAnchor;
//STRIP001 		}
//STRIP001 		URL aURL;
//STRIP001 		aURL.Complete = aEntry;
//STRIP001 		PARSE_URL( aURL );
//STRIP001 
//STRIP001     	Reference < XDispatchProvider > xProv( pTextWin->getFrame(), UNO_QUERY );
//STRIP001     	Reference < XDispatch > xDisp = xProv.is() ? xProv->queryDispatch( aURL, String(), 0 )
//STRIP001 												   : Reference < XDispatch >();
//STRIP001     	if ( xDisp.is() )
//STRIP001 		{
//STRIP001 			if ( !IsWait() )
//STRIP001 				EnterWait();
//STRIP001 
//STRIP001 //			( (OpenStatusListener_Impl*)xOpenListener.get() )->AddListener( xDisp, aURL );
//STRIP001         	xDisp->dispatch( aURL, Sequence < PropertyValue >() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //-------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxHelpWindow_Impl, SelectFactoryHdl, SfxHelpIndexWindow_Impl* , pWin )
//STRIP001 {
//STRIP001 	String aNewTitle = sTitle;
//STRIP001 	aNewTitle += DEFINE_CONST_UNICODE(" - ");
//STRIP001 	aNewTitle += pIndexWin->GetActiveFactoryTitle();
//STRIP001 	GetParent()->SetText( aNewTitle );
//STRIP001 
//STRIP001 	if ( pWin )
//STRIP001 		ShowStartPage();
//STRIP001 	pIndexWin->ClearSearchPage();
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxHelpWindow_Impl, ChangeHdl, HelpListener_Impl*, pListener )
//STRIP001 {
//STRIP001 	SetFactory( pListener->GetFactory() );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SfxHelpWindow_Impl, OpenDoneHdl, OpenStatusListener_Impl*, pListener )
//STRIP001 {
//STRIP001 	INetURLObject aObj( pListener->GetURL() );
//STRIP001 	if ( aObj.GetProtocol() == INET_PROT_VND_SUN_STAR_HELP )
//STRIP001 		SetFactory( aObj.GetHost() );
//STRIP001 	if ( IsWait() )
//STRIP001 		LeaveWait();
//STRIP001 	if ( bGrabFocusToToolBox )
//STRIP001 	{
//STRIP001 		pTextWin->GetToolBox().GrabFocus();
//STRIP001 		bGrabFocusToToolBox = sal_False;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pIndexWin->GrabFocusBack();
//STRIP001 	if ( pListener->IsSuccessful() )
//STRIP001 	{
//STRIP001 		// set some view settings: "prevent help tips" and "helpid == 68245"
//STRIP001 		try
//STRIP001 		{
//STRIP001 			Reference < XController > xController = pTextWin->getFrame()->getController();
//STRIP001 			if ( xController.is() )
//STRIP001 			{
//STRIP001 				Reference < XViewSettingsSupplier > xSettings( xController, UNO_QUERY );
//STRIP001 				Reference < XPropertySet > xViewProps = xSettings->getViewSettings();
//STRIP001 				Any aBoolAny = makeAny( sal_Bool( sal_True ) );
//STRIP001 				xViewProps->setPropertyValue( DEFINE_CONST_OUSTRING("PreventHelpTips"), aBoolAny );
//STRIP001 				xViewProps->setPropertyValue( DEFINE_CONST_OUSTRING("ShowGraphics"), aBoolAny );
//STRIP001 				xViewProps->setPropertyValue( DEFINE_CONST_OUSTRING("ShowTables"), aBoolAny );
//STRIP001 				xViewProps->setPropertyValue( DEFINE_CONST_OUSTRING("HelpURL"), makeAny( DEFINE_CONST_OUSTRING("HID:68245") ) );
//STRIP001 
//STRIP001                 xController->restoreViewData(pHelpInterceptor->GetViewData());
//STRIP001 			}
//STRIP001 		}
//STRIP001 		catch( Exception& )
//STRIP001 		{
//STRIP001 			DBG_ERROR( "SfxHelpWindow_Impl::OpenDoneHdl(): unexpected exception" );
//STRIP001 		}
//STRIP001 
//STRIP001 		// When the SearchPage opens the help doc, then select all words, which are equal to its text
//STRIP001 		String sSearchText = TRIM( pIndexWin->GetSearchText() );
//STRIP001 		if ( sSearchText.Len() > 0 )
//STRIP001 			pTextWin->SelectSearchText( sSearchText, pIndexWin->IsFullWordSearch() );
//STRIP001 
//STRIP001 		// no page style header -> this prevents a print output of the URL
//STRIP001 		pTextWin->SetPageStyleHeaderOff();
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxHelpWindow_Impl::SfxHelpWindow_Impl(
//STRIP001 	const ::com::sun::star::uno::Reference < ::com::sun::star::frame::XFrame >& rFrame,
//STRIP001 	Window* pParent, WinBits nBits ) :
//STRIP001 
//STRIP001 	SplitWindow( pParent, WB_3DLOOK | WB_NOSPLITDRAW ),
//STRIP001 
//STRIP001 	pIndexWin			( NULL ),
//STRIP001 	pTextWin	   		( NULL ),
//STRIP001 	pHelpInterceptor	( new HelpInterceptor_Impl() ),
//STRIP001 	pHelpListener		( new HelpListener_Impl( pHelpInterceptor ) ),
//STRIP001 	nExpandWidth		( 0 ),
//STRIP001 	nCollapseWidth		( 0 ),
//STRIP001 	nHeight				( 0 ),
//STRIP001 	nIndexSize			( 40 ),
//STRIP001 	nTextSize			( 60 ),
//STRIP001 	bIndex				( sal_True ),
//STRIP001 	bGrabFocusToToolBox	( sal_False ),
//STRIP001 	aWinPos				( 0, 0 ),
//STRIP001 	sTitle				( pParent->GetText() )
//STRIP001 
//STRIP001 {
//STRIP001 	SetHelpId( HID_HELP_WINDOW );
//STRIP001 	SetStyle( GetStyle() | WB_DIALOGCONTROL );
//STRIP001 
//STRIP001     OpenStatusListener_Impl* pOpenListener = new OpenStatusListener_Impl;
//STRIP001     xOpenListener = Reference< XDispatchResultListener >( static_cast< ::cppu::OWeakObject* >(pOpenListener), UNO_QUERY );
//STRIP001 
//STRIP001 	pHelpInterceptor->InitWaiter( (OpenStatusListener_Impl*)xOpenListener.get(), this );
//STRIP001 	pIndexWin = new SfxHelpIndexWindow_Impl( this );
//STRIP001 	pIndexWin->SetDoubleClickHdl( LINK( this, SfxHelpWindow_Impl, OpenHdl ) );
//STRIP001 	pIndexWin->SetSelectFactoryHdl( LINK( this, SfxHelpWindow_Impl, SelectFactoryHdl ) );
//STRIP001 	pIndexWin->Show();
//STRIP001 	pTextWin = new SfxHelpTextWindow_Impl( this );
//STRIP001     Reference < XFramesSupplier > xSup( rFrame, UNO_QUERY );
//STRIP001     Reference < XFrames > xFrames = xSup->getFrames();
//STRIP001     xFrames->append( pTextWin->getFrame() );
//STRIP001 	pTextWin->SetSelectHdl( LINK( this, SfxHelpWindow_Impl, SelectHdl ) );
//STRIP001 	pTextWin->Show();
//STRIP001 	pHelpInterceptor->setInterception( pTextWin->getFrame() );
//STRIP001 	pHelpListener->SetChangeHdl( LINK( this, SfxHelpWindow_Impl, ChangeHdl ) );
//STRIP001 	( (OpenStatusListener_Impl*)xOpenListener.get() )->SetOpenHdl( LINK( this, SfxHelpWindow_Impl, OpenDoneHdl ) );
//STRIP001 	LoadConfig();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxHelpWindow_Impl::~SfxHelpWindow_Impl()
//STRIP001 {
//STRIP001 	SaveConfig();
//STRIP001 	Window*	pDel = pIndexWin;
//STRIP001 	pIndexWin = NULL;
//STRIP001 	delete pDel;
//STRIP001 
//STRIP001 	pTextWin->CloseFrame();
//STRIP001 	delete pTextWin;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long SfxHelpWindow_Impl::PreNotify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	sal_Bool bHandled = sal_False;
//STRIP001 	if ( rNEvt.GetType() == EVENT_KEYINPUT )
//STRIP001 	{
//STRIP001 		// Backward == <ALT><LEFT> or <BACKSPACE> Forward == <ALT><RIGHT>
//STRIP001 	 	const KeyCode& rKeyCode = rNEvt.GetKeyEvent()->GetKeyCode();
//STRIP001 		if ( ( rKeyCode.IsMod2() &&
//STRIP001 			   ( rKeyCode.GetCode() == KEY_LEFT || rKeyCode.GetCode() == KEY_RIGHT ) ) ||
//STRIP001 			 ( !rKeyCode.GetModifier() &&
//STRIP001 			   rKeyCode.GetCode() == KEY_BACKSPACE && !pIndexWin->HasFocusOnEdit() ) )
//STRIP001 		{
//STRIP001 			DoAction( rKeyCode.GetCode() == KEY_RIGHT ? TBI_FORWARD : TBI_BACKWARD );
//STRIP001 			bHandled = sal_True;
//STRIP001 		}
//STRIP001 		else if ( rKeyCode.IsMod1() && rKeyCode.GetCode() == KEY_F4 )
//STRIP001 		{
//STRIP001 			// <STRG><F4> -> close top frame
//STRIP001 			CloseWindow();
//STRIP001 			bHandled = sal_True;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bHandled ? 1 : Window::PreNotify( rNEvt );
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpWindow_Impl::setContainerWindow( Reference < ::com::sun::star::awt::XWindow > xWin )
//STRIP001 {
//STRIP001 	xWindow = xWin;
//STRIP001 	MakeLayout();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpWindow_Impl::SetFactory( const String& rFactory )
//STRIP001 {
//STRIP001 	pIndexWin->SetFactory( rFactory, sal_True );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpWindow_Impl::SetHelpURL( const String& rURL )
//STRIP001 {
//STRIP001 	INetURLObject aObj( rURL );
//STRIP001 	if ( aObj.GetProtocol() == INET_PROT_VND_SUN_STAR_HELP )
//STRIP001 		SetFactory( aObj.GetHost() );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpWindow_Impl::DoAction( USHORT nActionId )
//STRIP001 {
//STRIP001 	switch ( nActionId )
//STRIP001 	{
//STRIP001 		case TBI_INDEX :
//STRIP001 		{
//STRIP001 			bIndex = !bIndex;
//STRIP001 			MakeLayout();
//STRIP001 			pTextWin->ToggleIndex( bIndex );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case TBI_START :
//STRIP001 		{
//STRIP001 			ShowStartPage();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case TBI_BACKWARD :
//STRIP001 		case TBI_FORWARD :
//STRIP001 		{
//STRIP001 			URL aURL;
//STRIP001 	        aURL.Complete = DEFINE_CONST_UNICODE(".uno:Backward");
//STRIP001 			if ( TBI_FORWARD == nActionId )
//STRIP001 		        aURL.Complete = DEFINE_CONST_UNICODE(".uno:Forward");
//STRIP001 			PARSE_URL( aURL );
//STRIP001 			pHelpInterceptor->dispatch( aURL, Sequence < PropertyValue >() );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case TBI_PRINT :
//STRIP001 		case TBI_SOURCEVIEW :
//STRIP001 		case TBI_SEARCHDIALOG :
//STRIP001 		case TBI_COPY :
//STRIP001         case TBI_SELECTIONMODE:
//STRIP001 		{
//STRIP001 			Reference < XDispatchProvider > xProv( pTextWin->getFrame(), UNO_QUERY );
//STRIP001 			if ( xProv.is() )
//STRIP001 			{
//STRIP001 				URL aURL;
//STRIP001 				if ( TBI_PRINT == nActionId )
//STRIP001 		        	aURL.Complete = DEFINE_CONST_UNICODE(".uno:Print");
//STRIP001 				else if ( TBI_SOURCEVIEW == nActionId )
//STRIP001 		        	aURL.Complete = DEFINE_CONST_UNICODE(".uno:SourceView");
//STRIP001 				else if ( TBI_COPY == nActionId )
//STRIP001 		        	aURL.Complete = DEFINE_CONST_UNICODE(".uno:Copy");
//STRIP001                 else if ( TBI_SELECTIONMODE == nActionId )
//STRIP001                     aURL.Complete = DEFINE_CONST_UNICODE(".uno:SelectTextMode");
//STRIP001                 else
//STRIP001 		        	aURL.Complete = DEFINE_CONST_UNICODE(".uno:SearchDialog");
//STRIP001 				PARSE_URL( aURL );
//STRIP001             	Reference < XDispatch > xDisp = xProv->queryDispatch( aURL, String(), 0 );
//STRIP001             	if ( xDisp.is() )
//STRIP001                 	xDisp->dispatch( aURL, Sequence < PropertyValue >() );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case TBI_BOOKMARKS :
//STRIP001 		{
//STRIP001 			String aURL = pHelpInterceptor->GetCurrentURL();
//STRIP001 			if ( aURL.Len() > 0 )
//STRIP001 			{
//STRIP001 				try
//STRIP001 				{
//STRIP001 					Content aCnt( aURL, Reference< ::com::sun::star::ucb::XCommandEnvironment > () );
//STRIP001 					::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySetInfo > xInfo = aCnt.getProperties();
//STRIP001 					if ( xInfo->hasPropertyByName( PROPERTY_TITLE ) )
//STRIP001 					{
//STRIP001 						::com::sun::star::uno::Any aAny = aCnt.getPropertyValue( PROPERTY_TITLE );
//STRIP001 						::rtl::OUString aValue;
//STRIP001 						if ( aAny >>= aValue )
//STRIP001 						{
//STRIP001 							String aTitle( aValue );
//STRIP001 							SfxAddHelpBookmarkDialog_Impl aDlg( this, sal_False );
//STRIP001 							aDlg.SetTitle( aTitle );
//STRIP001 							if ( aDlg.Execute() == RET_OK )
//STRIP001 							{
//STRIP001 								aTitle = aDlg.GetTitle();
//STRIP001 								pIndexWin->AddBookmarks( aTitle, aURL );
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 				catch( Exception& )
//STRIP001 				{
//STRIP001 					DBG_ERROR( "SfxHelpWindow_Impl::DoAction(): unexpected exception" );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpWindow_Impl::CloseWindow()
//STRIP001 {
//STRIP001 	try
//STRIP001 	{
//STRIP001 		// search for top frame
//STRIP001 		Reference< XFramesSupplier > xCreator = getTextFrame()->getCreator();
//STRIP001 		while ( xCreator.is() && !xCreator->isTop() )
//STRIP001 		{
//STRIP001 		    xCreator = xCreator->getCreator();
//STRIP001 		}
//STRIP001 
//STRIP001 		// when found, close it
//STRIP001 		if ( xCreator.is() && xCreator->isTop() )
//STRIP001 		{
//STRIP001 			Reference < XCloseable > xCloser( xCreator, UNO_QUERY );
//STRIP001 			if ( xCloser.is() )
//STRIP001 				xCloser->close( sal_False );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch( Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "SfxHelpWindow_Impl::CloseWindow(): caught an exception" );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxHelpWindow_Impl::UpdateToolbox()
//STRIP001 {
//STRIP001 	pTextWin->GetToolBox().EnableItem( TBI_BACKWARD, pHelpInterceptor->HasHistoryPred() );
//STRIP001 	pTextWin->GetToolBox().EnableItem( TBI_FORWARD, pHelpInterceptor->HasHistorySucc() );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SfxHelpWindow_Impl::HasHistoryPredecessor() const
//STRIP001 {
//STRIP001 	return pHelpInterceptor->HasHistoryPred();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SfxHelpWindow_Impl::HasHistorySuccessor() const
//STRIP001 {
//STRIP001 	return pHelpInterceptor->HasHistorySucc();
//STRIP001 }
//STRIP001 
//STRIP001 // class SfxAddHelpBookmarkDialog_Impl -----------------------------------
//STRIP001 
//STRIP001 SfxAddHelpBookmarkDialog_Impl::SfxAddHelpBookmarkDialog_Impl( Window* pParent, sal_Bool bRename ) :
//STRIP001 
//STRIP001 	ModalDialog( pParent, SfxResId( DLG_HELP_ADDBOOKMARK ) ),
//STRIP001 
//STRIP001 	aTitleFT	( this, ResId( FT_BOOKMARK_TITLE ) ),
//STRIP001 	aTitleED	( this, ResId( ED_BOOKMARK_TITLE ) ),
//STRIP001 	aOKBtn		( this, ResId( PB_BOOKMARK_OK ) ),
//STRIP001 	aEscBtn		( this, ResId( PB_BOOKMARK_CANCEL ) ),
//STRIP001 	aHelpBtn	( this, ResId( PB_BOOKMARK_HELP ) )
//STRIP001 
//STRIP001 {
//STRIP001 	if ( bRename )
//STRIP001 		SetText( String( ResId( STR_BOOKMARK_RENAME ) ) );
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxAddHelpBookmarkDialog_Impl::~SfxAddHelpBookmarkDialog_Impl()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxAddHelpBookmarkDialog_Impl::SetTitle( const String& rTitle )
//STRIP001 {
//STRIP001 	aTitleED.SetText( rTitle );
//STRIP001 	aTitleED.SetSelection( Selection( 0, rTitle.Len() ) );
//STRIP001 }
//STRIP001 
}
