/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_viewshe2.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:46:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVXIDS_HRC

#include <bf_svx/svxids.hrc>
#endif
#ifndef _SCRBAR_HXX //autogen
#include <vcl/scrbar.hxx>
#endif
// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SFXAPP_HXX //autogen
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
// auto strip #ifndef _SCH_DLL_HXX //autogen
// auto strip #include <bf_sch/schdll.hxx>
// auto strip #endif
// auto strip #ifndef _SCHDLL0_HXX
// auto strip #include <bf_sch/schdll0.hxx>
// auto strip #endif
// auto strip #ifndef _SMDLL_HXX //autogen
// auto strip #include <bf_starmath/smdll.hxx>
// auto strip #endif
// auto strip #ifndef SC_SCDLL_HXX //autogen
// auto strip #include <bf_sc/scdll.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_RULER_HXX //autogen
// auto strip #include <bf_svx/ruler.hxx>
// auto strip #endif
// auto strip #ifndef _OUTLINER_HXX //autogen
// auto strip #include <bf_svx/outliner.hxx>
// auto strip #endif
// auto strip #ifndef _EHDL_HXX //autogen
// auto strip #include <svtools/ehdl.hxx>
// auto strip #endif
// auto strip #ifndef _SVSTOR_HXX //autogen
// auto strip #include <so3/svstor.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOOLE2_HXX //autogen
// auto strip #include <bf_svx/svdoole2.hxx>
// auto strip #endif
// auto strip #ifndef _SOERR_HXX //autogen
// auto strip #include <so3/soerr.hxx>
// auto strip #endif
// auto strip #ifndef _SFXECODE_HXX
// auto strip #include <svtools/sfxecode.hxx>
// auto strip #endif
// auto strip #ifndef _IPENV_HXX //autogen
// auto strip #include <so3/ipenv.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_FMSHELL_HXX			// XXX nur temp (dg)
// auto strip #include <bf_svx/fmshell.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

// auto strip #include "misc.hxx"

#ifdef STARIMAGE_AVAILABLE
// auto strip #ifndef _SIMDLL_HXX
// auto strip #include <sim2/simdll.hxx>
// auto strip #endif
#endif

#include "strings.hrc"
#include "app.hrc"

#ifndef _SD_UNOKYWDS_HXX_
#include "unokywds.hxx"
#endif

// auto strip #include "sdundogr.hxx"
#include "frmview.hxx"
// auto strip #include "undopage.hxx"
// auto strip #include "sdresid.hxx"
// auto strip #include "drawdoc.hxx"
// auto strip #include "viewshel.hxx"
#include "sdview.hxx"
// auto strip #include "fupoor.hxx"
// auto strip #include "sdclient.hxx"
#include "docshell.hxx"
#include "fusearch.hxx"
#include "fuslshow.hxx"
// auto strip #include "sdpage.hxx"
#include "drviewsh.hxx"

#ifndef _SD_SDWINDOW_HXX
#include "sdwindow.hxx"
#endif

namespace binfilter {

#ifndef SO2_DECL_SVINPLACEOBJECT_DEFINED
#define SO2_DECL_SVINPLACEOBJECT_DEFINED
SO2_DECL_REF(SvInPlaceObject)
#endif
#ifndef SO2_DECL_SVSTORAGE_DEFINED
#define SO2_DECL_SVSTORAGE_DEFINED
SO2_DECL_REF(SvStorage)
#endif

#ifdef WNT
#pragma optimize ( "", off )
#endif

using namespace ::com::sun::star;

/*************************************************************************
|*
|* Scrollbar-Update: Thumbpos und VisibleSize anpassen
|*
\************************************************************************/

/*N*/ void SdViewShell::UpdateScrollBars()
/*N*/ {
/*N*/ 	short i;
/*N*/ 
/*N*/ 	for (i = 0; i < MAX_HSPLIT_CNT && pHScrlArray[i]; i++)
/*N*/ 	{
/*N*/ 		long nW = (long)(pWinArray[i][0]->GetVisibleWidth() * 32000);
/*N*/ 		long nX = (long)(pWinArray[i][0]->GetVisibleX() * 32000);
/*N*/ 		pHScrlArray[i]->SetVisibleSize(nW);
/*N*/ 		pHScrlArray[i]->SetThumbPos(nX);
/*N*/ 		nW = 32000 - nW;
/*N*/ 		long nLine = (long) (pWinArray[i][0]->GetScrlLineWidth() * nW);
/*N*/ 		long nPage = (long) (pWinArray[i][0]->GetScrlPageWidth() * nW);
/*N*/ 		pHScrlArray[i]->SetLineSize(nLine);
/*N*/ 		pHScrlArray[i]->SetPageSize(nPage);
/*N*/ 	}
/*N*/ 
/*N*/ 	for (i = 0; i < MAX_VSPLIT_CNT && pVScrlArray[i]; i++)
/*N*/ 	{
/*N*/ 		long nH = (long)(pWinArray[0][i]->GetVisibleHeight() * 32000);
/*N*/ 		long nY = (long)(pWinArray[0][i]->GetVisibleY() * 32000);
/*N*/ 		pVScrlArray[i]->SetVisibleSize(nH);
/*N*/ 		pVScrlArray[i]->SetThumbPos(nY);
/*N*/ 		nH = 32000 - nH;
/*N*/ 		long nLine = (long) (pWinArray[0][i]->GetScrlLineHeight() * nH);
/*N*/ 		long nPage = (long) (pWinArray[0][i]->GetScrlPageHeight() * nH);
/*N*/ 		pVScrlArray[i]->SetLineSize(nLine);
/*N*/ 		pVScrlArray[i]->SetPageSize(nPage);
/*N*/ 	}
/*N*/ 	if ( bHasRuler )
/*N*/ 	{
/*N*/ 		UpdateHRuler();
/*N*/ 		UpdateVRuler();
/*N*/ 	}
/*N*/ 
/*N*/ }
/*************************************************************************
|*
|* Handling fuer horizontale Scrollbars
|*
\************************************************************************/

IMPL_LINK_INLINE_START( SdViewShell, HScrollHdl, ScrollBar *, pHScroll )
{
	DBG_BF_ASSERT(0, "STRIP"); return 0; //STRIP001 return VirtHScrollHdl(pHScroll);
}
IMPL_LINK_INLINE_END( SdViewShell, HScrollHdl, ScrollBar *, pHScroll )

/*************************************************************************
|*
|* virtueller Scroll-Handler fuer horizontale Scrollbars
|*
\************************************************************************/

//STRIP001 long SdViewShell::VirtHScrollHdl(ScrollBar* pHScroll)
//STRIP001 {
//STRIP001 	long nDelta = pHScroll->GetDelta();
//STRIP001 
//STRIP001 	if (nDelta != 0)
//STRIP001 	{
//STRIP001 		short nX = 0, nY = 0;
//STRIP001 
//STRIP001 		// Spalte der zu scrollenden Fenster bestimmen
//STRIP001 		while ( nX < MAX_HSPLIT_CNT &&	pHScroll != pHScrlArray[nX] )
//STRIP001 			++nX;
//STRIP001 
//STRIP001 		double fX = (double) pHScroll->GetThumbPos() / pHScroll->GetRange().Len();
//STRIP001 
//STRIP001 		// alle Fenster der Spalte scrollen
//STRIP001 		while ( nY < MAX_VSPLIT_CNT && pWinArray[nX][nY] )
//STRIP001 		{
//STRIP001 			SdView* pView = GetView();
//STRIP001 			OutlinerView* pOLV = NULL;
//STRIP001 
//STRIP001 			if (pView)
//STRIP001 				pOLV = pView->GetTextEditOutlinerView();
//STRIP001 
//STRIP001 			if (pOLV)
//STRIP001 				pOLV->HideCursor();
//STRIP001 
//STRIP001 			pWinArray[nX][nY++]->SetVisibleXY(fX, -1);
//STRIP001 
//STRIP001 			Rectangle aVisArea = pDocSh->GetVisArea(ASPECT_CONTENT);
//STRIP001 			Point aVisAreaPos = pWindow->PixelToLogic( Point(0,0) );
//STRIP001 			aVisArea.SetPos(aVisAreaPos);
//STRIP001 			pDocSh->SetVisArea(aVisArea);
//STRIP001 
//STRIP001 			Size aVisSizePixel = pWindow->GetOutputSizePixel();
//STRIP001 			Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0), aVisSizePixel) );
//STRIP001 			VisAreaChanged(aVisAreaWin);
//STRIP001 
//STRIP001 			if (pView)
//STRIP001 			{
//STRIP001 				pView->VisAreaChanged(pWindow);
//STRIP001 			}
//STRIP001 
//STRIP001 			if (pOLV)
//STRIP001 				pOLV->ShowCursor();
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bHasRuler )
//STRIP001 			UpdateHRuler();
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
|* Handling fuer vertikale Scrollbars
|*
\************************************************************************/

IMPL_LINK_INLINE_START( SdViewShell, VScrollHdl, ScrollBar *, pVScroll )
{
	DBG_BF_ASSERT(0, "STRIP"); return 0; //STRIP001 return VirtVScrollHdl(pVScroll);
}
IMPL_LINK_INLINE_END( SdViewShell, VScrollHdl, ScrollBar *, pVScroll )

/*************************************************************************
|*
|* Handling fuer vertikale Scrollbars
|*
\************************************************************************/

//STRIP001 long SdViewShell::VirtVScrollHdl(ScrollBar* pVScroll)
//STRIP001 {
//STRIP001 	long nDelta = pVScroll->GetDelta();
//STRIP001 
//STRIP001 	if (nDelta != 0)
//STRIP001 	{
//STRIP001 		short nX = 0, nY = 0;
//STRIP001 
//STRIP001 		// Zeile der zu scrollenden Fenster bestimmen
//STRIP001 		while ( nY < MAX_VSPLIT_CNT &&	pVScroll != pVScrlArray[nY] )
//STRIP001 			++nY;
//STRIP001 
//STRIP001 		double fY = (double) pVScroll->GetThumbPos() / pVScroll->GetRange().Len();
//STRIP001 
//STRIP001 		// alle Fenster der Zeile scrollen
//STRIP001 		while ( nX < MAX_HSPLIT_CNT && pWinArray[nX][nY] )
//STRIP001 		{
//STRIP001 			SdView* pView = GetView();
//STRIP001 			OutlinerView* pOLV = NULL;
//STRIP001 
//STRIP001 			if (pView)
//STRIP001 				pOLV = pView->GetTextEditOutlinerView();
//STRIP001 
//STRIP001 			if (pOLV)
//STRIP001 				pOLV->HideCursor();
//STRIP001 
//STRIP001 			pWinArray[nX++][nY]->SetVisibleXY(-1, fY);
//STRIP001 
//STRIP001 			Rectangle aVisArea = pDocSh->GetVisArea(ASPECT_CONTENT);
//STRIP001 			Point aVisAreaPos = pWindow->PixelToLogic( Point(0,0) );
//STRIP001 			aVisArea.SetPos(aVisAreaPos);
//STRIP001 			pDocSh->SetVisArea(aVisArea);
//STRIP001 
//STRIP001 			Size aVisSizePixel = pWindow->GetOutputSizePixel();
//STRIP001 			Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0), aVisSizePixel) );
//STRIP001 			VisAreaChanged(aVisAreaWin);
//STRIP001 
//STRIP001 			if (pView)
//STRIP001 			{
//STRIP001 				pView->VisAreaChanged(pWindow);
//STRIP001 			}
//STRIP001 
//STRIP001 			if (pOLV)
//STRIP001 				pOLV->ShowCursor();
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bHasRuler )
//STRIP001 			UpdateVRuler();
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
|* Eine bestimmte Anzahl von Zeilen scrollen (wird beim automatischen
|* Scrollen (Zeichen/Draggen) verwendet)
|*
\************************************************************************/

//STRIP001 void SdViewShell::ScrollLines(long nLinesX, long nLinesY)
//STRIP001 {
//STRIP001 	short nX, nY;
//STRIP001 	for (nX = 0; nX < MAX_HSPLIT_CNT; nX++)
//STRIP001 	{
//STRIP001 		nY = 0;
//STRIP001 		while ( nY < MAX_VSPLIT_CNT && pWindow != pWinArray[nX][nY] )
//STRIP001 			nY++;
//STRIP001 		if ( nY < MAX_VSPLIT_CNT )
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	if ( nLinesX )
//STRIP001 	{
//STRIP001 		nLinesX *= pHScrlArray[nX]->GetLineSize();
//STRIP001 	}
//STRIP001 	if ( nLinesY )
//STRIP001 	{
//STRIP001 		nLinesY *= pVScrlArray[nY]->GetLineSize();
//STRIP001 	}
//STRIP001 
//STRIP001 	Scroll(nLinesX, nLinesY);
//STRIP001 }

/*************************************************************************
|*
|* Window um nScrollX, nScrollY scrollen
|*
\************************************************************************/

//STRIP001 void SdViewShell::Scroll(long nScrollX, long nScrollY)
//STRIP001 {
//STRIP001 	short nX, nY;
//STRIP001 	for (nX = 0; nX < MAX_HSPLIT_CNT; nX++)
//STRIP001 	{
//STRIP001 		nY = 0;
//STRIP001 		while ( nY < MAX_VSPLIT_CNT && pWindow != pWinArray[nX][nY] )
//STRIP001 			nY++;
//STRIP001 		if ( nY < MAX_VSPLIT_CNT )
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nScrollX)
//STRIP001 	{
//STRIP001 		long nLineSize = pHScrlArray[nX]->GetLineSize();
//STRIP001 
//STRIP001 		long nNewThumb = pHScrlArray[nX]->GetThumbPos() + nScrollX;
//STRIP001 		pHScrlArray[nX]->SetThumbPos(nNewThumb);
//STRIP001 	}
//STRIP001 	if (nScrollY)
//STRIP001 	{
//STRIP001 		long nNewThumb = pVScrlArray[nY]->GetThumbPos() + nScrollY;
//STRIP001 		pVScrlArray[nY]->SetThumbPos(nNewThumb);
//STRIP001 	}
//STRIP001 	double	fX = (double) pHScrlArray[nX]->GetThumbPos() /
//STRIP001 							pHScrlArray[nX]->GetRange().Len();
//STRIP001 	double	fY = (double) pVScrlArray[nY]->GetThumbPos() /
//STRIP001 							pVScrlArray[nY]->GetRange().Len();
//STRIP001 
//STRIP001 	pWindow->SetVisibleXY(fX, fY);
//STRIP001 
//STRIP001 	if ( bIsHSplit || bIsVSplit )	// alle Fenster der gleichen Spalte
//STRIP001 	{								// sowie Zeile scrollen
//STRIP001 		short i;
//STRIP001 
//STRIP001 		for (i = 0; i < MAX_HSPLIT_CNT; i++)
//STRIP001 			if ( i != nX && pWinArray[i][nY] )
//STRIP001 				pWinArray[i][nY]->SetVisibleXY(-1, fY);
//STRIP001 
//STRIP001 		for (i = 0; i < MAX_VSPLIT_CNT; i++)
//STRIP001 			if ( i != nY && pWinArray[nX][i] )
//STRIP001 			pWinArray[nX][i]->SetVisibleXY(fX, -1);
//STRIP001 	}
//STRIP001 
//STRIP001 	Rectangle aVisArea = pDocSh->GetVisArea(ASPECT_CONTENT);
//STRIP001 	Point aVisAreaPos = pWindow->PixelToLogic( Point(0,0) );
//STRIP001 	aVisArea.SetPos(aVisAreaPos);
//STRIP001 	pDocSh->SetVisArea(aVisArea);
//STRIP001 
//STRIP001 	Size aVisSizePixel = pWindow->GetOutputSizePixel();
//STRIP001 	Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0), aVisSizePixel) );
//STRIP001 	VisAreaChanged(aVisAreaWin);
//STRIP001 
//STRIP001 	SdView* pView = GetView();
//STRIP001 	if (pView)
//STRIP001 	{
//STRIP001 		pView->VisAreaChanged(pWindow);
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bHasRuler )
//STRIP001 	{
//STRIP001 		UpdateHRuler();
//STRIP001 		UpdateVRuler();
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Den Zoomfaktor fuer alle Split-Windows setzen
|*
\************************************************************************/

//STRIP001 void SdViewShell::SetZoom(long nZoom)
//STRIP001 {
//STRIP001 	Fraction aUIScale(nZoom, 100);
//STRIP001 	aUIScale *= pDoc->GetUIScale();
//STRIP001 
//STRIP001 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
//STRIP001 	{
//STRIP001 		if ( pHRulerArray[nX] )
//STRIP001 			pHRulerArray[nX]->SetZoom(aUIScale);
//STRIP001 
//STRIP001 		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
//STRIP001 		{
//STRIP001 			if ( nX == 0 && pVRulerArray[nY] )
//STRIP001 				pVRulerArray[nY]->SetZoom(aUIScale);
//STRIP001 
//STRIP001 			if ( pWinArray[nX][nY] )
//STRIP001 			{
//STRIP001 				pWinArray[nX][nY]->SetZoom(nZoom);
//STRIP001 				pWinArray[nX][nY]->Invalidate();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	Size aVisSizePixel = pWindow->GetOutputSizePixel();
//STRIP001 	Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0), aVisSizePixel) );
//STRIP001 	VisAreaChanged(aVisAreaWin);
//STRIP001 
//STRIP001 	SdView* pView = GetView();
//STRIP001 	if (pView)
//STRIP001 	{
//STRIP001 		pView->VisAreaChanged(pWindow);
//STRIP001 	}
//STRIP001 
//STRIP001 	UpdateScrollBars();
//STRIP001 }

/*************************************************************************
|*
|* Zoomrechteck fuer aktives Fenster einstellen und alle Split-Windows
|* auf den gleichen Zoomfaktor setzen
|*
\************************************************************************/

//STRIP001 void SdViewShell::SetZoomRect(const Rectangle& rZoomRect)
//STRIP001 {
//STRIP001 	short nX, nY, nCol, nRow;
//STRIP001 	long nZoom = pWindow->SetZoomRect(rZoomRect);
//STRIP001 	Fraction aUIScale(nZoom, 100);
//STRIP001 	aUIScale *= pDoc->GetUIScale();
//STRIP001 
//STRIP001 	for (nX = 0; nX < MAX_HSPLIT_CNT; nX++)
//STRIP001 		for (nY = 0; nY < MAX_VSPLIT_CNT; nY++)
//STRIP001 			if ( pWinArray[nX][nY] == pWindow )
//STRIP001 			{	nCol = nX; nRow = nY; }
//STRIP001 
//STRIP001 	Point aPos = pWindow->GetWinViewPos();
//STRIP001 
//STRIP001 	for (nX = 0; nX < MAX_HSPLIT_CNT; nX++)
//STRIP001 	{
//STRIP001 		if ( pHRulerArray[nX] )
//STRIP001 			pHRulerArray[nX]->SetZoom(aUIScale);
//STRIP001 
//STRIP001 		for (nY = 0; nY < MAX_VSPLIT_CNT; nY++)
//STRIP001 		{
//STRIP001 			if ( nX == 0 && pVRulerArray[nY] )
//STRIP001 				pVRulerArray[nY]->SetZoom(aUIScale);
//STRIP001 
//STRIP001 			if ( pWinArray[nX][nY] )
//STRIP001 			{
//STRIP001 				Point aNewPos = pWinArray[nX][nY]->GetWinViewPos();
//STRIP001 				if ( nX == nCol )	aNewPos.X() = aPos.X();
//STRIP001 				if ( nY == nRow )	aNewPos.Y() = aPos.Y();
//STRIP001 				pWinArray[nX][nY]->SetZoom(nZoom);
//STRIP001 				pWinArray[nX][nY]->SetWinViewPos(aNewPos);
//STRIP001 				pWinArray[nX][nY]->UpdateMapOrigin();
//STRIP001 				pWinArray[nX][nY]->Invalidate();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	Size aVisSizePixel = pWindow->GetOutputSizePixel();
//STRIP001 	Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0), aVisSizePixel) );
//STRIP001 	VisAreaChanged(aVisAreaWin);
//STRIP001 
//STRIP001 	SdView* pView = GetView();
//STRIP001 	if (pView)
//STRIP001 	{
//STRIP001 		pView->VisAreaChanged(pWindow);
//STRIP001 	}
//STRIP001 
//STRIP001 	UpdateScrollBars();
//STRIP001 }

/*************************************************************************
|*
|* Abbildungsparameter fuer alle Split-Windows initialisieren
|*
\************************************************************************/

/*N*/ void SdViewShell::InitWindows(const Point& rViewOrigin, const Size& rViewSize,
/*N*/ 							  const Point& rWinPos, BOOL bUpdate)
/*N*/ {
/*N*/ 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
/*N*/ 	{
/*N*/ 		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
/*N*/ 		{
/*N*/ 			if ( pWinArray[nX][nY] )
/*N*/ 			{
/*N*/ 				pWinArray[nX][nY]->SetViewOrigin(rViewOrigin);
/*N*/ 				pWinArray[nX][nY]->SetViewSize(rViewSize);
/*N*/ 				pWinArray[nX][nY]->SetWinViewPos(rWinPos);
/*N*/ 
/*N*/ 				if ( bUpdate )
/*N*/ 				{
/*N*/ 					pWinArray[nX][nY]->UpdateMapOrigin();
/*N*/ 					pWinArray[nX][nY]->Invalidate();
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	Size aVisSizePixel = pWindow->GetOutputSizePixel();
/*N*/ 	Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0), aVisSizePixel) );
/*N*/ 	VisAreaChanged(aVisAreaWin);
/*N*/ 
/*N*/ 	SdView* pView = GetView();
/*N*/ 	if (pView)
/*N*/ 	{
/*N*/ 		pView->VisAreaChanged(pWindow);
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Alle Split-Windows unter dem uebergebenen Rechteck invalidieren
|*
\************************************************************************/

/*N*/ void SdViewShell::InvalidateWindows()
/*N*/ {
/*N*/ 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
/*N*/ 		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
/*N*/ 			if ( pWinArray[nX][nY] )
/*N*/ 				pWinArray[nX][nY]->Invalidate();
/*N*/ }

/*************************************************************************
|*
|* ObjectBar umschalten, ResourceID der alten ObjectBar-ID zurueckgeben
|*
\************************************************************************/

/*N*/ USHORT SdViewShell::SwitchObjectBar(USHORT nSdResId)
/*N*/ {
/*N*/ 	USHORT nReturn = nCurrentObjectBar;
/*N*/ 
/*N*/ 	if (nCurrentObjectBar != nSdResId && bObjectBarSwitchEnabled)
/*N*/ 	{
/*N*/ 		nCurrentObjectBar = nSdResId;
/*N*/ 
/*N*/ 		if (nCurrentObjectBar)
/*N*/ 		{
/*N*/ 			//  SfxDispatcher* pDispatcher = GetViewFrame()->GetDispatcher();
/*N*/ 			//pDispatcher->Push(*(SfxShell*)aShellTable.Get(nCurrentObjectBar));
/*N*/ 			RemoveSubShell();
/*N*/ 
/*N*/ 			if ( ISA(SdDrawViewShell) )
/*N*/ 			{
/*N*/ 				AddSubShell( *(SfxShell*) aShellTable.Get( RID_FORMLAYER_TOOLBOX ) );
/*N*/ 
/*N*/  				if ( nCurrentObjectBar == RID_DRAW_TEXT_TOOLBOX )
/*?*/  					AddSubShell( *(SfxShell*) aShellTable.Get( RID_DRAW_OBJ_TOOLBOX ) );
/*N*/  			}
/*N*/ 
/*N*/ 			AddSubShell( *(SfxShell*) aShellTable.Get( nCurrentObjectBar ) );
/*N*/ 		}
/*N*/ 	}
/*N*/ 	return nReturn;
/*N*/ }

/*************************************************************************
|*
|* Auf allen Split-Windows ein Markierungsrechteck mit dem
|* uebergebenen Pen zeichnen
|*
\************************************************************************/

//STRIP001 void SdViewShell::DrawMarkRect(const Rectangle& rRect) const
//STRIP001 {
//STRIP001 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
//STRIP001 	{
//STRIP001 		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
//STRIP001 		{
//STRIP001 			if ( pWinArray[nX][nY] )
//STRIP001 			{
//STRIP001 				pWinArray[nX][nY]->InvertTracking(rRect, SHOWTRACK_OBJECT | SHOWTRACK_WINDOW);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|* Auf allen Split-Windows ein Rechteck zeichnen. Fuer den Rahmen wird der
|* uebergebene Pen, zum Fuellen die uebergebene Brush benutzt.
|*
\************************************************************************/

//STRIP001 void SdViewShell::DrawFilledRect( const Rectangle& rRect, const Color& rLColor,
//STRIP001 								  const Color& rFColor ) const
//STRIP001 {
//STRIP001 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
//STRIP001 	{
//STRIP001 		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
//STRIP001 		{
//STRIP001 			if ( pWinArray[nX][nY] )
//STRIP001 			{
//STRIP001 				const Color& rOldLineColor = pWinArray[nX][nY]->GetLineColor();
//STRIP001 				const Color& rOldFillColor = pWinArray[nX][nY]->GetFillColor();
//STRIP001 
//STRIP001 				pWinArray[nX][nY]->SetLineColor( rLColor );
//STRIP001 				pWinArray[nX][nY]->SetFillColor( rFColor );
//STRIP001 
//STRIP001 				pWinArray[nX][nY]->DrawRect(rRect);
//STRIP001 
//STRIP001 				pWinArray[nX][nY]->SetLineColor( rOldLineColor );
//STRIP001 				pWinArray[nX][nY]->SetFillColor( rOldFillColor );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Modus-Umschaltung (Draw, Slide, Outline)
|*
\************************************************************************/

IMPL_LINK( SdViewShell, ModeBtnHdl, Button *, pButton )
{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if	( !((ImageButton*) pButton)->IsChecked() )
//STRIP001 	{
//STRIP001 		if ( pButton == &aDrawBtn )
//STRIP001 		{
//STRIP001 			pFrameView->SetPageKind(PK_STANDARD);
//STRIP001 			GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL0,
//STRIP001 					SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 		}
//STRIP001 		else if ( pButton == &aNotesBtn )
//STRIP001 		{
//STRIP001 			pFrameView->SetPageKind(PK_NOTES);
//STRIP001 			pFrameView->SetLayerMode(FALSE);
//STRIP001 			GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL0,
//STRIP001 					SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 		}
//STRIP001 		else if ( pButton == &aHandoutBtn )
//STRIP001 		{
//STRIP001 			pFrameView->SetPageKind(PK_HANDOUT);
//STRIP001 			pFrameView->SetLayerMode(FALSE);
//STRIP001 			GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL0,
//STRIP001 					SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 		}
//STRIP001 		else if ( pButton == &aSlideBtn )
//STRIP001 		{
//STRIP001 			GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL1,
//STRIP001 					SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 		}
//STRIP001 		else if ( pButton == &aOutlineBtn )
//STRIP001 		{
//STRIP001 			GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL2,
//STRIP001 					SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 		}
//STRIP001 		else if ( pButton == &aPresentationBtn )
//STRIP001 		{
//STRIP001 			GetViewFrame()->GetDispatcher()->Execute(SID_PRESENTATION,
//STRIP001 					SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 		}
//STRIP001 	}
	return 0;
}

/*************************************************************************
|*
|* Groesse und Raender aller Seiten setzen
|*
\************************************************************************/

//STRIP001 void SdViewShell::SetPageSizeAndBorder(PageKind ePageKind, const Size& rNewSize,
//STRIP001 									   long nLeft, long nRight,
//STRIP001 									   long nUpper, long nLower, BOOL bScaleAll,
//STRIP001 									   Orientation eOrientation, USHORT nPaperBin,
//STRIP001 							           BOOL bBackgroundFullSize)
//STRIP001 {
//STRIP001 	SdPage* pPage;
//STRIP001 	SdUndoGroup* pUndoGroup = NULL;
//STRIP001 	pUndoGroup = new SdUndoGroup(pDoc);
//STRIP001 	String aString(SdResId(STR_UNDO_CHANGE_PAGEFORMAT));
//STRIP001 	pUndoGroup->SetComment(aString);
//STRIP001 
//STRIP001 	USHORT i, nPageCnt = pDoc->GetMasterSdPageCount(ePageKind);
//STRIP001 
//STRIP001 	for (i = 0; i < nPageCnt; i++)
//STRIP001 	{
//STRIP001 		/**********************************************************************
//STRIP001 		* Erst alle MasterPages bearbeiten
//STRIP001 		**********************************************************************/
//STRIP001 		pPage = pDoc->GetMasterSdPage(i, ePageKind);
//STRIP001 
//STRIP001 		SdUndoAction* pUndo = new SdPageFormatUndoAction(pDoc, pPage,
//STRIP001 							pPage->GetSize(),
//STRIP001 							pPage->GetLftBorder(), pPage->GetRgtBorder(),
//STRIP001 							pPage->GetUppBorder(), pPage->GetLwrBorder(),
//STRIP001 							pPage->IsScaleObjects(),
//STRIP001 							pPage->GetOrientation(),
//STRIP001 							pPage->GetPaperBin(),
//STRIP001 							pPage->IsBackgroundFullSize(),
//STRIP001 							rNewSize,
//STRIP001 							nLeft, nRight,
//STRIP001 							nUpper, nLower,
//STRIP001 							bScaleAll,
//STRIP001 							eOrientation,
//STRIP001 							nPaperBin,
//STRIP001 							bBackgroundFullSize);
//STRIP001 		pUndoGroup->AddAction(pUndo);
//STRIP001 
//STRIP001 		const SfxPoolItem* pPoolItem = NULL;
//STRIP001 
//STRIP001 		if (rNewSize.Width() > 0 ||
//STRIP001 			nLeft  >= 0 || nRight >= 0 || nUpper >= 0 || nLower >= 0)
//STRIP001 		{
//STRIP001 			Rectangle aNewBorderRect(nLeft, nUpper, nRight, nLower);
//STRIP001 			pPage->ScaleObjects(rNewSize, aNewBorderRect, bScaleAll);
//STRIP001 
//STRIP001 			if (rNewSize.Width() > 0)
//STRIP001 				pPage->SetSize(rNewSize);
//STRIP001 		}
//STRIP001 
//STRIP001 		if( nLeft  >= 0 || nRight >= 0 || nUpper >= 0 || nLower >= 0 )
//STRIP001 		{
//STRIP001 			pPage->SetBorder(nLeft, nUpper, nRight, nLower);
//STRIP001 		}
//STRIP001 
//STRIP001 		pPage->SetOrientation(eOrientation);
//STRIP001 		pPage->SetPaperBin( nPaperBin );
//STRIP001 		pPage->SetBackgroundFullSize( bBackgroundFullSize );
//STRIP001 
//STRIP001 		if ( ePageKind == PK_STANDARD )
//STRIP001 			pDoc->GetMasterSdPage(i, PK_NOTES)->CreateTitleAndLayout();
//STRIP001 
//STRIP001 		pPage->CreateTitleAndLayout();
//STRIP001 	}
//STRIP001 
//STRIP001 	nPageCnt = pDoc->GetSdPageCount(ePageKind);
//STRIP001 
//STRIP001 	for (i = 0; i < nPageCnt; i++)
//STRIP001 	{
//STRIP001 		/**********************************************************************
//STRIP001 		* Danach alle Pages bearbeiten
//STRIP001 		**********************************************************************/
//STRIP001 		pPage = pDoc->GetSdPage(i, ePageKind);
//STRIP001 
//STRIP001 		SdUndoAction* pUndo = new SdPageFormatUndoAction(pDoc, pPage,
//STRIP001 								pPage->GetSize(),
//STRIP001 								pPage->GetLftBorder(), pPage->GetRgtBorder(),
//STRIP001 								pPage->GetUppBorder(), pPage->GetLwrBorder(),
//STRIP001 								pPage->IsScaleObjects(),
//STRIP001 								pPage->GetOrientation(),
//STRIP001 								pPage->GetPaperBin(),
//STRIP001 								pPage->IsBackgroundFullSize(),
//STRIP001 								rNewSize,
//STRIP001 								nLeft, nRight,
//STRIP001 								nUpper, nLower,
//STRIP001 								bScaleAll,
//STRIP001 								eOrientation,
//STRIP001 								nPaperBin,
//STRIP001 								bBackgroundFullSize);
//STRIP001 		pUndoGroup->AddAction(pUndo);
//STRIP001 
//STRIP001 		if (rNewSize.Width() > 0 ||
//STRIP001 			nLeft  >= 0 || nRight >= 0 || nUpper >= 0 || nLower >= 0)
//STRIP001 		{
//STRIP001 			Rectangle aNewBorderRect(nLeft, nUpper, nRight, nLower);
//STRIP001 			pPage->ScaleObjects(rNewSize, aNewBorderRect, bScaleAll);
//STRIP001 
//STRIP001 			if (rNewSize.Width() > 0)
//STRIP001 				pPage->SetSize(rNewSize);
//STRIP001 		}
//STRIP001 
//STRIP001 		if( nLeft  >= 0 || nRight >= 0 || nUpper >= 0 || nLower >= 0 )
//STRIP001 		{
//STRIP001 			pPage->SetBorder(nLeft, nUpper, nRight, nLower);
//STRIP001 		}
//STRIP001 
//STRIP001 		pPage->SetOrientation(eOrientation);
//STRIP001 		pPage->SetPaperBin( nPaperBin );
//STRIP001 		pPage->SetBackgroundFullSize( bBackgroundFullSize );
//STRIP001 
//STRIP001 		if ( ePageKind == PK_STANDARD )
//STRIP001 		{
//STRIP001 			SdPage* pNotesPage = pDoc->GetSdPage(i, PK_NOTES);
//STRIP001 			pNotesPage->SetAutoLayout( pNotesPage->GetAutoLayout() );
//STRIP001 		}
//STRIP001 
//STRIP001 		pPage->SetAutoLayout( pPage->GetAutoLayout() );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Handoutseite an neues Format der Standardseiten anpassen
//STRIP001 	if ( ePageKind == PK_STANDARD )
//STRIP001 		pDoc->GetSdPage(0, PK_HANDOUT)->CreateTitleAndLayout(TRUE);
//STRIP001 
//STRIP001 	// Undo Gruppe dem Undo Manager uebergeben
//STRIP001 	GetViewFrame()->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndoGroup);
//STRIP001 
//STRIP001 	long nWidth = pPage->GetSize().Width();
//STRIP001 	long nHeight = pPage->GetSize().Height();
//STRIP001 
//STRIP001 	Point aPageOrg = Point(nWidth, nHeight / 2);
//STRIP001 	Size aViewSize = Size(nWidth * 3, nHeight * 2);
//STRIP001 
//STRIP001 	InitWindows(aPageOrg, aViewSize, Point(-1, -1), TRUE);
//STRIP001 
//STRIP001 	Point aVisAreaPos;
//STRIP001 
//STRIP001 	if ( pDocSh->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED )
//STRIP001 	{
//STRIP001 		aVisAreaPos = pDocSh->GetVisArea(ASPECT_CONTENT).TopLeft();
//STRIP001 	}
//STRIP001 
//STRIP001 	SdView* pView = GetView();
//STRIP001 	if (pView)
//STRIP001 	{
//STRIP001 		pView->SetWorkArea(Rectangle(Point() - aVisAreaPos - aPageOrg, aViewSize));
//STRIP001 	}
//STRIP001 
//STRIP001 	UpdateScrollBars();
//STRIP001 
//STRIP001 	Point aNewOrigin(pPage->GetLftBorder(), pPage->GetUppBorder());
//STRIP001 
//STRIP001 	if (pView)
//STRIP001 	{
//STRIP001 		pView->GetPageViewPvNum(0)->SetPageOrigin(aNewOrigin);
//STRIP001 	}
//STRIP001 
//STRIP001 	GetViewFrame()->GetBindings().Invalidate(SID_RULER_NULL_OFFSET);
//STRIP001 
//STRIP001 	// auf (neue) Seitengroesse zoomen
//STRIP001 	GetViewFrame()->GetDispatcher()->Execute(SID_SIZE_PAGE,
//STRIP001 			SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 }

/*************************************************************************
|*
|* Zoom-Faktor fuer InPlace einstellen
|*
\************************************************************************/

//STRIP001 void SdViewShell::SetZoomFactor(const Fraction& rZoomX, const Fraction& rZoomY)
//STRIP001 {
//STRIP001 	long nZoom = (long)((double) rZoomX * 100);
//STRIP001 	SetZoom(nZoom);
//STRIP001 }


/*************************************************************************
|*
|* Aktives Fenster setzen
|*
\************************************************************************/

/*N*/ void SdViewShell::SetActiveWindow(SdWindow* pWin)
/*N*/ {
/*N*/ 	if (GetWindow() != pWin)
/*N*/ 	{
/*N*/ 		if (pWin)
/*N*/ 		{
/*N*/ 			pWin->EnableChildTransparentMode();
/*N*/ 		}
/*N*/ 
/*N*/ 		SetWindow(pWin);
/*N*/ 	}
/*N*/ 
/*N*/ 	if (pWindow != pWin)
/*N*/ 	{
/*N*/ 		pWindow = pWin;
/*N*/ 
/*N*/ 		SdView* pView = GetView();
/*N*/ 
/*N*/ 		if (pView)
/*N*/ 		{
/*?*/ 			pView->SetActualWin(pWin);
/*N*/ 		}
/*N*/ 		if (pFuSlideShow)
/*N*/ 		{
/*?*/ 			pFuSlideShow->SetWindow(pWin);
/*N*/ 		}
/*N*/ 		if (pFuActual)
/*N*/ 		{
/*?*/ 			pFuActual->SetWindow(pWin);
/*N*/ 		}
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* RequestHelp event
|*
\************************************************************************/

//STRIP001 BOOL SdViewShell::RequestHelp(const HelpEvent& rHEvt, SdWindow* pWin)
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	if (rHEvt.GetMode())
//STRIP001 	{
//STRIP001 		if (pFuSlideShow)
//STRIP001 		{
//STRIP001 			bReturn = pFuSlideShow->RequestHelp(rHEvt);
//STRIP001 		}
//STRIP001 		else if (pFuActual)
//STRIP001 		{
//STRIP001 			bReturn = pFuActual->RequestHelp(rHEvt);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return(bReturn);
//STRIP001 }



/*************************************************************************
|*
|* Read FrameViews data and set actual views data
|*
\************************************************************************/

//STRIP001 void SdViewShell::ReadFrameViewData(FrameView* pView)
//STRIP001 {
//STRIP001 }



/*************************************************************************
|*
|* Write actual views data to FrameView
|*
\************************************************************************/

/*N*/ void SdViewShell::WriteFrameViewData()
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|* Auf allen Split-Windows ein Update erzwingen.
|*
\************************************************************************/

//STRIP001 void SdViewShell::UpdateWindows()
//STRIP001 {
//STRIP001 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
//STRIP001 		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
//STRIP001 			if ( pWinArray[nX][nY] )
//STRIP001 				pWinArray[nX][nY]->Update();
//STRIP001 }

/*************************************************************************
|*
|* OLE-Object aktivieren
|*
\************************************************************************/

//STRIP001 BOOL SdViewShell::ActivateObject(SdrOle2Obj* pObj, long nVerb)
//STRIP001 {
//STRIP001 	ErrCode aErrCode = 0;
//STRIP001 	SfxErrorContext aEC(ERRCTX_SO_DOVERB, pWindow, RID_SO_ERRCTX);
//STRIP001 	BOOL bAbort = FALSE;
//STRIP001 	BOOL bChartActive = FALSE;
//STRIP001 	pDocSh->SetWaitCursor( TRUE );
//STRIP001 
//STRIP001 	SvInPlaceObjectRef aIPObj = pObj->GetObjRef();
//STRIP001 
//STRIP001 	if ( !aIPObj.Is() )
//STRIP001 	{
//STRIP001 		/**********************************************************
//STRIP001 		* Leeres OLE-Objekt mit OLE-Objekt versehen
//STRIP001 		**********************************************************/
//STRIP001 		SvInPlaceObjectRef aNewIPObj;
//STRIP001 		SvStorageRef aStor = new SvStorage( String(), STREAM_STD_READWRITE);
//STRIP001 
//STRIP001 		String aName = pObj->GetProgName();
//STRIP001 
//STRIP001 		if( aName.EqualsAscii( "StarChart" ))
//STRIP001 		{
//STRIP001 			aNewIPObj = &((SvFactory*)SvInPlaceObject::ClassFactory())->CreateAndInit(
//STRIP001 							 SchModuleDummy::GetID(SOFFICE_FILEFORMAT_CURRENT), aStor);
//STRIP001 		}
//STRIP001 		else if( aName.EqualsAscii( "StarOrg" ))
//STRIP001 		{
//STRIP001 			// z.Z noch Nummer vom StarChart!
//STRIP001 			aNewIPObj = &((SvFactory*)SvInPlaceObject::ClassFactory())->CreateAndInit(
//STRIP001 							 SchModuleDummy::GetID(SOFFICE_FILEFORMAT_CURRENT), aStor);
//STRIP001 		}
//STRIP001 		else if( aName.EqualsAscii( "StarCalc" ))
//STRIP001 		{
//STRIP001 			aNewIPObj = &((SvFactory*)SvInPlaceObject::ClassFactory())->CreateAndInit(
//STRIP001 							 ScModuleDummy::GetID(SOFFICE_FILEFORMAT_CURRENT), aStor);
//STRIP001 		}
//STRIP001 #ifdef STARIMAGE_AVAILABLE
//STRIP001 		else if( aName.EqualsAscii( "StarImage" ))
//STRIP001 		{
//STRIP001 			aNewIPObj = &((SvFactory*)SvInPlaceObject::ClassFactory())->CreateAndInit(
//STRIP001 							 SimModuleDummy::GetID(SOFFICE_FILEFORMAT_CURRENT), aStor);
//STRIP001 		}
//STRIP001 #endif
//STRIP001 		else if( aName.EqualsAscii( "StarMath" ))
//STRIP001 		{
//STRIP001 			aNewIPObj = &((SvFactory*)SvInPlaceObject::ClassFactory())->CreateAndInit(
//STRIP001 							 SmModuleDummy::GetID(SOFFICE_FILEFORMAT_CURRENT), aStor);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// Dialog "OLE-Objekt einfuegen" aufrufen
//STRIP001 			pDocSh->SetWaitCursor( FALSE );
//STRIP001 			GetViewFrame()->GetDispatcher()->Execute(SID_INSERT_OBJECT,
//STRIP001 							SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 			aNewIPObj = pObj->GetObjRef();
//STRIP001 			pDocSh->SetWaitCursor( TRUE );
//STRIP001 
//STRIP001 			if (!aNewIPObj.Is())
//STRIP001 			{
//STRIP001 				bAbort = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( aNewIPObj.Is() )
//STRIP001 		{
			/******************************************************
			* OLE-Objekt ist nicht mehr leer
			******************************************************/
//STRIP001 			pObj->SetEmptyPresObj(FALSE);
//STRIP001 			pObj->SetOutlinerParaObject(NULL);
//STRIP001 			pObj->SetGraphic(NULL);

			/******************************************************
			* Das leere OLE-Objekt bekommt ein neues IPObj
			******************************************************/
//STRIP001 			if (aName.Len())
//STRIP001 			{
//STRIP001 				String aObjName = pDocSh->InsertObject(aNewIPObj, String())->GetObjName();
//STRIP001 				pObj->SetObjRef(aNewIPObj);
//STRIP001 				pObj->SetName(aObjName);
//STRIP001     			pObj->SetPersistName(aObjName);
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// Das Einfuegen hat der Dialog schon gemacht
//STRIP001 				pObj->SetObjRef(aNewIPObj);
//STRIP001 			}
//STRIP001 
//STRIP001 			Rectangle aRect = pObj->GetLogicRect();
//STRIP001 			aNewIPObj->SetVisAreaSize( aRect.GetSize() );
//STRIP001 
//STRIP001 			SetVerbs( &aNewIPObj->GetVerbList() );
//STRIP001 
//STRIP001 			if( aName.EqualsAscii( "StarChart" ))
//STRIP001 			{
//STRIP001 				bChartActive = TRUE;
//STRIP001 				SchDLL::Update(aNewIPObj, NULL, pWindow);		// BM: use different DLL-call
//STRIP001 			}
//STRIP001 
//STRIP001 			nVerb = SVVERB_SHOW;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aErrCode = ERRCODE_SFX_OLEGENERAL;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( aErrCode == 0  )
//STRIP001 	{
//STRIP001 		SdView* pView = GetView();
//STRIP001 
//STRIP001 		if (pView->IsTextEdit())
//STRIP001 		{
//STRIP001 			pView->EndTextEdit();
//STRIP001 		}
//STRIP001 
//STRIP001 		const SvInPlaceObjectRef& rIPObjRef = pObj->GetObjRef();
//STRIP001 		SfxInPlaceClientRef pSdClient = (SdClient*) FindIPClient(rIPObjRef, pWindow);
//STRIP001 
//STRIP001 		if ( !pSdClient.Is() )
//STRIP001 		{
//STRIP001 			pSdClient = new SdClient(pObj, this, pWindow);
//STRIP001 		}
//STRIP001 
//STRIP001 		rIPObjRef->DoConnect(pSdClient);
//STRIP001 		Rectangle aRect = pObj->GetLogicRect();
//STRIP001 		SvClientData* pClientData = pSdClient->GetEnv();
//STRIP001 
//STRIP001 		if (pClientData)
//STRIP001 		{
//STRIP001 			Size aDrawSize = aRect.GetSize();
//STRIP001 			Size aObjAreaSize = rIPObjRef->GetVisArea().GetSize();
//STRIP001 			aObjAreaSize = OutputDevice::LogicToLogic( aObjAreaSize,
//STRIP001 												   rIPObjRef->GetMapUnit(),
//STRIP001 												   pDoc->GetScaleUnit() );
//STRIP001 
//STRIP001 			// sichtbarer Ausschnitt wird nur inplace veraendert!
//STRIP001 			aRect.SetSize(aObjAreaSize);
//STRIP001 			pClientData->SetObjArea(aRect);
//STRIP001 
//STRIP001 			Fraction aScaleWidth (aDrawSize.Width(),  aObjAreaSize.Width() );
//STRIP001 			Fraction aScaleHeight(aDrawSize.Height(), aObjAreaSize.Height() );
//STRIP001 			aScaleWidth.ReduceInaccurate(10);       // kompatibel zum SdrOle2Obj
//STRIP001 			aScaleHeight.ReduceInaccurate(10);
//STRIP001 			pClientData->SetSizeScale(aScaleWidth, aScaleHeight);
//STRIP001 		}
//STRIP001 
//STRIP001 		// switching to edit mode for OLEs was disabled when OLE
//STRIP001 		// is member of a group all the time. I dont know why it
//STRIP001 		// was possible in previous versions. But I see no
//STRIP001 		// reason not to allow it. (src539)
//STRIP001 //			if( !pView->IsGroupEntered() )
//STRIP001     	DoVerb(pSdClient, nVerb);   // ErrCode wird ggf. vom Sfx ausgegeben
//STRIP001 		GetViewFrame()->GetBindings().Invalidate( SID_NAVIGATOR_STATE, TRUE, FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001 	pDocSh->SetWaitCursor( FALSE );
//STRIP001 
//STRIP001 	if (aErrCode != 0 && !bAbort)
//STRIP001 	{
//STRIP001 		ErrorHandler::HandleError(* new StringErrorInfo(aErrCode, String() ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bActivated = FALSE;
//STRIP001 
//STRIP001 	if (aErrCode == 0)
//STRIP001 	{
//STRIP001 		bActivated = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return(bActivated);
//STRIP001 }

/*************************************************************************
|*
|* umschliessendes Rechteck aller (Split-)Fenster zurueckgeben.
|*
\************************************************************************/

//STRIP001 const Rectangle& SdViewShell::GetAllWindowRect()
//STRIP001 {
//STRIP001 	aAllWindowRect.SetPos(pWinArray[0][0]->OutputToScreenPixel(Point(0,0)));
//STRIP001 	return aAllWindowRect;
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

/*N*/ void SdViewShell::CancelSearching()
/*N*/ {
/*N*/ 	delete pFuSearch;
/*N*/ 	pFuSearch = NULL;
/*N*/ }

/*************************************************************************
|*
|* Read user data
|*
\************************************************************************/

//STRIP001 void SdViewShell::ReadUserData(const String& rString)
//STRIP001 {
//STRIP001 	SfxViewShell::ReadUserData(rString);
//STRIP001 
//STRIP001 	// Auf an FrameView gemerkte VisArea zoomen
//STRIP001 	GetViewFrame()->GetDispatcher()->Execute(SID_SIZE_VISAREA,
//STRIP001 					SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 }

/*************************************************************************
|*
|* Write user data
|*
\************************************************************************/

//STRIP001 void SdViewShell::WriteUserData(String& rString)
//STRIP001 {
//STRIP001 	SfxViewShell::WriteUserData(rString);
//STRIP001 
//STRIP001 	// Das Schreiben unserer Daten erfolgt stets in WriteFrameViewData()
//STRIP001 	WriteFrameViewData();
//STRIP001 }


/*************************************************************************
|*
|* Lineale ein- / ausschalten
|*
\************************************************************************/

//STRIP001 void SdViewShell::SetRuler(BOOL bRuler)
//STRIP001 {
//STRIP001 	bHasRuler = bRuler;
//STRIP001 
//STRIP001 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
//STRIP001 	{
//STRIP001 		if (pHRulerArray[nX])
//STRIP001 		{
//STRIP001 			if (bHasRuler)
//STRIP001 			{
//STRIP001 				pHRulerArray[nX]->Show();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pHRulerArray[nX]->Hide();
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
//STRIP001 		{
//STRIP001 			if (nX == 0 && pVRulerArray[nY])
//STRIP001 			{
//STRIP001 				if (bHasRuler)
//STRIP001 				{
//STRIP001 					pVRulerArray[nY]->Show();
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					pVRulerArray[nY]->Hide();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	InvalidateBorder();
//STRIP001 }

/*************************************************************************
|*
|* AcceptDrop
|*
\************************************************************************/

//STRIP001 sal_Int8 SdViewShell::AcceptDrop( const AcceptDropEvent& rEvt, DropTargetHelper& rTargetHelper,
//STRIP001                                   SdWindow* pTargetWindow, USHORT nPage, USHORT nLayer )
//STRIP001 {
//STRIP001 	SdView* pView = GetView();
//STRIP001 	return( pView ? pView->AcceptDrop( rEvt, rTargetHelper, pTargetWindow, nPage, nLayer ) : DND_ACTION_NONE );
//STRIP001 }

/*************************************************************************
|*
|* ExecuteDrop
|*
\************************************************************************/

//STRIP001 sal_Int8 SdViewShell::ExecuteDrop( const ExecuteDropEvent& rEvt, DropTargetHelper& rTargetHelper,
//STRIP001                                    SdWindow* pTargetWindow, USHORT nPage, USHORT nLayer )
//STRIP001 {
//STRIP001 	SdView*	pView = GetView();
//STRIP001 	return( pView ? pView->ExecuteDrop( rEvt, rTargetHelper, pTargetWindow, nPage, nLayer ) : DND_ACTION_NONE );
//STRIP001 }

#ifdef WNT
#pragma optimize ( "", on )
#endif

/*N*/ void SdViewShell::WriteUserDataSequence ( ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& rSequence, sal_Bool bBrowse )
/*N*/ {
/*N*/ 	const sal_Int32 nIndex = rSequence.getLength();
/*N*/ 	rSequence.realloc( nIndex + 1 );
/*N*/ 
/*N*/     sal_uInt16 nViewID( GetViewFrame()->GetCurViewId());
/*N*/ 	rSequence[nIndex].Name = ::rtl::OUString ( RTL_CONSTASCII_USTRINGPARAM( sUNO_View_ViewId ) );
/*N*/ 	::rtl::OUStringBuffer sBuffer ( ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM( "view" ) ) );
/*N*/ 	sBuffer.append( static_cast<sal_Int32>(nViewID));
/*N*/ 	rSequence[nIndex].Value <<= sBuffer.makeStringAndClear();
/*N*/ 
/*N*/ 	pFrameView->WriteUserDataSequence( rSequence, bBrowse );
/*N*/ }

//STRIP001 void SdViewShell::ReadUserDataSequence ( const ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& rSequence, sal_Bool bBrowse )
//STRIP001 {
//STRIP001 	pFrameView->ReadUserDataSequence( rSequence, bBrowse );
//STRIP001 }

/*N*/ void SdViewShell::VisAreaChanged(const Rectangle& rRect)
/*N*/ {
/*N*/ 	SfxViewShell::VisAreaChanged(rRect);
/*N*/ }

//STRIP001 void SdViewShell::SetWinViewPos(const Point& rWinPos, bool bUpdate)
//STRIP001 {
//STRIP001 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
//STRIP001 	{
//STRIP001 		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
//STRIP001 		{
//STRIP001 			if ( pWinArray[nX][nY] )
//STRIP001 			{
//STRIP001 				pWinArray[nX][nY]->SetWinViewPos(rWinPos);
//STRIP001 
//STRIP001 				if ( bUpdate )
//STRIP001 				{
//STRIP001 					pWinArray[nX][nY]->UpdateMapOrigin();
//STRIP001 					pWinArray[nX][nY]->Invalidate();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bHasRuler )
//STRIP001 	{
//STRIP001 		UpdateHRuler();
//STRIP001 		UpdateVRuler();
//STRIP001 	}
//STRIP001 
//STRIP001 	UpdateScrollBars();
//STRIP001 
//STRIP001 	Size aVisSizePixel = pWindow->GetOutputSizePixel();
//STRIP001 	Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0), aVisSizePixel) );
//STRIP001 	VisAreaChanged(aVisAreaWin);
//STRIP001 
//STRIP001 	SdView* pView = GetView();
//STRIP001 	if (pView)
//STRIP001 	{
//STRIP001 		pView->VisAreaChanged(pWindow);
//STRIP001 	}
//STRIP001 }

//STRIP001 Point SdViewShell::GetWinViewPos() const
//STRIP001 {
//STRIP001 	return pWinArray[0][0]->GetWinViewPos();
//STRIP001 }

//STRIP001 Point SdViewShell::GetViewOrigin() const
//STRIP001 {
//STRIP001 	return pWinArray[0][0]->GetViewOrigin();
//STRIP001 }
}
