/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tabcontr.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:09:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SD_TABCONTR_HXX
#define _SD_TABCONTR_HXX

#ifndef _TABBAR_HXX //autogen wg. TabBar
#include <svtools/tabbar.hxx>
#endif
#ifndef _TRANSFER_HXX
#include <svtools/transfer.hxx>
#endif
namespace binfilter {

/*************************************************************************
|*
|* TabControl-Klasse fuer Seitenumschaltung
|*
\************************************************************************/

class SdDrawViewShell;

class SdTabControl : public TabBar, public DragSourceHelper, public DropTargetHelper 
{
private:

	// nested class to implement the TransferableHelper
	class SdTabControlTransferable : public TransferableHelper
	{
	private:

		SdTabControl&		mrParent;

//STRIP001 		virtual				~SdTabControlTransferable();
		
//STRIP001 		virtual void		AddSupportedFormats();
//STRIP001 		virtual sal_Bool	GetData( const ::com::sun::star::datatransfer::DataFlavor& rFlavor );
//STRIP001 		virtual void		DragFinished( sal_Int8 nDropAction );
		
	public:

							SdTabControlTransferable( SdTabControl& rParent ) :
								mrParent( rParent ) {}
	};

	friend class SdTabControl::SdTabControlTransferable;

//STRIP001 	void				DragFinished( sal_Int8 nDropAction );

protected:

	SdDrawViewShell*	pDrViewSh;
	BOOL				bInternalMove;

	// TabBar
//STRIP001 	virtual void		Select();
//STRIP001 	virtual void		DoubleClick();
//STRIP001 	virtual void		MouseButtonDown(const MouseEvent& rMEvt);
						
//STRIP001 	virtual void		Command(const CommandEvent& rCEvt);

//STRIP001 	virtual long		StartRenaming();
//STRIP001 	virtual long		AllowRenaming();
//STRIP001 	virtual void		EndRenaming();
						
//STRIP001 	virtual void		ActivatePage();
//STRIP001 	virtual long		DeactivatePage();

	// DragSourceHelper
//STRIP001 	virtual void		StartDrag( sal_Int8 nAction, const Point& rPosPixel );

	// DropTargetHelper
//STRIP001 	virtual sal_Int8	AcceptDrop( const AcceptDropEvent& rEvt );
//STRIP001 	virtual sal_Int8	ExecuteDrop( const ExecuteDropEvent& rEvt );

//STRIP001 						DECL_LINK(DeactivatePageHdl, void*);

public:
						
						SdTabControl(SdDrawViewShell* pDrViewSh, Window* pParent);
						~SdTabControl();

    /** Inform all listeners of this control that the current page has been
        activated.  Call this method after switching the current page and is
        not done elsewhere (like when using page up/down keys).
    */
    void SendActivatePageEvent (void);

    /** Inform all listeners of this control that the current page has been
        deactivated.  Call this method before switching the current page and
        is not done elsewhere (like when using page up/down keys).
    */
    void SendDeactivatePageEvent (void);
};

} //namespace binfilter
#endif		// _SD_TABCONTR_HXX

