/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_select.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:33:54 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

// auto strip #include <tools/urlobj.hxx>
// auto strip #include <vcl/sound.hxx>
// auto strip #include <bf_sfx2/docfile.hxx>

// auto strip #include "select.hxx"
#include "bf_sc.hrc"
#include "tabvwsh.hxx"
// auto strip #include "scmod.hxx"
// auto strip #include "document.hxx"
//#include "dataobj.hxx"
// auto strip #include "transobj.hxx"
// auto strip #include "docsh.hxx"
namespace binfilter {

extern USHORT nScFillModeMouseModifier;				// global.cxx

using namespace ::com::sun::star;

// STATIC DATA -----------------------------------------------------------

static Point aSwitchPos;				//! Member
static BOOL bDidSwitch = FALSE;

// -----------------------------------------------------------------------

//
//					View (Gridwin / Tastatur)
//

/*N*/ ScViewFunctionSet::ScViewFunctionSet( ScViewData* pNewViewData ) :
/*N*/ 		pViewData( pNewViewData ),
/*N*/ 		pEngine( NULL ),
/*N*/ 		bAnchor( FALSE ),
/*N*/ 		bStarted( FALSE )
/*N*/ {
/*N*/ 	DBG_ASSERT(pViewData, "ViewData==0 bei FunctionSet");
/*N*/ }

//STRIP001 ScSplitPos ScViewFunctionSet::GetWhich()
//STRIP001 {
//STRIP001 	if (pEngine)
//STRIP001 		return pEngine->GetWhich();
//STRIP001 	else
//STRIP001 		return pViewData->GetActivePart();
//STRIP001 }

/*N*/ void ScViewFunctionSet::SetSelectionEngine( ScViewSelectionEngine* pSelEngine )
/*N*/ {
/*N*/ 	pEngine = pSelEngine;
/*N*/ }

//		Drag & Drop

//STRIP001 void __EXPORT ScViewFunctionSet::BeginDrag()
//STRIP001 {
//STRIP001 	USHORT nTab = pViewData->GetTabNo();
//STRIP001 
//STRIP001 	short nPosX;
//STRIP001 	short nPosY;
//STRIP001 	if (pEngine)
//STRIP001 	{
//STRIP001 		Point aMPos = pEngine->GetMousePosPixel();
//STRIP001 		pViewData->GetPosFromPixel( aMPos.X(), aMPos.Y(), GetWhich(), nPosX, nPosY );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nPosX = pViewData->GetCurX();
//STRIP001 		nPosY = pViewData->GetCurY();
//STRIP001 	}
//STRIP001 
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	BOOL bRefMode = pScMod->IsFormulaMode();
//STRIP001 	if (!bRefMode)
//STRIP001 	{
//STRIP001 		pViewData->GetView()->FakeButtonUp( GetWhich() );	// ButtonUp wird verschluckt
//STRIP001 
//STRIP001 		ScMarkData& rMark = pViewData->GetMarkData();
//STRIP001 //		rMark.SetMarking(FALSE);						// es fehlt ein ButtonUp
//STRIP001 		rMark.MarkToSimple();
//STRIP001 		if ( rMark.IsMarked() && !rMark.IsMultiMarked() )
//STRIP001 		{
//STRIP001 			ScDocument* pClipDoc = new ScDocument( SCDOCMODE_CLIP );
//STRIP001 			// bApi = TRUE -> no error mesages
//STRIP001 			BOOL bCopied = pViewData->GetView()->CopyToClip( pClipDoc, FALSE, TRUE );
//STRIP001 			if ( bCopied )
//STRIP001 			{
//STRIP001 				sal_Int8 nDragActions = pViewData->GetView()->SelectionEditable() ?
//STRIP001 										( DND_ACTION_COPYMOVE | DND_ACTION_LINK ) :
//STRIP001 										( DND_ACTION_COPY | DND_ACTION_LINK );
//STRIP001 
//STRIP001 				ScDocShell* pDocSh = pViewData->GetDocShell();
//STRIP001 				TransferableObjectDescriptor aObjDesc;
//STRIP001 				pDocSh->FillTransferableObjectDescriptor( aObjDesc );
//STRIP001 				aObjDesc.maDisplayName = pDocSh->GetMedium()->GetURLObject().GetURLNoPass();
//STRIP001 				// maSize is set in ScTransferObj ctor
//STRIP001 
//STRIP001 				ScTransferObj* pTransferObj = new ScTransferObj( pClipDoc, aObjDesc );
//STRIP001 				uno::Reference<datatransfer::XTransferable> xTransferable( pTransferObj );
//STRIP001 
//STRIP001 				// set position of dragged cell within range
//STRIP001 				ScRange aMarkRange = pTransferObj->GetRange();
//STRIP001 				USHORT nStartX = aMarkRange.aStart.Col();
//STRIP001 				USHORT nStartY = aMarkRange.aStart.Row();
//STRIP001 				USHORT nHandleX = (nPosX >= (short) nStartX) ? nPosX - nStartX : 0;
//STRIP001 				USHORT nHandleY = (nPosY >= (short) nStartY) ? nPosY - nStartY : 0;
//STRIP001 				pTransferObj->SetDragHandlePos( nHandleX, nHandleY );
//STRIP001 				pTransferObj->SetVisibleTab( nTab );
//STRIP001 
//STRIP001 				pTransferObj->SetDragSource( pDocSh, rMark );
//STRIP001 
//STRIP001 				Window* pWindow = pViewData->GetActiveWin();
//STRIP001 				if ( pWindow->IsTracking() )
//STRIP001 					pWindow->EndTracking( ENDTRACK_CANCEL );	// abort selecting
//STRIP001 
//STRIP001 				SC_MOD()->SetDragObject( pTransferObj, NULL );		// for internal D&D
//STRIP001 				pTransferObj->StartDrag( pWindow, nDragActions );
//STRIP001 
//STRIP001 				return;			// dragging started
//STRIP001 			}
//STRIP001 			else
//STRIP001 				delete pClipDoc;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	Sound::Beep();			// can't drag
//STRIP001 }

//		Selektion

//STRIP001 void __EXPORT ScViewFunctionSet::CreateAnchor()
//STRIP001 {
//STRIP001 	if (bAnchor) return;
//STRIP001 
//STRIP001 	BOOL bRefMode = SC_MOD()->IsFormulaMode();
//STRIP001 	if (bRefMode)
//STRIP001 		SetAnchor( pViewData->GetRefStartX(), pViewData->GetRefStartY() );
//STRIP001 	else
//STRIP001 		SetAnchor( pViewData->GetCurX(), pViewData->GetCurY() );
//STRIP001 }

//STRIP001 void ScViewFunctionSet::SetAnchor( USHORT nPosX, USHORT nPosY )
//STRIP001 {
//STRIP001 	BOOL bRefMode = SC_MOD()->IsFormulaMode();
//STRIP001 	ScTabView* pView = pViewData->GetView();
//STRIP001 	USHORT nTab = pViewData->GetTabNo();
//STRIP001 
//STRIP001 	if (bRefMode)
//STRIP001 	{
//STRIP001 		pView->DoneRefMode( FALSE );
//STRIP001 		aAnchorPos.Put( nPosX, nPosY, nTab );
//STRIP001 		pView->InitRefMode( aAnchorPos.GetCol(), aAnchorPos.GetRow(), aAnchorPos.GetTab(),
//STRIP001 							SC_REFTYPE_REF );
//STRIP001 		bStarted = TRUE;
//STRIP001 	}
//STRIP001 	else if (pViewData->IsAnyFillMode())
//STRIP001 	{
//STRIP001 		aAnchorPos.Put( nPosX, nPosY, nTab );
//STRIP001 		bStarted = TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// nicht weg und gleich wieder hin
//STRIP001 		if ( bStarted && pView->IsMarking( nPosX, nPosY, nTab ) )
//STRIP001 		{
//STRIP001 			// nix
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pView->DoneBlockMode( TRUE );
//STRIP001 			aAnchorPos.Put( nPosX, nPosY, nTab );
//STRIP001 			ScMarkData& rMark = pViewData->GetMarkData();
//STRIP001 			if ( rMark.IsMarked() || rMark.IsMultiMarked() )
//STRIP001 			{
//STRIP001 				pView->InitBlockMode( aAnchorPos.GetCol(), aAnchorPos.GetRow(),
//STRIP001 										aAnchorPos.GetTab(), TRUE );
//STRIP001 				bStarted = TRUE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				bStarted = FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	bAnchor = TRUE;
//STRIP001 }

//STRIP001 void __EXPORT ScViewFunctionSet::DestroyAnchor()
//STRIP001 {
//STRIP001 	BOOL bRefMode = SC_MOD()->IsFormulaMode();
//STRIP001 	if (bRefMode)
//STRIP001 		pViewData->GetView()->DoneRefMode( TRUE );
//STRIP001 	else
//STRIP001 		pViewData->GetView()->DoneBlockMode( TRUE );
//STRIP001 
//STRIP001 	bAnchor = FALSE;
//STRIP001 }

//STRIP001 void ScViewFunctionSet::SetAnchorFlag( BOOL bSet )
//STRIP001 {
//STRIP001 	bAnchor = bSet;
//STRIP001 }

//STRIP001 BOOL __EXPORT ScViewFunctionSet::SetCursorAtPoint( const Point& rPointPixel, BOOL bDontSelectAtCursor )
//STRIP001 {
//STRIP001 	if ( bDidSwitch )
//STRIP001 	{
//STRIP001 		if ( rPointPixel == aSwitchPos )
//STRIP001 			return FALSE;					// nicht auf falschem Fenster scrollen
//STRIP001 		else
//STRIP001 			bDidSwitch = FALSE;
//STRIP001 	}
//STRIP001 	aSwitchPos = rPointPixel;		// nur wichtig, wenn bDidSwitch
//STRIP001 
//STRIP001 	//	treat position 0 as -1, so scrolling is always possible
//STRIP001 	//	(with full screen and hidden headers, the top left border may be at 0)
//STRIP001 	//	(moved from ScViewData::GetPosFromPixel)
//STRIP001 
//STRIP001 	Point aEffPos = rPointPixel;
//STRIP001 	if ( aEffPos.X() == 0 )
//STRIP001 		aEffPos.X() = -1;
//STRIP001 	if ( aEffPos.Y() == 0 )
//STRIP001 		aEffPos.Y() = -1;
//STRIP001 
//STRIP001 	//	Scrolling
//STRIP001 
//STRIP001 	Size aWinSize = pEngine->GetWindow()->GetOutputSizePixel();
//STRIP001 	BOOL bRightScroll  = ( aEffPos.X() >= aWinSize.Width() );
//STRIP001 	BOOL bBottomScroll = ( aEffPos.Y() >= aWinSize.Height() );
//STRIP001 	BOOL bNegScroll    = ( aEffPos.X() < 0 || aEffPos.Y() < 0 );
//STRIP001 	BOOL bScroll = bRightScroll || bBottomScroll || bNegScroll;
//STRIP001 
//STRIP001 	short	nPosX;
//STRIP001 	short	nPosY;
//STRIP001 	pViewData->GetPosFromPixel( aEffPos.X(), aEffPos.Y(), GetWhich(),
//STRIP001 								nPosX, nPosY, TRUE, TRUE );		// mit Repair
//STRIP001 
//STRIP001 	//	fuer AutoFill in der Mitte der Zelle umschalten
//STRIP001 	//	dabei aber nicht das Scrolling nach rechts/unten verhindern
//STRIP001 	if ( pViewData->IsFillMode() || pViewData->GetFillMode() == SC_FILL_MATRIX )
//STRIP001 	{
//STRIP001 		BOOL bLeft, bTop;
//STRIP001 		pViewData->GetMouseQuadrant( aEffPos, GetWhich(), nPosX, nPosY, bLeft, bTop );
//STRIP001 		ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 		USHORT nTab = pViewData->GetTabNo();
//STRIP001 		if ( bLeft && !bRightScroll )
//STRIP001 			do --nPosX; while ( nPosX>=0 && ( pDoc->GetColFlags( nPosX, nTab ) & CR_HIDDEN ) );
//STRIP001 		if ( bTop && !bBottomScroll )
//STRIP001 			do --nPosY; while ( nPosY>=0 && ( pDoc->GetRowFlags( nPosY, nTab ) & CR_HIDDEN ) );
//STRIP001 		//	negativ ist erlaubt
//STRIP001 	}
//STRIP001 
//STRIP001 	//	ueber Fixier-Grenze bewegt?
//STRIP001 
//STRIP001 	ScSplitPos eWhich = GetWhich();
//STRIP001 	if ( eWhich == pViewData->GetActivePart() )
//STRIP001 	{
//STRIP001 		if ( pViewData->GetHSplitMode() == SC_SPLIT_FIX )
//STRIP001 			if ( aEffPos.X() >= aWinSize.Width() )
//STRIP001 			{
//STRIP001 				if ( eWhich == SC_SPLIT_TOPLEFT )
//STRIP001 					pViewData->GetView()->ActivatePart( SC_SPLIT_TOPRIGHT ), bScroll = FALSE, bDidSwitch = TRUE;
//STRIP001 				else if ( eWhich == SC_SPLIT_BOTTOMLEFT )
//STRIP001 					pViewData->GetView()->ActivatePart( SC_SPLIT_BOTTOMRIGHT ), bScroll = FALSE, bDidSwitch = TRUE;
//STRIP001 			}
//STRIP001 
//STRIP001 		if ( pViewData->GetVSplitMode() == SC_SPLIT_FIX )
//STRIP001 			if ( aEffPos.Y() >= aWinSize.Height() )
//STRIP001 			{
//STRIP001 				if ( eWhich == SC_SPLIT_TOPLEFT )
//STRIP001 					pViewData->GetView()->ActivatePart( SC_SPLIT_BOTTOMLEFT ), bScroll = FALSE, bDidSwitch = TRUE;
//STRIP001 				else if ( eWhich == SC_SPLIT_TOPRIGHT )
//STRIP001 					pViewData->GetView()->ActivatePart( SC_SPLIT_BOTTOMRIGHT ), bScroll = FALSE, bDidSwitch = TRUE;
//STRIP001 			}
//STRIP001 	}
//STRIP001 
//STRIP001 	pViewData->ResetOldCursor();
//STRIP001 	return SetCursorAtCell( nPosX, nPosY, bScroll );
//STRIP001 }

//STRIP001 BOOL ScViewFunctionSet::SetCursorAtCell( short nPosX, short nPosY, BOOL bScroll )
//STRIP001 {
//STRIP001 	ScTabView* pView = pViewData->GetView();
//STRIP001 	USHORT nTab = pViewData->GetTabNo();
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	BOOL bRefMode = pScMod->IsFormulaMode();
//STRIP001 
//STRIP001 	BOOL bHide = !bRefMode && !pViewData->IsAnyFillMode() &&
//STRIP001 			( nPosX != (short) pViewData->GetCurX() || nPosY != (short) pViewData->GetCurY() );
//STRIP001 
//STRIP001 	if (bHide)
//STRIP001 		pView->HideAllCursors();
//STRIP001 
//STRIP001 	if (bScroll)
//STRIP001 	{
//STRIP001 		if (bRefMode)
//STRIP001 		{
//STRIP001 			ScSplitPos eWhich = GetWhich();
//STRIP001 			pView->AlignToCursor( nPosX, nPosY, SC_FOLLOW_LINE, &eWhich );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pView->AlignToCursor( nPosX, nPosY, SC_FOLLOW_LINE );
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bRefMode)
//STRIP001 	{
//STRIP001 		// #90910# if no input is possible from this doc, don't move the reference cursor around
//STRIP001 		if ( !pScMod->IsModalMode(pViewData->GetSfxDocShell()) )
//STRIP001 		{
//STRIP001 			if (!bAnchor)
//STRIP001 			{
//STRIP001 				pView->DoneRefMode( TRUE );
//STRIP001 				pView->InitRefMode( nPosX, nPosY, pViewData->GetTabNo(), SC_REFTYPE_REF );
//STRIP001 			}
//STRIP001 
//STRIP001 			pView->UpdateRef( nPosX, nPosY, pViewData->GetTabNo() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if (pViewData->IsFillMode() ||
//STRIP001 			(pViewData->GetFillMode() == SC_FILL_MATRIX && (nScFillModeMouseModifier & KEY_MOD1) ))
//STRIP001 	{
//STRIP001 		//	Wenn eine Matrix angefasst wurde, kann mit Ctrl auf AutoFill zurueckgeschaltet werden
//STRIP001 
//STRIP001 		USHORT nStartX, nStartY, nEndX, nEndY;		// Block
//STRIP001 		USHORT nDummy;
//STRIP001 		pViewData->GetSimpleArea( nStartX, nStartY, nDummy, nEndX, nEndY, nDummy );
//STRIP001 
//STRIP001 		if (pViewData->GetRefType() != SC_REFTYPE_FILL)
//STRIP001 		{
//STRIP001 			pView->InitRefMode( nStartX, nStartY, nTab, SC_REFTYPE_FILL );
//STRIP001 			CreateAnchor();
//STRIP001 		}
//STRIP001 
//STRIP001 		ScRange aDelRange;
//STRIP001 		BOOL bOldDelMark = pViewData->GetDelMark( aDelRange );
//STRIP001 		ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 
//STRIP001 		if ( nPosX+1 >= (short) nStartX && nPosX <= (short) nEndX &&
//STRIP001 			 nPosY+1 >= (short) nStartY && nPosY <= (short) nEndY &&
//STRIP001 			 ( nPosX != nEndX || nPosY != nEndY ) )						// verkleinern ?
//STRIP001 		{
//STRIP001 			//	Richtung (links oder oben)
//STRIP001 
//STRIP001 			short i;
//STRIP001 			long nSizeX = 0;
//STRIP001 			for (i=nPosX+1; i<=nEndX; i++)
//STRIP001 				nSizeX += pDoc->GetColWidth( i, nTab );
//STRIP001 			long nSizeY = 0;
//STRIP001 			for (i=nPosY+1; i<=nEndY; i++)
//STRIP001 				nSizeY += pDoc->GetRowHeight( i, nTab );
//STRIP001 
//STRIP001 			USHORT nDelStartX = nStartX;
//STRIP001 			USHORT nDelStartY = nStartY;
//STRIP001 			if ( nSizeX > nSizeY )
//STRIP001 				nDelStartX = nPosX + 1;
//STRIP001 			else
//STRIP001 				nDelStartY = nPosY + 1;
//STRIP001 			// 0 braucht nicht mehr getrennt abgefragt zu werden, weil nPosX/Y auch negativ wird
//STRIP001 
//STRIP001 			if ( nDelStartX < nStartX )
//STRIP001 				nDelStartX = nStartX;
//STRIP001 			if ( nDelStartY < nStartY )
//STRIP001 				nDelStartY = nStartY;
//STRIP001 
//STRIP001 			//	Bereich setzen
//STRIP001 
//STRIP001 			pViewData->SetDelMark( ScRange( nDelStartX,nDelStartY,nTab,
//STRIP001 											nEndX,nEndY,nTab ) );
//STRIP001 
//STRIP001 			if ( bOldDelMark )
//STRIP001 			{
//STRIP001 				ScUpdateRect aRect( aDelRange.aStart.Col(), aDelRange.aStart.Row(),
//STRIP001 									aDelRange.aEnd.Col(), aDelRange.aEnd.Row() );
//STRIP001 				aRect.SetNew( nDelStartX,nDelStartY, nEndX,nEndY );
//STRIP001 				USHORT nPaintStartX;
//STRIP001 				USHORT nPaintStartY;
//STRIP001 				USHORT nPaintEndX;
//STRIP001 				USHORT nPaintEndY;
//STRIP001 				if (aRect.GetDiff( nPaintStartX, nPaintStartY, nPaintEndX, nPaintEndY ))
//STRIP001 					pViewData->GetView()->
//STRIP001 						PaintArea( nPaintStartX, nPaintStartY,
//STRIP001 									nPaintEndX, nPaintEndY, SC_UPDATE_MARKS );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pViewData->GetView()->
//STRIP001 					PaintArea( nStartX,nDelStartY, nEndX,nEndY, SC_UPDATE_MARKS );
//STRIP001 
//STRIP001 			nPosX = nEndX;		// roten Rahmen um ganzen Bereich lassen
//STRIP001 			nPosY = nEndY;
//STRIP001 
//STRIP001 			//	Referenz wieder richtigherum, falls unten umgedreht
//STRIP001 			if ( nStartX != pViewData->GetRefStartX() || nStartY != pViewData->GetRefStartY() )
//STRIP001 			{
//STRIP001 				pViewData->GetView()->DoneRefMode();
//STRIP001 				pViewData->GetView()->InitRefMode( nStartX, nStartY, nTab, SC_REFTYPE_FILL );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if ( bOldDelMark )
//STRIP001 			{
//STRIP001 				pViewData->ResetDelMark();
//STRIP001 				pViewData->GetView()->
//STRIP001 					PaintArea( aDelRange.aStart.Col(), aDelRange.aStart.Row(),
//STRIP001 							   aDelRange.aEnd.Col(), aDelRange.aEnd.Row(), SC_UPDATE_MARKS );
//STRIP001 			}
//STRIP001 
//STRIP001 			BOOL bNegX = ( nPosX < (short) nStartX );
//STRIP001 			BOOL bNegY = ( nPosY < (short) nStartY );
//STRIP001 			short i;
//STRIP001 
//STRIP001 			long nSizeX = 0;
//STRIP001 			if ( bNegX )
//STRIP001 			{
//STRIP001 				//	#94321# in SetCursorAtPoint hidden columns are skipped.
//STRIP001 				//	They must be skipped here too, or the result will always be the first hidden column.
//STRIP001 				do ++nPosX; while ( nPosX<nStartX && ( pDoc->GetColFlags( nPosX, nTab ) & CR_HIDDEN ) );
//STRIP001 				for (i=nPosX; i<nStartX; i++)
//STRIP001 					nSizeX += pDoc->GetColWidth( i, nTab );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				for (i=nEndX+1; i<=nPosX; i++)
//STRIP001 					nSizeX += pDoc->GetColWidth( i, nTab );
//STRIP001 
//STRIP001 			long nSizeY = 0;
//STRIP001 			if ( bNegY )
//STRIP001 			{
//STRIP001 				//	#94321# in SetCursorAtPoint hidden rows are skipped.
//STRIP001 				//	They must be skipped here too, or the result will always be the first hidden row.
//STRIP001 				do ++nPosY; while ( nPosY<nStartY && ( pDoc->GetRowFlags( nPosY, nTab ) & CR_HIDDEN ) );
//STRIP001 				for (i=nPosY; i<nStartY; i++)
//STRIP001 					nSizeY += pDoc->GetRowHeight( i, nTab );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				for (i=nEndY+1; i<=nPosY; i++)
//STRIP001 					nSizeY += pDoc->GetRowHeight( i, nTab );
//STRIP001 
//STRIP001 			if ( nSizeX > nSizeY )			// Fill immer nur in einer Richtung
//STRIP001 			{
//STRIP001 				nPosY = nEndY;
//STRIP001 				bNegY = FALSE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				nPosX = nEndX;
//STRIP001 				bNegX = FALSE;
//STRIP001 			}
//STRIP001 
//STRIP001 			USHORT nRefStX = bNegX ? nEndX : nStartX;
//STRIP001 			USHORT nRefStY = bNegY ? nEndY : nStartY;
//STRIP001 			if ( nRefStX != pViewData->GetRefStartX() || nRefStY != pViewData->GetRefStartY() )
//STRIP001 			{
//STRIP001 				pViewData->GetView()->DoneRefMode();
//STRIP001 				pViewData->GetView()->InitRefMode( nRefStX, nRefStY, nTab, SC_REFTYPE_FILL );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		pView->UpdateRef( nPosX, nPosY, nTab );
//STRIP001 	}
//STRIP001 	else if (pViewData->IsAnyFillMode())
//STRIP001 	{
//STRIP001 		BYTE nMode = pViewData->GetFillMode();
//STRIP001 		if ( nMode == SC_FILL_EMBED_LT || nMode == SC_FILL_EMBED_RB )
//STRIP001 		{
//STRIP001 			ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 			DBG_ASSERT( pDoc->IsEmbedded(), "!pDoc->IsEmbedded()" );
//STRIP001 			ScTripel aStart;
//STRIP001 			ScTripel aEnd;
//STRIP001 			pDoc->GetEmbedded( aStart, aEnd );
//STRIP001 			ScRefType eRefMode = (nMode == SC_FILL_EMBED_LT) ? SC_REFTYPE_EMBED_LT : SC_REFTYPE_EMBED_RB;
//STRIP001 			if (pViewData->GetRefType() != eRefMode)
//STRIP001 			{
//STRIP001 				if ( nMode == SC_FILL_EMBED_LT )
//STRIP001 					pView->InitRefMode( aEnd.GetCol(), aEnd.GetRow(), nTab, eRefMode );
//STRIP001 				else
//STRIP001 					pView->InitRefMode( aStart.GetCol(), aStart.GetRow(), nTab, eRefMode );
//STRIP001 				CreateAnchor();
//STRIP001 			}
//STRIP001 
//STRIP001 			pView->UpdateRef( nPosX, nPosY, nTab );
//STRIP001 		}
//STRIP001 		else if ( nMode == SC_FILL_MATRIX )
//STRIP001 		{
//STRIP001 			USHORT nStartX, nStartY, nEndX, nEndY;		// Block
//STRIP001 			USHORT nDummy;
//STRIP001 			pViewData->GetSimpleArea( nStartX, nStartY, nDummy, nEndX, nEndY, nDummy );
//STRIP001 
//STRIP001 			if (pViewData->GetRefType() != SC_REFTYPE_FILL)
//STRIP001 			{
//STRIP001 				pView->InitRefMode( nStartX, nStartY, nTab, SC_REFTYPE_FILL );
//STRIP001 				CreateAnchor();
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( nPosX < nStartX ) nPosX = nStartX;
//STRIP001 			if ( nPosY < nStartY ) nPosY = nStartY;
//STRIP001 
//STRIP001 			pView->UpdateRef( nPosX, nPosY, nTab );
//STRIP001 		}
//STRIP001 		// else neue Modi
//STRIP001 	}
//STRIP001 	else					// normales Markieren
//STRIP001 	{
//STRIP001 		BOOL bHideCur = bAnchor && ( (USHORT)nPosX != pViewData->GetCurX() ||
//STRIP001 									 (USHORT)nPosY != pViewData->GetCurY() );
//STRIP001 		if (bHideCur)
//STRIP001 			pView->HideAllCursors();			// sonst zweimal: Block und SetCursor
//STRIP001 
//STRIP001 		if (bAnchor)
//STRIP001 		{
//STRIP001 			if (!bStarted)
//STRIP001 			{
//STRIP001 				BOOL bMove = ( nPosX != (short) aAnchorPos.GetCol() ||
//STRIP001 								nPosY != (short) aAnchorPos.GetRow() );
//STRIP001 				if ( bMove || ( pEngine && pEngine->GetMouseEvent().IsShift() ) )
//STRIP001 				{
//STRIP001 					pView->InitBlockMode( aAnchorPos.GetCol(), aAnchorPos.GetRow(),
//STRIP001 											aAnchorPos.GetTab(), TRUE );
//STRIP001 					bStarted = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if (bStarted)
//STRIP001 				pView->MarkCursor( (USHORT) nPosX, (USHORT) nPosY, nTab );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			ScMarkData& rMark = pViewData->GetMarkData();
//STRIP001 			if (rMark.IsMarked() || rMark.IsMultiMarked())
//STRIP001 			{
//STRIP001 				pView->DoneBlockMode(TRUE);
//STRIP001 				pView->InitBlockMode( nPosX, nPosY, nTab, TRUE );
//STRIP001 				pView->MarkCursor( (USHORT) nPosX, (USHORT) nPosY, nTab );
//STRIP001 
//STRIP001 				aAnchorPos.Put( nPosX, nPosY, nTab );
//STRIP001 				bStarted = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		pView->SetCursor( (USHORT) nPosX, (USHORT) nPosY );
//STRIP001 		pViewData->SetRefStart( nPosX, nPosY, nTab );
//STRIP001 		if (bHideCur)
//STRIP001 			pView->ShowAllCursors();
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bHide)
//STRIP001 		pView->ShowAllCursors();
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

//STRIP001 BOOL __EXPORT ScViewFunctionSet::IsSelectionAtPoint( const Point& rPointPixel )
//STRIP001 {
//STRIP001 	BOOL bRefMode = SC_MOD()->IsFormulaMode();
//STRIP001 	if (bRefMode)
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	if (pViewData->IsAnyFillMode())
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	ScMarkData& rMark = pViewData->GetMarkData();
//STRIP001 	if (bAnchor || !rMark.IsMultiMarked())
//STRIP001 	{
//STRIP001 		short	nPosX;
//STRIP001 		short	nPosY;
//STRIP001 		pViewData->GetPosFromPixel( rPointPixel.X(), rPointPixel.Y(), GetWhich(), nPosX, nPosY );
//STRIP001 		return pViewData->GetMarkData().IsCellMarked( (USHORT) nPosX, (USHORT) nPosY );
//STRIP001 	}
//STRIP001 
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 void __EXPORT ScViewFunctionSet::DeselectAtPoint( const Point& rPointPixel )
//STRIP001 {
//STRIP001 	//	gibt's nicht
//STRIP001 }

//STRIP001 void __EXPORT ScViewFunctionSet::DeselectAll()
//STRIP001 {
//STRIP001 	if (pViewData->IsAnyFillMode())
//STRIP001 		return;
//STRIP001 
//STRIP001 	BOOL bRefMode = SC_MOD()->IsFormulaMode();
//STRIP001 	if (bRefMode)
//STRIP001 	{
//STRIP001 		pViewData->GetView()->DoneRefMode( FALSE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pViewData->GetView()->DoneBlockMode( FALSE );
//STRIP001 		pViewData->GetViewShell()->UpdateInputHandler();
//STRIP001 	}
//STRIP001 
//STRIP001 	bAnchor = FALSE;
//STRIP001 }

//------------------------------------------------------------------------

/*N*/ ScViewSelectionEngine::ScViewSelectionEngine( Window* pWindow, ScTabView* pView,
/*N*/ 												ScSplitPos eSplitPos ) :
/*N*/ 		SelectionEngine( pWindow, pView->GetFunctionSet() ),
/*N*/ 		eWhich( eSplitPos )
/*N*/ {
/*N*/ 	//	Parameter einstellen
/*N*/ 	SetSelectionMode( MULTIPLE_SELECTION );
/*N*/ 	EnableDrag( TRUE );
/*N*/ }


//------------------------------------------------------------------------

//
//					Spalten- / Zeilenheader
//

/*N*/ ScHeaderFunctionSet::ScHeaderFunctionSet( ScViewData* pNewViewData ) :
/*N*/ 		pViewData( pNewViewData ),
/*N*/ 		bColumn( FALSE ),
/*N*/ 		eWhich( SC_SPLIT_TOPLEFT ),
/*N*/ 		bAnchor( FALSE ),
/*N*/ 		nCursorPos( 0 )
/*N*/ {
/*N*/ 	DBG_ASSERT(pViewData, "ViewData==0 bei FunctionSet");
/*N*/ }

//STRIP001 void ScHeaderFunctionSet::SetColumn( BOOL bSet )
//STRIP001 {
//STRIP001 	bColumn = bSet;
//STRIP001 }

//STRIP001 void ScHeaderFunctionSet::SetWhich( ScSplitPos eNew )
//STRIP001 {
//STRIP001 	eWhich = eNew;
//STRIP001 }

//STRIP001 void __EXPORT ScHeaderFunctionSet::BeginDrag()
//STRIP001 {
//STRIP001 	// gippsnich
//STRIP001 }

//STRIP001 void __EXPORT ScHeaderFunctionSet::CreateAnchor()
//STRIP001 {
//STRIP001 	if (bAnchor)
//STRIP001 		return;
//STRIP001 
//STRIP001 	ScTabView* pView = pViewData->GetView();
//STRIP001 	pView->DoneBlockMode( TRUE );
//STRIP001 	if (bColumn)
//STRIP001 	{
//STRIP001 		pView->InitBlockMode( nCursorPos, 0, pViewData->GetTabNo(), TRUE, TRUE, FALSE );
//STRIP001 		pView->MarkCursor( nCursorPos, MAXROW, pViewData->GetTabNo() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pView->InitBlockMode( 0, nCursorPos, pViewData->GetTabNo(), TRUE, FALSE, TRUE );
//STRIP001 		pView->MarkCursor( MAXCOL, nCursorPos, pViewData->GetTabNo() );
//STRIP001 	}
//STRIP001 	bAnchor = TRUE;
//STRIP001 }

//STRIP001 void __EXPORT ScHeaderFunctionSet::DestroyAnchor()
//STRIP001 {
//STRIP001 	pViewData->GetView()->DoneBlockMode( TRUE );
//STRIP001 	bAnchor = FALSE;
//STRIP001 }

//STRIP001 BOOL __EXPORT ScHeaderFunctionSet::SetCursorAtPoint( const Point& rPointPixel, BOOL bDontSelectAtCursor )
//STRIP001 {
//STRIP001 	if ( bDidSwitch )
//STRIP001 	{
//STRIP001 		//	die naechste gueltige Position muss vom anderen Fenster kommen
//STRIP001 		if ( rPointPixel == aSwitchPos )
//STRIP001 			return FALSE;					// nicht auf falschem Fenster scrollen
//STRIP001 		else
//STRIP001 			bDidSwitch = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Scrolling
//STRIP001 
//STRIP001 	Size aWinSize = pViewData->GetActiveWin()->GetOutputSizePixel();
//STRIP001 	BOOL bScroll;
//STRIP001 	if (bColumn)
//STRIP001 		bScroll = ( rPointPixel.X() < 0 || rPointPixel.X() >= aWinSize.Width() );
//STRIP001 	else
//STRIP001 		bScroll = ( rPointPixel.Y() < 0 || rPointPixel.Y() >= aWinSize.Height() );
//STRIP001 
//STRIP001 	//	ueber Fixier-Grenze bewegt?
//STRIP001 
//STRIP001 	BOOL bSwitched = FALSE;
//STRIP001 	if ( bColumn )
//STRIP001 	{
//STRIP001 		if ( pViewData->GetHSplitMode() == SC_SPLIT_FIX )
//STRIP001 		{
//STRIP001 			if ( rPointPixel.X() > aWinSize.Width() )
//STRIP001 			{
//STRIP001 				if ( eWhich == SC_SPLIT_TOPLEFT )
//STRIP001 					pViewData->GetView()->ActivatePart( SC_SPLIT_TOPRIGHT ), bSwitched = TRUE;
//STRIP001 				else if ( eWhich == SC_SPLIT_BOTTOMLEFT )
//STRIP001 					pViewData->GetView()->ActivatePart( SC_SPLIT_BOTTOMRIGHT ), bSwitched = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else				// Zeilenkoepfe
//STRIP001 	{
//STRIP001 		if ( pViewData->GetVSplitMode() == SC_SPLIT_FIX )
//STRIP001 		{
//STRIP001 			if ( rPointPixel.Y() > aWinSize.Height() )
//STRIP001 			{
//STRIP001 				if ( eWhich == SC_SPLIT_TOPLEFT )
//STRIP001 					pViewData->GetView()->ActivatePart( SC_SPLIT_BOTTOMLEFT ), bSwitched = TRUE;
//STRIP001 				else if ( eWhich == SC_SPLIT_TOPRIGHT )
//STRIP001 					pViewData->GetView()->ActivatePart( SC_SPLIT_BOTTOMRIGHT ), bSwitched = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if (bSwitched)
//STRIP001 	{
//STRIP001 		aSwitchPos = rPointPixel;
//STRIP001 		bDidSwitch = TRUE;
//STRIP001 		return FALSE;				// nicht mit falschen Positionen rechnen
//STRIP001 	}
//STRIP001 
//STRIP001 	//
//STRIP001 
//STRIP001 	short	nPosX;
//STRIP001 	short	nPosY;
//STRIP001 	pViewData->GetPosFromPixel( rPointPixel.X(), rPointPixel.Y(), pViewData->GetActivePart(),
//STRIP001 								nPosX, nPosY, FALSE );
//STRIP001 	if (bColumn)
//STRIP001 	{
//STRIP001 		nCursorPos = nPosX;
//STRIP001 		nPosY = pViewData->GetPosY(WhichV(pViewData->GetActivePart()));
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nCursorPos = nPosY;
//STRIP001 		nPosX = pViewData->GetPosX(WhichH(pViewData->GetActivePart()));
//STRIP001 	}
//STRIP001 
//STRIP001 	ScTabView* pView = pViewData->GetView();
//STRIP001 	BOOL bHide = pViewData->GetCurX() != nPosX ||
//STRIP001 				 pViewData->GetCurY() != nPosY;
//STRIP001 	if (bHide)
//STRIP001 		pView->HideAllCursors();
//STRIP001 
//STRIP001 	if (bScroll)
//STRIP001 		pView->AlignToCursor( nPosX, nPosY, SC_FOLLOW_LINE );
//STRIP001 	pView->SetCursor( nPosX, nPosY );
//STRIP001 
//STRIP001 	if ( !bAnchor || !pView->IsBlockMode() )
//STRIP001 	{
//STRIP001 		pView->DoneBlockMode( TRUE );
//STRIP001 		pViewData->GetMarkData().MarkToMulti();			//! wer verstellt das ???
//STRIP001 		pView->InitBlockMode( nPosX, nPosY, pViewData->GetTabNo(), TRUE, bColumn, !bColumn );
//STRIP001 
//STRIP001 		bAnchor = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	pView->MarkCursor( nPosX, nPosY, pViewData->GetTabNo(), bColumn, !bColumn );
//STRIP001 
//STRIP001 	//	SelectionChanged innerhalb von HideCursor wegen UpdateAutoFillMark
//STRIP001 	pView->SelectionChanged();
//STRIP001 
//STRIP001 	if (bHide)
//STRIP001 		pView->ShowAllCursors();
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

//STRIP001 BOOL __EXPORT ScHeaderFunctionSet::IsSelectionAtPoint( const Point& rPointPixel )
//STRIP001 {
//STRIP001 	short	nPosX;
//STRIP001 	short	nPosY;
//STRIP001 	pViewData->GetPosFromPixel( rPointPixel.X(), rPointPixel.Y(), pViewData->GetActivePart(),
//STRIP001 								nPosX, nPosY, FALSE );
//STRIP001 
//STRIP001 	ScMarkData& rMark = pViewData->GetMarkData();
//STRIP001 	if (bColumn)
//STRIP001 		return rMark.IsColumnMarked( nPosX );
//STRIP001 	else
//STRIP001 		return rMark.IsRowMarked( nPosY );
//STRIP001 }

//STRIP001 void __EXPORT ScHeaderFunctionSet::DeselectAtPoint( const Point& rPointPixel )
//STRIP001 {
//STRIP001 }

//STRIP001 void __EXPORT ScHeaderFunctionSet::DeselectAll()
//STRIP001 {
//STRIP001 	pViewData->GetView()->DoneBlockMode( FALSE );
//STRIP001 	bAnchor = FALSE;
//STRIP001 }

//------------------------------------------------------------------------

/*N*/ ScHeaderSelectionEngine::ScHeaderSelectionEngine( Window* pWindow, ScHeaderFunctionSet* pFuncSet ) :
/*N*/ 		SelectionEngine( pWindow, pFuncSet )
/*N*/ {
/*N*/ 	//	Parameter einstellen
/*N*/ 	SetSelectionMode( MULTIPLE_SELECTION );
/*N*/ 	EnableDrag( FALSE );
/*N*/ }





}
