/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_undoblk.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:05:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------

#define _MACRODLG_HXX
#define _BIGINT_HXX
#define _SVDXOUT_HXX
#define _SVDATTR_HXX
#define _SVDSURO_HXX

// INCLUDE ---------------------------------------------------------------

#include "scitems.hxx"
// auto strip #include <vcl/virdev.hxx>
// auto strip #include <vcl/waitobj.hxx>
#include <bf_svx/boxitem.hxx>

#include "undoblk.hxx"
// auto strip #include "undoutil.hxx"
// auto strip #include "document.hxx"
// auto strip #include "patattr.hxx"
#include "docsh.hxx"
// auto strip #include "tabvwsh.hxx"
// auto strip #include "rangenam.hxx"
// auto strip #include "rangeutl.hxx"
// auto strip #include "dbcolect.hxx"
// auto strip #include "stlpool.hxx"
// auto strip #include "stlsheet.hxx"
#include "globstr.hrc"
// auto strip #include "global.hxx"
#include "target.hxx"
// auto strip #include "docpool.hxx"
// auto strip #include "docfunc.hxx"
// auto strip #include "attrib.hxx"
// auto strip #include "chgtrack.hxx"
// auto strip #include "transobj.hxx"
#include "refundo.hxx"
// auto strip #include "undoolk.hxx"
namespace binfilter {


// STATIC DATA -----------------------------------------------------------

//STRIP001 TYPEINIT1(ScUndoInsertCells,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoDeleteCells,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoDeleteMulti,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoCut,				ScBlockUndo);
//STRIP001 TYPEINIT1(ScUndoPaste,				SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoDragDrop,			SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoListNames,			SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoUseScenario,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoSelectionStyle,		SfxUndoAction);
TYPEINIT1(ScUndoEnterMatrix,		ScBlockUndo);
//STRIP001 TYPEINIT1(ScUndoIndent,				ScBlockUndo);
//STRIP001 TYPEINIT1(ScUndoTransliterate,		ScBlockUndo);
//STRIP001 TYPEINIT1(ScUndoClearItems,			ScBlockUndo);
//STRIP001 TYPEINIT1(ScUndoRemoveBreaks,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoRemoveMerge,		ScBlockUndo);
//STRIP001 TYPEINIT1(ScUndoBorder,				ScBlockUndo);



// To Do:
/*A*/	// SetOptimalHeight auf Dokument, wenn keine View
/*B*/	// gelinkte Tabellen
/*C*/	// ScArea
//?		// spaeter mal pruefen


// -----------------------------------------------------------------------
//
//		Zellen einfuegen
//		Zeilen einfgen
//		einzeln oder Block
//

//STRIP001 ScUndoInsertCells::ScUndoInsertCells( ScDocShell* pNewDocShell,
//STRIP001 								const ScRange& rRange, InsCellCmd eNewCmd,
//STRIP001 								ScDocument* pUndoDocument, ScRefUndoData* pRefData,
//STRIP001 								BOOL bNewPartOfPaste ) :
//STRIP001 	ScMoveUndo( pNewDocShell, pUndoDocument, pRefData, SC_UNDO_REFLAST ),
//STRIP001 	aEffRange( rRange ),
//STRIP001 	eCmd( eNewCmd ),
//STRIP001 	bPartOfPaste( bNewPartOfPaste ),
//STRIP001 	pPasteUndo( NULL )
//STRIP001 {
//STRIP001 	if (eCmd == INS_INSROWS)			// ganze Zeilen?
//STRIP001 	{
//STRIP001 		aEffRange.aStart.SetCol(0);
//STRIP001 		aEffRange.aEnd.SetCol(MAXCOL);
//STRIP001 	}
//STRIP001 
//STRIP001 	if (eCmd == INS_INSCOLS)			// ganze Spalten?
//STRIP001 	{
//STRIP001 		aEffRange.aStart.SetRow(0);
//STRIP001 		aEffRange.aEnd.SetRow(MAXROW);
//STRIP001 	}
//STRIP001 
//STRIP001 	SetChangeTrack();
//STRIP001 }

//STRIP001 __EXPORT ScUndoInsertCells::~ScUndoInsertCells()
//STRIP001 {
//STRIP001 	delete pPasteUndo;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoInsertCells::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( pPasteUndo ? STR_UNDO_PASTE : STR_UNDO_INSERTCELLS );
//STRIP001 }

//STRIP001 BOOL ScUndoInsertCells::Merge( SfxUndoAction* pNextAction )
//STRIP001 {
//STRIP001 	//	If a paste undo action has already been added, append (detective) action there.
//STRIP001 	if ( pPasteUndo )
//STRIP001 		return pPasteUndo->Merge( pNextAction );
//STRIP001 
//STRIP001 	if ( bPartOfPaste && pNextAction->ISA( ScUndoWrapper ) )
//STRIP001 	{
//STRIP001 		ScUndoWrapper* pWrapper = (ScUndoWrapper*)pNextAction;
//STRIP001 		SfxUndoAction* pWrappedAction = pWrapper->GetWrappedUndo();
//STRIP001 		if ( pWrappedAction && pWrappedAction->ISA( ScUndoPaste ) )
//STRIP001 		{
//STRIP001 			//	Store paste action if this is part of paste with inserting cells.
//STRIP001 			//	A list action isn't used because Repeat wouldn't work (insert wrong cells).
//STRIP001 
//STRIP001 			pPasteUndo = pWrappedAction;
//STRIP001 			pWrapper->ForgetWrappedUndo();		// pWrapper is deleted by UndoManager
//STRIP001 			return TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Call base class for detective handling
//STRIP001 	return ScMoveUndo::Merge( pNextAction );
//STRIP001 }

//STRIP001 void ScUndoInsertCells::SetChangeTrack()
//STRIP001 {
//STRIP001 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 	{
//STRIP001 		pChangeTrack->AppendInsert( aEffRange );
//STRIP001 		nEndChangeAction = pChangeTrack->GetActionMax();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nEndChangeAction = 0;
//STRIP001 }

//STRIP001 void ScUndoInsertCells::DoChange( const BOOL bUndo )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	if ( bUndo )
//STRIP001 	{
//STRIP001 		ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
//STRIP001 		if ( pChangeTrack )
//STRIP001 			pChangeTrack->Undo( nEndChangeAction, nEndChangeAction );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		SetChangeTrack();
//STRIP001 
//STRIP001 	ScRange aWorkRange( aEffRange );
//STRIP001 	if ( pDoc->HasAttrib( aWorkRange, HASATTR_MERGED ) )	// zusammengefasste Zellen?
//STRIP001 		pDoc->ExtendMerge( aWorkRange, TRUE );
//STRIP001 
//STRIP001 	switch (eCmd)
//STRIP001 	{
//STRIP001 		case INS_INSROWS:
//STRIP001 		case INS_CELLSDOWN:
//STRIP001 			if (bUndo)
//STRIP001 				pDoc->DeleteRow( aEffRange );
//STRIP001 			else
//STRIP001 				pDoc->InsertRow( aEffRange );
//STRIP001 			break;
//STRIP001 		case INS_INSCOLS:
//STRIP001 		case INS_CELLSRIGHT:
//STRIP001 			if (bUndo)
//STRIP001 				pDoc->DeleteCol( aEffRange );
//STRIP001 			else
//STRIP001 				pDoc->InsertCol( aEffRange );
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 //?	Undo fuer herausgeschobene Attribute ?
//STRIP001 
//STRIP001 	USHORT nPaint = PAINT_GRID;
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	switch (eCmd)
//STRIP001 	{
//STRIP001 		case INS_INSROWS:
//STRIP001 			nPaint |= PAINT_LEFT;
//STRIP001 			aWorkRange.aEnd.SetRow(MAXROW);
//STRIP001 			break;
//STRIP001 		case INS_CELLSDOWN:
//STRIP001 			aWorkRange.aEnd.SetRow(MAXROW);		// bis ganz nach unten
//STRIP001 /*A*/		if ( (pViewShell) && pViewShell->AdjustRowHeight(
//STRIP001 					aWorkRange.aStart.Row(), aWorkRange.aEnd.Row(), FALSE ) )
//STRIP001 			{
//STRIP001 				aWorkRange.aStart.SetCol(0);
//STRIP001 				aWorkRange.aEnd.SetCol(MAXCOL);
//STRIP001 				nPaint |= PAINT_LEFT;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case INS_INSCOLS:
//STRIP001 			nPaint |= PAINT_TOP;				// obere Leiste
//STRIP001 		case INS_CELLSRIGHT:
//STRIP001 			aWorkRange.aEnd.SetCol(MAXCOL);		// bis ganz nach rechts
//STRIP001 /*A*/		if ( (pViewShell) && pViewShell->AdjustRowHeight(
//STRIP001 					aWorkRange.aStart.Row(), aWorkRange.aEnd.Row(), FALSE ) )
//STRIP001 			{									// AdjustDraw zeichnet PAINT_TOP nicht,
//STRIP001 				aWorkRange.aStart.SetCol(0);	// daher so geloest
//STRIP001 				aWorkRange.aEnd.SetRow(MAXROW);
//STRIP001 				nPaint |= PAINT_LEFT;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	pDocShell->PostPaint( aWorkRange, nPaint );
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->CellContentChanged();
//STRIP001 
//STRIP001 	ShowTable( aEffRange.aStart.Tab() );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoInsertCells::Undo()
//STRIP001 {
//STRIP001 	if ( pPasteUndo )
//STRIP001 		pPasteUndo->Undo();		// undo paste first
//STRIP001 
//STRIP001 	WaitObject aWait( pDocShell->GetDialogParent() );		// wichtig wegen TrackFormulas bei UpdateReference
//STRIP001 	BeginUndo();
//STRIP001 	DoChange( TRUE );
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoInsertCells::Redo()
//STRIP001 {
//STRIP001 	WaitObject aWait( pDocShell->GetDialogParent() );		// wichtig wegen TrackFormulas bei UpdateReference
//STRIP001 	BeginRedo();
//STRIP001 	DoChange( FALSE );
//STRIP001 	EndRedo();
//STRIP001 
//STRIP001 	if ( pPasteUndo )
//STRIP001 		pPasteUndo->Redo();		// redo paste last
//STRIP001 }

//STRIP001 void __EXPORT ScUndoInsertCells::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 	{
//STRIP001 		if ( pPasteUndo )
//STRIP001 		{
//STRIP001 			//	#94115# Repeat for paste with inserting cells is handled completely
//STRIP001 			//	by the Paste undo action
//STRIP001 
//STRIP001 			pPasteUndo->Repeat( rTarget );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			((ScTabViewTarget&)rTarget).GetViewShell()->InsertCells( eCmd, TRUE );
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoInsertCells::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Zellen loeschen
//		Zeilen lschen
//		einzeln oder Block
//

//STRIP001 ScUndoDeleteCells::ScUndoDeleteCells( ScDocShell* pNewDocShell,
//STRIP001 								const ScRange& rRange, DelCellCmd eNewCmd,
//STRIP001 								ScDocument* pUndoDocument, ScRefUndoData* pRefData ) :
//STRIP001 	ScMoveUndo( pNewDocShell, pUndoDocument, pRefData, SC_UNDO_REFLAST ),
//STRIP001 	aEffRange( rRange ),
//STRIP001 	eCmd( eNewCmd )
//STRIP001 {
//STRIP001 	if (eCmd == DEL_DELROWS)			// gaze Zeilen?
//STRIP001 	{
//STRIP001 		aEffRange.aStart.SetCol(0);
//STRIP001 		aEffRange.aEnd.SetCol(MAXCOL);
//STRIP001 	}
//STRIP001 
//STRIP001 	if (eCmd == DEL_DELCOLS)			// ganze Spalten?
//STRIP001 	{
//STRIP001 		aEffRange.aStart.SetRow(0);
//STRIP001 		aEffRange.aEnd.SetRow(MAXROW);
//STRIP001 	}
//STRIP001 
//STRIP001 	SetChangeTrack();
//STRIP001 }

//STRIP001 __EXPORT ScUndoDeleteCells::~ScUndoDeleteCells()
//STRIP001 {
//STRIP001 }

//STRIP001 String __EXPORT ScUndoDeleteCells::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_DELETECELLS ); // "Loeschen"
//STRIP001 }

//STRIP001 void ScUndoDeleteCells::SetChangeTrack()
//STRIP001 {
//STRIP001 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 		pChangeTrack->AppendDeleteRange( aEffRange, pRefUndoDoc,
//STRIP001 			nStartChangeAction, nEndChangeAction );
//STRIP001 	else
//STRIP001 		nStartChangeAction = nEndChangeAction = 0;
//STRIP001 }

//STRIP001 void ScUndoDeleteCells::DoChange( const BOOL bUndo )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	if ( bUndo )
//STRIP001 	{
//STRIP001 		ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
//STRIP001 		if ( pChangeTrack )
//STRIP001 			pChangeTrack->Undo( nStartChangeAction, nEndChangeAction );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		SetChangeTrack();
//STRIP001 
//STRIP001 	// Ausfuehren
//STRIP001 	switch (eCmd)
//STRIP001 	{
//STRIP001 		case DEL_DELROWS:
//STRIP001 		case DEL_CELLSUP:
//STRIP001 			if (bUndo)
//STRIP001 				pDoc->InsertRow( aEffRange );
//STRIP001 			else
//STRIP001 				pDoc->DeleteRow( aEffRange );
//STRIP001 			break;
//STRIP001 		case DEL_DELCOLS:
//STRIP001 		case DEL_CELLSLEFT:
//STRIP001 			if (bUndo)
//STRIP001 				pDoc->InsertCol( aEffRange );
//STRIP001 			else
//STRIP001 				pDoc->DeleteCol( aEffRange );
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	// bei Undo Referenzen wiederherstellen
//STRIP001 	if (bUndo)
//STRIP001 		pRefUndoDoc->CopyToDocument( aEffRange, IDF_ALL, FALSE, pDoc );
//STRIP001 
//STRIP001 //?	Datenbank muss vor ExtendMerge sein ?????
//STRIP001 
//STRIP001 	// Zusammengefasste Zellen?
//STRIP001 	ScRange aWorkRange( aEffRange );
//STRIP001 	if ( pDoc->HasAttrib( aWorkRange, HASATTR_MERGED ) )
//STRIP001 	{
//STRIP001 /*?		if ( !bUndo && ( eCmd==DEL_DELCOLS || eCmd==DEL_DELROWS ) )
//STRIP001 		{
//STRIP001 			if (eCmd==DEL_DELCOLS) aWorkRange.aEnd.SetCol(MAXCOL);
//STRIP001 			if (eCmd==DEL_DELROWS) aWorkRange.aEnd.SetRow(MAXROW);
//STRIP001 			ScMarkData aMarkData;
//STRIP001 			aMarkData.SelectOneTable( aWorkRange.aStart.Tab() );
//STRIP001 			ScPatternAttr aPattern( pDoc->GetPool() );
//STRIP001 			aPattern.GetItemSet().Put( ScMergeFlagAttr() );
//STRIP001 			pDoc->ApplyPatternArea( aWorkRange.aStart.Col(), aWorkRange.aStart.Row(),
//STRIP001 									aWorkRange.aEnd.Col(),   aWorkRange.aEnd.Row(),
//STRIP001 									aMarkData, aPattern );
//STRIP001 		}
//STRIP001 ?*/
//STRIP001 		pDoc->ExtendMerge( aWorkRange, TRUE );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Zeichnen
//STRIP001 	USHORT nPaint = PAINT_GRID;
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	switch (eCmd)
//STRIP001 	{
//STRIP001 		case DEL_DELROWS:
//STRIP001 			nPaint |= PAINT_LEFT;
//STRIP001 			aWorkRange.aEnd.SetRow(MAXROW);
//STRIP001 			break;
//STRIP001 		case DEL_CELLSUP:
//STRIP001 			aWorkRange.aEnd.SetRow(MAXROW);
//STRIP001 /*A*/		if ( (pViewShell) && pViewShell->AdjustRowHeight(
//STRIP001 					aWorkRange.aStart.Row(), aWorkRange.aEnd.Row(), FALSE   ) )
//STRIP001 			{
//STRIP001 				aWorkRange.aStart.SetCol(0);
//STRIP001 				aWorkRange.aEnd.SetCol(MAXCOL);
//STRIP001 				nPaint |= PAINT_LEFT;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case DEL_DELCOLS:
//STRIP001 			nPaint |= PAINT_TOP;				// obere Leiste
//STRIP001 		case DEL_CELLSLEFT:
//STRIP001 			aWorkRange.aEnd.SetCol(MAXCOL);		// bis ganz nach rechts
//STRIP001 /*A*/		if ( (pViewShell) && pViewShell->AdjustRowHeight(
//STRIP001 					aWorkRange.aStart.Row(), aWorkRange.aEnd.Row(), FALSE ) )
//STRIP001 			{
//STRIP001 				aWorkRange.aStart.SetCol(0);
//STRIP001 				aWorkRange.aEnd.SetRow(MAXROW);
//STRIP001 				nPaint |= PAINT_LEFT;
//STRIP001 			}
//STRIP001 	}
//STRIP001 	pDocShell->PostPaint( aWorkRange, nPaint, SC_PF_LINES );	//! auf Lines testen
//STRIP001 
//STRIP001 	// Markierung erst nach EndUndo
//STRIP001 
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 	//	CellContentChanged kommt mit der Markierung
//STRIP001 
//STRIP001 	ShowTable( aEffRange.aStart.Tab() );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDeleteCells::Undo()
//STRIP001 {
//STRIP001 	WaitObject aWait( pDocShell->GetDialogParent() );		// wichtig wegen TrackFormulas bei UpdateReference
//STRIP001 	BeginUndo();
//STRIP001 	DoChange( TRUE );
//STRIP001 	EndUndo();
//STRIP001 
//STRIP001 	// Markierung erst nach EndUndo
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->MarkRange( aEffRange );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDeleteCells::Redo()
//STRIP001 {
//STRIP001 	WaitObject aWait( pDocShell->GetDialogParent() );		// wichtig wegen TrackFormulas bei UpdateReference
//STRIP001 	BeginRedo();
//STRIP001 	DoChange( FALSE);
//STRIP001 	EndRedo();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->DoneBlockMode();			// aktuelle weg
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDeleteCells::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->DeleteCells( eCmd, TRUE );
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoDeleteCells::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Zellen loeschen auf Mehrfachselektion
//

//STRIP001 ScUndoDeleteMulti::ScUndoDeleteMulti( ScDocShell* pNewDocShell,
//STRIP001 										BOOL bNewRows, USHORT nNewTab,
//STRIP001 										const USHORT* pRng, USHORT nRngCnt,
//STRIP001 										ScDocument* pUndoDocument, ScRefUndoData* pRefData ) :
//STRIP001 	ScMoveUndo( pNewDocShell, pUndoDocument, pRefData, SC_UNDO_REFLAST ),
//STRIP001 	bRows( bNewRows ),
//STRIP001 	nTab( nNewTab ),
//STRIP001 	nRangeCnt( nRngCnt )
//STRIP001 {
//STRIP001 	pRanges = new USHORT[ 2 * nRangeCnt ];
//STRIP001 	memcpy(pRanges,pRng,nRangeCnt*2*sizeof(USHORT));
//STRIP001 	SetChangeTrack();
//STRIP001 }

//STRIP001 __EXPORT ScUndoDeleteMulti::~ScUndoDeleteMulti()
//STRIP001 {
//STRIP001 	delete pRanges;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoDeleteMulti::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_DELETECELLS );	// wie DeleteCells
//STRIP001 }

//STRIP001 void ScUndoDeleteMulti::DoChange() const
//STRIP001 {
//STRIP001 	if (bRows)
//STRIP001 		pDocShell->PostPaint( 0,pRanges[0],nTab, MAXCOL,MAXROW,nTab, PAINT_GRID | PAINT_LEFT );
//STRIP001 	else
//STRIP001 		pDocShell->PostPaint( pRanges[0],0,nTab, MAXCOL,MAXROW,nTab, PAINT_GRID | PAINT_TOP );
//STRIP001 
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->CellContentChanged();
//STRIP001 
//STRIP001 	ShowTable( nTab );
//STRIP001 }

//STRIP001 void ScUndoDeleteMulti::SetChangeTrack()
//STRIP001 {
//STRIP001 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 	{
//STRIP001 		nStartChangeAction = pChangeTrack->GetActionMax() + 1;
//STRIP001 		ScRange aRange( 0, 0, nTab, 0, 0, nTab );
//STRIP001 		if ( bRows )
//STRIP001 			aRange.aEnd.SetCol( MAXCOL );
//STRIP001 		else
//STRIP001 			aRange.aEnd.SetRow( MAXROW );
//STRIP001 		// rueckwaerts loeschen
//STRIP001 		USHORT* pOneRange = &pRanges[2*nRangeCnt];
//STRIP001 		for ( USHORT nRangeNo=0; nRangeNo<nRangeCnt; nRangeNo++ )
//STRIP001 		{
//STRIP001 			USHORT nEnd = *(--pOneRange);
//STRIP001 			USHORT nStart = *(--pOneRange);
//STRIP001 			if ( bRows )
//STRIP001 			{
//STRIP001 				aRange.aStart.SetRow( nStart );
//STRIP001 				aRange.aEnd.SetRow( nEnd );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aRange.aStart.SetCol( nStart );
//STRIP001 				aRange.aEnd.SetCol( nEnd );
//STRIP001 			}
//STRIP001 			ULONG nDummyStart;
//STRIP001 			pChangeTrack->AppendDeleteRange( aRange, pRefUndoDoc,
//STRIP001 				nDummyStart, nEndChangeAction );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nStartChangeAction = nEndChangeAction = 0;
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDeleteMulti::Undo()
//STRIP001 {
//STRIP001 	WaitObject aWait( pDocShell->GetDialogParent() );		// wichtig wegen TrackFormulas bei UpdateReference
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	USHORT* pOneRange;
//STRIP001 	USHORT nRangeNo;
//STRIP001 
//STRIP001 	//	rueckwaerts geloescht -> vorwaerts einfuegen
//STRIP001 	pOneRange = pRanges;
//STRIP001 	for (nRangeNo=0; nRangeNo<nRangeCnt; nRangeNo++)
//STRIP001 	{
//STRIP001 		USHORT nStart = *(pOneRange++);
//STRIP001 		USHORT nEnd = *(pOneRange++);
//STRIP001 		if (bRows)
//STRIP001 			pDoc->InsertRow( 0,nTab, MAXCOL,nTab, nStart,nEnd-nStart+1 );
//STRIP001 		else
//STRIP001 			pDoc->InsertCol( 0,nTab, MAXROW,nTab, nStart,nEnd-nStart+1 );
//STRIP001 	}
//STRIP001 
//STRIP001 	pOneRange = pRanges;
//STRIP001 	for (nRangeNo=0; nRangeNo<nRangeCnt; nRangeNo++)
//STRIP001 	{
//STRIP001 		USHORT nStart = *(pOneRange++);
//STRIP001 		USHORT nEnd = *(pOneRange++);
//STRIP001 		if (bRows)
//STRIP001 			pRefUndoDoc->CopyToDocument( 0,nStart,nTab, MAXCOL,nEnd,nTab, IDF_ALL,FALSE,pDoc );
//STRIP001 		else
//STRIP001 			pRefUndoDoc->CopyToDocument( nStart,0,nTab, nEnd,MAXROW,nTab, IDF_ALL,FALSE,pDoc );
//STRIP001 	}
//STRIP001 
//STRIP001 	ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 		pChangeTrack->Undo( nStartChangeAction, nEndChangeAction );
//STRIP001 
//STRIP001 	DoChange();
//STRIP001 
//STRIP001 	//!	Markierung wieder einzeichnen
//STRIP001 	//!	geht im Moment nicht, da keine Daten fuer Markierung vorhanden!
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDeleteMulti::Redo()
//STRIP001 {
//STRIP001 	WaitObject aWait( pDocShell->GetDialogParent() );		// wichtig wegen TrackFormulas bei UpdateReference
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	// rueckwaerts loeschen
//STRIP001 	USHORT* pOneRange = &pRanges[2*nRangeCnt];
//STRIP001 	for (USHORT nRangeNo=0; nRangeNo<nRangeCnt; nRangeNo++)
//STRIP001 	{
//STRIP001 		USHORT nEnd = *(--pOneRange);
//STRIP001 		USHORT nStart = *(--pOneRange);
//STRIP001 		if (bRows)
//STRIP001 			pDoc->DeleteRow( 0,nTab, MAXCOL,nTab, nStart,nEnd-nStart+1 );
//STRIP001 		else
//STRIP001 			pDoc->DeleteCol( 0,nTab, MAXROW,nTab, nStart,nEnd-nStart+1 );
//STRIP001 	}
//STRIP001 
//STRIP001 	SetChangeTrack();
//STRIP001 
//STRIP001 	DoChange();
//STRIP001 
//STRIP001 //!	Markierung loeschen, derzeit unnoetig (s.o.)
//STRIP001 //!	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 //!	if (pViewShell)
//STRIP001 //!		DoneBlockMode();
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDeleteMulti::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	//	DeleteCells, falls einfache Selektion
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->DeleteCells( DEL_DELROWS, TRUE );
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoDeleteMulti::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Ausschneiden (Cut)
//

//STRIP001 ScUndoCut::ScUndoCut( ScDocShell* pNewDocShell,
//STRIP001 				ScRange aRange, ScAddress aOldEnd,
//STRIP001 				ScDocument* pNewUndoDoc ) :
//STRIP001 	ScBlockUndo( pNewDocShell, ScRange(aRange.aStart, aOldEnd), SC_UNDO_AUTOHEIGHT ),
//STRIP001 	aExtendedRange( aRange ),
//STRIP001 	pUndoDoc( pNewUndoDoc )
//STRIP001 {
//STRIP001 	SetChangeTrack();
//STRIP001 }

//STRIP001 __EXPORT ScUndoCut::~ScUndoCut()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoCut::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_CUT ); // "Ausschneiden"
//STRIP001 }

//STRIP001 void ScUndoCut::SetChangeTrack()
//STRIP001 {
//STRIP001 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 		pChangeTrack->AppendContentRange( aBlockRange, pUndoDoc,
//STRIP001 			nStartChangeAction, nEndChangeAction, SC_CACM_CUT );
//STRIP001 	else
//STRIP001 		nStartChangeAction = nEndChangeAction = 0;
//STRIP001 }

//STRIP001 void ScUndoCut::DoChange( const BOOL bUndo )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	USHORT nExtFlags = 0;
//STRIP001 
//STRIP001 	if (bUndo)	// nur bei Undo
//STRIP001 	{
//STRIP001 		pUndoDoc->CopyToDocument( aExtendedRange, IDF_ALL, FALSE, pDoc );
//STRIP001 		ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
//STRIP001 		if ( pChangeTrack )
//STRIP001 			pChangeTrack->Undo( nStartChangeAction, nEndChangeAction );
//STRIP001 	}
//STRIP001 	else		// nur bei Redo
//STRIP001 	{
//STRIP001 		if (pDoc->HasAttrib( aExtendedRange, HASATTR_PAINTEXT ))
//STRIP001 			nExtFlags = SC_PF_LINES;
//STRIP001 		pDoc->DeleteAreaTab( aBlockRange, IDF_ALL );
//STRIP001 		SetChangeTrack();
//STRIP001 	}
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if ( !( (pViewShell) && pViewShell->AdjustBlockHeight() ) )
//STRIP001 /*A*/	pDocShell->PostPaint( aExtendedRange, PAINT_GRID, nExtFlags );
//STRIP001 
//STRIP001 	if ( pDrawUndo && !bUndo )					//	draw redo after updating row heights
//STRIP001 		RedoSdrUndoAction( pDrawUndo );			//!	include in ScBlockUndo?
//STRIP001 
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->CellContentChanged();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoCut::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 	DoChange( TRUE );
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoCut::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	EnableDrawAdjust( pDoc, FALSE );				//! include in ScBlockUndo?
//STRIP001 	DoChange( FALSE );
//STRIP001 	EnableDrawAdjust( pDoc, TRUE );					//! include in ScBlockUndo?
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoCut::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->CutToClip( NULL, TRUE );
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoCut::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Einfuegen (Paste)
//

/*N*/ ScUndoPaste::ScUndoPaste( ScDocShell* pNewDocShell,
/*N*/ 				USHORT nStartX, USHORT nStartY, USHORT nStartZ,
/*N*/ 				USHORT nEndX, USHORT nEndY, USHORT nEndZ,
/*N*/ 				const ScMarkData& rMark,
/*N*/ 				ScDocument* pNewUndoDoc, ScDocument* pNewRedoDoc,
/*N*/ 				USHORT nNewFlags,
/*N*/ 				ScRefUndoData* pRefData,
/*N*/ 				void* pFill1, void* pFill2, void* pFill3, 
/*N*/ 				BOOL bRedoIsFilled, const ScUndoPasteOptions* pOptions ) :
/*N*/ 	ScBlockUndo( pNewDocShell, ScRange( nStartX, nStartY, nStartZ, nEndX, nEndY, nEndZ ), SC_UNDO_SIMPLE ),
/*N*/ 	aMarkData( rMark ),
/*N*/ 	pUndoDoc( pNewUndoDoc ),
/*N*/ 	pRedoDoc( pNewRedoDoc ),
/*N*/ 	nFlags( nNewFlags ),
/*N*/ 	pRefUndoData( pRefData ),
/*N*/ 	pRefRedoData( NULL ),
/*N*/ 	bRedoFilled( bRedoIsFilled )
/*N*/ {
/*N*/ 	//	pFill1,pFill2,pFill3 are there so the ctor calls for simple paste (without cutting)
/*N*/ 	//	don't have to be changed and branched for 641.
/*N*/ 	//	They can be removed later.
/*N*/ 
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( !aMarkData.IsMarked() )				// no cell marked:
//STRIP001 		aMarkData.SetMarkArea( aBlockRange );	//  mark paste block
//STRIP001 
//STRIP001 	if ( pRefUndoData )
//STRIP001 		pRefUndoData->DeleteUnchanged( pDocShell->GetDocument() );
//STRIP001 
//STRIP001 	if ( pOptions )
//STRIP001 		aPasteOptions = *pOptions;		// used only for Repeat
//STRIP001 
//STRIP001 	SetChangeTrack();
/*N*/ }

/*N*/ __EXPORT ScUndoPaste::~ScUndoPaste()
/*N*/ {
/*N*/ 	delete pUndoDoc;
/*N*/ 	delete pRedoDoc;
/*N*/ 	delete pRefUndoData;
/*N*/ 	delete pRefRedoData;
/*N*/ }

//STRIP001 String __EXPORT ScUndoPaste::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_PASTE ); // "Einfuegen"
//STRIP001 }

//STRIP001 void ScUndoPaste::SetChangeTrack()
//STRIP001 {
//STRIP001 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
//STRIP001 	if ( pChangeTrack && (nFlags & IDF_CONTENTS) )
//STRIP001 		pChangeTrack->AppendContentRange( aBlockRange, pUndoDoc,
//STRIP001 			nStartChangeAction, nEndChangeAction, SC_CACM_PASTE );
//STRIP001 	else
//STRIP001 		nStartChangeAction = nEndChangeAction = 0;
//STRIP001 }

//STRIP001 void ScUndoPaste::DoChange( const BOOL bUndo )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	//	RefUndoData for redo is created before first undo
//STRIP001 	//	(with DeleteUnchanged after the DoUndo call)
//STRIP001 	BOOL bCreateRedoData = ( bUndo && pRefUndoData && !pRefRedoData );
//STRIP001 	if ( bCreateRedoData )
//STRIP001 		pRefRedoData = new ScRefUndoData( pDoc );
//STRIP001 
//STRIP001 	ScRefUndoData* pWorkRefData = bUndo ? pRefUndoData : pRefRedoData;
//STRIP001 
//STRIP001 		//	fuer Undo immer alle oder keine Inhalte sichern
//STRIP001 	USHORT nUndoFlags = IDF_NONE;
//STRIP001 	if (nFlags & IDF_CONTENTS)
//STRIP001 		nUndoFlags |= IDF_CONTENTS;
//STRIP001 	if (nFlags & IDF_ATTRIB)
//STRIP001 		nUndoFlags |= IDF_ATTRIB;
//STRIP001 
//STRIP001 	BOOL bPaintAll = FALSE;
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	// marking is in ScBlockUndo...
//STRIP001 	ScUndoUtil::MarkSimpleBlock( pDocShell, aBlockRange );
//STRIP001 
//STRIP001 	if ( bUndo && !bRedoFilled )
//STRIP001 	{
//STRIP001 		if (!pRedoDoc)
//STRIP001 		{
//STRIP001 			BOOL bColInfo = ( aBlockRange.aStart.Row()==0 && aBlockRange.aEnd.Row()==MAXROW );
//STRIP001 			BOOL bRowInfo = ( aBlockRange.aStart.Col()==0 && aBlockRange.aEnd.Col()==MAXCOL );
//STRIP001 			pRedoDoc = new ScDocument( SCDOCMODE_UNDO );
//STRIP001 			pRedoDoc->InitUndo( pDoc, aBlockRange.aStart.Tab(), aBlockRange.aStart.Tab(),
//STRIP001 								bColInfo, bRowInfo );
//STRIP001 		}
//STRIP001 		//	Redo-Daten beim ersten Undo aus dem Dokument lesen
//STRIP001 		pDoc->CopyToDocument( aBlockRange, nUndoFlags, FALSE, pRedoDoc );
//STRIP001 		bRedoFilled = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bHasLines = pDoc->HasAttrib( aBlockRange, HASATTR_PAINTEXT );
//STRIP001 
//STRIP001 	aMarkData.MarkToMulti();
//STRIP001 	pDoc->DeleteSelection( nUndoFlags, aMarkData );
//STRIP001 	aMarkData.MarkToSimple();
//STRIP001 
//STRIP001 	if ( !bUndo && pRedoDoc ) 		// Redo: UndoToDocument vorher
//STRIP001 		pRedoDoc->UndoToDocument( aBlockRange, nUndoFlags, FALSE, pDoc );
//STRIP001 
//STRIP001 	if (pWorkRefData)
//STRIP001 	{
//STRIP001 		pWorkRefData->DoUndo( pDoc, TRUE );		// TRUE = bSetChartRangeLists for SetChartListenerCollection
//STRIP001 		if ( pDoc->RefreshAutoFilter( 0,0, MAXCOL,MAXROW, aBlockRange.aStart.Tab() ) )
//STRIP001 			bPaintAll = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bCreateRedoData && pRefRedoData )
//STRIP001 		pRefRedoData->DeleteUnchanged( pDoc );
//STRIP001 
//STRIP001 	if (bUndo)		// Undo: UndoToDocument hinterher
//STRIP001 		pUndoDoc->UndoToDocument( aBlockRange, nUndoFlags, FALSE, pDoc );
//STRIP001 
//STRIP001 	if ( bUndo )
//STRIP001 	{
//STRIP001 		ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
//STRIP001 		if ( pChangeTrack )
//STRIP001 			pChangeTrack->Undo( nStartChangeAction, nEndChangeAction );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		SetChangeTrack();
//STRIP001 
//STRIP001 	ScRange aDrawRange( aBlockRange );
//STRIP001 	USHORT nPaint = PAINT_GRID;
//STRIP001 	USHORT nPaintExt = 0;
//STRIP001 	if (bPaintAll)
//STRIP001 	{
//STRIP001 		aDrawRange.aStart.SetCol(0);
//STRIP001 		aDrawRange.aStart.SetRow(0);
//STRIP001 		aDrawRange.aEnd.SetCol(MAXCOL);
//STRIP001 		aDrawRange.aEnd.SetRow(MAXROW);
//STRIP001 		nPaint |= PAINT_TOP | PAINT_LEFT;
//STRIP001 /*A*/	if (pViewShell)
//STRIP001 			pViewShell->AdjustBlockHeight(FALSE);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( aBlockRange.aStart.Row() == 0 && aBlockRange.aEnd.Row() == MAXROW )	// ganze Spalte
//STRIP001 		{
//STRIP001 			nPaint |= PAINT_TOP;
//STRIP001 			aDrawRange.aEnd.SetCol(MAXCOL);
//STRIP001 		}
//STRIP001 		if ( aBlockRange.aStart.Col() == 0 && aBlockRange.aEnd.Col() == MAXCOL )	// ganze Zeile
//STRIP001 		{
//STRIP001 			nPaint |= PAINT_LEFT;
//STRIP001 			aDrawRange.aEnd.SetRow(MAXROW);
//STRIP001 		}
//STRIP001 /*A*/	if ((pViewShell) && pViewShell->AdjustBlockHeight(FALSE))
//STRIP001 		{
//STRIP001 			aDrawRange.aStart.SetCol(0);
//STRIP001 			aDrawRange.aStart.SetRow(0);
//STRIP001 			aDrawRange.aEnd.SetCol(MAXCOL);
//STRIP001 			aDrawRange.aEnd.SetRow(MAXROW);
//STRIP001 			nPaint |= PAINT_LEFT;
//STRIP001 		}
//STRIP001 		bHasLines |= pDoc->HasAttrib( aDrawRange, HASATTR_PAINTEXT );
//STRIP001 		if (bHasLines) nPaintExt = SC_PF_LINES;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pDrawUndo && !bUndo )					//	draw redo after updating row heights
//STRIP001 		RedoSdrUndoAction( pDrawUndo );			//!	include in ScBlockUndo?
//STRIP001 
//STRIP001 	pDocShell->PostPaint( aDrawRange, nPaint, nPaintExt );
//STRIP001 
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->CellContentChanged();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoPaste::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 	DoChange( TRUE );
//STRIP001 	ShowTable( aBlockRange );
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoPaste::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	EnableDrawAdjust( pDoc, FALSE );				//! include in ScBlockUndo?
//STRIP001 	DoChange( FALSE );
//STRIP001 	EnableDrawAdjust( pDoc, TRUE );					//! include in ScBlockUndo?
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoPaste::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 	{
//STRIP001 		ScTabViewShell* pViewSh = ((ScTabViewTarget&)rTarget).GetViewShell();
//STRIP001 		ScTransferObj* pOwnClip = ScTransferObj::GetOwnClipboard( pViewSh->GetActiveWin() );
//STRIP001 		if (pOwnClip)
//STRIP001 			pViewSh->PasteFromClip( nFlags, pOwnClip->GetDocument(),
//STRIP001 									aPasteOptions.nFunction, aPasteOptions.bSkipEmpty, aPasteOptions.bTranspose,
//STRIP001 									aPasteOptions.bAsLink, aPasteOptions.eMoveMode, IDF_NONE,
//STRIP001 									TRUE );		// allow warning dialog
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoPaste::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Verschieben/Kopieren (Drag & Drop)
//

//STRIP001 ScUndoDragDrop::ScUndoDragDrop( ScDocShell* pNewDocShell,
//STRIP001 					const ScRange& rRange, ScAddress aNewDestPos, BOOL bNewCut,
//STRIP001 					ScDocument* pUndoDocument, ScRefUndoData* pRefData, BOOL bScenario ) :
//STRIP001 	ScMoveUndo( pNewDocShell, pUndoDocument, pRefData, SC_UNDO_REFFIRST ),
//STRIP001 	aSrcRange( rRange ),
//STRIP001 	bCut( bNewCut ),
//STRIP001 	bKeepScenarioFlags( bScenario )
//STRIP001 {
//STRIP001 	ScAddress aDestEnd(aNewDestPos);
//STRIP001 	aDestEnd.IncRow(aSrcRange.aEnd.Row() - aSrcRange.aStart.Row());
//STRIP001 	aDestEnd.IncCol(aSrcRange.aEnd.Col() - aSrcRange.aStart.Col());
//STRIP001 	aDestEnd.IncTab(aSrcRange.aEnd.Tab() - aSrcRange.aStart.Tab());
//STRIP001 
//STRIP001 	BOOL bIncludeFiltered = bCut;
//STRIP001 	if ( !bIncludeFiltered )
//STRIP001 	{
//STRIP001 		//	manually find number of non-filtered rows
//STRIP001 		USHORT nPastedCount = 0;
//STRIP001 		USHORT nTestEndRow = aSrcRange.aEnd.Row();
//STRIP001 		USHORT nFlagTab = aSrcRange.aStart.Tab();
//STRIP001 		ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 		for (USHORT nRow = aSrcRange.aStart.Row(); nRow <= nTestEndRow; nRow++)
//STRIP001 			if ( ( pDoc->GetRowFlags( nRow, nFlagTab ) & CR_FILTERED ) == 0 )
//STRIP001 				++nPastedCount;
//STRIP001 		if ( nPastedCount == 0 )
//STRIP001 			nPastedCount = 1;
//STRIP001 		aDestEnd.SetRow( aNewDestPos.Row() + nPastedCount - 1 );
//STRIP001 	}
//STRIP001 
//STRIP001 	aDestRange.aStart = aNewDestPos;
//STRIP001 	aDestRange.aEnd = aDestEnd;
//STRIP001 
//STRIP001 	SetChangeTrack();
//STRIP001 }

//STRIP001 __EXPORT ScUndoDragDrop::~ScUndoDragDrop()
//STRIP001 {
//STRIP001 }

//STRIP001 String __EXPORT ScUndoDragDrop::GetComment() const
//STRIP001 {	// "Verschieben" : "Kopieren"
//STRIP001 	return bCut ?
//STRIP001 		ScGlobal::GetRscString( STR_UNDO_MOVE ) :
//STRIP001 		ScGlobal::GetRscString( STR_UNDO_COPY );
//STRIP001 }

//STRIP001 void ScUndoDragDrop::SetChangeTrack()
//STRIP001 {
//STRIP001 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 	{
//STRIP001 		if ( bCut )
//STRIP001 		{
//STRIP001 			nStartChangeAction = pChangeTrack->GetActionMax() + 1;
//STRIP001 			pChangeTrack->AppendMove( aSrcRange, aDestRange, pRefUndoDoc );
//STRIP001 			nEndChangeAction = pChangeTrack->GetActionMax();
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pChangeTrack->AppendContentRange( aDestRange, pRefUndoDoc,
//STRIP001 				nStartChangeAction, nEndChangeAction );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nStartChangeAction = nEndChangeAction = 0;
//STRIP001 }

//STRIP001 void ScUndoDragDrop::PaintArea( ScRange aRange ) const
//STRIP001 {
//STRIP001 	USHORT nExtFlags = PAINT_GRID;
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		VirtualDevice aVirtDev;
//STRIP001 		ScViewData* pViewData = pViewShell->GetViewData();
//STRIP001 
//STRIP001 		if ( pDoc->SetOptimalHeight( aRange.aStart.Row(), aRange.aEnd.Row(),
//STRIP001 									 aRange.aStart.Tab(), 0, &aVirtDev,
//STRIP001 									 pViewData->GetPPTX(),  pViewData->GetPPTY(),
//STRIP001 									 pViewData->GetZoomX(), pViewData->GetZoomY(),
//STRIP001 									 FALSE ) )
//STRIP001 		{
//STRIP001 			aRange.aStart.SetCol(0);
//STRIP001 			aRange.aEnd.SetCol(MAXCOL);
//STRIP001 			aRange.aEnd.SetRow(MAXROW);
//STRIP001 			nExtFlags |= PAINT_LEFT;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bKeepScenarioFlags )
//STRIP001 	{
//STRIP001 		//	Szenarien mitkopiert -> auch Szenario-Rahmen painten
//STRIP001 		aRange.aStart.SetCol(0);
//STRIP001 		aRange.aStart.SetRow(0);
//STRIP001 		aRange.aEnd.SetCol(MAXCOL);
//STRIP001 		aRange.aEnd.SetRow(MAXROW);
//STRIP001 	}
//STRIP001 
//STRIP001 	//	column/row info (width/height) included if whole columns/rows were copied
//STRIP001 	if ( aSrcRange.aStart.Col() == 0 && aSrcRange.aEnd.Col() == MAXCOL )
//STRIP001 	{
//STRIP001 		nExtFlags |= PAINT_LEFT;
//STRIP001 		aRange.aEnd.SetRow(MAXROW);
//STRIP001 	}
//STRIP001 	if ( aSrcRange.aStart.Row() == 0 && aSrcRange.aEnd.Row() == MAXROW )
//STRIP001 	{
//STRIP001 		nExtFlags |= PAINT_TOP;
//STRIP001 		aRange.aEnd.SetCol(MAXCOL);
//STRIP001 	}
//STRIP001 
//STRIP001 	pDocShell->PostPaint( aRange, nExtFlags );
//STRIP001 }


//STRIP001 void ScUndoDragDrop::DoUndo( ScRange aRange ) const
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 		pChangeTrack->Undo( nStartChangeAction, nEndChangeAction );
//STRIP001 
//STRIP001 //?	DB-Areas vor Daten, damit bei ExtendMerge die Autofilter-Knoepfe stimmen
//STRIP001 
//STRIP001 	ScRange aPaintRange = aRange;
//STRIP001 	pDoc->ExtendMerge( aPaintRange );			// vor dem Loeschen
//STRIP001 
//STRIP001 	pDoc->DeleteAreaTab( aRange, IDF_ALL );
//STRIP001 	pRefUndoDoc->CopyToDocument( aRange, IDF_ALL, FALSE, pDoc );
//STRIP001 	if ( pDoc->HasAttrib( aRange, HASATTR_MERGED ) )
//STRIP001 		pDoc->ExtendMerge( aRange, TRUE );
//STRIP001 
//STRIP001 	aPaintRange.aEnd.SetCol( Max( aPaintRange.aEnd.Col(), aRange.aEnd.Col() ) );
//STRIP001 	aPaintRange.aEnd.SetRow( Max( aPaintRange.aEnd.Row(), aRange.aEnd.Row() ) );
//STRIP001 	PaintArea( aPaintRange );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDragDrop::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 	DoUndo(aDestRange);
//STRIP001 	if (bCut)
//STRIP001 		DoUndo(aSrcRange);
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDragDrop::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScDocument* pClipDoc = new ScDocument( SCDOCMODE_CLIP );
//STRIP001 
//STRIP001 	EnableDrawAdjust( pDoc, FALSE );				//! include in ScBlockUndo?
//STRIP001 
//STRIP001 	USHORT nTab;
//STRIP001 	ScMarkData aSourceMark;
//STRIP001 	for (nTab=aSrcRange.aStart.Tab(); nTab<=aSrcRange.aEnd.Tab(); nTab++)
//STRIP001 		aSourceMark.SelectTable( nTab, TRUE );
//STRIP001 	pDoc->CopyToClip( aSrcRange.aStart.Col(), aSrcRange.aStart.Row(),
//STRIP001 					  aSrcRange.aEnd.Col(),   aSrcRange.aEnd.Row(),
//STRIP001 					  bCut, pClipDoc, FALSE, &aSourceMark, bKeepScenarioFlags );
//STRIP001 
//STRIP001 	if (bCut)
//STRIP001 	{
//STRIP001 		ScRange aSrcPaintRange = aSrcRange;
//STRIP001 		pDoc->ExtendMerge( aSrcPaintRange );			// vor dem Loeschen
//STRIP001 		pDoc->DeleteAreaTab( aSrcRange, IDF_ALL );
//STRIP001 		PaintArea( aSrcPaintRange );
//STRIP001 	}
//STRIP001 
//STRIP001 	ScMarkData aDestMark;
//STRIP001 	for (nTab=aDestRange.aStart.Tab(); nTab<=aDestRange.aEnd.Tab(); nTab++)
//STRIP001 		aDestMark.SelectTable( nTab, TRUE );
//STRIP001 
//STRIP001 	BOOL bIncludeFiltered = bCut;
//STRIP001 	pDoc->CopyFromClip( aDestRange, aDestMark, IDF_ALL & ~IDF_OBJECTS, NULL, pClipDoc, TRUE, FALSE, bIncludeFiltered );
//STRIP001 
//STRIP001 	// skipped rows and merged cells don't mix
//STRIP001 	if ( !bIncludeFiltered && pClipDoc->HasClipFilteredRows() )
//STRIP001 		pDocShell->GetDocFunc().UnmergeCells( aDestRange, FALSE, TRUE );
//STRIP001 
//STRIP001 	for (nTab=aDestRange.aStart.Tab(); nTab<=aDestRange.aEnd.Tab(); nTab++)
//STRIP001 	{
//STRIP001 		USHORT nEndCol = aDestRange.aEnd.Col();
//STRIP001 		USHORT nEndRow = aDestRange.aEnd.Row();
//STRIP001 		pDoc->ExtendMerge( aDestRange.aStart.Col(), aDestRange.aStart.Row(),
//STRIP001 							nEndCol, nEndRow, nTab, TRUE );
//STRIP001 		PaintArea( ScRange( aDestRange.aStart.Col(), aDestRange.aStart.Row(), nTab,
//STRIP001 							nEndCol, nEndRow, nTab ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	SetChangeTrack();
//STRIP001 
//STRIP001 	delete pClipDoc;
//STRIP001 	ShowTable( aDestRange.aStart.Tab() );
//STRIP001 
//STRIP001 	if ( pDrawUndo )
//STRIP001 		RedoSdrUndoAction( pDrawUndo );			//!	include in ScBlockUndo?
//STRIP001 	EnableDrawAdjust( pDoc, TRUE );				//! include in ScBlockUndo?
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDragDrop::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoDragDrop::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;			// geht nicht
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Liste der Bereichsnamen einfuegen
//		(Einfuegen|Name|Einfuegen =>[Liste])
//

//STRIP001 ScUndoListNames::ScUndoListNames( ScDocShell* pNewDocShell, const ScRange& rRange,
//STRIP001 				ScDocument* pNewUndoDoc, ScDocument* pNewRedoDoc ) :
//STRIP001 	ScBlockUndo( pNewDocShell, rRange, SC_UNDO_AUTOHEIGHT ),
//STRIP001 	pUndoDoc( pNewUndoDoc ),
//STRIP001 	pRedoDoc( pNewRedoDoc )
//STRIP001 {
//STRIP001 }

//STRIP001 __EXPORT ScUndoListNames::~ScUndoListNames()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 	delete pRedoDoc;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoListNames::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_LISTNAMES );
//STRIP001 }

//STRIP001 void ScUndoListNames::DoChange( ScDocument* pSrcDoc ) const
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	pDoc->DeleteAreaTab( aBlockRange, IDF_ALL );
//STRIP001 	pSrcDoc->CopyToDocument( aBlockRange, IDF_ALL, FALSE, pDoc );
//STRIP001 	pDocShell->PostPaint( aBlockRange, PAINT_GRID );
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->CellContentChanged();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoListNames::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 	DoChange(pUndoDoc);
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoListNames::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 	DoChange(pRedoDoc);
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoListNames::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->InsertNameList();
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoListNames::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Szenario anwenden
//		(Extras|Szenarien)
//

//STRIP001 ScUndoUseScenario::ScUndoUseScenario( ScDocShell* pNewDocShell,
//STRIP001 						const ScMarkData& rMark,
//STRIP001 /*C*/					const ScArea& rDestArea,
//STRIP001 							  ScDocument* pNewUndoDoc,
//STRIP001 						const String& rNewName ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	pUndoDoc( pNewUndoDoc ),
//STRIP001 	aMarkData( rMark ),
//STRIP001 	aName( rNewName )
//STRIP001 {
//STRIP001 	aRange.aStart.SetCol(rDestArea.nColStart);
//STRIP001 	aRange.aStart.SetRow(rDestArea.nRowStart);
//STRIP001 	aRange.aStart.SetTab(rDestArea.nTab);
//STRIP001 	aRange.aEnd.SetCol(rDestArea.nColEnd);
//STRIP001 	aRange.aEnd.SetRow(rDestArea.nRowEnd);
//STRIP001 	aRange.aEnd.SetTab(rDestArea.nTab);
//STRIP001 }

//STRIP001 __EXPORT ScUndoUseScenario::~ScUndoUseScenario()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoUseScenario::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_USESCENARIO );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoUseScenario::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		pViewShell->DoneBlockMode();
//STRIP001 		pViewShell->InitOwnBlockMode();
//STRIP001 	}
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	pDoc->DeleteSelection( IDF_ALL, aMarkData );
//STRIP001 	pUndoDoc->CopyToDocument( aRange, IDF_ALL, TRUE, pDoc, &aMarkData );
//STRIP001 
//STRIP001 	//	Szenario-Tabellen
//STRIP001 	BOOL bFrame = FALSE;
//STRIP001 	USHORT nTab = aRange.aStart.Tab();
//STRIP001 	USHORT nEndTab = nTab;
//STRIP001 	while ( pUndoDoc->HasTable(nEndTab+1) && pUndoDoc->IsScenario(nEndTab+1) )
//STRIP001 		++nEndTab;
//STRIP001 	for (USHORT i = nTab+1; i<=nEndTab; i++)
//STRIP001 	{
//STRIP001 		//	Flags immer
//STRIP001 		String aComment;
//STRIP001 		Color  aColor;
//STRIP001 		USHORT nScenFlags;
//STRIP001 		pUndoDoc->GetScenarioData( i, aComment, aColor, nScenFlags );
//STRIP001 		pDoc->SetScenarioData( i, aComment, aColor, nScenFlags );
//STRIP001 		BOOL bActive = pUndoDoc->IsActiveScenario( i );
//STRIP001 		pDoc->SetActiveScenario( i, bActive );
//STRIP001 		//	Bei Zurueckkopier-Szenarios auch Inhalte
//STRIP001 		if ( nScenFlags & SC_SCENARIO_TWOWAY )
//STRIP001 		{
//STRIP001 			pDoc->DeleteAreaTab( 0,0, MAXCOL,MAXROW, i, IDF_ALL );
//STRIP001 			pUndoDoc->CopyToDocument( 0,0,i, MAXCOL,MAXROW,i, IDF_ALL,FALSE, pDoc );
//STRIP001 		}
//STRIP001 		if ( nScenFlags & SC_SCENARIO_SHOWFRAME )
//STRIP001 			bFrame = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Wenn sichtbare Rahmen, dann alles painten
//STRIP001 	if (bFrame)
//STRIP001 		pDocShell->PostPaint( 0,0,nTab, MAXCOL,MAXROW,nTab, PAINT_GRID | PAINT_EXTRAS );
//STRIP001 	else
//STRIP001 		pDocShell->PostPaint( aRange, PAINT_GRID | PAINT_EXTRAS );
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->CellContentChanged();
//STRIP001 
//STRIP001 	ShowTable( aRange.aStart.Tab() );
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoUseScenario::Redo()
//STRIP001 {
//STRIP001 	USHORT nTab = aRange.aStart.Tab();
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 		pViewShell->DoneBlockMode();
//STRIP001 		pViewShell->InitOwnBlockMode();
//STRIP001 	}
//STRIP001 
//STRIP001 	pDocShell->UseScenario( nTab, aName, FALSE );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoUseScenario::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 	{
//STRIP001 		String aTemp = aName;
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->UseScenario(aTemp);
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoUseScenario::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 	{
//STRIP001 		ScViewData* pViewData = ((ScTabViewTarget&)rTarget).GetViewShell()->GetViewData();
//STRIP001 		return !pViewData->GetDocument()->IsScenario( pViewData->GetTabNo() );
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Vorlage anwenden
//		(Format|Vorlagenkatalog)
//

/*N*/ ScUndoSelectionStyle::ScUndoSelectionStyle( ScDocShell* pNewDocShell,
/*N*/ 									  const ScMarkData& rMark,
/*N*/ 									  const ScRange& rRange,
/*N*/ 									  const String& rName,
/*N*/ 											ScDocument* pNewUndoDoc ) :
/*N*/ 	ScSimpleUndo( pNewDocShell ),
/*N*/ 	aMarkData( rMark ),
/*N*/ 	aRange( rRange ),
/*N*/ 	aStyleName( rName ),
/*N*/ 	pUndoDoc( pNewUndoDoc )
/*N*/ {
/*N*/ 	aMarkData.MarkToMulti();
/*N*/ }

/*N*/ __EXPORT ScUndoSelectionStyle::~ScUndoSelectionStyle()
/*N*/ {
/*N*/ 	delete pUndoDoc;
/*N*/ }

/*N*/ String __EXPORT ScUndoSelectionStyle::GetComment() const
/*N*/ {
/*N*/ 	return ScGlobal::GetRscString( STR_UNDO_APPLYCELLSTYLE );
/*N*/ }

//STRIP001 void ScUndoSelectionStyle::DoChange( const BOOL bUndo )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		pViewShell->DoneBlockMode();
//STRIP001 		pViewShell->InitOwnBlockMode();
//STRIP001 		pViewShell->GetViewData()->GetMarkData() = aMarkData;	// CopyMarksTo
//STRIP001 	}
//STRIP001 
//STRIP001 	ScRange aWorkRange( aRange );
//STRIP001 	if ( pDoc->HasAttrib( aWorkRange, HASATTR_MERGED ) )		// zusammengefasste Zellen?
//STRIP001 		pDoc->ExtendMerge( aWorkRange, TRUE );
//STRIP001 
//STRIP001 	BOOL bHasLines = pDoc->HasAttrib( aWorkRange, HASATTR_PAINTEXT );
//STRIP001 
//STRIP001 	if (bUndo)		// bei Undo alte Daten wieder reinschubsen
//STRIP001 	{
//STRIP001 		USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 		ScRange aCopyRange = aWorkRange;
//STRIP001 		aCopyRange.aStart.SetTab(0);
//STRIP001 		aCopyRange.aEnd.SetTab(nTabCount-1);
//STRIP001 		pUndoDoc->CopyToDocument( aCopyRange, IDF_ATTRIB, TRUE, pDoc, &aMarkData );
//STRIP001 	}
//STRIP001 	else			// bei Redo Style wieder zuweisen
//STRIP001 	{
//STRIP001 		ScStyleSheetPool* pStlPool = pDoc->GetStyleSheetPool();
//STRIP001 		ScStyleSheet* pStyleSheet =
//STRIP001 			(ScStyleSheet*) pStlPool->Find( aStyleName, SFX_STYLE_FAMILY_PARA );
//STRIP001 		if (!pStyleSheet)
//STRIP001 		{
//STRIP001 			DBG_ERROR("StyleSheet not found");
//STRIP001 			return;
//STRIP001 		}
//STRIP001 		pDoc->ApplySelectionStyle( *pStyleSheet, aMarkData );
//STRIP001 	}
//STRIP001 
//STRIP001 	bHasLines = bHasLines || pDoc->HasAttrib( aWorkRange, HASATTR_PAINTEXT );
//STRIP001 
//STRIP001 	if ( !( (pViewShell) && pViewShell->AdjustBlockHeight() ) )
//STRIP001 /*A*/	pDocShell->PostPaint( aWorkRange, PAINT_GRID | PAINT_EXTRAS, (bHasLines ? SC_PF_LINES : 0) );
//STRIP001 
//STRIP001 	ShowTable( aWorkRange.aStart.Tab() );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoSelectionStyle::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 	DoChange( TRUE );
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoSelectionStyle::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 	DoChange( FALSE );
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoSelectionStyle::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 	{
//STRIP001 		ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 		ScStyleSheetPool* pStlPool = pDoc->GetStyleSheetPool();
//STRIP001 		ScStyleSheet* pStyleSheet = (ScStyleSheet*) pStlPool->
//STRIP001 											Find( aStyleName, SFX_STYLE_FAMILY_PARA );
//STRIP001 		if (!pStyleSheet)
//STRIP001 		{
//STRIP001 			DBG_ERROR("StyleSheet not found");
//STRIP001 			return;
//STRIP001 		}
//STRIP001 
//STRIP001 		ScTabViewShell& rViewShell = *((ScTabViewTarget&)rTarget).GetViewShell();
//STRIP001 		rViewShell.SetStyleSheetToMarked( pStyleSheet, TRUE );
//STRIP001 	}
//STRIP001 }

/*N*/ BOOL __EXPORT ScUndoSelectionStyle::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return (rTarget.ISA(ScTabViewTarget));
/*N*/ }

//STRIP001 USHORT __EXPORT ScUndoSelectionStyle::GetId() const
//STRIP001 {
//STRIP001 	return STR_UNDO_APPLYCELLSTYLE;
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Matrix-Formel eingeben
//

/*N*/ ScUndoEnterMatrix::ScUndoEnterMatrix( ScDocShell* pNewDocShell, const ScRange& rArea,
/*N*/ 									  ScDocument* pNewUndoDoc, const String& rForm ) :
/*N*/ 	ScBlockUndo( pNewDocShell, rArea, SC_UNDO_SIMPLE ),
/*N*/ 	pUndoDoc( pNewUndoDoc ),
/*N*/ 	aFormula( rForm )
/*N*/ {
/*N*/ 	SetChangeTrack();
/*N*/ }

/*N*/ __EXPORT ScUndoEnterMatrix::~ScUndoEnterMatrix()
/*N*/ {
/*N*/ 	delete pUndoDoc;
/*N*/ }

/*N*/ String __EXPORT ScUndoEnterMatrix::GetComment() const
/*N*/ {
/*N*/ 	return ScGlobal::GetRscString( STR_UNDO_ENTERMATRIX );
/*N*/ }

/*N*/ void ScUndoEnterMatrix::SetChangeTrack()
/*N*/ {
/*N*/ 	ScDocument* pDoc = pDocShell->GetDocument();
/*N*/ 	ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
/*N*/ 	if ( pChangeTrack )
/*?*/ 	{	DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 pChangeTrack->AppendContentRange( aBlockRange, pUndoDoc,
//STRIP001 /*?*/ 			nStartChangeAction, nEndChangeAction );
/*N*/ 	else
/*N*/ 		nStartChangeAction = nEndChangeAction = 0;
/*N*/ }

//STRIP001 void __EXPORT ScUndoEnterMatrix::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	pDoc->DeleteAreaTab( aBlockRange, IDF_ALL );
//STRIP001 	pUndoDoc->CopyToDocument( aBlockRange, IDF_ALL, FALSE, pDoc );
//STRIP001 	pDocShell->PostPaint( aBlockRange, PAINT_GRID );
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->CellContentChanged();
//STRIP001 
//STRIP001 	ScChangeTrack* pChangeTrack = pDoc->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 		pChangeTrack->Undo( nStartChangeAction, nEndChangeAction );
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoEnterMatrix::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	ScMarkData aDestMark;
//STRIP001 	aDestMark.SelectOneTable( aBlockRange.aStart.Tab() );
//STRIP001 	aDestMark.SetMarkArea( aBlockRange );
//STRIP001 
//STRIP001 	pDoc->InsertMatrixFormula( aBlockRange.aStart.Col(), aBlockRange.aStart.Row(),
//STRIP001 							   aBlockRange.aEnd.Col(),   aBlockRange.aEnd.Row(),
//STRIP001 							   aDestMark, aFormula );
//STRIP001 //	pDocShell->PostPaint( aBlockRange, PAINT_GRID );	// nicht noetig ???
//STRIP001 
//STRIP001 	SetChangeTrack();
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoEnterMatrix::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 	{
//STRIP001 		String aTemp = aFormula;
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->EnterMatrix(aTemp);
//STRIP001 	}
//STRIP001 }

/*N*/ BOOL __EXPORT ScUndoEnterMatrix::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return (rTarget.ISA(ScTabViewTarget));
/*N*/ }

// -----------------------------------------------------------------------
//
//		Einzug vermindern / erhoehen
//

//STRIP001 ScRange lcl_GetMultiMarkRange( const ScMarkData& rMark )
//STRIP001 {
//STRIP001 	DBG_ASSERT( rMark.IsMultiMarked(), "wrong mark type" );
//STRIP001 
//STRIP001 	ScRange aRange;
//STRIP001 	rMark.GetMultiMarkArea( aRange );
//STRIP001 	return aRange;
//STRIP001 }

//STRIP001 ScUndoIndent::ScUndoIndent( ScDocShell* pNewDocShell, const ScMarkData& rMark,
//STRIP001 							ScDocument* pNewUndoDoc, BOOL bIncrement ) :
//STRIP001 	ScBlockUndo( pNewDocShell, lcl_GetMultiMarkRange(rMark), SC_UNDO_AUTOHEIGHT ),
//STRIP001 	aMarkData( rMark ),
//STRIP001 	pUndoDoc( pNewUndoDoc ),
//STRIP001 	bIsIncrement( bIncrement )
//STRIP001 {
//STRIP001 }

//STRIP001 __EXPORT ScUndoIndent::~ScUndoIndent()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoIndent::GetComment() const
//STRIP001 {
//STRIP001 	USHORT nId = bIsIncrement ? STR_UNDO_INC_INDENT : STR_UNDO_DEC_INDENT;
//STRIP001 	return ScGlobal::GetRscString( nId );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoIndent::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 	ScRange aCopyRange = aBlockRange;
//STRIP001 	aCopyRange.aStart.SetTab(0);
//STRIP001 	aCopyRange.aEnd.SetTab(nTabCount-1);
//STRIP001 	pUndoDoc->CopyToDocument( aCopyRange, IDF_ATTRIB, TRUE, pDoc, &aMarkData );
//STRIP001 	pDocShell->PostPaint( aBlockRange, PAINT_GRID, SC_PF_LINES | SC_PF_TESTMERGE );
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoIndent::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	pDoc->ChangeSelectionIndent( bIsIncrement, aMarkData );
//STRIP001 	pDocShell->PostPaint( aBlockRange, PAINT_GRID, SC_PF_LINES | SC_PF_TESTMERGE );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoIndent::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->ChangeIndent( bIsIncrement );
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoIndent::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }

// -----------------------------------------------------------------------
//
//		Transliteration for cells
//

//STRIP001 ScUndoTransliterate::ScUndoTransliterate( ScDocShell* pNewDocShell, const ScMarkData& rMark,
//STRIP001 							ScDocument* pNewUndoDoc, sal_Int32 nType ) :
//STRIP001 	ScBlockUndo( pNewDocShell, lcl_GetMultiMarkRange(rMark), SC_UNDO_AUTOHEIGHT ),
//STRIP001 	aMarkData( rMark ),
//STRIP001 	pUndoDoc( pNewUndoDoc ),
//STRIP001 	nTransliterationType( nType )
//STRIP001 {
//STRIP001 }

//STRIP001 __EXPORT ScUndoTransliterate::~ScUndoTransliterate()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoTransliterate::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_TRANSLITERATE );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoTransliterate::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 	ScRange aCopyRange = aBlockRange;
//STRIP001 	aCopyRange.aStart.SetTab(0);
//STRIP001 	aCopyRange.aEnd.SetTab(nTabCount-1);
//STRIP001 	pUndoDoc->CopyToDocument( aCopyRange, IDF_CONTENTS, TRUE, pDoc, &aMarkData );
//STRIP001 	pDocShell->PostPaint( aBlockRange, PAINT_GRID, SC_PF_LINES | SC_PF_TESTMERGE );
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoTransliterate::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	pDoc->TransliterateText( aMarkData, nTransliterationType );
//STRIP001 	pDocShell->PostPaint( aBlockRange, PAINT_GRID, SC_PF_LINES | SC_PF_TESTMERGE );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoTransliterate::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->TransliterateText( nTransliterationType );
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoTransliterate::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }

// -----------------------------------------------------------------------
//
//		einzelne Items per Which-IDs aus Bereich loeschen
//

//STRIP001 ScUndoClearItems::ScUndoClearItems( ScDocShell* pNewDocShell, const ScMarkData& rMark,
//STRIP001 							ScDocument* pNewUndoDoc, const USHORT* pW ) :
//STRIP001 	ScBlockUndo( pNewDocShell, lcl_GetMultiMarkRange(rMark), SC_UNDO_AUTOHEIGHT ),
//STRIP001 	aMarkData( rMark ),
//STRIP001 	pUndoDoc( pNewUndoDoc ),
//STRIP001 	pWhich( NULL )
//STRIP001 {
//STRIP001 	DBG_ASSERT( pW, "ScUndoClearItems: Which-Pointer ist 0" );
//STRIP001 
//STRIP001 	USHORT nCount = 0;
//STRIP001 	while ( pW[nCount] )
//STRIP001 		++nCount;
//STRIP001 	pWhich = new USHORT[nCount+1];
//STRIP001 	for (USHORT i=0; i<=nCount; i++)
//STRIP001 		pWhich[i] = pW[i];
//STRIP001 }

//STRIP001 __EXPORT ScUndoClearItems::~ScUndoClearItems()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 	delete pWhich;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoClearItems::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_DELETECONTENTS );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoClearItems::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	pUndoDoc->CopyToDocument( aBlockRange, IDF_ATTRIB, TRUE, pDoc, &aMarkData );
//STRIP001 	pDocShell->PostPaint( aBlockRange, PAINT_GRID, SC_PF_LINES | SC_PF_TESTMERGE );
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoClearItems::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	pDoc->ClearSelectionItems( pWhich, aMarkData );
//STRIP001 	pDocShell->PostPaint( aBlockRange, PAINT_GRID, SC_PF_LINES | SC_PF_TESTMERGE );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoClearItems::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 	{
//STRIP001 		ScViewData* pViewData = ((ScTabViewTarget&)rTarget).GetViewShell()->GetViewData();
//STRIP001 		ScDocFunc aFunc(*pViewData->GetDocShell());
//STRIP001 		aFunc.ClearItems( pViewData->GetMarkData(), pWhich, FALSE );
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoClearItems::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }

// -----------------------------------------------------------------------
//
//		Alle Umbrueche einer Tabelle loeschen
//

/*N*/ ScUndoRemoveBreaks::ScUndoRemoveBreaks( ScDocShell* pNewDocShell,
/*N*/ 									USHORT nNewTab, ScDocument* pNewUndoDoc ) :
/*N*/ 	ScSimpleUndo( pNewDocShell ),
/*N*/ 	nTab( nNewTab ),
/*N*/ 	pUndoDoc( pNewUndoDoc )
/*N*/ {
/*N*/ }

/*N*/ __EXPORT ScUndoRemoveBreaks::~ScUndoRemoveBreaks()
/*N*/ {
/*N*/ 	delete pUndoDoc;
/*N*/ }

//STRIP001 String __EXPORT ScUndoRemoveBreaks::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_REMOVEBREAKS );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRemoveBreaks::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	pUndoDoc->CopyToDocument( 0,0,nTab, MAXCOL,MAXROW,nTab, IDF_NONE, FALSE, pDoc );
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->UpdatePageBreakData( TRUE );
//STRIP001 	pDocShell->PostPaint( 0,0,nTab, MAXCOL,MAXROW,nTab, PAINT_GRID );
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRemoveBreaks::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	pDoc->RemoveManualBreaks(nTab);
//STRIP001 	pDoc->UpdatePageBreaks(nTab);
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->UpdatePageBreakData( TRUE );
//STRIP001 	pDocShell->PostPaint( 0,0,nTab, MAXCOL,MAXROW,nTab, PAINT_GRID );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRemoveBreaks::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 	{
//STRIP001 		ScTabViewShell& rViewShell = *((ScTabViewTarget&)rTarget).GetViewShell();
//STRIP001 		rViewShell.RemoveManualBreaks();
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoRemoveBreaks::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }

// -----------------------------------------------------------------------
//
//		Zusammenfassung aufheben (fuer einen ganzen Bereich)
//

//STRIP001 ScUndoRemoveMerge::ScUndoRemoveMerge( ScDocShell* pNewDocShell,
//STRIP001 									   const ScRange& rArea, ScDocument* pNewUndoDoc ) :
//STRIP001 	ScBlockUndo( pNewDocShell, rArea, SC_UNDO_SIMPLE ),
//STRIP001 	pUndoDoc( pNewUndoDoc )
//STRIP001 {
//STRIP001 }

//STRIP001 __EXPORT ScUndoRemoveMerge::~ScUndoRemoveMerge()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoRemoveMerge::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_REMERGE );	// "Zusammenfassung aufheben"
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRemoveMerge::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	ScRange aExtended = aBlockRange;
//STRIP001 	pUndoDoc->ExtendMerge( aExtended );
//STRIP001 
//STRIP001 	pDoc->DeleteAreaTab( aExtended, IDF_ATTRIB );
//STRIP001 	pUndoDoc->CopyToDocument( aExtended, IDF_ATTRIB, FALSE, pDoc );
//STRIP001 
//STRIP001 	BOOL bDidPaint = FALSE;
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if ( pViewShell )
//STRIP001 	{
//STRIP001 		pViewShell->SetTabNo( aExtended.aStart.Tab() );
//STRIP001 		bDidPaint = pViewShell->AdjustRowHeight( aExtended.aStart.Row(), aExtended.aEnd.Row() );
//STRIP001 	}
//STRIP001 	if (!bDidPaint)
//STRIP001 		ScUndoUtil::PaintMore( pDocShell, aExtended );
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRemoveMerge::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	USHORT nTab = aBlockRange.aStart.Tab();
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScRange aExtended = aBlockRange;
//STRIP001 	pDoc->ExtendMerge( aExtended );
//STRIP001 	ScRange aRefresh = aExtended;
//STRIP001 	pDoc->ExtendOverlapped( aRefresh );
//STRIP001 
//STRIP001 	//	ausfuehren
//STRIP001 
//STRIP001 	const SfxPoolItem& rDefAttr = pDoc->GetPool()->GetDefaultItem( ATTR_MERGE );
//STRIP001 	ScPatternAttr aPattern( pDoc->GetPool() );
//STRIP001 	aPattern.GetItemSet().Put( rDefAttr );
//STRIP001 	pDoc->ApplyPatternAreaTab( aBlockRange.aStart.Col(), aBlockRange.aStart.Row(),
//STRIP001 								aBlockRange.aEnd.Col(), aBlockRange.aEnd.Row(), nTab,
//STRIP001 								aPattern );
//STRIP001 
//STRIP001 	pDoc->RemoveFlagsTab( aExtended.aStart.Col(), aExtended.aStart.Row(),
//STRIP001 							aExtended.aEnd.Col(), aExtended.aEnd.Row(), nTab,
//STRIP001 							SC_MF_HOR | SC_MF_VER );
//STRIP001 
//STRIP001 	pDoc->ExtendMerge( aRefresh, TRUE, FALSE );
//STRIP001 
//STRIP001 	//	Paint
//STRIP001 
//STRIP001 	BOOL bDidPaint = FALSE;
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if ( pViewShell )
//STRIP001 	{
//STRIP001 		pViewShell->SetTabNo( aExtended.aStart.Tab() );
//STRIP001 		bDidPaint = pViewShell->AdjustRowHeight( aExtended.aStart.Row(), aExtended.aEnd.Row() );
//STRIP001 	}
//STRIP001 	if (!bDidPaint)
//STRIP001 		ScUndoUtil::PaintMore( pDocShell, aExtended );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRemoveMerge::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->RemoveMerge();
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoRemoveMerge::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }

// -----------------------------------------------------------------------
//
//		nur Umrandung setzen, per ScRangeList (StarOne)
//

/*N*/ ScRange lcl_TotalRange( const ScRangeList& rRanges )
/*N*/ {
/*N*/ 	ScRange aTotal;
/*N*/ 	ULONG nCount = rRanges.Count();
/*N*/ 	for (ULONG i=0; i<nCount; i++)
/*N*/ 	{
/*N*/ 		ScRange aRange = *rRanges.GetObject(i);
/*N*/ 		if (i==0)
/*N*/ 			aTotal = aRange;
/*N*/ 		else
/*N*/ 		{
/*N*/ 			if (aRange.aStart.Col() < aTotal.aStart.Col())
/*N*/ 				aTotal.aStart.SetCol(aRange.aStart.Col());
/*N*/ 			if (aRange.aStart.Row() < aTotal.aStart.Row())
/*N*/ 				aTotal.aStart.SetRow(aRange.aStart.Row());
/*N*/ 			if (aRange.aStart.Tab() < aTotal.aStart.Tab())
/*N*/ 				aTotal.aStart.SetTab(aRange.aStart.Tab());
/*N*/ 			if (aRange.aEnd.Col() > aTotal.aEnd.Col())
/*N*/ 				aTotal.aEnd.SetCol(aRange.aEnd.Col());
/*N*/ 			if (aRange.aEnd.Row() > aTotal.aEnd.Row())
/*N*/ 				aTotal.aEnd.SetRow(aRange.aEnd.Row());
/*N*/ 			if (aRange.aEnd.Tab() > aTotal.aEnd.Tab())
/*N*/ 				aTotal.aEnd.SetTab(aRange.aEnd.Tab());
/*N*/ 		}
/*N*/ 	}
/*N*/ 	return aTotal;
/*N*/ }

/*N*/ ScUndoBorder::ScUndoBorder( ScDocShell* pNewDocShell,
/*N*/ 							const ScRangeList& rRangeList, ScDocument* pNewUndoDoc,
/*N*/ 							const SvxBoxItem& rNewOuter, const SvxBoxInfoItem& rNewInner ) :
/*N*/ 	ScBlockUndo( pNewDocShell, lcl_TotalRange(rRangeList), SC_UNDO_SIMPLE ),
/*N*/ 	pUndoDoc( pNewUndoDoc )
/*N*/ {
/*N*/ 	pRanges = new ScRangeList(rRangeList);
/*N*/ 	pOuter = new SvxBoxItem(rNewOuter);
/*N*/ 	pInner = new SvxBoxInfoItem(rNewInner);
/*N*/ }

/*N*/ __EXPORT ScUndoBorder::~ScUndoBorder()
/*N*/ {
/*N*/ 	delete pUndoDoc;
/*N*/ 	delete pRanges;
/*N*/ 	delete pOuter;
/*N*/ 	delete pInner;
/*N*/ }

//STRIP001 String __EXPORT ScUndoBorder::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_SELATTRLINES );		//! eigener String?
//STRIP001 }

//STRIP001 void __EXPORT ScUndoBorder::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScMarkData aMarkData;
//STRIP001 	aMarkData.MarkFromRangeList( *pRanges, FALSE );
//STRIP001 	pUndoDoc->CopyToDocument( aBlockRange, IDF_ATTRIB, TRUE, pDoc, &aMarkData );
//STRIP001 	pDocShell->PostPaint( aBlockRange, PAINT_GRID, SC_PF_LINES | SC_PF_TESTMERGE );
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoBorder::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();		//! Funktion an docfunc aufrufen
//STRIP001 	ULONG nCount = pRanges->Count();
//STRIP001 	ULONG i;
//STRIP001 	for (i=0; i<nCount; i++)
//STRIP001 	{
//STRIP001 		ScRange aRange = *pRanges->GetObject(i);
//STRIP001 		USHORT nTab = aRange.aStart.Tab();
//STRIP001 
//STRIP001 		ScMarkData aMark;
//STRIP001 		aMark.SetMarkArea( aRange );
//STRIP001 		aMark.SelectTable( nTab, TRUE );
//STRIP001 
//STRIP001 		pDoc->ApplySelectionFrame( aMark, pOuter, pInner );
//STRIP001 	}
//STRIP001 	for (i=0; i<nCount; i++)
//STRIP001 		pDocShell->PostPaint( *pRanges->GetObject(i), PAINT_GRID, SC_PF_LINES | SC_PF_TESTMERGE );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoBorder::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	//!	spaeter (wenn die Funktion aus cellsuno nach docfunc gewandert ist)
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoBorder::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;	// s.o.
//STRIP001 }




}
