#*************************************************************************
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.14 $
#
#   last change: $Author: hr $ $Date: 2005/12/28 18:00:28 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************

PRJ=..$/..
PRJNAME=sdk_oo
TARGET=copying

#----------------------------------------------------------------
.INCLUDE: settings.mk
.INCLUDE: $(PRJ)$/util$/makefile.pmk
#----------------------------------------------------------------

IDL_DOCU_INDEX_FILE = $(DESTDIRGENIDLREF)$/module-ix.html
IDL_DOCU_CLEANUP_FLAG = $(MISC)$/idl_docu_cleanup.flag

IDL_CHAPTER_REFS=idl_chapter_refs.txt

DOCUHTMLFILES= \
    $(DESTDIR)$/index.html \
    $(DESTDIRDOCU)$/tools.html \
    $(DESTDIRDOCU)$/notsupported.html \
    $(DESTDIRDOCU)$/install.html \
    $(DESTDIRDOCU)$/DevelopersGuide_intro.html \
    $(DESTDIREXAMPLES)$/examples.html \
    $(DESTDIREXAMPLES)$/DevelopersGuide$/examples.html

DOCUFILES= \
    $(DESTDIRDOCU)$/DevelopersGuide$/DevelopersGuide.xhtml \
    $(DESTDIRDOCU)$/DevelopersGuide$/DevelopersGuide.pdf \
    $(DESTDIRDOCU)$/sdk_styles.css \
    $(DESTDIRGENIDLREF)$/idl.css

DIR_FILE_LIST=\
    $(DOCUFILES) \
    $(READMEFILES) \
    $(DESTDIR)$/settings$/dk.mk \
    $(IDL_DOCU_INDEX_FILE) \
    $(CONVERTTAGFLAG) 

DIR_DIRECTORY_LIST=$(uniq $(DIR_FILE_LIST:d))
DIR_FILE_FLAG=$(MISC)$/copying_files.txt

all : 	\
    $(DIR_FILE_LIST) \
    $(DIR_FILE_FLAG)


$(DESTDIRDOCU)$/%.css : $(PRJ)$/docs$/%.css
	+-$(MKDIRHIER) $(@:d)        
	+-rm -f $@ >& $(NULLDEV)
	$(MY_TEXTCOPY) $(MY_TEXTCOPY_SOURCEPRE) $< $(MY_TEXTCOPY_TARGETPRE) $@

$(DESTDIRDOCUIMAGES)$/% : $(PRJ)$/docs$/images$/%
	+-rm -f $@ >& $(NULLDEV)
	$(MY_COPY) $< $@

$(DESTDIR)$/settings$/dk.mk :
	+-$(MKDIRHIER) $(@:d)    
	+-rm -f $@ >& $(NULLDEV)
	echo #$(TITLE) dependent settings > $@
.IF "$(GUI)"=="UNX" || "$(USE_SHELL)"!="4nt"
	echo 'BUILDID= $(RSCREVISION)'>> $@
.ELSE
	echo BUILDID= $(RSCREVISION)>> $@
.ENDIF

$(DESTDIRDOCU)$/DevelopersGuide$/DevelopersGuide.pdf : DevelopersGuide.pdf
	+-$(MKDIRHIER) $(@:d)    
	+-rm -f $@ >& $(NULLDEV)
	$(MY_COPY) DevelopersGuide.pdf $(DESTDIRDOCU)$/DevelopersGuide

$(DESTDIRDOCU)$/DevelopersGuide$/DevelopersGuide.xhtml : DevelopersGuide.zip
	+-$(MKDIRHIER) $(@:d)    
	+unzip -quod $(DESTDIRDOCU) DevelopersGuide.zip && touch $@

$(CONVERTTAGFLAG) : $(MISC)$/deltree.txt
    +$(PERL) $(CONVERTTAGSCRIPT) 1 $(TITLE) $(OFFICEPRODUCTNAME) $(DOCUHTMLFILES)
    @echo "tags converted" > $@



$(IDL_DOCU_CLEANUP_FLAG) : $(IDL_CHAPTER_REFS) $(SOLARBINDIR)$/odkidl.zip $(PRJ)$/docs$/common$/ref$/idl.css
	+-$(MY_DELETE_RECURSIVE) $(DESTDIRGENIDLREF) >& $(NULLDEV)
	+-$(MY_DELETE_RECURSIVE) $(BIN)$/odkidl >& $(NULLDEV)
	+$(TOUCH) $@

$(IDL_DOCU_INDEX_FILE) : $(IDL_DOKU_CLEANUP_FLAG)
	$(GNUCOPY) -p $(SOLARBINDIR)$/odkidl.zip $(BIN)
	+-mkdir $(BIN)$/odkidl
	+-unzip -q -d $(BIN)$/odkidl $(BIN)$/odkidl.zip
	+-rm -f $(BIN)$/odkidl.zip >& $(NULLDEV)
	+-$(MKDIRHIER) $(@:d) 
	+$(MY_AUTODOC) -html $(DESTDIRGENIDLREF) -dvgroot ../../DevelopersGuide -sincefile apiref-autodoc.since  -name $(IDLDOCREFNAME) -lg \
	idl -dvgfile $(IDL_CHAPTER_REFS) -t $(SOURCEIDL)
	+-rm $(@:d)$/idl.css
	$(MY_TEXTCOPY) $(MY_TEXTCOPY_SOURCEPRE) $(PRJ)$/docs$/common$/ref$/idl.css $(MY_TEXTCOPY_TARGETPRE) $(@:d:d)$/idl.css

$(DIR_FILE_LIST) : $(IDL_DOCU_CLEANUP_FLAG)

$(DIR_FILE_FLAG) : $(DIR_FILE_LIST)
    @echo "must be zipped" > $@

