/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: real.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:38:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <precomp.h>
#include <udm/real.hxx>


// NOT FULLY DEFINED SERVICES
#include <cosv/template/tplutiln.hxx>



namespace udm
{

Data::accessor_type
Real::inq_Type() const
{
 	return t_Real;
}

Data::description
Real::inq_TypeDescription() const
{
 	return Data::description("r");
}

Real &
Real::access_Real()
{
 	return *this;
}


//*********************       Real_Null      *******************//

class Real_Null : public Real
{
  public:
    virtual             ~Real_Null();
  private:
    // Interface Data
    virtual void        do_Dispose();
    virtual void        do_BinWrite(
                            csv::bostream &     o_out ) const;
    // Interface Real:
    virtual value_type  inq_Value() const;
};

Real_Null::~Real_Null()
{
}

void                Real_Null::do_Dispose() { }
void                Real_Null::do_BinWrite( csv::bostream & ) const    {}


Real::value_type
Real_Null::inq_Value() const
{
 	return 0.0;
}


template <>
Real &
get_null<Real>( csv::Type2Type<Real> )
{
    static Real * pNull_ = new Real_Null;
    return *pNull_;
}




}   // namespace udm


namespace
{
//  compile-time check of sizeof(real) == 8:
char aCheck[ csv::TypeSizeCheck<real,8>::result ];
}

