/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sdrspell.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:00:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SDRSPELL_HXX
#define _SDRSPELL_HXX

#ifndef _SVDOUTL_HXX
#include <svx/svdoutl.hxx>
#endif

class SwViewShell;
class SwView;
class SdrTextObj;
class SdrObject;
class SwDoc;
class SfxStyleSheetPool;
class SpellChecker;
class SdWindow;
class SdrObjListIter;

#ifndef _COM_SUN_STAR_LINGUISTIC2_XSPELLCHECKER1_HPP_
#include <com/sun/star/linguistic2/XSpellChecker1.hpp>
#endif

/*************************************************************************
|*
|* SdrSpeller
|*
\************************************************************************/

class SdrSpeller : public SdrOutliner
{
	SwView* 			pView;
	::com::sun::star::uno::Reference< 
		::com::sun::star::linguistic2::XSpellChecker1 > 	xSpell;
	SdrTextObj* 		pTextObj;
	OutlinerView*		pOutlView;
	SdrObjListIter* 	pListIter;
	sal_uInt16				nDocIndex;

public:
	SdrSpeller( SwView* pVw, 
		::com::sun::star::uno::Reference< 
			::com::sun::star::linguistic2::XSpellChecker1 >  &xSpell );

	virtual ~SdrSpeller();

	virtual sal_Bool SpellNextDocument();
	void	StartSpelling();
    EditView&   GetEditView() const;
};


#endif		// _SDRSPELL_HXX

