/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: viewobjectcontactlist.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 20:01:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SDR_CONTACT_VIEWOBJECTCONTACTLIST_HXX
#define _SDR_CONTACT_VIEWOBJECTCONTACTLIST_HXX

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#include <vector>

//////////////////////////////////////////////////////////////////////////////
// predeclarations

class Region;

namespace sdr
{
	namespace contact
	{
		class ViewObjectContact;

		// typedefs for a vector of ViewObjectContacts
		typedef ::std::vector< ViewObjectContact* > ViewObjectContactVector;

		class ObjectContact;
		class DisplayInfo;
		class ViewContact;
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace contact
	{
		class ViewObjectContactList
		{
		private:
			
			// counter for entries
			sal_uInt32											mnCount;

			// entries in a union to allow list or single pointer
			union
			{
				ViewObjectContactVector*						mpVOCVector;
				ViewObjectContact*								mpVOContact;
			} maUnion;

		public:
			ViewObjectContactList();

			~ViewObjectContactList();

			sal_uInt32 Count() const { return mnCount; }

			ViewObjectContact* GetObject(sal_uInt32 nIndex) const;

			ViewObjectContact* GetLastObjectAndRemove();

			void Clear();

			void Append(ViewObjectContact* pNew);

			// Returns sal_True if remove was successful
			sal_Bool Remove(ViewObjectContact* pOld);

			sal_Bool Contains(ViewObjectContact* pOld);

			// This method only recursively clears the draw hierarchy structure between the
			// DrawObjectContacts, it does not delete any to make them reusable.
			void ClearDrawHierarchy();

			// This method recursively rebuilds the draw hierarchy structure in parallel
			// to the SdrObject structure.
			void BuildDrawHierarchy(ObjectContact& rObjectContact, ViewContact& rSourceNode, ViewObjectContact* pParent);

			// This method recursively checks the draw hierarchy structure in parallel
			// to the SdrObject structure and rebuilds the invalid parts.
			void CheckDrawHierarchy(ObjectContact& rObjectContact);

			// This method Recursively Builds the expand Clip Region
			void BuildClipRegion(DisplayInfo& rDisplayInfo, Region& rRegion);

			// If DrawHierarchy is handled by a object itself, the sub-objects are set 
			// to be equally painted to that object
			void CopyPaintFlagsFromParent(const ViewObjectContact& rParent);
		};
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_CONTACT_VIEWOBJECTCONTACTLIST_HXX

// eof
