/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: styledlg.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/05/02 16:04:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFX_STYLEDLG_HXX
#define _SFX_STYLEDLG_HXX

#ifndef _SAL_CONFIG_H_
#include "sal/config.h"
#endif

#ifndef INCLUDED_SFX2_DLLAPI_H
#include "sfx2/dllapi.h"
#endif

#include "tabdlg.hxx"

class SfxStyleSheetBase;

class SFX2_DLLPUBLIC SfxStyleDialog: public SfxTabDialog
{
private:
	SfxStyleSheetBase*			pStyle;
#if _SOLAR__PRIVATE
	DECL_DLLPRIVATE_LINK( CancelHdl, Button * );
#endif
protected:
	virtual const SfxItemSet*	GetRefreshedSet();

public:
#define ID_TABPAGE_MANAGESTYLES	1
	SfxStyleDialog( Window* pParent, const ResId& rResId, SfxStyleSheetBase&,
					BOOL bFreeRes = TRUE, const String* pUserBtnTxt = 0 );

	~SfxStyleDialog();

	SfxStyleSheetBase&			GetStyleSheet() { return *pStyle; }
	const SfxStyleSheetBase&	GetStyleSheet() const { return *pStyle; }

	virtual short 				Ok();
};

#endif

