/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: databrws.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:41:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SCH_DATABRWS_HXX
#define _SCH_DATABRWS_HXX
//------------------------------------------------------------------
//
// dieses Define dient nur zum Testen und darf auf keinen Fall aktiv bleiben
// Bei Umstellungen alle Files nach SIG_CHARTMODELDEFSCHDOC durchsuchen
// #define ChartModel SchChartDocument
//------------------------------------------------------------------

// #ifndef _SVX_BRWBOX_HXX //autogen
// #include <svtools/brwbox.hxx>
// #endif

#ifndef _SVTOOLS_EDITBROWSEBOX_HXX_
#include <svtools/editbrowsebox.hxx>
#endif
#ifndef _SV_OUTDEV_HXX //autogen
#include <vcl/outdev.hxx>
#endif
#ifndef _SV_EDIT_HXX
#include <vcl/edit.hxx>
#endif

#include <memory>

#include "datalog.hxx"

class ChartModel;
class SchMemChart;

/*************************************************************************
|*
|* Browser fuer Chart-Daten
|*
\************************************************************************/

class ChartDataBrowseBox : public ::svt::EditBrowseBox
{
private:
	const ChartModel*	m_pModel;
	::std::auto_ptr< SchMemChart > m_apMemChart;

    /** this object is created here but deleted by the ChartModel If no
        ChartModel was set this variable remains 0.
     */
	SchDataLogBook *    m_pLogBook;

    KeyEvent            m_aKeyEvent;
    /// the row that is currently painted
    long                m_nSeekRow;
    bool                m_bIsReadOnly;
    bool                m_bIsDirty;

    Edit                m_aEditField;
    /// note: the Edit control must precede this member!
    ::svt::CellControllerRef m_rEditController;

    Link				m_aCursorMovedHdlLink;
	Link				m_aEditFieldHdlLink;
	Link				m_aClickHdlLink;
    Link                m_aCellModifiedLink;

	void RenewTable();

	String GetColString( USHORT nColumnId ) const;
	String GetRowString( long nRow ) const;

    /// not implemented: inhibit copy construction
    ChartDataBrowseBox( const ChartDataBrowseBox & );

protected:
    // EditBrowseBox overridables
    virtual void PaintCell( OutputDevice& _rDev, const Rectangle& _rRect, sal_uInt16 _nColumnId ) const;
    virtual sal_Bool SeekRow( long nRow );
    virtual sal_Bool IsTabAllowed( sal_Bool bForward ) const;
    virtual ::svt::CellController* GetController( long nRow, sal_uInt16 nCol );
    virtual void InitController( ::svt::CellControllerRef& rController, long nRow, sal_uInt16 nCol );
    virtual sal_Bool SaveModified();
	virtual void CursorMoved();
    // called whenever the control of the current cell has been modified
    virtual void CellModified();

    void SetDirty();

public:
	ChartDataBrowseBox( Window* pParent, const ResId & rId );
	virtual ~ChartDataBrowseBox();

	/** GetCellText returns the text at the given position
		@param	_nRow
			the number of the row
		@param	_nColId
			the ID of the column
		@return
			the text out of the cell
	*/
	virtual String	GetCellText(long _nRow, USHORT _nColId) const;

    /// @return old state
    bool SetReadOnly( bool bNewState );
    bool IsReadOnly() const;

    /// @return true, if data has been modified
    bool IsDirty() const;
    /// reset the dirty status, if changes have been saved
    void SetClean();

    void SetDataFromModel( const ChartModel* pDoc );
	const SchMemChart* GetData() const;

    // predicates to determine what actions are possible at the current cursor
    // position.  This depends on the implementation of the according mutators
    // below.  (They are used for enabling toolbar icons)
    bool MayInsertRow() const;
    bool MayInsertColumn() const;
    bool MayDeleteRow() const;
    bool MayDeleteColumn() const;

    bool MaySwapRows() const;
    bool MaySwapColumns() const;

    bool MaySortRow() const;
    bool MaySortColumn() const;

    // mutators mutating data
	void InsertRow();
	void InsertColumn();
	void RemoveRow();
	void RemoveColumn();

	void SwapRow();
	void SwapColumn();

	void QuickSortRow();
	void QuickSortCol();

    // sorting the entire table
	void QuickSortTableCols ();
	void QuickSortTableRows ();

	void SetCursorMovedHdl( const Link& rLink );
	const Link& GetCursorMovedHdl() const;

    void SetCellModifiedHdl( const Link& rLink );

    /// confirms all pending changes to be ready to be closed
    void EndEditing();
};

#endif	// _SCH_DATABRSW_HXX


