
package org.netbeans.modules.openoffice.wizard.actions.idl;

import java.util.ResourceBundle;
import org.netbeans.modules.openoffice.wizard.util.Create;
import org.netbeans.modules.openoffice.wizard.util.UnionDefaultCreator;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class CreateUnionDefaultAction extends NodeAction
    implements Create
{

    public CreateUnionDefaultAction()
    {
    }

    public boolean enable(Node anode[])
    {
        if(anode.length != 1)
            return false;
        UnionDefaultCreator uniondefaultcreator = (UnionDefaultCreator)anode[0].getCookie(UnionDefaultCreator.class);
        if(uniondefaultcreator == null)
            return false;
        else
            return uniondefaultcreator.canAdd();
    }

    public void performAction(Node anode[])
    {
        if(enable(anode))
            ((UnionDefaultCreator)anode[0].getCookie(UnionDefaultCreator.class)).createUnionDefault();
    }

    public String getName()
    {
        return ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString("TXT_CreateUnionDefault");
    }

    public String toString()
    {
        return ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString("TXT_UnionDefault");
    }

    public HelpCtx getHelpCtx()
    {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isEnabled(Node anode[])
    {
        return enable(anode);
    }

 }
