
package org.netbeans.modules.openoffice.wizard.actions.idl;

import java.util.ResourceBundle;
import org.netbeans.modules.openoffice.wizard.util.Create;
import org.netbeans.modules.openoffice.wizard.util.InterfaceCreator;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class CreateInterfaceAction extends NodeAction
    implements Create
{

    public CreateInterfaceAction()
    {
    }

    protected void performAction(Node anode[])
    {
        if(enable(anode))
            ((InterfaceCreator)anode[0].getCookie(InterfaceCreator.class)).createInterface();
    }

    protected boolean enable(Node anode[])
    {
        return anode.length == 1 && anode[0].getCookie(InterfaceCreator.class) != null;
    }

    public String getName()
    {
        return ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString("TXT_CreateInterface");
    }

    public String toString()
    {
        return ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/actions/idl/Bundle").getString("TXT_Interface");
    }

    public HelpCtx getHelpCtx()
    {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isEnabled(Node anode[])
    {
        return enable(anode);
    }

}
