/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: elements.hxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:34:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#if !defined INCLUDED_JVMFWK_ELEMENTS_HXX
#define INCLUDED_JVMFWK_ELEMENTS_HXX

#include <vector>
#include "jvmfwk/framework.h"
#include "rtl/ustring.hxx"
#include "rtl/byteseq.hxx"
#include "libxml/parser.h"

#define NS_JAVA_FRAMEWORK "http://openoffice.org/2004/java/framework/1.0"
#define NS_SCHEMA_INSTANCE "http://www.w3.org/2001/XMLSchema-instance"

namespace jfw
{

xmlNode* findChildNode(const xmlNode * pParent, const xmlChar* pName);

/** gets the value of the updated element from the javavendors.xml.
 */
rtl::OString getElementUpdated();

/** creates the javasettings.xml in the users home directory.

    If javasettings.xml does not exist then it creates the file
    and inserts the root element with its namespaces.
    The content should look like this:

    <?xml version="1.0" encoding="UTF-8"?>
    <!--This is a generated file. Do not alter this file!-->
    <java xmlns:="http://openoffice.org/2004/java/framework/1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    </java>


 */
void createUserSettingsDocument();

/** create the child elements within the root structure for each platform.

    @param bNeedsSave
    [out]If true then the respective structure of elements was added and the
    document needs to be saved.
 */
void createSettingsStructure(
    xmlDoc * document, bool * bNeedsSave);

/** copies shared settings to user settings.

    This must only occur the first time when the javasettings.xml is
    prepared for the user. The shared settings shall be provided as bootstrap
    parameters.

    @param userParent
    The node under which the values are to be copied. 
    
 */
void copyShareSettings(xmlDoc * userDoc, xmlNode* userParent);

/** creates the structure of the documend.

    When this function is called the first time for a user then it creates the
    javasettings.xml in th ~/<office>/user/config/ unless it already exists
    (see createUserSettingsDocument). Then
    it creates a section for the current platform unless it already exist and
    creates all children elements. If the respective platform section did not exist
    then after creating the children, the values from the share/config/javasettings.xml
    are copied.

    @return
    JFW_E_CONFIG_READWRITE
 */
void prepareSettingsDocument();

class CXmlCharPtr;
class CNodeJavaInfo
{
public:
    CNodeJavaInfo();
    ~CNodeJavaInfo();
    /**
       sUpdated is the value from the <updated> element from the
       javavendors.xml.
     */
    CNodeJavaInfo(const JavaInfo * pInfo);

    /** if true, then javaInfo is empty. When writeToNode is called
        then all child elements are deleted.
     */
    bool m_bEmptyNode;
    /** Contains the value of the <updated> element of
        the javavendors.xml after loadFromNode was called.
        It is not used, when the javaInfo node is written.
        see writeToNode
     */
    rtl::OString sAttrVendorUpdate;
    /** contains the nil value of the /java/javaInfo@xsi:nil attribute.
        Default is true;
     */
    bool bNil;
    /** contains the value of the /java/javaInfo@autoSelect attribute.
        Default is true. If it is false then the user has modified the JRE
        selection by actively choosing a JRE from the options dialog. That is,
        the function jfw_setSelectedJRE was called. Contrary, the function
        jfw_findAndSelectJRE sets the attribute to true.
     */
    bool bAutoSelect;
    rtl::OUString sVendor;
    rtl::OUString sLocation;
    rtl::OUString sVersion;
    sal_uInt64 nFeatures;
    sal_uInt64 nRequirements;
    rtl::ByteSequence arVendorData;

    /** reads the node /java/javaInfo.
        If javaInfo@xsi:nil = true then member bNil is set to true
        an no further elements are read.
     */
    void loadFromNode(xmlDoc * pDoc,xmlNode * pJavaInfo);
    /** Only writes user settings. The attribut nil always gets the value
        false. The function gets the value javaSettings/updated from the
        javavendors.xml and writes it to javaInfo@vendorUpdate in javasettings.xml
     */
    void writeToNode(xmlDoc * pDoc, xmlNode * pJavaInfo) const;

    /** returns NULL if javaInfo is nil in both, user and share, settings.
     */
    JavaInfo * makeJavaInfo() const;
};

/** this class represents the javasettings.xml file
 */
class CNodeJava
{
    /** Share settings are a special case. Per default
        there are only user settings. Currently there need not be
        a share settings file. In that case the function returns
        without throwing an exception.
     */
    void loadShareSettings();
    /** This function is called after loadShareSettings. Elements which have been
        modified by the user, that is, the attribute xsi:nil = false, overwrite the
        values which have been retrieved with loadShareSettings.
    */
    void loadUserSettings();

    /** User configurable option.  /java/enabled
        The value is valid after loadFromSettings has been called
        successfully.
        The value is that of the user setting. If it is nil
        (/java/enabled[@xsi:nil = true]) then it represents the share setting.
        If there are no share settings or the node is also nil then the default
        is true.
    */
    sal_Bool m_bEnabled;
    /** Determines if m_bEnabled has been modified */
    bool m_bEnabledModified;
    /** User configurable option. /java/userClassPath
        The value is valid after loadFromSettings has been called successfully.
        The value is that of the user setting. If it is nil
        (/java/userClassPath[@xsi:nil = true]) then it represents the share setting.
        If there are no share settings or the node is also nil then the default
        is an empty string.
    */
    rtl::OUString m_sUserClassPath;
    /** Determines if m_sUserClassPath has been modified */
    bool m_bUserClassPathModified;
    /** User configurable option.  /java/javaInfo
        The value is valid after loadFromSettings has been called successfully.
        The value is that of the user setting. If it is nil
        (/java/javaInfo[@xsi:nil = true]) then it represents the share setting.
        If there are no share settings then the structure is regarded as empty.
     */
    CNodeJavaInfo m_aInfo;
    /** Determines if m_aInfo has been modified */
    bool m_bJavaInfoModified;

    /** User configurable option. /java/vmParameters
        The value is valid after loadFromSettings has been called successfully.
        The value is that of the user setting. If it is nil
        (/java/vmParameters[@xsi:nil = true]) then it represents the share setting.
        If there are no share settings then array is empty.
    */
    std::vector<rtl::OString>  m_arVmParameters;
    bool m_bVmParametersModified;

    /** User configurable option. /java/jreLocations
        The value is valid after loadFromSettings has been called successfully.
        The value is that of the user setting. If it is nil
        (/java/jreLocations[@xsi:nil = true]) then it represents the share setting.
        If there are no share settings then array is empty.
    */
    std::vector<rtl::OString>  m_arJRELocations;
    bool m_bJRELocationsModified;

public:    
    CNodeJava();
    /** sets m_bEnabled. It also sets a flag, that the value has been
        modified. This will cause that /java/enabled[@xsi:nil] will be
        set to false. The nil value and the value of enabled are only
        written when write Settings is called.
     */
    void setEnabled(sal_Bool bEnabled);
    /** returns the value of the element /java/enabled
     */
    sal_Bool getEnabled() const;
    /** sets m_sUserClassPath. Analog to setEnabled.
     */
    void setUserClassPath(const rtl::OUString & sClassPath);
    /** returns the value of the element /java/userClassPath.
     */
    rtl::OUString const & getUserClassPath() const;
    /** sets m_aInfo. Analog to setEnabled.
        @param bAutoSelect
        true- called by jfw_setSelectedJRE
        false called by jfw_findAndSelectJRE
     */
    void setJavaInfo(const JavaInfo * pInfo, bool bAutoSelect);
    /** returns a JavaInfo structure representing the node
        /java/javaInfo. Every time a new JavaInfo structure is created
        which needs to be freed by the caller.
        If both, user and share settings are nil, then NULL is returned.
    */
    JavaInfo * createJavaInfo() const;
    /** returns the value of the attribute /java/javaInfo[@vendorUpdate].
     */
    rtl::OString const & getJavaInfoAttrVendorUpdate() const;

    /** returns the javaInfo@autoSelect attribute.
        Before calling this function loadFromSettings must be called.
        It uses the javaInfo@autoSelect attribute  to determine
        the return value;
     */
    bool getJavaInfoAttrAutoSelect() const;

    /** sets the /java/vmParameters/param elements.
        The values are kept in a vector m_arVmParameters. When this method is
        called then the vector is cleared and the new values are inserted.
        The xsi:nil attribute of vmParameters will be set to true;
     */
    void setVmParameters(rtl_uString  * * arParameters, sal_Int32 size);
    /** returns the parameters from the element /java/vmParameters/param.
     */
    const std::vector<rtl::OString> & getVmParameters() const;

    /** returns an array.
        Caller must free the strings and the array.
     */
    void getVmParametersArray(rtl_uString *** parParameters, sal_Int32 * size) const;

    /** sets the /java/jreLocations/location elements.
        The values are kept in a vector m_arJRELocations. When this method is
        called then the vector is cleared and the new values are inserted.
        The xsi:nil attribute of vmParameters will be set to true;
     */
    void setJRELocations(rtl_uString  * * arParameters, sal_Int32 size);

    void addJRELocation(rtl_uString * sLocation);
    /** returns the parameters from the element /java/jreLocations/location.
     */
    const std::vector<rtl::OString> & getJRELocations() const;


    /** returns an array.
        Caller must free the strings and the array.
     */
    void getJRELocations(rtl_uString *** parLocations, sal_Int32 * size) const;
    
    
    /** reads user and share settings. user data supersede
        share data. These elements can be changed by the user:
        <enabled>, <userClasspath>, <javaInfo>, <vmParameters>
        If the user has not changed them then the nil attribute is
        set to true;
     */
    void loadFromSettings();
    /** writes the data to user settings.
     */
    void writeSettings() const;

    
};



class VersionInfo
{
    std::vector<rtl::OUString> vecExcludeVersions;
    rtl_uString ** arVersions;

public:
    VersionInfo();
    ~VersionInfo();

    void addExcludeVersion(const rtl::OUString& sVersion);
    
    rtl::OUString sMinVersion;
    rtl::OUString sMaxVersion;

    /** The caller DOES NOT get ownership of the strings. That is he
        does not need to release the strings.
        The array exists as long as this object exists.
    */
    
    rtl_uString** getExcludeVersions();
    sal_Int32 getExcludeVersionSize();
};

struct PluginLibrary
{
    PluginLibrary()
    {
    }
    PluginLibrary(rtl::OUString vendor, rtl::OUString path) :
        sVendor(vendor), sPath(path)
    {
    }
    /** contains the vendor string which is later userd in the xml API
     */
    rtl::OUString sVendor;
    /** File URL the plug-in library
     */
    rtl::OUString sPath;
};

} //end namespace
#endif
