/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dlg_InsertStatistic.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:09:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "dlg_InsertStatistic.hxx"
#include "dlg_InsertStatistic.hrc"

#include "ResId.hxx"
#include "SchSfxItemIds.hxx"
#include "Strings.hrc"
#include "Bitmaps.hrc"
#include "Bitmaps_HC.hrc"

// header for class SfxBoolItem
#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif

//.............................................................................
namespace chart
{
//.............................................................................

// macro for selecting a normal or high contrast bitmap the stack variable
// bIsHighContrast must exist and reflect the correct state

#define SELECT_BITMAP(name) Bitmap( SchResId( bIsHighContrast ? name ## _HC : name ))

enum StatIndicator
{
	INDICATE_NONE,
	INDICATE_BOTH,
	INDICATE_UP,
	INDICATE_DOWN
};

enum StatRegression
{
	REGRESSION_NONE,
	REGRESSION_LINE,
	REGRESSION_LOG,
	REGRESSION_EXP,
	REGRESSION_POW
};

/*************************************************************************
|*
|* Dialog fuer die Statistikfunktionen
|*
\************************************************************************/

SchDataStatisticsDlg::SchDataStatisticsDlg(Window           *pWindow,
										   const SfxItemSet &rMyAttrs) :
	ModalDialog(pWindow, SchResId(DLG_DATA_STAT)),
	aCbxAverage (this, ResId (CBX_AVERAGE)),
	aRbtNone (this, ResId (RBT_NONE)),
	aRbtVariant (this, ResId (RBT_VARIANT)),
	aRbtSigma (this, ResId (RBT_SIGMA)),
	aRbtPercent (this, ResId (RBT_PERCENT)),
	aRbtBigError (this, ResId (RBT_BIGERROR)),
	aRbtConst (this, ResId (RBT_CONST)),
	aFlDescr (this, ResId (FL_ERROR)),
	aMtrFldPercent (this, ResId (MTR_FLD_PERCENT)),
	aMtrFldBigError (this, ResId (MTR_FLD_BIGERROR)),
	aFTConstPlus (this, ResId (FT_PERCENT_PLUS)),
	aMtrFldConstPlus (this, ResId (MTR_FLD_PLUS)),
	aFTConstMinus (this, ResId (FT_PERCENT_MINUS)),
	aMtrFldConstMinus (this, ResId (MTR_FLD_MINUS)),
	aFTIndicate (this, ResId (FT_INDICATE)),
	aFTRegress (this, ResId (FT_REGRESS)),
	aSet (this, ResId (CT_INDICATE)),
	aRegression (this, ResId (CT_REGRESS)),
	aBtnOK (this, ResId (BTN_OK)),
	aBtnCancel (this, ResId (BTN_CANCEL)),
	aBtnHelp (this, ResId (BTN_HELP)),
    m_bEnableRegression( false ),
	rInAttrs(rMyAttrs),
    m_eErrorKind( CHERROR_NONE ),
    m_bErrorKindUnique( true ),
    m_eIndicate( CHINDICATE_BOTH ),
    m_bIndicatorUnique( true ),
    m_eRegression( CHREGRESS_NONE ),
    m_bRegressionUnique( true ),

    m_bPlusUnique( true ),
    m_bMinusUnique( true )
{
	FreeResource();

	aRbtNone.SetClickHdl(LINK(this, SchDataStatisticsDlg, RBtnClick));
	aRbtVariant.SetClickHdl(LINK(this, SchDataStatisticsDlg, RBtnClick));
	aRbtSigma.SetClickHdl(LINK(this, SchDataStatisticsDlg, RBtnClick));
	aRbtPercent.SetClickHdl(LINK(this, SchDataStatisticsDlg, RBtnClick));
	aRbtBigError.SetClickHdl(LINK(this, SchDataStatisticsDlg, RBtnClick));
	aRbtConst.SetClickHdl(LINK(this, SchDataStatisticsDlg, RBtnClick));
	aCbxAverage.SetClickHdl(LINK(this, SchDataStatisticsDlg, CbxClick));
// 	aMtrFldConstPlus.SetLoseFocusHdl(LINK(this, SchDataStatisticsDlg, EditLoseFocusHdl));
// 	aMtrFldConstMinus.SetLoseFocusHdl(LINK(this, SchDataStatisticsDlg, EditLoseFocusHdl));

    FillValueSets();

    aSet.SetStyle (aSet.GetStyle () /*| WB_ITEMBORDER | WB_DOUBLEBORDER*/ | WB_NAMEFIELD /*| WB_VSCROLL*/ );
	aSet.SetColCount(5);
	aSet.SetLineCount(1);
	aSet.SetExtraSpacing(2);
	aSet.SetSelectHdl(LINK(this, SchDataStatisticsDlg, SelectIndicate));

	aRegression.SetStyle (aSet.GetStyle () /*| WB_ITEMBORDER | WB_DOUBLEBORDER*/ | WB_NAMEFIELD /*| WB_VSCROLL*/ );
	aRegression.SetColCount(5);
	aRegression.SetLineCount(1);
	aRegression.SetExtraSpacing(2);
	aRegression.SetSelectHdl(LINK(this, SchDataStatisticsDlg, SelectRegression));

	Reset();
}

/*************************************************************************
|*
|* Dtor
|*
\************************************************************************/

SchDataStatisticsDlg::~SchDataStatisticsDlg()
{
}

/*************************************************************************
|*
|*	Handler fuer Mittelwert-Button
|*
\*************************************************************************/

IMPL_LINK( SchDataStatisticsDlg, CbxClick, CheckBox *, pBtn )
{
	return 0;
}

/*************************************************************************
|*
|*	Handler fuer die Radiobuttons
|*
\*************************************************************************/

IMPL_LINK( SchDataStatisticsDlg, RBtnClick, Button *, pBtn )
{
	aMtrFldPercent.Enable (pBtn == &aRbtPercent);
	aMtrFldBigError.Enable (pBtn == &aRbtBigError);
	aMtrFldConstPlus.Enable (pBtn == &aRbtConst);
	aMtrFldConstMinus.Enable (pBtn == &aRbtConst);
	aSet.Enable (pBtn != &aRbtNone);
	aFTIndicate.Enable (pBtn != &aRbtNone);

	if (pBtn == &aRbtPercent) m_eErrorKind = CHERROR_PERCENT;
	if (pBtn == &aRbtBigError) m_eErrorKind = CHERROR_BIGERROR;
	if (pBtn == &aRbtConst) m_eErrorKind = CHERROR_CONST;

	if (pBtn == &aRbtNone)
	{
		aSet.Hide ();
		m_eErrorKind = CHERROR_NONE;
	}
	else
	{
		aSet.Show ();
		if (pBtn == &aRbtVariant) m_eErrorKind = CHERROR_VARIANT;
			else if (pBtn == &aRbtSigma) m_eErrorKind = CHERROR_SIGMA;
	}
    m_bErrorKindUnique = true;

	return 0;
}

/*************************************************************************
|*
|*	Initialisierung
|*
\*************************************************************************/

void SchDataStatisticsDlg::Reset()
{
	const SfxPoolItem *pPoolItem = NULL;
    SfxItemState aState = SFX_ITEM_UNKNOWN;

    aState = rInAttrs.GetItemState( SCHATTR_STAT_AVERAGE, TRUE, &pPoolItem );
    if( aState == SFX_ITEM_DONTCARE )
    {
        aCbxAverage.EnableTriState( TRUE );
        aCbxAverage.SetState( STATE_DONTKNOW );
    }
    else
    {
        aCbxAverage.EnableTriState( FALSE );
        if( aState == SFX_ITEM_SET )
            aCbxAverage.Check( static_cast< const SfxBoolItem * >( pPoolItem )->GetValue());
    }

    m_eErrorKind = CHERROR_NONE;
    aState = rInAttrs.GetItemState( SCHATTR_STAT_KIND_ERROR, TRUE, &pPoolItem );
    m_bErrorKindUnique = ( aState != SFX_ITEM_DONTCARE );

    if( aState == SFX_ITEM_SET )
        m_eErrorKind = ((const SvxChartKindErrorItem*) pPoolItem)->GetValue();

    if( m_bErrorKindUnique )
    {
        aRbtNone.Check    ( m_eErrorKind == CHERROR_NONE );
        aRbtVariant.Check ( m_eErrorKind == CHERROR_VARIANT );
        aRbtSigma.Check   ( m_eErrorKind == CHERROR_SIGMA );
        aRbtPercent.Check ( m_eErrorKind == CHERROR_PERCENT );
        aRbtBigError.Check( m_eErrorKind == CHERROR_BIGERROR );
        aRbtConst.Check   ( m_eErrorKind == CHERROR_CONST );
    }
    else
    {
        aRbtNone.Check    ( FALSE );
        aRbtVariant.Check ( FALSE );
        aRbtSigma.Check   ( FALSE );
        aRbtPercent.Check ( FALSE );
        aRbtBigError.Check( FALSE );
        aRbtConst.Check   ( FALSE );
    }

    aSet.Enable (m_eErrorKind != CHERROR_NONE);
	aFTIndicate.Enable (m_eErrorKind != CHERROR_NONE);

	if (m_eErrorKind == CHERROR_NONE) aSet.Hide ();
	else aSet.Show ();

    aState = rInAttrs.GetItemState( SCHATTR_STAT_CONSTPLUS, TRUE, &pPoolItem );
    m_bPlusUnique = ( aState != SFX_ITEM_DONTCARE );
    sal_Int32 nPlusValue = 0;
    if( aState == SFX_ITEM_SET )
    {
        nPlusValue = static_cast< sal_Int32 >(((const SvxDoubleItem*) pPoolItem)->GetValue() * 10.0);
		aMtrFldConstPlus.SetValue( nPlusValue );
    }

    aState = rInAttrs.GetItemState( SCHATTR_STAT_CONSTMINUS, TRUE, &pPoolItem );
    m_bMinusUnique = ( aState != SFX_ITEM_DONTCARE );
    sal_Int32 nMinusValue = 0;
    if( aState == SFX_ITEM_SET )
    {
        nMinusValue = static_cast< sal_Int32 >(((const SvxDoubleItem*) pPoolItem)->GetValue() * 10.0);
		aMtrFldConstMinus.SetValue( nMinusValue );
    }

    if( m_bPlusUnique && m_bMinusUnique )
    {
        sal_Int32 nAvg = (nPlusValue + nMinusValue) / 2;
        aMtrFldPercent.SetValue(  nAvg );
        aMtrFldBigError.SetValue( nAvg );
    }

//     if (rInAttrs.GetItemState(SCHATTR_STAT_PERCENT, TRUE, &pPoolItem) == SFX_ITEM_SET)
// 		aMtrFldPercent.SetValue( static_cast< sal_Int32 >(((const SvxDoubleItem*) pPoolItem)->GetValue()));
// 	else aMtrFldPercent.SetValue(0);

// 	if (rInAttrs.GetItemState(SCHATTR_STAT_BIGERROR, TRUE, &pPoolItem) == SFX_ITEM_SET)
// 		aMtrFldBigError.SetValue( static_cast< sal_Int32 >(((const SvxDoubleItem*) pPoolItem)->GetValue()));
// 	else aMtrFldBigError.SetValue(0);

    if( m_bEnableRegression )
    {
        aFTRegress.Show ();
        aRegression.Show ();
    }
    else
    {
        aRegression.Hide ();
        aFTRegress.Hide ();
    }

	if ((m_eErrorKind == CHERROR_NONE) ||
		(m_eErrorKind == CHERROR_VARIANT) ||
		(m_eErrorKind == CHERROR_SIGMA))
	{
		aMtrFldPercent.Enable (FALSE);
		aMtrFldBigError.Enable (FALSE);
		aMtrFldConstPlus.Enable (FALSE);
		aMtrFldConstMinus.Enable (FALSE);
	}
	else if (m_eErrorKind == CHERROR_PERCENT)
		 {
			 aMtrFldPercent.Enable (TRUE);
			 aMtrFldBigError.Enable (FALSE);
			 aMtrFldConstPlus.Enable (FALSE);
			 aMtrFldConstMinus.Enable (FALSE);
		 }
		 else if (m_eErrorKind == CHERROR_BIGERROR)
			  {
				  aMtrFldPercent.Enable (FALSE);
				  aMtrFldBigError.Enable (TRUE);
				  aMtrFldConstPlus.Enable (FALSE);
				  aMtrFldConstMinus.Enable (FALSE);
			  }
			  else if (m_eErrorKind == CHERROR_CONST)
				   {
					   aMtrFldPercent.Enable (FALSE);
					   aMtrFldBigError.Enable (FALSE);
					   aMtrFldConstPlus.Enable (TRUE);
					   aMtrFldConstMinus.Enable (TRUE);
				   }

	aState = rInAttrs.GetItemState( SCHATTR_STAT_INDICATE, TRUE, &pPoolItem );
    m_bIndicatorUnique = ( aState != SFX_ITEM_DONTCARE );
    if( aState == SFX_ITEM_SET)
		m_eIndicate = ((const SvxChartIndicateItem * ) pPoolItem)->GetValue();

    if( m_bIndicatorUnique )
    {
        switch( m_eIndicate )
        {
            case CHINDICATE_NONE :
                aSet.SelectItem(INDICATE_NONE + 1);
                break;
            case CHINDICATE_BOTH :
                aSet.SelectItem(INDICATE_BOTH + 1);
                break;
            case CHINDICATE_UP :
                aSet.SelectItem(INDICATE_UP + 1);
                break;
            case CHINDICATE_DOWN :
                aSet.SelectItem(INDICATE_DOWN + 1);
                break;
        }                                                             \
    }
    else
        aSet.SetNoSelection();

	aState = rInAttrs.GetItemState( SCHATTR_STAT_REGRESSTYPE, TRUE, &pPoolItem );
    m_bRegressionUnique = ( aState != SFX_ITEM_DONTCARE );
    if( aState == SFX_ITEM_SET )
        m_eRegression = ((const SvxChartRegressItem * ) pPoolItem)->GetValue();

    if( m_bRegressionUnique )
    {
        switch( m_eRegression )
        {
            case CHREGRESS_NONE :
                aRegression.SelectItem(REGRESSION_NONE + 1);
                break;
            case CHREGRESS_LINEAR :
                aRegression.SelectItem(REGRESSION_LINE + 1);
                break;
            case CHREGRESS_LOG :
                aRegression.SelectItem(REGRESSION_LOG + 1);
                break;
            case CHREGRESS_EXP :
                aRegression.SelectItem(REGRESSION_EXP + 1);
                break;
            case CHREGRESS_POWER :
                aRegression.SelectItem(REGRESSION_POW + 1);
                break;
        }
    }

}

/*************************************************************************
|*
|*    Fuellt uebergebenen Item-Set mit Dialogbox-Attributen
|*
\*************************************************************************/

void SchDataStatisticsDlg::GetAttr(SfxItemSet& rOutAttrs)
{
    if( aCbxAverage.GetState() != STATE_DONTKNOW )
        rOutAttrs.Put( SfxBoolItem( SCHATTR_STAT_AVERAGE, aCbxAverage.IsChecked() ));
    if( m_bErrorKindUnique )
        rOutAttrs.Put( SvxChartKindErrorItem( m_eErrorKind ));

    if( m_bIndicatorUnique )
        rOutAttrs.Put( SvxChartIndicateItem( m_eIndicate ));

	if( m_bEnableRegression &&
        m_bRegressionUnique )
        rOutAttrs.Put( SvxChartRegressItem( m_eRegression ));

    if( m_bErrorKindUnique )
    {
        switch( m_eErrorKind )
        {
            case CHERROR_PERCENT :
                if( aMtrFldPercent.IsModified())
                    rOutAttrs.Put (SvxDoubleItem ((double) aMtrFldPercent.GetValue () / 10.0, SCHATTR_STAT_PERCENT));
                break;
            case CHERROR_BIGERROR :
                if( aMtrFldBigError.IsModified())
                    rOutAttrs.Put (SvxDoubleItem ((double) aMtrFldBigError.GetValue () / 10.0, SCHATTR_STAT_BIGERROR));
                break;
            case CHERROR_CONST :
                if( aMtrFldConstPlus.IsModified())
                    rOutAttrs.Put (SvxDoubleItem ((double) aMtrFldConstPlus.GetValue () / 10.0, SCHATTR_STAT_CONSTPLUS));
                if( aMtrFldConstMinus.IsModified())
                    rOutAttrs.Put (SvxDoubleItem ((double) aMtrFldConstMinus.GetValue () / 10.0, SCHATTR_STAT_CONSTMINUS));
                break;
            case CHERROR_NONE:
            case CHERROR_VARIANT:
            case CHERROR_SIGMA:
                // nothing
                break;
        }
    }
}

/*************************************************************************
|*
|*    Bearbeitet das Werteset der Fehlerbalken
|*
\*************************************************************************/

IMPL_LINK( SchDataStatisticsDlg, SelectIndicate, void *, EMPTYARG )
{
	StatIndicator eSelection = (StatIndicator) aSet.GetSelectItemId();

    switch (eSelection - 1)
	{
		case INDICATE_NONE :
			m_eIndicate = CHINDICATE_NONE;
			break;

		case INDICATE_BOTH :
			m_eIndicate = CHINDICATE_BOTH;
			break;

		case INDICATE_UP :
			m_eIndicate = CHINDICATE_UP;
			break;

		case INDICATE_DOWN :
			m_eIndicate = CHINDICATE_DOWN;
			break;
	}

	aSet.SelectItem(eSelection);
	aSet.Show ();
    m_bIndicatorUnique = true;

	return 0;
}

/*************************************************************************
|*
|*    Bearbeitet das Werteset der Regression
|*
\*************************************************************************/

IMPL_LINK( SchDataStatisticsDlg, SelectRegression, void *, EMPTYARG )
{
	StatRegression eSelection = (StatRegression) aRegression.GetSelectItemId();

    switch (eSelection - 1)
	{
		case REGRESSION_NONE :
			m_eRegression = CHREGRESS_NONE;
			break;

		case REGRESSION_LINE :
			m_eRegression = CHREGRESS_LINEAR;
			break;

		case REGRESSION_LOG :
			m_eRegression = CHREGRESS_LOG;
			break;

		case REGRESSION_EXP :
			m_eRegression = CHREGRESS_EXP;
			break;

		case REGRESSION_POW :
			m_eRegression = CHREGRESS_POWER;
			break;
	}

	aRegression.SelectItem(eSelection);
	aRegression.Show ();
    m_bRegressionUnique = true;

	return 0;
}

/*************************************************************************
|*
|*    Bearbeite das Valueset
|*
\*************************************************************************/

// IMPL_LINK( SchDataStatisticsDlg, EditLoseFocusHdl, Control *, pControl )
// {
// 	if ((double) aMtrFldConstPlus.GetValue () == 0.0)
// 	{
// 		if ((double) aMtrFldConstMinus.GetValue () == 0.0)
// 		{
// 			m_eIndicate = CHINDICATE_NONE;
// 			aSet.SelectItem(INDICATE_NONE + 1);
// 		}
// 		else if (m_eIndicate != CHINDICATE_NONE)
// 			 {
// 				 m_eIndicate = CHINDICATE_DOWN;
// 				 aSet.SelectItem(INDICATE_DOWN + 1);
// 			 }
// 	}
// 	else if ((double) aMtrFldConstMinus.GetValue () == 0.0)
// 		 {
// 			 if (m_eIndicate != CHINDICATE_NONE)
// 			 {
// 				 m_eIndicate = CHINDICATE_UP;
// 				 aSet.SelectItem(INDICATE_UP + 1);
// 			 }
// 		 }
// 		 else
// 		 {
// 			 m_eIndicate = CHINDICATE_BOTH;
// 			 aSet.SelectItem(INDICATE_BOTH + 1);
// 		 }

// 	return 0;
// }

void SchDataStatisticsDlg::FillValueSets()
{
    bool bIsHighContrast = ( true && GetDisplayBackground().GetColor().IsDark() );

    if( aSet.GetItemCount() == 0 )
    {
        aSet.InsertItem( INDICATE_NONE + 1, SELECT_BITMAP( BMP_INDICATE_NONE ),
                         String(SchResId(STR_INDICATE_NONE)));
        aSet.InsertItem( INDICATE_BOTH + 1, SELECT_BITMAP( BMP_INDICATE_BOTH ),
                         String(SchResId(STR_INDICATE_BOTH)));
        aSet.InsertItem( INDICATE_DOWN + 1, SELECT_BITMAP( BMP_INDICATE_DOWN ),
                         String(SchResId(STR_INDICATE_DOWN)));
        aSet.InsertItem( INDICATE_UP + 1, SELECT_BITMAP( BMP_INDICATE_UP ),
                         String(SchResId(STR_INDICATE_UP)));
    }
    else
    {
        aSet.SetItemImage( INDICATE_NONE + 1, SELECT_BITMAP( BMP_INDICATE_NONE ));
        aSet.SetItemImage( INDICATE_BOTH + 1, SELECT_BITMAP( BMP_INDICATE_BOTH ));
        aSet.SetItemImage( INDICATE_DOWN + 1, SELECT_BITMAP( BMP_INDICATE_DOWN ));
        aSet.SetItemImage( INDICATE_UP + 1, SELECT_BITMAP( BMP_INDICATE_UP ));
    }

    if( aRegression.GetItemCount() == 0 )
    {
        aRegression.InsertItem( REGRESSION_NONE + 1, SELECT_BITMAP( BMP_REGRESSION_NONE ),
                                String(SchResId(STR_REGRESSION_NONE)));
        aRegression.InsertItem( REGRESSION_LINE + 1, SELECT_BITMAP( BMP_REGRESSION_LINEAR ),
                                String(SchResId(STR_REGRESSION_LINEAR)));
        aRegression.InsertItem( REGRESSION_LOG + 1, SELECT_BITMAP( BMP_REGRESSION_LOG ),
                                String(SchResId(STR_REGRESSION_LOG)));
        aRegression.InsertItem( REGRESSION_EXP + 1, SELECT_BITMAP( BMP_REGRESSION_EXP ),
                                String(SchResId(STR_REGRESSION_EXP)));
        aRegression.InsertItem( REGRESSION_POW + 1, SELECT_BITMAP( BMP_REGRESSION_POWER ),
                                String(SchResId(STR_REGRESSION_POWER)));
    }
    else
    {
        aRegression.SetItemImage( REGRESSION_NONE + 1, SELECT_BITMAP( BMP_REGRESSION_NONE ));
        aRegression.SetItemImage( REGRESSION_LINE + 1, SELECT_BITMAP( BMP_REGRESSION_LINEAR ));
        aRegression.SetItemImage( REGRESSION_LOG + 1, SELECT_BITMAP( BMP_REGRESSION_LOG ));
        aRegression.SetItemImage( REGRESSION_EXP + 1, SELECT_BITMAP( BMP_REGRESSION_EXP ));
        aRegression.SetItemImage( REGRESSION_POW + 1, SELECT_BITMAP( BMP_REGRESSION_POWER ));
    }
}

void SchDataStatisticsDlg::DataChanged( const DataChangedEvent& rDCEvt )
{
    ModalDialog::DataChanged( rDCEvt );

    if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
        FillValueSets();
}

void SchDataStatisticsDlg::EnableRegression( bool bEnable /* = true */ )
{
    m_bEnableRegression = bEnable;
    Reset();
}

//.............................................................................
} //namespace chart
//.............................................................................
