/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ip_2s.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/01/19 17:56:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_IDL_IP_2S_HXX
#define ARY_IDL_IP_2S_HXX


// USED SERVICES
    // BASE CLASSES
    // COMPONENTS
    // PARAMETERS
#include <ary/stdconstiter.hxx>
#include <ary/idl/i_language.hxx>

namespace csv
{
    class bistream;
}


namespace ary
{
namespace idl
{
namespace alphabetical_index
{
    enum E_Letter
    {
        a = int('a'),
        b,
        c,
        d,
        e,
        f,
        g,
        h,
        i,
        j,
        k,
        l,
        m,
        n,
        o,
        p,
        q,
        r,
        s,
        t,
        u,
        v,
        w,
        x,
        y,
        z,
        non_alpha = int('_'),
        MAX
    };
}

class SecondariesPilot
{
  public:
    // LIFECYCLE
    virtual             ~SecondariesPilot() {}

    // OPERATIONS
    virtual void        CheckAllInterfaceBases(
                            Gate &              i_rGate ) = 0;
    void                Connect_Types2Ces();
    void                Gather_CrossReferences();
    void                Read_Links2DevManual(
                            csv::bstream &      i_file );

    // INQUIRY
    void                Get_AlphabeticalIndex(
                            std::vector<Ce_id> &
                                                o_rResult,
                            alphabetical_index::E_Letter
                                                i_cLetter ) const;
  private:
    virtual void        do_Connect_Types2Ces() = 0;
    virtual void        do_Gather_CrossReferences() = 0;
    virtual void        do_Read_Links2DevManual(
                            csv::bstream &      i_file ) = 0;
    virtual void        inq_Get_AlphabeticalIndex(
                            std::vector<Ce_id> &
                                                o_rResult,
                            alphabetical_index::E_Letter
                                                i_cLetter) const = 0;
};




// IMPLEMENTATION

inline void
SecondariesPilot::Connect_Types2Ces()
    { do_Connect_Types2Ces(); }

inline void
SecondariesPilot::Gather_CrossReferences()
    { do_Gather_CrossReferences(); }

inline void
SecondariesPilot::Read_Links2DevManual( csv::bstream & i_file )
    { do_Read_Links2DevManual(i_file);  }

inline void
SecondariesPilot::Get_AlphabeticalIndex( std::vector<Ce_id> &         o_rResult,
                                         alphabetical_index::E_Letter i_cLetter ) const
    { inq_Get_AlphabeticalIndex(o_rResult, i_cLetter);  }

}   // namespace idl
}   // namespace ary



#endif

