#!/bin/sh


# startskript for helpservers portalconnect
# started from sportald (configuration entry in services section of sportaldrc)

#set -x

VMTYPE=-native
_NAME="helpserver"
_DIR="program"
_MAIN_CLASS="com.sun.star.tools.uno.UnoApp"
_MAIN_JAR="xmlhelp.jar"
_NEEDED_JARS="$_MAIN_JAR jut.jar juh.jar ridl.jar daemons2.jar sandbox.jar java_uno.jar unoil.jar jurt.jar db.jar jaxp.jar xmlsearch.jar parser.jar xt.jar"
THREADS_FLAG=native; export THREADS_FLAG

usage_error() 
{
	echo " "
	echo "usage:"
	echo "  $0     ($_NAME    as foreground process)"
	echo " "
}

java_select()
{
	JAVARC=$sd_inst/share/config/javarc 

	if [ ! -f $JAVARC ] ;then
		echo "Warning: $JAVARC"": file not found"
		if [ -d /usr/java1.2 ]; then
		    JAVA_ROOT="/usr/java1.2"
		fi
	else
		JAVA_ROOT=`$grep Home= $JAVARC|$awk -F= '{print $2;}'`
	fi

	JAVA="$JAVA_ROOT""/bin/java $VMTYPE"
}

find_jar()
{
	if [ -f $sd_bindir/$_JAR ]; then
		_JARF=$sd_bindir/$_JAR
	elif [ -f $sd_bindir/lib/$_JAR ]; then
		_JARF=$sd_bindir/lib/$_JAR
	elif [ -f $sd_bindir/classes/$_JAR ]; then
		_JARF=$sd_bindir/classes/$_JAR
	elif [ -f $sd_inst/program/classes/$_JAR ]; then
		_JARF=$sd_inst/program/classes/$_JAR
	elif [ -f $sd_inst/lib/$_JAR ]; then
		_JARF=$sd_inst/lib/$_JAR
	else
		echo $_JAR": file not found"
	fi
}


classpath()
{
	CP="."
	for jartofind in $_NEEDED_JARS ; do
		_JAR=$jartofind
		find_jar
		CP=$CP":""$_JARF"	
	done;
	CLASSPATH=$CP
	export CLASSPATH
}

env_daemon()
{
    # set search path for shared libraries
    case $sd_platform in
    SunOS)
	LD_LIBRARY_PATH=$sd_inst/program:$sd_inst/lib:$sd_inst/lib/components:.:$LD_LIBRARY_PATH
	export LD_LIBRARY_PATH
	;;
    IRIX*)
	LD_LIBRARYN32_PATH=$sd_inst/program:$sd_inst/lib:$sd_inst/lib/components:.:$LD_LIBRARYN32_PATH
	export LD_LIBRARYN32_PATH
	;;
      *)
	LD_LIBRARY_PATH=$sd_inst/program:$sd_inst/lib:$sd_inst/lib/components:.:$LD_LIBRARY_PATH
	export LD_LIBRARY_PATH
	;;
	esac
}

Server()
{
	java_select
	env_daemon
	classpath

#	echo $CLASSPATH

	_MAIN_ARGS="-smgr '\"-r ""$sd_inst""/program/applicat.rdb, -c 	com.sun.star.help.HelpProvider\"' -u 'uno:portal;urp;HelpProvider' -s 'com.sun.star.help.XMLHelp' -- 0"

	cd ${_DIR}


	exec $JAVA -Dcom.sun.star.help.Directory=$sd_inst/help/ $_MAIN_CLASS -smgr \"-r "$sd_inst"/program/applicat.rdb, -c com.sun.star.help.HelpProvider\" -u "uno:portal;urp;HelpProvider" -s com.sun.star.help.XMLHelp -- 0

	# eval $JAVA -Dcom.sun.star.help.Directory=$sd_inst/help/ $_MAIN_CLASS ${_MAIN_ARGS} $*
}

find_prog() 
{
	if [ -x /usr/bin/${PROG} ]; then
		eval ${PROG}=/usr/bin/${PROG}
	else
		eval ${PROG}=/bin/${PROG}
	fi
}

# try to find some of the programs needed to perform properly
 _PROGRAMS="awk grep cp ln basename dirname rm nohup"
for PROG in ${_PROGRAMS} ;  do
    find_prog
done

# resolve installation directory
sd_platform=`uname -s`
case $sd_platform in
	SCO_SV) test=/bin/test     ;;
  	*)      test=/usr/bin/test ;;
esac
sd_cwd="`pwd`"

if $test -L "$0" ; then
	sd_basename=`$basename $0`
 	sd_script=`ls -l $0 | sed "s/.*${sd_basename} -> //g"` 
else
	sd_script="$0"
fi

cd "`$dirname "$sd_script"`"
sd_script=`$basename $sd_script`
sd_bindir="`pwd`"
if [ -d ../program ]; then
	cd ..
	sd_inst="`pwd`"
else
	sd_inst=$sd_bindir
fi

if [ $# -eq 0 ]; then
	mode="run"
else 
	mode="$1"
	shift
fi

# main dispatch routine
case "$mode" in
'run')
	Server run  $*
	;;
'start_msg')
	;;
*)
	usage_error
	exit 1
	;;
esac

# well done
exit 0




