/*************************************************************************
 *
 *  $RCSfile: rapofflinestoragedatastream.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:58:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPOFFLINESTORAGEDATASTREAM_HXX
#define INCLUDED_UCB_RAPOFFLINESTORAGEDATASTREAM_HXX

#ifndef INCLUDED_UCB_RAPOFFLINESTORAGEERROR_HXX
#include "rapofflinestorageerror.hxx"
#endif

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include "com/sun/star/uno/Sequence.hxx"
#endif
#ifndef _SAL_TYPES_H_
#include "sal/types.h"
#endif
#ifndef _STORE_STORE_HXX_
#include "store/store.hxx"
#endif

namespace com { namespace sun { namespace star { namespace util {
    struct DateTime;
} } } }
namespace rtl { class OUString; }

namespace ucprmt { namespace offline {

class StorageDataStream
{
public:
    inline StorageDataStream(store::OStoreStream const & rStream):
        m_aStream(rStream), m_nOffset(0) {}

    bool readBoolean() SAL_THROW((StorageError)); // not thread safe

    sal_uInt32 readInteger() SAL_THROW((StorageError)); // not thread safe

    com::sun::star::util::DateTime readDateTime() SAL_THROW((StorageError));
        // not thread safe

    rtl::OUString readString() SAL_THROW((StorageError)); // not thread safe

    com::sun::star::uno::Sequence< rtl::OUString > readStrings()
        SAL_THROW((StorageError)); // not thread safe

    void writeBoolean(bool bValue) SAL_THROW((StorageError));
        // not thread safe

    void writeInteger(sal_uInt32 nValue) SAL_THROW((StorageError));
        // not thread safe

    void writeDateTime(com::sun::star::util::DateTime const & rValue)
        SAL_THROW((StorageError)); // not thread safe

    void writeString(rtl::OUString const & rValue) SAL_THROW((StorageError));
        // not thread safe

    void writeStrings(com::sun::star::uno::Sequence< rtl::OUString > const &
                          rValue)
        SAL_THROW((StorageError)); // not thread safe

private:
    store::OStoreStream m_aStream;
    sal_uInt32 m_nOffset;

    void readBuffer(void * pBuffer, sal_uInt32 nSize)
        SAL_THROW((StorageError));

    void writeBuffer(void const * pBuffer, sal_uInt32 nSize)
        SAL_THROW((StorageError));
};

} }

#endif // INCLUDED_UCB_RAPOFFLINESTORAGEDATASTREAM_HXX
