/*************************************************************************
 *
 *  $RCSfile: rapofflinedynamicresultset.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:58:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPOFFLINEDYNAMICRESULTSET_HXX
#include "rapofflinedynamicresultset.hxx"
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include "com/sun/star/lang/XMultiServiceFactory.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_OPENCOMMANDARGUMENT2_HPP_
#include "com/sun/star/ucb/OpenCommandArgument2.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDENVIRONMENT_HPP_
#include "com/sun/star/ucb/XCommandEnvironment.hpp"
#endif
#ifndef _UCBHELPER_RESULTSET_HXX
#include "ucbhelper/resultset.hxx"
#endif
#ifndef _VOS_REF_HXX_
#include "vos/ref.hxx"
#endif

using namespace com::sun;
using ucprmt::offline::DynamicResultSet;

void DynamicResultSet::initStatic()
{}

void DynamicResultSet::initDynamic()
{
    m_xResultSet2 = m_xResultSet1;
}

DynamicResultSet::DynamicResultSet(
    star::uno::Reference< star::lang::XMultiServiceFactory > const &
        rServiceFactory,
    star::ucb::OpenCommandArgument2 const & rArgument,
    star::uno::Reference< star::ucb::XCommandEnvironment > const &
        rEnvironment,
    rtl::Reference< ucb::ResultSetDataSupplier > const & rDataSupplier):
    ResultSetImplHelper(rServiceFactory, rArgument)
{
    m_xResultSet1
        = new ucb::ResultSet(rServiceFactory,
                             rArgument.Properties,
                             vos::ORef< ucb::ResultSetDataSupplier >(
                                 rDataSupplier.get()),
                             rEnvironment);
}
