/*************************************************************************
 *
 *  $RCSfile: instanceprovider.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: sb $ $Date: 2001/02/06 11:11:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCB_MAIN_INSTANCEPROVIDER_HXX_
#include "instanceprovider.hxx"
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif
#ifndef _VOS_DIAGNOSE_H_
#include <vos/diagnose.hxx>
#endif

namespace unnamed_ucb_main_instanceprovider {}
using namespace unnamed_ucb_main_instanceprovider;
	// unnamed namespaces don't work well yet...

using namespace com::sun;
using namespace com::sun::star;
using namespace ucb_main;

//============================================================================
//
//  OneInstanceFactory
//
//============================================================================

namespace unnamed_ucb_main_instanceprovider {

class OneInstanceFactory:
		public cppu::WeakImplHelper1< lang::XMultiServiceFactory >
{
public:
	inline
	OneInstanceFactory(uno::Reference< lang::XMultiServiceFactory > const &
					       rTheFactory,
					   bool bTheInstallUser):
		m_xFactory(rTheFactory), m_bInstallUser(bTheInstallUser) {}

	//========================================================================
	// com::sun::star::lang::XMultiServiceFactory:

    virtual uno::Reference< uno::XInterface > SAL_CALL
	createInstance(rtl::OUString const & rServiceSpecifier)
		throw (uno::Exception, uno::RuntimeException);

    virtual uno::Reference< uno::XInterface > SAL_CALL
	createInstanceWithArguments(rtl::OUString const & rServiceSpecifier,
								uno::Sequence< uno::Any > const & rArguments)
		throw (uno::Exception, uno::RuntimeException);

    virtual uno::Sequence< rtl::OUString > SAL_CALL getAvailableServiceNames()
		throw (uno::RuntimeException);

private:
	uno::Reference< lang::XMultiServiceFactory > m_xFactory;
	bool m_bInstallUser;
};

}

//============================================================================
// virtual
uno::Reference< uno::XInterface > SAL_CALL
OneInstanceFactory::createInstance(rtl::OUString const & rServiceSpecifier)
	throw (uno::Exception, uno::RuntimeException)
{
	if (rServiceSpecifier.
		    equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
				             "com.sun.star.lang.ServiceManager")))
	{
		if (m_bInstallUser)
		{
			// Copy user installation, throwing an exception in case of
			// failure:
			if (!m_xFactory->
				         createInstanceWithArguments(
							 rtl::OUString(
								 RTL_CONSTASCII_USTRINGPARAM(
									 "com.sun.star.portal.InstallUser")),
							 uno::Sequence< uno::Any >(1)).
				     is())
				throw
					uno::RuntimeException(
						rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
							              "Cannot copy user installation")),
						m_xFactory);
					//@@@
			m_bInstallUser = false;
		}
		return m_xFactory;
	}
	else
		return 0;
}

//============================================================================
// virtual
uno::Reference< uno::XInterface > SAL_CALL
OneInstanceFactory::createInstanceWithArguments(
	rtl::OUString const & rServiceSpecifier,
	uno::Sequence< uno::Any > const & rArguments)
	throw (uno::Exception, uno::RuntimeException)
{
	if (rArguments.getLength() == 0)
		return createInstance(rServiceSpecifier);
	else
		return 0;
}

//============================================================================
// virtual
uno::Sequence< rtl::OUString > SAL_CALL
OneInstanceFactory::getAvailableServiceNames()
	throw (uno::RuntimeException)
{
	uno::Sequence< rtl::OUString > aNames(1);
	aNames[0]
		= rtl::OUString::createFromAscii("com.sun.star.lang.ServiceManager");
	return aNames;
}

//============================================================================
//
//  InstanceProvider
//
//============================================================================

InstanceProvider::InstanceProvider(
	uno::Reference< lang::XMultiServiceFactory > const & rTheFactory,
	bool bInstallUser):
	m_xFactory(rTheFactory),
	m_xInitialObject(*new OneInstanceFactory(rTheFactory, bInstallUser))
{}

//============================================================================
// virtual
InstanceProvider::~InstanceProvider() throw ()
{}

//============================================================================
// virtual
uno::Any SAL_CALL InstanceProvider::queryInterface(uno::Type const & rType)
	throw (uno::RuntimeException)
{
	uno::Any
		aRet(cppu::queryInterface(rType,
								  static_cast< bridge::XInstanceProvider * >(
									  this)));
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface(rType);
}

//============================================================================
// virtual
void SAL_CALL InstanceProvider::acquire() throw ()
{
	OWeakObject::acquire();
}

//============================================================================
// virtual
void SAL_CALL InstanceProvider::release() throw ()
{
	OWeakObject::release();
}

//============================================================================
// virtual
uno::Reference< uno::XInterface > SAL_CALL
InstanceProvider::getInstance(rtl::OUString const & rInstanceName)
	throw (container::NoSuchElementException, uno::RuntimeException)
{
	if (rInstanceName.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("UCB.Factory")))
		return m_xInitialObject;
	else if (rInstanceName.
			     equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
					              "com.sun.star.portal.InstallUser")))
		return
			m_xFactory->
			    createInstance(rtl::OUString(
					               RTL_CONSTASCII_USTRINGPARAM(
									   "com.sun.star.portal.InstallUser")));
	else
	{
		VOS_ENSURE(false,
				   "ucb_main::InstanceProvider::getInstance():"
				       " Unknown rInstanceName");
		return 0;
	}
}
