/*************************************************************************
 *
 *  $RCSfile: MemMgr.CXX,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <string.h>
#include <stdio.h>

// -----------------------------------------------------------------------

#include <solar.h>
#include <new.hxx>

// -----------------------------------------------------------------------

#if defined( WNT )
#include "memwnt.cxx"
#elif defined( WIN )
#include "memwin.cxx"
#elif defined( OS2 )
#include "memos2.cxx"
#elif defined( MAC )
#include "memmac.cxx"
#elif defined( UNX )
#include "memunx.cxx"
#endif

// -----------------------------------------------------------------------

#include "MemMgr.hxx"

// -----------------------------------------------------------------------

#ifdef MAC
_NEW_HANDLER		_new_handler;
#endif

/*************************************************************************
|*
|*    ImpDeInitMemMgr()
|*
|*    Beschreibung      Muss aufgerufen werden nachdem main() verlassen werden
|*    Ersterstellung    KH 10.06.95
|*    Letzte Aenderung  WKC 14.08.95
|*
*************************************************************************/

void ImpDeInitMemMgr()
{
	aMemD.bIsInMain = FALSE;
}

/*************************************************************************
|*
|*    set_new_handler()
|*
|*    Beschreibung      Setzt den New-Handler
|*    Ersterstellung    TH 21.07.92
|*    Letzte Aenderung  TH 21.07.92
|*
*************************************************************************/

_NEW_HANDLER set_new_handler( _NEW_HANDLER pHandler )
{
    MemData* pMemData = GetMemData();

    _NEW_HANDLER pOldHandler = _new_handler;
    _new_handler = pHandler;
    return pOldHandler;
}

/*************************************************************************
|*
|*    MemAlloc()
|*
|*    Beschreibung      Speicher anfordern
|*    Ersterstellung    TH 06.09.92
|*    Letzte Aenderung  TH 06.09.92
|*
*************************************************************************/

void* MemAlloc( ULONG nAlloc )
{
    // Ueberschreitet Speicheranforderung die Blockgroesse, dann wird
    // ein globaler Block geholt, der nicht in die Speicherverwaltung
    // aufgenommen wird
    if ( nAlloc >= MEMBLOCK_MAXSIZE )
    {
#ifdef WIN
        // Bei Bloecken kleiner 64 KB geben wir 4 Bytes dazu, da einige
        // Compiler Probleme bei Segementgrenzen haben
        if ( nAlloc < 0xFFFF-4 )
            nAlloc += 4;

        void* p = AllocMemory( nAlloc );

        return p;
#else
        // Speicher anlegen
        void* p = AllocMemory( nAlloc + __STACKALIGNMENT );

        // Pointer als Systemblock markieren
        if ( p )
        {
            p = (void*)(((char*)p) + __STACKALIGNMENT);
            void* pTemp = ((char*)p) - sizeof( USHORT );
            *((USHORT*)pTemp) = MEMBLOCK_SYSBLOCK;
        }

        return p;
#endif
    }
    else
    {
        // n muss >= MEMBLOCK_MINSIZE sein und muss auf 4-Byte Grenze
        // gerundet sein
        size_t n = (size_t)nAlloc;
        if ( n < MEMBLOCK_MINSIZE )
            n = MEMBLOCK_MINSIZE + sizeof( MemBlock );
        else
        {
            // Groesse des Memory-Blocks dazuzaehlen
            n += sizeof( MemBlock );
            n = (n + 3) & ~3;
        }

        MEM_SEMSTART();

        // Suche freien Block
        MemData*    pMemData = GetMemData();
        FreeBlock*  p;
        FreeBlock*  pBlock      = pMemData->pFirstBlock;
        FreeBlock*  pLastBlock  = NULL;
        if ( n < MEMBLOCK_ISLARGE )
        {
            while ( pBlock && (pBlock->nSize < n) )
                pBlock = pBlock->pNext;
        }
        else
        {
            if ( pBlock )
            {
                while ( pBlock->nSize < n )
                {
                    if ( !pBlock->pNext )
                    {
                        pLastBlock = pBlock;
                        pBlock = 0;
                        break;
                    }

                    pBlock = pBlock->pNext;
                }
            }
        }

        // Passender Block vorhanden
        if ( pBlock )
        {
            p = pBlock;

            // Es darf kein Block nachbleiben, der kleiner als MEMBLOCK_MINSIZE ist
            if ( (pBlock->nSize-n) < MEMBLOCK_MINSIZE )
            {
                // Pointer anpassen
                if ( pBlock->pPrev )
                {
                    pBlock->pPrev->pNext = pBlock->pNext;

                    // Prev-Block anpassen
                    if ( pBlock->pNext )
                        pBlock->pNext->pPrev = pBlock->pPrev;
                }
                else
                {
                    pMemData->pFirstBlock = pBlock->pNext;

                    // Prev-Block anpassen
                    if ( pMemData->pFirstBlock )
                        pMemData->pFirstBlock->pPrev = NULL;
                }

                // Daten setzen
                p->nSize |= MEMBLOCK_NOTFREE;
            }
            else
            {
                // Daten vom freien Block anpassen
                pBlock = (FreeBlock*)(((char*)p)+n);
                pBlock->nSize = p->nSize-n;
                pBlock->pNext = p->pNext;
                pBlock->pPrev = p->pPrev;
                pBlock->nPrev = n;
                ((MemBlock*)(((char*)pBlock)+pBlock->nSize))->nPrev = pBlock->nSize;

                // Prev-Block anpassen
                if ( pBlock->pNext )
                    pBlock->pNext->pPrev = pBlock;

                // Pointer anpassen
                if ( pBlock->pPrev )
                    pBlock->pPrev->pNext = pBlock;
                else
                    pMemData->pFirstBlock = pBlock;

                // Daten setzen
                p->nSize = n | MEMBLOCK_NOTFREE;
            }
        }
        else
        {
            // Neuen Block anlegen (Die groesse von einem MemBlock muss
            // dazugerechnet werden, damit letzter Block erkannt werden kann)
            pBlock = (FreeBlock*)AllocMemory( MEMBLOCK_SIZE+sizeof(MemBlock) );

            DBG_MEM_FREESET( pBlock, MEMBLOCK_SIZE+sizeof(MemBlock) );

            if ( !pBlock )
            {
                MEM_SEMEND();
                return NULL;
            }

            // Daten setzen
            p = pBlock;
            p->nPrev = 0;
            p->nSize = n | MEMBLOCK_NOTFREE;

            // Den letzten Block kennzeichnen
            ((MemBlock*)(((char*)pBlock)+MEMBLOCK_SIZE))->nSize = MEMBLOCK_LAST;

            // Den Rest in die Freispeicherliste aufnehmen
            pBlock = (FreeBlock*)(((char*)pBlock)+n);
            pBlock->nSize = MEMBLOCK_SIZE-n;
            pBlock->nPrev = n;

            // Um zu grosse Luecken zu verhindern
            if ( pLastBlock )
            {
                pBlock->pNext     = NULL;
                pBlock->pPrev     = pLastBlock;
                pLastBlock->pNext = pBlock;
            }
            else
            {
                pBlock->pNext           = pMemData->pFirstBlock;
                pBlock->pPrev           = NULL;
                pMemData->pFirstBlock   = pBlock;

                if ( pBlock->pNext )
                    pBlock->pNext->pPrev = pBlock;
            }
        }

        MEM_SEMEND();

        return ((void*)(((char*)p) + sizeof( MemBlock )));
    }
}

/*************************************************************************
|*
|*    operator new()
|*
|*    Beschreibung      new
|*    Ersterstellung    TH 21.07.92
|*    Letzte Aenderung  TH 02.05.95
|*
*************************************************************************/

#if defined( WNT ) && defined( MSC )
void* _cdecl operator new( size_t n )
#else
void* operator new( size_t n )
#endif
{
    return SvMemAlloc( n );
}

#if defined( WIN ) && defined( __BORLANDC__ )
void* operator new( unsigned long n )
{
    return SvMemAlloc( n );
}
#endif

#ifdef __MWERKS__

void* operator new( size_t n ,void* p)
{
    return p;
}

#endif

/*************************************************************************
|*
|*    SvMemAlloc()
|*
|*    Beschreibung      new unter anderem Namen
|*    Ersterstellung    TH 21.07.92
|*    Letzte Aenderung  DV 14.09.95
|*
*************************************************************************/

void* SvMemAlloc( ULONG nBytes, USHORT nFlags )
{
    void* p = DBG_MEM_ALLOC( nBytes );

    if ( !p && !( nFlags & MEM_NOCALLNEWHDL ) )
    {
        while ( 1 )
        {
            // kein Speicher, dann Handler rufen
            if ( !_new_handler )
                break;
            (*_new_handler)();

            p = DBG_MEM_ALLOC( nBytes );

            if ( p )
                break;
        }
    }

    return p;
}

/*************************************************************************
|*
|*    operator delete()
|*
|*    Beschreibung      delete
|*    Ersterstellung    TH 21.07.92
|*    Letzte Aenderung  TH 21.07.92
|*
*************************************************************************/

#if defined( WNT ) && defined( MSC )
void _cdecl operator delete( void* p )
#else
void operator delete( void* p )
#endif
{
    if ( !p )
        return;

    DBG_MEM_FREE( p );

	if (!aMemD.bIsInMain)
		return;

#ifdef WIN
    if ( !OFF( p ) )
    {
        FreeMemory( p );
        return;
    }

    // Pointer anpassen
    p = (void*)(((char*)p) - sizeof( USHORT ));
#else
    // Pointer anpassen
    p = (void*)(((char*)p) - sizeof( USHORT ));

    // Wurde Speicher direkt angefordert
    if ( *((USHORT*)p) == MEMBLOCK_SYSBLOCK )
    {
        p = (void*)(((char*)p) - (__STACKALIGNMENT - sizeof( USHORT )));
        FreeMemory( p );
        return;
    }
#endif

    MEM_SEMSTART();

    // Block freigeben
    p = (void*)(((char*)p) - sizeof( MemBlock ) + sizeof( USHORT ));
    MemData*    pMemData = GetMemData();
    FreeBlock*  pBlock;
    FreeBlock*  pFreeBlock = ((FreeBlock*)p);
    int         bConcat = FALSE;   // Wurde Block zusammengefast

    // Block ist nicht mehr belegt
    pFreeBlock->nSize &= ~MEMBLOCK_NOTFREE;

    // Bloecke zusammenfassen
    if ( pFreeBlock->nPrev )
    {
        FreeBlock* pPrev = (FreeBlock*)(((char*)pFreeBlock)-pFreeBlock->nPrev);
        // Ist Block davor frei
        if ( !(pPrev->nSize & MEMBLOCK_NOTFREE) )
        {
            pPrev->nSize += pFreeBlock->nSize;
            pFreeBlock    = pPrev;

            // Block wurde zusammengefast
            bConcat = TRUE;
        }
    }

    FreeBlock* pNext = (FreeBlock*)(((char*)pFreeBlock)+pFreeBlock->nSize);
    // Ist Block nicht der letzte und der nachfolgende frei
    if ( (pNext->nSize != MEMBLOCK_LAST) && !(pNext->nSize & MEMBLOCK_NOTFREE) )
    {
        // Wenn wir schon zusammenhaengen, muessen wir nichts machen
        if ( bConcat && (pFreeBlock->pNext == pNext) )
        {
            pFreeBlock->nSize += pNext->nSize;
            pFreeBlock->pNext  = pNext->pNext;
        }
        else
        {
            // Wenn Block schon zusammengefast, dann muessen wir diesen
            // Block aus der Verwaltung entfernen
            if ( bConcat )
            {
                if ( pMemData->pFirstBlock == pFreeBlock )
                {
                    pMemData->pFirstBlock = pFreeBlock->pNext;
                    pMemData->pFirstBlock->pPrev = NULL;
                }
                else
                {
                    pBlock = pFreeBlock->pPrev;
                    pBlock->pNext = pFreeBlock->pNext;
                    if ( pBlock->pNext )
                        pBlock->pNext->pPrev = pBlock;
                }
            }

            pFreeBlock->nSize += pNext->nSize;
            pFreeBlock->pNext  = pNext->pNext;

            // Block wurde zusammengefast
            bConcat = TRUE;

            // pNext aus der Verwaltung nehmen
            if ( pMemData->pFirstBlock == pNext )
            {
                pMemData->pFirstBlock = pFreeBlock;
                pFreeBlock->pPrev = NULL;
            }
            else
            {
                pBlock = pNext->pPrev;
                pBlock->pNext = pFreeBlock;
                pFreeBlock->pPrev = pBlock;
            }
        }

        // Prev-Block setzen
        if ( pFreeBlock->pNext )
            pFreeBlock->pNext->pPrev = pFreeBlock;
    }

    if ( pFreeBlock->nSize == MEMBLOCK_SIZE )
    {
        // Block aus der Verwaltung nehmen
        if ( pMemData->pFirstBlock == pFreeBlock )
        {
            pMemData->pFirstBlock = pFreeBlock->pNext;

            // PrevBlock anpassen
            if ( pMemData->pFirstBlock )
                pMemData->pFirstBlock->pPrev = NULL;
        }
        else
        {
            pBlock = pFreeBlock->pPrev;
            pBlock->pNext = pFreeBlock->pNext;

            // PrevBlock anpassen
            if ( pBlock->pNext )
                pBlock->pNext->pPrev = pBlock;
        }

        FreeMemory( pFreeBlock );
    }
    else
    {
        DBG_MEM_FREESET( ((char*)pFreeBlock)+sizeof(FreeBlock),
                         pFreeBlock->nSize-sizeof(FreeBlock) );

        // Ist Block zusammengefast wurden
        if ( bConcat )
        {
            // dann Offset im nachfolgenden Block anpassen
            ((MemBlock*)(((char*)pFreeBlock)+pFreeBlock->nSize))->nPrev = pFreeBlock->nSize;
        }
        else
        {
            // sonst neu in die Liste aufnehmen
            pFreeBlock->pNext = pMemData->pFirstBlock;
            pFreeBlock->pPrev = NULL;
            pMemData->pFirstBlock = pFreeBlock;

            // PrevBlock setzen
            if ( pFreeBlock->pNext )
                pFreeBlock->pNext->pPrev = pFreeBlock;
        }
    }

    MEM_SEMEND();
}

/*************************************************************************
|*
|*    SvMemFree()
|*
|*    Beschreibung      delete unter anderem Namen
|*    Ersterstellung    TH 21.07.92
|*    Letzte Aenderung  TH 02.05.95
|*
*************************************************************************/

void SvMemFree( void* p )
{
    delete p;
}
