/*************************************************************************
 *
 *  $RCSfile: sectctr.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:59:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SCRBAR_HXX
#include <vcl/scrbar.hxx>
#endif

#ifndef _SV_SPLITWIN_HXX
#include <vcl/splitwin.hxx>
#endif

#ifndef _SV_LSTBOX_HXX //autogen wg. ListBox
#include <vcl/lstbox.hxx>
#endif

#include "section.hxx"
#include "sectctr.hxx"

// Constants -------------------------------------------------------------
#define DUMMY_ID (USHORT) (SECTION_APPEND - 1)
#define DUMMY_MINSIZE		100
#define OFFSET_SIZE			10
long gnLineHeight=0;


class ImplSplitWindow: public SplitWindow
{

protected:

	virtual void		MouseButtonDown( const MouseEvent& rMEvt );
	virtual void		MouseMove( const MouseEvent& rMEvt );
	virtual void		Paint( const Rectangle& rRect );
	
public:
	
	ImplSplitWindow( Window* pParent, WinBits nStyle = 0 );
	ImplSplitWindow( Window* pParent, const ResId& rResId );

};

ImplSplitWindow::ImplSplitWindow( Window* pParent, WinBits nStyle):
		SplitWindow(pParent, nStyle)
{
	//Do nothing else
}

ImplSplitWindow::ImplSplitWindow( Window* pParent, const ResId& rResId ):
		SplitWindow(pParent, rResId )
{
	//Do nothing else
}

void ImplSplitWindow::MouseButtonDown( const MouseEvent& rMEvt )
{
	//Do really nothing
}

void ImplSplitWindow::MouseMove( const MouseEvent& rMEvt )
{
	//Do really nothing
}
void ImplSplitWindow::Paint( const Rectangle& rRect )
{
	//Do really nothing
}
	
SvSectionControl::SvSectionControl( Window* pParent,WinBits nStyle):
				Control(pParent,nStyle),
				aSplitWinContainer(this,WB_NOBORDER),
				pSplitWin(NULL),
				pVScrollBar(NULL),
				pHScrollBar(NULL),
				pScrollBarBox(NULL),
				nRealHeight(0),
				nMaxHeight(0),
				nMinWidth(0)
{
	pSplitWin=new ImplSplitWindow(&aSplitWinContainer,WB_NOSPLITDRAW);
	pSplitWin->Show();
	pDummy=new DockingWindow(this);
	pDummy->Disable();
	pSplitWin->InsertItem(DUMMY_ID,pDummy,100,999,0,SWIB_RELATIVESIZE);
	
	BOOL bVScroll=(nStyle & WB_VSCROLL)>0;
	BOOL bHScroll=(nStyle & WB_HSCROLL)>0;
	SetScrollBars(bVScroll,bHScroll);

	aSplitWinContainer.SetPosPixel(Point());
	aSplitWinContainer.SetBackground();
	aSplitWinContainer.SetPaintTransparent(TRUE);
	aSplitWinContainer.Show();
	aWallpaper = Control::GetBackground();
	Control::SetBackground();          
	SetPaintTransparent(TRUE);
	pDummy->SetBackground(aWallpaper);
	pDummy->SetPaintTransparent(FALSE);
	
}
			

SvSectionControl::SvSectionControl( Window* pParent, const ResId& rResId ):
				Control(pParent,rResId),
				aSplitWinContainer(this,WB_NOBORDER),
				pSplitWin(NULL),
				pVScrollBar(NULL),
				pHScrollBar(NULL),
				nRealHeight(0),
				nMaxHeight(0),
				nMinWidth(0)
{
	pSplitWin=new ImplSplitWindow(&aSplitWinContainer,WB_NOSPLITDRAW);
	pSplitWin->SetPosPixel(Point(0,0));
	pSplitWin->Show();
	pDummy=new DockingWindow(this);
	pDummy->Disable();
	pSplitWin->InsertItem(DUMMY_ID,pDummy,100,999,0,SWIB_RELATIVESIZE);	

	WinBits nStyle=GetStyle();
	BOOL bVScroll=(nStyle & WB_VSCROLL)>0;
	BOOL bHScroll=(nStyle & WB_HSCROLL)>0;
	SetScrollBars(bVScroll,bHScroll);

	aSplitWinContainer.SetPosPixel(Point());
	aSplitWinContainer.SetBackground();
	aSplitWinContainer.SetPaintTransparent(TRUE);
	aSplitWinContainer.Show();
	Resize();
	aWallpaper = Control::GetBackground();
	Control::SetBackground();          
	SetPaintTransparent(TRUE);
	pDummy->SetBackground(aWallpaper);
	pDummy->SetPaintTransparent(FALSE);
	
}
						
SvSectionControl::~SvSectionControl()
{
	delete pDummy;
	if(pSplitWin!=NULL) delete pSplitWin;
	if(pVScrollBar!=NULL) delete pVScrollBar;
	if(pHScrollBar!=NULL) delete pHScrollBar;
	if(pScrollBarBox!=NULL) delete pScrollBarBox;
}

void SvSectionControl::Paint( const Rectangle& rRect )
{
	Rectangle aRect(rRect);
	Size aSize=pSplitWin->GetSizePixel();
	long nHeight = aSize.Height();
	if(aRect.Top() < nHeight)
		aRect.Top() = nHeight;

	DrawWallpaper(aRect,aWallpaper );
}
	
void SvSectionControl::SetScrollBars(BOOL bVert,BOOL bHorz)
{
	if(gnLineHeight==0)
	{
		SvExpander aExpander(this);
		Size aSize=aExpander.GetMinSize();
		gnLineHeight=aSize.Height();
	}

	if(bVert)
	{
		if(pVScrollBar==NULL)
		{
			pVScrollBar= new ScrollBar(this);
			pVScrollBar->SetScrollHdl(LINK( this, SvSectionControl, ScrollHdl));
			pVScrollBar->SetEndScrollHdl(LINK( this, SvSectionControl, EndScrollHdl));
			pVScrollBar->SetLineSize(gnLineHeight);
			pVScrollBar->EnableDrag();
		}
	}
	else
	{
		if(pVScrollBar!=NULL)
		{
			delete pVScrollBar;
			pVScrollBar=NULL;
		}
	}

	if(bHorz)
	{
		if(pHScrollBar==NULL)
		{
			pHScrollBar= new ScrollBar(this,WB_HSCROLL);
			pHScrollBar->SetScrollHdl(LINK( this, SvSectionControl, ScrollHdl));

			pHScrollBar->SetLineSize(gnLineHeight);
			pHScrollBar->EnableDrag();
		}
	}
	else
	{
		if(pHScrollBar!=NULL)
		{
			delete pHScrollBar;
			pHScrollBar=NULL;
		}
	}

	if(bHorz && bVert)
	{
		pScrollBarBox = new ScrollBarBox(this);
	}
	else
	{
		delete pScrollBarBox;
		pScrollBarBox = NULL;
	}

}

void SvSectionControl::StateChanged( StateChangedType nStateChange )
{
	if(nStateChange == STATE_CHANGE_STYLE )
	{
		WinBits nStyle=GetStyle();
		BOOL bVScroll=(nStyle & WB_VSCROLL)>0;
		BOOL bHScroll=(nStyle & WB_HSCROLL)>0;
		SetScrollBars(bVScroll,bHScroll);
	}
	Control::StateChanged(nStateChange );
}

void SvSectionControl::UpdateScrollBars()
{
	BOOL bResize=FALSE;
	long nScrollSize = GetSettings().GetStyleSettings().GetScrollBarSize();

	if(pVScrollBar!=NULL)
	{
		Size aSize(pVScrollBar->GetSizePixel());
		if(aSize.Width()!=nScrollSize)
		{
			aSize.Width()=nScrollSize;
			pVScrollBar->SetSizePixel(aSize);
			bResize=TRUE;
		}
	}

	if(pHScrollBar!=NULL)
	{
		Size aSize(pHScrollBar->GetSizePixel());
		if(aSize.Height()!=nScrollSize)
		{
			aSize.Height()=nScrollSize;
			pHScrollBar->SetSizePixel(aSize);
			bResize=TRUE;
		}
	}
	if(bResize) Resize();
}

void SvSectionControl::DataChanged( const DataChangedEvent& rDCEvt )
{
	if( (rDCEvt.GetType()==DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
	{
		UpdateScrollBars();
	}
	Control::DataChanged( rDCEvt );
}

void SvSectionControl::SetPosSizePixel( long nX, long nY,long nWidth, long nHeight,USHORT nFlags)
{
	Control::SetPosSizePixel(nX, nY, nWidth, nHeight, nFlags);
}


void SvSectionControl::Resize()
{
	Size aSize(GetOutputSizePixel());
	Size a2Size(pSplitWin->GetSizePixel());

	if(pHScrollBar!=NULL) 
		HScrollResize(aSize);

	if(pVScrollBar!=NULL) 
		VScrollResize(aSize);
	
	if(pScrollBarBox!=NULL) 
		ShowScrollBarBox();

	aSplitWinContainer.SetSizePixel(aSize);
	aSplitWinContainer.Invalidate(INVALIDATE_NOCHILDREN);
	if(a2Size.Height()!=nMaxHeight || 
		aSize.Width()!=a2Size.Width())
	{
		aSize.Height()=nMaxHeight;
		pSplitWin->SetSizePixel(aSize);
	}

}

void SvSectionControl::ShowScrollBarBox()
{
	Point aPoint;
	
	if(pVScrollBar !=NULL && pHScrollBar!=NULL &&
		pVScrollBar->IsVisible() && pHScrollBar->IsVisible())
	{
		aPoint.X() = pVScrollBar->GetPosPixel().X();
		aPoint.Y() = pHScrollBar->GetPosPixel().Y();
		
		Point aOldPoint= pScrollBarBox->GetPosPixel();

		if(aOldPoint != aPoint)
			pScrollBarBox->SetPosPixel(aPoint);
		
		if(!pScrollBarBox->IsVisible())
			pScrollBarBox->Show();
	}
	else
	{
		if(pScrollBarBox->IsVisible())
			pScrollBarBox->Hide();
	}
}


BOOL SvSectionControl::VScrollResize(Size &aSize)
{
	BOOL bFlag=FALSE;

	if(nRealHeight > aSize.Height())
	{
		long nOldThumbPos = pVScrollBar -> GetThumbPos();
		Size a3Size(pVScrollBar -> GetSizePixel());
		aSize.Width() -= a3Size.Width();
		a3Size.Height() = aSize.Height();
		pVScrollBar -> SetPosSizePixel(Point(aSize.Width(),0),a3Size);
		pVScrollBar -> SetRange(Range(0,nRealHeight+gnLineHeight));
		long nThumbPos = pVScrollBar -> GetThumbPos();
		
		if(nOldThumbPos != nThumbPos)
			pSplitWin -> SetPosPixel(Point(0,-nThumbPos));

		pVScrollBar -> SetPageSize(aSize.Height());
		pVScrollBar -> SetVisibleSize(aSize.Height());
		
		if(!pVScrollBar->IsVisible())
			pVScrollBar -> Show();
	
		bFlag=TRUE;
	}
	else
	{
		Point aPoint(0,0);
		Point aOldPoint = pSplitWin->GetPosPixel();
		if(pVScrollBar->IsVisible())
			pVScrollBar->Hide();
		pVScrollBar->SetThumbPos(0);
		
		if(aOldPoint != aPoint)
			pSplitWin->SetPosPixel(aPoint);
	}
	return bFlag;
}

BOOL SvSectionControl::HScrollResize(Size &aSize)
{
	BOOL bFlag=FALSE;

	if(nMinWidth > aSize.Width())
	{
		long nOldThumbPos = pHScrollBar -> GetThumbPos();

		Size a3Size(pHScrollBar -> GetSizePixel());
		aSize.Height() -= a3Size.Height();
		a3Size.Width() = aSize.Width();
		if(nRealHeight > aSize.Height())
		{
			a3Size.Width()-=pVScrollBar -> GetSizePixel().Width();
		}
		pHScrollBar -> SetPosSizePixel(Point(0,aSize.Height()),a3Size);
		
		pHScrollBar -> SetRange(Range(0,nMinWidth));
		pHScrollBar -> SetPageSize(a3Size.Width());
		pHScrollBar -> SetVisibleSize(a3Size.Width());		

		long nThumbPos = pHScrollBar -> GetThumbPos();

		if(nOldThumbPos != nThumbPos)
			SetChildPos(-nThumbPos,FALSE);

		if(!pHScrollBar->IsVisible())
			pHScrollBar -> Show();

		bFlag=TRUE;
	}
	else
	{
		if(pHScrollBar->IsVisible())
			pHScrollBar ->Hide();
		pHScrollBar ->SetThumbPos(0);
		Point aPos(pSplitWin->GetPosPixel());
		SetChildPos(0,FALSE);
	}
	return bFlag;
}

void SvSectionControl::SetChildPos(long nPos, BOOL bScrolling)
{
	USHORT nCount=GetSectionCount();

	for(USHORT i=0;i<nCount;i++)
	{
		USHORT nId=GetSectionId(i);
		if(nId>0) 
		{
			SvSection* pSection = GetSection(nId);

			if(pSection)
			{
				if(bScrolling)
					pSection->SetScrollPos(nPos);
				else
					pSection->SetChildPos(nPos);
			}
		}
	}
}

long SvSectionControl::CalcMaxHeight()
{
	USHORT nCount=GetSectionCount();

	long nHeight=0;
	for(USHORT i=0;i<nCount;i++)
	{
		USHORT nId=GetSectionId(i);
		if(nId>0) 
		{
			SvSection* pSection=GetSection(nId);
			if(pSection)
				nHeight+=pSection->GetMaxHeight();
		}
	}
	nHeight+=DUMMY_MINSIZE;

	return nHeight;
}

long SvSectionControl::CalcRealHeight()
{
	USHORT nCount=GetSectionCount();

	long nHeight=0;
	for(USHORT i=0;i<nCount;i++)
	{
		USHORT nId=pSplitWin->GetItemId(i);
		if(nId>0)
		{
			nHeight+=pSplitWin->GetItemSize(nId);
		}
	}

	nHeight+= OFFSET_SIZE;
	return nHeight;
}

long SvSectionControl::CalcSectionWidth()
{
	USHORT nCount=GetSectionCount();

	long nWidth=0;
	for(USHORT i=0;i<nCount;i++)
	{
		USHORT nId = pSplitWin->GetItemId(i);
		if(nId>0)
		{
			SvSection* pSection=GetSection(nId );
			if(pSection)
			{
				long nTmpWidth=pSection->GetMinWidth();

				if(nTmpWidth>nWidth)
					nWidth = nTmpWidth;
			}
		}
	}

	return nWidth;
}
	

void SvSectionControl::InsertSection(USHORT nSectionId,SvSection* pSection,long nSize,USHORT nPos)
{
	if(pSection!=NULL)
	{
		USHORT nDummyPos=pSplitWin->GetItemPos(DUMMY_ID);
		if(nPos> nDummyPos) 
		{
			nPos=nDummyPos;
			pSplitWin->InsertItem(nSectionId,pSection,nSize,nPos,0,SWIB_FIXED);
		}
		else //change TabOrder 
		{
			
			USHORT nOldWinId=GetSectionId( nPos );
			Window* pOldWin=GetSection(nOldWinId);
			pSplitWin->InsertItem(nSectionId,pSection,nSize,nPos,0,SWIB_FIXED);
			
			if(pOldWin!=NULL)
			{
			   pSection->SetZOrder(pOldWin, WINDOW_ZORDER_BEFOR);
			}
		}

		pSection->Show();
		pSection->SetSectionID(nSectionId);
		pSection->SetMaxHeight(nSize);
		nRealHeight=CalcRealHeight();
		nMaxHeight=CalcMaxHeight();
		nMinWidth=CalcSectionWidth();
		Resize();
	}
}

void SvSectionControl::InsertSection(USHORT nSectionId,SvSection* pSection,USHORT nPos)
{
	if(pSection!=NULL)
	{
		InsertSection(nSectionId,pSection,pSection->GetMaxHeight(),nPos);
	}
}

void SvSectionControl::RemoveSection( USHORT nSectionId )
{
	pSplitWin->RemoveItem(nSectionId );
	nRealHeight=CalcRealHeight();
	nMaxHeight=CalcMaxHeight();
	nMinWidth=CalcSectionWidth();
	Resize();
	Invalidate();
}
void SvSectionControl::Clear()
{
	pSplitWin->Clear();
	pSplitWin->InsertItem(999,pDummy,100,999,0,SWIB_RELATIVESIZE);
	nRealHeight=0;
	nMaxHeight=0;
	nMinWidth=0;
	Resize();
	Invalidate();
}                     	

void SvSectionControl::SetSectionSize( USHORT nId, long nNewSize )
{
	long nOldSize=pSplitWin->GetItemSize(nId);
	pSplitWin->SetItemSize(nId,nNewSize );
	long nMyNewHeight=CalcRealHeight();
	nMaxHeight=CalcMaxHeight();

	if(nRealHeight < nMyNewHeight)
	{
		nRealHeight=nMyNewHeight;
		long nThumbPos = pVScrollBar -> GetThumbPos();
		pVScrollBar -> SetRange(Range(0,nMyNewHeight+gnLineHeight));
		pVScrollBar -> SetThumbPos(nThumbPos);
		Resize();
	}
	else if(pVScrollBar)
	{
		long nMax = nMyNewHeight + gnLineHeight;
		long nThumbPos = pVScrollBar -> GetThumbPos();
		long nVisSize=pVScrollBar -> GetVisibleSize();
		if(nMax < nVisSize + nThumbPos)
			nMax = nVisSize + nThumbPos;
		pVScrollBar -> SetRange(Range(0,nMax));
		pVScrollBar -> SetThumbPos(nThumbPos);
	}
}                     	

long SvSectionControl::GetSectionSize( USHORT nId ) const
{
	return pSplitWin->GetItemSize(nId);
}

void SvSectionControl::SetSectionWidth( USHORT nId, long nWidth)
{
	if(nId>0)
	{
		SvSection* pSection=GetSection(nId);
		if(pSection)
			pSection->SetMinWidth(nWidth);

		nMinWidth=CalcSectionWidth();
	}
}
long SvSectionControl::GetSectionWidth( USHORT nId) const
{
	long nWidth=0;
	if(nId>0)
	{
		SvSection* pSection=GetSection(nId);
		if(pSection)
			nWidth=pSection->GetMinWidth();
	}
	return nWidth;
}

USHORT SvSectionControl::GetSectionCount() const
{
	return pSplitWin->GetItemCount()-1;
}

USHORT SvSectionControl::GetSectionId( USHORT nPos ) const
{
	USHORT nSectionId = pSplitWin->GetItemId(nPos);
	if(nSectionId == DUMMY_ID) nSectionId = 0;
	return nSectionId;
}

USHORT SvSectionControl::GetSectionPos( USHORT nSectionId ) const
{                       
	return pSplitWin->GetItemPos(nSectionId );
}                       
USHORT SvSectionControl::GetSectionId( const Point& rPos ) const
{  
	Point aPos(rPos);
	aPos -= pSplitWin->GetPosPixel();

	USHORT nSectionId = pSplitWin->GetItemId(aPos);
	if(nSectionId == DUMMY_ID) nSectionId = 0;

	return nSectionId;
}                       

SvSection* SvSectionControl::GetSection( USHORT nSectionId ) const
{
	return (SvSection*)pSplitWin->GetItemWindow(nSectionId);
}

void SvSectionControl::SetSectionText( USHORT nSectionId, const XubString& rText )
{
	SvSection* pSection=(SvSection*)pSplitWin->GetItemWindow(nSectionId);
	pSection->SetSectionText(rText );
}
XubString SvSectionControl::GetSectionText( USHORT nSectionId ) const
{
	SvSection* pSection=(SvSection*)pSplitWin->GetItemWindow(nSectionId);
	return pSection->GetSectionText();
}

void SvSectionControl::SetHelpText( USHORT nSectionId, const XubString& rText )
{
	SvSection* pSection=(SvSection*)pSplitWin->GetItemWindow(nSectionId);
	pSection->SetHelpText(rText);
}
const XubString& SvSectionControl::GetHelpText( USHORT nSectionId ) const
{
	SvSection* pSection=(SvSection*)pSplitWin->GetItemWindow(nSectionId);
	return pSection->GetHelpText();
}

void SvSectionControl::SetHelpId( USHORT nSectionId, ULONG nHelpId )
{
	SvSection* pSection=(SvSection*)pSplitWin->GetItemWindow(nSectionId);
	pSection->SetHelpId(nHelpId );
}
ULONG SvSectionControl::GetHelpId( USHORT nSectionId ) const
{
	SvSection* pSection=(SvSection*)pSplitWin->GetItemWindow(nSectionId);
	return pSection->GetHelpId();
}

long SvSectionControl::KeyEventNotify( const KeyEvent& rKEvt )
{
	long nRes = FALSE;

	KeyCode aKeyCode = rKEvt.GetKeyCode();
	USHORT	nKeyCode = aKeyCode.GetCode();

	if ( aKeyCode.IsMod1() )
	{
		if(pVScrollBar && pVScrollBar->IsVisible())
		{
			switch (nKeyCode)
			{
				case KEY_HOME:
					nRes = TRUE;
					pVScrollBar->DoScroll( 0 );
					break;

				case KEY_END:
					nRes = TRUE;
					pVScrollBar->DoScroll( pVScrollBar->GetRangeMax() );
					break;

				case KEY_UP:
					nRes = TRUE;
					pVScrollBar->DoScrollAction( SCROLL_LINEUP );
					break;

				case KEY_DOWN:
					nRes = TRUE;
					pVScrollBar->DoScrollAction( SCROLL_LINEDOWN );
					break;
			}
		}
		if(pHScrollBar && pHScrollBar->IsVisible())
		{
			switch (nKeyCode)
			{
				case KEY_HOME:
					nRes = TRUE;
					pHScrollBar->DoScroll( 0 );
					break;
				case KEY_END:
					nRes = TRUE;
					pHScrollBar->DoScroll( pHScrollBar->GetRangeMax() );
					break;
			}
		}
	}
	else if ( aKeyCode.IsMod2() )
	{
		if(pHScrollBar && pHScrollBar->IsVisible())
		{
			switch (nKeyCode)
			{
					case KEY_LEFT:
					nRes = TRUE;
					pHScrollBar->DoScrollAction( SCROLL_LINEUP );
					break;
				case KEY_RIGHT:
					nRes = TRUE;
					pHScrollBar->DoScrollAction( SCROLL_LINEDOWN );
					break;
			}
		}
	}
	else
	{
		switch (nKeyCode)
		{
			case KEY_PAGEUP:
				nRes = TRUE;
				pVScrollBar->DoScrollAction( SCROLL_PAGEUP );
				break;

			case KEY_PAGEDOWN:
				nRes = TRUE;
				pVScrollBar->DoScrollAction( SCROLL_PAGEDOWN );
				break;
		}
	}

	return nRes;
}
	
long SvSectionControl::PreNotify( NotifyEvent& rNEvt )
{	
	long	nRes = FALSE;
		
	if(rNEvt.GetType() == EVENT_COMMAND)
	{
		const CommandEvent* pCEvt = rNEvt.GetCommandEvent();
			
		Command( *pCEvt);
		nRes = TRUE;
	}
	

	if(!nRes)
	{
		nRes = Control::PreNotify(rNEvt );
	}
	return nRes;

}

long SvSectionControl::Notify( NotifyEvent& rNEvt )
{	
	long	nRes = FALSE;
		
	if(rNEvt.GetType() == EVENT_KEYINPUT)
	{
		const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
		
		nRes = KeyEventNotify(*pKEvt);

	}

	if(!nRes)
	{
		nRes = Control::Notify(rNEvt );
	}
	return nRes;

}

void SvSectionControl::Command( const CommandEvent& rCEvt )
{
	if( (rCEvt.GetCommand() == COMMAND_HWHEEL) ||
		(rCEvt.GetCommand() == COMMAND_STARTAUTOSCROLL) ||
		(rCEvt.GetCommand() == COMMAND_AUTOSCROLL) )
	{

		ScrollBar* pHScrl = NULL;
		ScrollBar* pVScrl = NULL;

		if(pVScrollBar && pVScrollBar->IsVisible())
			pVScrl=pVScrollBar;
		if(pHScrollBar && pHScrollBar->IsVisible())
			pHScrl=pHScrollBar;

		HandleScrollCommand( rCEvt,pHScrl, pVScrl);
	}
	else Control::Command( rCEvt );
}

IMPL_LINK( SvSectionControl, ScrollHdl, ScrollBar*,pSb)
{
	if(pSb!=NULL)
	{
		long nThumbPos = pSb->GetThumbPos();

		if(pHScrollBar!=pSb)
		{
			long nDelta=pVScrollBar->GetDelta();
			aSplitWinContainer.Scroll(0,-nDelta,SCROLL_CHILDREN);
			//pSplitWin->SetPosPixel(Point(0,-nThumbPos));
		}
		else
			SetChildPos(-nThumbPos);
	}
	return 0;
}

IMPL_LINK( SvSectionControl, EndScrollHdl, ScrollBar*,pSb)
{
	if(pSb!=NULL)
	{
		long nThumbPos = pSb->GetThumbPos();

		if(pHScrollBar!=pSb)
		{
			if(nThumbPos==0)
			{
				nRealHeight= CalcRealHeight();
				Resize();
			}
		}
	}
	return 0;
}


