#*************************************************************************
#
#   $RCSfile: test.pl,v $
#
#   $Revision: 1.2 $
#
#   last change: $Author: hr $ $Date: 2001/06/18 14:33:22 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc..
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..5\n"; }
END {print "not ok 1\n" unless $loaded;}
use GenInfoParser;
$loaded = 1;
print "ok 1\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

# ok let's do some very simple minded tests

# Test 2
# load test data
$a = GenInfoParser->new();
print $a->load_list("test.data") ? "ok 2\n" : "not ok 2\n";

# Test 3
# get key/value pair
$key    = $a->get_key('item1/subitem11/key112');
$value  = $a->get_value('item1/subitem11/key112');
$success = ($key eq 'KEY112' && $value eq 'value112');
print $success ? "ok 3\n" : "not ok 3\n";

# Test 4
# get list of top level keys
@keys = $a->get_keys();
$success = 1;
$i = 0;
foreach $item (@keys) {
    $i++;
    $success = 0 if ( $item ne "ITEM$i" );
}
print $success ? "ok 4\n" : "not ok 4\n";

# Test 4
# get list of sub list keys
@keys = $a->get_keys('item1/subitem12');
$success = 1;
$i = 0;
foreach $item (@keys) {
    $i++;
    $success = 0 if ( $item ne "KEY12$i" );
}
print $success ? "ok 5\n" : "not ok 5\n";

# do some tests on "stand.lst"
#$b = GenInfoParser->new();
#print $b->load_list("stand.lst") ? "ok 2\n" : "not ok 2\n" ;
#print $b->get_key('src633/Comment/Build') . " " . $b->get_value('src633/Comment/Build');
#print "\n";
#print join("\n", $b->get_keys()) . "\n";
#print join("\n", $b->get_keys('src633/Drives/o:/Projects')) . "\n";

