#!/usr/solar/bin/perl -w
# convert workfilenames in pvcs files to lowercase 


opendir WD, ".";

while ($file = readdir WD) {
	($file =~ /\w\.c$/i) && (push @files, $file) && next;
	($file =~ /\w\.h$/i) && (push @files, $file) && next;
	($file =~ /\w\.cxx$/i) && (push @files, $file) && next;
	($file =~ /\w\.hxx$/i) && (push @files, $file) && next;
	($file =~ /\w\.hrc$/i) && (push @files, $file) && next;
	($file =~ /\w\.src$/i) && (push @files, $file) && next;
	($file =~ /\w\.rc$/i) && (push @files, $file) && next;
	($file =~ /\w\.sdi$/i) && (push @files, $file) && next;
	($file =~ /\w\.idl$/i) && (push @files, $file) && next;
	($file =~ /\w\.pmk$/i) && (push @files, $file) && next;
	($file =~ /\w\.bmp$/i) && (push @files, $file) && next;
	($file =~ /\w\.ico$/i) && (push @files, $file) && next;
	($file =~ /\w\.lst$/i) && (push @files, $file) && next;
	($file =~ /makefile\.mk$/i) && (push @files, $file) && next;
}

foreach $file (@files) {
	print "vlog $file";
	open(VLOG, "vlog $file |") or die "can't vlog $file";
	while (<VLOG>) {
		$line = $_;
		if ( $line =~ /^Workfile:\s+(\w+\.\w*)/ ) {
			$tmp = $1;
			if ( $tmp =~ /[A-Z]/ ) {
				push @workfiles, lc($tmp);
				print "\t\t... found $tmp\n"; 
			} else {
				print "\n";
			}
			last;
		}
	}
	close(VLOG);
}

foreach $file (@workfiles) {
	print "vcs -W$file $file\n";
	system("vcs -W$file $file");
} 
exit(0);
