/*************************************************************************
 *
 *  $RCSfile: progind.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: th $ $Date: 2001/05/11 11:44:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <vcl/decoview.hxx>
#include <vos/mutex.hxx>

using namespace vos;

#pragma hdrstop

#include "progind.hxx"
#include "app.hxx"
#include "sfxuno.hxx"
#include "helpid.hrc"

SfxPopupStatusIndicator::SfxPopupStatusIndicator( Window* pParent )
    : Window( pParent )
    , aTextBar( this , WB_3DLOOK )
    , aProgressBar( this, WB_STDPROGRESSBAR )
{
    aTextBar.SetUniqueId( HID_STATUSINDICATOR_TEXT );
    aProgressBar.SetUniqueId( HID_STATUSINDICATOR_PROGRESS );
    pInterface = new SfxStatusInd_Impl;
    pInterface->acquire();
    pInterface->pWindow = this;
    SetBackground();
    Size aSize = aTextBar.CalcMinimumSize();
    aSize.Width() = 0;
    aTextBar.SetSizePixel( aSize );
    aProgressBar.SetSizePixel( aSize );
    Point aPos( aTextBar.GetPosPixel() );
    aPos.X() = 2;
    aPos.Y() = 2;
    aTextBar.SetPosPixel( aPos );
    aPos.Y() += aSize.Height();
    aProgressBar.SetPosPixel( aPos );
    aTextBar.Show();
    SetSizePixel( CalcWindowSizePixel() );
}

SfxPopupStatusIndicator::~SfxPopupStatusIndicator()
{
    pInterface->pWindow = NULL;
    pInterface->release();
}

void SfxPopupStatusIndicator::Paint( const Rectangle& rRect )
{
    Point aPoint;
    Rectangle aRect( aPoint, GetSizePixel() );
    USHORT nStyle = BUTTON_DRAW_FLAT;
    nStyle |= BUTTON_DRAW_NOTOPLIGHTBORDER;

    DecorationView(this).DrawButton( aRect, nStyle );
}

void SfxPopupStatusIndicator::Resize()
{
    Size aSize( GetOutputSizePixel() );
    aTextBar.SetPosSizePixel( 0, 0, aSize.Width(), 0, WINDOW_POSSIZE_WIDTH );
    aProgressBar.SetPosSizePixel( 0, 0, aSize.Width(), 0, WINDOW_POSSIZE_WIDTH );
}

Size SfxPopupStatusIndicator::CalcWindowSizePixel()
{
    Size aSize( GetSizePixel() );
    aSize.Height() = aTextBar.GetSizePixel().Height();
    if ( aProgressBar.IsVisible() )
        aSize.Height() += aProgressBar.GetSizePixel().Height();
    aSize.Height() += 4;
    aSize.Width() += 4;
    return aSize;
}

void SfxPopupStatusIndicator::MakeVisible( BOOL bVis )
{
    if ( bVis )
    {
        SetSizePixel( CalcWindowSizePixel() );
        Show();
    }
    else
    {
        Hide();
    }

    GetParent()->Resize();
}

// -----------------------------------------------------------------------
/* ASDBG
void* SfxStatusInd_Impl::getImplementation(Reflection* pRef)
{
    return UsrObject::getImplementation(pRef);
}
*/
// -----------------------------------------------------------------------

SfxStatusInd_Impl::SfxStatusInd_Impl()
    : pWindow( 0 )
    , nRange( 0 )
    , nValue( 0 )
    , nProgressCount( 0 )
{
}
/* ASDBG
// -----------------------------------------------------------------------
BOOL SfxStatusInd_Impl::queryInterface( UsrUik aUIK, XInterfaceRef& xRet )
{
    if ( aUIK == XStatusIndicator::getSmartUik() )
        xRet = (XStatusIndicator*)this;
    else
        return UsrObject::queryInterface( aUIK, xRet );
    return xRet.is();
}
*/
// -----------------------------------------------------------------------
void SfxStatusInd_Impl::start(const ::rtl::OUString& aText, INT32 nRng) throw ( ::com::sun::star::uno::RuntimeException )
{
    if ( pWindow )
    {
        OGuard aGuard( Application::GetSolarMutex() );
        nProgressCount++;
        nRange = nRng;
        pWindow->aTextBar.SetText( aText );
        if ( nRng )
        {
            pWindow->aProgressBar.Show();
        }

        if ( !pWindow->IsVisible() )
            pWindow->MakeVisible( TRUE );
        else
        {
            pWindow->SetSizePixel( pWindow->CalcWindowSizePixel() );
            pWindow->GetParent()->Resize();
        }
    }
}

// -----------------------------------------------------------------------
void SfxStatusInd_Impl::end(void) throw ( ::com::sun::star::uno::RuntimeException )
{
    if ( pWindow )
    {
        OGuard aGuard( Application::GetSolarMutex() );
        if ( nProgressCount )
            nProgressCount--;
        else
            DBG_WARNINGFILE( "W1: invalid prgress count" );
    }

    reset();
}

// -----------------------------------------------------------------------
void SfxStatusInd_Impl::setText(const ::rtl::OUString& aText) throw ( ::com::sun::star::uno::RuntimeException )
{
    if ( pWindow )
    {
        OGuard aGuard( Application::GetSolarMutex() );
        if ( !pWindow->IsVisible() )
            pWindow->MakeVisible( TRUE );

        pWindow->aTextBar.SetText( aText );
    }

    if ( !aText.getLength() )
        reset();
}

// -----------------------------------------------------------------------
void SfxStatusInd_Impl::setValue(INT32 nVal) throw ( ::com::sun::star::uno::RuntimeException )
{
    if ( pWindow )
    {
        OGuard aGuard( Application::GetSolarMutex() );
        nValue = nVal;
        long nPercent = nRange ? (USHORT)(nValue * 100L / nRange) : 0;
        pWindow->aProgressBar.SetValue( nPercent );
    }
}

void SfxStatusInd_Impl::reset() throw ( ::com::sun::star::uno::RuntimeException )
{
    if ( pWindow )
    {
        OGuard aGuard( Application::GetSolarMutex() );
        if ( !nProgressCount )
        {
            pWindow->MakeVisible( FALSE );
            pWindow->aProgressBar.Hide();
        }
    }
}


