/*************************************************************************
 *
 *  $RCSfile: filehelper.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: tra $ $Date: 2001/12/05 14:34:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
 
#ifndef _FILEHELPER_HXX_
#define _FILEHELPER_HXX_

#include <osl/file.h>
#include <osl/file.hxx>
#include <rtl/ustring.hxx>
#include <rtl/byteseq.h>
#include <vector>
#include "config.hxx"
#include <algorithm>

//--------------------------------------------
// writes a line into the given file, the file
// must have been opened with write access
//--------------------------------------------

osl::FileBase::RC fileWriteLine( osl::File& aFile, const rtl::OString& aLine );

//--------------------------------------------
// read the next line from the given file
// the file must have been opened with read 
// access
//--------------------------------------------

osl::FileBase::RC fileReadLine( osl::File& aFile, rtl::OString& aLine );

//--------------------------------------------
//
//--------------------------------------------

void fileReadAllLines( osl::File& aFile, OStringList_t& aLineBuffer );

//--------------------------------------------
// reads a single byte character from the given
// file, the file must have been opened with
// read access
//--------------------------------------------

osl::FileBase::RC fileRead( osl::File& aFile, sal_Char* pChar );

//--------------------------------------------
// writes a single byte character to the given
// file, the file must have been opened with
// write access
//--------------------------------------------

osl::FileBase::RC fileWrite( osl::File& aFile, sal_Char aByteChar );

//--------------------------------------------
// appends a single line to the given file,
// the file must have been opened with write
// access
//--------------------------------------------

osl::FileBase::RC fileWrite( osl::File& aFile, const OStringList_t& aListOfLines );

//--------------------------------------------
// appends a mumber of lines to the given file
// the file must have been opened with write
// access
//--------------------------------------------

osl::FileBase::RC fileAppendLine( osl::File& aFile, const rtl::OString& aLines );

//--------------------------------------------
//
//--------------------------------------------

void fileAppendLines( osl::File& aFile, const OStringList_t& aListOfLines );

//--------------------------------------------
// sets the file pointer of the given file to
// the start of the file, the given file must 
// be open
//--------------------------------------------

osl::FileBase::RC fileSetStartPos( osl::File& aFile );

//--------------------------------------------
// sets the file pointer of the given file to
// the end of the file, the given file must be
// open
//--------------------------------------------

osl::FileBase::RC fileSetEndPos( osl::File& aFile );

//--------------------------------------------
// tries to open the given file, if the file
// doesn't exist, the function tries to 
// create it
//--------------------------------------------

osl::FileBase::RC fileEnsureOpen( osl::File& aFile, sal_uInt32 uFlags );

//--------------------------------------------
// ensures that there is a trailing line end
// character at the end of the given file
// if there isn't the function appends one,
// the file must have been opened with write
// access
//--------------------------------------------

void fileEnsureTrailingLineEnd( osl::File& aFile );

//---------------------------------------------
// completly replaces the curent content of the
// given file with a new content, the file must
// have been opened with write access
//---------------------------------------------

osl::FileBase::RC fileReplaceContent( osl::File& aFile, const OStringList_t& aNewContent );

//---------------------------------------------
// a simple functor class for stl for_each algo
//---------------------------------------------

class FileWriteHelper
{
public:
    FileWriteHelper( osl::File& aFile ) : 
        m_rFile( aFile )
    { }

    void operator() ( const rtl::OString& aLine )
    { fileWriteLine( m_rFile, aLine ); }
    
private:
    osl::File& m_rFile;
};

//---------------------------------------------
// a simple functor class for stl remove_if algo
//---------------------------------------------

class FileRemoveEntryHelper
{
public:
    FileRemoveEntryHelper( const OStringList_t& aListOfRemoveableLines ) :
        m_RemoveableLines(aListOfRemoveableLines),
        m_iter_begin(m_RemoveableLines.begin()),
        m_iter_end(m_RemoveableLines.end())
    { }

    bool operator() ( const rtl::OString& aLine )
    {
        OStringList_t::const_iterator iter = 
            std::find( m_iter_begin, m_iter_end, aLine.trim() );
        return ( iter != m_iter_end );
    }

private:
    const OStringList_t& m_RemoveableLines;
    OStringList_t::const_iterator m_iter_begin;
    OStringList_t::const_iterator m_iter_end; 
};

#endif
