/*************************************************************************
 *
 *  $RCSfile: filehelper.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: tra $ $Date: 2001/12/05 14:34:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
 
#ifndef _FILEHELPER_HXX_
#include "filehelper.hxx"
#endif

#include <osl/diagnose.h>

//---------------------------------------
// namespace directives 
//---------------------------------------

using namespace osl;
using namespace rtl;

//--------------------------------------------
// const
//--------------------------------------------

const sal_Char UNIX_LINE_END = '\n';

//--------------------------------------------
//
//--------------------------------------------

FileBase::RC fileWriteLine( File& aFile, const OString& aLine )
{
    sal_uInt64 nBytesWritten;

    FileBase::RC rc = aFile.write( 
        aLine.getStr( ), 
        aLine.getLength( ), 
        nBytesWritten );

    if ( FileBase::E_None == rc )
        rc = fileWrite( aFile, UNIX_LINE_END );

    return rc;
}

//--------------------------------------------
//
//--------------------------------------------

FileBase::RC fileReadLine( File& aFile, OString& aLine )
{
    ByteSequence aByteSeq;    
    FileBase::RC rc = aFile.readLine( aByteSeq );

    if ( FileBase::E_None == rc )
        aLine = OString( (sal_Char*)aByteSeq.getArray( ), aByteSeq.getLength( ) );
        
    return rc;
}

//--------------------------------------------
//
//--------------------------------------------

void fileReadAllLines( File& aFile, OStringList_t& aLineBuffer )
{
    aLineBuffer.clear();
    
    sal_Bool bEOF;
    OString aLine;
    
    while ( FileBase::E_None == aFile.isEndOfFile( &bEOF ) && !bEOF )
    {
        fileReadLine( aFile, aLine );
        aLineBuffer.push_back( aLine );
    }
}

//--------------------------------------------
// reads a byte char from the current file
// position
//--------------------------------------------

FileBase::RC fileRead( File& aFile, sal_Char* pChar )
{
    OSL_PRECOND( pChar, "invalid argument" );
    
    sal_uInt64 nBytesRead;
    return aFile.read( pChar, sizeof( sal_Char ), nBytesRead );
}

//--------------------------------------------
// writes a byte char to the current file
// position
//--------------------------------------------

FileBase::RC fileWrite( File& aFile, sal_Char aByteChar )
{
    sal_uInt64 nBytesWritten;
    return aFile.write( &aByteChar, sizeof( sal_Char ), nBytesWritten );
}

//--------------------------------------------
//
//--------------------------------------------

FileBase::RC fileWrite( File& aFile, const OStringList_t& aListOfLines )
{        
    std::for_each( aListOfLines.begin(), aListOfLines.end(), FileWriteHelper(aFile) );
    return FileBase::E_None;
}

//--------------------------------------------
//
//--------------------------------------------

FileBase::RC fileAppendLine( File& aFile, const OString& aLine )
{
    FileBase::RC rc = fileSetEndPos( aFile );

    if ( FileBase::E_None == rc )
        rc = fileWriteLine( aFile, aLine );

    return rc;
}

//--------------------------------------------
//
//--------------------------------------------

void fileAppendLines( File& aFile, const OStringList_t& aListOfLines )
{
    FileBase::RC rc = fileSetEndPos( aFile );
    std::for_each( aListOfLines.begin(), aListOfLines.end(), FileWriteHelper(aFile) );
}

//--------------------------------------------
// go to the end of file (behind the last 
// character)
//--------------------------------------------

FileBase::RC fileSetEndPos( File& aFile )
{
    return aFile.setPos( Pos_End, 0 );
}

//--------------------------------------------
// go to the start of the file 
//--------------------------------------------

FileBase::RC fileSetStartPos( File& aFile )
{
    return aFile.setPos( Pos_Absolut, 0 );
}

//--------------------------------------------
//
//--------------------------------------------

FileBase::RC fileEnsureOpen( File& aFile, sal_uInt32 uFlags )
{
    FileBase::RC rc = aFile.open( uFlags );
        
    if ( FileBase::E_NOENT == rc )
        rc = aFile.open( OpenFlag_Create | uFlags );

    return rc;
}

//--------------------------------------------
//
//--------------------------------------------

void fileEnsureTrailingLineEnd( File& aFile )
{
    FileBase::RC rc = aFile.setPos( Pos_End, -1 );
    
    if ( FileBase::E_None == rc )
    {
        sal_Char chLast;        
        rc = fileRead( aFile, &chLast );

        if ( FileBase::E_None == rc && chLast != UNIX_LINE_END )
        {
            OString aLine( "" );
            rc = fileAppendLine( aFile, aLine );
        }
    }
}

//--------------------------------------------
//
//--------------------------------------------

FileBase::RC fileReplaceContent( File& aFile, const OStringList_t& aNewContent )
{
    FileBase::RC rc = aFile.setSize( 0 );

    if ( FileBase::E_None == rc && FileBase::E_None == fileSetStartPos( aFile ) )
        rc = fileWrite( aFile, aNewContent );

    return rc;
}

