/*************************************************************************
 *
 *  $RCSfile: script.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:07:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "script.hxx"
#include "compiler.hxx"
#include "fields.hxx"
#include "environ.hxx"

#if defined(MAC)
#define OREG_INI		"oreg.prefs"
#else
#define OREG_INI		"oreg.ini"
#endif

#if defined(MAC)
#define SOFFICE_INI		"soffice.prefs"
#elif defined(UNX)
#define SOFFICE_INI		"sofficerc"
#else
#define SOFFICE_INI		"soffice.ini"
#endif

// IMPLEMENT_HASHTABLE_OWNER(DeclaratorSet,ByteString,SiDeclarator*)

DECLARE_HASHTABLE_ITERATOR(DeclaratorSetIt,SiDeclarator*)

SiCompiledScript::SiCompiledScript()
{
	m_pDeclarators  = new DeclaratorSet(2117);
	m_pInstallation = NULL;
    m_pRootModule	= NULL;
	m_bUncomplete	= FALSE;
	m_pInstallInfo  = NULL;
	m_pSetup		= NULL;
	m_pCompiledHelp = NULL;
	m_pOfficeINI	= NULL;
	m_pORegINI		= NULL;
	m_pServerINI	= NULL;

	m_bBindUnlinked = TRUE;
	m_bSecondLevel	= FALSE;
	m_bWriteScpAction = FALSE;
}

SiCompiledScript::~SiCompiledScript()
{
	DeclaratorSetIt  Iterator(*m_pDeclarators);

	m_HelpTextLst.Clear();

	for (SiDeclarator
	    *pDeclarator  = Iterator.GetFirst()
	  ;  pDeclarator != NULL
	  ;  pDeclarator  = Iterator.GetNext())
	{
		delete pDeclarator;
	}
	delete m_pDeclarators;

	if( m_pCompiledHelp )
		delete m_pCompiledHelp;

	for( USHORT i = 0; i < m_ExplicitUNORegList.Count(); i++ )
		delete m_ExplicitUNORegList.GetObject(i);
	m_ExplicitUNORegList.Clear();
}

void SiCompiledScript::RemoveDeclarator(const ByteString& rID)
{
	m_pDeclarators->Delete( rID );
}

SiDeclarator* SiCompiledScript::FindProcedureByName(ByteString const& aName) const
{
	DeclaratorSetIt  Iterator(*m_pDeclarators);
	for( SiDeclarator* pDeclarator = Iterator.GetFirst();
		 pDeclarator != NULL;
		 pDeclarator = Iterator.GetNext() )
	{
		SiProcedure* pProc = PTR_CAST(SiProcedure,pDeclarator);
		if( pProc != NULL && (pProc->GetProcName() == aName) )
			return pProc;
	}
	return NULL;
}

SiProcedure* SiCompiledScript::FindPreSelectProc() const
{
	DeclaratorSetIt  Iterator(*m_pDeclarators);
	for( SiDeclarator* pDeclarator = Iterator.GetFirst();
		 pDeclarator != NULL;
		 pDeclarator = Iterator.GetNext() )
	{
		SiProcedure* pProc = PTR_CAST(SiProcedure,pDeclarator);
		if( pProc != NULL && pProc->IsPreSelectProc() )
			return pProc;
	}
	return NULL;
}

SiProcedure* SiCompiledScript::FindLanguageSelectProc() const
{
	DeclaratorSetIt  Iterator(*m_pDeclarators);
	for( SiDeclarator* pDeclarator = Iterator.GetFirst();
		 pDeclarator != NULL;
		 pDeclarator = Iterator.GetNext() )
	{
		SiProcedure* pProc = PTR_CAST(SiProcedure,pDeclarator);
		if( pProc != NULL && pProc->IsLanguageSelectProc() )
			return pProc;
	}
	return NULL;
}

BOOL SiCompiledScript::Add(SiDeclarator* pDec, SiCompiler* pCompiler)
// pre:  pDec befindet sich nicht im Script
// post: 1. pDec befindet sich im Script
//		 2. Abhaengige Objekte wurden an die Objekte gehaengt,
//			von denen sie abhaengen.
{
    // Wenn NULL als Fehler von Insert() zurckkommt, war der Identifier
    // schon vorhanden.
    //
    if (m_pDeclarators->Insert(pDec->GetID(),pDec) == 0)
		return FALSE;

	// Modulbaum aufbauen
    SiModule *pModule = PTR_CAST(SiModule,pDec);

    if (pModule != NULL)
	{
		if (pModule->GetParent() == NULL)
		{
			if (m_pRootModule == NULL)
			{
				m_pRootModule = pModule;
			}
			else
				pCompiler->SymanticError("root module already defined");
		}
		else
			pModule->GetParent()->Add(pModule); // Parent -> Child
		return TRUE;
	}

	// Unix-HardLinks an Datei haengen
	//
    SiShortcut* pSCut = PTR_CAST(SiShortcut,pDec);

    if( pSCut != NULL )
	{
		SiShortcut* p = pSCut;
		while( p && !p->GetFile() )
			p = pSCut->GetShortcut();
		if( !p && m_bSecondLevel )
		{
			fprintf( stderr, "\nerror: shortcut without valid target (%s)\n\n", pSCut->GetID().GetBuffer() );
			exit(-1);
		}

		p->GetFile()->AddShortcut( pSCut, pSCut!=p? TRUE : FALSE );
		return TRUE;
	}

	SiFile *pFile = PTR_CAST(SiFile,pDec);

	if (pFile != NULL)					// Datei ?
	{
		if (pFile->GetPartOf() != NULL)	// Teil  ?
		{
			// Dateiteil an Vater haengen
			//
			pFile->GetPartOf()->AddPart(pFile);

			// Damit es nicht durch AddUnlinkedFilesToRoot
			// erwischt wird.
			//
			pFile->AddRefCount();
		}
		else
		{
			// Spezielle Datei
			//
			if( pFile->IsSetup() )
			{
				if( m_pSetup != NULL )
					pCompiler->Warning("SETUP already used");
				else
					m_pSetup = pFile;
			}
		}

		return TRUE;
	}

	SiInstallation *pInst = PTR_CAST(SiInstallation,pDec);

	if (pInst != NULL)
	{
		if (m_pInstallation != NULL)
		{
			pCompiler->SymanticError("installation object already defined");
			return FALSE;
		}

		m_pInstallation = pInst;
	}

	// Verzeichnisse in einer separaten Liste
	// aufbewaren, damit auch nicht referenzierte Verzeichnisse
	// (Kein Dateiverweis) erzeugt werden koennen.
	SiDirectory *pDir = PTR_CAST(SiDirectory,pDec);
	if (pDir != NULL)
	{
		// Baum aufbauen und Wurzeln merken
		if (pDir->GetParent() != NULL)
			pDir->GetParent()->Add(pDir);
		else
			m_Directories.Insert(pDir,LIST_APPEND);
	}

	SiProfile *pProfile = PTR_CAST(SiProfile,pDec);
	if (pProfile != NULL)
	{
		// fuer OnlineReg.
		ByteString aName( pProfile->GetName() );
		if( aName.CompareIgnoreCaseToAscii(OREG_INI) == COMPARE_EQUAL )
			m_pORegINI = pProfile;
		if( aName.CompareIgnoreCaseToAscii(SOFFICE_INI) == COMPARE_EQUAL )
			m_pOfficeINI = pProfile;
		else if( pProfile->IsServerINI() )
			m_pServerINI = pProfile;
	}

	// SiProfileItem
	SiProfileItem *pItem = PTR_CAST(SiProfileItem,pDec);
	if (pItem != NULL)
	{
		if (pItem->IsInstallInfo())
		{
			if (m_pInstallInfo != NULL)
			{
				pCompiler->SymanticError("INSTALL_INFO already used");
				return FALSE;
			}
			m_pInstallInfo = pItem;
		}
	}

	// Slide Objecte
	SiSlide *pSlide = PTR_CAST(SiSlide,pDec);
	if (pSlide != NULL)
	{
		USHORT i = (USHORT)m_Slides.Count();
		while( i > 0 &&  m_Slides.GetObject(i-1)->GetOrder() >
			   pSlide->GetOrder() )
			i--;
		m_Slides.Insert(pSlide,i);
		return TRUE;
	}

	// SiHelpText Objecte
	SiHelpText* pHelpText = PTR_CAST( SiHelpText, pDec );
	if( pHelpText != NULL )
	{
		m_HelpTextLst.Insert( pHelpText, LIST_APPEND );
		return TRUE;
	}

	// SiScpAction Objecte
	SiScpAction* pScpAction = PTR_CAST( SiScpAction, pDec );
	if( pScpAction != NULL )
	{
		m_ScpActionLst.Insert( pScpAction, LIST_APPEND );
		return TRUE;
	}

	// Insert SiModuleIds objects into our module id list
	SiModuleIds* pModuleIds = PTR_CAST( SiModuleIds, pDec );
	if( pModuleIds != NULL )
	{
		m_ModIdsLst.Insert( pModuleIds, LIST_APPEND );
		return TRUE;
	}

	// Insert SiModulesSet objects into our modules set list
	SiModulesSet* pModulesSet = PTR_CAST( SiModulesSet, pDec );
	if( pModulesSet != NULL )
	{
		m_ModSetLst.Insert( pModulesSet, LIST_APPEND );
		return TRUE;
	}

	return TRUE;
}

void SiCompiledScript::AddUnlinkedObjectsToRoot()
{
	if( m_pRootModule == NULL || !m_bBindUnlinked )
		return;

	DeclaratorSetIt  Iterator(*m_pDeclarators);

	for( SiDeclarator* pDeclarator = Iterator.GetFirst();
		 pDeclarator != NULL; pDeclarator  = Iterator.GetNext() )
	{
		SiCompiler* pCompiler = pDeclarator->GetCompiler();
		SiFile *pFile = PTR_CAST(SiFile,pDeclarator);

		if( pFile != NULL && pFile->GetRefCount() == 0 )
		{
			if( m_bSecondLevel && m_bBindUnlinkedWarning )
				fprintf( stdout, "warning: %s bind unlinked file to rootmodule.\n", pDeclarator->GetID().GetBuffer() );

			m_pRootModule->Add(pFile);
			continue;
		}

		SiDirectory *pDir = PTR_CAST(SiDirectory,pDeclarator);
		if( pDir != NULL && !pDir->IsSystemObject() ) // && pDir->GetRefCount() == 0 && pDir->DoCreate() )
		{
			if( m_bSecondLevel && m_bBindUnlinkedWarning )
				fprintf( stdout, "warning: bind unlinked directory (%s) to root.\n", pDeclarator->GetID().GetBuffer() );

			m_pRootModule->Add(pDir);
			continue;
		}

		SiProcedure *pProc = PTR_CAST(SiProcedure,pDeclarator);
		if( pProc != NULL )
		{
			if( m_bSecondLevel && m_bBindUnlinkedWarning )
				fprintf( stdout, "warning: bind unlinked procedure (%s) to root.\n", pDeclarator->GetID().GetBuffer() );

			if ( ! pProc->GetRefCount() )
			    m_pRootModule->Add( pProc );
			continue;
		}

        SiRegistryItem *pReg = PTR_CAST(SiRegistryItem,pDeclarator);
		if( pReg != NULL )
		{
			if( m_bSecondLevel && m_bBindUnlinkedWarning )
				fprintf( stdout, "warning: bind unlinked registryitem (%s) to root.\n", pDeclarator->GetID().GetBuffer() );

#ifdef WNT
			if ( !pReg->GetRefCount() )
			    m_pRootModule->Add( pReg );
#endif
			continue;
		}
	}
}

void SiCompiledScript::CreateNameSpace(ByteString const& rPrefix)
// pre:  -
// post: 1. Alle Keys UND Objektids in m_pDeclarators haben den rPrefix
//		 2. m_pDeclarators wurde entsprechend neu aufgebaut
{
	DeclaratorSet   *pOld = m_pDeclarators;
	DeclaratorSetIt  Iterator(*pOld); // ueber die alten Daten iterieren

	m_pDeclarators = new DeclaratorSet(pOld->GetSize());

	for (SiDeclarator
		*pDeclarator  = Iterator.GetFirst()
	  ;  pDeclarator != NULL
	  ;  pDeclarator  = Iterator.GetNext())
	{
		// Objekte umbenennen:
		// (PREDEFINED_xxx - Objekte natuerlich nicht aendern)
		//
		if (!pDeclarator->IsSystemObject())
		{
			ByteString anID  = rPrefix;
				   anID += pDeclarator->GetID();

			pDeclarator->SetID(anID);
		}

		// unter neuem Key eintragen
		m_pDeclarators->Insert(pDeclarator->GetID(),pDeclarator);
	}

	delete pOld; // Dictionary mit alten Keys wegwerfen
}

void SiCompiledScript::Join
(
	SiModule		   * pModule,
	DeclaratorSet const& rDict
)
// Modulbaum traversieren:
// Fuer jede Referenz die natuerliche Identitaet berechnen
// und im Dictionary nachschlagen. Wenn vorhanden muss die
// Referenz umgesetzt werden.
//
// pre:  rDict enthaelt die Assoziation NatID -> Upgradeobjekt
// post: alle Objekte dieses Scripts, die im Dictionary vorhanden
//       sind wurden wie folgt beghandelt:
//			a: 1-n Referenzen wurden entfernt
//			b: m-n Referenzen zeigen auf das Upgradeobjekt
{
	if( !pModule )
		return;

	ULONG i=0;

    SiFileList const& aFileList = pModule->GetFileList();

	// Wenn eine Datei im Upgradescript enthalten ist,
	// dann muss der Zeiger umgesetzt werden.
	//
	for (i=aFileList.Count(); i>0; i--)
	{
		ByteString aNatID = aFileList.GetObject(i-1)->GetNaturalID();
		SiFile *pFile = (SiFile*)rDict.Find(aNatID);

		if (pFile != NULL)
		{
			pModule->Remove(aFileList.GetObject(i-1));
			pModule->Add(pFile);
		}
	}

    SiProfileList const& aProfileList = pModule->GetProfileList();

	for (i=aProfileList.Count(); i>0; i--)
	{
		ByteString	   aNatID   = aProfileList.GetObject(i-1)->GetNaturalID();
		SiProfile *pProfile = (SiProfile*)rDict.Find(aNatID);

		if (pProfile != NULL)
		{
			// Referenz entfernen, weil Profile
			// schon an ein Module des Upgradescripts gebunden
			// sein koennte.
			// Wenn es keinem Modul zugeordnet ist, muss es natuerlich
			// auch entfernt werden.
			//
			pModule->Remove(aProfileList.GetObject(i-1));
		}
	}

    SiProfileItemList const& aPItemList = pModule->GetProfileItemList();

	for (i=aPItemList.Count(); i>0; i--)
	{
		ByteString		   aNatID = aPItemList.GetObject(i-1)->GetNaturalID();
		SiProfileItem *pItem  = (SiProfileItem*)rDict.Find(aNatID);

		// Zur Auslieferung SO4 W16 war leider das INSTALL_INFO Flag an einem
		// falschen ProfileItem gesetzt. Das fuehrte beim Join mit dem ServiceCD
		// oder Channel SP2 Updatescript zu einem doppeltem Identifer der in dem
		// Fall INSTALL_INFO GPF'te. Deshalb folgender HACK:
		SiProfileItem *pThisItem  = (SiProfileItem*)aPItemList.GetObject(i-1);
		if( pThisItem && pThisItem->IsInstallInfo() &&
			pThisItem->GetSection().CompareIgnoreCaseToAscii( "versions" ) != COMPARE_EQUAL )
			pThisItem->SetInstallInfo(FALSE);

		if (pItem != NULL)
		{
			// Referenz entfernen, weil ProfileItem schon an ein Module des
			// Upgradescripts gebunden ist.
			pModule->Remove(aPItemList.GetObject(i-1));
		}
	}

	// ---
	//
    SiFolderItemList const& aFItemList = pModule->GetFolderItemList();

	for (i=aPItemList.Count(); i>0; i--)
	{
		if (rDict.Find(aPItemList.GetObject(i-1)->GetNaturalID()) != NULL)
			pModule->Remove(aPItemList.GetObject(i-1));
	}

	// ---
	//
    SiRegistryItemList const& aRItemList = pModule->GetRegistryItemList();

	for (i=aRItemList.Count(); i>0; i--)
	{
		if (rDict.Find(aRItemList.GetObject(i-1)->GetNaturalID()) != NULL)
			pModule->Remove(aRItemList.GetObject(i-1));
	}


	// ---
	//
    SiRegistryAreaList const& aRAreaList = pModule->GetRegistryAreaList();

	for (i=aRAreaList.Count(); i>0; i--)
	{
		if (rDict.Find(aRAreaList.GetObject(i-1)->GetNaturalID()) != NULL)
			pModule->Remove(aRAreaList.GetObject(i-1));
	}

	// ---
	//
    SiOs2ClassList const& aClassList = pModule->GetOs2ClassList();

	for (i=aClassList.Count(); i>0; i--)
	{
		if (rDict.Find(aClassList.GetObject(i-1)->GetNaturalID()) != NULL)
			pModule->Remove(aClassList.GetObject(i-1));
	}

	// ---
	//
    SiOs2TemplateList const& aTemplateList = pModule->GetOs2TemplateList();

	for (i=aTemplateList.Count(); i>0; i--)
	{
		if (rDict.Find(aTemplateList.GetObject(i-1)->GetNaturalID()) != NULL)
			pModule->Remove(aTemplateList.GetObject(i-1));
	}

	// Rekursiv runter
	//
    SiModuleList const& aModuleList = *pModule->GetModuleList();

	for (i=0; i<aModuleList.Count(); i++)
	{
		Join(aModuleList.GetObject(i), rDict);
	}
}

void SiCompiledScript::Join(SiCompiledScript *pOther)
{
	CreateNameSpace("NS_");

	// pOther kopieren ?

	// Dict mit den natuerlichen Identitaeten des UpdateScriptes aufbauen
	//
	DeclaratorSet	 aDict(pOther->m_pDeclarators->GetSize());
	DeclaratorSetIt  anIterator(*pOther->m_pDeclarators);

	for (SiDeclarator
		*pDeclarator  = anIterator.GetFirst()
	  ;  pDeclarator != NULL
	  ;  pDeclarator  = anIterator.GetNext())
	{
		aDict.Insert(pDeclarator->GetNaturalID(),pDeclarator);
	}

	Join(GetRootModule(),aDict);

	// Scripte zusammenklinken
	//
	GetRootModule()->Add(pOther->GetRootModule());
	pOther->GetRootModule()->SetParent(GetRootModule());
	pOther->GetRootModule()->SetHidden();
}

void SiCompiledScript::PrepareForLocalInstallation()
{
	PrepareForLocalInstallation(GetRootModule());
}

BOOL SiCompiledScript::PrepareForLocalInstallation(SiModule *pModule)
{
	for( ULONG i = pModule->GetModuleList()->Count(); i > 0; i-- )
	{
		SiModule *pChild = pModule->GetModuleList()->GetObject(i-1);
		if (PrepareForLocalInstallation(pChild))
			pModule->Remove(pChild);
	}

	if (pModule->GetModuleList()->Count() == 0)
	{
		BOOL bInstalled = pModule->IsInstalled();
		pModule->SetInstalled(FALSE);

		return !bInstalled;
	}
	else
	{
		pModule->SetInstalled(FALSE);
		return FALSE;
	}
	return FALSE;
}


SiFile* _GetCompiledHelp( SiModule* pMod )
{
	for( USHORT ii = 0; ii < pMod->GetFileList().Count(); ++ii )
	{
		SiFile* pFile = pMod->GetFileList().GetObject(ii);
		if( pFile->GetID().CompareIgnoreCaseToAscii("COMP_HELP_ID") == COMPARE_EQUAL )
			return pFile;
	}
	SiFile* pReturn = NULL;
	for( USHORT i = 0; i < pMod->GetModuleList()->Count(); ++i )
	{
		pReturn = _GetCompiledHelp( pMod->GetModuleList()->GetObject(i) );
		if( pReturn ) break;
	}
	return pReturn;
}


void SiCompiledScript::SetCompiledHelp( const SiFile* pFile, const ByteString& rFileName )
{
	SiFile* pHelpFile = _GetCompiledHelp( m_pRootModule );
	if( !pHelpFile )
	{
		m_pCompiledHelp = new SiFile(SiIdentifier("COMP_HELP_ID"), pFile->GetCompiler() );
		m_pCompiledHelp->SetProperty( PROPERTY_CARRIER, (SiDeclarator*)pFile->GetDataCarrier());
		m_pCompiledHelp->SetProperty( PROPERTY_FLAGS, VALUE_COMP_BY_SETUP );
		m_pCompiledHelp->SetProperty( PROPERTY_NAME, rFileName );
		pHelpFile = m_pCompiledHelp;
		m_pRootModule->Add( m_pCompiledHelp );
	}
	SiFile* pLangRef = (SiFile*) pHelpFile->GetInternalLangRef( pFile->GetLanguage() );
	if( pLangRef )
		pLangRef->SetProperty( PROPERTY_DIR, (SiDeclarator*)pFile->GetDirectory() );
	else
		pHelpFile->SetProperty( PROPERTY_DIR, (SiDeclarator*)pFile->GetDirectory() );
}

ByteString SiCompiledScript::GetSetupExePath(const SiEnvironment& rEnv)
{
#if defined(OS2) || defined(WNT) || defined(WIN)
	ByteString aSetupEXE( "setup.exe" );
#elif defined(MAC)
	ByteString aSetupEXE( "setup" );
#elif defined(UNX)
	ByteString aSetupEXE( "setup.bin" );
#else
#error	Wie nennt ihr das Setupbinary?
#endif

	SiDirEntry aLocation( rEnv.GetDestPath() );

	for( USHORT i=0; i < m_pRootModule->GetFileList().Count(); i++ ) {
		SiFile* pFile = m_pRootModule->GetFileList().GetObject(i);
		if( pFile->GetName().CompareIgnoreCaseToAscii(aSetupEXE) == COMPARE_EQUAL )
		{
			aLocation += pFile->GetDirectory()->GetName();
			break;
		}
	}

	aLocation.ToAbs();
	return aLocation.GetFull();
}

SiHelpText* SiCompiledScript::GetHelpTextForId( USHORT nId, USHORT nLanguage )
{
	for( USHORT i = 0; i < m_HelpTextLst.Count(); ++i )
		if( m_HelpTextLst.GetObject(i)->GetPageId() == nId )
		{
			SiHelpText* pObj = (SiHelpText*)m_HelpTextLst.GetObject(i);
			SiHelpText* pLangRef = NULL;
			if( pObj->HasLangRef() )
			{
				pLangRef = (SiHelpText*)pObj->GetLangRef( nLanguage );
				if( pLangRef ) pLangRef->JoinWithParent();
			}

			return pLangRef ? pLangRef : pObj;
		}

	return NULL;
}



