/*************************************************************************
 *
 *  $RCSfile: texec.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dv $ $Date: 2001/09/07 10:52:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _TEXEC_HXX
#define _TEXEC_HXX

#ifndef _VOS_THREAD_HXX_
#include <vos/thread.hxx>
#endif

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif

#ifndef SETUP_SIMODE_HXX
#include "simode.hxx"
#endif

class SiAgenda;
class SiCompiledScript;

class ExecuterData
{
	SiCompiledScript*	m_pCScript;

	ByteString			m_aInitialSourcePath;
	SiInstallMode		m_eInstallMode;
	SiInstallSubMode 	m_eInstallSubMode;
    BOOL 				m_bIsWorkstation    : 1;
    BOOL 				m_bUpgrade          : 1;
    BOOL 				m_bNoEvent          : 1;

public:

    void SetCScript( SiCompiledScript* pNew )		{ m_pCScript = pNew; }
	SiCompiledScript* GetCScript() const  			{ return m_pCScript; }

	void SetSourcePath( const ByteString& rNew )    { m_aInitialSourcePath = rNew; }
	const ByteString& GetSourcePath() const         { return m_aInitialSourcePath; }

	void SetInstallMode( SiInstallMode eNew )		{ m_eInstallMode = eNew; }
	SiInstallMode GetInstallMode() const  			{ return m_eInstallMode; }

	void SetInstallSubMode( SiInstallSubMode eNew ) { m_eInstallSubMode = eNew; }
	SiInstallSubMode GetInstallSubMode() const 		{ return m_eInstallSubMode; }

	void SetUpgrade( BOOL bNew )					{ m_bUpgrade = bNew; }
	BOOL GetUpgrade() const   						{ return m_bUpgrade; }

	void SetNoEvent( BOOL bNew )					{ m_bNoEvent = bNew; }
	BOOL GetNoEvent() const   						{ return m_bNoEvent; }

	void SetWorkstation( BOOL bNew )	 			{ m_bIsWorkstation = bNew; }
	BOOL IsWorkstation() const   		 			{ return m_bIsWorkstation; }

};

class ThreadExecuter : public NAMESPACE_VOS(OThread)
{
    ExecuterData*   m_pData;
	SiAgenda*       m_pAgenda;
    BOOL 			m_bRun;

public:
			ThreadExecuter( SiAgenda* pAgenda );
			~ThreadExecuter();

	void SAL_CALL			run();

	void SetCScript( SiCompiledScript* pNew )		{ m_pData->SetCScript( pNew ); }
	SiCompiledScript* GetCScript() const  			{ return m_pData->GetCScript(); }

	void SetSourcePath( const ByteString& rNew )    { m_pData->SetSourcePath( rNew ); }
	const ByteString& GetSourcePath() const         { return m_pData->GetSourcePath(); }

	void SetInstallMode( SiInstallMode eNew )		{ m_pData->SetInstallMode( eNew ); }
	SiInstallMode GetInstallMode() const  			{ return m_pData->GetInstallMode(); }

	void SetInstallSubMode( SiInstallSubMode eNew ) { m_pData->SetInstallSubMode( eNew ); }
	SiInstallSubMode GetInstallSubMode() const 		{ return m_pData->GetInstallSubMode(); }

	void SetUpgrade( BOOL bNew )					{ m_pData->SetUpgrade( bNew ); }
	BOOL GetUpgrade() const   						{ return m_pData->GetUpgrade(); }

	void SetNoEvent( BOOL bNew )					{ m_pData->SetNoEvent( bNew ); }
	BOOL GetNoEvent() const   						{ return m_pData->GetNoEvent(); }

	void SetWorkstation( BOOL bNew )	 			{ m_pData->SetWorkstation( bNew ); }
	BOOL IsWorkstation() const   		 			{ return m_pData->IsWorkstation(); }

    ExecuterData*   GetData() const                 { return m_pData; }
};

#endif //_TEXEC_HXX
