/*************************************************************************
 *
 *  $RCSfile: unlight.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:46:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "chtscene.hxx"

#pragma hdrstop

#include "schdll.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include <svx/dlight3d.hxx>
#include "unlight.hxx"

TYPEINIT1(SchUndoLighting, SchUndoAction);


/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchUndoLighting::Undo()
{
	ChartScene* pScene = rDoc.GetScene();

	if (pScene)
	{
		E3dLight        *pAmbient = 0;
		E3dDistantLight *pLight   = 0;

/*        long nMax = pScene->GetLightCount();
		for (long i = 0; i < nMax; i++)
		{
			if (pScene->GetLight(i)->ISA(E3dDistantLight)) pLight = (class E3dDistantLight *) pScene->GetLight(i);
			else pAmbient = pScene->GetLight(i);
		}*/

		rDoc.LightVec ()         = aOldLight;
		rDoc.SpotIntensity ()    = fOldIntensity;
		rDoc.SetAmbientIntensity (fOldIntensity);
		if (pLight)
		{
			pLight->SetDirection(aOldLight);
			pLight->SetIntensity (fOldIntensity);
		}

		if (pAmbient) pAmbient->SetIntensity(fOldIntensity);

		pScene->SetRectsDirty();
		rDoc.BuildChart (FALSE);
		rDoc.SetChanged();
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchUndoLighting::Redo()
{
	ChartScene* pScene = rDoc.GetScene();

	if (pScene)
	{
		E3dLight        *pAmbient = 0;
		E3dDistantLight *pLight   = 0;

/*        long nMax = pScene->GetLightCount();
		for (long i = 0; i < nMax; i++)
		{
			if (pScene->GetLight(i)->ISA(E3dDistantLight)) pLight = (class E3dDistantLight *) pScene->GetLight(i);
			else pAmbient = pScene->GetLight(i);
		}
*/
		rDoc.LightVec ()         = aNewLight;
		rDoc.SpotIntensity ()    = fNewIntensity;
		rDoc.SetAmbientIntensity (fNewIntensity);
		if (pLight)
		{
			pLight->SetDirection(aNewLight);
			pLight->SetIntensity (fNewIntensity);
		}

		if (pAmbient) pAmbient->SetIntensity(fNewIntensity);

		pScene->SetRectsDirty();
		rDoc.BuildChart (FALSE);
		rDoc.SetChanged();
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

BOOL SchUndoLighting::CanRepeat(SfxRepeatTarget& rView) const
{
	return FALSE;
}



