/*************************************************************************
 *
 *  $RCSfile: objadj.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 00:29:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#include "objadj.hxx"
#include "glob.hxx"




/*************************************************************************
|*
|* Objekt-Ausrichting ermitteln
|*
\************************************************************************/

SchObjectAdjust* GetObjectAdjust(const SdrObject& rObj)
{
	for (USHORT i = 0; i < rObj.GetUserDataCount(); i++)
	{
		SdrObjUserData *pData = rObj.GetUserData(i);
		if (pData && pData->GetId() == SCH_OBJECTADJUST_ID)
			return (SchObjectAdjust*)pData;
	}

	return NULL;
}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchObjectAdjust::SchObjectAdjust() :
	SdrObjUserData(SchInventor, SCH_OBJECTADJUST_ID, 1),
	eAdjust(CHADJUST_TOP_LEFT),
	eOrient(CHTXTORIENT_STANDARD)
{
}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchObjectAdjust::SchObjectAdjust(ChartAdjust eAdj,
								 SvxChartTextOrient eOr) :
	SdrObjUserData(SchInventor, SCH_OBJECTADJUST_ID, 1),
	eAdjust(eAdj),
	eOrient(eOr)
{
}

/*************************************************************************
|*
|* Kopier-Konstruktor
|*
\************************************************************************/

SchObjectAdjust::SchObjectAdjust(const SchObjectAdjust& rObjectAdjust) :
	SdrObjUserData(rObjectAdjust),
	eAdjust(rObjectAdjust.eAdjust),
	eOrient(rObjectAdjust.eOrient)
{
}

/*************************************************************************
|*
|* Kopie erzeugen
|*
\************************************************************************/

SdrObjUserData* SchObjectAdjust::Clone(SdrObject *pObj) const
{
	return new SchObjectAdjust(*this);
}

/*************************************************************************
|*
|* Daten in Stream schreiben
|*
\************************************************************************/

void SchObjectAdjust::WriteData(SvStream& rOut)
{
	SdrObjUserData::WriteData(rOut);

	rOut << (INT16)eAdjust;
	rOut << (INT16)eOrient;
}

/*************************************************************************
|*
|* Daten aus Stream lesen
|*
\************************************************************************/

void SchObjectAdjust::ReadData(SvStream& rIn)
{
	SdrObjUserData::ReadData(rIn);

	INT16 nInt16;

	rIn >> nInt16; eAdjust = (ChartAdjust)nInt16;

	if (nVersion < 1)
		eOrient = CHTXTORIENT_STANDARD;
	else
	{
		rIn >> nInt16; eOrient = (SvxChartTextOrient)nInt16;
	}

}



