/*************************************************************************
 *
 *  $RCSfile: SchAddInCollection.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: bm $ $Date: 2002/06/27 09:08:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "SchAddInCollection.hxx"

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCONTENTENUMERATIONACCESS_HPP_
#include <com/sun/star/container/XContentEnumerationAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICENAME_HPP_
#include <com/sun/star/lang/XServiceName.hpp>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

using namespace com::sun::star;

SchAddInCollection::SchAddInCollection() :
        mbInitialized( sal_False )
{
}

SchAddInCollection::~SchAddInCollection()
{}

void SchAddInCollection::Initialize()
{
    // collect all service names of available AddIns

    try
    {
        uno::Reference< lang::XMultiServiceFactory > xFactory = ::comphelper::getProcessServiceFactory();
        uno::Reference< container::XContentEnumerationAccess > xEnumAcc( xFactory, uno::UNO_QUERY );
        if( xEnumAcc.is())
        {
            uno::Reference< container::XEnumeration > xEnum =
                xEnumAcc->createContentEnumeration( rtl::OUString::createFromAscii( "com.sun.star.chart.Diagram" ));
            if( xEnum.is())
            {
                // clear possibly existing list
                if( mbInitialized )
                    maServiceNames.realloc( 0 );

                while( xEnum->hasMoreElements())
                {
                    // create Instance to collect the service name of the addin
                    uno::Any aFactoryAny = xEnum->nextElement();
                    uno::Reference< uno::XInterface > xFactoryIntf;
                    aFactoryAny >>= xFactoryIntf;
                    if( xFactoryIntf.is())
                    {
                        uno::Reference< lang::XSingleServiceFactory > xAddInFactory( xFactoryIntf, uno::UNO_QUERY );
                        if( xAddInFactory.is())
                        {
                            uno::Reference< lang::XServiceName > xServicName(
                                xAddInFactory->createInstance(), uno::UNO_QUERY );
                            if( xServicName.is())
                            {
                                sal_Int32 nIndex = maServiceNames.getLength();
                                maServiceNames.realloc( nIndex + 1 );
                                maServiceNames[ nIndex ] = xServicName->getServiceName();
                            }
                        }
                    }
                }
            }
        }
        mbInitialized = sal_True;
    }
    catch( const uno::Exception& aEx )
    {
        OSL_ENSURE( false,
                    ::rtl::OUStringToOString(
                        ::rtl::OUString(
                            RTL_CONSTASCII_USTRINGPARAM(
                                "Couldn't initialize add-in collection: " )) +
                        aEx.Message,
                        RTL_TEXTENCODING_ASCII_US ).getStr() );
    }
}

uno::Reference< util::XRefreshable > SchAddInCollection::GetAddInByName( const rtl::OUString& rName )
{
    if( ! mbInitialized )
        Initialize();

    const sal_Int32 nSize = maServiceNames.getLength();
    for( sal_Int32 i = 0; i < nSize; i++ )
    {
        if( rName.equalsIgnoreAsciiCase( maServiceNames[ i ] ))
        {
            uno::Reference< lang::XMultiServiceFactory > xFactory = ::comphelper::getProcessServiceFactory();
            return uno::Reference< util::XRefreshable >( xFactory->createInstance( rName ), uno::UNO_QUERY );
        }
    }

    return uno::Reference< util::XRefreshable >();
}

uno::Sequence< rtl::OUString > SchAddInCollection::GetAddInNames()
{
    if( ! mbInitialized )
        Initialize();

    return maServiceNames;
}
