/*************************************************************************
 *
 *  $RCSfile: MoveFileEx.c,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: tra $ $Date: 2000/12/12 10:59:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <windows.h>
#include <MoveFile.h>
#include <CopyFile.h>
#include <DeleteFile.h>


BOOL WINAPI MoveFileExW_9x(
	LPCWSTR lpExistingFileName,	// file name
	LPCWSTR lpNewFileName,		// new file name
	DWORD	dwFlags				// move options
)
{
	BOOL	fSuccess = FALSE;	// assume failure

	// Windows 9x has a special mechanism to move files after reboot

	if ( dwFlags & MOVEFILE_DELAY_UNTIL_REBOOT )
	{
		LPSTR	lpExistingFileNameA = NULL;
		LPSTR	lpNewFileNameA = NULL;
		DWORD	nSize, dwError;


		nSize = WideCharToMultiByte( CP_ACP, 0, lpExistingFileName, -1, NULL, 0, NULL, NULL );
		lpExistingFileNameA = nSize ? HeapAlloc( GetProcessHeap(), 0, nSize * sizeof(CHAR) ) : NULL;

		if ( lpExistingFileNameA )
		{
			WideCharToMultiByte( CP_ACP, 0, lpExistingFileName, -1, lpExistingFileNameA, nSize, NULL, NULL );
			fSuccess = GetShortPathNameA( lpExistingFileNameA, lpExistingFileNameA, nSize );
		}

		if ( fSuccess )
		{
			nSize = WideCharToMultiByte( CP_ACP, 0, lpNewFileName, -1, NULL, 0, NULL, NULL );
			lpNewFileNameA = nSize ? HeapAlloc( GetProcessHeap(), 0, nSize * sizeof(CHAR) ) : NULL;

			if ( lpNewFileNameA )
			{
				WideCharToMultiByte( CP_ACP, 0, lpNewFileName, -1, lpNewFileNameA, nSize, NULL, NULL );
				fSuccess = GetShortPathNameA( lpNewFileNameA, lpNewFileNameA, nSize );
			}
		}

		fSuccess = fSuccess && WritePrivateProfileStringA( "rename", lpNewFileNameA, lpExistingFileNameA, "WININIT.INI" );

		dwError = GetLastError();

		if ( lpExistingFileNameA )
			HeapFree( GetProcessHeap(), 0, lpExistingFileNameA );

		if ( lpNewFileNameA )
			HeapFree( GetProcessHeap(), 0, lpNewFileNameA );

		SetLastError( dwError );
	}
	else
	{

		fSuccess = MoveFileW_9x( lpExistingFileName, lpNewFileName );

		if ( !fSuccess && 0 != (dwFlags & (MOVEFILE_COPY_ALLOWED | MOVEFILE_REPLACE_EXISTING)) )
		{
			BOOL	bFailIfExist = 0 == (dwFlags & MOVEFILE_REPLACE_EXISTING);

			fSuccess = CopyFileW_9x( lpExistingFileName, lpNewFileName, bFailIfExist );

			/*
			In case of successfull copy do not return FALSE if delete fails.
			Error detection is done by GetLastError()
			*/

			if ( fSuccess )
			{
				SetLastError( NO_ERROR );
				DeleteFileW_9x( lpExistingFileName );
			}
		}

	}

	return fSuccess;
}
