/*************************************************************************
 *
 *  $RCSfile: fileimpl.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2003/04/08 15:50:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _FILEIMPL_HXX_
#define _FILEIMPL_HXX_

#include <windows.h>

#ifndef _RTL_USTRING_H_
#include <rtl/ustring.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************
 osl_systemPathGetVolumeRoot
 Given a system path the function returns the volume root of it.
 E.g. given the path c:\local the function may either return 
 c:\ if 'local' is a simple file or directory or
 c:\local if 'local' is a mount point 
 The function ensures that the returned volume root has a trailing 
 backslash.
 
 @precond the path is a valid system path
 
 @param system_path
 A valid system path, this may be a local path or an UNC path
 
 @param volume_root 
 On success receives the volume root of the specified path
 
 ******************************************************************/
 
void osl_systemPathGetVolumeRoot(
    const rtl_uString* system_path,
    rtl_uString**      volume_root);

/*******************************************************************

 ******************************************************************/
 
oslFileError MapWindowsErrorToOSLError(DWORD dwError);

#define MapError( oserror )	MapWindowsErrorToOSLError( oserror )


#ifdef __cplusplus
}
#endif

#endif /* _FILE_IMPL_HXX_ */
