/*************************************************************************
 *
 *  $RCSfile: thread.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:17:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __THREAD_HXX
#define __THREAD_HXX

#ifndef __cplusplus
#error Needs C++
#endif

#include "system.h"

#ifndef _OSL_TYPES_H_
#	include <osl/types.h>
#endif

#ifndef __BASE_HXX
#include "base.hxx"
#endif

#ifndef __STACK_H
#include "stack.h"
#endif

class SALThread;
class SALThreadQueue;
class SALSemaphore;
class SALMutex;
class SALCondition;

#ifdef __cplusplus
extern "C" {
#endif

typedef sal_uInt32 oslThreadKey;

oslThreadKey SAL_CALL osl_createThreadKey(void);
void SAL_CALL osl_destroyThreadKey(oslThreadKey Key);
void* SAL_CALL osl_getThreadKeyData(oslThreadKey Key);
sal_Bool SAL_CALL osl_setThreadKeyData(oslThreadKey Key, void *pData);

#ifdef __cplusplus
}
#endif

///////////////////////////////////////////////////////////////////////////////
// class SALThread
//

// Definition einer Einsprung-Funktion fuer einen SALSALThread

typedef void * (__cdecl *SALThreadEntryFunc)(void *pParam);

// Konstanten fuer SALSALThread Priority Level

#define TPL_HIGHEST      4
#define TPL_HIGH         3
#define TPL_NORMAL       2
#define TPL_LOW          1
#define TPL_LOWEST       0
#define TPL_CONSUMER    -1    // Prioritaet fuer Consumer SALSALThread
// #define TPL_CONSUMER	TPL_NORMAL

// Konstanten fuer SALSALThread Dynamic Priority

#define TPD_HIGHEST      16
#define TPD_HIGH         8
#define TPD_NORMAL       4
#define TPD_LOW          2
#define TPD_LOWEST       1
#define TPD_CONSUMER		 TPD_LOWEST
// #define TPD_CONSUMER		 TPD_HIGH

// Konstante fuer die Standard Stackgroesse

#ifdef LOCAL
#	define DEFAULT_THREAD_STACKSIZE		4096
#	define CONSUMER_THREAD_STACKSIZE	 512
#	define MIN_THREAD_STACKSIZE			1024
#	define MAX_THREAD_STACKSIZE			8192
#else
#	define DEFAULT_THREAD_STACKSIZE	    12288
#	define CONSUMER_THREAD_STACKSIZE	 1024
#	define MIN_THREAD_STACKSIZE			 1024
#	define MAX_THREAD_STACKSIZE			32768
#endif

// class SALThread

enum STATUS
{
    STATUS_OK,
    STATUS_ERROR,
    STATUS_TIMEOUT
};

typedef union
{
    oslThreadKey key;
    void FAR *data;
} tThreadKeyHolder;

class SALThread : public SALItem
{
public:
    tThreadKeyHolder *pTlsDataKey;
    int nKeyCount;
public:
	enum TaskType {NoTaskType, WSATaskType, ProcessTaskType};

    SALThread(
           SALThreadEntryFunc func,
           void *pParam = 0,
           long nPriority = TPD_NORMAL,
           long nLevel = TPL_NORMAL,
           unsigned short nStackSize = DEFAULT_THREAD_STACKSIZE
           );
    
    virtual ~SALThread();
	virtual BOOL isValid() const {return mbValid;}

    SALThread *next() const {return (SALThread *)nextItem();}
    SALThread *prev() const {return (SALThread *)prevItem();}
    SALThreadQueue *queue() const {return (SALThreadQueue *)getQueue();}

    LONG getPriorityLevel() const {return mnPriorityLevel;}
    LONG getPriority() const {return mnPriorityBase;}
    LONG getPriorityCounter() const {return mnPriorityCounter;}

    void setPriorityLevel(LONG nPriorityLevel) {mnPriorityLevel = nPriorityLevel;}
    void setPriority(LONG nPriority) {mnPriorityBase = nPriority;}

    STATUS getStatus() const {return meStatus;}
    void setStatus(STATUS eStatus) {meStatus = eStatus;}
    
    void delay(long nMilliSeconds);
    void wakeup();
    void resume();
    void suspend();
    void kill(void * = 0);
    void *getExitParam() const;
    void join();
    BOOL schedule();
    void terminate();

    int isRunning() const {return mpSemaphore != 0;}
	int isTerminating() const {return mbTerminate;}
	
    virtual SALQueue *mutexQueue() const {return mpMutexQueue;}

    LONG    setWSAError(LONG nErrorCode) {
        LONG nOldError = mnWSAError;
        mnWSAError = nErrorCode;
        return nOldError;
    }
    LONG    getWSAError() const {return mnWSAError;}

	void registerCallback(TaskType eType, HTASK hTask);
	void unregisterCallback();

protected:
    SALThread();                        // Konstruktor fuer den MainThread

	HGLOBAL			mhStackBase;		// Speicherhandle fr den Stack
	STACK   		maStackFrame;       // Zeiger auf Stackframe
	VOID    		*mpParam;           // Zeiger auf Parameter
	LONG			mnDelay;			// Wartezeit in Millisekunden
	LONG            mnPriorityLevel;    // Level fuer blockierende Prioritaet
	LONG            mnPriorityBase;     // Wert fuer die dynamische Prioritaet
	LONG            mnPriorityCounter;  // Zaehler fuer die aktuelle dynamische Prioritaet
	STATUS          meStatus;           // Aktueller Status fuer Conditions/Semaphore
	SALQueue        *mpMutexQueue;      // Liste der Mutexe deren Owner der Thread ist
	SALSemaphore    *mpSemaphore;       // Solange das Semaphore existiert ist der Thread am Laufen
	LONG            mnWSAError;         // Thread-lokaler Fehlercode
	BOOL			mbTerminate;
	BOOL			mbValid;
	HTASK			mhTask;
	TaskType		meTaskType;

	void *allocStack(size_t size);
	void freeStack();

    friend class SALSemaphore;
    friend class SALMutex;
    friend class SALCondition;
    friend class SALScheduler;
};

///////////////////////////////////////////////////////////////////////////////
// class SALThreadQueue
//

DECLARE_QUEUE(SALReadyQueue, SALThread);

class SALThreadQueue : public SALReadyQueue
{
public:
    virtual ~SALThreadQueue();
    
protected:
    virtual SALItem *removeItem(SALItem *);
};

#endif

        

