/*************************************************************************
 *
 *  $RCSfile: sendctrl.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:32:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SFXTBXCTRL_HXX
#include <sfx2/tbxctrl.hxx>
#endif
#include <sfx2/pgpwrp.hxx>

#ifndef _SV_TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif

#include <vcl/image.hxx>

static const UINT16	PGP_UNAVAIL_FLAG = 0x8000;

// class OffSendToolBoxCtrl_Impl ------------------------------------

class OffSendToolBoxCtrl_Impl : public SfxToolBoxControl

/*	[Beschreibung]

	ToolBoxControl f"ur die MailToolBox.
	Beim Anklicken des Buttons geht ein PopupMenu auf, auf dem man ein
	von vier SendeButtons ausw"ahlen kann.
*/

{
private:
		Timer		_Timer;					// Timer zum Menue-aufklappen
		Timer		_FirstInitTimer;		// asynchrone Abfrage, ob PGP verf"ugbar ist
		ImageList	_Images;				// PGP - Images
		ImageList	_LargeImages;			// PGP - Images
		ImageList*	_pImages;				// Zeiger auf die aktuelle ImageListe
		UINT16		_nState;				// letzter von der View gesendeter State
		BOOL		_bHasPGP;				// PGP vorhanden oder nicht

static	int			_nNoPGPPolicy;			// wie vorgehen, wenn kein PGP da ist

	enum ImageID
	{
		 Image_SEND 			= PGP_NONE
		,Image_ENCRYPT			= PGP_ENCRYPT
		,Image_SIGN				= PGP_SIGN
		,Image_SIGNANDENCRYPT	= PGP_ENCRYPT_AND_SIGN
	};

	// Absenden der Aktion
	void		dispatch( USHORT nID				// ID der auszufuehrenden Aktion
						);
	void		ChangeState( BOOL bEnable, UINT16 nState 		// ein Wert aus ImageID
							);
	// Image-List - Zeiger festlegen
	void		SetImageList();

	// initialize "green arrow"-flag (dropdown)
	void		SetGreenArrowFlag();

public:
	SFX_DECL_TOOLBOX_CONTROL();

	OffSendToolBoxCtrl_Impl( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings );
	~OffSendToolBoxCtrl_Impl();

	virtual void			Click();
	virtual void			Select( BOOL bMod1 = FALSE );
	virtual void			StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState );

	DECL_LINK(          	Timeout, Timer* );
};


