/*************************************************************************
 *
 *  $RCSfile: optuno.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: vg $ $Date: 2001/09/13 10:04:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SFXSIDS_HRC
#include <sfx2/sfxsids.hrc>
#endif
#ifndef _AEITEM_HXX //autogen wg. SfxAllEnumItem
#include <svtools/aeitem.hxx>
#endif
#ifndef _SFXITEMPOOL_HXX //autogen wg. SfxItemPool
#include <svtools/itempool.hxx>
#endif
#include <osl/mutex.hxx>
#include <sfx2/app.hxx>
#include <svtools/pathoptions.hxx>
#pragma hdrstop

#include "optuno.hxx"

#define PROPERTY_UNBOUND 0

SfxItemPropertyMap aGeneralOptionsPropertyMap_Impl[] =
{
	{0,0,0,0}
};

#define ASCII_NAME( name ) name, sizeof(name)-1

#define PATHID_BEGIN	100
#define PATHID_INST		(PATHID_BEGIN + 0)
#define PATHID_PROG		(PATHID_BEGIN + 1)
#define PATHID_USER		(PATHID_BEGIN + 2)

SfxItemPropertyMap aPathSettingsMap_Impl[] =
{
    { ASCII_NAME("AddIns"), 	SvtPathOptions::PATH_ADDIN, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
    { ASCII_NAME("AutoText"), 	SvtPathOptions::PATH_AUTOTEXT, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
    { ASCII_NAME("Backup"), 	SvtPathOptions::PATH_BACKUP, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
    { ASCII_NAME("Basic"), 		SvtPathOptions::PATH_BASIC, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
    { ASCII_NAME("Bitmap"), 	SvtPathOptions::PATH_BITMAP, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
    { ASCII_NAME("Config"), 	SvtPathOptions::PATH_BITMAP, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
    { ASCII_NAME("Dictionary"), SvtPathOptions::PATH_DICTIONARY, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
    { ASCII_NAME("Filter"), 	SvtPathOptions::PATH_FILTER, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
    { ASCII_NAME("Gallery"), 	SvtPathOptions::PATH_GALLERY, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
    { ASCII_NAME("Graphics"), 	SvtPathOptions::PATH_GRAPHIC, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
    { ASCII_NAME("Help"), 		SvtPathOptions::PATH_HELP, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
    { ASCII_NAME("Modules"), 	SvtPathOptions::PATH_MODULE, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
    { ASCII_NAME("Palette"), 	SvtPathOptions::PATH_PALETTE, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
    { ASCII_NAME("Plugins"), 	SvtPathOptions::PATH_PLUGIN, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("ProgPath"), 	PATHID_PROG, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
    { ASCII_NAME("Storage"), 	SvtPathOptions::PATH_STORAGE, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
    { ASCII_NAME("Template"), 	SvtPathOptions::PATH_TEMPLATE, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
    { ASCII_NAME("UserConfig"), SvtPathOptions::PATH_USERCONFIG, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
    { ASCII_NAME("UserDictionary"), SvtPathOptions::PATH_USERDICTIONARY, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("UserPath"), 	PATHID_USER, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
    { ASCII_NAME("Work"), 		SvtPathOptions::PATH_WORK, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{0,0,0,0}
};


SfxItemPropertyMap aBrowserOptionsPropertyMap_Impl[] =
{
	{ ASCII_NAME("Applets"), SID_INET_EXE_APPLETS, &::getCppuType( static_cast<BOOL*>( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("CacheAborted"), SID_INET_CACHEABORTED, &::getCppuType( static_cast<BOOL*>( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("CacheExpired"), SID_INET_CACHEEXPIRED, &::getCppuType( static_cast<BOOL*>( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("CacheJavaScript"), SID_INET_CACHEJS, &::getCppuType( static_cast<BOOL*>( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("Cookies"), SID_INET_COOKIESHANDLE, &::getCppuType( static_cast< sal_Int16* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("DiskCache"), SID_INET_DISKCACHE, &::getCppuType( static_cast< sal_Int32* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("ExecuteStarBasic"), SID_INET_EXE_PLUGIN, &::getCppuType( static_cast< sal_Int16* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("Expiration"), SID_INET_EXPIRATION, &::getCppuType( static_cast< sal_Int16* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("ExtBrowserOn"), SID_OPT_EXTBRW_ON, &::getCppuType( static_cast<BOOL*>( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("ExtBrwOffExceptiom"), SID_OPT_EXTBRW_OFF_EXCEPTION, &::getCppuType( static_cast< ::com::sun::star::uno::Sequence< ::rtl::OUString >* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("ExtBrwOnExceptiom"), SID_OPT_EXTBRW_ON_EXCEPTION, &::getCppuType( static_cast< ::com::sun::star::uno::Sequence< ::rtl::OUString >* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("HomePage"), SID_INET_HOMEPAGE, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("JavaAccess"), SID_INET_JAVA_ACCESSTYPE, &::getCppuType( static_cast< sal_Int16* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("JavaClassPath"), SID_INET_JAVA_CLASSPATH, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("JavaEnabled"), SID_INET_JAVA_ENABLE, &::getCppuType( static_cast<BOOL*>( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("JavaScript"), SID_INET_EXE_JAVASCRIPT, &::getCppuType( static_cast<BOOL*>( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("JavaSecurity"), SID_INET_JAVA_SECURITY, &::getCppuType( static_cast<BOOL*>( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("MemoryCache"), SID_INET_MEMCACHE, &::getCppuType( static_cast< sal_Int16* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("NonCachedServer"), SID_INET_NONCACHED_SERVER, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("Plugins"), SID_INET_EXE_PLUGIN, &::getCppuType( static_cast<BOOL*>( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("SecureURLs"), SID_SECURE_URL, &::getCppuType( static_cast< ::com::sun::star::uno::Sequence< ::rtl::OUString >* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("UserAgent"), SID_INET_USERAGENT, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{0,0,0,0}
};

SfxItemPropertyMap aINetOptionsPropertyMap_Impl[] =
{
	{ ASCII_NAME("Channels"), SID_INET_CHANNELS_ONOFF, &::getCppuType( static_cast<BOOL*>( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("DNSAuto"), SID_INET_DNS_AUTO, &::getCppuType( static_cast<BOOL*>( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("DNSServer"), SID_INET_DNS_SERVER, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("FTPProxyName"), SID_INET_FTP_PROXY_NAME, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("FTPProxyPort"), SID_INET_FTP_PROXY_PORT, &::getCppuType( static_cast< sal_Int32* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("HTTPProxyName"), SID_INET_HTTP_PROXY_NAME, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("HTTPProxyPort"), SID_INET_HTTP_PROXY_PORT, &::getCppuType( static_cast< sal_Int32* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("MailPassWord"), SID_INET_MAILPASSWORD, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("MailTextFormat"), SID_INET_MAILTEXTFORMAT, &::getCppuType( static_cast<BYTE*>( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("MailUserName"), SID_INET_MAILUSERNAME, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("MaxFTPConnections"), SID_INET_MAXFTPCONS, &::getCppuType( static_cast< sal_Int16* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("MaxHTTPConnections"), SID_INET_MAXHTTPCONS, &::getCppuType( static_cast< sal_Int16* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("MaxNews"), SID_INET_MAXNEWS, &::getCppuType( static_cast< sal_Int16* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("NNTPServer"), SID_INET_NNTPSERVER, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("NoProxy"), SID_INET_NOPROXY, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("POPServer"), SID_INET_POPSERVER, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("ProxyType"), SID_INET_PROXY_TYPE, &::getCppuType( static_cast< sal_Int16* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("RevealMailAddress"), SID_INET_REVEAL_MAILADDR, &::getCppuType( static_cast<BOOL*>( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("SMTPGateway"), SID_INET_SMTPGATEWAY, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("SMTPServer"), SID_INET_SMTPSERVER, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("SecurityProxyName"), SID_INET_SECURITY_PROXY_NAME, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("SecurityProxyPort"), SID_INET_SECURITY_PROXY_PORT, &::getCppuType( static_cast< sal_Int32* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("SocksProxyName"), SID_INET_SOCKS_PROXY_NAME, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("SocksProxyPort"), SID_INET_SOCKS_PROXY_PORT, &::getCppuType( static_cast< sal_Int32* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{ ASCII_NAME("UserAgent"), SID_INET_USERAGENT, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
//    { "EmailName", SID_INET_EMAIL_NAME, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
//    { "Proxy", SID_INET_PROXY, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
//    { "ProxyName", SID_INET_PROXY_NAME, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
//    { "ProxyPort", SID_INET_PROXY_PORT, &::getCppuType( static_cast< ::rtl::OUString* >( NULL ) ), PROPERTY_UNBOUND, 0 },
	{0,0,0,0}
};

//SFX_IMPL_UNO_SERVICE( SfxSettingsContainer );
//SFX_IMPL_UNO_ONEINSTANCEFACTORY( SfxSettingsContainer );
SFX_IMPL_XSERVICEINFO(SfxSettingsContainer, "com.sun.star.frame.Settings", "stardiv.offmgr.SettingsContainer")
SFX_IMPL_ONEINSTANCEFACTORY(SfxSettingsContainer)

//::com::sun::star::uno::Reference< ::com::sun::star::reflection::XIdlClass >  SfxSettingsContainer::getStaticIdlClass()
//{
//	// Global Method, must be guarded (multithreading)
//	MutexGuard aGuard( Mutex::getGlobalMutex() );
//	{
//		// use the standard class implementation of the usr library
//		static ::com::sun::star::uno::Reference< ::com::sun::star::reflection::XIdlClass >  xClass =
//		createStandardClass(
//			getImplementationName_Static(),
//			OWeakObject::getStaticIdlClass(),
//			2/*Anzahl Interfaces*/,
//			::getCppuType((const ::com::sun::star::container::XNameAccess*)0),
//			::getCppuType((const ::com::sun::star::lang::XServiceInfo*)0) );
//
//		return xClass;
//	}
//}

SfxSettingsContainer::SfxSettingsContainer(const UNOREFERENCE< UNOXMULTISERVICEFACTORY >& /* not interested in */)
{
	xINetSettings = new SfxSettings( aINetOptionsPropertyMap_Impl );
	xBrowserSettings = new SfxSettings( aBrowserOptionsPropertyMap_Impl );
	xGeneralSettings = new SfxSettings( aGeneralOptionsPropertyMap_Impl );
	xPathSettings = new SfxPathSettings( aPathSettingsMap_Impl );
}

::com::sun::star::uno::Type SAL_CALL SfxSettingsContainer::getElementType(  ) throw(::com::sun::star::uno::RuntimeException)
{
	return ::getCppuType( static_cast< UNOREFERENCE< ::com::sun::star::beans::XPropertySet >* >(NULL) );
}

sal_Bool SAL_CALL SfxSettingsContainer::hasElements() throw( ::com::sun::star::uno::RuntimeException )
{
	return sal_True;
}

::com::sun::star::uno::Any SAL_CALL SfxSettingsContainer::getByName(const ::rtl::OUString& Name) throw( ::com::sun::star::container::NoSuchElementException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException )
{
	::com::sun::star::uno::Any aAny;
	if ( Name.compareToAscii("INetSettings") == 0 )
		aAny <<= xINetSettings;
	else if ( Name.compareToAscii("BrowserSettings") == 0 )
		aAny <<= xBrowserSettings;
	else if ( Name.compareToAscii("GeneralSettings") == 0 )
		aAny <<= xGeneralSettings;
	else if ( Name.compareToAscii("PathSettings") == 0 )
		aAny <<= xPathSettings;
	return aAny;
}

::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL SfxSettingsContainer::getElementNames() throw( ::com::sun::star::uno::RuntimeException )
{
	::com::sun::star::uno::Sequence< ::rtl::OUString > names(4);
	names.getArray()[0] = ::rtl::OUString::createFromAscii("INetSettings");
	names.getArray()[1] = ::rtl::OUString::createFromAscii("BrowserSettings");
	names.getArray()[2] = ::rtl::OUString::createFromAscii("GeneralSettings");
	names.getArray()[3] = ::rtl::OUString::createFromAscii("PathSettings");
	return names;
}

sal_Bool SAL_CALL SfxSettingsContainer::hasByName(const ::rtl::OUString& Name) throw( ::com::sun::star::uno::RuntimeException )
{
	if	(	(Name.compareToAscii("INetSettings") == 0)
		||	(Name.compareToAscii("BrowserSettings") == 0)
		||	(Name.compareToAscii("GeneralSettings") == 0)
		)
		return sal_True;
	else
		return sal_False;
}

//-----------------------------------------------------------------------------
//::com::sun::star::uno::Reference< ::com::sun::star::reflection::XIdlClass >  SAL_CALL SfxSettings::getStaticIdlClass()
//{
//	// Global Method, must be guarded (multithreading)
//	MutexGuard aGuard( Mutex::getGlobalMutex() );
//	{
//		// use the standard class implementation of the usr library
//		static ::com::sun::star::uno::Reference< ::com::sun::star::reflection::XIdlClass >  xClass =
//		createStandardClass(
//			L"stardiv.offmgr.Setting",
//			OWeakObject::getStaticIdlClass(),
//			2/*Anzahl Interfaces*/,
//			::getCppuType((const ::com::sun::star::beans::XPropertySet*)0),
//			::getCppuType((const ::com::sun::star::beans::XFastPropertySet*)0) );
//
//		return xClass;
//	}
//}

//-----------------------------------------------------------------------------

SfxSettings::SfxSettings( const SfxItemPropertySet& rSet )
	: _aPropSet( rSet )
{
}

//-----------------------------------------------------------------------------

::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySetInfo >  SAL_CALL SfxSettings::getPropertySetInfo() throw ( ::com::sun::star::uno::RuntimeException)
{
	return _aPropSet.getPropertySetInfo();
}

//-----------------------------------------------------------------------------

void SAL_CALL SfxSettings::setPropertyValue(const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Any& aValue) throw ( ::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::beans::PropertyVetoException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException)
{
	const SfxItemPropertyMap* pMap = SfxItemPropertyMap::GetByName( _aPropSet.getPropertyMap(),
			aPropertyName );
	if ( pMap )
		setFastPropertyValue( pMap->nWID, aValue );
}

//-----------------------------------------------------------------------------

::com::sun::star::uno::Any SfxSettings::getPropertyValue(const ::rtl::OUString& aPropertyName) throw ( ::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException)
{
	const SfxItemPropertyMap* pMap = SfxItemPropertyMap::GetByName( _aPropSet.getPropertyMap(),
		aPropertyName );
	if ( pMap )
		return getFastPropertyValue( pMap->nWID );
	else
		return ::com::sun::star::uno::Any();
}

//-----------------------------------------------------------------------------

void SfxSettings::addPropertyChangeListener(const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertyChangeListener >& aListener) throw ( ::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException)
{}

//-----------------------------------------------------------------------------

void SfxSettings::removePropertyChangeListener(const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertyChangeListener >& aListener) throw ( ::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException)
{}

//-----------------------------------------------------------------------------

void SfxSettings::addVetoableChangeListener(const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XVetoableChangeListener >& aListener) throw ( ::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException)
{}

//-----------------------------------------------------------------------------

void SfxSettings::removeVetoableChangeListener(const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XVetoableChangeListener >& aListener) throw ( ::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star ::uno::RuntimeException)
{}

//-----------------------------------------------------------------------------

void SfxSettings::setFastPropertyValue(sal_Int32 nHandle, const ::com::sun::star::uno::Any& aValue) throw ( ::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::beans::PropertyVetoException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException)
{
	SfxApplication *pApp = SFX_APP();
	SfxItemSet aSet( pApp->GetPool(), (sal_uInt16) nHandle, (sal_uInt16) nHandle, 0L );
	pApp->GetOptions( aSet );

	const SfxPoolItem* pItem=0;
	SfxItemState eState = aSet.GetItemState( (sal_uInt16) nHandle, sal_True, &pItem );
	if ( eState == SFX_ITEM_SET )
	{
		SfxPoolItem* pNew = pItem->Clone();
		pNew->PutValue( aValue );
		aSet.Put( *pNew );
		SFX_APP()->SetOptions( aSet );
	}
	else
		DBG_ASSERT( eState != SFX_ITEM_AVAILABLE, "::com::sun::star::beans::Property nicht gesetzt!" );
}

//-----------------------------------------------------------------------------

::com::sun::star::uno::Any SfxSettings::getFastPropertyValue(sal_Int32 nHandle) throw ( ::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException)
{
	SfxApplication *pApp = SFX_APP();
	SfxItemSet aSet( pApp->GetPool(), (sal_uInt16) nHandle, (sal_uInt16) nHandle, 0L );
	pApp->GetOptions( aSet );
	::com::sun::star::uno::Any aValue;
	const SfxPoolItem* pItem=0;
	SfxItemState eState = aSet.GetItemState( (sal_uInt16) nHandle, sal_True, &pItem );
	if ( eState == SFX_ITEM_SET )
	{
		pItem->QueryValue( aValue );
	}
	else
	{
		DBG_ASSERT( eState != SFX_ITEM_AVAILABLE, "::com::sun::star::beans::Property nicht gesetzt!" );
		aValue <<= ::rtl::OUString();
	}

	return aValue;
}

SfxPathSettings::SfxPathSettings( const SfxItemPropertySet& rSet )
	: SfxSettings( rSet )
{
}

::com::sun::star::uno::Any SfxPathSettings::getFastPropertyValue( sal_Int32 nHandle ) throw ( ::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException)
{
	::com::sun::star::uno::Any aValue;
	String aValueStr;
	SvtPathOptions aPathOpt;

	if ( nHandle < PATHID_BEGIN )
	{
		SfxApplication *pApp = SFX_APP();
		sal_uInt16 nWhich = pApp->GetPool().GetWhich(SID_ATTR_PATHNAME);
		SfxItemSet aSet( pApp->GetPool(), nWhich, nWhich, 0L );
		pApp->GetOptions( aSet );
		SfxItemState eItemState = SFX_ITEM_UNKNOWN;
		const SfxAllEnumItem* pGrpItem = NULL;
		eItemState = aSet.GetItemState( nWhich, sal_False, (const SfxPoolItem**)&pGrpItem );
		if ( eItemState == SFX_ITEM_SET )
			aValueStr = aPathOpt.SubstituteVariable( pGrpItem->GetValueTextByPos( (USHORT)nHandle ) );
	}
	else
	{
		String aPath;
		if ( PATHID_INST == nHandle )
			aPath = String( DEFINE_CONST_UNICODE( "$(inst)" ) );
		else if ( PATHID_PROG == nHandle )
			aPath = String( DEFINE_CONST_UNICODE( "$(prog)" ) );
		else if ( PATHID_USER == nHandle )
			aPath = String( DEFINE_CONST_UNICODE( "$(userpath)" ) );
		if ( aPath.Len() > 0 )
			aValueStr = aPathOpt.SubstituteVariable( aPath );
	}

	if ( aValueStr.Len() > 0 )
		aValue <<= ::rtl::OUString( aValueStr );

	return aValue;
}

void SfxPathSettings::setFastPropertyValue( sal_Int32 nHandle, const ::com::sun::star::uno::Any& aValue ) throw ( ::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::beans::PropertyVetoException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException)
{
	if ( nHandle < PATHID_BEGIN )
	{
		SfxApplication* pApp = SFX_APP();
		sal_uInt16 nWhich = pApp->GetPool().GetWhich( SID_ATTR_PATHNAME );
		SfxItemSet aSet( pApp->GetPool(), nWhich, nWhich, 0L );
		pApp->GetOptions( aSet );
		const SfxPoolItem* pItem = NULL;
		SfxItemState eState = aSet.GetItemState( nWhich, sal_True, &pItem );
		if ( eState == SFX_ITEM_SET )
		{
			SfxAllEnumItem * pNew = PTR_CAST( SfxAllEnumItem, pItem->Clone() );
			::rtl::OUString sValue;
			aValue >>= sValue;
			pNew->InsertValue( (USHORT)nHandle, sValue );
			// We do not use the enum value here, but we have to set the enum value
			// because otherwise the old and new item are equal.
			pNew->SetValue( (USHORT)nHandle );
			aSet.Put( *pNew );
			SFX_APP()->SetOptions( aSet );
		}
		else
			DBG_ASSERT( eState != SFX_ITEM_AVAILABLE, "::com::sun::star::beans::Property nicht gesetzt!" );
	}
}


